      SUBROUTINE TVBLWH (IC, ICOLOR, BUFFER, IERR)
C-----------------------------------------------------------------------
C! various interactive black and white OFM manipulations
C# TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Inputs:
C      IC       I      Bit mask of desired TV channels
C      ICOLOR   I      Bit mask of desired color(s)
C   Output:
C      BUFFER   R(*)   scratch * >= TVMOFM
C      IERR     I      error code
C-----------------------------------------------------------------------
      INTEGER   IC, icolor, BUFFER(*), IERR
C
      INTEGER  IBUT, QUAD, ITW(3), IMLEVS, ISZX, ISZY, NC, NP, LC, I,
     *   JJ, I0, NLEVS
      REAL      RPOS(2), PPOS(2), PGAMMA, PHUE, GAMINV, V, HSTEP, H
      LOGICAL   F, DOIT
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA F /.FALSE./
C-----------------------------------------------------------------------
C                                        general parameters
      QUAD = -1
      NLEVS = MAXINT + 1
      RPOS(1) = 0.0
      RPOS(2) = 0.0
      IMLEVS = MAX (LUTOUT+1, NLEVS)
      IF (IMLEVS.GT.OFMINP+1) IMLEVS = OFMINP + 1
      CALL ZTIME (ITW)
C                                        TVBW
C                                        Button A: step wedges
C                                        Button B: Loops in B/W
C                                        Button C: B/W contours
      MSGTXT = 'Hit button A for B/W wedges'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button B for loops in B/W'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button C for B/W contours'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button D to exit'
      CALL MSGWRT (1)
      PPOS(1) = 0.0
      PPOS(2) = 0.0
      ISZX = WINDTV(3) - WINDTV(1) + 1
      ISZY = WINDTV(4) - WINDTV(2) + 1
C                                        continuous RGB triangles
 20   MSGTXT = 'Cursor X position controls number of wedges'
      CALL MSGWRT (1)
      MSGTXT = 'Cursor Y position controls intensity (Gamma)'
      CALL MSGWRT (1)
C                                        init vals, on cursor
      RPOS(1) = ISZX / 20.0 + WINDTV(1) - 1
      RPOS(2) = ISZY * 0.6 + WINDTV(2) - 1
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
C                                        read until moves
 30   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.GT.0) THEN
            CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            ISZX = WINDTV(3) - WINDTV(1) + 1
            ISZY = WINDTV(4) - WINDTV(2) + 1
            END IF
         IF (IBUT.EQ.2) GO TO 40
         IF (IBUT.EQ.4) GO TO 60
         CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        new color
         IF (DOIT) THEN
            PGAMMA = 2.5 * (RPOS(2)+13-WINDTV(2)) / ISZY
            GAMINV = PGAMMA
            IF (GAMINV.LE.0.0) GAMINV = 1.0
            GAMINV = 1.0/GAMINV
            NC = 15.0 * (RPOS(1) - WINDTV(1) + 1.) / ISZX + 1.0
            NC = MAX (1, MIN (16, NC))
            NP = FLOAT (NLEVS) / FLOAT (NC) + 0.5
            DO 35 LC = 1,NC
               I0 = (LC - 1) * NP
               DO 34 I = 1,NP
                  V = (FLOAT(I-1) / FLOAT(NP-1)) ** GAMINV
                  BUFFER(I0+I) = LUTOUT * V + 0.5
 34               CONTINUE
 35            CONTINUE
            CALL YLUT ('WRIT', IC, ICOLOR, F, BUFFER, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 30
C                                        loops in hue
 40   MSGTXT = 'Cursor X position controls starting intensity, ' //
     *      'number of loops'
      CALL MSGWRT (1)
      MSGTXT = 'Cursor Y position controls starting intensity'
      CALL MSGWRT (1)
C                                        init & fixed values, on curs
      RPOS(1) = ISZX / 16.0 + WINDTV(1) - 1
      RPOS(2) = (WINDTV(2) + WINDTV(4)) / 2.0
      PGAMMA = 1.0
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
C                                        read until move
 50   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.GT.0) THEN
            CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            ISZX = WINDTV(3) - WINDTV(1) + 1
            ISZY = WINDTV(4) - WINDTV(2) + 1
            END IF
         IF (IBUT.EQ.1) GO TO 20
         IF (IBUT.EQ.4) GO TO 60
         CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        new color
         IF (DOIT) THEN
            NC = 3.0 * (RPOS(1) - WINDTV(1)) / ISZX + 1.0
            PHUE = 360.0 * (RPOS(1) - WINDTV(1) -
     *         (NC-1)*(ISZX/3) + 1) / (ISZX/3)
            PGAMMA = 2.5 * (RPOS(2)+13-WINDTV(2)) / ISZY
            GAMINV = PGAMMA
            IF (GAMINV.LE.0.0) GAMINV = 1.0
            GAMINV = 1.0/GAMINV
            HSTEP = (360.0 * DG2RAD * NC) /  NLEVS
            H = PHUE * DG2RAD - HSTEP
            NP = IMLEVS / NLEVS
            I0 = 1
            DO 55 I = 1,NLEVS
               H = H + HSTEP
               V = ((SIN(H-PI/2.0) + 1.0) / 2.0) ** GAMINV
               JJ = V * LUTOUT + 0.5
               CALL FILL (NP, JJ, BUFFER(I0))
               I0 = I0 + NP
 55            CONTINUE
            BUFFER(1) = 0.0
            CALL YLUT ('WRIT', IC, ICOLOR, F, BUFFER, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 50
C                                        Color contours
 60   MSGTXT = 'Cursor X position controls number of contours'
      CALL MSGWRT (1)
      MSGTXT = 'Cursor Y position controls intensity (Gamma)'
      CALL MSGWRT (1)
C                                        init vals, on cursor:
C                                        PPOS 0 forces action 1st time
      RPOS(1) = (WINDTV(1)  + WINDTV(3)) / 2.0
      RPOS(2) = ISZY * 0.6 + WINDTV(2) - 1
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
C                                        read loop
 70   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.GT.0) THEN
            CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            ISZX = WINDTV(3) - WINDTV(1) + 1
            ISZY = WINDTV(4) - WINDTV(2) + 1
            END IF
         IF (IBUT.EQ.1) GO TO 20
         IF (IBUT.EQ.2) GO TO 40
         CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        cursor moved: do it
         IF (DOIT) THEN
            PGAMMA = 2.5 * (RPOS(2)+13-WINDTV(2)) / ISZY
            GAMINV = PGAMMA
            IF (GAMINV.LE.0.0) GAMINV = 1.0
            GAMINV = 1.0/GAMINV
            NC = 63.0 * (RPOS(1) - WINDTV(1) + 1.) / ISZX + 1.0
            NC = MAX (2, MIN (64, NC))
            NP = FLOAT (NLEVS) / FLOAT (NC) + 0.5
            DO 75 LC = 1,NC
               I0 = (LC - 1) * NP
               V = (FLOAT (LC-1) / FLOAT (NC-1)) ** GAMINV
               JJ = V * LUTOUT + 0.5
               CALL FILL (NP, JJ, BUFFER(I0+1))
 75            CONTINUE
            CALL YLUT ('WRIT', IC, ICOLOR, F, BUFFER, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 70
C                                        messages on error
 900  IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1910) IERR
         CALL MSGWRT (7)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1910 FORMAT ('TVBLWH: TV ACTION ERROR CODE',I7)
      END
