      SUBROUTINE TV2COL (NLEVS, APARM, BUFFER, IERR)
C-----------------------------------------------------------------------
C! Interactive pseudo-colorings with only 2 colors at a time
C# TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2020-2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Inputs:
C      NLEVS    I      color levels (use 0)
C   Output:
C      BUFFER   I(*)   scratch * >= TVMOFM
C      IERR     I      error code
C-----------------------------------------------------------------------
      INTEGER   NLEVS, BUFFER(*), IERR
      REAL      APARM(10)
C
      INTEGER  IBUT, QUAD, ITW(3), ICOL, IMLEVS, ITYCON, ISZX, ISZY,
     *   ITYPE, ISCY, IX
      REAL      RPOS(2), PPOS(2), PGAMMA, PHUE(2), SATUR(2), X
      LOGICAL   F, DOIT
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA F /.FALSE./
C-----------------------------------------------------------------------
C                                        general parameters
      QUAD = -1
      RPOS(1) = 0.0
      RPOS(2) = 0.0
      IMLEVS = MAX (LUTOUT+1, NLEVS)
      IF (IMLEVS.GT.OFMINP+1) IMLEVS = OFMINP + 1
      CALL ZTIME (ITW)
      APARM(1) = MAX (0.0, MIN (APARM(1), 0.5))
      APARM(2) = MAX (0.0, MIN (APARM(2), 1.0))
      APARM(3) = MAX (0.0, MIN (APARM(3), 0.5))
C                                        TV2color
      MSGTXT = 'Hit button D to exit'
      CALL MSGWRT (1)
      ISZX = WINDTV(3) - WINDTV(1) + 1
      ISZY = WINDTV(4) - WINDTV(2) + 1
      GO TO 40
C
 20   PPOS(1) = 0.0
      PPOS(2) = 0.0
C                                        hue, saturation
      MSGTXT = 'Cursor X position controls break between low & high'
     *   // ' colors'
      CALL MSGWRT (1)
      MSGTXT = 'Cursor Y position controls saturation'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button A to cycle colors'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button B to cycle intensity slope'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button C to switch to pure color pairs'
      CALL MSGWRT (1)
C                                        init vals, on cursor
      RPOS(1) = (WINDTV(1) + WINDTV(3)) / 2
      RPOS(2) = ISZY * 0.9 + WINDTV(2) - 1
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
      PGAMMA = 2.2
      ITYPE = 0
      PHUE(1) = 75.
      PHUE(2) = 255.0
C                                        read until moves
 30   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.GT.0) THEN
            CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            ISZX = WINDTV(3) - WINDTV(1) + 1
            ISZY = WINDTV(4) - WINDTV(2) + 1
            ISCY = (WINDTV(4) + WINDTV(2)) / 2
            END IF
         IF (IBUT.EQ.4) GO TO 40
         IF (IBUT.EQ.2) THEN
            ITYPE = ITYPE + 1
            IF (ITYPE.GT.1) ITYPE = -1
            END IF
         IF (IBUT.EQ.1) THEN
            PHUE(1) = PHUE(1) + 30.0
            PHUE(2) = PHUE(2) + 30.0
            IF (PHUE(1).GT.360.) PHUE(1) = PHUE(1) - 360.
            IF (PHUE(2).GT.360.) PHUE(2) = PHUE(2) - 360.
            END IF
         CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        new color
         IF (DOIT) THEN
            X = (RPOS(1) - WINDTV(1) + 1.) / ISZX
            SATUR(1) = 100.0 * (((RPOS(2)-WINDTV(2)) / ISZY)**0.333)
            SATUR(2) = SATUR(1)
            CALL COLR2S (IMLEVS, ITYPE, X, SATUR, PHUE, PGAMMA, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 30
C                                       simple colors
 40   PPOS(1) = 0.0
      PPOS(2) = 0.0
      ICOL = 3
      ITYCON = 1
      MSGTXT = 'Cursor X position controls break between low & high'
     *   // ' colors'
      CALL MSGWRT (1)
      MSGTXT = 'Cursor Y position controls color intensity (Gamma)'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button A or B to cycle colors'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button C to switch to hue-saturation pairs'
      CALL MSGWRT (1)
CC                                        init vals, on cursor
      RPOS(1) = (WINDTV(1) + WINDTV(3)) / 2
      RPOS(2) = ISZY * 0.6 + WINDTV(2) - 1
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
C                                        read until moves
 50   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.GT.0) THEN
            CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            ISZX = WINDTV(3) - WINDTV(1) + 1
            ISZY = WINDTV(4) - WINDTV(2) + 1
            END IF
C        IF (IBUT.EQ.2) GO TO 40
         IF (IBUT.EQ.4) GO TO 20
         CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        new color
         IF (DOIT) THEN
            PGAMMA = 2.5 * (RPOS(2)+13-WINDTV(2)) / ISZY
            IX = IMLEVS * (RPOS(1) - WINDTV(1) + 1.) / ISZX + 0.6
            IF (IBUT.GT.0) THEN
               ICOL = ICOL - 1
               IF (ICOL.EQ.0) ICOL = -1
               IF (ICOL.EQ.-4) ICOL = 3
               END IF
            CALL COLOR2 (IMLEVS, ICOL, IX, PGAMMA, APARM, BUFFER, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 50
C                                        messages on error
 900  IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1910) IERR
         CALL MSGWRT (7)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1910 FORMAT ('TVPSUD: TV ACTION ERROR CODE',I7)
      END
