LOCAL INCLUDE 'PTVIEW.INC'
      INTEGER   NOPT, MAXCHR
      PARAMETER (NOPT = 13)
      PARAMETER (MAXCHR = 19)
LOCAL END
LOCAL INCLUDE 'TVIEW.INC'
      INCLUDE 'INCS:PMAD.INC'
      CHARACTER NAMIN*12, CLSIN*6, NAMIN2*12, CLSIN2*6, FUNTYP*2,
     *   SAMTYP*4
      HOLLERITH XNAMIN(3), XCLSIN(2), XNAMI2(3), XCLSI2(2), XFUNC
      REAL      SEQIN, DSKIN, SEQIN2, DSKIN2, BLC(7), TRC(7), TBLC(7),
     *   TTRC(7), XTVCH, RANGE(2), XCBPLT, REWGT(2)
      INTEGER   CATBLK(256), CATBL1(256), CATBL2(256), CATBL3(256),
     *   CATBL4(256), CATBLS(256)
      REAL      CATR(256), CATR1(256), CATR2(256), CATR3(256),
     *   CATR4(256), CATRS(256), PRANGE(2), CRANGE(2), ROTIN, ROTTOT,
     *   SRANGE(2)
      DOUBLE PRECISION CATD(128), CATD1(128), CATD2(128), CATD3(128),
     *   CATD4(128), CATDS(128)
      HOLLERITH CATH(256), CATH1(256), CATH2(256), CATH3(256),
     *   CATH4(256), CATHS(256)
      REAL      BUFF1(MABFSS)
      INTEGER   LUN1, LUN2, IND1, IND2, VOL1, VOL2, SLOT1, SLOT2, SEQ1,
     *   SEQ2, IUSER, TVCH, JBUFSZ, CURWIN(4,4), LWINTV(4), GRMENU,
     *   GRSPC1, GRSPC2, GRMEBG, GRLABL, GRMODL, GRESID, GRBLAC,
     *   IBUFF(MAXIMG), JBUFF(MAXIMG), SCRTCH(MAXIMG), DOLABL, RAAX,
     *   DECAX, FAX, TVCENT(2), CURPLN(4), HDRSAV(256,4), CBPLOT, DOREF
      LOGICAL   MENUOK
      EQUIVALENCE (CATBLK, CATR, CATH, CATD)
      EQUIVALENCE (CATBL1, CATR1, CATH1, CATD1)
      EQUIVALENCE (CATBL2, CATR2, CATH2, CATD2)
      EQUIVALENCE (CATBL3, CATR3, CATH3, CATD3)
      EQUIVALENCE (CATBL4, CATR4, CATH4, CATD4)
      EQUIVALENCE (CATBLS, CATRS, CATHS, CATDS)
      COMMON /MAPHDR/ CATD, CATD1, CATD2, CATD3, CATD4, CATDS
      COMMON /INPARM/ XNAMIN, XCLSIN, SEQIN, DSKIN, BLC, TRC, XNAMI2,
     *   XCLSI2, SEQIN2, DSKIN2, TBLC, TTRC, XTVCH, RANGE, XFUNC,
     *   XCBPLT, REWGT
      COMMON /CHARPM/ NAMIN, CLSIN, NAMIN2, CLSIN2, SAMTYP, FUNTYP
      COMMON /BUFFRS/ BUFF1, IBUFF, JBUFF
      COMMON /TVIEWP/ LUN1, LUN2, IND1, IND2, VOL1, VOL2, SEQ1, SEQ2,
     *   SLOT1, SLOT2, TVCH, JBUFSZ, IUSER, CURWIN, PRANGE, LWINTV,
     *   GRMENU, GRSPC1, GRSPC2, GRMEBG, GRLABL, GRMODL, GRESID, GRBLAC,
     *   MENUOK, DOREF, SCRTCH, CURPLN, CRANGE, DOLABL, RAAX, DECAX,
     *   FAX, TVCENT, HDRSAV, ROTIN, ROTTOT, CBPLOT, SRANGE
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DDCH.INC'
LOCAL END
LOCAL INCLUDE 'ROTCOM.INC'
      INTEGER   IXCEN, IYCEN, IWID, IHALF
      REAL      XINT(10), YINT(10), DENOM(10), WFRAC
      COMMON /ITRLCM/ XINT, YINT, DENOM, IXCEN, IYCEN, IWID, IHALF,
     *   WFRAC
LOCAL END
      PROGRAM TVIEW
C-----------------------------------------------------------------------
C! displays cube in 3 transpositions, can rotate
C# TV Map-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2018-2019, 2021-2022, 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   TVIEW will display an image on the TV based on input images giving
C   separate red, green, and blue pictures.  It allows for interactive
C   scaling of the images.
C   INPUTS:   (from AIPS)
C      INNAME   R(3)   name of cube
C      INCLASS  R(2)   class of cube
C      INSEQ    R      sequence number of cube
C      INDISK   R      disk volume number. 0 means try all.
C      BLC      R(7)   Bottom left pixel of cube to be included
C      TRC      R(7)   Top right corner of cube to be included
C      IN2NAME  R(3)   name of reference image
C      IN2CLASS R(2)   class of reference image
C      IN2SEQ   R      sequence number reference image
C      IN2DISK  R      disk volume number. 0 means try all.
C      TBLC     R(7)   the pixel in the reference image to become the
C                      left hand coordinate (1,1) of the display
C      TTRC     R(7)   the pixel in the reference image to become the
C                      top right hand corner of the display
C      TVCHAN   R      Desired TV channel
C      PIXRANGE R(2)   the maximum and minimum values allowed for the
C                      map.  All other values will be clipped.  If
C                      IRANGE(1) .GE. IRANGE(2) then the map max and
C                      min will be used.
C      APARM    R(10)
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PMAD.INC'
      INTEGER   INPRMS, IRET, NWORDS, NX, NY, JERR, NX2, NY2, NZ2
      LONGINT   PRIMAG, PIMAG1, PIMAG2, PIMAG3
      REAL      RIMAGE(2), IMAGE1(2), IMAGE2(2), IMAGE3(2)
      CHARACTER PRGNAM*6
      INCLUDE 'TVIEW.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DTVD.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       init the task
      INPRMS = 49
      PRGNAM = 'TVIEW'
      CALL TVIEWI (PRGNAM, INPRMS, IRET)
      IF (IRET.NE.0) GO TO 910
C                                       Allocate cube
      NX2 = CATBL1(KINAX)
      NY2 = CATBL1(KINAX+1)
      NZ2 = CATBL1(KINAX+2)
      NWORDS = (NX2 * NY2 * NZ2 - 1) / 1024 + 3
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, IMAGE1, PIMAG1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING MEMORY FOR CUBE 1'
         GO TO 900
         END IF
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, IMAGE2, PIMAG2, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING MEMORY FOR CUBE 2'
         GO TO 900
         END IF
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, IMAGE3, PIMAG3, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING MEMORY FOR CUBE 3'
         GO TO 900
         END IF
      MSGTXT = 'read image cube into memory'
      CALL MSGWRT (2)
      CALL TVIEI2 (NX2, NY2, NZ2, IMAGE1(1+PIMAG1), IMAGE2(1+PIMAG2),
     *   IMAGE3(1+PIMAG3), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING IMAGE'
         GO TO 900
         END IF
C                                       allocate reference
      IF (DOREF.GE.0.0) THEN
         NX = TTRC(1) - TBLC(1) + 1
         NY = TTRC(2) - TBLC(2) + 1
         NWORDS = (NX * NY - 1) / 1024 + 3
         CALL ZMEMRY ('GET ', TSKNAM, NWORDS, RIMAGE, PRIMAG, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET,
     *         'GETTING MEMORY FOR REFERENCE IMAGE'
            GO TO 900
            END IF
C                                       read image
         MSGTXT = 'read reference image into memory'
         CALL MSGWRT (2)
         CALL TVIEIM (NX, NY, RIMAGE(1+PRIMAG), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING IMAGE'
            GO TO 900
            END IF
         END IF
C                                       do the function
      CALL TVIEDO (NX, NY, RIMAGE(1+PRIMAG), NX2, NY2, NZ2,
     *   IMAGE1(1+PIMAG1), IMAGE2(1+PIMAG2), IMAGE3(1+PIMAG3), IRET)
      GO TO 910
C                                       error message
 900  IF (IRET.NE.0) CALL MSGWRT (8)
C                                       close TV
 910  IF ((TVIND.GT.0) .AND. (TVIND2.GT.0)) THEN
         CALL TVCLOS (SCRTCH, JERR)
         END IF
      IF (ROTTOT.NE.0.0) THEN
         WRITE (MSGTXT,1910) ROTTOT, ROTTOT-ROTIN
         CALL MSGWRT (5)
         END IF
C                                       close files
      CALL DIE (IRET, SCRTCH)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I5,' ON ',A)
 1910 FORMAT ('Total rotation',F7.1,' in this task',F7.1,' degrees')
      END
      SUBROUTINE TVIEWI (PRGNAM, INPRMS, IRET)
C-----------------------------------------------------------------------
C   Routine to get parameters for TVIEW
C   Inputs:
C      PRGNAM   C*6    Program name
C      INPRMS   I      Number of data parameters from AIPS
C   Outputs:
C       SCRTCH  I(*)   Scratch buffer
C       IRET    I      Return code 0=> OK, else just go to DIE
C   Task parameters are returned in common /INPARM/
C-----------------------------------------------------------------------
      CHARACTER PRGNAM*6
      INTEGER   INPRMS, IRET
C
      INCLUDE 'PTVIEW.INC'
C
      INTEGER   IERR, IROUND, I, J, II, TVCODE, NAX
      CHARACTER FTYPE*2, SUBR*8, CHTEMP*4
      REAL      SLOPE, D
      INCLUDE 'TVIEW.INC'
      INCLUDE 'INCS:DFIL.INC'
      DATA FTYPE /'MA'/
C-----------------------------------------------------------------------
      NSCR = 0
      NCFILE = 0
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      IRET = 0
      JBUFSZ = 2 * MABFSS
C                                       Get input values from AIPS.
      CALL GTPARM (PRGNAM, INPRMS, RQUICK, XNAMIN, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         IRET = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
            CALL MSGWRT (8)
      ELSE
         RQUICK = .FALSE.
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, SCRTCH, IERR)
      IF (IRET.NE.0) GO TO 999
      IRET = 5
C                                       AIPS Holleriths ->
C                                       characters
      CALL H2CHR (12, 1, XNAMIN, NAMIN)
      CALL H2CHR (6, 1, XCLSIN, CLSIN)
      CALL H2CHR (12, 1, XNAMI2, NAMIN2)
      CALL H2CHR (6, 1, XCLSI2, CLSIN2)
      CALL H2CHR (2, 1, XFUNC, FUNTYP)
      CALL FILL (4, 0, CURPLN)
      CBPLOT = IROUND (XCBPLT)
      CBPLOT = ABS (CBPLOT)
C
      LUN1 = 16
      LUN2 = 17
      SEQ1 = IROUND (SEQIN)
      SEQ2 = IROUND (SEQIN2)
      VOL1 = IROUND (DSKIN)
      VOL2 = IROUND (DSKIN2)
      IUSER = NLUSER
      TVCH = IROUND (XTVCH)
      IF (TVCH.LE.0) TVCH = 1
C                                       open main cube
      CALL MAPOPN ('READ', VOL1, NAMIN, CLSIN, SEQ1, FTYPE, IUSER,
     *   LUN1, IND1, SLOT1, CATBLK, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN IMAGE CUBE'
         GO TO 990
         END IF
      FTYPE = 'MA'
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = VOL1
      FCNO(NCFILE) = SLOT1
      FRW(NCFILE) = 0
      CALL WINDOW (CATBLK(KIDIM), CATBLK(KINAX), BLC, TRC, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'SETTING WINDOW INTO CUBE'
         GO TO 990
         END IF
C                                       adjust header
      CALL COPY (256, CATBLK, CATBLS)
      NAX = CATBLK(KIDIM)
      RAAX = 0
      DECAX = 0
      FAX = 0
      DO 10 I = 1,NAX
         CATBLK(KINAX+I-1) = TRC(I) - BLC(I) + 1.01
         CATR(KRCRP+I-1) = CATR(KRCRP+I-1) - BLC(I) + 1.0
         IF (I.LE.3) THEN
            J = KHCTP + 2 * (I-1)
            CALL H2CHR (4, 1, CATH(J), CHTEMP)
            IF (CHTEMP(:2).EQ.'RA') RAAX = I
            IF (CHTEMP(:3).EQ.'DEC') DECAX = I
            IF (CHTEMP.EQ.'FREQ') FAX = I
            IF (CHTEMP.EQ.'VELO') FAX = I
            IF (CHTEMP.EQ.'FELO') FAX = I
            IF (FAX.EQ.I) CATR(KRARP) = CATR(KRARP) - BLC(I) + 1.0
            END IF
 10      CONTINUE
      IF ((RAAX.LE.0) .OR. (DECAX.LE.0) .OR. (FAX.LE.0)) THEN
         IERR = 10
         MSGTXT = 'DID NOT FIND ALL 3 AXES'
         GO TO 990
         END IF
      D = 0.005 * (CATR(KRDMX) - CATR(KRDMN))
      CRANGE(1) = CATR(KRDMN) - D
      CRANGE(2) = CATR(KRDMX) + D
      D = 0.005 * (CRANGE(2) - CRANGE(1))
      CATR(IRRAN) = CRANGE(1)
      CATR(IRRAN+1) = CRANGE(2)
      CALL CHR2H (2, FUNTYP, 1, CATH(IITRA))
      CALL COPY (256, CATBLK, CATBL1)
      CALL COPY (256, CATBLK, CATBL2)
      CALL COPY (256, CATBLK, CATBL3)
      CALL RCOPY (2, CRANGE, SRANGE)
C                                       spray out coords: RA
      J = RAAX - 1
      CATBL1(KINAX) = CATBLK(KINAX+J)
      CATR1(KRCRP)  = CATR(KRCRP+J)
      CATR1(KRCIC)  = CATR(KRCIC+J)
      CATR1(KRCRT)  = CATR(KRCRT+J)
      CATD1(KDCRV)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH1(KHCTP))
      CATBL2(KINAX+1) = CATBLK(KINAX+J)
      CATR2(KRCRP+1)  = CATR(KRCRP+J)
      CATR2(KRCIC+1)  = CATR(KRCIC+J)
      CATR2(KRCRT+1)  = CATR(KRCRT+J)
      CATD2(KDCRV+1)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH2(KHCTP+2))
      CATBL3(KINAX+2) = CATBLK(KINAX+J)
      CATR3(KRCRP+2)  = CATR(KRCRP+J)
      CATR3(KRCIC+2)  = CATR(KRCIC+J)
      CATR3(KRCRT+2)  = CATR(KRCRT+J)
      CATD3(KDCRV+2)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH3(KHCTP+4))
C                                       dec
      J = DECAX - 1
      ROTIN = CATR(KRCRT+J)
      ROTTOT = ROTIN
      CATBL1(KINAX+1) = CATBLK(KINAX+J)
      CATR1(KRCRP+1)  = CATR(KRCRP+J)
      CATR1(KRCIC+1)  = CATR(KRCIC+J)
      CATR1(KRCRT+1)  = CATR(KRCRT+J)
      CATD1(KDCRV+1)  = CATD(KDCRV+J)
      CATR1(KRCRT+1)  = ROTIN
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH1(KHCTP+2))
      CATBL2(KINAX+2) = CATBLK(KINAX+J)
      CATR2(KRCRP+2)  = CATR(KRCRP+J)
      CATR2(KRCIC+2)  = CATR(KRCIC+J)
      CATR2(KRCRT+2)  = CATR(KRCRT+J)
      CATD2(KDCRV+2)  = CATD(KDCRV+J)
      CATR1(KRCRT+2)  = ROTIN
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH2(KHCTP+4))
      CATBL3(KINAX+1) = CATBLK(KINAX+J)
      CATR3(KRCRP+1)  = CATR(KRCRP+J)
      CATR3(KRCIC+1)  = CATR(KRCIC+J)
      CATR3(KRCRT+1)  = CATR(KRCRT+J)
      CATD3(KDCRV+1)  = CATD(KDCRV+J)
      CATR1(KRCRT+1)  = ROTIN
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH3(KHCTP+2))
C                                       freq
      J = FAX - 1
      CATBL1(KINAX+2) = CATBLK(KINAX+J)
      CATR1(KRCRP+2)  = CATR(KRCRP+J)
      CATR1(KRCIC+2)  = CATR(KRCIC+J)
      CATR1(KRCRT+2)  = CATR(KRCRT+J)
      CATD1(KDCRV+2)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH1(KHCTP+4))
      CATBL2(KINAX) = CATBLK(KINAX+J)
      CATR2(KRCRP)  = CATR(KRCRP+J)
      CATR2(KRCIC)  = CATR(KRCIC+J)
      CATR2(KRCRT)  = CATR(KRCRT+J)
      CATD2(KDCRV)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH2(KHCTP))
      CATBL3(KINAX) = CATBLK(KINAX+J)
      CATR3(KRCRP)  = CATR(KRCRP+J)
      CATR3(KRCIC)  = CATR(KRCIC+J)
      CATR3(KRCRT)  = CATR(KRCRT+J)
      CATD3(KDCRV)  = CATD(KDCRV+J)
      CALL RCOPY (2, CATH(KHCTP+2*J), CATH3(KHCTP))
      DOREF = -1
      IF (NAMIN2.NE.' ') DOREF = 1
      IF (DOREF.GE.0.0) THEN
         CALL MAPOPN ('READ', VOL2, NAMIN2, CLSIN2, SEQ2, FTYPE, IUSER,
     *      LUN2, IND2, SLOT2, CATBLK, SCRTCH, IERR)
         IF (IERR.GE.2) THEN
            WRITE (MSGTXT,1000) IERR, 'OPENING REFERENCE IMAGE'
            GO TO 990
            END IF
         NCFILE = NCFILE + 1
         FVOL(NCFILE) = VOL2
         FCNO(NCFILE) = SLOT2
         FRW(NCFILE) = 0
         CALL COPY (256, CATBLK, CATBL4)
         CATBLK(IIVOL) = VOL2
         CATBLK(IICNO) = SLOT2
         CALL RNGSET (RANGE, CATR4(KRDMX), CATR4(KRDMN), PRANGE)
         CATR4(IRRAN) = PRANGE(1)
         CATR4(IRRAN+1) = PRANGE(2)
         CALL CHR2H (2, FUNTYP, 1, CATH4(IITRA))
C                                       Check windows
         CALL WINDOW (CATBLK(KIDIM), CATBLK(KINAX), TBLC, TTRC, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'SETTING TV WINDOW'
            GO TO 990
            END IF
         CALL RCOPY (5, TBLC(3), TTRC(3))
      ELSE
         CALL COPY (256, CATBL1, CATBL4)
         END IF
C                                       pix ranges
C                                       open the TV
      IRET = 8
      CALL TVOPEN (SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TV'
         GO TO 990
         END IF
      CALL YHOLD ('ONNN', IERR)
      SUBR = 'YCINIT'
      CALL YCINIT (TVCH, SCRTCH)
      IF (IERR.NE.0) GO TO 980
      SUBR = 'YINIT'
      CALL YINIT (SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 980
      II = NGRAY + NGRAPH
      SUBR = 'YSLECT'
      DO 60 I = 1,II
         IF (I.EQ.TVCH) THEN
            CALL YSLECT ('ONNN', I, 0, SCRTCH, IERR)
         ELSE
            CALL YSLECT ('OFFF', I, 0, SCRTCH, IERR)
            END IF
         IF (IERR.NE.0) GO TO 980
 60      CONTINUE
C                                       Init OFM
      II = OFMINP + 1
      CALL RFILL (II, 0.0, BUFF1)
      II = LUTOUT + 1
      SLOPE = 1.0 / REAL (LUTOUT)
      DO 65 I = 1,II
         BUFF1(I) = (I-1) * SLOPE
 65      CONTINUE
      BUFF1(1) = 0.0
      SUBR = 'YOFM'
      CALL YOFM ('WRIT', 7, .TRUE., BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       LUTs
      II = MAXINT + 1
      SLOPE = REAL (LUTOUT) / REAL (MAXINT)
      DO 70 I = 1,II
         SCRTCH(I) = (I-1) * SLOPE + 0.5
 70      CONTINUE
      SCRTCH(1) = 0
      TVCODE = 2 ** (TVCH - 1)
      SUBR = 'YLUT'
      CALL YLUT ('WRIT', TVCODE, 7, .TRUE., SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL FILL (16, 1, CURWIN)
      CURWIN(3,1) = CATBL1(KINAX)
      CURWIN(4,1) = CATBL1(KINAX+1)
      CURWIN(3,2) = CATBL2(KINAX)
      CURWIN(4,2) = CATBL2(KINAX+1)
      CURWIN(3,3) = CATBL3(KINAX)
      CURWIN(4,3) = CATBL3(KINAX+1)
      CURWIN(3,4) = CATBL4(KINAX)
      CURWIN(4,4) = CATBL4(KINAX+1)
      CURPLN(1) = CATBL1(KINAX+2) / 2
      CURPLN(2) = CATBL2(KINAX+2) / 2
      CURPLN(3) = CATBL3(KINAX+2) / 2
      CATBL4(IIVOL) = VOL1
      CATBL4(IICNO) = SLOT1
      CATR4(IRRAN) = PRANGE(1)
      CATR4(IRRAN+1) = PRANGE(2)
      CALL CHR2H (2, FUNTYP, 1, CATH4(IITRA))
      DO 80 I = 3,7
         CATBL4(IIDEP+I-3) = IROUND (TBLC(I))
80       CONTINUE
      CALL COPY (256, CATBL1, HDRSAV(1,1))
      CALL COPY (256, CATBL2, HDRSAV(1,2))
      CALL COPY (256, CATBL3, HDRSAV(1,3))
      CALL COPY (256, CATBL4, HDRSAV(1,4))
      IRET = 0
C                                       init coords for top labels
      CALL COPY (256, CATBL1, CATBLK)
      LOCNUM = 3
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      GO TO 999
C                                       TV error
 980  WRITE (MSGTXT,1000) IERR, 'TV FUNCTION ' // SUBR
C                                       all errors
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVIEWI: ERROR',I3,' ON ',A)
      END
      SUBROUTINE TVIEIM (NX, NY, IMAGE, IRET)
C-----------------------------------------------------------------------
C   TVIEIM reads in the image to core
C   Inputs
C      NX      I      Number x pixels
C      NY      I      Number y pixels
C   Outputs
C      IMAGE   R(*)   Image
C      IRET    I      error
C-----------------------------------------------------------------------
      INTEGER   NX, NY, IRET
      REAL      IMAGE(NX,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   J, OFFS, WIN(4), BIND
C-----------------------------------------------------------------------
      CALL COMOFF (CATBL4(KIDIM), CATBL4(KINAX), CATBL4(IIDEP), OFFS,
     *   IRET)
      OFFS = OFFS + 1
      WIN(1) = TBLC(1) + 0.1
      WIN(2) = TBLC(2) + 0.1
      WIN(3) = TTRC(1) + 0.1
      WIN(4) = TTRC(2) + 0.1
      CALL MINIT ('READ', LUN2, IND2, NX, NY, WIN, BUFF1, JBUFSZ, OFFS,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT IO TO TV IMAGE'
         GO TO 990
         END IF
      CATBL4(KINAX) = NX
      CATBL4(KINAX+1) = NY
      CATBL4(KINAX+2) = 1
      CATR4(KRCRP) = CATR4(KRCRP) - TBLC(1) + 1.0
      CATR4(KRCRP+1) = CATR4(KRCRP+1) - TBLC(2) + 1.0
      CATR4(KRCRP+2) = CATR4(KRCRP+2) - TBLC(2) + 1.0
      DO 20 J = 1,NY
         CALL MDISK ('READ', LUN2, IND2, BUFF1, BIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ TV IMAGE ROW'
            GO TO 990
            END IF
         CALL RCOPY (NX, BUFF1(BIND), IMAGE(1,J))
 20      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVIEIM: ERROR',I4,' ON ',A)
      END
      SUBROUTINE TVIEI2 (NX, NY, NZ, IMAGE1, IMAGE2, IMAGE3, IRET)
C-----------------------------------------------------------------------
C   TVIEI2 reads in the image cube to core
C   Inputs
C      NX      I      Number X pixels
C      NY      I      Number y pixels
C      NZ      I      Number Z pixels
C   Outputs
C      IMAGE   R(*)   Image
C      IRET    I      error
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NZ, IRET
      REAL      IMAGE1(NX,NY,*), IMAGE2(NZ,NX,*), IMAGE3(NZ,NY,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   J, K, OFFS, WIN(4), BIND, DEPTH(5), Z1, Z2, MX, MY,
     *   LL, MM, KK, I, LX, LY
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      LX = CATBLS(KINAX)
      LY = CATBLS(KINAX+1)
      WIN(1) = BLC(1) + 0.01
      WIN(2) = BLC(2) + 0.01
      WIN(3) = TRC(1) + 0.01
      WIN(4) = TRC(2) + 0.01
      MX = WIN(3) - WIN(1) + 1
      MY = WIN(4) - WIN(2) + 1
      Z1 = BLC(3) + 0.01
      Z2 = TRC(3) + 0.01
      IF (RAAX.EQ.1) LL = 1
      IF (DECAX.EQ.1) LL = 2
      IF (FAX.EQ.1) LL = 3
      IF (RAAX.EQ.2) MM = 1
      IF (DECAX.EQ.2) MM = 2
      IF (FAX.EQ.2) MM = 3
      DO 90 K = Z1,Z2
         DEPTH(1) = K
         KK = K - Z1 + 1
         CALL COMOFF (CATBLS(KIDIM), CATBLS(KINAX), DEPTH, OFFS,
     *      IRET)
         OFFS = OFFS + 1
         CALL MINIT ('READ', LUN1, IND1, LX, LY, WIN, BUFF1, JBUFSZ,
     *      OFFS, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT IO TO TV IMAGE CUBE'
            GO TO 990
            END IF
         DO 80 J = 1,MY
            CALL MDISK ('READ', LUN1, IND1, BUFF1, BIND, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ IMAGE CUBE ROW'
               GO TO 990
               END IF
C                                       spray the values
            IF (LL.EQ.1) THEN
               IF (MM.EQ.2) THEN
                  DO 20 I = 1,MX
                     IMAGE1(I,J,KK) = BUFF1(BIND+I-1)
                     IMAGE2(KK,I,J) = BUFF1(BIND+I-1)
                     IMAGE3(KK,J,I) = BUFF1(BIND+I-1)
 20                  CONTINUE
               ELSE
                  DO 25 I = 1,MX
                     IMAGE1(I,KK,J) = BUFF1(BIND+I-1)
                     IMAGE2(J,I,KK) = BUFF1(BIND+I-1)
                     IMAGE3(J,KK,I) = BUFF1(BIND+I-1)
 25                  CONTINUE
                  END IF
            ELSE IF (LL.EQ.2) THEN
               IF (MM.EQ.1) THEN
                  DO 30 I = 1,MX
                     IMAGE1(J,I,KK) = BUFF1(BIND+I-1)
                     IMAGE2(KK,J,I) = BUFF1(BIND+I-1)
                     IMAGE3(KK,I,J) = BUFF1(BIND+I-1)
 30                  CONTINUE
               ELSE
                  DO 35 I = 1,MX
                     IMAGE1(KK,I,J) = BUFF1(BIND+I-1)
                     IMAGE2(J,KK,I) = BUFF1(BIND+I-1)
                     IMAGE3(J,I,KK) = BUFF1(BIND+I-1)
 35                  CONTINUE
                  END IF
            ELSE
               IF (MM.EQ.1) THEN
                  DO 40 I = 1,MX
                     IMAGE1(J,KK,I) = BUFF1(BIND+I-1)
                     IMAGE2(I,J,KK) = BUFF1(BIND+I-1)
                     IMAGE3(I,KK,J) = BUFF1(BIND+I-1)
 40                  CONTINUE
               ELSE
                  DO 45 I = 1,MX
                     IMAGE1(KK,J,I) = BUFF1(BIND+I-1)
                     IMAGE2(I,KK,J) = BUFF1(BIND+I-1)
                     IMAGE3(I,J,KK) = BUFF1(BIND+I-1)
 45                  CONTINUE
                  END IF
               END IF
 80         CONTINUE
 90      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVIEI2: ERROR',I4,' ON ',A)
      END
      SUBROUTINE TVIEDO (NX, NY, RIMAGE, NX2, NY2, NZ2, IMAGE1, IMAGE2,
     *   IMAGE3, IRET)
C-----------------------------------------------------------------------
C   TVIEDO does the interaction control
C   Inputs
C      NX       I      Number x pixels
C      NY       I      Number y pixels
C      NX2      I      Number x pixels image 2
C      NY2      I      Number y pixels image 2
C      NZ2      I      Number z pixels image 2
C   Outputs
C      RIMAGE   R(*)   reference image image #4
C      IMAGE1   R(*)   XYV cube
C      IMAGE2   R(*)   VXY cube
C      IMAGE3   R(*)   VYX cube
C      IRET     I      error
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NX2, NY2, NZ2, IRET
      REAL      RIMAGE(NX,*), IMAGE1(NX2,NY2,*), IMAGE2(NZ2,NX2,*),
     *   IMAGE3(NZ2,NY2,*)
C
      INCLUDE 'TVIEW.INC'
      INCLUDE 'INC:PTVC.INC'
      INTEGER   NOPT
      PARAMETER (NOPT = 20)
C
      INTEGER   I, II, IBUT, GRCS(2), CHS, NTITLE, TOPSEP, SIDSEP, MOPT,
     *   TTY(2), TIMLIM, ICOLOR, MBOX, NBO, NLEVS, TVCODE, J
      LOGICAL   DOIT, LEAVE(NOPT), VERBOS, FIRST
      REAL      BLCO(7), TRCO(7), RPOS(2), SLOPE, ANGLE, OFM(TVMOFM,3),
     *   IOFM(TVMOFM,3)
      DOUBLE PRECISION DTEMP(10)
      CHARACTER OPTION(NOPT)*20, SUBR*6, ISHELP*8, TITLE*8, MSGBUF*72
      DATA OPTION /'OFF TRANS', 'OFF PSEUDO', 'TVTRANSF', 'TVPSEUDO',
     *   'TVPHLAME', 'OFMCOLOR', 'LABEL IMAGES?', 'CURVALUE',
     *   'SET CUBE RANGE', 'SET REF RANGE', 'SPECTRA', ' ', 'ROAM',
     *   'SET WINDOW', 'RESET WINDOW', 'ROTATE', 'TV ROTATE',
     *   'RELOAD IMAGES', ' ', 'EXIT'/
C      DATA LEAVE /NOPT*.FALSE./
      DATA LEAVE /7*.TRUE., .FALSE., 2*.TRUE., 2*.FALSE., 8*.FALSE./
C-----------------------------------------------------------------------
C                                        Initialize
      TTY(1) = 5
      TTY(2) = 0
      TITLE = ' '
      NTITLE = 0
      MENUOK = .FALSE.
      DOLABL = 0
      GRMENU = 1 + NGRAY
      GRSPC1 = 2 + NGRAY
      GRSPC2 = 3 + NGRAY
      GRMEBG = 4 + NGRAY
      GRLABL = 5 + NGRAY
      GRMODL = 6 + NGRAY
      GRESID = 7 + NGRAY
      GRBLAC = 8 + NGRAY
      TVCODE = 2 ** (TVCH - 1)
C                                       start by forcing a load
      DOIT = .TRUE.
      VERBOS = .FALSE.
      FIRST = .TRUE.
      MOPT = NOPT
      IF (DOREF.LT.0.0) THEN
         OPTION(10) = 'SET SPEC RANGE'
         DO 10 I = 12,MOPT
            OPTION(I-1) = OPTION(I)
 10         CONTINUE
         MOPT = MOPT - 1
         END IF
C                                       Menu interaction loop point
C                                       check window
 100  CALL YWINDO ('READ', WINDTV, IRET)
      SUBR = 'YWINDO'
      IF (IRET.NE.0) GO TO 990
      IF (WINDTV(1).NE.LWINTV(1)) MENUOK = .FALSE.
      IF (WINDTV(2).NE.LWINTV(2)) MENUOK = .FALSE.
      IF (WINDTV(3).NE.LWINTV(3)) MENUOK = .FALSE.
      IF (WINDTV(4).NE.LWINTV(4)) MENUOK = .FALSE.
      CALL COPY (4, WINDTV, LWINTV(1))
      TVCENT(1) = (WINDTV(3) + WINDTV(1)) / 2
      TVCENT(2) = (WINDTV(4) + WINDTV(2)) / 2
      IF (FIRST) GO TO 200
C                                       build menu
      GRCS(1) = GRMENU - NGRAY
c      IF (MENUOK) GRCS(1) = -GRCS(1)
      GRCS(2) = GRMEBG - NGRAY
      ISHELP = TSKNAM
      TOPSEP = 3 * CSIZTV(2) + 1
      SIDSEP = 5
      TIMLIM = 0
      CALL TVMENU (0, 1, MOPT, GRCS, TOPSEP, SIDSEP, ISHELP, OPTION,
     *   TIMLIM, LEAVE, NTITLE, TITLE, CHS, IBUT, SCRTCH, IRET)
      SUBR = 'TVMENU'
      IF (IRET.NE.0) GO TO 990
      MENUOK = .TRUE.
C                                       double check window
      CALL YWINDO ('READ', WINDTV, IRET)
      SUBR = 'YWINDO'
      IF (IRET.NE.0) GO TO 990
      IF (WINDTV(1).NE.LWINTV(1)) MENUOK = .FALSE.
      IF (WINDTV(2).NE.LWINTV(2)) MENUOK = .FALSE.
      IF (WINDTV(3).NE.LWINTV(3)) MENUOK = .FALSE.
      IF (WINDTV(4).NE.LWINTV(4)) MENUOK = .FALSE.
      CALL COPY (4, WINDTV, LWINTV(1))
      TVCENT(1) = (WINDTV(3) + WINDTV(1)) / 2
      TVCENT(2) = (WINDTV(4) + WINDTV(2)) / 2
C                                       Something to do
C                                       off B&W transfer
      DOIT = .NOT.MENUOK
      IF (OPTION(CHS).EQ.'OFF TRANS') THEN
         CALL YHOLD ('ONNN', IRET)
         II = MAXINT + 1
         SLOPE = REAL (LUTOUT) / REAL (MAXINT)
         DO 120 I = 1,II
            SCRTCH(I) = (I-1) * SLOPE + 0.5
 120        CONTINUE
         SUBR = 'YLUT'
         CALL YLUT ('WRIT', TVCODE, 7, .TRUE., SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       off coloring
      ELSE IF (OPTION(CHS).EQ.'OFF PSEUDO') THEN
         CALL YHOLD ('ONNN', IRET)
         II = OFMINP + 1
         CALL RFILL (II, 0.0, BUFF1)
         II = LUTOUT + 1
         SLOPE = 1.0 / REAL (LUTOUT)
         DO 125 I = 1,II
            BUFF1(I) = (I-1) * SLOPE
 125        CONTINUE
         BUFF1(1) = 0.0
         SUBR = 'YOFM'
         CALL YOFM ('WRIT', 7, .TRUE., BUFF1, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       B&W transfer function
      ELSE IF (OPTION(CHS).EQ.'TVTRANSF') THEN
         I = 1
         ICOLOR = 7
         SUBR = 'IENHNS'
         CALL IENHNS (TVCODE, ICOLOR, I, RPOS, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       pseudo coloring
      ELSE IF (OPTION(CHS).EQ.'TVPSEUDO') THEN
         NLEVS = LUTOUT + 1
         SUBR = 'TVPSUD'
         CALL TVPSUD (NLEVS, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       flame coloring
      ELSE IF (OPTION(CHS).EQ.'TVPHLAME') THEN
         NLEVS = LUTOUT + 1
         SUBR = 'TVFLAM'
         CALL TVFLAM (NLEVS, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       pseudo coloring
      ELSE IF (OPTION(CHS).EQ.'OFMCOLOR') THEN
         NLEVS = LUTOUT + 1
         SUBR = 'OFMCOL'
         CALL OFMCOL (NLEVS, OFM, IOFM, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       set a sub-image
      ELSE IF (OPTION(CHS).EQ.'SET WINDOW') THEN
         CALL FINDIM (I)
         IF (I.EQ.1) CALL COPY (256, CATBL1, CATBLK)
         IF (I.EQ.2) CALL COPY (256, CATBL2, CATBLK)
         IF (I.EQ.3) CALL COPY (256, CATBL3, CATBLK)
         IF (I.EQ.4) CALL COPY (256, CATBL4, CATBLK)
         DOIT = .TRUE.
         NBO = 0
         MBOX = 1
         SUBR = 'GRBOXS'
         J = GRMEBG - NGRAY
         CALL GRBOXS (J, MBOX, NBO, BLCO, TRCO, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
         CURWIN(1,I) = BLCO(1) + 0.1
         CURWIN(2,I) = BLCO(2) + 0.1
         CURWIN(3,I) = TRCO(1) + 0.1
         CURWIN(4,I) = TRCO(2) + 0.1
         IF (I.EQ.1) THEN
            CURWIN(2,2) = BLCO(1) + 0.1
            CURWIN(4,2) = TRCO(1) + 0.1
            CURWIN(2,3) = BLCO(2) + 0.1
            CURWIN(4,3) = TRCO(2) + 0.1
         ELSE IF (I.EQ.2) THEN
            CURWIN(1,3) = BLCO(1) + 0.1
            CURWIN(3,3) = TRCO(1) + 0.1
            CURWIN(1,1) = BLCO(2) + 0.1
            CURWIN(3,1) = TRCO(2) + 0.1
         ELSE IF (I.EQ.3) THEN
            CURWIN(1,2) = BLCO(1) + 0.1
            CURWIN(3,2) = TRCO(1) + 0.1
            CURWIN(2,1) = BLCO(2) + 0.1
            CURWIN(4,1) = TRCO(2) + 0.1
            END IF
C                                       DEBUG
         CALL YHOLD ('ONNN', IRET)
         CALL YSLECT ('OFFF', GRMEBG, 0, SCRTCH, IRET)
C                                       back to full image
      ELSE IF (OPTION(CHS).EQ.'RESET WINDOW') THEN
         CALL FINDIM (I)
         DOIT = .TRUE.
         IF (I.EQ.4) THEN
            CURWIN(1,4) = 1
            CURWIN(2,4) = 1
            CURWIN(3,4) = CATBL4(KINAX)
            CURWIN(4,4) = CATBL4(KINAX+1)
         ELSE IF (I.EQ.3) THEN
            CURWIN(1,3) = 1
            CURWIN(2,3) = 1
            CURWIN(3,3) = CATBL3(KINAX)
            CURWIN(4,3) = CATBL3(KINAX+1)
            CURWIN(1,2) = 1
            CURWIN(3,2) = CATBL2(KINAX)
            CURWIN(2,1) = 1
            CURWIN(4,1) = CATBL1(KINAX+1)
         ELSE IF (I.EQ.2) THEN
            CURWIN(1,2) = 1
            CURWIN(2,2) = 1
            CURWIN(3,2) = CATBL2(KINAX)
            CURWIN(4,2) = CATBL2(KINAX+1)
            CURWIN(1,1) = 1
            CURWIN(3,1) = CATBL1(KINAX)
            CURWIN(1,3) = 1
            CURWIN(3,3) = CATBL3(KINAX)
         ELSE IF (I.EQ.1) THEN
            CURWIN(1,1) = 1
            CURWIN(2,1) = 1
            CURWIN(3,1) = CATBL1(KINAX)
            CURWIN(4,1) = CATBL1(KINAX+1)
            CURWIN(2,2) = 1
            CURWIN(4,2) = CATBL2(KINAX+1)
            CURWIN(2,3) = 1
            CURWIN(4,3) = CATBL3(KINAX+1)
            END IF
C                                       switch to spectra
      ELSE IF (OPTION(CHS).EQ.'SPECTRA') THEN
         DOREF = 0.0
         OPTION(10) = 'SET SPEC RANGE'
         OPTION(11) = 'REFERENCE'
         DOIT = .TRUE.
C                                       switch to reference
      ELSE IF (OPTION(CHS).EQ.'REFERENCE') THEN
         DOREF = 1.0
         OPTION(10) = 'SET REF RANGE'
         OPTION(11) = 'SPECTRA'
         DOIT = .TRUE.
C                                       set plane pixrange
      ELSE IF (OPTION(CHS).EQ.'SET REF RANGE') THEN
C                                       Open terminal
         IF (TTY(2).LE.0) THEN
            TTY(2) = 0
            CALL ZOPEN (TTY(1), TTY(2), 1, MSGBUF, .FALSE., .TRUE.,
     *         .TRUE., IRET)
            IF (IRET.NE.0) THEN
               TTY(2) = 0
               WRITE (MSGTXT,1250) IRET
               CALL MSGWRT (6)
               GO TO 200
               END IF
            END IF
         WRITE (MSGBUF,1030) CATR4(KRDMN), CATR4(KRDMX)
         CALL INQFLT (TTY, MSGBUF, 2, DTEMP, IRET)
         IF (IRET.LT.0) GO TO 200
         SUBR = 'INQFLT'
         IF (IRET.GT.0) GO TO 990
         DOIT = .TRUE.
         IF (DTEMP(1).LT.DTEMP(2)) THEN
            PRANGE(1) = DTEMP(1)
            PRANGE(2) = DTEMP(2)
            PRANGE(1) = MAX (PRANGE(1), CATR4(KRDMN))
            PRANGE(2) = MIN (PRANGE(2), CATR4(KRDMX))
         ELSE
            PRANGE(1) = 0.0
            PRANGE(2) = 0.0
            END IF
C                                       set plane pixrange
      ELSE IF (OPTION(CHS).EQ.'SET SPEC RANGE') THEN
C                                       Open terminal
         IF (TTY(2).LE.0) THEN
            TTY(2) = 0
            CALL ZOPEN (TTY(1), TTY(2), 1, MSGBUF, .FALSE., .TRUE.,
     *         .TRUE., IRET)
            IF (IRET.NE.0) THEN
               TTY(2) = 0
               WRITE (MSGTXT,1250) IRET
               CALL MSGWRT (6)
               GO TO 200
               END IF
            END IF
         WRITE (MSGBUF,1032) CATRS(KRDMN), CATRS(KRDMX)
         CALL INQFLT (TTY, MSGBUF, 2, DTEMP, IRET)
         IF (IRET.LT.0) GO TO 200
         SUBR = 'INQFLT'
         IF (IRET.GT.0) GO TO 990
         DOIT = .TRUE.
         IF (DTEMP(1).LT.DTEMP(2)) THEN
            SRANGE(1) = DTEMP(1)
            SRANGE(2) = DTEMP(2)
            SRANGE(1) = MAX (SRANGE(1), CATRS(KRDMN))
            SRANGE(2) = MIN (SRANGE(2), CATRS(KRDMX))
         ELSE
            SRANGE(1) = 0.0
            SRANGE(2) = 0.0
            END IF
C                                       set cube pixrange
      ELSE IF (OPTION(CHS).EQ.'SET CUBE RANGE') THEN
C                                       Open terminal
         IF (TTY(2).LE.0) THEN
            TTY(2) = 0
            CALL ZOPEN (TTY(1), TTY(2), 1, MSGBUF, .FALSE., .TRUE.,
     *         .TRUE., IRET)
            IF (IRET.NE.0) THEN
               TTY(2) = 0
               WRITE (MSGTXT,1250) IRET
               CALL MSGWRT (6)
               GO TO 200
               END IF
            END IF
         WRITE (MSGBUF,1031) CATR1(KRDMN), CATR1(KRDMX)
         CALL INQFLT (TTY, MSGBUF, 2, DTEMP, IRET)
         IF (IRET.LT.0) GO TO 200
         SUBR = 'INQFLT'
         IF (IRET.GT.0) GO TO 990
         DOIT = .TRUE.
         IF (DTEMP(1).LT.DTEMP(2)) THEN
            CRANGE(1) = DTEMP(1)
            CRANGE(2) = DTEMP(2)
            CRANGE(1) = MAX (CRANGE(1), CATR1(KRDMN))
            CRANGE(2) = MIN (CRANGE(2), CATR1(KRDMX))
         ELSE
            CRANGE(1) = CATRS(KRDMN)
            CRANGE(2) = CATRS(KRDMX)
            END IF
C                                       curvalue
      ELSE IF (OPTION(CHS).EQ.'CURVALUE') THEN
         SUBR = 'TVIEWV'
         CALL TVIEWV (NX, NY, RIMAGE, NX2, NY2, NZ2, IMAGE1, IMAGE2,
     *      IMAGE3, IRET)
         IF (IRET.NE.0) GO TO 990
C                                       label pimages
      ELSE IF (OPTION(CHS).EQ.'LABEL IMAGES?') THEN
C                                       turn labels off
         CALL YHOLD ('ONNN', IRET)
         IF (DOLABL.EQ.2) THEN
            SUBR = 'YSLECT'
            CALL YSLECT ('OFFF', GRLABL, 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 990
            CALL YSLECT ('OFFF', GRBLAC, 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 990
            SUBR = 'YZERO'
            CALL YZERO (GRLABL, IRET)
            IF (IRET.NE.0) GO TO 990
            CALL YZERO (GRBLAC, IRET)
            IF (IRET.NE.0) GO TO 990
            DOLABL = 0
C                                       plot labels
         ELSE
            DOLABL = DOLABL + 1
            SUBR = 'TVIELA'
            CALL TVIELA (IRET)
            IF (IRET.NE.0) GO TO 999
            END IF
C                                       change curplane
      ELSE IF (OPTION(CHS).EQ.'ROAM') THEN
         SUBR = 'TVIERO'
         CALL TVIERO (NX2, NY2, NZ2, IMAGE1, IMAGE2, IMAGE3, IRET)
         IF (IRET.GT.0) GO TO 990
C                                       rotate cube
      ELSE IF (OPTION(CHS).EQ.'ROTATE') THEN
C                                       Open terminal
         IF (TTY(2).LE.0) THEN
            TTY(2) = 0
            CALL ZOPEN (TTY(1), TTY(2), 1, MSGBUF, .FALSE., .TRUE.,
     *         .TRUE., IRET)
            IF (IRET.NE.0) THEN
               TTY(2) = 0
               WRITE (MSGTXT,1250) IRET
               CALL MSGWRT (6)
               GO TO 200
               END IF
            END IF
         WRITE (MSGBUF,1040)
         CALL INQFLT (TTY, MSGBUF, 1, DTEMP, IRET)
         ANGLE = DTEMP(1)
         CALL TVSROT (ANGLE, NX, NY, RIMAGE, NX2, NY2, NZ2, IMAGE1,
     *      IMAGE2, IMAGE3, IRET)
         SUBR = 'TVSROT'
         IF (IRET.NE.0) GO TO 990
         DOIT = .TRUE.
         ROTTOT = ROTTOT + ANGLE
C                                       rotate cube
      ELSE IF (OPTION(CHS).EQ.'TV ROTATE') THEN
         IF (DOREF.GT.0.0) THEN
            CALL COPY (256, CATBL4, CATBLK)
            CALL COPY (4, CURWIN(1,4), CATBLK(IIWIN))
            CATR(IRRAN) = PRANGE(1)
            CATR(IRRAN+1) = PRANGE(2)
            CALL TVSLIC (NX, NY, RIMAGE, ANGLE, IRET)
         ELSE
            CALL COPY (256, CATBL1, CATBLK)
            CALL COPY (4, CURWIN(1,1), CATBLK(IIWIN))
            CATR(IRRAN) = CRANGE(1)
            CATR(IRRAN+1) = CRANGE(2)
            CALL TVSLIC (NX2, NY2, IMAGE1(1,1,CURPLN(1)), ANGLE, IRET)
            END IF
         SUBR = 'TVSLIC'
         IF (IRET.NE.0) GO TO 990
         MENUOK = .FALSE.
         CALL TVSROT (ANGLE, NX, NY, RIMAGE, NX2, NY2, NZ2, IMAGE1,
     *      IMAGE2, IMAGE3, IRET)
         SUBR = 'TSROT'
         IF (IRET.NE.0) GO TO 990
         DOIT = .TRUE.
         ROTTOT = ROTTOT + ANGLE
C                                       reload images
      ELSE IF (OPTION(CHS).EQ.'RELOAD IMAGES') THEN
         DOIT = .TRUE.
         CALL COPY (256, HDRSAV(1,1), CATBL1)
         CALL COPY (256, HDRSAV(1,2), CATBL2)
         CALL COPY (256, HDRSAV(1,3), CATBL3)
         CALL COPY (256, HDRSAV(1,4), CATBL4)
         MSGTXT = 'read image cube into memory'
         CALL MSGWRT (2)
         CALL TVIEI2 (NX2, NY2, NZ2, IMAGE1, IMAGE2, IMAGE3, IRET)
         SUBR = 'TVIEI2'
         IF (IRET.NE.0) GO TO 990
         IF (DOREF.GE.0.0) THEN
            MSGTXT = 'read reference image into memory'
            CALL MSGWRT (2)
            CALL TVIEIM (NX, NY, RIMAGE, IRET)
            SUBR = 'TVIEIM'
            IF (IRET.NE.0) GO TO 990
            END IF
C                                       blank
      ELSE IF (OPTION(CHS).EQ.' ') THEN
C                                       quit
      ELSE IF (OPTION(CHS).EQ.'EXIT') THEN
         IRET = 0
         GO TO 990
         END IF
C                                       load TV
 200  IF (DOIT) THEN
         CALL YHOLD ('ONNN', IRET)
         CALL YZERO (TVCH, IRET)
         IF (DOREF.GT.0.0) THEN
            CALL TVIELD (NX, NY, RIMAGE, IRET)
            SUBR = 'TVIELD'
            IF (IRET.NE.0) GO TO 990
         ELSE
            CALL TVIEWS (NX2, NY2, NZ2, IMAGE1, IRET)
            SUBR = 'TVIEWS'
            IF (IRET.NE.0) GO TO 990
            END IF
         CALL TVIEL2 (DOIT, NX2, NY2, NZ2, IMAGE1, IMAGE2, IMAGE3, IRET)
         SUBR = 'TVIEL2'
         IF (IRET.NE.0) GO TO 990
         IF (DOLABL.GT.0) THEN
            SUBR = 'TVIELA'
            CALL TVIELA (IRET)
            IF (IRET.NE.0) GO TO 990
            END IF
         END IF
      FIRST = .FALSE.
      GO TO 100
C
 990  IF (IRET.NE.0) THEN
         IRET = 1
         WRITE (MSGTXT,1990) IRET, SUBR
         CALL MSGWRT (8)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT ('Enter reference image pixrange: min, max',2(1PE11.3))
 1031 FORMAT ('Enter cube image pixrange: min, max',2(1PE11.3))
 1032 FORMAT ('Enter spectrum plot pixrange: min, max',2(1PE11.3))
 1040 FORMAT ('Enter desired rotation angle in degrees CW')
 1250 FORMAT ('TVIEDO ERROR',I5,' OPENING TERMINAL TO ASK QUESTIONS')
 1990 FORMAT ('TVIEDO: ERROR',I5,' RETURNED BY ROUTINE ',A)
      END
      SUBROUTINE FINDIM (IMAG)
C-----------------------------------------------------------------------
C   Finds which of the 4 quadrants is to be used at present
C   Output
C      IMAG   I   4 top left, 2 top right, 1 bot left, 3 bot right
C-----------------------------------------------------------------------
      INTEGER   IMAG
C
      INCLUDE 'TVIEW.INC'
      INTEGER   QUAD, IBUT, IRET
      REAL      RPOS(2)
C-----------------------------------------------------------------------
      MSGTXT = 'Position cursor on image, press any button'
      CALL MSGWRT (2)
      CALL TVWHER (QUAD, RPOS, IBUT, IRET)
      IF (RPOS(2).GT.TVCENT(2)) THEN
         IF (RPOS(1).LT.TVCENT(1)) THEN
            IMAG = 4
C            IF (.NOT.DOREF) GO TO 10
         ELSE
            IMAG = 2
            END IF
      ELSE
         IF (RPOS(1).LT.TVCENT(1)) THEN
            IMAG = 1
         ELSE
            IMAG = 3
            END IF
         END IF
C
 999  RETURN
      END
      SUBROUTINE TVIELD (NX, NY, IMAGE, IRET)
C-----------------------------------------------------------------------
C   TVIELD loads reference image to the TV
C   Inputs:
C      NX       I      Number x pixels
C      NY       I      Number y pixels
C      IMAGE    R(*)   Image
C   Outputs:
C      IRET     I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, IRET
      REAL      IMAGE(NX,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   IX, IY, MX, MY, LX, LY, NXINT, NYINT, PLINC(2), NXP,
     *   NYP, I, J, IY1, IY2, IYTV, MPIX, IWINTV(4)
      CHARACTER SUBR*8
      REAL      X, Y
C-----------------------------------------------------------------------
      I = GRSPC1
      SUBR = 'YSLECT'
      CALL YSLECT ('OFFF', I, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 990
      LX = CURWIN(3,4) - CURWIN(1,4) + 1
      LY = CURWIN(4,4) - CURWIN(2,4) + 1
      MX = LWINTV(3) - LWINTV(1) + 1
      MY = LWINTV(4) - LWINTV(2) + 1
      MX = MX / 2
      MY = MY / 2
      IWINTV(1) = LWINTV(1)
      IWINTV(2) = MY + LWINTV(2)
      IWINTV(3) = LWINTV(1) + MX
      IWINTV(4) = LWINTV(4)
C                                       increments
      IF ((LX.GT.MX) .OR. (LY.GT.MY)) THEN
         NXINT = 1
         NYINT = 1
         PLINC(1) = (LX - 1) / MX + 1
         PLINC(2) = (LY - 1) / MY + 1
         PLINC(1) = MAX (PLINC(1), PLINC(2))
         PLINC(2) = PLINC(1)
         NXP = (LX - 1) / PLINC(1) + 1
         NYP = (LY - 1) / PLINC(2) + 1
         WRITE (MSGTXT,1000) PLINC(1)
      ELSE
         PLINC(1) = 1
         PLINC(2) = 1
         NXINT = (MX - 1) / LX
         NYINT = (MY - 1) / LY
         NXINT = MIN (NXINT, NYINT)
         NXINT = MAX (1, NXINT)
         NYINT = NXINT
         NXP = (LX - 1) * NXINT + 1
         NYP = (LY - 1) * NYINT + 1
         IF (NXINT.GT.1) THEN
            WRITE (MSGTXT,1001) NXINT
         ELSE
            MSGTXT = 'Loading every image pixel in window'
            END IF
         END IF
      CALL MSGWRT (2)
      WRITE (MSGTXT,1010) (CURWIN(J,4), J = 1,4)
      CALL MSGWRT (2)
C                                       img catalog
      CALL COPY (256, CATBL4, CATBLK)
C                                       corners
      CALL COPY (4, CURWIN(1,4), CATBLK(IIWIN))
      IX = (MX - NXP) / 2
      CATBLK(IICOR) = IX + IWINTV(1)
      CATBLK(IICOR+2) = IX + IWINTV(1) + NXP - 1
      IY = (MY - NYP) / 2
      CATBLK(IICOR+1) = IY + IWINTV(2)
      CATBLK(IICOR+3) = IY + IWINTV(2) + NYP - 1
      CALL YCWRIT (TVCH, CATBLK(IICOR), CATBLK, SCRTCH, IRET)
      SUBR = 'YCWRIT'
      IF (IRET.NE.0) GO TO 990
      CATR(IRRAN) = PRANGE(1)
      CATR(IRRAN+1) = PRANGE(2)
      CALL COPY (256, CATBLK, CATBL4)
C                                       load to TV
      IYTV = IY + IWINTV(2) - 1
      MPIX = 1 + (NXP - 1) / NXINT
C                                       First row
      IX = CURWIN(1,4)
      IY = CURWIN(2,4)
      IY1 = IY + 1
      IY2 = CURWIN(4,4)
      CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *   IMAGE(IX,IY), SCRTCH)
      CALL LINTER (MPIX, NXINT, SCRTCH, IBUFF)
      SUBR = 'YIMGIO'
      DO 50 IY = IY1,IY2
         IF (MOD(IY-IY1+1,PLINC(2)).EQ.0) THEN
            CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *         IMAGE(IX,IY), SCRTCH)
            CALL LINTER (MPIX, NXINT, SCRTCH, JBUFF)
            IYTV = IYTV + 1
            CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0, NXP,
     *         IBUFF, IRET)
            IF (IRET.NE.0) GO TO 990
            IF (NYINT.GT.1) THEN
               X = 1.0 / NYINT
               DO 40 I = 2,NYINT
                  Y = (I-1) * X
                  DO 30 J = 1,NXP
                     IF ((JBUFF(J).EQ.0) .OR. (IBUFF(J).EQ.0)) THEN
                        SCRTCH(J) = 0
                     ELSE
                        SCRTCH(J) = IBUFF(J) + Y * (JBUFF(J)-IBUFF(J))
     *                     + 0.49999
                        END IF
 30                  CONTINUE
                  IYTV = IYTV + 1
                  CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0,
     *               NXP, SCRTCH, IRET)
                  IF (IRET.NE.0) GO TO 990
 40               CONTINUE
               END IF
            CALL COPY (NXP, JBUFF, IBUFF)
            END IF
 50      CONTINUE
      GO TO 999
C
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Loading every',I3,' pixel of image')
 1001 FORMAT ('Loading image interpolated by',I3)
 1010 FORMAT ('Image corners',4I6)
 1990 FORMAT ('TVIELD ERROR',I5,' FROM ROUTINE ',A)
      END
      SUBROUTINE TVIEL2 (FIRST, NX, NY, NZ, IMAGE1, IMAGE2, IMAGE3,
     *   IRET)
C-----------------------------------------------------------------------
C   TVIEL2 loads cube images to the TV
C   Inputs:
C      NX       I      Number x pixels
C      NY       I      Number y pixels
C      IMAGE1   R(*)   XYV image
C      IMAGE2   R(*)   VXY image
C      IMAGE3   R(*)   VYX image
C   Outputs:
C      IRET     I      error code
C-----------------------------------------------------------------------
      LOGICAL   FIRST
      INTEGER   NX, NY, NZ, IRET
      REAL      IMAGE1(NX,NY,*), IMAGE2(NZ,NX,*), IMAGE3(NZ,NY,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   IX, IY, MX, MY, LX, LY, NXINT, NYINT, PLINC(2), NXP,
     *   NYP, I, J, K, IY1, IY2, IYTV, MPIX, DEPTH(5), CATSAV(256), L,
     *   IWINTV(4), ICHAR, IX0, IY0, NCHAR, NCH(3), MCH
      CHARACTER SUBR*8, STRING*8, XTRIN(3)*24, AXT*8
      REAL      X, Y
      DOUBLE PRECISION SKY(3), SKRA, SKDEC
      SAVE MCH
      DATA DEPTH, MCH /5*1, 0/
C-----------------------------------------------------------------------
      MX = (LWINTV(3) - LWINTV(1) + 1) / 2
      MY = (LWINTV(4) - LWINTV(2) + 1) / 2
      L = MAX (CATBL1(KINAX), CATBL1(KINAX+1))
      L = MAX (L, CATBL1(KINAX+2))
      IF (L.GE.10000) THEN
         ICHAR = 4
      ELSE IF (L.GE.1000) THEN
         ICHAR = 5
      ELSE IF (L.GE.100) THEN
         ICHAR = 6
      ELSE
         ICHAR = 7
         END IF
      NCHAR = 9 - ICHAR
      CALL COPY (256, CATBL1, CATBLK)
      LOCNUM = 3
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      X = CATR1(KRCRP)
      Y = CURPLN(2)
      CALL XYVAL (X, Y, SKY(1), SKY(2), SKY(3), IRET)
      SKDEC = SKY(2)
      Y = CATR1(KRCRP+1)
      X = CURPLN(3)
      CALL XYVAL (X, Y, SKY(1), SKY(2), SKY(3), IRET)
      SKRA = SKY(1)
      CALL H2CHR (8, 1, CATH1(KHCTP), AXT)
      CALL AXSTRN (AXT, SKRA, 0, NCH(3), XTRIN(3))
      WRITE (STRING,1020) CURPLN(3)
      XTRIN(3)(NCH(3)+3:) = STRING(ICHAR:)
      NCH(3) = NCH(3) + 2 + NCHAR
      CALL H2CHR (8, 1, CATH1(KHCTP+2), AXT)
      CALL AXSTRN (AXT, SKDEC, 1, NCH(2), XTRIN(2))
      WRITE (STRING,1020) CURPLN(2)
      XTRIN(2)(NCH(2)+3:) = STRING(ICHAR:)
      NCH(2) = NCH(2) + 2 + NCHAR
      CALL H2CHR (8, 1, CATH1(KHCTP+4), AXT)
      SKY(3) = CATD1(KDCRV+2) + (CURPLN(1) - CATR(KRCRP+2)) *
     *   CATR(KRCIC+2)
      CALL AXSTRN (AXT, SKY(3), 2, NCH(1), XTRIN(1))
      WRITE (STRING,1020) CURPLN(1)
      NCH(1) = MAX (MCH-2-NCHAR, NCH(1))
      XTRIN(1)(NCH(1)+3:) = STRING(ICHAR:)
      NCH(1) = NCH(1) + 2 + NCHAR
      MCH = MAX (MCH, NCH(1))
C                                       image1
      DO 100 L = 1,3
         IF (CURPLN(L).LT.1) GO TO 100
         CALL COPY (256, CATBLK, CATSAV)
         IF (L.EQ.1) THEN
            IF (CURPLN(L).GT.NZ) GO TO 100
            CALL COPY (256, CATBL1, CATBLK)
            IWINTV(3) = LWINTV(1) + MX
            IWINTV(4) = LWINTV(2) + MY
            IWINTV(1) = LWINTV(1)
            IWINTV(2) = LWINTV(2)
         ELSE IF (L.EQ.2) THEN
            IF (CURPLN(L).GT.NY) GO TO 100
            CALL COPY (256, CATBL2, CATBLK)
            IWINTV(1) = LWINTV(1) + MX
            IWINTV(2) = LWINTV(2) + MY
            IWINTV(3) = LWINTV(3)
            IWINTV(4) = LWINTV(4)
         ELSE
            IF (CURPLN(L).GT.NX) GO TO 100
            CALL COPY (256, CATBL3, CATBLK)
            IWINTV(3) = LWINTV(3)
            IWINTV(4) = LWINTV(2) + MY
            IWINTV(1) = LWINTV(1) + MX
            IWINTV(2) = LWINTV(2)
            END IF
         LX = CURWIN(3,L) - CURWIN(1,L) + 1
         LY = CURWIN(4,L) - CURWIN(2,L) + 1
         K = CURPLN(L)
C                                       increments
         IF (L.EQ.1) THEN
            IF ((LX.GT.MX) .OR. (LY.GT.MY)) THEN
               NXINT = 1
               NYINT = 1
               PLINC(1) = (LX - 1) / MX + 1
               PLINC(2) = (LY - 1) / MY + 1
               PLINC(1) = MAX (PLINC(1), PLINC(2))
               PLINC(2) = PLINC(1)
               NXP = (LX - 1) / PLINC(1) + 1
               NYP = (LY - 1) / PLINC(2) + 1
               WRITE (MSGTXT,1000) PLINC(1), PLINC(2)
            ELSE
               PLINC(1) = 1
               PLINC(2) = 1
               NXINT = (MX - 1) / LX
               NYINT = (MY - 1) / LY
               NXINT = MAX (1, NXINT)
               NYINT = MAX (1, NYINT)
               NXINT = MIN (NXINT, NYINT)
               NYINT = NXINT
               NXP = (LX - 1) * NXINT + 1
               NYP = (LY - 1) * NYINT + 1
               IF ((NXINT.GT.1) .OR. (NYINT.GT.1)) THEN
                  WRITE (MSGTXT,1001) NXINT, NYINT
               ELSE
                  MSGTXT = 'Loading every image pixel in window'
                  END IF
               END IF
            IF (FIRST) CALL MSGWRT (2)
         ELSE
            IF (LX.GT.MX) THEN
               NXINT = 1
               PLINC(1) = (LX - 1) / MX + 1
               NXP = (LX - 1) / PLINC(1) + 1
               WRITE (MSGTXT,1005) PLINC(1), 'X'
            ELSE
               PLINC(1) = 1
               NXINT = (MX - 1) / LX
               NXINT = MAX (1, NXINT)
               NXP = (LX - 1) * NXINT + 1
               IF (NXINT.GT.1) THEN
                  WRITE (MSGTXT,1006) 'X', NXINT
               ELSE
                  MSGTXT = 'Loading every X pixel in window'
                  END IF
               END IF
            IF (FIRST) CALL MSGWRT (2)
            IF (LY.GT.MY) THEN
               NYINT = 1
               PLINC(2) = (LY - 1) / MY + 1
               NYP = (LY - 1) / PLINC(2) + 1
               WRITE (MSGTXT,1005) PLINC(2), 'Y'
            ELSE
               PLINC(2) = 1
               NYINT = (MY - 1) / LY
               NYINT = MAX (1, NYINT)
               NYP = (LY - 1) * NYINT + 1
               IF (NYINT.GT.1) THEN
                  WRITE (MSGTXT,1006) 'Y', NYINT
               ELSE
                  MSGTXT = 'Loading every Y pixel in window'
                  END IF
               END IF
            IF (FIRST) CALL MSGWRT (2)
            END IF
         WRITE (MSGTXT,1010) (CURWIN(J,L), J = 1,4)
         IF (FIRST) CALL MSGWRT (2)
C                                       corners
         CALL COPY (5, DEPTH, CATBLK(IIDEP))
         CALL COPY (4, CURWIN(1,L), CATBLK(IIWIN))
         IX = (MX - NXP) / 2
         CATBLK(IICOR) = IX + IWINTV(1)
         CATBLK(IICOR+2) = IX + IWINTV(1) + NXP - 1
         IY = (MY - NYP) / 2
         CATBLK(IICOR+1) = IY + IWINTV(2)
         CATBLK(IICOR+3) = IY + IWINTV(2) + NYP - 1
         CATR(IRRAN) = CRANGE(1)
         CATR(IRRAN+1) = CRANGE(2)
         CALL YCWRIT (TVCH, CATBLK(IICOR), CATBLK, SCRTCH, IRET)
         SUBR = 'YCWRIT'
         IF (IRET.NE.0) GO TO 990
         IF (L.EQ.1) CALL COPY (256, CATBLK, CATBL1)
         IF (L.EQ.2) CALL COPY (256, CATBLK, CATBL2)
         IF (L.EQ.3) CALL COPY (256, CATBLK, CATBL3)
         IF (FIRST) THEN
            SUBR = 'YFILL'
            CALL YFILL (TVCH, IWINTV(1), IWINTV(2), IWINTV(3), IWINTV(4)
     *         ,0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 990
            END IF

C                                       load to TV
         IYTV = IY + IWINTV(2) - 1
         MPIX = 1 + (NXP - 1) / NXINT
C                                       First row
         IX = CURWIN(1,L)
         IY = CURWIN(2,L)
         IY1 = IY + 1
         IY2 = CURWIN(4,L)
         IF (L.EQ.1) THEN
            CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *         IMAGE1(IX,IY,K), SCRTCH)
         ELSE IF (L.EQ.2) THEN
            CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *         IMAGE2(IX,IY,K), SCRTCH)
         ELSE
            CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *         IMAGE3(IX,IY,K), SCRTCH)
            END IF
         CALL LINTER (MPIX, NXINT, SCRTCH, IBUFF)
         SUBR = 'YIMGIO'
         DO 50 IY = IY1,IY2
            IF (MOD(IY-IY1+1,PLINC(2)).EQ.0) THEN
               IF (L.EQ.1) THEN
                  CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX,
     *               PLINC(1), IMAGE1(IX,IY,K), SCRTCH)
               ELSE IF (L.EQ.2) THEN
                  CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX,
     *               PLINC(1), IMAGE2(IX,IY,K), SCRTCH)
               ELSE
                  CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX,
     *               PLINC(1), IMAGE3(IX,IY,K), SCRTCH)
                  END IF
               CALL LINTER (MPIX, NXINT, SCRTCH, JBUFF)
               IYTV = IYTV + 1
               CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0, NXP,
     *            IBUFF, IRET)
               IF (IRET.NE.0) GO TO 990
               IF (NYINT.GT.1) THEN
                  X = 1.0 / NYINT
                  DO 40 I = 2,NYINT
                     Y = (I-1) * X
                     DO 30 J = 1,NXP
                        IF ((JBUFF(J).EQ.0) .OR. (IBUFF(J).EQ.0)) THEN
                           SCRTCH(J) = 0
                        ELSE
                           SCRTCH(J) = IBUFF(J) + Y*(JBUFF(J)-IBUFF(J))
     *                        + 0.49999
                           END IF
 30                     CONTINUE
                     IYTV = IYTV + 1
                     CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0,
     *                  NXP, SCRTCH, IRET)
                     IF (IRET.NE.0) GO TO 990
 40                  CONTINUE
                  END IF
               CALL COPY (NXP, JBUFF, IBUFF)
               END IF
 50         CONTINUE
C                                       label
         IX0 = CATBLK(IICOR+2) - (NCH(L)+2) * CSIZTV(1)
         IY0 = CATBLK(IICOR+3) + CSIZTV(2)
         IF (IY0+CSIZTV(2).GE.MAXXTV(2)) IY0 = CATBLK(IICOR+3) -
     *      2*CSIZTV(2)
         CALL IMCHAR (TVCH, IX0, IY0, 0, 0, XTRIN(L)(:NCH(L)), SCRTCH,
     *      IRET)
 100     CONTINUE
      GO TO 995
C
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C
 995  CALL COPY (256, CATSAV, CATBLK)
      FIRST = .FALSE.
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Loading every',2I3,' pixel of image cube')
 1001 FORMAT ('Loading image cube interpolated by',2I3)
 1005 FORMAT ('Loading every',I3,1X,A,' pixel of image cube')
 1006 FORMAT ('Loading image cube interpolated in ',A,' by',I3)
 1010 FORMAT ('Image cube corners',4I6)
 1020 FORMAT (I8)
 1990 FORMAT ('TVIEL2 ERROR',I5,' FROM ROUTINE ',A)
      END
      SUBROUTINE TVIEWS (NX, NY, NZ, IMAGE1, IRET)
C-----------------------------------------------------------------------
C   Plots spectrum
C   Inputs:
C      NX       I      X dimension of IMAGE1
C      NY       I      Y dimension of IMAGE1
C      NZ       I      Z dimension of IMAGE1
C      IMAGE1   R(*)   X-Y-S cube
C   Outputs:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NZ, IRET
      REAL      IMAGE1(NX,NY,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   I, IX0, IY0, JDROP(2), CATSAV(256), TVSIZE(2), NXA, NYA,
     *   I4XTRA, ICHB, ICHL, ICHR, ICHT, IX1, IX2, IY1, IY2, LABEL,
     *   NTEXT, IROUND, INP, JTRIM, IWINTV(4), MX, MY, NP, I1, I2
      REAL      SPECT(16384), SMAX, SMIN, FQFINC, PIXMIN, PIXMAX,
     *   RANGE2(2), RMAX,XBLC(7), XTRC(7), LBLC(2), LTRC(2), CH(4),
     *   YGAP, DX, X, Y, XFAC, XOFF, XYRATO, XX, XRANGE(2)
      LOGICAL   BLAST
      CHARACTER TEXT(2)*80, SUBR*8, XTEXT*80
      DOUBLE PRECISION FQFREQ
      INCLUDE 'INCS:DTVS.INC'
      DATA XBLC, XTRC /14*1.0/
      DATA JDROP /2*0/
C-----------------------------------------------------------------------
      CALL COPY (256, CATBLK, CATSAV)
      CALL COPY (256, CATBL2, CATBLK)
      LOCNUM = 3
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      IGR = GRSPC1
C                                       load up spectrum
      IX0 = CURPLN(3)
      IY0 = CURPLN(2)
      IF ((IX0.LT.1) .OR. (IX0.GT.NX) .OR. (IY0.LT.1) .OR. (IY0.GT.NY))
     *   THEN
         WRITE (MSGTXT,1010) IX0, IY0, NX, NY
         GO TO 990
         END IF
      SMAX = -1.E10
      SMIN = -SMAX
      I1 = CURWIN(1,2)
      I2 = CURWIN(3,2)
      DO 20 I = I1,I2
         SPECT(I) = IMAGE1(IX0,IY0,I)
         IF (SPECT(I).NE.FBLANK) THEN
            SMAX = MAX (SMAX, SPECT(I))
            SMIN = MIN (SMIN, SPECT(I))
            END IF
 20      CONTINUE
      IF (SRANGE(2).GT.SRANGE(1)) THEN
         SMAX = SRANGE(2)
         SMIN = SRANGE(1)
         END IF
C                                       on plane and zero
      SUBR = 'YSLECT'
      CALL YSLECT ('ONNN', IGR, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      SUBR = 'YZERO'
      CALL YZERO (IGR, IRET)
      IF (IRET.NE.0) GO TO 980
      XBLC(1) = 1
      XBLC(2) = IX0
      XBLC(3) = IY0
      XTRC(1) = NZ
      XTRC(2) = IX0
      XTRC(3) = IY0
C                                       window limits
      MX = LWINTV(3) - LWINTV(1) + 1
      MY = LWINTV(4) - LWINTV(2) + 1
      MX = MX / 2
      MY = MY / 2
      IWINTV(1) = LWINTV(1)
      IWINTV(2) = MY + LWINTV(2)
      IWINTV(3) = LWINTV(1) + MX
      IWINTV(4) = LWINTV(4)
      IF (SRANGE(2).LE.SRANGE(1)) THEN
         XRANGE(2) = SMAX
         XRANGE(1) = SMIN
      ELSE
         CALL RCOPY (2, SRANGE, XRANGE)
         END IF
C                                       mess about a bit
 30   DX = (XRANGE(2) - XRANGE(1)) * 0.03
      RANGE2(2) = XRANGE(2) + DX
      RANGE2(1) = XRANGE(1) - DX
C                                       Calc fac & offset to keep BLC
C                                       TRC within range to prevent
C                                       overflow in graphics routines.
      PIXMAX = RANGE2(2)
      PIXMIN = RANGE2(1)
      XFAC = 39999.0 / (PIXMAX - PIXMIN)
      XOFF = 40000.0 - XFAC * PIXMAX
      RANGE2(1) = XFAC * RANGE2(1) + XOFF
      RANGE2(2) = XFAC * RANGE2(2) + XOFF
      RMAX = 2.0 ** (NBITWD-1) - 1
C                                       Must reduce users max value.
      IF (RANGE2(2).GT.RMAX) RANGE2(2) = RMAX
C                                       Must increase users min.
      IF (RANGE2(1).LT.-RMAX) RANGE2(1) = -RMAX
C                                       Round and back calc range.
      RANGE2(1) = IROUND (RANGE2(1))
      RANGE2(2) = IROUND (RANGE2(2))
      IF (RANGE2(1).GE.RANGE2(2)) THEN
         XRANGE(1) = CATR(KRDMN)
         XRANGE(2) = CATR(KRDMX)
         GO TO 30
         END IF
      XRANGE(1) = (RANGE2(1) - XOFF) / XFAC
      XRANGE(2) = (RANGE2(2) - XOFF) / XFAC
      LBLC(2) = RANGE2(1)
      LTRC(2) = RANGE2(2)
      LBLC(1) = 1
      LTRC(1) = NZ
      NP = NZ
      LABEL = 3
C                                       Initialize plot file line drw.
      JDROP(1) = I1 - 1
      JDROP(2) = NZ - I2
      CALL SLBINI (JDROP, NP, XRANGE, LBLC, LTRC, XBLC, XTRC, FQFREQ,
     *   FQFINC, CATBLK(IIDEP), LABEL, YGAP, CH, TEXT, NTEXT)
      XYRATO = (LTRC(2) - LBLC(2)) / (LTRC(1) - LBLC(1))
      IX1 = LBLC(1) + .5
      IY1 = LBLC(2) + .5
      IX2 = LTRC(1) + .5
      IY2 = LTRC(2) + .5
      CH(1) = MAX (9.0, CH(1))
      CH(2) = 0.5
      NTEXT = MIN (NTEXT, 1)
      INP = JTRIM (TEXT(1))
      WRITE (XTEXT,1030) IX0, IY0
      CALL REFRMT (XTEXT, '_', I)
      TEXT(1)(INP+3:) = XTEXT(:I)
      ICHL = CH(1) * CSIZTV(1) + .5
      ICHB = CH(2) * CSIZTV(2) + .5
      ICHR = CH(3) * CSIZTV(1) + .5
      ICHT = CH(4) * CSIZTV(2) + .5
      TVSIZE(1) = IWINTV(3) - IWINTV(1) + 1
      TVSIZE(2) = IWINTV(4) - IWINTV(2) + 1
      NYA = IWINTV(4) - IWINTV(2) - ICHT - ICHB
      NXA = IWINTV(3) - IWINTV(1) - ICHL - ICHR
C                                       compute scaling
      X = IX2
      X = ABS (X - IX1)
      XX = X * XYRATO
      Y = IY2
      Y = ABS (Y - IY1)
      IF ((XX.LE.0.0) .OR. (Y.LE.0.0)) THEN
         MSGTXT = 'SCALING ERROR'
         CALL MSGWRT (8)
         IRET = 1
         GO TO 999
         END IF
      SCALEY = (NYA - 1) / Y
      SCALEX = (NXA - 1) / X
      NXA = SCALEX * X + ICHL + ICHR
      IF (NXA.GE.TVSIZE(1)) THEN
         SCALEX = SCALEX * (FLOAT(TVSIZE(1)) / (NXA + 5.0))
         SCALEY = SCALEY * (FLOAT(TVSIZE(1)) / (NXA + 5.0))
         NXA = SCALEX * X + ICHL + ICHR
         END IF
      NYA = SCALEY * Y + ICHB + ICHT
      IF (NXA.GE.TVSIZE(1)) THEN
         SCALEX = SCALEX * (FLOAT(TVSIZE(2)) / (NYA + 5.0))
         SCALEY = SCALEY * (FLOAT(TVSIZE(2)) / (NYA + 5.0))
         NXA = SCALEX * X + ICHL + ICHR
         NYA = SCALEY * Y + ICHB + ICHT
         END IF
      RX0 = ICHL + MAX (0, TVSIZE(1)-NXA) / 2 + IWINTV(1)
      RY0 = ICHB + MAX (0, TVSIZE(2)-NYA) / 2 + IWINTV(2)
C                                       Put stuff in image catalog.
      CATBLK(IIWIN  ) = IX1
      CATBLK(IIWIN+1) = IY1
      CATBLK(IIWIN+2) = IX2
      CATBLK(IIWIN+3) = IY2
      CATBLK(IICOR  ) = RX0 + 0.5
      CATBLK(IICOR+1) = RY0 + 0.5
      CATBLK(IICOR+2) = RX0 + X * SCALEX + .5
      CATBLK(IICOR+3) = RY0 + Y * SCALEY + .5
      CATBLK(IIPLT) = 5
      CATBLK(IIOTH) = LABEL
      CATBLK(IIOTH+1) = JDROP(1)
      CATBLK(IIOTH+2) = JDROP(2)
      I4XTRA = IIOTH + 3
      CATR(I4XTRA  ) = XBLC(1)
      CATR(I4XTRA+1) = XBLC(2)
      CATR(I4XTRA+2) = XTRC(1)
      CATR(I4XTRA+3) = XTRC(2)
      CATR(I4XTRA+4) = XBLC(3)
      CATR(I4XTRA+5) = XTRC(3)
      I4XTRA = I4XTRA + 6
      I4XTRA = I4XTRA/2 + 1
      CATD(I4XTRA) = FQFREQ
      I4XTRA = 2*I4XTRA + 1
      CATR(I4XTRA) = FQFINC
      CALL CHR2H (2, 'SL', KHPTYO, CATH(KHPTY))
      CATR(IRRAN) = XRANGE(1)
      CATR(IRRAN+1) = XRANGE(2)
C
      RX0 = RX0 - LBLC(1) * SCALEX + .5
      RY0 = RY0 - LBLC(2) * SCALEY + .5
C                                       image catalog etc
      CALL YCINIT (IGR, SCRTCH)
      SUBR = 'YCWRIT'
      CALL YCWRIT (IGR, CATBLK(IICOR), CATBLK, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      SUBR = 'TVLAB'
      CALL TVLAB (LBLC, LTRC, LABEL, YGAP, TEXT, NTEXT, CH, .FALSE.,
     *   IRET)
      IF (IRET.NE.0) GO TO 980
C                                       plot slice
      SUBR = 'TVVEC'
      BLAST = .TRUE.
      DO 50 I = I1,I2
         IF (SPECT(I).EQ.FBLANK) THEN
            BLAST = .TRUE.
         ELSE
            X = I
            Y = XFAC * SPECT(I) + XOFF
            Y = MIN (Y, RANGE2(2))
            Y = MAX (Y, RANGE2(1))
            INP = 2
            IF (BLAST) INP = 1
            CALL TVVEC (X, Y, INP, IRET)
            IF (IRET.NE.0) GO TO 980
            BLAST = .FALSE.
            END IF
 50      CONTINUE
      CALL COPY (256, CATSAV, CATBLK)
      GO TO 999
C
 980  WRITE (MSGTXT,1980) IRET, SUBR
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('TVIEWS PIXEL',2I5,' OUTSIDE RANGE',2(' 1 -',I5))
 1030 FORMAT ('PIXEL',2I6)
 1980 FORMAT ('TVIEWS ERROR',I4,' FROM TV ROUTINE ',A)
      END
      SUBROUTINE TVIERO (NX, NY, NZ, IMAGE1, IMAGE2, IMAGE3, IRET)
C-----------------------------------------------------------------------
C   TVIERO performs the roam operation (changing CURPLN)
C   Outputs:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NZ, IRET
      REAL      IMAGE1(NX,NY,*), IMAGE2(NZ,NX,*), IMAGE3(NZ,NY,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   I, J, ITW(3), QUAD, IBUT, IMT, ICOR(4,4), IWIN(4,4),
     *   IROUND
      DOUBLE PRECISION SKY(3)
      REAL      PPOS(2), RPOS(2), LPPOS(2)
      CHARACTER SUBR*8
      LOGICAL   F, DOIT
      DATA F /.FALSE./
C-----------------------------------------------------------------------
C                                       set up coordinates
      IF (DOREF.GE.0.0) THEN
         CALL COPY (256, CATBL4, CATBLK)
         LOCNUM = 1
         CALL SETLOC (CATBLK(IIDEP), .FALSE.)
         CALL COPY (256, CATBL1, CATBLK)
         LOCNUM = 2
         CALL SETLOC (CATBLK(IIDEP), .FALSE.)
         END IF
      CALL COPY (4, CATBL1(IIWIN), IWIN(1,1))
      CALL COPY (4, CATBL2(IIWIN), IWIN(1,2))
      CALL COPY (4, CATBL3(IIWIN), IWIN(1,3))
      CALL COPY (4, CATBL4(IIWIN), IWIN(1,4))
      CALL COPY (4, CATBL1(IICOR), ICOR(1,1))
      CALL COPY (4, CATBL2(IICOR), ICOR(1,2))
      CALL COPY (4, CATBL3(IICOR), ICOR(1,3))
      CALL COPY (4, CATBL4(IICOR), ICOR(1,4))
      LPPOS(1) = (ICOR(3,4) + ICOR(1,4)) / 2
      LPPOS(2) = (ICOR(4,4) + ICOR(2,4)) / 2
C                                       cursor set up
      CALL ZTIME (ITW)
      PPOS(1) = (CATBL1(IICOR) + CATBL1(IICOR+2)) / 2.0
      PPOS(2) = (CATBL1(IICOR+1) + CATBL1(IICOR+3)) / 2.0
      RPOS(1) = PPOS(1)
      RPOS(2) = PPOS(2)
C                                       on cursor
      SUBR = 'YCURSE'
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IRET)
      IF (IRET.NE.0) GO TO 990
      MSGTXT = 'Hit buttons C or D to stop'
      CALL MSGWRT (1)
C                                       loop point
 20   SUBR = 'YCURSE'
C      CALL YHOLD ('OFFF', IRET)
      CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                       do something
      IF (DOIT) THEN
C                                       exit
         IF (IBUT.GE.4) GO TO 900
C                                       which image?
         IMT = 0
         IF (RPOS(2).LT.TVCENT(2)) THEN
            IF (RPOS(1).LT.TVCENT(1)) THEN
               IMT = 1
            ELSE
               IMT = 3
               END IF
         ELSE IF (RPOS(1).LT.TVCENT(1)) THEN
            IF (DOREF.GE.0.0) IMT = 4
         ELSE
            IMT = 2
            END IF
         IF (IMT.LE.0) GO TO 20
         IF ((RPOS(1).GE.ICOR(1,IMT)) .AND. (RPOS(1).LE.ICOR(3,IMT))
     *      .AND. (RPOS(2).GE.ICOR(2,IMT)) .AND.
     *      (RPOS(2).LE.ICOR(4,IMT))) THEN
            I = (RPOS(1)-ICOR(1,IMT)) / (ICOR(3,IMT)-ICOR(1,IMT)) *
     *         (IWIN(3,IMT)-IWIN(1,IMT)) + IWIN(1,IMT)
            J = (RPOS(2)-ICOR(2,IMT)) / (ICOR(4,IMT)-ICOR(2,IMT)) *
     *         (IWIN(4,IMT)-IWIN(2,IMT)) + IWIN(2,IMT)
            IF (IMT.EQ.1) THEN
               CURPLN(2) = J
               CURPLN(3) = I
            ELSE IF (IMT.EQ.2) THEN
               CURPLN(1) = I
               CURPLN(3) = J
            ELSE IF (IMT.EQ.3) THEN
               CURPLN(1) = I
               CURPLN(2) = J
C                                       coordinates required
            ELSE
 30            RPOS(1) = (PPOS(1) - CATBL4(IICOR)) *
     *            REAL (CATBL4(IIWIN+2) - CATBL4(IIWIN)) /
     *            REAL (CATBL4(IICOR+2) -  CATBL4(IICOR)) +
     *            CATBL4(IIWIN)
               RPOS(2) = (PPOS(2) - CATBL4(IICOR+1)) *
     *            REAL (CATBL4(IIWIN+3) - CATBL4(IIWIN+1)) /
     *            REAL (CATBL4(IICOR+3) - CATBL4(IICOR+1)) +
     *            CATBL4(IIWIN+1)
               LOCNUM = 1
               CALL XYVAL (RPOS(1), RPOS(2), SKY(1), SKY(2), SKY(3),
     *            IRET)
               IF (IRET.EQ.0) THEN
                  LOCNUM = 2
                  IF (CORTYP(1).EQ.1) THEN
                     IF (CORTYP(LOCNUM).EQ.1) THEN
                        CALL XYPIX (SKY(1), SKY(2), RPOS(1), RPOS(2),
     *                     IRET)
                     ELSE
                        CALL XYPIX (SKY(2), SKY(1), RPOS(1), RPOS(2),
     *                     IRET)
                        END IF
                  ELSE IF (CORTYP(1).EQ.2) THEN
                     IF (CORTYP(LOCNUM).EQ.1) THEN
                        CALL XYPIX (SKY(2), SKY(1), RPOS(1), RPOS(2),
     *                     IRET)
                     ELSE
                        CALL XYPIX (SKY(1), SKY(2), RPOS(1), RPOS(2),
     *                     IRET)
                        END IF
                     END IF
                  END IF
               IF (IRET.NE.0) THEN
                  LPPOS(1) = PPOS(1)
                  LPPOS(2) = PPOS(2)
                  CALL YCURSE ('ONNN', F, F, PPOS, QUAD, IBUT, IRET)
                  IF (IRET.NE.0) GO TO 990
                  GO TO 30
                  END IF
               LPPOS(1) = PPOS(1)
               LPPOS(2) = PPOS(2)
               I = IROUND (RPOS(1))
               J = IROUND (RPOS(2))
               CURPLN(2) = MAX (1, MIN (J, CATBL2(KINAX+2)))
               CURPLN(3) = MAX (1, MIN (I, CATBL3(KINAX+2)))
               END IF
            CALL YHOLD ('ONNN', IRET)
            CALL TVIEL2 (F, NX, NY, NZ, IMAGE1, IMAGE2, IMAGE3, IRET)
            SUBR = 'TVIEL2'
            IF (IRET.NE.0) GO TO 990
            IF (DOREF.LE.0.0) THEN
               CALL TVIEWS (NX, NY, NZ, IMAGE1, IRET)
               SUBR = 'TVIEWS'
               IF (IRET.NE.0) GO TO 990
               END IF
            CALL YHOLD ('0FFF', IRET)
            END IF
         END IF
      GO TO 20
 900  CALL YCURSE ('OFFF', F, F, PPOS, QUAD, IBUT, I)
      IF (DOLABL.GT.0) THEN
         CALL YHOLD ('ONNN', IRET)
         SUBR = 'TVIELA'
         CALL TVIELA (IRET)
         IF (IRET.NE.0) GO TO 990
         CALL YHOLD ('ONNN', IRET)
         END IF
      GO TO 999
C                                       error
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1990 FORMAT ('TVIERO ERROR',I4,' RETURNED FROM ',A)
      END
      SUBROUTINE TVSLIC (NX, NY, IMAGE, ANGLE, IRET)
C-----------------------------------------------------------------------
C   TVSLIC displays an image on full screen (channel chan+1) and then
C   interactively sets the end points of a slice.  The angle of the
C   slice is returned.
C   Inputs:
C      NX      I      Number X points in image
C      NY      I      Number Y points in image
C      IMAGE   R(*)   Image
C   Outputs
C      ANGLE   R      Rotation angle CW in degrees
C      IRET    I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, IRET
      REAL      IMAGE(NX,NY), ANGLE
C
      INCLUDE 'TVIEW.INC'
      INTEGER   IG
      CHARACTER SUBR*8
      REAL      BLC0(7), TRC0(7)
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
C                                       clear the TV
      CALL YHOLD ('ONNN', IRET)
      SUBR = 'YZERO'
      CALL YZERO (TVCH, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL YZERO (GRSPC1, IRET)
      IF (IRET.NE.0) GO TO 990
      IF (DOLABL.NE.0) THEN
         SUBR = 'YSLECT'
         CALL YSLECT ('OFFF', GRLABL, 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
         IF (NGRAPH.EQ.8) THEN
            CALL YSLECT ('OFFF', GRBLAC, 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 990
            END IF
         END IF
      CALL TVSLLD (NX, NY, IMAGE, IRET)
      SUBR = 'TVSLLD'
      IF (IRET.NE.0) GO TO 990
      MSGTXT = 'Draw line to set angle tp rotate to X axis'
      CALL MSGWRT (2)
      BLC0(1) = NX / 2
      BLC0(2) = NY / 2
      CALL RFILL (5, 1.0, BLC0(3))
      CALL RCOPY (7, BLC0, TRC0)
      IG = GRSPC1 - NGRAY
      CALL YHOLD ('OFFF', IRET)
      CALL GRSLIC (IG, BLC0, TRC0, SCRTCH, IRET)
      SUBR = 'GRSLIC'
      IF (IRET.NE.0) GO TO 990
C                                       compute angle
      ANGLE = RAD2DG * ATAN2 (TRC0(2)-BLC0(2), TRC0(1)-BLC0(1))
      WRITE (MSGTXT,1000) ANGLE
      CALL MSGWRT (3)
      GO TO 995
C                                       error
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C                                       turn off graphics
 995  CALL YHOLD ('ONNN', IRET)
      CALL YSLECT ('OFFF', GRSPC1, 0, SCRTCH, IG)
      IF (DOLABL.NE.0) THEN
         CALL YSLECT ('ONNN', GRLABL, 0, SCRTCH, IG)
         IF (NGRAPH.EQ.8) CALL YSLECT ('ONNN', GRBLAC, 0, SCRTCH, IG)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVSLIC sets rotation angle to',F7.1,' degrees CW')
 1990 FORMAT ('TVSLIC ERROR',I4,' RETURNED FROM ',A)
      END
      SUBROUTINE TVSLLD (NX, NY, IMAGE, IRET)
C-----------------------------------------------------------------------
C   TVIELD loads an image to the full TV screen
C   Inputs:
C      NX       I      Number x pixels
C      NY       I      Number y pixels
C      IMAGE    R(*)   Image
C   Common
C      CATBLK   I(*)   image header with info
C   Outputs:
C      IRET     I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, IRET
      REAL      IMAGE(NX,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   IX, IY, MX, MY, LX, LY, NXINT, NYINT, PLINC(2), NXP,
     *   NYP, I, J, IY1, IY2, IYTV, MPIX, IWINTV(4)
      CHARACTER SUBR*8
      REAL      X, Y
C-----------------------------------------------------------------------
      LX = CATBLK(IIWIN+2) - CATBLK(IIWIN) + 1
      LY = CATBLK(IIWIN+3) - CATBLK(IIWIN+1) + 1
      MX = LWINTV(3) - LWINTV(1) + 1
      MY = LWINTV(4) - LWINTV(2) + 1
      CALL COPY (4, LWINTV, IWINTV)
C                                       increments
      IF ((LX.GT.MX) .OR. (LY.GT.MY)) THEN
         NXINT = 1
         NYINT = 1
         PLINC(1) = (LX - 1) / MX + 1
         PLINC(2) = (LY - 1) / MY + 1
         PLINC(1) = MAX (PLINC(1), PLINC(2))
         PLINC(2) = PLINC(1)
         NXP = (LX - 1) / PLINC(1) + 1
         NYP = (LY - 1) / PLINC(2) + 1
         WRITE (MSGTXT,1000) PLINC(1)
      ELSE
         PLINC(1) = 1
         PLINC(2) = 1
         NXINT = (MX - 1) / LX
         NYINT = (MY - 1) / LY
         NXINT = MIN (NXINT, NYINT)
         NXINT = MAX (1, NXINT)
         NYINT = NXINT
         NXP = (LX - 1) * NXINT + 1
         NYP = (LY - 1) * NYINT + 1
         IF (NXINT.GT.1) THEN
            WRITE (MSGTXT,1001) NXINT
         ELSE
            MSGTXT = 'Loading every image pixel in window'
            END IF
         END IF
      CALL MSGWRT (2)
C                                       corners
      IX = (MX - NXP) / 2
      CATBLK(IICOR) = IX + IWINTV(1)
      CATBLK(IICOR+2) = IX + IWINTV(1) + NXP - 1
      IY = (MY - NYP) / 2
      CATBLK(IICOR+1) = IY + IWINTV(2)
      CATBLK(IICOR+3) = IY + IWINTV(2) + NYP - 1
      CALL YCWRIT (TVCH, CATBLK(IICOR), CATBLK, SCRTCH, IRET)
      SUBR = 'YCWRIT'
      IF (IRET.NE.0) GO TO 990
C                                       load to TV
      IYTV = IY + IWINTV(2) - 1
      MPIX = 1 + (NXP - 1) / NXINT
C                                       First row
      IX = CATBLK(IIWIN)
      IY = CATBLK(IIWIN+1)
      IY1 = IY + 1
      IY2 = CATBLK(IIWIN+3)
      CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *   IMAGE(IX,IY), SCRTCH)
      CALL LINTER (MPIX, NXINT, SCRTCH, IBUFF)
      SUBR = 'YIMGIO'
      DO 50 IY = IY1,IY2
         IF (MOD(IY-IY1+1,PLINC(2)).EQ.0) THEN
            CALL ISCALE (FUNTYP, MAXINT, CATR(IRRAN), LX, PLINC(1),
     *         IMAGE(IX,IY), SCRTCH)
            CALL LINTER (MPIX, NXINT, SCRTCH, JBUFF)
            IYTV = IYTV + 1
            CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0, NXP,
     *         IBUFF, IRET)
            IF (IRET.NE.0) GO TO 990
            IF (NYINT.GT.1) THEN
               X = 1.0 / NYINT
               DO 40 I = 2,NYINT
                  Y = (I-1) * X
                  DO 30 J = 1,NXP
                     IF ((JBUFF(J).EQ.0) .OR. (IBUFF(J).EQ.0)) THEN
                        SCRTCH(J) = 0
                     ELSE
                        SCRTCH(J) = IBUFF(J) + Y*(JBUFF(J)-IBUFF(J))
     *                     + 0.49999
                        END IF
 30                  CONTINUE
                  IYTV = IYTV + 1
                  CALL YIMGIO ('WRIT', TVCH, CATBLK(IICOR), IYTV, 0,
     *               NXP, SCRTCH, IRET)
                  IF (IRET.NE.0) GO TO 990
 40               CONTINUE
               END IF
            CALL COPY (NXP, JBUFF, IBUFF)
            END IF
 50      CONTINUE
      GO TO 999
C
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Loading every',I3,' pixel of image')
 1001 FORMAT ('Loading image interpolated by',I3)
 1990 FORMAT ('TVSLLD ERROR',I5,' FROM ROUTINE ',A)
      END
      SUBROUTINE TVIELA (IRET)
C-----------------------------------------------------------------------
C   TVIELA draws labels on the grey scale image(s)
C   Output:
C      IRET     I      Error return
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'TVIEW.INC'
      INTEGER   CATSAV(256), IBUFF1(MABFSS), ILAB, IGR
      LOGICAL   DOGRID
      CHARACTER SUBR*8
      EQUIVALENCE (IBUFF1, BUFF1)
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      CALL COPY (256, CATBLK, CATSAV)
C                                       zero graphics
      SUBR = 'YZERO'
      CALL YZERO (GRLABL, IRET)
      IF (IRET.NE.0) GO TO 990
      IF (NGRAPH.EQ.8) THEN
         CALL YZERO (GRBLAC, IRET)
         IF (IRET.NE.0) GO TO 990
         SUBR = 'YSLECT'
         CALL YSLECT ('ONNN', GRBLAC, 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
         END IF
      SUBR = 'YSLECT'
      CALL YSLECT ('ONNN', GRLABL, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       parameters, main image
      ILAB = 7
      DOGRID = DOLABL.EQ.2
      IGR = GRLABL - NGRAY
      SUBR = 'IAXIS1'
      IF (DOREF.GT.0.0) THEN
         LOCNUM = 2
         CALL COPY (256, CATBL4, CATBLK)
         CALL SETLOC (CATBLK(IIDEP), .FALSE.)
         CALL IAXIS1 (IBUFF1, ILAB, IGR, 0, DOGRID, IRET)
         IF (IRET.NE.0) GO TO 990
         IF (CBPLOT.GT.0) CALL ICBPLT (IBUFF1, CBPLOT, IGR, -1, IRET)
         IF (IRET.GT.0) GO TO 990
         END IF
C                                       cube images
      LOCNUM = 1
      CALL COPY (256, CATBL1, CATBLK)
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      CALL IAXIS1 (IBUFF1, ILAB, IGR, 0, DOGRID, IRET)
      IF (IRET.NE.0) GO TO 990
      IF (CBPLOT.GT.0) CALL ICBPLT (IBUFF1, CBPLOT, IGR, -1, IRET)
      IF (IRET.GT.0) GO TO 990
      CALL COPY (256, CATBL2, CATBLK)
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      CALL IAXIS1 (IBUFF1, ILAB, IGR, 0, DOGRID, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL COPY (256, CATBL3, CATBLK)
      CALL SETLOC (CATBLK(IIDEP), .FALSE.)
      CALL IAXIS1 (IBUFF1, ILAB, IGR, 0, DOGRID, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL COPY (256, CATSAV, CATBLK)
      GO TO 999
C                                       error
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1990 FORMAT ('TVIELA ERROR',I5,' FROM ROUTINE ',A)
      END
      SUBROUTINE TVIEWV (NX, NY, IMAGE, NX2, NY2, NZ2, IMAGE1, IMAGE2,
     *   IMAGE3, IRET)
C-----------------------------------------------------------------------
C   TVIEDO does curvalue in any of the 4 picture areas
C   Inputs
C      NX       I      Number x pixels
C      NY       I      Number y pixels
C      NX2      I      Number x pixels image 2
C      NY2      I      Number y pixels image 2
C      NZ2      I      Number z pixels image 2
C      IMAGE    R(*)   Reference image
C      IMAGE1   R(*)   XYV image
C      IMAGE2   R(*)   VXY image
C      IMAGE3   R      VYX image
C   Outputs:
C      IRET     I      error
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NX2, NY2, NZ2, IRET
      REAL      IMAGE(NX,*), IMAGE1(NX2,NY2,*), IMAGE2(NZ2,NX2,*),
     *   IMAGE3(NZ2,NY2,*)
C
      INCLUDE 'TVIEW.INC'
      INTEGER   QUAD, IBUT, ITW(3), I, NPIX, NROW, IX0, IY0, IX1, IY1,
     *   IX, IY, IROUND, CATSAV(256), IMTYPE, LIMTYP, IWIN(4,4)
      REAL      PPOS(2), RPOS(2), PIXVAL
      CHARACTER SUBR*8, STRING*16, PREFIX*5
      DOUBLE PRECISION SKY(3)
      LOGICAL   F, DOIT, EQUAL, DOERR
      DATA F /.FALSE./
C-----------------------------------------------------------------------
      CALL COPY (256, CATBLK, CATSAV)
      LOCNUM = 1
      LIMTYP = 0
      CALL COPY (4, CATBL1(IICOR), IWIN(1,1))
      CALL COPY (4, CATBL2(IICOR), IWIN(1,2))
      CALL COPY (4, CATBL3(IICOR), IWIN(1,3))
      CALL COPY (4, CATBL4(IICOR), IWIN(1,4))
C                                       window for curvalue
      NPIX = 13 * CSIZTV(1)
      NROW = 5.5 * CSIZTV(2)
      IX0 = WINDTV(1) + 2*CSIZTV(1)
      IY0 = WINDTV(4) - NROW + 1 - 2*CSIZTV(2)
      IX1 = IX0 + NPIX - 1
      IY1 = IY0 + NROW - 1
      SUBR = 'YZERO'
      CALL YZERO (GRMEBG, IRET)
      IF (IRET.NE.0) GO TO 990
      IF (NGRAPH.EQ.8) THEN
         IF (DOLABL.EQ.0) THEN
            CALL YZERO (GRBLAC, IRET)
            IF (IRET.NE.0) GO TO 990
            END IF
         SUBR = 'YFILL'
         CALL YFILL (GRBLAC, IX0, IY0, IX1, IY1, 1, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
         SUBR = 'YSLECT'
         CALL YSLECT ('ONNN', GRBLAC, 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 990
         END IF
      SUBR = 'YSLECT'
      CALL YSLECT ('ONNN', GRMEBG, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       cursor set up
      CALL ZTIME (ITW)
      PPOS(1) = (CATBL1(IICOR) + CATBL1(IICOR+2)) / 2.0
      PPOS(2) = (CATBL1(IICOR+1) + CATBL1(IICOR+3)) / 2.0
      RPOS(1) = PPOS(1)
      RPOS(2) = PPOS(2)
C                                       on cursor
      SUBR = 'YCURSE'
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IRET)
      IF (IRET.NE.0) GO TO 990
      MSGTXT = 'Hit buttons C or D to stop'
      CALL MSGWRT (1)
      DOERR = .TRUE.
C                                       loop point
 20   SUBR = 'YCURSE'
      CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                       do something
      IF (DOIT) THEN
C                                       exit
         IF (IBUT.GE.4) GO TO 900
C                                       which image?
         IMTYPE = 2
         IF (RPOS(2).LT.TVCENT(2)) THEN
            IF (RPOS(1).LT.TVCENT(1)) THEN
               IMTYPE = 1
            ELSE
               IMTYPE = 3
               END IF
         ELSE IF (RPOS(1).LT.TVCENT(1)) THEN
            IMTYPE = 4
            END IF
C                                       get coord system
         IF (IMTYPE.NE.LIMTYP) THEN
            IF (IMTYPE.EQ.4) THEN
               CALL COPY (256, CATBL4, CATBLK)
            ELSE IF (IMTYPE.EQ.3) THEN
               CALL COPY (256, CATBL3, CATBLK)
            ELSE IF (IMTYPE.EQ.2) THEN
               CALL COPY (256, CATBL2, CATBLK)
            ELSE
               CALL COPY (256, CATBL1, CATBLK)
               END IF
            CALL SETLOC (CATBLK(IIDEP), .FALSE.)
            LIMTYP = IMTYPE
            END IF
C                                       images
         IF ((IMTYPE.LT.4) .OR. (DOREF.GT.0.0)) THEN
C                                       get image pixel coordinate
            CALL IMA2MP (PPOS, RPOS)
            LOCNUM = 1
            CALL XYVAL (RPOS(1), RPOS(2), SKY(1), SKY(2), SKY(3), IRET)
            IF (IRET.NE.0) THEN
               MSGTXT = 'BAD SKY COORDINATE XYVAL - TRY AGAIN'
               IF (DOERR) CALL MSGWRT (6)
               DOERR = .FALSE.
               GO TO 20
               END IF
C                                       curvalue
            SUBR = 'YFILL'
            CALL YFILL (GRMEBG, IX0, IY0, IX1, IY1, 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 990
            IX = IROUND (RPOS(1))
            IY = IROUND (RPOS(2))
            IF (IMTYPE.EQ.4) THEN
               PIXVAL = IMAGE(IX,IY)
            ELSE IF (IMTYPE.EQ.3) THEN
               PIXVAL = IMAGE3(IX,IY,CURPLN(3))
            ELSE IF (IMTYPE.EQ.2) THEN
               PIXVAL = IMAGE2(IX,IY,CURPLN(2))
            ELSE IF (IMTYPE.EQ.1) THEN
               PIXVAL = IMAGE1(IX,IY,CURPLN(1))
               END IF
            WRITE (STRING,1020) IX, IY
            IY = IY0 + 4.5 * CSIZTV(2)
            CALL YHOLD ('ONNN', IRET)
            SUBR = 'IMCHAR'
            CALL IMCHAR (GRMEBG, IX0, IY, 0, 0, STRING(:13), SCRTCH,
     *         IRET)
            IF (IRET.NE.0) GO TO 990
            IY = IY - 1.5 * CSIZTV(2)
            IF (PIXVAL.NE.FBLANK) THEN
               CALL METSCA (PIXVAL, PREFIX, EQUAL)
               WRITE (STRING,1021) PIXVAL
               CALL IMCHAR (GRMEBG, IX0, IY, 0, 0, STRING(:10), SCRTCH,
     *            IRET)
               IF (IRET.NE.0) GO TO 990
               STRING = PREFIX
               CALL H2CHR (8, 1, CATH(KHBUN), STRING(6:))
            ELSE
               STRING = 'B  BLANKED'
               CALL IMCHAR (GRMEBG, IX0, IY, 0, 0, STRING(:10), SCRTCH,
     *            IRET)
               IF (IRET.NE.0) GO TO 990
               STRING = ' '
               CALL IMCHAR (GRMEBG, IX0, IY0, 0, 0, STRING(:13), SCRTCH,
     *            IRET)
               STRING = ' '
               END IF
            IY = IY - 1.5 * CSIZTV(2)
            CALL IMCHAR (GRMEBG, IX0, IY, 0, 0, STRING(:13), SCRTCH,
     *         IRET)
            IF (IRET.NE.0) GO TO 990
            STRING = ' '
            IF (IMTYPE.LT.4) THEN
               WRITE (STRING,1022) CURPLN(IMTYPE)
               CALL IMCHAR (GRMEBG, IX0, IY0, 0, 0, STRING(:13), SCRTCH,
     *            IRET)
               IF (IRET.NE.0) GO TO 990
               END IF
            CALL YHOLD ('OFFF', IRET)
            END IF
         END IF
      GO TO 20
C                                       shut down nicely
 900  CALL YHOLD ('ONNN', I)
      CALL YCURSE ('OFFF', F, F, PPOS, QUAD, IBUT, I)
      SUBR = 'YSLECT'
      CALL YSLECT ('OFFF', GRMEBG, 0, SCRTCH, I)
      IF (IRET.NE.0) GO TO 990
      IF ((NGRAPH.EQ.8) .AND. (DOLABL.EQ.0)) THEN
         CALL YSLECT ('OFFF', GRBLAC, 0, SCRTCH, I)
         IF (IRET.NE.0) GO TO 990
         END IF
      CALL COPY (256, CATSAV, CATBLK)
      GO TO 999
C                                       error
 990  WRITE (MSGTXT,1990) IRET, SUBR
      CALL MSGWRT (8)
      CALL COPY (256, CATSAV, CATBLK)
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT ('X=',I4,' Y=',I4)
 1021 FORMAT ('B=',F8.3)
 1022 FORMAT ('Z=',I4)
 1990 FORMAT ('TVIEWV ERROR',I4,' RETURNED FROM ',A)
      END
      SUBROUTINE TVSROT (ANGLE, NX, NY, RIMAGE, NX2, NY2, NZ2, IMAGE1,
     *   IMAGE2, IMAGE3, IRET)
C-----------------------------------------------------------------------
C   Rotate reference image and cube in spatial axes
C   Inputs:
C      ANGLE    I      Angle to rotate in degrees
C      NX       I      Number x pixels ref image
C      NY       I      Number y pixels ref image
C      NX2      I      Number x pixels cube
C      NY2      I      Number y pixels cube
C      NZ2      I      Number z pixels cube
C   In/out
C      RIMAGE   R(*)   reference image image #4
C      IMAGE1   R(*)   XYV cube
C      IMAGE2   R(*)   VXY cube
C      IMAGE3   R(*)   VYX cube
C   Output:
C      IRET     I      error
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NX2, NY2, NZ2, IRET
      REAL      ANGLE, RIMAGE(NX,*), IMAGE1(NX2,NY2,*),
     *   IMAGE2(NZ2,NX2,*), IMAGE3(NZ2,NY2,*)
C
      INCLUDE 'TVIEW.INC'
      INCLUDE 'ROTCOM.INC'
      INTEGER   I, J, KWORDS, IZ
      REAL      PROD, OIMAGE(2)
      LONGINT   POIMAG
C-----------------------------------------------------------------------
C                                       init interp function
      IHALF = REWGT(1) + 0.01
      IHALF = MAX (1, MIN (4, IHALF))
      REWGT(1) = IHALF
      IWID = 2 * IHALF + 1
      IF ((REWGT(2).LE.0.0) .OR. (REWGT(2).GT.1.0)) REWGT(2) = 0.333
      WFRAC = REWGT(2)
C                                       Calculate Lagrangian
C                                       denominators
      DO 10 J = 1,IWID
         PROD = 1.0
         DO 5 I = 1,IWID
            IF (I.NE.J) PROD = PROD * (J - I)
 5          CONTINUE
         DENOM(J) = 1.0 / PROD
 10      CONTINUE
C                                       Initialize interpolation fn.
      XINT(1) = FBLANK
      YINT(1) = FBLANK
C                                       reference image
      IF (DOREF.GE.0.0) THEN
         KWORDS = (NX * NY - 1) / 1024 + 4
         CALL ZMEMRY ('GET ', 'TVSROT', KWORDS, OIMAGE, POIMAG, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'GETTING DYNAMIC MEMORY'
            GO TO 990
            END IF
         MSGTXT = 'Rotating reference image'
         CALL MSGWRT (2)
         CALL COPY (256, CATBL4, CATBLK)
         CALL DOROTA (ANGLE, NX, NY, 1, RIMAGE, OIMAGE(1+POIMAG), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'ROTATING REFERENCE IMAGE'
            GO TO 990
            END IF
         CALL ZMEMRY ('FREE', 'TVSROT', KWORDS, OIMAGE, POIMAG, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FREEING DYNAMIC MEMORY'
            GO TO 990
            END IF
         CATR4(KRCRT+1) = CATR4(KRCRT+1) - ANGLE
         END IF
C                                       cube
      KWORDS = (NX2 * NY2 * NZ2 - 1) / 1024 + 4
      CALL ZMEMRY ('GET ', 'TVSROT', KWORDS, OIMAGE, POIMAG, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING DYNAMIC MEMORY'
         GO TO 990
         END IF
      CALL COPY (256, CATBL1, CATBLK)
      MSGTXT = 'Rotating the cube'
      CALL MSGWRT (2)
      CALL DOROTA (ANGLE, NX2, NY2, NZ2, IMAGE1, OIMAGE(1+POIMAG), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'ROTATING REFERENCE IMAGE'
         GO TO 990
         END IF
      CALL ZMEMRY ('FREE', 'TVSROT', KWORDS, OIMAGE, POIMAG, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FREEING DYNAMIC MEMORY'
         GO TO 990
         END IF
      CATR1(KRCRT+1) = CATR1(KRCRT+1) - ANGLE
      CATR2(KRCRT+2) = CATR2(KRCRT+2) - ANGLE
      CATR3(KRCRT+1) = CATR3(KRCRT+1) - ANGLE
C                                       copy cube to other
C                                       transpositions
      DO 50 IZ = 1,NZ2
         DO 40 J = 1,NY2
            DO 30 I = 1,NX2
               IMAGE2(IZ,I,J) = IMAGE1(I,J,IZ)
               IMAGE3(IZ,J,I) = IMAGE1(I,J,IZ)
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVSROT ERROR',I4,' ON ',A)
      END
      SUBROUTINE DOROTA (ANGLE, NX, NY, NZ, RIMAGE, OIMAGE, IRET)
C-----------------------------------------------------------------------
C   Actually computes the rotated image
C   Inputs
C      ANGLE    R      Angle in degrees
C      NX       I      Number X pixels
C      NY       I      Number Y pixels
C      RIMAGE   R(*)   Input image
C   Outputs
C      OIMAGE   R(*)   Output image
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NZ, IRET
      REAL      ANGLE, RIMAGE(NX,NY,*), OIMAGE(NX,NY,*)
C
      INTEGER   I, J, K
      REAL      CRPIX(2), CDELT(2), CR, SR, X, Y, XPIX, YPIX, XR, YR
      INCLUDE 'ROTCOM.INC'
      INCLUDE 'TVIEW.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
      CRPIX(1) = CATR(KRCRP)
      CRPIX(2) = CATR(KRCRP+1)
      CDELT(1) = CATR(KRCIC)
      CDELT(2) = CATR(KRCIC+1)
      CR = COS (DG2RAD * ANGLE)
      SR = SIN (DG2RAD * ANGLE)
C                                       loop over output array
      DO 30 K = 1,NZ
         DO 20 J = 1,NY
            Y = (J - CRPIX(2)) * CDELT(2)
            DO 10 I = 1,NX
               X = (I - CRPIX(1)) * CDELT(1)
               XR = X * CR + Y * SR
               YR = -X * SR + Y * CR
               XPIX = (XR / CDELT(1)) + CRPIX(1)
               YPIX = (YR / CDELT(2)) + CRPIX(2)
               CALL IMINTR (XPIX, YPIX, NX, NY, RIMAGE(1,1,K),
     *            OIMAGE(I,J,K))
 10            CONTINUE
 20         CONTINUE
 30      CONTINUE
      I = NX * NY * NZ
      CALL RCOPY (I, OIMAGE(1,1,1), RIMAGE(1,1,1))
C
 999  RETURN
      END
      SUBROUTINE IMINTR (XPIX, YPIX, NX, NY, RIMAGE, VAL)
C-----------------------------------------------------------------------
C   Interpolates in input image
C   Inputs:
C      XPIX     R      X pixel
C      YPIX     R      Y pixel
C      NX       I      X dimension
C      NY       I      Y dimension
C      RIMAGE   R(*)   input image
C   Output
C      VAL      R      interpolated value
C-----------------------------------------------------------------------
      INTEGER   NX, NY
      REAL      XPIX, YPIX, RIMAGE(NX,NY), VAL
C
      INTEGER   II, JJ, I, J, GOOD
      REAL      SUM, SUMWT, WT, WTY, TWT
      INCLUDE 'ROTCOM.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      VAL = FBLANK
      IF ((XPIX.LT.0.5) .OR. (XPIX.GT.NX+0.5) .OR. (YPIX.LT.0.5) .OR.
     *   (YPIX.GT.NY+0.5)) GO TO 999
C                                       Get interpolation fn
      IF (XPIX.NE.XINT(1)) CALL IMINFN (XPIX, NX, XINT, IXCEN)
      IF (YPIX.NE.YINT(1)) CALL IMINFN (YPIX, NY, YINT, IYCEN)
      SUM = 0.0
      SUMWT = 0.0
      GOOD = 0
      TWT = 0.0
      DO 20 J = 1,IWID
         WTY = YINT(J+1)
         JJ = J + IYCEN
         DO 10 I = 1,IWID
            II = I + IXCEN
            WT = XINT(I+1) * WTY
            TWT = TWT + WT
            IF (RIMAGE(II,JJ).NE.FBLANK) THEN
               SUMWT = SUMWT + WT
               SUM = SUM + RIMAGE(II,JJ) * WT
               GOOD = GOOD + 1
               END IF
 10         CONTINUE
 20      CONTINUE
      IF ((SUMWT.GT.0.9) .AND. (SUMWT/TWT.GT.WFRAC)) VAL = SUM / SUMWT
C
 999  RETURN
      END
      SUBROUTINE IMINFN (POS, N, INT, CEN)
C-----------------------------------------------------------------------
C   Private function
C   Returns Lagrangian interpolation weights.  Adjustments are made to
C   account for the ends of the data.
C   Inputs:
C      POS     R    Coordinate
C      N       I    Maximum pixel number
C   Output:
C      INT     R(*) Interpolation array
C                   (1) = POS
C                   (2...) interpolation weights.
C      CEN     I    (First - 1) pixel number for use
C-----------------------------------------------------------------------
      REAL      POS, INT(*)
      INTEGER   N, CEN
C
      INTEGER   IPOS, I, J
      REAL      PROD, XX
      INCLUDE 'ROTCOM.INC'
C-----------------------------------------------------------------------
      INT(1) = POS
C                                       Fractional pixel
      IPOS = POS + 0.5
C                                       Set first pixel
      CEN = IPOS - IHALF
      CEN = MAX (1, MIN (CEN, (N-IWID+1)))
C                                       Make 0 rel
      CEN = CEN - 1
C                                       Set "x" at first pixel to 1.0
      XX = POS - CEN
C                                       Compute interpolating kernal
      DO 50 J = 1,IWID
         PROD = DENOM(J)
         DO 30 I = 1,IWID
            IF (I.NE.J) PROD = PROD * (XX - I)
 30         CONTINUE
         INT(J+1) = PROD
 50      CONTINUE
C
 999  RETURN
      END
