LOCAL INCLUDE 'OFMPL.INC'
      INTEGER   MXDIR
      PARAMETER (MXDIR = 128)
C
      HOLLERITH XINFIL(12), XNAME(3), XCLASS(2), XFUNC(1)
      REAL      XSEQ, XDISK, TBLC(7), TTRC(7), TXINC, TYINC, PIXR(2)
      CHARACTER INFILE*48, SNAME(MXDIR)*8, FNAME(MXDIR)*64, INNAME*12,
     *   INCLAS*6, FUNCT*2
      INTEGER   SCRTCH(4096), NNAME, INSEQ, INDISK, INCNO
      LOGICAL   DOIMAG
      COMMON /INPARM/ XINFIL, XNAME, XCLASS, XSEQ, XDISK, TBLC, TTRC,
     *   TXINC, TYINC, PIXR, XFUNC
      COMMON /COFMPL/ FNAME, SNAME, INFILE, INNAME, INCLAS, FUNCT
      COMMON /POFMPL/ SCRTCH, NNAME, INSEQ, INDISK, INCNO, DOIMAG
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:PTVC.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DDCH.INC'
LOCAL END
      PROGRAM OFMPL
C-----------------------------------------------------------------------
C! Plots OFM table values
C# TV Interactive
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Plots OFM ("output function memory") color tables
C   Inputs:
C      INFILE    C*48    Data area for user's OFM tables
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'OFMPL.INC'
      DATA PRGM /'OFMPL'/
C-----------------------------------------------------------------------
      CALL OFMPLI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
      CALL OFMPLD (IRET)
C
 990  CALL DIE (IRET, SCRTCH)
C
 999  STOP
      END
      SUBROUTINE OFMPLI (PRGM, IRET)
C-----------------------------------------------------------------------
C   Starts the OFM plot task, reads the directories
C   Output
C      IRET   I   Error code
C-----------------------------------------------------------------------
      CHARACTER PRGM*(*)
      INTEGER   IRET
C
      INCLUDE 'OFMPL.INC'
      INTEGER   J, NNAM(6), JTRIM, NPARM
      CHARACTER XLATED*256, HUSER*3, INTYPE*2, STAT*4
      INCLUDE 'INCS:DFIL.INC'
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      IRET = 0
      CALL VHDRIN
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      NPARM = 38
      CALL GTPARM (PRGM, NPARM, RQUICK, XINFIL, SCRTCH, IRET)
      RQUICK = .FALSE.
      IF (IRET.NE.0) THEN
         RQUICK = .TRUE.
         IF (IRET.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IRET
         IRET = 8
         END IF
C                                       Using the TV?
      IF ((NPOPS.GT.NINTRN) .OR. (NTVDEV.LE.0)) THEN
         MSGTXT = 'YOU ARE NOT ALLOWED TO USE THE TV'
         IRET = 8
         END IF
      IF (IRET.NE.0) GO TO 990
      CALL H2CHR (48, 1 ,XINFIL, INFILE)
      CALL H2CHR (12, 1 ,XNAME, INNAME)
      CALL H2CHR (6, 1 ,XCLASS, INCLAS)
      CALL H2CHR (2, 1 ,XFUNC, FUNCT)
      CALL ZEHEX (NLUSER, 3, HUSER)
      NNAME = 1
      CALL FILL (6, 0, NNAM)
      IF (INFILE.NE.' ') THEN
         J = JTRIM (INFILE)
         XLATED = INFILE(:J)
         IF (XLATED(J:J).NE.':') THEN
            J = J + 1
            XLATED(J:) = ':'
            END IF
         XLATED(J+1:) = '*.' // HUSER
         CALL GETNAM (XLATED, NNAM(1), FNAME(NNAME), SNAME(NNAME),
     *      IRET)
         IF (IRET.NE.0) THEN
            J = MIN (51, JTRIM(XLATED))
            WRITE (MSGTXT,1000) IRET, 'GETTING ' // XLATED(:J)
            GO TO 990
            END IF
         NNAME = NNAME + NNAM(1)
         XLATED(J+1:) = '*.000'
         CALL GETNAM (XLATED, NNAM(2), FNAME(NNAME), SNAME(NNAME),
     *      IRET)
         IF (IRET.NE.0) THEN
            J = MIN (51, JTRIM(XLATED))
            WRITE (MSGTXT,1000) IRET, 'GETTING ' // XLATED(:J)
            GO TO 990
            END IF
         NNAME = NNAME + NNAM(2)
         END IF
      XLATED = 'OFMFIL:*.' // HUSER
      CALL GETNAM (XLATED, NNAM(3), FNAME(NNAME), SNAME(NNAME),
     *   IRET)
      IF (IRET.NE.0) THEN
         J = MIN (51, JTRIM(XLATED))
         WRITE (MSGTXT,1000) IRET, 'GETTING ' // XLATED(:J)
         GO TO 990
         END IF
      NNAME = NNAME + NNAM(3)
      XLATED = 'OFMFIL:*.000'
      CALL GETNAM (XLATED, NNAM(4), FNAME(NNAME), SNAME(NNAME),
     *   IRET)
      IF (IRET.NE.0) THEN
         J = MIN (51, JTRIM(XLATED))
         WRITE (MSGTXT,1000) IRET, 'GETTING ' // XLATED(:J)
         GO TO 990
         END IF
      NNAME = NNAME + NNAM(4)
      XLATED = 'AIPSOFM:*.000'
      CALL GETNAM (XLATED, NNAM(5), FNAME(NNAME), SNAME(NNAME),
     *   IRET)
      IF (IRET.NE.0) THEN
         J = MIN (51, JTRIM(XLATED))
         WRITE (MSGTXT,1000) IRET, 'GETTING ' // XLATED(:J)
         GO TO 990
         END IF
      NNAME = NNAME + NNAM(5) - 1
C
      DOIMAG = (INNAME.NE.' ') .AND. (INCLAS.NE.' ')
      IF (DOIMAG) THEN
         INCNO = 1
         INTYPE = 'MA'
         CALL CATDIR ('SRCH', INDISK, INCNO, INNAME, INCLAS, INSEQ,
     *      INTYPE, NLUSER, STAT, SCRTCH, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SEARCH FOR IMAGE'
            GO TO 990
            END IF
         CALL CATIO ('READ', INDISK, INCNO, CATBLK, 'READ', SCRTCH,
     *      IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ HEADER OF IMAGE'
            GO TO 990
            END IF
         NCFILE = NCFILE + 1
         FVOL(NCFILE) = INDISK
         FCNO(NCFILE) = INCNO
         FRW(NCFILE) = 0
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('OFMPLI: ERROR',I4,' ON ',A)
      END
      SUBROUTINE GETNAM (XLATED, NNAM, FNAME, SNAME, IRET)
C-----------------------------------------------------------------------
C   Get list of names matching XLATED
C   Inputs:
C      XLATED   C*(*)      General file name (ENV:*.uuu)
C   Output
C      NNAM     I          Number names found
C      SNAME    C(*)*(*)   Found names - short form
C      FNAME    C(*)*(*)   Found names - full form (INV:oname.uuu)
C      IRET     I          error code
C-----------------------------------------------------------------------
      INTEGER   NNAM, IRET
      CHARACTER XLATED*(*), SNAME(*)*(*), FNAME(*)*(*)
C
      CHARACTER FILSPC*256, CNUM*4, CTEST*12
      HOLLERITH NAMES(3,128)
      INTEGER   JTRIM, FLEN, NMAX, J, I, N, K
      INCLUDE 'INCS:DMSG.INC'
      DATA NMAX /128/
C-----------------------------------------------------------------------
      NNAM = 0
      K = JTRIM (XLATED)
      CALL ZFULLN (XLATED, ' ', ' ', FILSPC, IRET)
      IF (IRET.NE.0) THEN
         J = MIN (48, JTRIM(XLATED))
         WRITE (MSGTXT,1000) IRET, 'TRANSLATING ' // XLATED(:J)
         GO TO 990
         END IF
      FLEN = JTRIM (FILSPC)
      CALL ZTXMA2 (FLEN, FILSPC, NMAX, 0, N, NAMES(1,1), IRET)
      IF (IRET.GT.1) THEN
         J = MIN (42, JTRIM(XLATED))
         WRITE (MSGTXT,1000) IRET, 'LISTING FILES IN ' // XLATED
         GO TO 990
         END IF
      IF (IRET.EQ.1) THEN
         N = 0
         IRET = 0
         END IF
      CNUM = XLATED(K-3:K)
      DO 20 I = 1,N
         CALL H2CHR (12, 1, NAMES(1,I), CTEST)
         J = JTRIM (CTEST)
         IF (J.GT.0) THEN
            NNAM = NNAM + 1
            SNAME(NNAM) = CTEST(:J)
            FNAME(NNAM) = XLATED(:K-5) // CTEST(:J) // CNUM
            END IF
 20      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('GETNAM ERROR',I4,' ON ',A)
      END
      SUBROUTINE OFMPLD (IRET)
C-----------------------------------------------------------------------
C     OFMPLD does the interactive display
C     Output:
C     IRET   I   error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INTEGER   MCOL
      PARAMETER (MCOL=16)
C
      INCLUDE 'OFMPL.INC'
      INTEGER   I, J, IGR, GRCHS(2), TOPSEP, SIDSEP, MTYPE, NCOL, TVBUT,
     *   NROWS(MCOL), NTITL, TIMLIM, CHS, NEDGE, IX1, IX2, IY1(4), K,
     *   IY2(5), IX(5), IY(5), TVCH(3,2), W, ITEMP, LX(1024), LY(1024),
     *   KX, KY, HALF, PW, LWINTV(4), JTRIM
      CHARACTER ISHELP*6, ROUTIN*6, TITLE*128, INAME*8
      LOGICAL   LEAVE(129)
      REAL      OFM(32736,3), IOFM(32736,3), SCL
      DATA LEAVE /129*.TRUE./
      DATA TVCH /2,3,4, 5,6,7/
      DATA LWINTV /4*0/
C-----------------------------------------------------------------------
      W = 1
      PW = W
C                                       open TV
      CALL TVOPEN (SCRTCH, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING TV DISPLAY'
         GO TO 990
         END IF
      ROUTIN ='YINIT'
      CALL YINIT (SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      IGR = 1 + NGRAY
      ROUTIN ='YSLECT'
      CALL YSLECT ('ONNN', IGR, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      IGR = IGR + 1
      CALL YSLECT ('ONNN', IGR, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      IGR = IGR + 2
      CALL YSLECT ('ONNN', IGR, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      DO 10 I = 1,3
         CALL YSLECT ('OFFF', TVCH(I,W), 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 980
         CALL YSLECT ('ONNN', TVCH(I,W), I, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 980
 10      CONTINUE
      CALL YSLECT ('OFFF', 1, 0, SCRTCH, IRET)
      IF (IRET.NE.0) GO TO 980
      CALL OFMIO ('READ', TVMOFM, TVMLOU, .FALSE., IOFM, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING NULL OFM'
         GO TO 980
      END IF
      I = 32736 * 3
      CALL RCOPY (I, IOFM, OFM)
      INAME = 'PLAIN'
      NNAME = NNAME + 3
      IF (DOIMAG) THEN
         NNAME = NNAME + 1
         SNAME(NNAME-3) = ' '
         SNAME(NNAME-2) = 'IMAGE'
      ELSE
         SNAME(NNAME-2) = ' '
         END IF
      SNAME(NNAME-1) = 'SWITCH'
      SNAME(NNAME) = 'EXIT'
      NCOL = MCOL
      I = (NNAME-1) / MCOL + 1
      CALL FILL (MCOL, I, NROWS)
      IF (NCOL*I.GT.NNAME) NROWS(MCOL) = NNAME - (MCOL-1)*I
 15   IF (NROWS(NCOL).LE.0) THEN
         NCOL = NCOL - 1
         NROWS(NCOL) = NROWS(NCOL) + NROWS(NCOL+1)
         GO TO 15
         END IF
      GRCHS(1) = 2
      GRCHS(2) = 1
      TOPSEP = 3
      SIDSEP = 10
      ISHELP = ' '
      TIMLIM = 0
      NTITL = 0
      MTYPE = 2
      NEDGE = MAX (2, (CSIZTV(1)+1)/2)
 30   I = 2 * (2 + NEDGE + (NCOL-1) * (1+NEDGE)) + CSIZTV(1) * 8 * NCOL
      I = MAX (I, 1028)
      J = 1.5 * CSIZTV(2) + 0.5
      J = TOPSEP + NROWS(1) * J + 2*NEDGE
      ITEMP = J
      J = J + 14 * CSIZTV(2) + 256
      CALL YWINDO ('READ', WINDTV, IRET)
      ROUTIN = 'YWINDO'
      IF (IRET.NE.0) GO TO 980
      I = (I - WINDTV(3) + WINDTV(1) + 1) / 2
      J = (J - WINDTV(4) + WINDTV(2) + 1) / 2
      IF ((I.GT.0) .OR. (J.GT.0)) THEN
         WINDTV(3) = WINDTV(3) + MAX (I,0)
         WINDTV(1) = WINDTV(1) - MAX (I,0)
         WINDTV(4) = WINDTV(4) + MAX (J,0)
         WINDTV(2) = WINDTV(2) - MAX (J,0)
         CALL YWINDO ('WRIT', WINDTV, IRET)
         IF (IRET.NE.0) GO TO 980
      END IF
      IF ((LWINTV(1).NE.WINDTV(1)) .OR. (LWINTV(2).NE.WINDTV(2))  .OR.
     *   (LWINTV(3).NE.WINDTV(3))  .OR. (LWINTV(4).NE.WINDTV(4))) THEN
         CALL COPY (4, WINDTV, LWINTV)
         IX1 = (WINDTV(3) + WINDTV(1)) / 2 - 513
         IX2 = IX1 + 1026
         IY1(1) = WINDTV(2) + CSIZTV(2)
         IY2(1) = IY1(1) + 66
         IY1(2) = IY2(1) + 2 * CSIZTV(2)
         IY2(2) = IY1(2) + 66
         IY1(3) = IY2(2) + 2 * CSIZTV(2)
         IY2(3) = IY1(3) + 66
         IY1(4) = IY2(3) + 2 * CSIZTV(2)
         IY2(4) = IY1(4) + 66
         IY2(5) = WINDTV(4) - ITEMP - 2*CSIZTV(2)
         IX(1) = IX1
         IX(2) = IX2
         IX(3) = IX2
         IX(4) = IX1
         IX(5) = IX1
         IGR = 4 + NGRAY
         CALL YZERO (IGR, IRET)
         ROUTIN = 'YZERO'
         IF (IRET.NE.0) GO TO 980
         ROUTIN = 'IMVECT'
         IF (W.EQ.1) THEN
            DO 40 J = 1,4
               IY(1) = IY1(J)
               IY(2) = IY1(J)
               IY(3) = IY2(J)
               IY(4) = IY2(J)
               IY(5) = IY1(J)
               CALL IMVECT ('ONNN', IGR, 5, IX, IY, SCRTCH, IRET)
               IF (IRET.NE.0) GO TO 980
 40         CONTINUE
         ELSE
            IY(1) = IY1(1)
            IY(2) = IY1(1)
            IY(3) = IY2(5)
            IY(4) = IY2(5)
            IY(5) = IY1(1)
            CALL IMVECT ('ONNN', IGR, 5, IX, IY, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
            END IF
         IF (DOIMAG) THEN
            IY(1) = IY1(1)
            IY(3) = IY2(5)
            CALL TVIMAG (IX, IY, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'DISPLAYING IMAGE'
               GO TO 990
               END IF
            KY = IY2(5) + 2
            KX = (IX1 + IX2) / 2.0 - 4.0*CSIZTV(1)
            K = 1
            CALL IMCHAR (K, KX, KY, 0, 0, INAME, SCRTCH, IRET)
            ROUTIN = 'IMCHAR'
            IF (IRET.NE.0) GO TO 980
            END IF
         END IF

C                                       title lines
      CALL TVMENU (MTYPE, NCOL, NROWS, GRCHS, TOPSEP, SIDSEP, ISHELP,
     *   SNAME, TIMLIM, LEAVE, NTITL, TITLE, CHS, TVBUT, SCRTCH, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'RETURNED FROM TVMENU'
         GO TO 990
         END IF
C                                       case statement
C                                       exit
      IF (SNAME(CHS).EQ.'EXIT') THEN
         MSGTXT = 'Bye-bye'
         CALL MSGWRT (2)
         GO TO 995
      ELSE IF (SNAME(CHS).EQ.' ') THEN
         GO TO 30
      ELSE IF (SNAME(CHS).EQ.'IMAGE') THEN
         ROUTIN ='YSLECT'
         W = 3
         CALL FILL (4, 0, LWINTV)
         CALL YSLECT ('ONNN', 1, 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 980
         DO 50 I = 1,3
            CALL YSLECT ('OFFF', TVCH(I,1), 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL YSLECT ('OFFF', TVCH(I,2), I, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
 50         CONTINUE
         CALL OFMIO ('WRIT', TVMOFM, TVMLOU, .FALSE., OFM, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITING OFM'
            GO TO 990
            END IF
         KY = IY2(5) + 2
         KX = (IX1 + IX2) / 2.0 - 4.0*CSIZTV(1)
         K = 1
         CALL IMCHAR (K, KX, KY, 0, 0, INAME, SCRTCH, IRET)
         ROUTIN = 'IMCHAR'
         IF (IRET.NE.0) GO TO 980
         GO TO 30
      ELSE IF (SNAME(CHS).EQ.'SWITCH') THEN
         ROUTIN ='YSLECT'
         IF (W.EQ.3) THEN
            W = PW
            CALL OFMIO ('WRIT', TVMOFM, TVMLOU, .FALSE., IOFM, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'RE-WRITING NULL OFM'
               GO TO 990
               END IF
         ELSE
            W = 3 - W
            END IF
         PW = W
         CALL YSLECT ('OFFF', 1, 0, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 980
         DO 60 I = 1,3
            CALL YSLECT ('OFFF', TVCH(I,3-W), 0, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL YSLECT ('ONNN', TVCH(I,W), I, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
 60         CONTINUE
         CALL FILL (4, 0, LWINTV)
         GO TO 30
         END IF
      CALL OFMDIR ('GET ', FNAME(CHS), TVMOFM, OFM, IRET)
      IF (IRET.NE.0) THEN
         J = MIN (52, JTRIM(FNAME(CHS)))
         WRITE (MSGTXT,1000) IRET, 'READING ' // FNAME(CHS)(:J)
         GO TO 990
         END IF
      INAME = SNAME(CHS)
      HALF = LUTOUT / 2
      IF (TVBUT.EQ.4) TVBUT = 3
      IF (TVBUT.GE.8) TVBUT = 4
C                                       step wedges
      IF (W.EQ.1) THEN
         SCL = MAXINT - 0.02
         DO 90 J = 1,3
            DO 80 I = 1,LUTOUT,2
               K = (I+1) / 2
               LX(K) = SCL * OFM(I,J) + 1.01
 80            CONTINUE
            LX(1) = 0
            KX = IX1 + 2
            KY = IY1(TVBUT) + 2
            K = TVCH(4-J,W)
            ROUTIN = 'YIMGIO'
            DO 85 I = KY,KY+63
               CALL YIMGIO ('WRIT', K, KX, I, 0, HALF, LX, IRET)
               IF (IRET.NE.0) GO TO 980
 85            CONTINUE
            KY = IY2(TVBUT) + 2
            KX = (IX1 + IX2) / 2.0 - 4.0*CSIZTV(1)
            CALL IMCHAR (K, KX, KY, 0, 0, SNAME(CHS), SCRTCH, IRET)
            ROUTIN = 'IMCHAR'
            IF (IRET.NE.0) GO TO 980
 90         CONTINUE
C                                       Plot
      ELSE IF (W.EQ.2) THEN
         DO 120 J = 1,3
            DO 110 I = 1,LUTOUT,2
               K = (I+1) / 2
               LX(K) = (K - 1.0) / HALF * (IX2-IX1-2.0) + IX1 + 2
               LY(K) = OFM(I,J) * (IY2(5)-IY1(1)-4) + IY1(1) + 2
 110           CONTINUE
            K = TVCH(4-J,W)
            CALL YZERO (K, IRET)
            ROUTIN = 'YZERO'
            IF (IRET.NE.0) GO TO 980
            ROUTIN = 'IMVECT'
            CALL IMVECT ('ONNN', K, HALF, LX, LY, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 980
            KY = IY2(5) + 2
            KX = (IX1 + IX2) / 2.0 - 4.0*CSIZTV(1)
            CALL IMCHAR (K, KX, KY, 0, 0, SNAME(CHS), SCRTCH, IRET)
            ROUTIN = 'IMCHAR'
            IF (IRET.NE.0) GO TO 980
 120     CONTINUE
C                                       image
      ELSE
         CALL OFMIO ('WRIT', TVMOFM, TVMLOU, .FALSE., OFM, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITING OFM'
            GO TO 980
            END IF
         KY = IY2(5) + 2
         KX = (IX1 + IX2) / 2.0 - 4.0*CSIZTV(1)
         K = 1
         CALL IMCHAR (K, KX, KY, 0, 0, INAME, SCRTCH, IRET)
         ROUTIN = 'IMCHAR'
         IF (IRET.NE.0) GO TO 980
         END IF
      GO TO 30
C
 980  WRITE (MSGTXT,1000) IRET, 'TV ERROR IN ' // ROUTIN
C
 990  CALL MSGWRT (8)
C
 995  CALL TVCLOS (SCRTCH, I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('OTFPLD ERROR',I4,' ON ',A)
      END
      SUBROUTINE TVIMAG (IX, IY, IRET)
C-----------------------------------------------------------------------
C   TVIMAG displays an image
C   Inputs:
C      IX     I(5)   X pixels of corners
C      IY     I(5)   Y pixels of corners
C   Outputs:
C      IRET   I      error code
C-----------------------------------------------------------------------
      INTEGER   IX(5), IY(5), IRET
C
      INCLUDE 'OFMPL.INC'
      INCLUDE 'INCS:PMAD.INC'
      INTEGER   LX(1024), I, KX, KY, K, NPIX, SAVEMX(2), INC(2), IROUND,
     *   IWIN(4), TYPE, LUN, IND, ITVC(4), JBUFSZ, NX(5), NY(5)
      REAL      IMGBUF(MABFSS)
      CHARACTER PHNAME*48
      INCLUDE 'INCS:DHDR.INC'
      SAVE NX, NY
      DATA LUN /43/
      DATA NX, NY /10*0/
C-----------------------------------------------------------------------
C                                       has it changed
      IND = 0
      IRET = 0
      IF (NX(1).NE.IX(1)) GO TO 20
      IF (NX(3).NE.IX(3)) GO TO 20
      IF (NY(1).NE.IY(1)) GO TO 20
      IF (NY(3).NE.IY(3)) GO TO 20
      GO TO 999
C                                       redo display
 20   CALL YZERO (1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'ZEROING IMAGE PLANE'
         GO TO 990
      END IF
      CALL COPY (5, IX, NX)
      CALL COPY (5, IY, NY)
C                                       step wedge
      DO 30 I = 1,LUTOUT,2
         K = (I+1)/2
         LX(K) = (MAXINT-0.02) * (I-1.0) / (LUTOUT-1.0) + 1.01
 30      CONTINUE
      LX(1) = 0
      KX = IX(1) + 2
      KY = IY(1) + 2
      K = 1
      NPIX = IX(2) - IX(1) - 3
      DO 40 I = KY,KY+15
         CALL YIMGIO ('WRIT', K, KX, I, 0, NPIX, LX, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITING IMAGE STEP WEDGE'
            GO TO 990
            END IF
 40      CONTINUE
      CALL COPY (2, MAXXTV, SAVEMX)
      MAXXTV(1) = IX(2) - IX(1) - 3
      MAXXTV(2) = IY(3) - IY(1) - 21
      INC(1) = IROUND (TXINC)
      INC(2) = IROUND (TYINC)
      TYPE = -1
      CALL FILL (4, 0, ITVC)
      CALL TVWIND (TYPE, INC, TBLC, TTRC, K, ITVC, IWIN, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'SETTING TV WINDOWS'
         GO TO 990
      END IF
      ITVC(1) = ITVC(1) + IX(1) + 2
      ITVC(3) = ITVC(3) + IX(1) + 2
      ITVC(2) = ITVC(2) + IY(1) + 20
      ITVC(4) = ITVC(4) + IY(1) + 20
      CALL COPY (2, SAVEMX, MAXXTV)
      CALL RNGSET (PIXR, CATR(KRDMX), CATR(KRDMN), CATR(IRRAN))
      CATBLK(IIVOL) = INDISK
      CATBLK(IICNO) = INCNO
      CALL CHR2H (2, FUNCT, 1, CATH(IITRA))
      JBUFSZ = 2 * MABFSS
      CALL ZPHFIL ('MA', INDISK, INCNO, 1, PHNAME, IRET)
      CALL ZOPEN (LUN, IND, INDISK, PHNAME, .TRUE., .TRUE., .TRUE.,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING IMAGE FILE'
         GO TO 990
         END IF
      CALL TVLOAD (LUN, IND, K, INC, ITVC, IWIN, JBUFSZ, IMGBUF,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'LOADING IMAGE TO TV'
         GO TO 990
         END IF
      GO TO 995
C
 990  CALL MSGWRT (8)
C
 995  IF (IND.GT.0) CALL ZCLOSE (LUN, IND, I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('TVIMAG ERROR',I4,' ON ',A)
      END
