LOCAL INCLUDE 'SNBLP.INC'
      INTEGER   NCODE
      PARAMETER (NCODE=4)
C                                       Local include for SNBLP
      INCLUDE 'INCS:PUVD.INC'
C                                       Input parameters
      REAL      XSIN, XDISIN, XNVER, XQUAL, XTIME(8), XBAND, XFREQ,
     *   XFQID, XSUBA, XBIF, XEIF, XANT(50), PIXR(2), XNCOU, XXINC,
     *   APARM(10), BPARM(10), CPARM(10), XDO3C, XPCNUM, XSYM,
     *   FACTOR, XDOBL, CUTOFF, XSCAN, XLABEL, XDOTV, XGRCH, XYRATO
      HOLLERITH XNAMEI(3), XCLAIN(2), XTYPE(1), XXSOUR(4,30), XXSTOK(1),
     *   XOPTY(1), XOPCOD(1)
      CHARACTER NAMEIN*12, CLAIN*6, TYPE*2, XSOUR(30)*16, XSTOK*4,
     *   OPTYPE*4, OPCODE*4
C                                       Program info
C
      INTEGER   MXSCAN
      PARAMETER (MXSCAN=5000)
C
      REAL      TSTART, TSTOP, XYSCL(2), XYOFF(2), XMX, XMN, XMXW, XMNW,
     *   GMMOD, RATFAC(MAXIF), SELBAN,XSTART, XSTOP, CHOUT(4), XXMIN,
     *   XXMAX, YYMIN, TSCAN(MXSCAN), PPMAX, YYMAX, PPMIN, PRAN(2,2),
     *   DO3COL, CSMIN, CSMAX
      INTEGER   SEQIN, DISKIN, CNOIN, IVER, BIF, ANTS(50), NCOUNT,
     *   ICODES(4), NCODES, NPARMS, NID, SID(500), NANTSL, NPLOTS,
     *   SUMSTK, ISTOK, FRQSEL, XINC, GRCHN, TVCHN, TVCORN(4),
     *   ISOU, OSOU, IANT, EIF, ITPLOT, ITVER, PCNUM, LABEL, SUBARR,
     *   MUMPOL, MUMIF, MUMANT, MTIMES, ISYM,
     *   BSYM, NANREC(MAXANT), ANTNUM(MAXANT), ANTNNN(MAXANT), NOSCAN,
     *   STRANS(MXSCAN)
      LOGICAL   DOAWNT, DOTV, NNODAT, DOLINE, SWAP
      DOUBLE PRECISION SELFRQ, GNRECD(XCLRSZ/2)
C                                       SN/CL table info
      INTEGER CLBUFF(512), NCLINR, NUMANT, NUMPOL, NUMIF, ICLRNO,
     *   KOLS(40), KOLTYP(40), KOLDIM(40), ICLUN, GNRECI(XCLRSZ),
     *   TIMKOL, INTKOL, SOUKOL, ANTKOL, SUBKOL, FRQKOL, IFRKOL,
     *   GEOKOL, DOPKOL, ATMKOL, DATKOL,
     *   MB1KOL, RE1KOL, IM1KOL, DL1KOL, RA1KOL, WT1KOL, RF1KOL,
     *   CK1KOL, DC1KOL, DS1KOL, DD1KOL,
     *   MB2KOL, RE2KOL, IM2KOL, DL2KOL, RA2KOL, WT2KOL, RF2KOL,
     *   CK2KOL, DC2KOL, DS2KOL, DD2KOL,
     *   REKOL(4), IMKOL(4), DLKOL(4), RAKOL(4), WTKOL(4),
     *   DOPLKL, DOP3KL, CLTIME
      REAL GNREC(XCLRSZ)
C                                       Constants
      DOUBLE PRECISION SIDER, CLIGHT
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XTYPE, XNVER,
     *   XXSOUR, XQUAL, XTIME, XXSTOK, XBAND, XFREQ, XFQID, XSUBA, XBIF,
     *   XEIF, XANT, PIXR, XNCOU, XXINC, XOPTY, XOPCOD, APARM, BPARM,
     *   CPARM, XDO3C, XPCNUM, XSYM, FACTOR, XDOBL, CUTOFF,
     *   XSCAN, XLABEL, XDOTV, XGRCH, XYRATO
      COMMON /VPARM/ SEQIN, DISKIN, CNOIN, IVER, BIF, EIF, ANTS, NCOUNT,
     *   ICODES, NCODES, NPARMS, GRCHN, TVCHN, TVCORN, ISOU, OSOU,
     *   IANT, ITPLOT, ITVER, PCNUM, DOTV, NNODAT, LABEL, CHOUT, DO3COL,
     *   DOLINE, NOSCAN, TSCAN, STRANS, SWAP
      COMMON /VGNCOM/ SELFRQ,
     *   TSTART, TSTOP, XYSCL, XYOFF, SELBAN, XMX, XMN, XMXW,
     *   XMNW, XSTART, XSTOP, GMMOD, RATFAC, NID, SID, NANTSL, PRAN,
     *   NPLOTS, DOAWNT, ISTOK, SUMSTK, FRQSEL, XINC,
     *   SUBARR, MUMPOL, MUMIF, MUMANT, MTIMES,
     *   XXMIN, XXMAX, YYMIN, YYMAX, PPMIN, PPMAX, ISYM,
     *   BSYM, NANREC, ANTNUM, ANTNNN, CSMIN, CSMAX
      COMMON /VGNCHR/ NAMEIN, CLAIN, TYPE, XSOUR, XSTOK, OPTYPE,
     *   OPCODE
      COMMON /TABCOM/ GNREC, CLBUFF, NCLINR, NUMANT, NUMPOL, NUMIF,
     *   ICLRNO, KOLS, KOLTYP, KOLDIM, ICLUN,
     *   REKOL, IMKOL, DLKOL, RAKOL, WTKOL,
     *   DOPLKL, DOP3KL, CLTIME
      COMMON /CONST/ SIDER, CLIGHT
      EQUIVALENCE (GNREC, GNRECD, GNRECI)
      EQUIVALENCE (KOLS(1), TIMKOL), (KOLS(2), INTKOL),
     *   (KOLS(3), SOUKOL), (KOLS(4), ANTKOL), (KOLS(5), SUBKOL),
     *   (KOLS(6), FRQKOL), (KOLS(7), IFRKOL),
     *   (KOLS(8), GEOKOL), (KOLS(9), DOPKOL), (KOLS(10), ATMKOL),
     *   (KOLS(11), DATKOL)
      EQUIVALENCE (KOLS(12), MB1KOL),
     *   (KOLS(13), RE1KOL), (KOLS(14), IM1KOL),
     *   (KOLS(15), RA1KOL), (KOLS(16), DL1KOL), (KOLS(17), WT1KOL),
     *   (KOLS(18), RF1KOL), (KOLS(19), CK1KOL), (KOLS(20), DC1KOL),
     *   (KOLS(21), DS1KOL), (KOLS(22), DD1KOL)
      EQUIVALENCE (KOLS(23), MB2KOL),
     *   (KOLS(24), RE2KOL), (KOLS(25), IM2KOL),
     *   (KOLS(26), RA2KOL), (KOLS(27), DL2KOL), (KOLS(28), WT2KOL),
     *   (KOLS(29), RF2KOL), (KOLS(30), CK2KOL), (KOLS(31), DC2KOL),
     *   (KOLS(32), DS2KOL), (KOLS(33), DD2KOL)
C                                                          End SNBLP
LOCAL END
      PROGRAM SNBLP
C-----------------------------------------------------------------------
C! Plots data from a SN or CL table in baseline form
C# UV Plot EXT-appl Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2018, 2020, 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   SNBLP plots SN or CL extension files. A 'PL' extension file is made
C   which can be displayed in the usual ways .
C   Inputs:
C      INNAME.....UV file name (name).       Standard defaults.
C      INCLASS....UV file name (class).      Standard defaults.
C      INSEQ......UV file name (seq. #).     0 => highest.
C      INDISK.....Disk unit #.               0 => any.
C      INEXT......'SN','TY','PC' or 'CL' table to be plotted
C      INVERS.....Version number of table to plot, 0=>highest no.
C      SOURCES....Source list.  '*' = all; a "-" before a source
C                 name means all except ANY source named.
C      TIMERANG...Time range of the data to be plotted. In order:
C                 Start day, hour, min. sec,
C                 end day, hour, min. sec. Days relative to ref.
C                 date.
C      STOKES.....The desired Stokes type of the output data:
C                 'R' = RCP, 'L' = LCP, 'DIFF' = difference
C      BIF........IF to plot
C      ANTENNAS...A list of the antennas to be plotted. All 0 => all.
C                 If any number is negative then all antennas listed
C                 are NOT to be plotted and all others are.
C      PIXRANGE...Limit the plot to values between PIXR(1) and
C                 PIXR(2).  The plots will not exceed the min/max in
C                 the actual gains.  Basically, if PIXR(1) < PIXR(2),
C                 all plots will be on the same scale and be limited
C                 to max (datamin, PIXR(1)) through min (datamax,
C                 PIXR(2)).  If PIXR(1) >= PIXR(2), each plot will be
C                 self-scaled individually.
C      NCOUNT.....Number of antennas to plot per page (try 5).
C      OPTYPE.....Data to be plotted: 'PHAS' = phase, 'AMP '=  ampl.,
C                 'DELA' = delay, 'RATE' = rate
C                 '    ' => 'PHAS'
C      OPCODE.....'IFDF' = IF difference, 'PLIF' = all IF's for
C                 specified antennas, ' ' = just OPTYPE
C      XTYPE......Variable data to be plotted against,
C                 1 = IAT time; 2 = elevation; 3 = HA, 4 = LST
C      DOTV     R      > 0 => TV, else plot file
C      GRCHAN   R      graphics channel to use
C-----------------------------------------------------------------------
C
      CHARACTER PRGN*6
      REAL      PLTPTS(2), TABPTS(2)
      LONGINT   PPLTPT, PTABPT
      INTEGER   IRET, MVAL, NWORDS, NROWS
      INCLUDE 'SNBLP.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA PRGN /'SNBLP '/
C-----------------------------------------------------------------------
C                                       Get input parameters
      CALL SNPIN (PRGN, NROWS, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       read data to figure out
C                                       distribution
      CALL SNPCNT (IRET)
C                                       allocate memory to hold table
      MUMANT = MAX (1, MUMANT)
      MVAL = 2 + MUMPOL*MUMIF*NCODES
      NWORDS = (MVAL * MUMANT * MTIMES - 1) / 1024  + 21
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, TABPTS, PTABPT, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'UNABLE TO GET DYNAMIC MEMORY'
         CALL MSGWRT (8)
         GO TO 990
         END IF
      NWORDS = (MVAL * MTIMES - 1) / 1024  + 21
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, PLTPTS, PPLTPT, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'UNABLE TO GET DYNAMIC MEMORY'
         CALL MSGWRT (8)
         GO TO 990
         END IF
C                                       Fetch data, determine scaling
      CALL SNPGET (MVAL, TABPTS(1+PTABPT), IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Do plots
      CALL SNPLOT (MVAL, MTIMES, TABPTS(1+PTABPT), PLTPTS(1+PPLTPT),
     *   IRET)
      IF (IRET.LT.0) IRET = 0
C                                       Close down
 990  CALL DIE (IRET, CLBUFF)
C
 999  STOP
      END
      SUBROUTINE SNPIN (PRGN, NROWS, IERR)
C-----------------------------------------------------------------------
C   Gets the inputs parameters for SNBLP.
C   Inputs:
C      PRGN    C*6  Program name
C   Output in common:
C      SUMSTK  I    Selected Stokes 0=both, 1=R, 2=L, 4=difference
C   Output:
C      IERR    I    Error code: 0 => ok
C      ISTOK   I    1 = R, 2 = L
C      ICODE   I    1='PHAS', 2='AMP ', 3='DELA', 4='RATE', 5='TSYS',
C                   6='SUM ', 7='DOPL', 8='SNR', 9='MDEL', 10='TANT',
C                   11='ATM', 12='GEO', 13='CCAL', 14='DDLY'
C                   15='REAL', 16='IMAG', 17='IFR', 18='PDIF',
C                   19='PSUM', 20=PGN ', 21='PON ', 22='POFF', 23='PSYS'
C                   24='PDGN', 25='PSGN', 26='POWR', 27='PODB'
C-----------------------------------------------------------------------
      INTEGER   NROWS, IERR
      CHARACTER PRGN*6
C
      INTEGER   NTPLT
      PARAMETER (NTPLT=5)
C
      INCLUDE 'SNBLP.INC'
      CHARACTER STAT*4, CODE(NCODE)*4, TYPTMP*2, TPLOT(NTPLT)*4
      INTEGER   IRET, BUFF(256), I, J, K, JERR, QUAL(30), NSOUR, LTYPE,
     *   BUFFER(512), IROUND, LUN, VER, NIF, NSTOK, FRQTMP, ICODE
      LOGICAL T, F, MATCH, ISTYPE
      DOUBLE PRECISION FOFF(MAXIF)
      INTEGER   ISBAND(MAXIF)
      REAL      FINC(MAXIF)
      CHARACTER BNDCOD(MAXIF)*8
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA CODE /'PHAS', 'AMP ', 'DELA', 'RATE'/
      DATA TPLOT /'ALIF', 'ALST', 'ALSI', 'IFDF', 'IFRA'/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
      OSOU = -1
      NPARMS = 242
C                                        Get input parameters.
      CALL SETUP (PRGN, NPARMS, XNAMEI, BUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (8)
         IRET = 8
         RQUICK = .FALSE.
         GO TO 990
         END IF
C                                       Decode inputs.
C                                       characters
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (2, 1, XTYPE, TYPE)
      CALL H2CHR (4, 1, XXSTOK, XSTOK)
      CALL H2CHR (4, 1, XOPTY, OPTYPE)
      CALL H2CHR (4, 1, XOPCOD, OPCODE)
      ISYM = IROUND (XSYM)
      IF ((ISYM.LE.0) .OR. (ISYM.GT.24)) ISYM = 1
      BSYM = IROUND (XDOBL)
      IF ((BSYM.GT.0) .AND. (BSYM.EQ.ISYM)) BSYM = MOD (ISYM, 24) + 1
C
      DO3COL = XDO3C
      IF (XDO3C.GT.1.5) DO3COL = -1.
      DO 20 I = 1,30
         CALL H2CHR (16, 1, XXSOUR(1,I), XSOUR(I))
         QUAL(I) = IROUND (XQUAL)
 20      CONTINUE
      IF (TYPE.EQ.' ') TYPE ='SN'
      CUTOFF = MAX (0.0, CUTOFF)
      XTYPE = HBLANK
      CALL CHR2H (2, TYPE, 1, XTYPE)
C                                       Integers
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
      IVER = IROUND (XNVER)
      NCOUNT = IROUND (XNCOU)
      IF (NCOUNT.LE.0) NCOUNT = 5
      XNCOU = NCOUNT
      XINC = IROUND (XXINC)
      IF (XINC.LE.0) XINC = 1
      PCNUM = IROUND (XPCNUM)
      IF (PCNUM.LE.0) PCNUM = 1
      XXINC = XINC
      DOLINE = FACTOR.LT.0.0
      FACTOR = ABS (FACTOR)
      IF ((.NOT.DOLINE) .AND. (FACTOR.LT.0.1)) FACTOR = 1.0
      IF (FACTOR.GT.10.0) FACTOR = 1.0
C                                       plot types
      IF (OPTYPE.EQ.'MULT') THEN
         NCODES = 0
         DO 25 I = 1,4
            ICODE = IROUND (APARM(I))
            IF ((ICODE.LT.1) .OR. (ICODE.GT.NCODE)) GO TO 26
            NCODES = NCODES + 1
            ICODES(NCODES) = ICODE
 25         CONTINUE
 26      IF (NCODES.LE.0) THEN
            MSGTXT = 'OPTYPE ''MULT'' HAS NO VALID TYPE CODES'
            CALL MSGWRT (8)
            IERR = 10
            GO TO 999
            END IF
      ELSE
         ICODE = 1
         DO 30 I = 1,NCODE
            IF (OPTYPE.EQ.CODE(I)) ICODE = I
 30         CONTINUE
         CALL CHR2H (4, CODE(ICODE), 1, XOPTY)
         NCODES = 1
         ICODES(1) = ICODE
         BPARM(1) = PIXR(1)
         CPARM(1) = PIXR(2)
         END IF
      ITPLOT = 0
      DO 35 I = 1,NTPLT
         IF (OPCODE.EQ.TPLOT(I)) ITPLOT = I
 35      CONTINUE
      IF (ITPLOT.GT.0) CALL CHR2H (4, TPLOT(ITPLOT), 1, XOPCOD)
      IF ((ITPLOT.LE.0) .OR. (ITPLOT.GT.3)) DO3COL = -1.0
C                                       Time range
      TSTART = XTIME(1) + (XTIME(2) / 24.0) + (XTIME(3) / (24.0*60.0)) +
     *   (XTIME(4) / (24.0*3600.0))
      TSTOP = XTIME(5) + (XTIME(6) / 24.0) + (XTIME(7) / (24.0*60.0)) +
     *   (XTIME(8) / (24.0*3600.0))
      IF (TSTART.GE.TSTOP) THEN
         TSTART = 0.0
         TSTOP = 999.0
         END IF
      DOTV = XDOTV.GT.0.0
      GRCHN = XGRCH + 0.01
      TVCHN = 1
      CALL FILL (4, 0, TVCORN)
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS(LABEL), 100)
      IF ((LTYPE.EQ.0) .OR. (LTYPE.GT.10)) LTYPE = 3
      IF (LTYPE.GT.7) LTYPE = 7
      IF ((LTYPE.GE.4) .AND. (LTYPE.LE.6)) LTYPE = 3
      IF (LABEL.LT.0) THEN
         LABEL = (LABEL/100)*100 - LTYPE
      ELSE
         LABEL = (LABEL/100)*100 + LTYPE
         END IF
C                                       Find input catalog
      CNOIN = 1
      TYPTMP = 'UV'
      CALL CATDIR ('SRCH', DISKIN, CNOIN, NAMEIN, CLAIN, SEQIN, TYPTMP,
     *   NLUSER, STAT, BUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      'UV', NLUSER
         GO TO 990
         END IF
C                                       Save name class etc.
      CALL CHR2H (12, NAMEIN, 1, XNAMEI)
      CALL CHR2H (6, CLAIN, 1, XCLAIN)
      XDISIN = DISKIN
      XSIN = SEQIN
C                                       Read catalog header
      STAT = 'WRIT'
      IF (DOTV) STAT = 'READ'
      CALL CATIO ('READ', DISKIN, CNOIN, CATBLK, STAT, BUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FCNO(NCFILE) = CNOIN
      FVOL(NCFILE) = DISKIN
      FRW(NCFILE) = 1
      IF (DOTV) FRW(NCFILE) = 0
      XDISIN = DISKIN
      CALL UVPGET (IERR)
      IF (IERR.NE.0) GO TO 990
      SEQIN = CATBLK(KIIMS)
      XSIN = SEQIN
C                                       Subarray
      SUBARR = IROUND (XSUBA)
      IF (SUBARR.EQ.0) SUBARR = 1
C                                       Freq id
      IF (XBAND.GT.0.0) SELBAN = XBAND
      IF (XFREQ.GT.0.0) SELFRQ = XFREQ
      FRQSEL = IROUND (XFQID)
      IF (FRQSEL.GE.0) THEN
         LUN = 25
         CALL FQMATC (DISKIN, CNOIN, CATBLK, LUN, SELBAN, SELFRQ, MATCH,
     *      FRQSEL, IERR)
         IF (.NOT.MATCH) THEN
            WRITE (MSGTXT,1070)
            IERR = 1
            GO TO 990
            END IF
         IF (IERR.GT.0) GO TO 999
         END IF
C                                       IF'S
      IF (JLOCIF.GE.0) THEN
         BIF = IROUND (XBIF)
         BIF = MAX (1, MIN (BIF, CATBLK(KINAX+JLOCIF)))
         EIF = IROUND (XEIF)
         IF (EIF.LT.BIF) EIF = CATBLK(KINAX+JLOCIF)
         IF (EIF.GT.CATBLK(KINAX+JLOCIF)) EIF = CATBLK(KINAX+JLOCIF)
      ELSE
         BIF = 1
         EIF = 1
         END IF
      IF ((ITPLOT.GE.4) .AND. (EIF.LE.BIF)) THEN
         MSGTXT = 'OPCODE IFDF/IFRA REQUESTED WITH 1 IF - CONTINUING'
         CALL MSGWRT (6)
         ITPLOT = 0
         OPCODE = ' '
         END IF
C                                       Look up sources
      NID = 500
      NSOUR = 30
      MSGSUP = 32000
      CALL SOURNU (XSOUR, QUAL, NSOUR, DISKIN, CNOIN, NID, BUFFER, SID,
     *   JERR)
      MSGSUP = 0
      IF (JERR.LT.0) THEN
         MSGTXT = 'SPECIFIED SOURCE(S) NOT FOUND - CONTINUING'
         CALL MSGWRT (6)
         END IF
      IF (JERR.NE.0) NID = 0
C                                       Check antennas desired.
      NANTSL = 0
      DOAWNT = T
      DO 70 J = 1,50
         ANTS(J) = IROUND (XANT(J))
         IF (ANTS(J).LT.0) DOAWNT = F
C                                       Make positive
         ANTS(J) = ABS (ANTS(J))
         IF (NANTSL.LT.1) GO TO 60
            DO 50 K = 1,NANTSL
               IF (ANTS(J).EQ.ANTS(K)) ANTS(J) = 0
 50            CONTINUE
C                                       Check for multiple entries
 60      IF (ABS (ANTS(J)).GE.1) NANTSL = J
 70      CONTINUE
C                                       Make sure not too many
      IF (NANTSL.GT.MAXANT) NANTSL = MAXANT
C                                       Get antenna names
      CALL GETANT (DISKIN, CNOIN, MAX (1, SUBARR), CATBLK, BUFFER, JERR)
      MUMANT = NSTNS
      IF (MUMANT.LE.1) THEN
         MUMANT = MAXANT
         TIMLAB = 'IAT'
         END IF
C                                       Rate scaling to Hz
      DO 71 I = BIF,EIF
         RATFAC(I-BIF+1) = FREQ
 71      CONTINUE
      IF ((OPTYPE.EQ.'RATE') .OR. (ISTYPE(4))) THEN
         VER = 1
         LUN = 25
         IF (FRQSEL.LE.0) FRQTMP = 1
         IF (FRQSEL.GT.0) FRQTMP = FRQSEL
         CALL CHNDAT ('READ', BUFFER, DISKIN, CNOIN, VER, CATBLK, LUN,
     *      NIF, FOFF, ISBAND, FINC, BNDCOD, FRQTMP, JERR)
         IF (JERR.EQ.0) THEN
            DO 72 I = BIF,EIF
               RATFAC(I-BIF+1) = FREQ + FOFF(I)
 72            CONTINUE
            END IF
         END IF
C                                       Check Stokes' (R or IPOL)
C                                       Set stokes request
      NSTOK = CATBLK(KINAX+JLOCS)
      MUMPOL = 1
      IF ((ICOR0.EQ.1) .OR. (ICOR0.EQ.-2) .OR. (ICOR0.EQ.-6) .OR.
     *   (((ICOR0.EQ.-1) .OR. (ICOR0.EQ.-5)) .AND. (NSTOK.EQ.1))) THEN
         ISTOK = ABS (ICOR0)
         SUMSTK = 1
         XSTOK = 'I'
         IF (ICOR0.EQ.-2) XSTOK='L'
         IF (ICOR0.EQ.-1) XSTOK='R'
      ELSE IF (XSTOK.EQ.'DIFF') THEN
         ISTOK = 1
         SUMSTK = 3
      ELSE IF (XSTOK.EQ.'RATO') THEN
         ISTOK = 1
         SUMSTK = 4
      ELSE IF (ICOR0.EQ.-1) THEN
         IF ((XSTOK.EQ.'R') .OR. (XSTOK.EQ.'RR')) THEN
            ISTOK = 1
            SUMSTK = 1
            XSTOK = 'R'
         ELSE IF ((XSTOK.EQ.'L') .OR. (XSTOK.EQ.'LL')) THEN
            ISTOK = 2
            SUMSTK = 2
            XSTOK = 'L'
         ELSE
            ISTOK = 1
            SUMSTK = 0
            XSTOK = 'R&L'
            MUMPOL = 2
            END IF
      ELSE IF (ICOR0.EQ.-5) THEN
         IF ((XSTOK.EQ.'V') .OR. (XSTOK.EQ.'VV')) THEN
            ISTOK = 1
            SUMSTK = 1
            XSTOK = 'V'
         ELSE IF ((XSTOK.EQ.'H') .OR. (XSTOK.EQ.'HH')) THEN
            ISTOK = 2
            SUMSTK = 2
            XSTOK = 'N'
         ELSE
            ISTOK = 1
            SUMSTK = 0
            XSTOK = 'V&H'
            MUMPOL = 2
            END IF
         END IF
      CALL CHR2H (4, XSTOK, 1, XXSTOK)
      IF ((SUMSTK.GE.3) .AND. (ITPLOT.GE.4)) THEN
         MSGTXT = 'CANNOT DIFFERENCE POLARIZATIONS AND IFS TOGETHER'
         CALL MSGWRT (6)
         ITPLOT = 0
         END IF
C                                       Open table to check
C                                       Open SN, CL, TY or PC table
      IF ((TYPE.EQ.'SN') .OR. (TYPE.EQ.'CL')) THEN
         CALL SNPOPN (NROWS, IERR)
         IF (IERR.NE.0) GO TO 999
C                                       Invalid table type
      ELSE
         IERR = 5
         MSGTXT = 'INVALID TABLE TYPE =' // TYPE
         GO TO 990
         END IF
      XNVER = IVER
      MUMIF = EIF - BIF + 1
      IF (ITPLOT.GE.4) MUMIF = 1
      XBIF = BIF
      XEIF = EIF
      CSMAX = -100000
      CSMIN = 1000000
      XXMIN = 1.E5
      XXMAX = -1.E5
      I = 2 * MAXIF * MAXANT
      PPMIN = 1.E8
      PPMAX = -PPMIN
      YYMIN = PPMIN
      YYMAX = PPMAX
      IF ((TSTART.GT.0.0) .AND. (TSTOP.LT.999.0)) THEN
         XXMIN = TSTART
         XXMAX = TSTOP
         END IF
      IF (XSCAN.GT.0.0) THEN
         LUN = 25
         CALL GETNX (LUN, DISKIN, CNOIN, CATBLK, SUBARR, BUFFER, NOSCAN,
     *      TSCAN)
      ELSE
         NOSCAN = 0
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR;',I7,'GETTING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',I3,
     *   ' TYPE=',A2,' USER=',I4)
 1040 FORMAT ('ERROR',I3,' COPYING CATALOG HEADER')
 1070 FORMAT ('NO MATCH TO SELBAND/SELFREQ ADVERBS - CHECK INPUTS')
      END
      SUBROUTINE SNPOPN (NROWS, IERR)
C-----------------------------------------------------------------------
C   Routine to open SN, CL table and get necessary information
C   Input from Common:
C      TYPE     C*2  'SN', 'CL'
C      DISKIN   I     Disk number
C      CNOIN    I     Catalog slot number
C      CATBLK   I(*)  Catalog header
C      SUMSTK   I     Stokes type requested 0=both, 1=R, 2=L,
C                     3=difference, 4=ratio
C   Output:
C      IERR     I     Error code, 0=OK else failed.
C   Output in common:
C      ICLRNO       I    Current cal record number
C      NCLINR       I    Number of gain records in file.
C      NUMANT       I    Number of antennas
C      NUMPOL       I    Number of polarizations
C      NUMIF        I    Number of IFs.
C      ITVER        I    Version number opened.
C      KOLS         I(*) Column pointers
C      KOLTYP       I(*) Column data types
C      KOLDIM       I(*) Column dimension
C-----------------------------------------------------------------------
      INTEGER   NROWS, IERR
      INCLUDE 'SNBLP.INC'
C
      INTEGER MAXPCC
      PARAMETER (MAXPCC = 33)
      CHARACTER KEYW(4)*8, COLHD1(11)*24, COLHD2(11)*24, COLHD3(11)*24,
     *   COLTAB(40)*24, COLHED(37)*24, KEYSN(4)*8
      INTEGER   NKEY, NREC, NCOL, DATP(128,2), IPOINT, KEYTYP(4),
     *   KLOCS(4), KEYVAL(6), I, KP, MSGSAV, KEYSUB(2,2), KEY(2,2),
     *   CLANT
      LOGICAL   T, ISTYPE, DOM
      REAL      KEYVR(6), FKEY(2,2)
      DOUBLE PRECISION KEYVAD
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DANS.INC'
      EQUIVALENCE (KEYVAL, KEYVR)
      EQUIVALENCE (COLHED(1), COLHD1), (COLHED(12), COLHD2),
     *   (COLHED(23), COLHD3)
      DATA COLHD1 /'TIME                    ',
     *   'TIME INTERVAL           ',
     *   'SOURCE ID               ', 'ANTENNA NO.             ',
     *   'SUBARRAY                ', 'FREQ ID                 ',
     *   'I.FAR.ROT               ',
     *   'GEODELAY                ', 'DOPPOFF                 ',
     *   'ATMOS                   ', 'DATMOS                  '/
      DATA COLHD2 /'MBDELAY1      ',
     *   'REAL1                   ', 'IMAG1                   ',
     *   'RATE 1                  ', 'DELAY 1                 ',
     *   'WEIGHT 1                ', 'REFANT 1                ',
     *   'CLOCK 1                 ', 'DCLOCK 1                ',
     *   'DISP 1                  ', 'DDISP 1                 '/
      DATA COLHD3 /'MBDELAY2      ',
     *   'REAL2                   ', 'IMAG2                   ',
     *   'RATE 2                  ', 'DELAY 2                 ',
     *   'WEIGHT 2                ', 'REFANT 2                ',
     *   'CLOCK 2                 ', 'DCLOCK 2                ',
     *   'DISP 2                  ', 'DDISP 2                 '/
      DATA KEYSN /'NO_ANT  ', 'NO_POL  ', 'NO_IF   ','MGMOD   '/
      DATA T /.TRUE./
      DATA FKEY /1.0,0.0,1.0,0.0/
      DATA KEYSUB /4*1/
C-----------------------------------------------------------------------
C                                       Open table
      ICLUN = 28
      NKEY = 0
      NREC = 0
      NCOL = 0
      ICLRNO = 1
      CALL TABINI ('READ', TYPE, DISKIN, CNOIN, IVER, CATBLK, ICLUN,
     *   NKEY, NREC, NCOL, DATP, CLBUFF, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1100) IERR, TYPE, IVER
         GO TO 980
         END IF
      ITVER = IVER
C                                       Get number of scans
      NCLINR = CLBUFF(5)
      NROWS = NCLINR
C                                       Check if empty
      IF (NCLINR.LE.0) THEN
         IERR = 6
         MSGTXT = 'ERROR: SELECTED TABLE IS EMPTY'
         CALL MSGWRT (8)
         GO TO 999
         END IF
C                                       Get column pointers
      NKEY = 33
      DO 10 I = 1,NKEY
         COLTAB(I) = COLHED(I)
 10      CONTINUE
      CALL FNDCOL (NKEY, COLTAB, 24, T, CLBUFF, KOLS, IERR)
      IF ((IERR.GE.1) .AND. (IERR.LE.10)) GO TO 999
      IERR = 0
C                                       Time column logical number
      CLTIME = KOLS(1)
      CLANT = KOLS(4)
C                                       Convert to pointers, types
      DO 20 I = 1,NKEY
         KP = KOLS(I)
         IF (KP.GT.0) THEN
            KOLS(I) = DATP(KP,1)
            KOLTYP(I) = MOD (DATP(KP,2), 10)
            KOLDIM(I) = DATP(KP,2) / 10
         ELSE
            KOLS(I) = -1
            KOLTYP(I) = -1
            KOLDIM(I) = 0
            END IF
 20      CONTINUE
C                                       Sort to time-ant if necessary
      IF ((CLBUFF(43).NE.KOLS(1)) .OR. (CLBUFF(44).NE.KOLS(4))) THEN
         MSGTXT = 'Sorting the ' // TYPE // ' table'
         CALL MSGWRT (3)
C                                       Close table
         CALL TABIO ('CLOS', 0, ICLRNO, KEYVR, CLBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         KEY(1,1) = CLTIME
         KEY(2,1) = 0
         KEY(1,2) = CLANT
         KEY(2,2) = 0
C                                       Sort
         CALL TABSRT (DISKIN, CNOIN, TYPE, IVER, IVER, KEY, KEYSUB,
     *      FKEY, CLBUFF, CATBLK, IERR)
         IF (IERR.NE.0) GO TO 999
C                                       Reopen table
         CALL TABINI ('READ', TYPE, DISKIN, CNOIN, IVER, CATBLK,
     *      ICLUN, NKEY, NREC, NCOL, DATP, CLBUFF, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1100) IERR, TYPE, IVER
            GO TO 980
            END IF
         END IF
C                                       Table keywords
      NKEY = 4
      DO 30 I = 1,NKEY
         KEYW(I) = KEYSN(I)
 30      CONTINUE
      MSGSAV = MSGSUP
      MSGSUP = 32000
      CALL TABKEY ('READ', KEYW, NKEY, CLBUFF, KLOCS, KEYVAL, KEYTYP,
     *   IERR)
      MSGSUP = MSGSAV
      IF ((IERR.GE.1) .AND. (IERR.LE.20)) GO TO 999
      IERR = 0
C                                       Retrieve keyword values: other
C                                       No. antennas.
      NUMANT = NSTNS
      IPOINT = KLOCS(1)
      IF (IPOINT.GT.0) NUMANT = KEYVAL(IPOINT)
C                                       No. poln.
      NUMPOL = 1
      IPOINT = KLOCS(2)
      IF (IPOINT.GT.0) NUMPOL = KEYVAL(IPOINT)
C                                       No. IF
      NUMIF = 1
      IPOINT = KLOCS(3)
      IF (IPOINT.GT.0) NUMIF = KEYVAL(IPOINT)
C                                       Mean gain modulus
      GMMOD = 1.0
      IPOINT = KLOCS(4)
      IF (IPOINT.GT.0) THEN
         IF (KEYTYP(4).EQ.1) THEN
            CALL DPCOPY (1, KEYVR(IPOINT), KEYVAD)
         ELSE
            KEYVAD = KEYVR(IPOINT)
            END IF
         IF (KEYVAD.GT.0.0) GMMOD = 1.0 / KEYVAD
         END IF
C                                       Set pointers
      DOPKOL = DOPKOL + BIF - 1
      DOP3KL = DOPKOL + EIF - 1
      DOPLKL = DOPKOL
C                                       1st poln
      IF ((ISTOK.EQ.ABS (ICOR0)) .OR. (ISTOK.EQ.ABS (ICOR0+4)) .OR.
     *   (SUMSTK.GE.3)) THEN
         REKOL(1) = RE1KOL + BIF - 1
         IMKOL(1) = IM1KOL + BIF - 1
         DLKOL(1) = DL1KOL + BIF - 1
         RAKOL(1) = RA1KOL + BIF - 1
         WTKOL(1) = WT1KOL + BIF - 1
         IF (ITPLOT.GE.4) THEN
            REKOL(3) = RE1KOL + EIF - 1
            IMKOL(3) = IM1KOL + EIF - 1
            DLKOL(3) = DL1KOL + EIF - 1
            RAKOL(3) = RA1KOL + EIF - 1
            WTKOL(3) = WT1KOL + EIF - 1
            END IF
C                                       2nd poln
      ELSE
         REKOL(1) = RE2KOL + BIF - 1
         IMKOL(1) = IM2KOL + BIF - 1
         DLKOL(1) = DL2KOL + BIF - 1
         RAKOL(1) = RA2KOL + BIF - 1
         WTKOL(1) = WT2KOL + BIF - 1
         IF (ITPLOT.GE.4) THEN
            REKOL(3) = RE2KOL + EIF - 1
            IMKOL(3) = IM2KOL + EIF - 1
            DLKOL(3) = DL2KOL + EIF - 1
            RAKOL(3) = RA2KOL + EIF - 1
            WTKOL(3) = WT2KOL + EIF - 1
            END IF
         END IF
C                                       2nd Poln
      REKOL(2) = RE2KOL + BIF - 1
      IMKOL(2) = IM2KOL + BIF - 1
      DLKOL(2) = DL2KOL + BIF - 1
      RAKOL(2) = RA2KOL + BIF - 1
      WTKOL(2) = WT2KOL + BIF - 1
      IF (ITPLOT.GE.4) THEN
         REKOL(4) = RE2KOL + EIF - 1
         IMKOL(4) = IM2KOL + EIF - 1
         DLKOL(4) = DL2KOL + EIF - 1
         RAKOL(4) = RA2KOL + EIF - 1
         WTKOL(4) = WT2KOL + EIF - 1
         END IF
C                                       Phase and amplitude
      DOM = .FALSE.
      IF ((ISTYPE(1)) .OR. (ISTYPE(2))) THEN
         IF ((REKOL(1).LT.0) .AND. (IMKOL(1).LT.0)) GO TO 500
         IF (((SUMSTK.GE.3) .OR. (MUMPOL.EQ.2)) .AND. ((REKOL(2).LT.0)
     *      .OR. (IMKOL(2).LT.0))) GO TO 500
         IF (ISTYPE(1)) THEN
            IF ((SUMSTK.GT.3) .OR. (ITPLOT.GT.4)) DOM = .TRUE.
            SUMSTK = MIN (SUMSTK, 3)
            ITPLOT = MIN (ITPLOT, 4)
            END IF
         END IF
C                                       Singleband Delay
      IF (ISTYPE(3)) THEN
         IF (DLKOL(1).LT.0) GO TO 500
         IF ((SUMSTK.GE.3) .AND. (DLKOL(2).LT.0)) GO TO 500
         IF ((MUMPOL.EQ.2) .AND. (DLKOL(2).LT.0)) GO TO 500
         IF ((SUMSTK.GT.3) .OR. (ITPLOT.GT.4)) DOM = .TRUE.
         SUMSTK = MIN (SUMSTK, 3)
         ITPLOT = MIN (ITPLOT, 4)
         END IF
C                                       Rate
      IF (ISTYPE(4)) THEN
         IF (RAKOL(1).LT.0) GO TO 500
         IF ((SUMSTK.GE.3) .AND. (RAKOL(2).LT.0)) GO TO 500
         IF ((MUMPOL.EQ.2) .AND. (RAKOL(2).LT.0)) GO TO 500
         IF ((SUMSTK.GT.3) .OR. (ITPLOT.GT.4)) DOM = .TRUE.
         SUMSTK = MIN (SUMSTK, 3)
         ITPLOT = MIN (ITPLOT, 4)
         END IF
      IF ((ITPLOT.LE.0) .OR. (ITPLOT.GE.4)) DO3COL = -1.0
      IF (DOM) THEN
         MSGTXT = '***  RATIO PLOT CHANGED TO DIFFERENCE PLOT'
         CALL MSGWRT (7)
         MSGTXT = '***  RATIO PLOTS DONE FOR AMPLITUDE ONLY'
         CALL MSGWRT (7)
         END IF
      GO TO 999
C                                       Requested data not in table
 500  WRITE(MSGTXT,1500) OPTYPE, TYPE
      IERR = 10
      GO TO 980
C                                       Error
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1100 FORMAT ('ERROR ',I3,' OPENING ',A,' TABLE NO. ',I3)
 1500 FORMAT (' REQUESTED DATA ',A,' NOT IN ',A,' TABLE ')
      END
      LOGICAL FUNCTION ISTYPE (FTYPE)
C-----------------------------------------------------------------------
C   ISTYPE inquires if type in list of requested types
C   Inputs:
C      FTYPE    I   Test type
C   Output:
C      ISTYPE   L   T => TYPE in ICODES
C-----------------------------------------------------------------------
      INTEGER   FTYPE
C
      INTEGER   I
      INCLUDE 'SNBLP.INC'
C-----------------------------------------------------------------------
      ISTYPE = .FALSE.
      DO 10 I = 1,NCODES
         IF (ICODES(I).EQ.FTYPE) ISTYPE = .TRUE.
 10      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE SNPCNT (IERR)
C-----------------------------------------------------------------------
C   SNPCNT reads the SN or CL table to find the number of samples for
C   each antenna
C   Input/Output in common:
C      TSTART   R      Start time of plot
C      TSTOP    R      Stop time of plot
C   Output:
C      IERR     I      Error code, 0=OK else failed
C   Outputs in common:
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'SNBLP.INC'
      LOGICAL   NODATA, OKAY
      INTEGER   I, NP, SCNT(MXSCAN)
      REAL      TB, TE, GTIME, XVARIB, CSOU, LTIME, TEPS
      REAL      VALUE(2*MAXIF,10)
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA TEPS /1.E-6/
C-----------------------------------------------------------------------
      CALL FILL (MAXANT, 0, NANREC)
      CALL FILL (MXSCAN, 0, SCNT)
      NODATA = .TRUE.
      TB = 1.0E5
      TE = -1.0E5
      IF ((TSTART.GT.0.0) .AND. (TSTOP.LT.999.0)) THEN
         TB = TSTART
         TE = TSTOP
         END IF
      XMX = TE
      XMN = TB
      XMXW = TE
      XMNW = TB
      MTIMES = 0
      LTIME = -1000.
C                                       Loop thru data
      NP = MUMPOL * MUMIF
      DO 100 ICLRNO = 1,NCLINR,XINC
         CALL TABIO ('READ', 0, ICLRNO, GNREC, CLBUFF, IERR)
         IF (IERR.LT.0) GO TO 100
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1010) IERR
            GO TO 990
            END IF
         CALL CHKREC (XVARIB, VALUE, CSOU, OKAY)
C                                       okay
         IF (OKAY) THEN
            IANT = GNRECI(ANTKOL)
            GTIME = XVARIB
            IF (GTIME-LTIME.GT.TEPS) THEN
               MTIMES = MTIMES + 1
               LTIME = GTIME
               END IF
C                                      Get start, stop times
            TB = MIN (TB, GTIME)
            TE = MAX (TE, GTIME)
            NODATA = .FALSE.
            NANREC(IANT) = NANREC(IANT) + 1
            I = CSOU + 0.1
            IF ((I.GT.0) .AND. (I.LE.MXSCAN)) SCNT(I) = SCNT(I) + 1
            END IF
 100     CONTINUE
      IERR = MAX (0, IERR)
      CALL FILL (MAXANT, 0, ANTNUM)
      CALL FILL (MAXANT, 0, ANTNNN)
      MUMANT = 0
      DO 120 I = 1,MAXANT
         IF (NANREC(I).GT.0) THEN
            MUMANT = MUMANT + 1
            ANTNUM(MUMANT) = I
            ANTNNN(I) = MUMANT
            END IF
 120     CONTINUE
C                                       source number translation
      NP = 0
      CALL FILL (MXSCAN, 0, STRANS)
      DO 130 I = 1,MXSCAN
         IF (SCNT(I).GT.0) THEN
            NP = NP + 1
            STRANS(I) = NP
            END IF
 130     CONTINUE
C
 990  IF (IERR.NE.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('SNPCNT: ERROR =',I3,' FROM TABIO')
      END
      SUBROUTINE CHKREC (XVARIB, VALUE, CSOU, OKAY)
C-----------------------------------------------------------------------
C   do standard process on SN/CL record
C   In/out in common
C      GNREC    R(*)   SN/CL record
C   Outputs:
C      XVARIB   R      Time
C      VALUE    R(*)   Data values
C      CSOU     R      Source number
C      OKAY     L      true => there is something to plot
C-----------------------------------------------------------------------
      INCLUDE 'SNBLP.INC'
      REAL    XVARIB, VALUE(2*MAXIF,*), CSOU
      LOGICAL OKAY
C
      INTEGER   I, IFNUM
      REAL      GTIME
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      OKAY = .FALSE.
C                                       Check weight per IF
C                                       If weight < CUTOFF them
C                                       set amp, phase, delay and
C                                       rate to FBLANK FOR EACH IF
      IF ((CUTOFF.GE.0.0) .AND. (WT1KOL.GT.0)) THEN
         IF (NUMPOL.EQ.2) THEN
            IF ((SUMSTK.EQ.0) .OR. (SUMSTK.GE.3)) THEN
               DO 5 IFNUM = 0, MUMIF - 1
                 IF (GNREC(WTKOL(1) + IFNUM).LE.CUTOFF) THEN
                    GNREC(REKOL(1) + IFNUM) = FBLANK
                    GNREC(IMKOL(1) + IFNUM) = FBLANK
                    GNREC(DLKOL(1) + IFNUM) = FBLANK
                    GNREC(RAKOL(1) + IFNUM) = FBLANK
                    END IF
                 IF (GNREC(WTKOL(2) + IFNUM).LE.CUTOFF) THEN
                    GNREC(REKOL(2) + IFNUM) = FBLANK
                    GNREC(IMKOL(2) + IFNUM) = FBLANK
                    GNREC(DLKOL(2) + IFNUM) = FBLANK
                    GNREC(RAKOL(2) + IFNUM) = FBLANK
                    END IF
 5               CONTINUE
            ELSE IF (SUMSTK.EQ.1) THEN
               DO 15 IFNUM = 0, MUMIF - 1
                  IF (GNREC(WTKOL(1) + IFNUM).LE.CUTOFF) THEN
                     GNREC(REKOL(1) + IFNUM) = FBLANK
                     GNREC(IMKOL(1) + IFNUM) = FBLANK
                     GNREC(DLKOL(1) + IFNUM) = FBLANK
                     GNREC(RAKOL(1) + IFNUM) = FBLANK
                     END IF
15                CONTINUE
            ELSE IF (SUMSTK.EQ.2) THEN
               DO 25 IFNUM = 0, MUMIF - 1
                 IF (GNREC(WTKOL(2) + IFNUM).LE.CUTOFF) THEN
                    GNREC(REKOL(2) + IFNUM) = FBLANK
                    GNREC(IMKOL(2) + IFNUM) = FBLANK
                    GNREC(DLKOL(2) + IFNUM) = FBLANK
                    GNREC(RAKOL(2) + IFNUM) = FBLANK
                    END IF
25                CONTINUE
               END IF
            END IF
         IF (NUMPOL.EQ.1) THEN
            DO 35 IFNUM = 0, MUMIF - 1
              IF (GNREC(WTKOL(1) + IFNUM).LE.CUTOFF) THEN
                 GNREC(REKOL(1) + IFNUM) = FBLANK
                 GNREC(IMKOL(1) + IFNUM) = FBLANK
                 GNREC(DLKOL(1) + IFNUM) = FBLANK
                 GNREC(RAKOL(1) + IFNUM) = FBLANK
                 END IF
 35           CONTINUE
            END IF
         END IF
C                                       Record within specified
C                                       time range ?
      IF (KOLTYP(CLTIME).EQ.1) THEN
         GTIME = GNRECD(TIMKOL)
      ELSE
         GTIME = GNREC(TIMKOL)
         END IF
      IF ((GTIME.LT.TSTART) .OR. (GTIME.GT.TSTOP)) GO TO 999
C                                       Freq id
      IF ((GNRECI(FRQKOL).GT.0) .AND. (GNRECI(FRQKOL).NE.FRQSEL)
     *    .AND. (FRQSEL.GT.0)) GO TO 999
C                                       Subarray
      IF ((GNRECI(SUBKOL).GT.0) .AND. (SUBARR.GT.0) .AND.
     *   (GNRECI(SUBKOL).NE.SUBARR)) GO TO 999
C                                       Antenna?
      IANT = GNRECI(ANTKOL)
      IF (NANTSL.GT.0) THEN
         DO 50 I = 1,NANTSL
            IF ((IANT.EQ.ANTS(I)).AND.DOAWNT) GO TO 60
            IF ((IANT.EQ.ANTS(I)).AND.(.NOT.DOAWNT)) GO TO 999
 50         CONTINUE
         IF (DOAWNT) GO TO 999
         END IF
C                                       Check source
 60   IF (NID.GT.0) THEN
         ISOU = GNRECI(SOUKOL)
         DO 70 I = 1,NID
            IF (ISOU.EQ.SID(I)) GO TO 80
 70         CONTINUE
         GO TO 999
         END IF
C                                       Get value
 80   CALL SNPDAT (VALUE, XVARIB, CSOU, OKAY)
      IF (XVARIB.EQ.FBLANK) OKAY = .FALSE.
C
 999  RETURN
      END
      SUBROUTINE SNPGET (NV, TABPTS, IERR)
C-----------------------------------------------------------------------
C   SNPGET reads the SN or CL table to load the memory
C   Input:
C      NV       I      Number values per time (source, X, n*Y)
C   Input/Output in common:
C      TSTART   R      Start time of plot
C      TSTOP    R      Stop time of plot
C   Output:
C      TABPTS   R(*)   Data to be plotted (NV, *)
C      IERR     I      Error code, 0=OK else failed
C   Outputs in common:
C-----------------------------------------------------------------------
      INTEGER   NV, IERR
      REAL      TABPTS(NV,*)
C
      LOGICAL   NODATA, OKAY
      INTEGER   I, NP, NN, IS, KK, NTIMES
      REAL      TB, TE, TMAX, TMIN, GTIME, XVARIB, CSOU, TEPS, LTIME
      INCLUDE 'SNBLP.INC'
      REAL      VALUE(2*MAXIF,10)
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA TEPS /1.E-6/
C-----------------------------------------------------------------------
      NODATA = .TRUE.
      TB = 1.0E5
      TE = -1.0E5
      IF ((TSTART.GT.0.0) .AND. (TSTOP.LT.999.0)) THEN
         TB = TSTART
         TE = TSTOP
         END IF
      XMX = TE
      XMN = TB
      XMXW = TE
      XMNW = TB
C                                       Loop thru data
      NP = MUMPOL * MUMIF
      NTIMES = 0
      LTIME = -1000.
      DO 100 ICLRNO = 1,NCLINR,XINC
         CALL TABIO ('READ', 0, ICLRNO, GNREC, CLBUFF, IERR)
         IF (IERR.LT.0) GO TO 100
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1010) IERR
            GO TO 990
            END IF
         CALL CHKREC (XVARIB, VALUE, CSOU, OKAY)
C                                       okay
         IF (OKAY) THEN
            IANT = GNRECI(ANTKOL)
            GTIME = XVARIB
            IF (GTIME-LTIME.GT.TEPS) THEN
               NTIMES = NTIMES + 1
               LTIME = GTIME
               END IF
C                                      Get start, stop times
            TB = MIN (TB, GTIME)
            TE = MAX (TE, GTIME)
            NODATA = .FALSE.
C                                       Put in array
            NN = NTIMES + (ANTNNN(IANT) - 1) * MTIMES
            IS = CSOU + 0.1
            IF ((IS.GT.0) .AND. (IS.LE.MXSCAN)) CSOU = STRANS(IS)
            TABPTS(1,NN) = CSOU
            TABPTS(2,NN) = XVARIB
            KK = 3
            DO 81 I = 1,NCODES
               CALL RCOPY (NP, VALUE(1,I), TABPTS(KK,NN))
               KK = KK + NP
 81            CONTINUE
            IF (ICODES(1).EQ.6) CALL RCOPY (NP, VALUE(1,2),
     *         TABPTS(KK,NN))
            XMX = MAX (XMX, XVARIB)
            XMN = MIN (XMN, XVARIB)
            XXMAX = MAX (XXMAX, XVARIB)
            XXMIN = MIN (XXMIN, XVARIB)
            CSMIN = MIN (CSMIN, CSOU)
            CSMAX = MAX (CSMAX, CSOU)
            END IF
 100     CONTINUE
      IERR = MAX (0, IERR)
C                                       Set actual X range
      SWAP = .FALSE.
      XSTART = TB
      XSTOP = TE
C                                       Check for no data
      IF (NODATA) THEN
         IERR = 6
         MSGTXT = 'NO DATA SELECTED'
         GO TO 990
         END IF
C                                       check and set scaling
      IF ((TSTART.GT.0.0) .AND. (TSTOP.LT.999.0)) THEN
         TMAX = (XSTOP + 0.03 * (XSTOP - XSTART)) * 360.0
         TMIN = (XSTART- 0.03 * (XSTOP - XSTART)) * 360.0
      ELSE
         TMAX = (XSTOP + 0.1 * (XSTOP - XSTART)) * 360.0
         TMIN = (XSTART- 0.1 * (XSTOP - XSTART)) * 360.0
         END IF
C                                       If start time is stop time,
      IF (ABS (TMAX-TMIN) .LT. 0.01) THEN
         TMIN = MAX( TMIN-0.005, 0.0)
         TMAX = TMIN + 0.01
         END IF
      TSTART = TB
      TSTOP = TE
      XYOFF(1) = TMIN
      XYSCL(1) = 1000.0 / (TMAX - TMIN)
      PRAN(1,1) = TMIN
      PRAN(2,1) = TMAX
C                                       Send back time range
      XTIME(1) = TSTART
      XTIME(2) = 0.0
      XTIME(3) = 0.0
      XTIME(4) = 0.0
      XTIME(5) = TSTOP
      XTIME(6) = 0.0
      XTIME(7) = 0.0
      XTIME(8) = 0.0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('SNPGET: ERROR =',I3,' FROM TABIO')
      END
      SUBROUTINE SNPDAT (VALUE, XVARIB, CSOU, OKAY)
C-----------------------------------------------------------------------
C   Routine to get the specified value from a SN/CL/TY table entry
C   Input from common:
C      GNREC    R(*)  Table record
C      ICODE    I     Plot code
C      SUMSTK   I     Selected Stokes 0=both, 1=R, 2=L, 3=Difference
C   Also uses pointers etc. set in SNPOPN
C   Output:
C      VALUE    R(*)   Table value, magic value blanked (amp on ICODE 6)
C      XVARIB   R      Value of associated x-axis variable
C      CSOU     R      source number
C      OKAY     L      Some values are good
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      REAL      VALUE(2*MAXIF,*), XVARIB, CSOU
      LOGICAL   OKAY
C
      INTEGER   IIS, IIF, IP1, IP2, LP, JP1, JP2, KK, ICODE, JIF
      LOGICAL   T, DORATO, DODIFF
      INCLUDE 'SNBLP.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA T /.TRUE./
C-----------------------------------------------------------------------
C                                       In case the data is bad
      LP = MUMPOL * MUMIF
      CALL XCALC (XVARIB, CSOU)
      DO 900 KK = 1,NCODES
         ICODE = ICODES(KK)
         CALL RFILL (LP, FBLANK, VALUE(1,KK))
         DODIFF = (ITPLOT.EQ.4) .OR. (SUMSTK.EQ.3)
         DORATO = (ITPLOT.EQ.5) .OR. (SUMSTK.EQ.4)
C                                       Select data type
C                                       Phase (deg)
         IF (ICODE.EQ.1) THEN
            DO 110 IIS = 1,MUMPOL
               LP = IIS - MUMPOL
               IP1 = REKOL(IIS) - 1
               JP1 = IMKOL(IIS) - 1
               IF (ITPLOT.GE.4) THEN
                  IP2 = REKOL(IIS+2) - 1
                  JP2 = IMKOL(IIS+2) - 1
               ELSE
                  IP2 = REKOL(2) - 1
                  JP2 = IMKOL(2) - 1
                  END IF
               DO 105 IIF = 1,MUMIF
                  IP1 = IP1 + 1
                  JP1 = JP1 + 1
                  IP2 =  IP2 + 1
                  JP2 = JP2 + 1
                  LP = LP + MUMPOL
                  IF ((GNREC(IP1).NE.FBLANK) .AND.
     *               (GNREC(JP1).NE.FBLANK)) THEN
                     IF (DODIFF) THEN
                        IF ((GNREC(IP2).NE.FBLANK) .AND.
     *                     (GNREC(JP2).NE.FBLANK)) THEN
                           VALUE(LP,KK) = 57.296 *
     *                        (ATAN2 (GNREC(JP1), GNREC(IP1) + 1.0E-20)
     *                        -ATAN2 (GNREC(JP2), GNREC(IP2) + 1.0E-20))
                           IF (VALUE(LP,KK).LE.-180.0) VALUE(LP,KK) =
     *                        VALUE(LP,KK) + 360.0
                           IF (VALUE(LP,KK).GT.+180.0) VALUE(LP,KK) =
     *                        VALUE(LP,KK) - 360.0
                           END IF
                     ELSE
                        VALUE(LP,KK) = 57.296 *
     *                     ATAN2 (GNREC(JP1), GNREC(IP1) + 1.0E-20)
                        END IF
                     END IF
 105              CONTINUE
 110           CONTINUE
C                                       Amplitude
         ELSE IF (ICODE.EQ.2) THEN
            DO 130 IIS = 1,MUMPOL
               LP = IIS - MUMPOL
               IP1 = REKOL(IIS) - 1
               JP1 = IMKOL(IIS) - 1
               IF (ITPLOT.GE.4) THEN
                  IP2 = REKOL(IIS+2) - 1
                  JP2 = IMKOL(IIS+2) - 1
               ELSE
                  IP2 = REKOL(2) - 1
                  JP2 = IMKOL(2) - 1
                  END IF
               DO 125 IIF = 1,MUMIF
                  IP1 = IP1 + 1
                  JP1 = JP1 + 1
                  IP2 =  IP2 + 1
                  JP2 = JP2 + 1
                  LP = LP + MUMPOL
                  IF ((GNREC(IP1).NE.FBLANK) .AND.
     *               (GNREC(JP1).NE.FBLANK)) THEN
                     IF (DORATO) THEN
                        IF ((GNREC(IP2).NE.FBLANK) .AND.
     *                     (GNREC(JP2).NE.FBLANK)) VALUE(LP,KK) =
     *                     SQRT ((GNREC(IP1)**2 + GNREC(JP1)**2) /
     *                     (GNREC(IP2)**2 + GNREC(JP2)**2+1.E-10))
                     ELSE IF (DODIFF) THEN
                        IF ((GNREC(IP2).NE.FBLANK) .AND.
     *                     (GNREC(JP2).NE.FBLANK)) VALUE(LP,KK) = GMMOD
     *                     * SQRT ((GNREC(IP1)-GNREC(IP2))**2  +
     *                     (GNREC(JP1)-GNREC(JP2))**2)
                     ELSE
                        VALUE(LP,KK) = GMMOD *
     *                     SQRT ((GNREC(IP1)**2) + (GNREC(JP1)**2))
                        END IF
                     END IF
 125              CONTINUE
 130           CONTINUE
C                                       Delay (sec)
         ELSE IF (ICODE.EQ.3) THEN
            DO 150 IIS = 1,MUMPOL
               LP = IIS - MUMPOL
               IP1 = DLKOL(IIS) - 1
               IF (ITPLOT.GE.4) THEN
                  IP2 = DLKOL(IIS+2) - 1
               ELSE
                  IP2 = DLKOL(2) - 1
                  END IF
               DO 145 IIF = 1,MUMIF
                  IP1 = IP1 + 1
                  IP2 =  IP2 + 1
                  LP = LP + MUMPOL
                  IF (GNREC(IP1).NE.FBLANK) THEN
                     IF (DODIFF) THEN
                        IF (GNREC(IP2).NE.FBLANK)
     *                     VALUE(LP,KK) = GNREC(IP1) - GNREC(IP2)
                     ELSE
                        VALUE(LP,KK) = GNREC(IP1)
                        END IF
                     END IF
 145              CONTINUE
 150           CONTINUE
C                                       Rate (Hz)
         ELSE IF (ICODE.EQ.4) THEN
            DO 170 IIS = 1,MUMPOL
               LP = IIS - MUMPOL
               IP1 = RAKOL(IIS) - 1
               IF (ITPLOT.GE.4) THEN
                  IP2 = RAKOL(IIS+2) - 1
                  JIF = IP2 - IP1 + 1
               ELSE
                  IP2 = RAKOL(2) - 1
                  END IF
               DO 165 IIF = 1,MUMIF
                  IP1 = IP1 + 1
                  IP2 = IP2 + 1
                  LP = LP + MUMPOL
                  IF (SUMSTK.EQ.3) JIF = IIF
                  IF (GNREC(IP1).NE.FBLANK) THEN
                     IF (DODIFF) THEN
                        IF (GNREC(IP2).NE.FBLANK) VALUE(LP,KK) =
     *                     RATFAC(IIF) * GNREC(IP1) -
     *                     RATFAC(JIF) * GNREC(IP2)
                     ELSE
                        VALUE(LP,KK) = GNREC(IP1) * RATFAC(IIF)
                        END IF
                     END IF
 165              CONTINUE
 170           CONTINUE
            END IF
 900     CONTINUE
C
      OKAY = .TRUE.
      LP = MUMPOL * MUMIF
      DO 910 IIS = 1,LP
         IF (VALUE(IIS,KK).NE.FBLANK) GO TO 999
 910     CONTINUE
      OKAY = .FALSE.
C
 999  RETURN
      END
      SUBROUTINE SNPLOT (NV, NT, TABPTS, PLTPTS, IRET)
C-----------------------------------------------------------------------
C   SNPLOT plots the data thru calls to PLTSN.
C   Input:
C      NV       I      Number values per antenna
C      NT       I      Number times in data array
C      TABPTS   R(*)   Data (NV,NT,*)
C   Output:
C      IRET     I      Return code, 0=OK else failed
C-----------------------------------------------------------------------
      INTEGER   NV, NT, IRET
      REAL      TABPTS(NV,NT,*), PLTPTS(NV,*)
C
      INTEGER   IPLOT, JPLT, IPLT, NPLT, DIFF, LUMIF, LIF1, LIF2, KK,
     *   LUMST, LST1, LST2, IIF, IIS, IA1, IA2
      LOGICAL   ONEIF, ONEST, DOIT
      INCLUDE 'SNBLP.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
      IRET = 0
      IPLOT = 0
      DIFF = MAX (1, SUMSTK-1)
      IF ((DIFF.EQ.1) .AND. (ITPLOT.GE.4)) DIFF = ITPLOT - 2
C                                       Loop thru stations to plot
      ONEST = (OPCODE.EQ.'ALST') .OR. (OPCODE.EQ.'ALSI')
      ONEIF = (OPCODE.EQ.'ALIF') .OR. (OPCODE.EQ.'ALSI')
      IF (ONEIF) THEN
         LUMIF = 1
         LIF1 = 1
         LIF2 = MUMIF
      ELSE
         LUMIF = MUMIF
         END IF
      IF (ONEST) THEN
         LUMST = 1
         LST1 = 1
         LST2 = MUMPOL
      ELSE
         LUMST = MUMPOL
         END IF
C                                       count the plots
      NPLOTS = 0
      IPLT = 0
      DO 50 IA1 = 1,MUMANT-1
         DO 40 IA2 = IA1+1,MUMANT
            DO 35 IIF = 1,LUMIF
               IF (.NOT.ONEIF) THEN
                  LIF1 = IIF
                  LIF2 = IIF
                  END IF
               DO 30 IIS = 1,LUMST
                  IF (.NOT.ONEST) THEN
                     LST1 = IIS
                     LST2 = IIS
                     END IF
                  DO 25 KK = 1,NCODES
                     CALL GETPLT (NV, NT, TABPTS, KK, IA1, IA2, LST1,
     *                  LST2, LIF1, LIF2, PLTPTS, DOIT)
                     IF (DOIT) THEN
                        CALL GETSCL (KK, LST1, LST2, LIF1, LIF2)
                        NPLOTS = NPLOTS + 1
                        END IF
 25                  CONTINUE
 30               CONTINUE
 35            CONTINUE
 40         CONTINUE
 50      CONTINUE
C                                       Now plot
      NPLT = 0
      DO 100 IA1 = 1,MUMANT-1
         DO 90 IA2 = IA1+1,MUMANT
            DO 80 IIF = 1,LUMIF
               IF (.NOT.ONEIF) THEN
                  LIF1 = IIF
                  LIF2 = IIF
                  END IF
               DO 70 IIS = 1,LUMST
                  IF (.NOT.ONEST) THEN
                     LST1 = IIS
                     LST2 = IIS
                     END IF
                  DO 60 KK = 1,NCODES
                     CALL GETPLT (NV, NT, TABPTS, KK, IA1, IA2, LST1,
     *                  LST2, LIF1, LIF2, PLTPTS, DOIT)
                     IF (DOIT) THEN
                        CALL GETSCL (KK, LST1, LST2, LIF1, LIF2)
                        NPLT = NPLT + 1
                        JPLT = NPLT
                        IPLOT = MOD (NPLT-1, NCOUNT) + 1
                        IF (NPLT.EQ.NPLOTS) IPLOT = -IPLOT
                        CALL PLTSN (IPLOT, KK, LST1, LST2, LIF1, LIF2,
     *                     IA1, IA2, DIFF, NV, PLTPTS, IRET)
                        IF (IRET.NE.0) GO TO 999
                        END IF
 60                  CONTINUE
 70               CONTINUE
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
C
 999  RETURN
      END
      SUBROUTINE GETPLT (NV, NT, TABPTS, KK, IA1, IA2, LST1, LST2, LIF1,
     *   LIF2, PLTPTS, DOIT)
C-----------------------------------------------------------------------
C   GETPLT converts selected table data to baseline form
C   Inputs:
C      NV       I      number values per sample
C      NT       I      number times
C      TABPTS   R(*)   table data
C      KK       I      parameter number
C      IA1      I      antenna relative number 1
C      IA2      I      antenna relative number 2
C      LST1     I      start Stokes this plot
C      LST2     I      end Stokes this plot
C      LIF1     I      start IF this plot
C      LIF2     I      end IF this plot
C   Outputs
C      PLTPTS   R(*)   plot array
C      DOIT     L      True -> valid data
C-----------------------------------------------------------------------
      INTEGER   NV, NT, KK, IA1, IA2, LST1, LST2, LIF1, LIF2
      REAL      TABPTS(NV,NT,*), PLTPTS(NV,*)
      LOGICAL   DOIT
C
      INCLUDE 'SNBLP.INC'
      INTEGER   IP, IST, IIF, IT
      REAL      X, YMX, YMN, PMX, PMN
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      DOIT = .FALSE.
      YMX = -1.E8
      YMN = -YMX
      PMX = YMX
      PMN = YMN
      DO 100 IT = 1,NT
         PLTPTS(1,IT) = TABPTS(1,IT,IA1)
         PLTPTS(2,IT) = TABPTS(2,IT,IA1)
         DO 90 IIF = LIF1,LIF2
            DO 80 IST = LST1,LST2
               IP = (IIF-1) * MUMPOL + IST + 2 + (KK-1) * MUMPOL * MUMIF
               IF ((TABPTS(IP,IT,IA1).EQ.FBLANK) .OR.
     *            (TABPTS(IP,IT,IA2).EQ.FBLANK)) THEN
                  PLTPTS(IP,IT) = FBLANK
C                                       amplitude
               ELSE
                  DOIT = .TRUE.
                  IF (ICODES(KK).EQ.2) THEN
                     X = TABPTS(IP,IT,IA1) * TABPTS(IP,IT,IA2)
                     PLTPTS(IP,IT) = X
                     YMX = MAX (YMX, X)
                     YMN = MIN (YMN, X)
                  ELSE
                     X = TABPTS(IP,IT,IA1) - TABPTS(IP,IT,IA2)
                     IF (ICODES(KK).EQ.1) THEN
                        IF (X.LT.-180.0) X = X + 360.0
                        IF (X.GT.180.0) X = X - 360.0
                        PLTPTS(IP,IT) = X
                        YMX = MAX (YMX, X)
                        YMN = MIN (YMN, X)
                        IF (X.LT.0.0) X = X + 360.0
                        PMX = MAX (PMX, X)
                        PMN = MIN (PMN, X)
                     ELSE
                        PLTPTS(IP,IT) = X
                        YMX = MAX (YMX, X)
                        YMN = MIN (YMN, X)
                        END IF
                     END IF
                  END IF
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
      YYMAX = YMX
      YYMIN = YMN
      PPMAX = PMX
      PPMIN = PMN
C
 999  RETURN
      END
      SUBROUTINE GETSCL (KK, LST1, LST2, LIF1, LIF2)
C-----------------------------------------------------------------------
C   GETSCL converts a number of max/min's to a scale
C   Inputs:
C      KK      I   parameter number
C      LST1    I   1st Stokes
C      LST2    I   Upper Stokes
C      LIF1    I   1st IF number
C      LIF2    I   1st IF number
C   Output in common
C      XYSCL   R(2)   Scaling - only 2nd one changed
C      XYOFF   R(2)   Offset  - only second one changed
C-----------------------------------------------------------------------
      INTEGER   KK, LST1, LST2, LIF1, LIF2
C
      INCLUDE 'SNBLP.INC'
      REAL      YMX, YMN, PMX, PMN, TMAX, TMIN, TDIF, TOLER(4), SIZEY
C                                       Minimum value range for each
C                                       ICODE
C                  phs    amp    delay    rate
      DATA TOLER /0.001, 0.001, 1.0E-12, 1.0E-8/
C-----------------------------------------------------------------------
      YMX = YYMAX
      YMN = YYMIN
      PMX = PPMAX
      PMN = PPMIN
      IF ((ICODES(KK).EQ.1) .AND. (PMX-PMN.LT.YMX-YMN)) THEN
         YMX = PMX
         YMN = PMN
         END IF
      SIZEY = 1000.0 / NCOUNT
      TMAX = YMX + 0.1 * (YMX - YMN)
      TMIN = YMN - 0.1 * (YMX - YMN)
      IF (ABS (TMAX-TMIN) .LT. TOLER(ICODES(KK))) THEN
         TMAX = TMAX + TOLER(ICODES(KK))
         TMIN = TMIN - TOLER(ICODES(KK))
         END IF
      TDIF = TMAX - TMIN
      IF (ABS (TDIF).LE.1.0E-25) TDIF = 1.0E-25
      XYOFF(2) = TMIN
      XYSCL(2) = 1000.0 / TDIF / NCOUNT
      PRAN(1,2) = TMIN
      PRAN(2,2) = TMAX
C
 999  RETURN
      END
      SUBROUTINE PLTSN (IPLOT, KK, LST1, LST2, LIF1, LIF2, IA1, IA2,
     *   DIFF, NV, PLTPTS, IRET)
C-----------------------------------------------------------------------
C   PLTSN actually plots data.
C   Input:
C      IPLOT    I      Plot number on current page. If neg. then this is
C                      last plot.
C      KK       I      Parameter number
C      LST1     I      1st Stokes this plot
C      LST2     I      last Stokes this plot
C      LIF1     I      1st IF this plot
C      LIF2     I      last IF this plot
C      ANTNO    I      Antenna number
C      DIFF     I      3/2 if plotting ratio/difference between Stokes
C                      parameters , 1 otherwise
C      NV       I      Number values
C      PLTPTS   R(*)   Data to plot (NV,*)
C   Output:
C      IRET     I      Return code, 0 => OK, otherwise abort.
C                       -1 => user request termination
C                        1 => failed to add to catalog
C                        2 => failed to create
C                        3 => graph file write error
C                        4 => UV file IO error
C-----------------------------------------------------------------------
      INTEGER   IPLOT, KK, LST1, LST2, LIF1, LIF2, IA1, IA2, DIFF, NV,
     *   IRET
      REAL      PLTPTS(NV,*)
C
      INCLUDE 'SNBLP.INC'
C
      CHARACTER TEXT*132, PFILE*48, ATIME*8, ADATE*12, CHTMP*18,
     *   AUNITS(NCODE,3)*8, CHTYPE(NCODE,3)*20, XUNITS*20,
     *   TXTMSG*80, CSAVE*5
      INTEGER   BUFFER(256), VER, IERR, ITYPE, IPSIZE, LUNPL, LTYPE,
     *   FINDPL, DEPTH(5), INCHAR, INP, IT(3), ID(3), IAXLAB, IAPLOT,
     *   I, NGOOD, NNOFIT, JCODE, NN, IP, IST, IIF, LDIFF, ILITY,
     *   JA1, JA2
      REAL      BLC(2), TRC(2), DX, DY, TR, VALUE, TI, XY(2),
     *   XTRC(2), XBLC(2), TLC(2), PLTINC, YYOFF(2), SIZE, XMULT(2),
     *   DBY, COLV, COL(3), COLR, AX(5), AY(5), OLDSRC
      LOGICAL   T, F, GOOD, CATUP, DONEG, DO3C, BLNKD, SCOLOR, DOCOLR
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DTVC.INC'
      SAVE XMULT, CSAVE, LTYPE, BUFFER
      DATA LUNPL /26/
      DATA DEPTH /5*1/
      DATA T, F /.TRUE.,.FALSE./
      DATA AUNITS /'Degrees','Gain','Seconds','Hz',
     *             'Degrees','Gain','Seconds','Hz',
     *             'Degrees','Ratio','Seconds','Hz'/
      DATA CHTYPE /'Gain phase', 'Gain amplitude', 'Delay', 'Rate',
C                                       differences
     *             'R-L phase diff','R-L amp diff','R-L delay diff',
     *             'R-L rate diff',
C                                       ratios
     *             ' ','R/L amp ratio',' ', ' '/
      DATA XUNITS /'IAT (hours)'/
C-----------------------------------------------------------------------
C                                       Time system from AN table
      SCOLOR = (XDO3C.GT.1.5) .AND. (CSMAX-CSMIN.GT.0.99)
      OLDSRC = -1000.0
      XUNITS(:3) = TIMLAB(1:3)
      NGOOD = 0
      NNOFIT = 0
      IRET = 3
      CATUP = T
      JA1 = ANTNUM(IA1)
      JA2 = ANTNUM(IA2)
C
      JCODE = ICODES(KK)
C                                       Create plot file
      IF (ABS (IPLOT).EQ.1) THEN
C                                       Update catalog header.
         VER = 0
         IRET = 1
         IF (.NOT.DOTV) THEN
            CALL MADDEX ('PL', DISKIN, CNOIN, CATBLK, BUFFER, CATUP,
     *         'WRIT', VER, IERR)
            IF (IERR.NE.0) THEN
               NCFILE = NCFILE - 1
               GO TO 999
               END IF
            END IF
         CALL ZPHFIL ('PL', DISKIN, CNOIN, VER, PFILE, IERR)
         IF (IERR.NE.0) GO TO 960
         IPSIZE = 0
         ITYPE = 57
         CALL GINIT (DISKIN, CNOIN, PFILE, IPSIZE, ITYPE, NPARMS,
     *      XNAMEI, DOTV, TVCHN, GRCHN, TVCORN, CATBLK, BUFFER, LUNPL,
     *      FINDPL, IERR)
         IRET = 2
         IF (IERR.NE.0) GO TO 960
         END IF
C                                       Graph drawing parameters.
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      IF (DOTV) THEN
         TRC(1) = WINDTV(3) - WINDTV(1)
         TRC(2) = WINDTV(4) - WINDTV(2)
         IF (DO3COL.LE.0.0) THEN
            CALL GCINIT (GPHTVG(4), 0, IERR)
            IF (IERR.NE.0) GO TO 960
            CALL GCINIT (GPHTVG(3), 0, IERR)
            IF (IERR.NE.0) GO TO 960
            END IF
         END IF
      PLTINC = TRC(2) / NCOUNT
      IF (XYRATO.LT.0.01) XYRATO = 1.0
C                                       Set window for current plot.
      XBLC(1) = BLC(1)
      XBLC(2) = TRC(2) - ABS (IPLOT) * PLTINC
      XTRC(1) = TRC(1)
      XTRC(2) = XBLC(2) + PLTINC - 1.0
      TLC(1) = XBLC(1)
      TLC(2) = XTRC(2)
C                                       Offsets for current plot.
      YYOFF(1) = XBLC(1)
      YYOFF(2) = XBLC(2)
C                                       fool with location common
      LOCNUM = 1
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 7
      AXTYP(LOCNUM) = 0
      TR = 1.1 * (PRAN(2,2)-PRAN(1,2))
      IF (TR.LE.0.0) TR = 1.0
      IF ((ABS(IPLOT).EQ.1) .OR. (NCODES.GT.1)) THEN
         TI = TR
         CALL METSCL (LABEL, TR, CPREF(2,LOCNUM), GOOD)
         XMULT(2) = TR / TI
         CSAVE = CPREF(2,LOCNUM)
         END IF
      CPREF(1,LOCNUM) = ' '
      XMULT(1) = 1.0
      DO 50 I = 1,2
         SIZE = XTRC(I) - XBLC(I) + 1
         TR = PRAN(2,I) - PRAN(1,I)
         XYSCL(I) = (XTRC(I) - XBLC(I)) / TR
         RPLOC(I,LOCNUM) = XBLC(I)
         RPVAL(I,LOCNUM) = XYOFF(I) * XMULT(I)
         AXINC(I,LOCNUM) = TR * XMULT(I) / (XTRC(I) - XBLC(I))
 50      CONTINUE
      CTYP(1,LOCNUM) = XUNITS
      CTYP(2,LOCNUM) = AUNITS(JCODE, DIFF)
      LDIFF = DIFF
      IF (ITPLOT.GE.4) LDIFF = 1
C                                       Init plot calls again
C                                       Number of characters on each
C                                       side of the plot
      IF (ABS (IPLOT).EQ.1) THEN
         CALL RFILL (4, 0.5, CHOUT)
C                                       Not fully initialized, may make
C                                       INP too large which is okay.
         CALL CHNTIC (XBLC, XTRC, INP)
         INP = MAX (INP, 3)
         IF (NCODES.GT.1) INP = MAX (INP, 7)
         LTYPE = MOD (ABS (LABEL), 100)
         IF (LTYPE.EQ.2) CHOUT(1) = 2.5
         IF (LTYPE.GT.2) CHOUT(1) = INP + 4
         IF (LTYPE.GT.1) CHOUT(2) = 2.0
         IF (LTYPE.GT.2) CHOUT(2) = CHOUT(2) + 1.333
         IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) CHOUT(4) = 3.333
         IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7))
     *      CHOUT(4) = CHOUT(4) + 1.333
C                                       Init for line drawing.
         CALL GINITL (BLC, TRC, XYRATO, CHOUT, DEPTH, BUFFER, IERR)
         IRET = 3
         IF (IERR.NE.0) GO TO 970
         IF (.NOT.DOTV) THEN
            WRITE (MSGTXT,1000) VER
            CALL MSGWRT (2)
            END IF
         END IF
      IRET = 3
      CATUP = T
C                                       Draw border
      CALL GLTYPE (1, BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      CALL GPOS (XBLC(1), XTRC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      CALL GVEC (XBLC(1), XBLC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      CALL GVEC (XTRC(1), XBLC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      CALL GVEC (XTRC(1), XTRC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      CALL GVEC (XBLC(1), XTRC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
C                                       Top labels: type & name
      IF ((ABS(IPLOT).EQ.1) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         DX = 0.0
         DY = 1.833
C                                       The second line of the header
         CALL GPOS (BLC(1), TRC(2), BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         INCHAR = 16
         INP = 1
         TEXT = CHTYPE(JCODE,LDIFF)
         IF (NCODES.GT.1) TEXT = 'Multiple'
         IF (ICOR0.LT.-4) THEN
            IF (TEXT(1:3).EQ.'R-L') THEN
               TEXT(1:3) = 'V-H'
            ELSE IF (TEXT(:3).EQ.'R/L') THEN
               TEXT(1:3) = 'V/H'
               END IF
            END IF
         CALL CHTRIM (TEXT, INCHAR, TEXT, INP)
         IF (ITPLOT.GE.4) THEN
            TEXT(INP+1:) = ' IF diff'
            IF (ITPLOT.EQ.5) TEXT(INP+1:) = ' IF ratio'
            INCHAR = 132
            CALL CHTRIM (TEXT, INCHAR, TEXT, INP)
            END IF
         INP = INP + 1
         TEXT(INP:INP+16) = ' vs '// TIMLAB(1:3) // ' time for '
         INP = INP + 17
C                                       File name
         CALL H2CHR (18, KHIMNO, CATH(KHIMN), CHTMP)
         CALL H2CHR (6, KHIMCO, CATH(KHIMC), CHTMP(13:18))
         CALL NAMEST (CHTMP, CATBLK(KIIMS), TEXT(INP:), INCHAR)
         CALL REFRMT (TEXT, ' ', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
C                                       the third line of header
         DY = 0.5
         CALL GPOS (BLC(1), TRC(2), BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         INP = 1
C
         WRITE (TEXT(INP:),1010) TYPE, ITVER
         INP = INP + 8
         IF (TYPE .EQ. 'PC') THEN
            WRITE (TEXT(INP:),1015) PCNUM
            INP = INP + 9
            END IF
C                                       Stokes and IF
         IF (LDIFF.EQ.1) THEN
            IF (SUMSTK.GT.0) THEN
               TEXT(INP:) = XSTOK(:1) // 'pol_'
               INP = INP + 7
            ELSE
               TEXT(INP:) = 'Rpol & Lpol_'
               IF (ICOR0.LT.-4) TEXT(INP:) = 'Vpol & Hpol_'
               INP = INP + 14
               END IF
            END IF
         IF (ITPLOT.GE.4) THEN
            WRITE (TEXT(INP:),1020) BIF, EIF
            INP = INP + 12
         ELSE IF (BIF.EQ.EIF) THEN
            WRITE (TEXT(INP:),1021) BIF
            INP = INP + 6
         ELSE
            WRITE (TEXT(INP:),1022) BIF, EIF
            INP = INP + 11
            END IF
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
C                                       Date/time/version
         IF ((LABEL.GT.0) .AND. (LTYPE.GT.1)) THEN
            DY = 0.5 + 2 * 1.333
C                                       the first line of the header
            CALL GPOS (BLC(1), TRC(2), BUFFER, IERR)
            IF (IERR.NE.0) GO TO 970
            CALL ZDATE (ID)
            CALL ZTIME (IT)
            CALL TIMDAT (IT, ID, ATIME, ADATE)
            WRITE (TEXT,1030) VER, ADATE, ATIME
            CALL REFRMT (TEXT, '_', INCHAR)
            CALL GCHAR (INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
         END IF
C                                       station ID
      CALL GPOS (XBLC(1), XTRC(2), BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      DX =  1.5
      DY = -1.8
      WRITE (TEXT,1040) JA1
      INP = 4
      TEXT(INP+1:) = STNNAM(JA1)
      CALL CHTRIM (TEXT, 132, TEXT, INP)
      INP = INP + 3
      WRITE (TEXT(INP:),1040) JA2
      INP = INP + 4
      TEXT(INP+1:) = STNNAM(JA2)
      CALL CHTRIM (TEXT, 132, TEXT, INP)
      INP = INP + 2
      IF (MUMPOL.LE.1) THEN
         TEXT(INP:) = XSTOK(:1)
         INP = INP + 1
      ELSE IF ((MUMIF.LE.1) .OR. (LIF1.NE.LIF2)) THEN
         IF (ICOR0.LT.-4) THEN
            TEXT(INP:) = 'VV'
            IF (LST1.EQ.2) TEXT(INP:) = 'HH'
         ELSE
            TEXT(INP:) = 'RR'
            IF (LST1.EQ.2) TEXT(INP:) = 'LL'
            END IF
         INP = INP + 2
         END IF
      CALL CHTRIM (TEXT, 132, TEXT, INCHAR)
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GICHAR (1, INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
C                                       Stokes, IF
      IF ((MUMIF.GT.1) .AND. (LIF1.EQ.LIF2)) THEN
         INP = 1
         WRITE (TEXT(INP:),1021) LIF1 + BIF - 1
         INP = INP + 5
         IF ((MUMPOL.GT.1) .AND. (LST1.EQ.LST2)) THEN
            IF (ICOR0.LT.-4) THEN
               TEXT(INP:) = 'VV'
               IF (LST1.EQ.2) TEXT(INP:) = 'HH'
            ELSE
               TEXT(INP:) = 'RR'
               IF (LST1.EQ.2) TEXT(INP:) = 'LL'
               END IF
            INP = INP + 2
            END IF
         CALL GPOS (XBLC(1), XTRC(2), BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         DX =  1.5
         DY = -3.133
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GICHAR (1, INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         END IF
C                                       type of plot
      IF (NCODES.GT.1) THEN
         TEXT = CHTYPE(JCODE,LDIFF)
         CALL CHTRIM (TEXT, INCHAR, TEXT, INP)
         CALL GPOS (XTRC(1), XTRC(2), BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         DX = -INP - 3.0
         DY = -2.8
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GICHAR (1, INCHAR, 0, DX, DY, TEXT, BUFFER, IERR)
         IF (IERR.NE.0) GO TO 970
         END IF
C                                       Set up location common
C                                       Blank bottom label.
      IF ((IPLOT.GE.0) .AND. (ABS (IPLOT).NE.NCOUNT)) THEN
         CPREF(1,LOCNUM) = ' '
         CTYP(1,LOCNUM) = ' '
         END IF
C                                       Only label Y axis once.
      IAXLAB = NCOUNT / 2 + 1
      IAPLOT = ABS (IPLOT)
      IF (NCODES.LE.1) THEN
         CPREF(2,LOCNUM) = CSAVE
         IF ((IAPLOT.NE.IAXLAB) .AND. ((IPLOT.GE.0) .OR.
     *      (IAPLOT.GT.IAXLAB))) CPREF(2,LOCNUM) = '-1'
         END IF
C                                       Put on labels and ticks
      CALL CLAB1 (XBLC, XTRC, CHOUT, LABEL, XYRATO, F, BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
C                                       Size of symbol.
      DBY = 0.5 * FACTOR
C                                       Loop
      ILITY = 4
      CALL GLTYPE (ILITY, BUFFER, IERR)
      IF (IERR.NE.0) GO TO 970
      COLR = (LIF2 - LIF1 + 1.0) * (LST2 - LST1 + 1.0) - 1.0
      DO3C = (DO3COL.GT.0.0) .AND. (COLR.GE.0.9)
      DOCOLR = DO3C .OR. SCOLOR
C                                       Outer loop: IF, stokes
      COLV = 0.0
      DO 200 IIF = LIF1,LIF2
         DO 190 IST = LST1,LST2
            IF (DO3COL.GT.0.0) THEN
               IF (DO3C) THEN
                  CALL COLOR3 (COLV, .FALSE., COL)
                  CALL G3VCOL (COL(1), COL(2), COL(3), BUFFER, IERR)
                  IF (IERR.NE.0) GO TO 970
                  COLV = COLV + 0.97 / COLR
               ELSE IF (2+IST.NE.ILITY) THEN
                  ILITY = 2 + IST
                  CALL GLTYPE (ILITY, BUFFER, IERR)
                  IF (IERR.NE.0) GO TO 970
                  END IF
               END IF
            IP = (IIF-1) * MUMPOL + IST + 2 + (KK-1) * MUMPOL * MUMIF
C                                       Point plot
            DO 120 NN = 1,MTIMES
               DONEG = JCODE.EQ.1
C                                       Scale X
               XY(1) = PLTPTS(2,NN)
               IF ((SWAP) .AND. (XY(1).GT.180.0)) XY(1) = XY(1) - 360.0
               XY(1) = XY(1) * 360.0
               XY(1) = XYSCL(1) * (XY(1) - XYOFF(1)) + YYOFF(1)
               IF ((XY(1).LT.XBLC(1)) .OR. (XY(1).GT.XTRC(1))) THEN
                  NNOFIT = NNOFIT + (LST2-LST1+1)*(LIF2-LIF1+1)
                  GO TO 120
                  END IF
C                                       source color
               IF ((SCOLOR) .AND. (ABS(PLTPTS(1,NN)-OLDSRC).GT.0.1))
     *            THEN
                  COLV = 0.97 * (PLTPTS(1,NN)-CSMIN) / (CSMAX-CSMIN)
                  CALL COLOR3 (COLV, .FALSE., COL)
                  CALL G3VCOL (COL(1), COL(2), COL(3), BUFFER, IERR)
                  IF (IERR.NE.0) GO TO 970
                  OLDSRC = PLTPTS(1,NN)
                  END IF
C                                       loop for points
               VALUE = PLTPTS(IP,NN)
C                                       ?????????????????
               IF (VALUE.NE.FBLANK) THEN
 110              XY(2) = VALUE
                  XY(2) = XYSCL(2) * (XY(2) - XYOFF(2)) + YYOFF(2)
                  IF ((XY(2).LT.XBLC(2)) .OR. (XY(2).GT.XTRC(2))) THEN
                     IF (DONEG) THEN
                        IF (VALUE.LT.0.) THEN
                           VALUE = VALUE + 360.
                        ELSE
                           VALUE = VALUE - 360.
                           END IF
                        DONEG = .FALSE.
                        GO TO 110
                     ELSE
                        NNOFIT = NNOFIT + 1
                        END IF
                  ELSE
                     NGOOD = NGOOD + 1
C                                       Mark point
                     DY = 5.0 * FACTOR
                     DX = 5.0 * FACTOR
                     IF (XYRATO.GT.1.0) THEN
                        DY = DY * XYRATO
                     ELSE
                        DX = DX / XYRATO
                        END IF
                     AX(1) = XY(1)
                     AY(1) = XY(2)
                     AX(2) = AX(1)
                     AX(3) = AX(1)
                     AX(4) = AX(1) - DX
                     AX(5) = AX(1) + DX
                     AY(2) = AY(1) + DY
                     AY(3) = AY(1) - DY
                     AY(4) = AY(1)
                     AY(5) = AY(1)
                     IF ((DO3COL.LE.0) .AND. (ILITY.NE.4)) THEN
                        ILITY = 4
                        CALL GLTYPE (ILITY, BUFFER, IERR)
                        IF (IERR.NE.0) GO TO 970
                        END IF
                     CALL PNTPLT (ISYM, AX, AY, XBLC, XTRC, .FALSE.,
     *                  DOCOLR, BUFFER, IERR)
                     IF (IERR.NE.0) GO TO 970
                     END IF
               ELSE IF (BSYM.GT.0) THEN
                  DY = 5.0 * FACTOR
                  DX = 5.0 * FACTOR
                  IF (XYRATO.GT.1.0) THEN
                     DY = DY * XYRATO
                  ELSE
                     DX = DX / XYRATO
                     END IF
                  XY(2) = XBLC(2) + DY
                  AX(1) = XY(1)
                  AY(1) = XY(2)
                  AX(2) = AX(1)
                  AX(3) = AX(1)
                  AX(4) = AX(1) - DX
                  AX(5) = AX(1) + DX
                  AY(2) = AY(1) + DY
                  AY(3) = AY(1) - DY
                  AY(4) = AY(1)
                  AY(5) = AY(1)
                  IF ((DO3COL.LE.0) .AND. (ILITY.NE.3)) THEN
                     ILITY = 3
                     CALL GLTYPE (ILITY, BUFFER, IERR)
                     IF (IERR.NE.0) GO TO 970
                     END IF
                  CALL PNTPLT (BSYM, AX, AY, XBLC, XTRC, .FALSE.,
     *               DOCOLR, BUFFER, IERR)
                  IF (IERR.NE.0) GO TO 970
                  END IF
 120           CONTINUE
C                                       Line plot
            IF (DOLINE) THEN
               BLNKD = .TRUE.
               DO 140 NN = 1,MTIMES
                  DONEG = JCODE.EQ.1
C                                       Scale X
                  XY(1) = PLTPTS(2,NN)
                  XY(1) = XY(1) * 360.0
                  XY(1) = XYSCL(1) * (XY(1) - XYOFF(1)) + YYOFF(1)
                  IF ((XY(1).LT.XBLC(1)) .OR. (XY(1).GT.XTRC(1)))
     *               GO TO 140
C                                       loop for points
                  VALUE = PLTPTS(IP,NN)
                  IF (VALUE.EQ.FBLANK) THEN
                     BLNKD = .TRUE.
                  ELSE
 130                 XY(2) = VALUE
                     XY(2) = XYSCL(2) * (XY(2) - XYOFF(2)) + YYOFF(2)
                     IF ((XY(2).LT.XBLC(2)) .OR. (XY(2).GT.XTRC(2)))
     *                  THEN
                        IF (DONEG) THEN
                           IF (VALUE.LT.0.) THEN
                              VALUE = VALUE + 360.
                           ELSE
                              VALUE = VALUE - 360.
                              END IF
                           DONEG = .FALSE.
                           GO TO 130
                           END IF
                     ELSE
                        NGOOD = NGOOD + 1
C                                       Mark point
                        IF (BLNKD) THEN
                           CALL GPOS (XY(1), XY(2), BUFFER, IERR)
                           BLNKD = .FALSE.
                        ELSE IF (DOCOLR) THEN
                           CALL G3VEC (XY(1), XY(2), BUFFER, IERR)
                        ELSE
                           CALL GVEC (XY(1), XY(2), BUFFER, IERR)
                           END IF
                        IF (IERR.NE.0) GO TO 970
                        END IF
                     END IF
 140              CONTINUE
               END IF
C                                       plot scan boundaries
            IF ((XSCAN.GT.0.0) .AND. (NOSCAN.GT.0)) THEN
               WRITE (TXTMSG,1150) NOSCAN
               CALL GCOMNT (-1, TXTMSG, BUFFER, IERR)
               IF (IERR.NE.0) GO TO 970
               I = 3
               CALL GLTYPE (I, BUFFER, IERR)
               IF (IERR.NE.0) GO TO 970
               AY(1) = XYSCL(2) * (PRAN(1,2)-XYOFF(2)) + YYOFF(2)
               AY(2) = XYSCL(2) * (PRAN(2,2)-XYOFF(2)) + YYOFF(2)
               IF (XSCAN.GE.1.5) AY(2) = AY(1) + 0.1*(AY(2)-AY(1))
               DO 160 I = 1,NOSCAN
                  AX(1) = XYSCL(1) * (TSCAN(I)*360.-XYOFF(1)) + YYOFF(1)
                  IF ((AX(1).GE.XBLC(1)) .AND. (AX(1).LE.XTRC(1))) THEN
                     CALL GPOS (AX(1), AY(1), BUFFER, IERR)
                     IF (IERR.NE.0) GO TO 970
                     CALL GVEC (AX(1), AY(2), BUFFER, IERR)
                     IF (IERR.NE.0) GO TO 970
                     END IF
 160              CONTINUE
               END IF
 190        CONTINUE
 200     CONTINUE
C                                       Done: finish plot
      WRITE (MSGTXT,1200) NGOOD
      CALL MSGWRT (2)
      IF (NNOFIT.GE.1) THEN
         WRITE (MSGTXT,1202) NNOFIT
         CALL MSGWRT (2)
         END IF
      IF ((IPLOT.GT.0) .AND. (ABS(IPLOT).LT.NCOUNT)) GO TO 210
         GPHPAG = IPLOT.GT.0
         CALL GFINIS (BUFFER, IERR)
         IF (IERR.GT.0) GO TO 975
         IF (.NOT.DOTV) THEN
            CALL HIPLOT (DISKIN, CNOIN, VER, BUFFER, IERR)
            IERR = 0
            END IF
 210  IF (IERR.GT.0) GO TO 975
         IRET = MIN (IERR, 0)
         GO TO 999
C                                       ZPHFIL or GINIT failure.
 960  WRITE (MSGTXT,1960)
      CALL MSGWRT (8)
      IF (.NOT.DOTV) THEN
         CALL DELEXT ('PL', DISKIN, CNOIN, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         NCFILE = NCFILE - 1
         END IF
      GO TO 999
C                                       Try to finish partial graph
 970  WRITE (MSGTXT,1970)
      CALL MSGWRT (6)
      WRITE (MSGTXT,1200) NGOOD
      CALL MSGWRT (2)
      IF (NNOFIT.GE.1) THEN
         WRITE (MSGTXT,1202) NNOFIT
         CALL MSGWRT (2)
         END IF
      GPHPAG = IPLOT.GT.0
      CALL GFINIS (BUFFER, IERR)
      IF (IERR.NE.0) GO TO 975
         IF (.NOT.DOTV) THEN
            CALL HIPLOT (DISKIN, CNOIN, VER, BUFFER, IERR)
            IERR = 0
            END IF
         GO TO 999
C                                       Destroy the plot file
 975  IF (.NOT.DOTV) THEN
         CALL ZCLOSE (LUNPL, FINDPL, IERR)
         CALL ZDESTR (DISKIN, PFILE, IERR)
         CALL DELEXT ('PL', DISKIN, CNOIN, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         NCFILE = NCFILE - 1
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Plot file version',I4,'  created.')
 1010 FORMAT (A2,I4,'_')
 1015 FORMAT ('NTONE ',I2)
 1020 FORMAT ('IF ',I2,' vs',I3)
 1021 FORMAT ('IF ',I2)
 1022 FORMAT ('IF ',I2,' - ',I2)
 1030 FORMAT ('Plot file version',I4,'__created ',A, A)
 1040 FORMAT (I3)
 1150 FORMAT ('Plotting',I4,' scan breaks')
 1200 FORMAT ('PLTSN:',I9,' points plotted')
 1202 FORMAT ('PLTSN:',I9,' points did not fit')
 1960 FORMAT ('PLTSN: ERROR DURING GRAPH FILE CREATION')
 1970 FORMAT ('PLTSN: ERROR DURING GRAPHING. WILL TRY TO FINISH ',
     *   'PARTIAL GRAPH')
      END
      SUBROUTINE XCALC (XVARIB, XSOU)
C-----------------------------------------------------------------------
C  Routine to use the source and antenna geometry information in order
C  to return the requested value of the x-variable against which the
C  data is to be plotted.
C  Inputs (in common):
C    XVAR        I       Type of variable to calculate:
C                        1 = time (easy)
C  Output:
C    XVARIB      R       Value of requested variable
C                        Time, LST (days)
C                        Elevation, HA (degrees)
C    XSOU        I       source number
C----------------------------------------------------------------------
      REAL    XVARIB, XSOU
C
      INTEGER CSOU
      DOUBLE PRECISION TIME
      INCLUDE 'SNBLP.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      CSOU = GNRECI(SOUKOL)
      XSOU = CSOU
C                                      Time
      IF (KOLTYP(CLTIME).EQ.1) THEN
         TIME = GNRECD(TIMKOL)
      ELSE
         TIME = GNREC(TIMKOL)
         END IF
      XVARIB = TIME
C
 999  RETURN
      END
