LOCAL INCLUDE 'RIRMS.INC'
C                                       Local include for RIRMS
      INCLUDE 'INCS:ZPBUFSZ.INC'
      HOLLERITH XNAMEI(3), XCLAIN(2), XSOUR(4,30), XCALC, XXSTOK,
     *   XLPNAM(12), XFUNC
      REAL      XSIN, XDISIN, XQUAL, XTIME(8), XBAND, XFREQ, XFQID,
     *   XANT(50), XBASE(50), XUVRA(2),  XSUBA, XBIF, XEIF, XBCHAN,
     *   XECHAN, XDOCAL, XGUSE, XDOPOL, XPDVER, XBLVER, XFLAG, XDOBND,
     *   XBPVER, XSMOTH(3), SOLINT, XNDIG, DOCRT, DOPLOT, FACTOR,
     *   XBOXES, CUTOFF, APARM(10), XDOTV, XGRCHN, XLABEL, BADD(10)
      REAL      FITPAR(10), CATOR(256), TIMBEG, TIMEND
      HOLLERITH CATOH(256)
      INTEGER   SEQIN, DISKIN, JBUFSZ, ILOCWT, CATOLD(256), INCSI,
     *   INCFI, INCIFI, OLDCNO, IXANT(50), IXBAS(50), NXANT, NXBAS,
     *   NSAMP, MAXSAM, NBOXES, GRCHAN, NPARM, IOPT, IDOPLT, NTIME,
     *   SCRBUF(256)
      LOGICAL   DESEL
      DOUBLE PRECISION VSUM, VSUMS, NSUMS, CATOD(128)
      CHARACTER NAMEIN*12, CLAIN*6, OPTYPE*4, FUNTYP*2, LPNAME*48,
     *   CSTOKE(2)*2
      EQUIVALENCE (CATOD, CATOH, CATOR, CATOLD)
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XSOUR, XQUAL, XCALC,
     *   XXSTOK, XTIME, XBAND, XFREQ, XFQID, XANT, XBASE, XUVRA, XSUBA,
     *   XBIF, XEIF, XBCHAN, XECHAN, XDOCAL, XGUSE, XDOPOL, XPDVER,
     *   XBLVER, XFLAG, XDOBND, XBPVER, XSMOTH, SOLINT, XNDIG, DOCRT,
     *   XLPNAM, DOPLOT, FACTOR, XBOXES, CUTOFF, XFUNC, APARM, XDOTV,
     *   XGRCHN, XLABEL, BADD
      COMMON /RIRMSS/ CATOLD, VSUM, VSUMS, NSUMS, SEQIN, DISKIN, ILOCWT,
     *   INCSI, INCFI,INCIFI, OLDCNO, IXANT, IXBAS, NXANT, NXBAS, DESEL,
     *   NSAMP, MAXSAM, NBOXES, GRCHAN, FITPAR, NPARM, IOPT, IDOPLT,
     *   TIMBEG, TIMEND, NTIME
      COMMON /CHARPM/ NAMEIN, CLAIN, OPTYPE, FUNTYP, LPNAME, CSTOKE
      COMMON /BUFRS/ SCRBUF, JBUFSZ
C                                       End local include for RIRMS
LOCAL END
      PROGRAM RIRMS
C-----------------------------------------------------------------------
C! Prints statistics of selected uv data and plots them
C# UV UV-util Calibration Plot
C-----------------------------------------------------------------------
C;  Copyright (C) 2020, 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   RIRMS prints statistics from a sample of uv data and plots
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input VU data.
C   full set of calibration adverbs
C      OPTYPE         OPTYPE        Type of data to process
C      SOLINT         SOLINT        Averaging time (min)
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, NWORDS, I
      LONGINT   PTIMAV, PTIMRM, PSUMS
      REAL      TIMAVG(2), TIMRMS(2), SUMS(2)
      LOGICAL   LAST
      INCLUDE 'RIRMS.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DANS.INC'
      DATA PRGM /'RIRMS '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL RIRMSI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       dynamic memory
      NTIME = (TIMEND - TIMBEG) / SOLINT + 1.5
      NWORDS = (NSTNS*NSTNS*2*NTIME - 1) / 1024 + 1
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, TIMAVG, PTIMAV, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', TSKNAM, NWORDS, TIMRMS,
     *   PTIMRM, IRET)
      NWORDS = (NSTNS*NSTNS*2*5 - 1) / 1024 + 1
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', TSKNAM, NWORDS, SUMS, PSUMS,
     *   IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'UNABLE TO GET NEEDED DYNAMIC MEMORY'
         CALL MSGWRT (8)
         GO TO 990
         END IF
C                                       read data
      CALL RIRMSR (NSTNS, SUMS(1+PSUMS), TIMAVG(1+PTIMAV),
     *   TIMRMS(1+PTIMRM), IRET)
      IF (IRET.NE.0) GO TO 990
C                                       matrix print
      CALL RIRMSM (NSTNS, SUMS(1+PSUMS), TIMAVG(1+PTIMAV),
     *   TIMRMS(1+PTIMRM), IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Plot vs time
      I = IDOPLT / 2
      LAST = IDOPLT.LT.2
      IF (MOD(I,2).EQ.1) CALL RIRMST (NSTNS, SUMS(1+PSUMS),
     *   TIMAVG(1+PTIMAV), TIMRMS(1+PTIMRM), LAST, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Plot histograms
      LAST = IDOPLT.LT.4
      IF (MOD(IDOPLT,2).EQ.1) CALL RIRMSH (1, NSTNS, SUMS(1+PSUMS),
     *   TIMAVG(1+PTIMAV), TIMRMS(1+PTIMRM), LAST, IRET)
      IF (IRET.NE.0) GO TO 990
      LAST = .TRUE.
      IF (IDOPLT.GT.3) CALL RIRMSH (2, NSTNS, SUMS(1+PSUMS),
     *   TIMAVG(1+PTIMAV), TIMRMS(1+PTIMRM), LAST, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Close down files, etc.
 990  IRET = MAX (0, IRET)
      CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE RIRMSI (PRGN, JERR)
C-----------------------------------------------------------------------
C   RIRMSI gets input parameters for RIRMS
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      JERR    I    Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C   Output in common:
C      INCSI   I  Input Stokes' increment in vis.
C      INCFI   I  Input frequency increment in vis.
C      INCIFI  I  Input IF increment in vis.
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      INTEGER   JERR
      CHARACTER PRGN*6
C
      CHARACTER STAT*4, PTYPE*2
      INTEGER   IROUND, IERR, INCX, I, NFREQ, LUN
      LOGICAL   MATCH
      REAL      CATR(256), RPARM(20)
      HOLLERITH CATH(256)
      DOUBLE PRECISION CATD(128)
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'RIRMS.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      EQUIVALENCE (CATBLK, CATR, CATH, CATD)
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 302
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1001) IERR
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF ((IERR.NE.0) .OR. (NPOPS.GT.NINTRN) .OR. (ISBTCH.EQ.32000))
     *   DOCRT = MIN (-1.0, DOCRT)
      CALL H2CHR (48, 1, XLPNAM, LPNAME)
      IF ((DOPLOT.EQ.0.0) .AND. (DOCRT.EQ.0.0)) DOCRT = -1.0
      IF (DOCRT.GT.0.0) RQUICK = .FALSE.
      IF (RQUICK) RQUICK = (LPNAME.NE.' ') .OR. (DOCRT.EQ.0.0)
      IF (RQUICK) CALL RELPOP (JERR, SCRBUF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (4, 1, XCALC, SELCOD)
      CALL H2CHR (4, 1, XXSTOK, STOKES)
      CALL H2CHR (2, 1, XFUNC, FUNTYP)
      DO 5 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 5       CONTINUE
      DO 10 I = 1,30
         CALL H2CHR (16, 1, XSOUR(1,I), SOURCS(I))
 10      CONTINUE
      SELQUA = IROUND (XQUAL)
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
      IDOPLT = IROUND (DOPLOT)
      IF (DOPLOT.GT.0) IDOPLT = MAX (1, IDOPLT)
      IF (FACTOR.LT.0.2) FACTOR = 1.0
      IF (CUTOFF.LT.0.3) CUTOFF = 3.0
C                                       Info for UVGET:
C                                       Put selection criteria into
C                                       correct common.
      UNAME = NAMEIN
      UCLAS = CLAIN
      UDISK = DISKIN
      USEQ = SEQIN
      DOCAL = XDOCAL.GT.0.0
      DOWTCL = DOCAL .AND. (XDOCAL.LE.99.0)
      IF (OPTYPE.EQ.'AUTO') THEN
         DOACOR = .TRUE.
         DOXCOR = .FALSE.
         OPTYPE = 'AMP'
         END IF
C                                       Set time range.
      CALL RCOPY (8, XTIME, TIMRNG)
      IF ((TIMRNG(1)+TIMRNG(2)+TIMRNG(3)+TIMRNG(4)) .EQ.0.0)
     *   TIMRNG(1)=-1.0E6
      IF ((TIMRNG(5)+TIMRNG(6)+TIMRNG(7)+TIMRNG(8)) .EQ.0.0)
     *   TIMRNG(5)=1.0E6
      TSTART = TIMRNG(1) + TIMRNG(2) / 24. + TIMRNG(3) / (24. * 60.) +
     *   TIMRNG(4) / (24. * 60. * 60.)
      TEND = TIMRNG(5) + TIMRNG(6) / 24. + TIMRNG(7) / (24. * 60.) +
     *   TIMRNG(8) / (24. * 60. * 60.)
      UVRNG(1) = XUVRA(1)
      UVRNG(2) = XUVRA(2)
      DOPOL = IROUND(XDOPOL)
      IF (XDOPOL.GT.0.0) DOPOL = MAX (1, DOPOL)
      PDVER = IROUND (XPDVER)
      DOAPPL = .FALSE.
      SUBARR = IROUND (XSUBA)
      IF (SUBARR.LE.0) SUBARR = 1
      FGVER = IROUND (XFLAG)
      DOBAND = IROUND (XDOBND)
      BPVER = IROUND (XBPVER)
      CALL RCOPY (3, XSMOTH, SMOOTH)
      CLVER = IROUND (XGUSE)
      CLUSE = IROUND (XGUSE)
      BLVER = IROUND (XBLVER)
      GRCHAN = XGRCHN + 0.1
C                                       Get CATBLK from old file.
      OLDCNO = 1
      PTYPE = 'UV'
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, STAT, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      NLUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'REST', SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING UV DATA HEADER'
         GO TO 990
         END IF
C                                       Save input CATBLK
      CALL COPY (256, CATBLK, CATOLD)
C                                       Get uv header info.
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
C                                       Test STOKES
      IF ((STOKES.NE.'RLLR') .AND. (STOKES.NE.'VHHV')) THEN
         STOKES = 'HALF'
         IF (CATD(KDCRV+JLOCS).EQ.-1.D0) THEN
            CSTOKE(1) = 'RR'
            CSTOKE(2) = 'LL'
         ELSE IF (CATD(KDCRV+JLOCS).EQ.-2.D0) THEN
            CSTOKE(1) = 'VV'
            CSTOKE(2) = 'HH'
            END IF
      ELSE
         IF (CATD(KDCRV+JLOCS).EQ.-1.D0) THEN
            CSTOKE(1) = 'RL'
            CSTOKE(2) = 'LR'
         ELSE IF (CATD(KDCRV+JLOCS).EQ.-2.D0) THEN
            CSTOKE(1) = 'VH'
            CSTOKE(2) = 'HV'
            END IF
         END IF

C                                       Channel selection?
      IF (JLOCIF.LT.0) THEN
         BIF = 1
         EIF = 1
      ELSE
         BIF = IROUND (XBIF)
         EIF = IROUND (XEIF)
         BIF = MIN (MAX (1, BIF), CATBLK(KINAX+JLOCIF))
         IF (EIF.LT.BIF) EIF = CATBLK(KINAX+JLOCIF)
         END IF
      NFREQ = CATBLK(KINAX+JLOCF)
      BCHAN = IROUND (XBCHAN)
      ECHAN = IROUND (XECHAN)
      IF ((BCHAN.LE.0) .OR. (BCHAN.GT.NFREQ)) BCHAN = 1
      IF ((ECHAN.LE.0) .OR. (ECHAN.GT.NFREQ)) ECHAN = NFREQ
      IF (BCHAN.GT.ECHAN) THEN
         MSGTXT = 'INVALID BCHAN AND ECHAN'
         CALL MSGWRT (6)
         JERR = 1
         GO TO 990
         END IF
C                                       Freq id
      IF (XBAND.GT.0.0) SELBAN = XBAND
      IF (XFREQ.GT.0.0) SELFRQ = XFREQ
      FRQSEL = IROUND (XFQID)
      IF (FRQSEL.EQ.0) FRQSEL = -1
      LUN = 28
      CALL FQMATC (DISKIN, OLDCNO, CATBLK, LUN, SELBAN, SELFRQ, MATCH,
     *   FRQSEL, JERR)
      IF (.NOT.MATCH) THEN
         MSGTXT = 'NO MATCH TO SELBAND/SELFREQ ADVERBS - CHECK INPUTS'
         JERR = 1
         GO TO 990
         END IF
      IF (JERR.GT.0) GO TO 999
C                                       Find baselines to copy
      CALL SETANT (50, XANT, XBASE, NXANT, NXBAS, IXANT, IXBAS, DESEL)
C                                       now using cal system -
C                                       UVGET makes header
      CALL UVGET ('INIT', RPARM, RPARM, JERR)
      IF (JERR.NE.0) THEN
         WRITE (MSGTXT,1035) JERR
         GO TO 990
         END IF
      CALL UVGET ('CLOS', RPARM, RPARM, IERR)
C                                       Save input file info
      INCX = CATBLK(KINAX)
      INCSI = INCS / INCX
      INCFI = INCF / INCX
      INCIFI = INCIF / INCX
C                                       antenna info
      CALL GETANT (DISKIN, OLDCNO, SUBARR, CATBLK, SCRBUF, JERR)
      IF (JERR.NE.0) THEN
         WRITE (MSGTXT,1000) JERR, 'READING ANTENNA FILE'
         GO TO 990
         END IF
C                                       Fill defaults for plots
      CALL RCOPY (2, UVRNG, XUVRA)
      XBCHAN = BCHAN
      XECHAN = ECHAN
      XBIF = BIF
      XEIF = EIF
C                                       number of times
      IF (SOLINT.LE.0.0) SOLINT = 0.1683333
      SOLINT = SOLINT / (60.0 * 24.0)
      CALL TBTIME (TIMBEG, TIMEND, JERR)
      IF (JERR.NE.0) THEN
         WRITE (MSGTXT,1000) JERR, 'FINDING DATA SET TIME RANGE'
         GO TO 990
         END IF
      CALL RFILL (8, 0.0, XTIME)
      XTIME(1) = TIMBEG
      XTIME(5) = TIMEND
C                                        Put input file in READ
      PTYPE = 'UV'
      CALL CATDIR ('CSTA', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, 'READ', SCRBUF, IERR)
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = OLDCNO
      FRW(NCFILE) = 0
      JERR = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('RIRMSI: ERROR',I3,' ON ',A)
 1001 FORMAT ('RIRMSI: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1035 FORMAT ('RIRMSI: UVGET INIT ERROR',I3,' CHECK ADVERBS')
      END
      SUBROUTINE RIRMSR (NANT, SUMS, TAVG, TRMS, IRET)
C-----------------------------------------------------------------------
C   RIRMSR reads the uv data and prepares a list of values with time
C   averaging (one or multiple times)
C   Input in common:
C      INCSI   I      Input Stokes increment in vis.
C      INCFI   I      Input frequency increment in vis.
C      INCIFI  I      Input IF increment in vis.
C   Input:
C      NANT    I      # antennas
C   Output:
C      SUMS    R(*)   Work array (NANT, NANT, 2pol, 3 sum sums wt)
C      TAVG    R(*)   Time sequence of averages
C      TRMS    r(*)   Time sequence of RMSes
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   NANT, IRET
      REAL      SUMS(NANT,NANT,2,3), TAVG(NANT,NANT,2,*),
     *   TRMS(NANT,NANT,2,*)
C
      INCLUDE 'RIRMS.INC'
      INTEGER   IA1, IA2, NV, NT
      REAL      BASEN, VIS(UVBFSS), RPARM(20), LTIME, TIME, T1, T2
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
C-----------------------------------------------------------------------
      NV = NANT * NANT * 2 * NTIME
      CALL RFILL (NV, FBLANK, TAVG)
      CALL RFILL (NV, FBLANK, TRMS)
      NV = NANT * NANT * 6
      CALL RFILL (NV, 0.0, SUMS)
      NSAMP = 0
C                                       Open and init for read
      CALL UVGET ('INIT', RPARM, VIS, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN/INIT INPUT VIS FILE'
         GO TO 990
         END IF
      CALL UVPGET (IRET)
      LTIME = -100.
      NV = 0
      T1 = TIMBEG
      T2 = T1 + SOLINT
      NT = 1
C                                       Read vis. record.
 100  CALL UVGET ('READ', RPARM, VIS, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ INPUT VIS FILE'
         GO TO 990
C                                       Loop over buffer
      ELSE IF (IRET.EQ.0) THEN
         IF (ILOCB.GE.0) THEN
            BASEN = RPARM(1+ILOCB)
            IA1 = BASEN / 256. + 0.1
            IA2 = BASEN - IA1*256. + 0.1
         ELSE
            IA1 = RPARM(1+ILOCA1) + 0.1
            IA2 = RPARM(1+ILOCA2) + 0.1
            END IF
         TIME = RPARM(1+ILOCT)
 110     IF (TIME.GT.T2) THEN
            IF (NV.GT.0.0) THEN
               IF (NT.GE.NTIME) GO TO 900
               CALL FIXIT (NANT, SUMS, NT, TAVG, TRMS, NSAMP)
               END IF
            T1 = T2
            T2 = T1 + SOLINT
            NV = 0
            IF (TIME.GT.TIMEND) GO TO 200
            NT = NT + 1
            GO TO 110
            END IF
C                                       call user routine
         CALL RIRMSG (IA1, IA2, NANT, VIS, SUMS, IRET)
C                                       Copy to output.
         IF (IRET.EQ.0) NV = NV + 1
C                                       Read next buffer.
         IRET = 0
         GO TO 100
         END IF
C                                       Close files
 200  CALL UVGET ('CLOS', RPARM, VIS, IRET)
C                                       close NX table
      IRET = 0
      IF (NSAMP.LE.0) THEN
         IRET = 10
         MSGTXT = 'NO DATA SAMPLES FOUND'
         GO TO 990
         END IF
      IF (NT.NE.NTIME-1) THEN
         WRITE (MSGTXT,1200) NTIME, NT
         CALL MSGWRT (6)
         NTIME = NT
         END IF
      GO TO 999
C
 900  WRITE (MSGTXT,1900) NT
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('RIRMSR: ERROR',I4,' ON ',A)
 1200 FORMAT ('RIRMSR EXPECTED',I8,' TIMES, READ',I8)
 1900 FORMAT ('RIRMSR: MAXIMUM NUMBER SAMPLES REACHED',I12)
      END
      SUBROUTINE RIRMSG (IA1, IA2, NANT, VIS, SUMS, IRET)
C-----------------------------------------------------------------------
C   Adds into the summing array on set of visibilities
C   Inputs:
C      IA1    I      Lower numbered antenna number
C      IA2    I      Higher numbered antenna number
C      NANT   I      Max antenna number
C      VIS    R(3,*) Visibilities in order real, imaginary, weight
C                    (Jy, Jy, unitless).  Weight <= 0 => flagged.
C   In/out:
C      SUMS   R(*)   Summing array (nant,nant,pol, v v^2 wt
C                       (ia1,ia2) gets imag,  (ia2,ia1) gets real
C   Inputs from COMMON:
C      INCSI      I    Input Stokes' increment in vis.
C      INCFI      I    Input frequency increment in vis.
C      INCIFI     I    Input IF increment in vis.
C   Output:
C      IRET       I    Return code  -1 => don't include
C                                    0 => OK
C-----------------------------------------------------------------------
      INTEGER   IA1, IA2, NANT, IRET
      REAL      VIS(3,*), SUMS(NANT,NANT,2,3)
C
      INTEGER   JIF, JF, JS, NIF, NF, NS, INDEXI
      REAL      VR, VI, VW, RR, RR2, RI, RI2, RW
      INCLUDE 'RIRMS.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
C-----------------------------------------------------------------------
      IRET = 0
C                                       pointers to traverse the data
      NS = 1
      NIF = 1
      NF = 1
      IF (JLOCS.GE.0) NS = CATBLK(KINAX+JLOCS)
      IF (JLOCIF.GE.0) NIF = CATBLK(KINAX+JLOCIF)
      IF (JLOCF.GE.0) NF = CATBLK(KINAX+JLOCF)
      DO 60 JS = 1,NS
         RW = 0.0
         RR = 0.0
         RI = 0.0
         RR2 = 0.0
         RI2 = 0.0
         DO 40 JIF = 1,NIF
            DO 30 JF = 1,NF
               INDEXI = (JIF-1) * INCIFI + (JF-1) * INCFI +
     *            (JS-1) * INCSI + 1
               VR = VIS(1,INDEXI)
               VI = VIS(2,INDEXI)
               VW = VIS(3,INDEXI)
               IF (VW.GT.0.0) THEN
                  RW = RW + VW
                  RR = RR + VW * VR
                  RR2 = RR2 + VW * VR * VR
                  RI = RI + VW * VI
                  RI2 = RI2 + VW * VI * VI
                  END IF
 30            CONTINUE
 40         CONTINUE
         IF (RW.LE.0.0) THEN
            IRET = IRET + 1
         ELSE
            SUMS(IA1,IA2,JS,1) = SUMS(IA1,IA2,JS,1) + RI
            SUMS(IA1,IA2,JS,2) = SUMS(IA1,IA2,JS,2) + RI2
            SUMS(IA1,IA2,JS,3) = SUMS(IA1,IA2,JS,3) + RW
            SUMS(IA2,IA1,JS,1) = SUMS(IA2,IA1,JS,1) + RR
            SUMS(IA2,IA1,JS,2) = SUMS(IA2,IA1,JS,2) + RR2
            SUMS(IA2,IA1,JS,3) = SUMS(IA2,IA1,JS,3) + RW
            END IF
 60      CONTINUE
      IF (IRET.LT.2) THEN
         IRET = 0
      ELSE
         IRET = -1
         END IF
C
 999  RETURN
      END
      SUBROUTINE FIXIT (NANT, SUMS, NT, TAVG, TRMS, NSAMP)
C-----------------------------------------------------------------------
C    FIXIT averages the real and imag sums and returns the desired value
C    Input
C       NANT    I      Number stations
C       NT      I      Time number
C    In/out:
C       SUMS    R(*)   Summing array  (0 on output)
C       TAVG    R(*)   Time sequence of averages
C       TRMS    R(*)   Time sequence of RMSes
C       NSAMP   I      Number good samples (+1 if there are any
C-----------------------------------------------------------------------
      INTEGER   NANT, NT, NSAMP
      REAL      SUMS(NANT,NANT,2,3), TAVG(NANT,NANT,2,*),
     *   TRMS(NANT,NANT,2,*)
C
      INTEGER   IA1, IA2, NGOOD, IP
      REAL      AVG, RMS
C-----------------------------------------------------------------------
      NGOOD = 0
      DO 100 IA1 = 1,NANT
         DO 90 IA2 = 1,NANT
            DO 80 IP = 1,2
               IF (SUMS(IA1,IA2,IP,3).GT.0.0) THEN
                  AVG = SUMS(IA1,IA2,IP,1) / SUMS(IA1,IA2,IP,3)
                  RMS = SUMS(IA1,IA2,IP,2) / SUMS(IA1,IA2,IP,3) -
     *               AVG * AVG
                  RMS = SQRT (MAX (0.0, RMS))
                  NGOOD = NGOOD + 1
                  TAVG(IA1,IA2,IP,NT) = AVG
                  TRMS(IA1,IA2,IP,NT) = RMS
                  END IF
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
      IF (NGOOD.GT.0) NSAMP = NSAMP + 1
      IP = 2 * NANT * NANT
      CALL RFILL (IP, 0.0, SUMS)
C
 999  RETURN
      END
      SUBROUTINE RIRMSM (NANT, SUMS, TAVG, TRMS, IRET)
C-----------------------------------------------------------------------
C   RIRMSM averages the data in TAVG and TRMS over time with the result
C   in SUMS.  It then prints matrices of the values
C   Input:
C      NANT    I      # antennas
C      TAVG    R(*)   Time sequence of averages
C      TRMS    r(*)   Time sequence of RMSes
C   Output:
C      SUMS    R(*)   Work array (NANT, NANT, 2pol, 3 sum sums wt)
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   NANT, IRET
      REAL      SUMS(NANT,NANT,2,5), TAVG(NANT,NANT,2,*),
     *   TRMS(NANT,NANT,2,*)
C
      INCLUDE 'RIRMS.INC'
      INTEGER   IA1, IA2, I, IP, IT, NP(2), NDIG, NN, MM, J, K, M1, M2,
     *   MANT, IROUND, LUNP, FINDP, NACROS, PAGE, IPCNT
      REAL      V, W, R, MAXAA, MINAA, MAXRA, MAXAR, MINAR, MAXRR,
     *   XX, XM, SCALE
      CHARACTER STRING*6, TITLE(4)*14, TITL1*132, TITL2*132, LINE*132,
     *   CSCR*132
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA TITLE/'Mean of means', 'RMS of means', 'Mean of RMSes',
     *   'RMS of RMSes'/
C-----------------------------------------------------------------------
C                                       do the average: sum
      I = NANT * NANT * 10
      CALL RFILL (I, 0.0, SUMS)
      DO 40 IT = 1,NTIME
         DO 30 IP = 1,2
            DO 20 IA2 = 1,NANT
               DO 10 IA1 = 1,NANT
                  IF ((TAVG(IA1,IA2,IP,IT).NE.FBLANK) .AND.
     *               (TRMS(IA1,IA2,IP,IT).NE.FBLANK)) THEN
                     V = TAVG(IA1,IA2,IP,IT)
                     SUMS(IA1,IA2,IP,1) = SUMS(IA1,IA2,IP,1) + V
                     SUMS(IA1,IA2,IP,2) = SUMS(IA1,IA2,IP,2) + V * V
                     V = TRMS(IA1,IA2,IP,IT)
                     SUMS(IA1,IA2,IP,3) = SUMS(IA1,IA2,IP,3) + V
                     SUMS(IA1,IA2,IP,4) = SUMS(IA1,IA2,IP,4) + V * V
                     SUMS(IA1,IA2,IP,5) = SUMS(IA1,IA2,IP,5) + 1
                     END IF
 10               CONTINUE
 20            CONTINUE
 30         CONTINUE
 40      CONTINUE
C                                       now average
      MAXAA = -10.**10
      MINAA = -MAXAA
      MAXRA = MAXAA
      MAXAR = -10.**10
      MINAR = -MAXAA
      MAXRR = MAXAA
      NP(1) = 0
      NP(2) = 0
      DO 80 IP = 1,2
         DO 70 IA2 = 1,NANT
            DO 60 IA1 = 1,NANT
               W = SUMS(IA1,IA2,IP,5)
               IF (W.GT.0) THEN
                  NP(IP) = NP(IP) + 1
                  V = SUMS(IA1,IA2,IP,1) / W
                  R = SUMS(IA1,IA2,IP,2) / W - V * V
                  R = SQRT (MAX (0.0, R))
                  SUMS(IA1,IA2,IP,1) = V
                  SUMS(IA1,IA2,IP,2) = R
                  MAXAA = MAX (MAXAA, V)
                  MAXRA = MAX (MAXRA, R)
                  MINAA = MIN (MINAA, V)
                  V = SUMS(IA1,IA2,IP,3) / W
                  R = SUMS(IA1,IA2,IP,4) / W - V * V
                  R = SQRT (MAX (0.0, R))
                  SUMS(IA1,IA2,IP,3) = V
                  SUMS(IA1,IA2,IP,4) = R
                  MAXAR = MAX (MAXAR, V)
                  MAXRR = MAX (MAXRR, R)
                  MINAR = MIN (MINAR, V)
                  END IF
 60            CONTINUE
 70         CONTINUE
 80      CONTINUE
C                                       exit if no print
      IF (DOCRT.EQ.0.0) GO TO 999
C                                       open printer
      IF (LPNAME.EQ.' ') DOCRT = MAX (-1.0, DOCRT)
      CALL LPOPEN (LPNAME, DOCRT, LUNP, FINDP, NACROS, SCRBUF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING THE PRINTER'
         CALL MSGWRT (8)
         GO TO 999
         END IF
      PAGE = 0
C                                       now print matrices
      MAXAA = MAX (MAXAA, ABS(MINAA))
      MAXAR = MAX (MAXAR, ABS(MINAR))
      NDIG = XNDIG + 0.1
      IF (NDIG.LE.0) NDIG = ((NACROS-4) / NANT) - 1
      NDIG = MAX (2, MIN (NDIG, 5))
      NN = 10**NDIG
      DO 200 IP = 1,2
         DO 190 I = 1,4
            IPCNT = 990
            IF (I.EQ.1) THEN
               XX = MAXAA
            ELSE IF (I.EQ.2) THEN
               XX = MAXRA
            ELSE IF (I.EQ.3) THEN
               XX = MAXAR
            ELSE
               XX = MAXRR
               END IF
            IF (XX.LT.1.0) THEN
               MM = LOG10 (XX)
            ELSE
               MM = LOG10 (XX) + 1.0
               END IF
            SCALE = 10.0 ** (NDIG - MM)
            XM = 10.0**MM
            WRITE (TITL1,1100) TITLE(I), IP
            WRITE (TITL2,1101) NN, XM, SCALE
            MANT = (NACROS-4) / (NDIG + 1)
            M1 = 1
 110        M2 = MIN (M1+MANT-1,NANT)
            IF (M2.GE.M1) THEN
               LINE = ' '
               CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *            LINE, IPCNT, PAGE, CSCR, IRET)
               IF (IRET.NE.0) GO TO 960
               K = 5
               DO 120 IA1 = M1,M2
                  WRITE (STRING,1110) IA1
                  LINE(K:) = STRING(6-NDIG:)
                  K = K + NDIG + 1
 120              CONTINUE
               CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *            LINE, IPCNT, PAGE, CSCR, IRET)
               IF (IRET.NE.0) GO TO 960
               DO 180 IA2 = 1,NANT
                  WRITE (LINE,1111) IA2
                  K = 5
                  DO 130 IA1 = M1,M2
                     J = IROUND (SUMS(IA1,IA2,IP,I) * SCALE)
                     WRITE (STRING,1110) J
                     IF (SUMS(IA1,IA2,IP,I).EQ.0) STRING = ' '
                     LINE(K:) = STRING(6-NDIG:)
                     K = K + NDIG + 1
 130                 CONTINUE
                  CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *               LINE, IPCNT, PAGE, CSCR, IRET)
                  IF (IRET.NE.0) GO TO 960
 180              CONTINUE
               END IF
            M1 = M2 + 1
            IF (M1.LE.NANT) GO TO 110
 190        CONTINUE
 200     CONTINUE
      GO TO 980
C
 960  IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'PRINTING A LINE'
         CALL MSGWRT (8)
      ELSE
         IRET = 0
         END IF
 980  CALL LPCLOS (LUNP, FINDP, IPCNT, I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('RIRMSM: ERROR',I4,' ON ',A)
 1100 FORMAT ('Display ',A,' for polarization',I2)
 1101 FORMAT ('Print value',I7,' is',1PE8.1,' => data multiplied by',
     *   1PE8.1)
 1110 FORMAT (I6)
 1111 FORMAT (I2)
      END
      SUBROUTINE RIRMST (NANT, SUMS, TAVG, TRMS, LAST, IRET)
C-----------------------------------------------------------------------
C    RIRMST plots the data vs time
C   Input:
C      NANT    I      # antennas
C      SUMS    R(*)   Work array (NANT, NANT, 2pol, 5 <Tavg>, rms,
C                        <Trms>. rms, wt
C      TAVG    R(*)   Time sequence of averages
C      TRMS    R(*)   Time sequence of RMSes
C      LAST    L      Is this the last plot subroutine call?
C   Output:
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   NANT, IRET
      LOGICAL   LAST
      REAL      SUMS(NANT,NANT,2,5), TAVG(NANT,NANT,2,*),
     *   TRMS(NANT,NANT,2,*)
C
      INCLUDE 'RIRMS.INC'
      INTEGER   I, PLUN, IOBLK(256), IVER, TVCHN, TVCORN(4), IDEPTH(5),
     *   J, NCHAR, IT(3), ID(3), LTYPE, LABEL, PIND, IROUND, LT, IA1,
     *   IA2, IP, IPLOT, NPLOTS, IPLOTS
      LOGICAL   DOTV, FLAG, REQBAS
      CHARACTER PFILE*48, CHT12*12, CHT6*6, CHTY*2, UNITS(4)*20,
     *   STRING*132, CHT8*8, NS*18, ADATE*12, ATIME*8, LTITLE*80
      REAL      YMAX(4), YMIN(4), BLC(2), TRC(2), CH(4), X, Y, Y1, Y2,
     *   XYRATO, DX, DY, XSCALE, YSCALE, XMIN, XMAX, SPARM(10), XBLC(2),
     *   XTRC(2), V, TSCALE
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DANS.INC'
      DATA TVCHN, TVCORN, IDEPTH /1, 4*0, 5*1/
      DATA UNITS /'Mean Real', 'Mean Imag', 'RMS Real', 'RMS Imag'/
C-----------------------------------------------------------------------
      DOTV = XDOTV.GT.0.0
      CALL RCOPY (10, APARM, SPARM)
      NPLOTS = 0
      IPLOTS = 0
      APARM(10) = 1
      DO 10 IA1 = 1,NANT
         DO 5 IA2 = IA1,NANT
C                                       data? wanted?
            IF ((SUMS(IA1,IA2,1,5).LE.0.0) .AND.
     *         (SUMS(IA1,IA2,2,5).LE.0.0)) GO TO 5
            IF (REQBAS (IA1, IA2, DESEL, IXANT, NXANT, IXBAS, NXBAS))
     *         NPLOTS = NPLOTS + 1
 5          CONTINUE
 10      CONTINUE
C                                       loop over baselines
      DO 100 IA1 = 1,NANT
         DO 90 IA2 = IA1,NANT
            APARM(9) = 512 * IA1 + IA2
C                                       data? wanted?
            IF ((SUMS(IA1,IA2,1,5).LE.0.0) .AND.
     *         (SUMS(IA1,IA2,2,5).LE.0.0)) GO TO 90
            IF (.NOT.REQBAS (IA1, IA2, DESEL, IXANT, NXANT, IXBAS,
     *         NXBAS)) GO TO 90
            CALL RFILL (4, -1.E10, YMAX)
            CALL RFILL (4, 1.E10, YMIN)
            DO 20 LT = 1,NTIME
               DO 15 IP = 1,2
                  IF (SUMS(IA2,IA1,IP,5).GT.0.0) THEN
                     IF (TAVG(IA2,IA1,IP,LT).NE.FBLANK) THEN
                        YMAX(1) = MAX (YMAX(1), TAVG(IA2,IA1,IP,LT))
                        YMIN(1) = MIN (YMIN(1), TAVG(IA2,IA1,IP,LT))
                        YMAX(3) = MAX (YMAX(3), TRMS(IA2,IA1,IP,LT))
                        YMIN(3) = MIN (YMIN(3), TRMS(IA2,IA1,IP,LT))
                        END IF
                     IF (TAVG(IA1,IA2,IP,LT).NE.FBLANK) THEN
                        YMAX(2) = MAX (YMAX(2), TAVG(IA1,IA2,IP,LT))
                        YMIN(2) = MIN (YMIN(2), TAVG(IA1,IA2,IP,LT))
                        YMAX(4) = MAX (YMAX(4), TRMS(IA1,IA2,IP,LT))
                        YMIN(4) = MIN (YMIN(4), TRMS(IA1,IA2,IP,LT))
                        END IF
                     END IF
 15               CONTINUE
 20            CONTINUE
            DO 25 IPLOT = 1,4
              IF (SPARM(2*IPLOT).GT.SPARM(2*IPLOT-1)) THEN
                 YMIN(IPLOT) = SPARM(2*IPLOT-1)
                 YMAX(IPLOT) = SPARM(2*IPLOT)
                 END IF
              Y1 = (YMAX(IPLOT) - YMIN(IPLOT)) * 0.04
              YMAX(IPLOT) = YMAX(IPLOT) + Y1
              YMIN(IPLOT) = YMIN(IPLOT) - Y1
 25           CONTINUE
C                                       Add plot file to the image
C                                       catalog header.
            IF (.NOT.DOTV) THEN
               CHT12 = ' '
               CHT6 = ' '
               CHTY = ' '
               CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12, CHT6, 0,
     *            CHTY, 0,'CLRD', IOBLK, IRET)
               IF (IRET.EQ.0) CALL CATDIR ('CSTA', DISKIN, OLDCNO,
     *            CHT12, CHT6, 0, CHTY, 0, 'WRIT', IOBLK, IRET)
               FRW(NCFILE) = 1
               CALL MADDEX ('PL', DISKIN, OLDCNO, CATOLD, IOBLK, .TRUE.,
     *            'WRIT', IVER, IRET)
               IF (IRET.NE.0) THEN
                  MSGTXT = 'RIRMST: ERROR UPDATING CATALOG HEADER.'
                  CALL MSGWRT (8)
                  GO TO 999
                  END IF
               END IF
C                                       Open the PLot file.
            CALL ZPHFIL ('PL', DISKIN, OLDCNO, IVER, PFILE, IRET)
            APARM(10) = 1
            SOLINT = SOLINT * 24.0 * 60.0
            CALL GINIT (DISKIN, OLDCNO, PFILE, 0, 72, NPARM, XNAMEI,
     *         DOTV, TVCHN, GRCHAN, TVCORN, CATOLD, IOBLK, PLUN, PIND,
     *         IRET)
            IF (IRET.NE.0) THEN
               MSGTXT = 'RIRMST: ERROR OPENING PLOT FILE FOR' //
     *            'A TIME PLOT'
               CALL MSGWRT (8)
               IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT',
     *            CATOLD, IOBLK, IVER, I)
               GO TO 999
               END IF
            SOLINT = SOLINT / (24.0 * 60.0)
C                                       Set BLC, TRC, XYRATO.
            Y1 = (TIMEND - TIMBEG) * 0.04
            XMIN = TIMBEG - Y1
            XMAX = TIMEND + Y1
            BLC(1) = -1.0
            BLC(2) = -1.0
            TRC(1) = 1002.0
            TRC(2) = 1002.0
C                                       Set coordinate common
            LOCNUM = 1
            RPVAL(1,LOCNUM) = XMIN * 360.0
            RPVAL(2,LOCNUM) = YMIN(1)
            RPLOC(1,LOCNUM) = 1.0
            RPLOC(2,LOCNUM) = 1.0
            AXINC(1,LOCNUM) = (XMAX - XMIN) / 999.0 * 360
            AXINC(2,LOCNUM) = (YMAX(1) - YMIN(1)) / 999.0
            ROT(LOCNUM) = 0.0
            NCHLAB(1,LOCNUM) = 0
            NCHLAB(2,LOCNUM) = 0
            LABTYP(LOCNUM) = 7
            CORTYP(LOCNUM) = 0
            AXTYP(LOCNUM) = 4
            AXFUNC(1,LOCNUM) = 0
            AXFUNC(2,LOCNUM) = 0
            NCHLAB(1,LOCNUM) = 0
            NCHLAB(2,LOCNUM) = 0
            CTYP(1,LOCNUM) = 'Time (hours)'
            CTYP(2,LOCNUM) = 'Jy'
C                                       metric scaling
            LABEL = IROUND (XLABEL)
            CPREF(1,LOCNUM) = ' '
            Y1 = ABS (AXINC(2,LOCNUM) * (TRC(2) - BLC(2)))
            Y2 = Y1
            CALL METSCL (LABEL, Y2, CPREF(2,LOCNUM), FLAG)
            IF ((.NOT.FLAG) .AND. (Y1.NE.0.0)) THEN
               RPVAL(2,LOCNUM) = RPVAL(2,LOCNUM) * Y2 / Y1
               AXINC(2,LOCNUM) = AXINC(2,LOCNUM) * Y2 / Y1
            ELSE
               CPREF(2,LOCNUM) = ' '
               END IF
C                                       Set character offsets.
            LTYPE = MOD (ABS (LABEL), 100)
            CALL RFILL (4, 0.5, CH)
            CALL CHNTIC (BLC, TRC, J)
            IF (LTYPE.EQ.2) CH(1) = 2.5
            IF (LTYPE.GT.2) CH(1) = J + 5.0
            IF (LTYPE.GT.1) CH(2) = 2.0
            IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
            IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               CH(2) = CH(2) + 1.333
               CH(4) = 2.0
               IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
               END IF
            IF (DOTV) THEN
               DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) +
     *            CH(3))
               DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) +
     *            CH(4))
               XYRATO = 1.4
               IF (DY.GT.0.0) XYRATO = DX / DY
            ELSE
               XYRATO = 1.4
               END IF
C                                       Initialize for line drawing
            CALL GINITL (BLC, TRC, XYRATO, CH, IDEPTH, IOBLK, IRET)
            IF (IRET.NE.0) THEN
               MSGTXT = 'RIRMST: ERROR INITIALIZING FOR LINE DRAWING.'
               GO TO 950
               END IF
C                                       Labeling: source, freq, etc
            IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               DX = 0.0
               DY = 0.5
               CALL H2CHR (8, 1, CATOH(KHOBJ), CHT8)
               XX = (CATOD(KDCRV+JLOCF) + CATOR(KRCIC+JLOCF)
     *            * (1.0 - CATOR(KRCRP+JLOCF))) / 1.0E6
               WRITE (STRING,1030) CHT8, XX
               NS = NAMEIN // CLAIN
               CALL NAMEST (NS, CATOLD(KIIMS), STRING(31:), I)
               CALL REFRMT (STRING, '_', NCHAR)
               CALL GPOS (BLC(1), TRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 930
               END IF
C                                       Labeling: date
            IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               CALL ZDATE (ID)
               CALL ZTIME (IT)
               CALL TIMDAT (IT, ID, ATIME, ADATE)
               WRITE (STRING,1031) IVER, ADATE, ATIME
               DY = DY + 1.333
               CALL REFRMT (STRING, '_', NCHAR)
               CALL GPOS (BLC(1), TRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 930
               END IF
            IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               DY = -2.833 - 1.333
C                                       lower title: chan, IF, ant
               WRITE (STRING,1020) STNNAM(IA1), STNNAM(IA2), IA1, IA2
               CALL REFRMT (STRING, '_', NCHAR)
               LTITLE = ' '
               IF ((JLOCIF.GE.0) .AND. (CATBLK(KINAX+JLOCIF).GT.1)) THEN
                  IF (CATBLK(KINAX+JLOCF).GT.1) THEN
                     WRITE (LTITLE,1021) BIF, EIF, BCHAN, ECHAN
                  ELSE
                     WRITE (LTITLE,1022) BIF, EIF
                     END IF
               ELSE
                  IF (CATBLK(KINAX+JLOCF).GT.1) WRITE (LTITLE,1023)
     *               BCHAN, ECHAN
                  END IF
               CALL REFRMT (LTITLE, '_', I)
               STRING(NCHAR+3:) = LTITLE
               NCHAR = NCHAR + 2 + I
               CALL GPOS (BLC(1), BLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 930
               END IF
C                                       4 plots
            DO 80 IPLOT = 1,4
               XBLC(1) = BLC(1)
               XTRC(1) = TRC(1)
               XTRC(2) = 250 * IPLOT
               XBLC(2) = 1 + 250 * (IPLOT-1)
               IF (IPLOT.GT.1) XBLC(2) = XBLC(2) + 10
               RPVAL(2,LOCNUM) = YMIN(IPLOT)
               RPLOC(2,LOCNUM) = XBLC(2)
               AXINC(2,LOCNUM) = (YMAX(IPLOT)-YMIN(IPLOT)) /
     *            (XTRC(2)-XBLC(2))
               CTYP(2,LOCNUM) = UNITS(IPLOT)
               IF (IPLOT.GT.1) THEN
                  CTYP(1,LOCNUM) = ' '
                  CPREF(1,LOCNUM) = ' '
                  END IF
               Y1 = ABS (AXINC(2,LOCNUM) * (XTRC(2) - XBLC(2)))
               Y2 = Y1
               CALL METSCL (LABEL, Y2, CPREF(2,LOCNUM), FLAG)
               IF ((.NOT.FLAG) .AND. (Y1.NE.0.0)) THEN
                  RPVAL(2,LOCNUM) = RPVAL(2,LOCNUM) * Y2 / Y1
                  AXINC(2,LOCNUM) = AXINC(2,LOCNUM) * Y2 / Y1
               ELSE
                  CPREF(2,LOCNUM) = ' '
                  END IF
C                                       Draw borders.
               CALL GLTYPE (1, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GPOS (XBLC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GVEC (XTRC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XTRC(1), XTRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XBLC(1), XTRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XBLC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
C                                       Calculate range and scales.
               XSCALE = 999.0 / (XMAX - XMIN)
               TSCALE = (TIMEND - TIMBEG) / NTIME
               YSCALE = (XTRC(2)-XBLC(2)-2) / (YMAX(IPLOT)-YMIN(IPLOT))
C                                       tick marks, labels, ...
               CALL CLAB1 (XBLC, XTRC, CH, LABEL, XYRATO, .FALSE.,
     *            IOBLK, IRET)
               IF (IRET.NE.0) THEN
                  MSGTXT = 'RIRMST: PLOT ERROR OCCURRED WHILE'
     *               // 'DRAWING TICKS.'
                  GO TO 950
                  END IF
C                                       Draw the data
               DO 40 IP = 1,2
                  IF (SUMS(IA2,IA1,IP,5).GT.0.0) THEN
                     CALL GLTYPE (IP, IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 920
C                                       Stokes label
                     CALL GPOS (XTRC(1), XTRC(2), IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 910
                     DX = -8.0 + (IP-1.0)*3.5
                     DY = -3.0
                     CALL GICHAR (1, 2, 0, DX, DY, CSTOKE(IP), IOBLK,
     *                  IRET)
                     IF (IRET.NE.0) GO TO 930
C                                       now draw
                     DX = 2.0 * FACTOR
                     DY = 4.0 * FACTOR
                     DO 30 LT = 1,NTIME
                        X = (LT-0.5) * TSCALE + TIMBEG
                        X= (X - XMIN) * XSCALE + 1.0
                        IF (IPLOT.EQ.1) THEN
                           V = TAVG(IA2,IA1,IP,LT)
                        ELSE IF (IPLOT.EQ.2) THEN
                           V = TAVG(IA1,IA2,IP,LT)
                        ELSE IF (IPLOT.EQ.3) THEN
                           V = TRMS(IA2,IA1,IP,LT)
                        ELSE IF (IPLOT.EQ.4) THEN
                           V = TRMS(IA1,IA2,IP,LT)
                           END IF
                        IF (V.NE.FBLANK) THEN
                           Y = (V - YMIN(IPLOT)) * YSCALE + XBLC(2)
                           CALL GPOS (X, Y+DY, IOBLK, IRET)
                           IF (IRET.NE.0) GO TO 910
                           CALL GVEC (X, Y-DY, IOBLK, IRET)
                           IF (IRET.NE.0) GO TO 920
                           CALL GPOS (X+DX, Y, IOBLK, IRET)
                           IF (IRET.NE.0) GO TO 910
                           CALL GVEC (X-DX, Y, IOBLK, IRET)
                           IF (IRET.NE.0) GO TO 920
                           END IF
 30                     CONTINUE
                     END IF
 40               CONTINUE
 80            CONTINUE
            IPLOTS = IPLOTS + 1
            GPHPAG = (IPLOTS.LT.NPLOTS) .OR. (.NOT.LAST)
            CALL GFINIS (IOBLK, IRET)
            IF (IRET.NE.0) GO TO 950
            WRITE (MSGTXT,1050) IVER
            IF (.NOT.DOTV) CALL MSGWRT (3)
 90         CONTINUE
 100     CONTINUE
      GO TO 999
C                                       Error return from GPOS.
 910  MSGTXT = 'RIRMST: PLOT ERROR OCCURRED WHILE MOVING TO A POINT.'
      GO TO 940
C                                       Error return from GVEC.
 920  MSGTXT = 'RIRMST: PLOT ERROR OCCURRED WHILE DRAWING A LINE.'
      GO TO 940
C                                       error return from GCHAR
 930  MSGTXT = 'RIRMST: PLOT ERROR OCCURRED WHILE DRAWING CHARACTERS.'
 940  CALL MSGWRT (8)
C                                       Destroy the PLot file on error.
 950  IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) IVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN, PFILE, I)
         CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT', CATOLD, IOBLK,
     *      IVER, I)
         END IF
      IRET = MAX (0, IRET)
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT ('Baseline ',A,' - ',A,' (',I3,' - ',I3,' )')
 1021 FORMAT ('IF numbers',2I3,'__Spectral channels',2I5)
 1022 FORMAT ('IF numbers',2I3)
 1023 FORMAT ('Spectral channels',2I5)
 1030 FORMAT (A8,1X,F10.3,' MHz')
 1031 FORMAT ('PLot file version',I4,'__created ',A12,A8)
 1050 FORMAT ('Successful  plot version',I4,' created')
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
      SUBROUTINE RIRMSH (WHAT, NANT, SUMS, TAVG, TRMS, LAST, IRET)
C-----------------------------------------------------------------------
C    RIRMSH plots the histograms
C   Input:
C      WHAT    I      1 -> RMSes, 2 -> MEANs
C      NANT    I      # antennas
C      SUMS    R(*)   Work array (NANT, NANT, 2pol, 5 <Tavg>, rms,
C                        <Trms>. rms, wt
C      TAVG    R(*)   Time sequence of averages
C      TRMS    r(*)   Time sequence of RMSes
C      LAST    L      Is this the last plot subroutine call?
C   Output:
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   WHAT, NANT, IRET
      LOGICAL   LAST
      REAL      SUMS(NANT,NANT,2,5), TAVG(NANT,NANT,2,*),
     *   TRMS(NANT,NANT,2,*)
C
      INCLUDE 'RIRMS.INC'
      INTEGER   I, PLUN, IOBLK(256), IVER, TVCHN, TVCORN(4), IDEPTH(5),
     *   J, NCHAR, IT(3), ID(3), LTYPE, LABEL, PIND, IROUND, NPLOTS,
     *   IPLOTS, IW, NPTS(4), NXPANE, NYPANE, NXP, NYP,IA1, IA2, IPLOT,
     *   IP, LT, IV, NOUT(4)
      LOGICAL   DOTV, FLAG, REQBAS
      CHARACTER PFILE*48, CHT12*12, CHT6*6, CHTY*2, UNITS(2,2)*20,
     *   STRING*132, CHT8*8, NS*18, ADATE*12, ATIME*8, LTITLE*80
      REAL      BLC(2), TRC(2), CH(4), X, X2, Y1, Y2, XYRATO, DX, DY,
     *   XSCALE, YSCALE, XMIN(4), XMAX(4), HISTOG(2048,4), YMIN(4),
     *   YMAX(4), PLTXIN, PLTYIN, PLTXOF, PLTYOF, V, XBLC(2), XTRC(2)
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DANS.INC'
      DATA TVCHN, TVCORN, IDEPTH /1, 4*0, 5*1/
      DATA UNITS /'Real RMS', 'Imag RMS', 'Real MEAN', 'Imag MEAN'/
C-----------------------------------------------------------------------
      DOTV = XDOTV.GT.0.0
      NBOXES = XBOXES + 0.1
      IF (NBOXES.LE.5) NBOXES = 128
      NBOXES = MIN (NTIME/10, NBOXES)
      NBOXES = MIN (NBOXES, 2048)
      XBOXES = NBOXES
      NPLOTS = 0
      IPLOTS = 0
      APARM(10) = 1
      IW = 3
      IF (WHAT.EQ.2) IW = 1
      DO 10 IA1 = 1,NANT
         DO 5 IA2 = IA1,NANT
C                                       data? wanted?
            IF ((SUMS(IA1,IA2,1,5).LE.0.0) .AND.
     *         (SUMS(IA1,IA2,2,5).LE.0.0)) GO TO 5
            IF (REQBAS (IA1, IA2, DESEL, IXANT, NXANT, IXBAS, NXBAS))
     *         NPLOTS = NPLOTS + 1
 5          CONTINUE
 10      CONTINUE
C                                       loop over baselines
      DO 100 IA1 = 1,NANT
         DO 90 IA2 = IA1,NANT
            APARM(9) = 512 * IA1 + IA2
C                                       data? wanted?
            IF ((SUMS(IA1,IA2,1,5).LE.0.0) .AND.
     *         (SUMS(IA1,IA2,2,5).LE.0.0)) GO TO 90
            IF (.NOT.REQBAS (IA1, IA2, DESEL, IXANT, NXANT, IXBAS,
     *         NXBAS)) GO TO 90
            CALL FILL (4, 0, NPTS)
            CALL FILL (4, 0, NOUT)
            XMIN(1) = SUMS(IA2,IA1,1,IW) - CUTOFF*SUMS(IA2,IA1,1,IW+1)
            XMIN(2) = SUMS(IA2,IA1,2,IW) - CUTOFF*SUMS(IA2,IA1,2,IW+1)
            XMIN(3) = SUMS(IA1,IA2,1,IW) - CUTOFF*SUMS(IA1,IA2,1,IW+1)
            XMIN(4) = SUMS(IA1,IA2,2,IW) - CUTOFF*SUMS(IA1,IA2,2,IW+1)
            XMAX(1) = SUMS(IA2,IA1,1,IW) + CUTOFF*SUMS(IA2,IA1,1,IW+1)
            XMAX(2) = SUMS(IA2,IA1,2,IW) + CUTOFF*SUMS(IA2,IA1,2,IW+1)
            XMAX(3) = SUMS(IA1,IA2,1,IW) + CUTOFF*SUMS(IA1,IA2,1,IW+1)
            XMAX(4) = SUMS(IA1,IA2,2,IW) + CUTOFF*SUMS(IA1,IA2,2,IW+1)
C                                       compute histograms
            CALL RFILL (8192, 0.0, HISTOG)
            DO 20 LT = 1,NTIME
               DO 15 IP = 1,2
                  IF (SUMS(IA2,IA1,IP,5).GT.0.0) THEN
                     IF (TAVG(IA2,IA1,IP,LT).NE.FBLANK) THEN
                        IF (WHAT.EQ.1) THEN
                           V = TRMS(IA2,IA1,IP,LT)
                        ELSE
                           V = TAVG(IA2,IA1,IP,LT)
                           END IF
                        IV = (V-XMIN(IP)) / (XMAX(IP)-XMIN(IP)) *
     *                     NBOXES + 0.5
                        IF ((IV.GE.1) .AND. (IV.LE.NBOXES)) THEN
                           HISTOG(IV,IP) = HISTOG(IV,IP) + 1.0
                        ELSE
                           NOUT(IP) = NOUT(IP) + 1
                           END IF
                        END IF
                     IF (TAVG(IA1,IA2,IP,LT).NE.FBLANK) THEN
                        IF (WHAT.EQ.1) THEN
                           V = TRMS(IA1,IA2,IP,LT)
                        ELSE
                           V = TAVG(IA1,IA2,IP,LT)
                           END IF
                        IV = (V-XMIN(IP+2)) / (XMAX(IP+2)-XMIN(IP+2)) *
     *                     NBOXES + 0.5
                        IF ((IV.GE.1) .AND. (IV.LE.NBOXES)) THEN
                           HISTOG(IV,IP+2) = HISTOG(IV,IP+2) + 1.0
                        ELSE
                           NOUT(IP+2) = NOUT(IP+2) + 1
                           END IF
                        END IF
                     END IF
 15               CONTINUE
 20            CONTINUE
C                                       scale histograms
            CALL RFILL (4, 0.0, YMIN)
            CALL RFILL (4, -1.E10, YMAX)
            DO 30 IPLOT = 1,4
               DO 25 IV = 1,NBOXES
                  IF (HISTOG(IV,IPLOT).GT.0.0) NPTS(IPLOT) = NPTS(IPLOT)
     *               + HISTOG(IV,IPLOT) + 0.1
                  IF (FUNTYP.EQ.'LG') THEN
                     IF (HISTOG(IV,IPLOT).LE.0.0) THEN
                        HISTOG(IV,IPLOT) = LOG10 (0.5)
                     ELSE
                        HISTOG(IV,IPLOT) = LOG10 (HISTOG(IV,IPLOT))
                        END IF
                     END IF
                  YMIN(IPLOT) = MIN (YMIN(IPLOT), HISTOG(IV,IPLOT))
                  YMAX(IPLOT) = MAX (YMAX(IPLOT), HISTOG(IV,IPLOT))
 25               CONTINUE
               Y1 = (YMAX(IPLOT) - YMIN(IPLOT)) * 0.05
               YMIN(IPLOT) = YMIN(IPLOT) - Y1
               YMAX(IPLOT) = YMAX(IPLOT) + Y1
 30            CONTINUE
C                                       Add plot file to the image
C                                       catalog header.
            IF (.NOT.DOTV) THEN
               CHT12 = ' '
               CHT6 = ' '
               CHTY = ' '
               CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12, CHT6, 0,
     *            CHTY, 0,'CLRD', IOBLK, IRET)
               IF (IRET.EQ.0) CALL CATDIR ('CSTA', DISKIN, OLDCNO,
     *            CHT12, CHT6, 0, CHTY, 0, 'WRIT', IOBLK, IRET)
               FRW(NCFILE) = 1
               CALL MADDEX ('PL', DISKIN, OLDCNO, CATOLD, IOBLK, .TRUE.,
     *            'WRIT', IVER, IRET)
               IF (IRET.NE.0) THEN
                  MSGTXT = 'RIRMST: ERROR UPDATING CATALOG HEADER.'
                  CALL MSGWRT (8)
                  GO TO 999
                  END IF
               END IF
C                                       Open the PLot file.
            CALL ZPHFIL ('PL', DISKIN, OLDCNO, IVER, PFILE, IRET)
            APARM(10) = 2
            SOLINT = SOLINT * 24.0 * 60.0
            CALL GINIT (DISKIN, OLDCNO, PFILE, 0, 72, NPARM, XNAMEI,
     *         DOTV, TVCHN, GRCHAN, TVCORN, CATOLD, IOBLK, PLUN, PIND,
     *         IRET)
            IF (IRET.NE.0) THEN
               MSGTXT = 'RIRMST: ERROR OPENING PLOT FILE FOR' //
     *            'A TIME PLOT'
               CALL MSGWRT (8)
               IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT',
     *            CATOLD, IOBLK, IVER, I)
               GO TO 999
               END IF
            SOLINT = SOLINT / (24.0 * 60.0)
            BLC(1) = 0.0
            BLC(2) = 0.0
            TRC(1) = 1000.0
            TRC(2) = 1000.0
            NXPANE = 2
            NYPANE = 2
            PLTXIN = 1000.0 / (NXPANE - 0.25)
            PLTYIN = 1000.0 / (NYPANE - 0.10)
            PLTXOF = NXPANE * PLTXIN - 1000.
            PLTYOF = NYPANE * PLTYIN - 1000.
C                                       Set coordinate common
            LOCNUM = 1
            ROT(LOCNUM) = 0.0
            NCHLAB(1,LOCNUM) = 0
            NCHLAB(2,LOCNUM) = 0
            LABTYP(LOCNUM) = 0
            CORTYP(LOCNUM) = 0
            AXTYP(LOCNUM) = 4
            AXFUNC(1,LOCNUM) = 0
            AXFUNC(2,LOCNUM) = 0
            NCHLAB(1,LOCNUM) = 0
            NCHLAB(2,LOCNUM) = 0
            IF (FUNTYP.EQ.'LG') THEN
               CTYP(2,LOCNUM) = 'LOG10 (counts)'
            ELSE
               CTYP(2,LOCNUM) = 'Counts'
               END IF
            LABEL = IROUND (XLABEL)
C                                       Loop over 4 plots
            NXP = 0
            NYP = 1
            DO 80 IPLOT = 1,4
               NXP = NXP + 1
               IF (NXP.EQ.3) THEN
                  NXP = 1
                  NYP = 2
                  END IF
C                                       Set window for current plot.
               XBLC(1) = BLC(1) + ABS (NXP-1) * PLTXIN
               XBLC(2) = BLC(2) + ABS (NYP-1) * PLTYIN
               XTRC(1) = XBLC(1) + PLTXIN - 1.0 - PLTXOF
               XTRC(2) = XBLC(2) + PLTYIN - 1.0 - PLTYOF
               RPVAL(1,LOCNUM) = XMIN(IPLOT)
               RPVAL(2,LOCNUM) = YMIN(IPLOT)
               AXINC(1,LOCNUM) = (XMAX(IPLOT) - XMIN(IPLOT)) /
     *            (XTRC(1) - XBLC(1))
               AXINC(2,LOCNUM) = (YMAX(IPLOT) - YMIN(IPLOT)) /
     *            (XTRC(2) - XBLC(2))
               CTYP(1,LOCNUM) = UNITS((IPLOT+1)/2,WHAT)
               RPLOC(1,LOCNUM) = XBLC(1)
               RPLOC(2,LOCNUM) = XBLC(2)
C                                       metric scaling
               DO 35 I = 1,2
                  Y1 = ABS (AXINC(I,LOCNUM) * (TRC(I) - BLC(I)))
                  Y2 = Y1
                  CALL METSCL (LABEL, Y2, CPREF(I,LOCNUM), FLAG)
                  IF ((.NOT.FLAG) .AND. (Y1.NE.0.0)) THEN
                     RPVAL(I,LOCNUM) = RPVAL(I,LOCNUM) * Y2 / Y1
                     AXINC(I,LOCNUM) = AXINC(I,LOCNUM) * Y2 / Y1
                  ELSE
                     CPREF(I,LOCNUM) = ' '
                     END IF
 35               CONTINUE
C                                       init the plot
               IF (IPLOT.EQ.1) THEN
C                                       Set character offsets.
                  LTYPE = MOD (ABS (LABEL), 100)
                  CALL RFILL (4, 0.5, CH)
                  CALL CHNTIC (BLC, TRC, J)
                  IF (LTYPE.EQ.2) CH(1) = 2.5
                  IF (LTYPE.GT.2) CH(1) = J + 5.0
                  IF (LTYPE.GT.1) CH(2) = 2.0
                  IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
                  IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
                     CH(2) = CH(2) + 1.333 * 2
                     CH(4) = 2.0
                     IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
                     END IF
                  IF (DOTV) THEN
                     DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) *
     *                  (CH(1) + CH(3))
                     DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) *
     *                  (CH(2) + CH(4))
                     XYRATO = 1.4
                     IF (DY.GT.0.0) XYRATO = DX / DY
                  ELSE
                     XYRATO = 1.4
                     END IF
C                                       Initialize for line drawing
                  CALL GINITL (BLC, TRC, XYRATO, CH, IDEPTH, IOBLK,
     *               IRET)
                  IF (IRET.NE.0) THEN
                     MSGTXT =
     *                  'RIRMSH: ERROR INITIALIZING FOR LINE DRAWING.'
                     GO TO 950
                     END IF
                  CALL GLTYPE (1, IOBLK, IRET)
                  IF (IRET.NE.0) GO TO 920
C                                       Labeling: source, freq, etc
                  IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
                     DX = 0.0
                     DY = 0.5
                     CALL H2CHR (8, 1, CATOH(KHOBJ), CHT8)
                     XX = (CATOD(KDCRV+JLOCF) + CATOR(KRCIC+JLOCF)
     *                  * (1.0 - CATOR(KRCRP+JLOCF))) / 1.0E6
                     WRITE (STRING,1030) CHT8, XX, STOKES
                     NS = NAMEIN // CLAIN
                     CALL NAMEST (NS, CATOLD(KIIMS), STRING(31:), I)
                     CALL REFRMT (STRING, '_', NCHAR)
                     CALL GPOS (BLC(1), TRC(2), IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 910
                     CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 930
                     END IF
C                                       Labeling: date
                  IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND.
     *               (LTYPE.LT.7)) THEN
                     CALL ZDATE (ID)
                     CALL ZTIME (IT)
                     CALL TIMDAT (IT, ID, ATIME, ADATE)
                     WRITE (STRING,1031) IVER, ADATE, ATIME
                     DY = DY + 1.333
                     CALL REFRMT (STRING, '_', NCHAR)
                     CALL GPOS (BLC(1), TRC(2), IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 910
                     CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 930
                     END IF
                  IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
                     DY = -2.833 - 1.333
C                                       lower title: chan, IF, ant
                     WRITE (STRING,1020) STNNAM(IA1), STNNAM(IA2), IA1,
     *                  IA2
                     CALL REFRMT (STRING, '_', NCHAR)
                     LTITLE = ' '
                     IF ((JLOCIF.GE.0) .AND.
     *                  (CATBLK(KINAX+JLOCIF).GT.1)) THEN
                        IF (CATBLK(KINAX+JLOCF).GT.1) THEN
                           WRITE (LTITLE,1021) BIF, EIF, BCHAN, ECHAN
                        ELSE
                           WRITE (LTITLE,1022) BIF, EIF
                           END IF
                     ELSE
                        IF (CATBLK(KINAX+JLOCF).GT.1)
     *                     WRITE (LTITLE,1023) BCHAN, ECHAN
                        END IF
                     CALL REFRMT (LTITLE, '_', I)
                     STRING(NCHAR+3:) = LTITLE
                     NCHAR = NCHAR + 2 + I
                     CALL GPOS (BLC(1), BLC(2), IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 910
                     CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 930
C                                       npts, nboxes
                     DY = DY - 1.333
                     WRITE (STRING,1025) NBOXES, NPTS, NOUT
                     CALL REFRMT (STRING, '_', NCHAR)
                     CALL GPOS (BLC(1), BLC(2), IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 910
                     CALL GCHAR (NCHAR, 0, DX, DY, STRING, IOBLK, IRET)
                     IF (IRET.NE.0) GO TO 930
                     END IF
                  END IF
C                                       Draw borders.
               CALL GLTYPE (1, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GPOS (XBLC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GVEC (XTRC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XTRC(1), XTRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XBLC(1), XTRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
               CALL GVEC (XBLC(1), XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
C                                       Calculate range and scales.
               XSCALE = (XTRC(1)-XBLC(1)) / NBOXES
               YSCALE = (XTRC(2)-XBLC(2)) / (YMAX(IPLOT) - YMIN(IPLOT))
C                                       tick marks, labels, ...
               CALL CLAB1 (XBLC, XTRC, CH, LABEL, XYRATO, .FALSE.,
     *            IOBLK, IRET)
               IF (IRET.NE.0) THEN
                  MSGTXT =
     *               'DRWHGM: PLOT ERROR OCCURRED WHILE DRAWING TICKS.'
                  GO TO 950
                  END IF
C                                       Draw the histogram
               CALL GLTYPE (NXP, IOBLK, IRET)
               IF (IRET.NE.0) GO TO 920
C                                       stokes label
               CALL GPOS (XTRC(1), XTRC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               DX = -6.0
               DY = -3.0
               CALL GICHAR (1, 2, 0, DX, DY, CSTOKE(NXP), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 930
C                                       now draw
               X = XBLC(1)
               CALL GPOS (X, XBLC(2), IOBLK, IRET)
               IF (IRET.NE.0) GO TO 910
               DO 40 I = 1,NBOXES
                  Y1 = HISTOG(I,IPLOT)
                  Y1 = (Y1 - YMIN(IPLOT)) * YSCALE + XBLC(2)
                  CALL GVEC (X, Y1, IOBLK, IRET)
                  IF (IRET.NE.0) GO TO 920
                  X2 = X + XSCALE
                  CALL GVEC (X2, Y1, IOBLK, IRET)
                  IF (IRET.NE.0) GO TO 920
                  X = X2
 40               CONTINUE
 80            CONTINUE
            IPLOTS = IPLOTS + 1
            GPHPAG = (IPLOTS.LT.NPLOTS) .OR. (.NOT.LAST)
            CALL GFINIS (IOBLK, IRET)
            IF (IRET.NE.0) GO TO 950
            WRITE (MSGTXT,1050) IVER
            IF (.NOT.DOTV) CALL MSGWRT (3)
 90         CONTINUE
 100     CONTINUE
      GO TO 999
C                                       Error return from GPOS.
 910  MSGTXT = 'RIRMSP: PLOT ERROR OCCURRED WHILE MOVING TO A POINT.'
      GO TO 940
C                                       Error return from GVEC.
 920  MSGTXT = 'RIRMSP: PLOT ERROR OCCURRED WHILE DRAWING A LINE.'
      GO TO 940
C                                       error return from GCHAR
 930  MSGTXT = 'RIRMSP: PLOT ERROR OCCURRED WHILE DRAWING CHARACTERS.'
 940  CALL MSGWRT (8)
C                                       Destroy the PLot file on error.
 950  IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) IVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN, PFILE, I)
         CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT', CATOLD, IOBLK,
     *      IVER, I)
         END IF
      IRET = MAX (0, IRET)
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT ('Baseline ',A,' - ',A,' (',I3,' - ',I3,' )')
 1021 FORMAT ('IF numbers',2I3,'__Spectral channels',2I5)
 1022 FORMAT ('IF numbers',2I3)
 1023 FORMAT ('Spectral channels',2I5)
 1025 FORMAT ('Nboxes',I5,'__Npoints',4I8,'__Nout',4I8)
 1030 FORMAT (A8,1X,F10.3,' MHz__',A4)
 1031 FORMAT ('PLot file version',I4,'__created ',A12,A8)
 1050 FORMAT ('Successful  plot version',I4,' created')
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
