LOCAL INCLUDE 'QBEAM.INC'
C                                                          Include QBEAM
C                                       Local include for QBEAM
      INCLUDE 'INCS:PSTD.INC'
      INTEGER   MAXPOI, NINLI, NPL
C                                       number of points in each line
C                                       of the measurments
      PARAMETER (NINLI = 101)
C                                       Number of the lines(plots)
C                                       Number of plots should be equal
C                                       NINLI*NREF; Take NREF_max=NINLI
      PARAMETER (NPL = NINLI*NINLI)
C                                       MAXPOI max number of measurments
      PARAMETER (MAXPOI = NINLI*NPL)
C
      HOLLERITH XNAMEO(3), XIFILE(12)
      REAL      XSOU, XDISOU, RADIUS, THRESH, DOPLOT, XDOTV, XGRCHN,
     *   XBAD(10)
C                                       Inputs
      COMMON /INPARM/ XNAMEO, XSOU, XDISOU, XIFILE, RADIUS, THRESH,
     *   DOPLOT, XDOTV, XGRCHN, XBAD
C
      INTEGER   SEQOU, DISKOU, CNOUT, TVCHN, GRCHN, TVCORN(4), NPARM,
     *   PRTLEV, IANT, NREF, REFANT(150), NANT, NANTS(150), NMEAS,
     *   ISTART(NPL), NPO(NPL), NITER, NFIT, NNFIT
      LOGICAL   DOTV, DOPHAS, DOCOMB, DOSWIT, CONTUR, IRING
      DOUBLE PRECISION XMEAS(MAXPOI), YMEAS(MAXPOI), AMPLS(MAXPOI),
     *   FREQU, DIAM, TOLER, AMMAX, XYMAX(2), XYMIN(2), PHCUT,
     *   PHMAX
      CHARACTER INFILE*48, NAMEOU*12, CLASOU*6, STOKE*2, SAVLIN*80
C                                       Buffers
      INTEGER   BUFFER(1024)
      COMMON /BUFRS/ BUFFER
C                                       general info
      COMMON /OTHPRM/ SEQOU, DISKOU, CNOUT, TVCHN, NPARM, DOTV, PRTLEV,
     *   DOPHAS, DOCOMB, DOSWIT, CONTUR, IRING
      COMMON /EL/     GRCHN, TVCORN
      COMMON /CHRCOM/ INFILE, NAMEOU, CLASOU, STOKE, SAVLIN
C                                       Important constants
C                                       Internal storage
      COMMON /MEAS/ XMEAS, YMEAS, AMPLS, FREQU, DIAM, TOLER,
     *   AMMAX, XYMAX, XYMIN, PHCUT, PHMAX, NMEAS, ISTART, NPO, NITER,
     *   NFIT, NNFIT, IANT, NREF, REFANT, NANT,NANTS
C                                                          End QBEAM
LOCAL END
LOCAL INCLUDE 'IMAGE.QBEAM'
      INTEGER   IMSIZE
      PARAMETER (IMSIZE=512)
LOCAL END
      PROGRAM QBEAM
C-----------------------------------------------------------------------
C! Fits an analitic function to the measured values of the beam
C# UV Calibration EXT-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2024-2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   QBEAM fits the analytic function to the measured values of the beam
C   Inputs:
C      INNAME.....UV file name (name).       Standard defaults.
C      INCLASS....UV file name (class).      Standard defaults.
C      INSEQ......UV file name (seq. #).     0 => highest.
C      INDISK.....Disk unit #.               0 => any.
C      INFILE.....The name of a file with the measured points of the
C                 beam (first polarization)
C      DOTV.......> 0 => TV, else plot file
C      GRCHAN.....Graphics channel 0 => 1.
C      BADDISK....A list of disks on which scratch files are not to
C                 be placed.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'QBEAM.INC'
      DATA PRGM /'QBEAM '/
C-----------------------------------------------------------------------
C                                       Get input parameters
      CALL QBEAIN (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
      SAVLIN = ' '
C                                       prepare data for PLTFIT
 10   CALL PREPD (IRET)
      IF (IRET.NE.0) GO TO 990
C                                       plot the beam contours
      CALL PLTFIT (IRET)
      IRET = MAX (0, IRET)
      IF ((IRET.EQ.0) .AND. (SAVLIN.NE.' ')) GO TO 10
C                                       Close down files, etc.
 990  CALL DIE (IRET, BUFFER)
C
 999  STOP
      END
      SUBROUTINE QBEAIN (PRGN, JERR)
C-----------------------------------------------------------------------
C   QBEAIN gets input parameters for QBEAM.
C   Inputs:
C      PRGN    C*6       Program name
C   Output:
C      JERR    I         Error code: 0 => ok
C                           1 => Invalid request
C                           5 => catalog troubles
C                           8 => can't start
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      CHARACTER PRGN*6
      INTEGER   JERR
C
      INCLUDE 'QBEAM.INC'
      INTEGER   IERR, I, IROUND
      LOGICAL   T
C
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA T /.TRUE./
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (T, BUFFER)
      CALL VHDRIN
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 32
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEO, BUFFER, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) THEN
            GO TO 999
         ELSE
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
            END IF
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, BUFFER, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      SEQOU = IROUND (XSOU)
      DISKOU = IROUND (XDISOU)
      DOTV = XDOTV.GT.0.0
      GRCHN = XGRCHN + 0.01
      TVCHN = 1
      CALL FILL (4, 0, TVCORN)
      DO 15 I = 1,10
         IBAD(I) = IROUND (XBAD(I))
 15      CONTINUE
C                                       Convert characters
      CALL H2CHR (12, 1, XNAMEO, NAMEOU)
      CALL H2CHR (48, 1, XIFILE, INFILE)
      I = DOPLOT + 0.1
      CONTUR = MOD (I,2).EQ.1
      IRING = MOD (I/2,2).EQ.1
      IF (RADIUS.LE.0.0) RADIUS = 10000.
      THRESH = THRESH * THRESH
C                                       must have a file to attach
C                                       the plot files to
      IF (NAMEOU.EQ.' ') THEN
         IF (.NOT. DOTV) THEN
            MSGTXT = '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
            CALL MSGWRT (6)
            MSGTXT = 'OUTNAME='' '', DOTV.LE.0=> I switch to DOTV>0'
            CALL MSGWRT (6)
            MSGTXT = '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
            CALL MSGWRT (6)
            END IF
         DOTV = .TRUE.
         END IF
      JERR = 0
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('QBEAIN: ERROR',I3,' OBTAINING INPUT PARAMETERS')
      END
      SUBROUTINE PREPD (IRET)
C-----------------------------------------------------------------------
C   PREPD prepares the data for PLTFIT.
C   Output:  IRET    I         Error code: 0 => ok
C-----------------------------------------------------------------------
      INTEGER   IRET
      INCLUDE 'QBEAM.INC'
C
      INTEGER   IMEAS, I, NMEAS1
      DOUBLE PRECISION RRE, IMA, XMEAS1(MAXPOI), YMEAS1(MAXPOI),
     *  RREAL1(MAXPOI), IIMAG1(MAXPOI), AMMXX
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      AMMAX = 0.0D0
      PHMAX = 0.0
C                                       read the input file twice
C                                       1. to find the maximum of the
C                                          data
C                                       2. to devide the data by the
C                                          found maximum
      CALL READF (INFILE, NMEAS1, XMEAS1, YMEAS1, RREAL1, IIMAG1,
     *   IRET)
      IF (IRET.NE.0) GO TO 999
      THRESH = SQRT (THRESH)
C                                       read only one file
      NMEAS = NMEAS1
      DO 30 IMEAS = 1,NMEAS
         XMEAS(IMEAS) = XMEAS1(IMEAS)
         YMEAS(IMEAS) = YMEAS1(IMEAS)
         RRE = RREAL1(IMEAS)
         IMA = IIMAG1(IMEAS)
         AMPLS(IMEAS) = RRE*RRE + IMA*IMA
         AMMXX = MAX (AMMXX, AMPLS(IMEAS))
         IF (AMMAX.LT.AMPLS(IMEAS)) THEN
            AMMAX = AMPLS(IMEAS)
            PHMAX = ATAN2 (IMA, RRE)
            END IF
 30      CONTINUE
C                                       do normalization
      DO 60 IMEAS = 1,NMEAS
         AMPLS(IMEAS) = AMPLS(IMEAS) / AMMAX
 60      CONTINUE
      WRITE (MSGTXT,1060) AMMAX
      CALL MSGWRT (4)
C                                       plot xy ranges
      XYMAX(1) = -10000.
      XYMAX(2) = -10000.
      XYMIN(1) = 10000.
      XYMIN(2) = 10000.
      DO 130 I = 1,NMEAS
         XYMAX(1) = MAX (XYMAX(1), XMEAS(I))
         XYMIN(1) = MIN (XYMIN(1), XMEAS(I))
         XYMAX(2) = MAX (XYMAX(2), YMEAS(I))
         XYMIN(2) = MIN (XYMIN(2), YMEAS(I))
 130     CONTINUE
      IRET = 0
C
 999  RETURN
C-----------------------------------------------------------------------
 1060 FORMAT ('Data normalized by factor',F7.4)
      END
      SUBROUTINE READF (INPFIL, NNMEAS, XXMEAS, YYMEAS, RREAL, IIMAG,
     *   IRET)
C-----------------------------------------------------------------------
C   Routine to read the input file
C   Input:
C      INPFIL    C(*)  The file name
C   Output:
C      NNMEAS    I     Number of selected measurments
C      XXMEAS    R(*)  Array of selected Xs in minutes
C      YYMEAS    R(*)  Array of selected Ys in minutes
C      RREAL     R(*)  Array of real part of amplitude
C      IIMAG     R(*)  Array of image part of amplitude
C      IRET      I     Error; 0 => OK
C-----------------------------------------------------------------------
      INCLUDE 'QBEAM.INC'
      CHARACTER INPFIL*48
      INTEGER   NNMEAS, IRET
      DOUBLE PRECISION XXMEAS(*), YYMEAS(*), RREAL(*), IIMAG(*)
C
      CHARACTER SYM*8, KSTOKE*2
      LOGICAL   T, F, FA, FIRST, NEXT, EOF, GOTSOM
      INTEGER   LUNPR, PFIND, NIDENT, N2, IREF, KANT, KBPLIM, JTRIM,
     *   KBP, IERR, I, J
      DOUBLE PRECISION XT, YT, AMPSQR, RD2MI, PHADEG, TOLER0, XINIT,
     *   YINIT, DIFFX, DIFFY, PHAS, AMPI, AMPR, AMPP, XTP, YTP, KFREQU,
     *   XLAST, YLAST, RRE, IMA, XX
      CHARACTER LINE*80
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      SAVE LUNPR, PFIND
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       read the file
      IF (SAVLIN.EQ.' ') THEN
         LUNPR = 10
         FA = F
         CALL ZTXOPN ('READ', LUNPR, PFIND, INPFIL, .FALSE., IRET)
         IF (IRET.NE.0) THEN
            KBP = JTRIM (INPFIL)
            WRITE (MSGTXT,1000) INPFIL(:KBP)
            CALL MSGWRT (8)
            GO TO 999
            END IF
         END IF
C
      N2 = 1
      NNMEAS = 0
      RD2MI = 180.0D0 / PI * 60.0D0
C
      TOLER0 = 1.0D-06
      FIRST = T
      AMPR = 0
      AMPI = 0
      NIDENT = 0
C
      NREF = 0
      NANT = 0
      EOF = .FALSE.
      GOTSOM = .FALSE.
C                                       read the file data
 10   IF (SAVLIN.NE.' ') THEN
         LINE = SAVLIN
         SAVLIN = ' '
         IRET = 0
      ELSE
         CALL ZTXIO ('READ', LUNPR, PFIND, LINE, IRET)
         END IF
      IF (IRET.EQ.2) THEN
         EOF = .TRUE.
         GO TO 20
      ELSE IF (IRET.GT.0) THEN
         GO TO 999
      ELSE
         CALL CHTRIM (LINE, 80, LINE, KBPLIM)
C                                       read array of ref. antennas,
C                                       antenna number, polarization
C                                       and frequency
         IF (LINE(:10).EQ.'#! Average') GO TO 20
         IF ((LINE(:3).EQ.'#! ') .AND. (GOTSOM)) THEN
            SAVLIN = LINE
            GO TO 20
            END IF
         IF (LINE(:3).EQ.'#! ') THEN
            CALL CHLTOU (80, LINE)
            IF (LINE(:9).EQ.'#! REFANT') THEN
               KBP = 3
               CALL GETSYM (LINE, KBP, SYM, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GETNUM (LINE, KBPLIM, KBP, XX)
               IREF = -1
               IF (XX.NE.DBLANK) THEN
                  IREF = XX + 0.01
                  NREF = NREF + 1
                  REFANT(NREF) = IREF
               ELSE
                  IREF = -1
                  END IF
               CALL GETSYM (LINE, KBP, SYM, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GETNUM (LINE, KBPLIM, KBP, XX)
               IF (XX.NE.DBLANK) THEN
                  KANT = XX + 0.01
                  NANT = NANT + 1
                  NANTS(NANT) = KANT
               ELSE
                  KANT = -1
                  END IF
               CALL GETSYM (LINE, KBP, SYM, IERR)
               IF (IERR.NE.0) GO TO 999
               I = INDEX (LINE(KBP:), '''')
               KBP = KBP + I
               KSTOKE = LINE(KBP:KBP+1)
               I = INDEX (LINE(KBP:), '''')
               KBP = KBP + I
               CALL GETSYM (LINE, KBP, SYM, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GETNUM (LINE, KBPLIM, KBP, XX)
               KFREQU = 1.0D0
               IF (XX.NE.DBLANK) KFREQU = XX
               IANT = KANT
               STOKE = KSTOKE
               FREQU = KFREQU
            ELSE IF (LINE(:20).EQ.'#! AVERAGED REF-ANTS') THEN
               KBP = 23
 15            CALL GETNUM (LINE, KBPLIM, KBP, XX)
               IF (XX.NE.DBLANK) THEN
                  KANT = XX + 0.01
                  IF (KANT.GT.0) THEN
                     NREF = NREF + 1
                     REFANT(NREF) = KANT
                     GO TO 15
                     END IF
                  END IF
            ELSE IF (LINE(:20).EQ.'#! AVERAGED ANTENNAS') THEN
               KBP = 23
 16            CALL GETNUM (LINE, KBPLIM, KBP, XX)
               IF (XX.NE.DBLANK) THEN
                  KANT = XX + 0.01
                  IF (KANT.GT.0) THEN
                     NANT = NANT + 1
                     NANTS(NANT) = KANT
                     GO TO 16
                     END IF
                  END IF
               END IF
            END IF
C                                       loop if header card or blank
         IF ((KBPLIM.LE.0) .OR. (LINE(:1).EQ.'#')) GO TO 10
C                                       parse the data card
         KBP = 1
         CALL GETNUM (LINE, KBPLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         IF (DOSWIT) THEN
            YTP = XX
         ELSE
            XTP = XX
            END IF
         CALL GETNUM (LINE, KBPLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         IF (DOSWIT) THEN
            XTP = XX
         ELSE
            YTP = XX
            END IF
         CALL GETNUM (LINE, KBPLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         AMPP = XX
         CALL GETNUM (LINE, KBPLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         PHAS = XX * DG2RAD
C                                       really ASIN
         XTP = ASIN (XTP)
         YTP = ASIN (YTP)
         IF (FIRST) THEN
            XINIT = XTP
            YINIT = YTP
            FIRST = .FALSE.
            END IF
C                                       accumulate the identical points
         DIFFX = ABS(XTP - XINIT)
         DIFFY = ABS(YTP - YINIT)
         END IF
C                                       EOF comes here also
 20   NEXT = (DIFFX.GT.TOLER0) .OR. (DIFFY.GT.TOLER0) .OR. (EOF)
      IF (NEXT) THEN
         XINIT = XTP
         YINIT = YTP
         RRE = AMPR / NIDENT
         IMA = AMPI / NIDENT
         AMPSQR = (RRE*RRE + IMA*IMA)
         PHADEG = ABS(ATAN2(IMA,RRE)*RAD2DG)
         XT = XLAST
         YT = YLAST
C
         AMPR = AMPP * COS(PHAS)
         AMPI = AMPP * SIN(PHAS)
         XLAST = XTP
         YLAST = YTP
         NIDENT = 1
      ELSE
         AMPR = AMPR + AMPP * COS(PHAS)
         AMPI = AMPI + AMPP * SIN(PHAS)
         XLAST = XTP
         YLAST = YTP
         NIDENT = NIDENT + 1
         GO TO 10
         END IF
C                                       select the points with big
C                                       amplitude; exclude points with
C                                       big phase(sidelobes)
      XX = SQRT (XT*XT + YT*YT) * RD2MI
C                                       take the point exceeded the
C                                       threshold
      IF ((AMPSQR.GT.THRESH) .AND. (XX.LE.RADIUS)) THEN
         NNMEAS = NNMEAS + 1
         RREAL(NNMEAS) = RRE
         IIMAG(NNMEAS) = IMA
         XXMEAS(NNMEAS) = XT * RD2MI
         YYMEAS(NNMEAS) = YT * RD2MI
         GOTSOM = .TRUE.
         END IF
      IF ((.NOT.EOF) .AND. (SAVLIN.EQ.' ')) GO TO 10
C                                       close the infile
      IF (SAVLIN.EQ.' ') CALL ZTXCLS (LUNPR, PFIND, IRET)
C                                       trim lists
      IF (NANT.GT.1) THEN
         KBP = 1
         DO 50 I = 2,NANT
            DO 40 J = 1,I-1
               IF (NANTS(I).EQ.NANTS(J)) GO TO 50
 40            CONTINUE
            KBP = KBP + 1
            NANTS(KBP) = NANTS(I)
 50         CONTINUE
         NANT = KBP
         END IF
      IF (NREF.GT.1) THEN
         KBP = 1
         DO 70 I = 2,NREF
            DO 60 J = 1,I-1
               IF (REFANT(I).EQ.REFANT(J)) GO TO 70
 60            CONTINUE
            KBP = KBP + 1
            REFANT(KBP) = REFANT(I)
 70         CONTINUE
         NREF = KBP
         END IF
      IF (.NOT.GOTSOM) THEN
         MSGTXT = 'NO DATA FOUND'
         IRET = 10
         CALL MSGWRT (8)
         END IF
      GO TO 999
C                                       data error
 900  MSGTXT = 'BAD DATA RECORD ='
      CALL MSGWRT (8)
      MSGTXT = LINE
      CALL MSGWRT (8)
      IRET = 9
C
 999  RETURN
C-----------------------------------------------------------------
 1000 FORMAT ('ERROR OPENING FILE ''',A,'''')
      END
      SUBROUTINE PLTFIT (IRET)
C-----------------------------------------------------------------------
C   PLTFIT plots the data through calls to PLTEL
C   Output:
C      IRET   I   Return code, 0=OK else failed
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'QBEAM.INC'
      INCLUDE 'IMAGE.QBEAM'
      DOUBLE PRECISION DIMAG(IMSIZE,IMSIZE), X0, Y0, X1, Y1, SUM, DD,
     *   DRING(IMSIZE), DRSUM(IMSIZE)
      INTEGER   I
      REAL      SD
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      IRET = 0
C                                       compute model, residual
      X0 = 0.0D0
      Y0 = 0.0D0
      SUM = 0.0
      DO 20 I = 2,NMEAS
         DD = MAX (ABS(XMEAS(I)-XMEAS(I-1)),
     *      ABS(YMEAS(I)-YMEAS(I-1)))
         SUM = SUM + DD
 20      CONTINUE
      DD = SUM / MAX (1, NMEAS-1)
C                                       make an image header
      CALL CATINI (CATBLK)
      CALL CHR2H (8, 'BEAM POW', 1, CATH(KHBUN))
      CALL CHR2H (8, 'H-offset', 1, CATH(KHCTP))
      CALL CHR2H (8, 'V-offset', 1, CATH(KHCTP+2))
      CALL CHR2H (8, 'FREQ    ', 1, CATH(KHCTP+4))
      CALL CHR2H (8, 'STOKES  ', 1, CATH(KHCTP+6))
      X1 = MAX (ABS(XYMAX(1)), ABS(XYMIN(1)))
      Y1 = MAX (ABS(XYMAX(2)), ABS(XYMIN(2)))
      X1 = MAX (X1, Y1)
      X1 = 1.15 * X1 / 256.0
      CATR(KRCIC) = X1 / 60.0
      CATR(KRCIC+1) = X1 / 60.0
      CATR(KRCIC+2) = 1.0
      CATR(KRCIC+3) = 0.0
      CATBLK(KIDIM) = 4
      CATBLK(KINAX) = IMSIZE
      CATBLK(KINAX+1) = IMSIZE
      CATBLK(KINAX+2) = 1
      CATBLK(KINAX+3) = 1
      CATR(KRCRP) = IMSIZE/2
      CATR(KRCRP+1) = IMSIZE/2 + 1
      CATR(KRCRP+2) = 1.0
      CATR(KRCRP+3) = 1.0
C                                       plot data
      SD = 0.0D0
      CALL MAKIMG (NMEAS, 1.4, XMEAS, YMEAS, X0, Y0, AMPLS, DIMAG,
     *   DD, SD)
      WRITE (MSGTXT,1020) 'Data', SD
      CALL MSGWRT (2)
      IF (NAMEOU.NE.' ') THEN
         CALL OUTMAP (1, DIMAG, IRET)
         IF (IRET.NE.0) GO TO 999
         END IF
      IF (CONTUR) THEN
         CALL PLTMAP (1, NMEAS, XMEAS, YMEAS, X0, Y0, DIMAG, IRET)
         IF (IRET.LT.0) THEN
            IRING = .FALSE.
            CONTUR = .FALSE.
            END IF
         IF (IRET.GT.0) GO TO 999
         END IF
      IF (IRING) CALL DORING (DIMAG, DRING, DRSUM)
C                                       plot IRING
      IF (IRING) THEN
         CALL PLRING (.FALSE., DRING, DRSUM, IRET)
         IF (IRET.LT.0) THEN
            IRING = .FALSE.
            CONTUR = .FALSE.
            END IF
         IF (IRET.GT.0) GO TO 999
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT (A,' image further normalized by factor',F7.4)
      END
      SUBROUTINE MAKIMG (NMEAS, VPARM9, XMEAS, YMEAS, X0, Y0, VALS,
     *   IMAG, DD, XN)
C-----------------------------------------------------------------------
C   grid data to make an image
C   Inputs:
C      NMEAS   I      Number samples
C      XMEAS   D(*)   X values
C      YMEAS   D(*)   Y values
C      X0      D      X offset
C      Y0      D      Y offset
C      VALS    D(*)   data to grid
C      DD      D      Typical sample spacing
C   In/out:
C      XN      R
C   Output:
C      IMAG    R()    Image
C   In/out in common
C      CATBLK  I(256)   Image header
C-----------------------------------------------------------------------
      INCLUDE 'IMAGE.QBEAM'
      INTEGER   NMEAS
      REAL      VPARM9, XN
      DOUBLE PRECISION XMEAS(*), YMEAS(*), X0, Y0, VALS(*),
     *   IMAG(IMSIZE,IMSIZE), DD
C
      INTEGER   M, I, J, I1, I2, J1, J2, R
      DOUBLE PRECISION X, Y, W, WT(IMSIZE,IMSIZE), RX, CV(1000)
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
C                                       compute convolving function
      IF (VPARM9.LE.0.0) VPARM9 = 1.4
      W = DD / ABS (60.0D0*CATR(KRCIC)) / VPARM9
      W = W / SQRT (LOG(3.0D0))
      RX = 0.0
      DO 10 I = 1,1000
         CV(I) = EXP (-((I-1) / W)**2)
         IF (CV(I).GT.0.005D0) RX = I
 10      CONTINUE
C                                       zero
      I = IMSIZE * IMSIZE
      CALL DFILL (I, 0.0D0, IMAG)
      CALL DFILL (I, 0.0D0, WT)
C                                       loop over points
      DO 50 M = 1,NMEAS
         X = (XMEAS(M) - X0) / CATR(KRCIC) / 60.0 + CATR(KRCRP)
         Y = (YMEAS(M) - Y0) / CATR(KRCIC+1) / 60.0 + CATR(KRCRP+1)
         X = XMEAS(M) / CATR(KRCIC) / 60.0 + CATR(KRCRP)
         Y = YMEAS(M) / CATR(KRCIC+1) / 60.0 + CATR(KRCRP+1)
         I1 = X - RX
         J1 = Y - RX
         I2 = X + RX + 0.99
         J2 = Y + RX + 0.99
         I1 = MAX (1, I1)
         J1 = MAX (1, J1)
         I2 = MIN (IMSIZE, I2)
         J2 = MIN (IMSIZE, J2)
         DO 30 J = J1,J2
            DO 20 I = I1,I2
               R = SQRT ((X-I)*(X-I) + (Y-J)*(Y-J)) + 0.5
               IMAG(I,J) = IMAG(I,J) + VALS(M) * CV(R)
               WT(I,J) = WT(I,J) + CV(R)
 20            CONTINUE
 30         CONTINUE
 50      CONTINUE
C                                       normalize
      X = -1.E6
      Y = 1.E6
      DO 70 J = 1,IMSIZE
         DO 60 I = 1,IMSIZE
            IF (WT(I,J).LE.0.0) THEN
               IMAG(I,J) = FBLANK
            ELSE
               IMAG(I,J) = IMAG(I,J) / WT(I,J)
               X = MAX (X, IMAG(I,J))
               Y = MIN (Y, IMAG(I,J))
               END IF
 60         CONTINUE
 70      CONTINUE
      IF (XN.LE.0.0) XN = X
      Y = 1.E6
      X = -Y
      DO 90 J = 1,IMSIZE
         DO 80 I = 1,IMSIZE
            IF (WT(I,J).GT.0.0) THEN
               IMAG(I,J) = IMAG(I,J) / XN
               X = MAX (X, IMAG(I,J))
               Y = MIN (Y, IMAG(I,J))
               END IF
 80         CONTINUE
 90      CONTINUE
C                                       header
      CATR(KRDMX) = X
      CATR(KRDMN) = Y
      CATR(KRBLK) = FBLANK
C
 999  RETURN
      END
      SUBROUTINE OUTMAP (IPLT, IMAG, IRET)
C-----------------------------------------------------------------------
c   OUTMAP creates and fills the output image file
C   Inputs
C      IPLT   I      1,2,3 => data. model. residual
C      IMAG   R      Image(IMSIZE,IMSIZE)
C   Outputs:
C      IRET   I      > 0 => failed.
C-----------------------------------------------------------------------
      INCLUDE 'IMAGE.QBEAM'
      INTEGER   IPLT, IRET
      DOUBLE PRECISION IMAG(IMSIZE,IMSIZE)
C
      INCLUDE 'QBEAM.INC'
      INCLUDE 'INCS:PMAD.INC'
      INTEGER   WIN(4), LUN, IND, JBUFSZ, IBIND, IY, DATE(3), TIME(3),
     *   IX, J, JTRIM
      REAL      BUFF1(MABFSS)
      CHARACTER IPTYPE(3)*1, PHNAME*48, CTIME*8, CDATE*12, HILINE*72,
     *   ST*1
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      DATA IPTYPE /'D','M','R'/
      DATA LUN /28/
C-----------------------------------------------------------------------
      DISKOU = XDISOU + 0.1
      SEQOU = XSOU + 0.1
      CATBLK(KIIMS) = SEQOU
      CATD(KDCRV+2) = FREQU * 1.D9
      ST = STOKE(:1)
      CALL CHR2H (12, NAMEOU, KHIMNO, CATH(KHIMN))
      CLASOU = 'QBEAM' // ST
      CALL CHR2H (6, CLASOU, KHIMCO, CATH(KHIMC))
      CALL CHR2H (2, 'MA', KHPTYO, CATH(KHPTY))
      IF (ST.EQ.'I') CATD(KDCRV+3) = 1.0D0
      IF (ST.EQ.'Q') CATD(KDCRV+3) = 2.0D0
      IF (ST.EQ.'U') CATD(KDCRV+3) = 3.0D0
      IF (ST.EQ.'V') CATD(KDCRV+3) = 4.0D0
      IF (ST.EQ.'R') CATD(KDCRV+3) = -1.0D0
      IF (ST.EQ.'L') CATD(KDCRV+3) = -2.0D0
      IF (ST.EQ.'X') CATD(KDCRV+3) = -5.0D0
      IF (ST.EQ.'Y') CATD(KDCRV+3) = -6.0D0
C                                       Create new cataloged file.
      CALL MCREAT (DISKOU, CNOUT, BUFFER, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IPLT, IRET, 'CREATE IMAGE FILE'
         GO TO 990
         END IF
      SEQOU = CATBLK(KIIMS)
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKOU
      FCNO(NCFILE) = CNOUT
      FRW(NCFILE) = 2
C                                       open output
      CALL ZPHFIL ('MA', DISKOU, CNOUT, 1, PHNAME, IRET)
      CALL ZOPEN (LUN, IND, DISKOU, PHNAME, .TRUE., .TRUE., .TRUE.,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IPLT, IRET, 'OPEN IMAGE FILE'
         GO TO 990
         END IF
      WIN(1) = 1
      WIN(2) = 1
      WIN(3) = IMSIZE
      WIN(4) = IMSIZE
      JBUFSZ = 2 * MABFSS
      CALL MINIT ('WRIT', LUN, IND, IMSIZE, IMSIZE, WIN, BUFF1, JBUFSZ,
     *   1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IPLT, IRET, 'INIT IO TO IMAGE'
         GO TO 990
         END IF
      DO 20 IY = 1,IMSIZE
         CALL MDISK ('WRIT', LUN, IND, BUFF1, IBIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IPLT, IRET, 'WRITE IMAGE ROW'
            GO TO 990
            END IF
         DO 10 IX = 1,IMSIZE
            BUFF1(IBIND+IX-1) = IMAG(IX,IY)
 10         CONTINUE
 20      CONTINUE
      CALL MDISK ('FINI', LUN, IND, BUFF1, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IPLT, IRET, 'WRITE LAST IMAGE ROW'
         GO TO 990
         END IF
      CALL ZCLOSE (LUN, IND, IRET)
C                                       make a history file
      CALL HIINIT (2)
      CALL HICREA (LUN, DISKOU, CNOUT, CATBLK, BUFFER, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IPLT, IRET, 'CREATE HISTORY FILE'
         CALL MSGWRT (7)
         END IF
      IF (IRET.EQ.0) THEN
         CALL ZDATE (DATE)
         CALL ZTIME (TIME)
         CALL TIMDAT (TIME, DATE, CTIME, CDATE)
         WRITE (HILINE,1100) TSKNAM, RLSNAM, CDATE, CTIME
         CALL HIADD (LUN, HILINE, BUFFER, IRET)
         IF (IRET.NE.0) GO TO 30
         J = JTRIM (INFILE)
         WRITE (HILINE,1101) TSKNAM, INFILE(:J)
         CALL HIADD (LUN, HILINE, BUFFER, IRET)
         IF (IRET.NE.0) GO TO 30
         WRITE (HILINE,1102) TSKNAM, RADIUS
         CALL HIADD (LUN, HILINE, BUFFER, IRET)
         IF (IRET.NE.0) GO TO 30
         WRITE (HILINE,1103) TSKNAM, THRESH
         CALL HIADD (LUN, HILINE, BUFFER, IRET)
         IF (IRET.NE.0) GO TO 30
         WRITE (HILINE,1104) TSKNAM, AMMAX
         CALL HIADD (LUN, HILINE, BUFFER, IRET)
 30      CALL HICLOS (LUN, .TRUE., BUFFER, IRET)
         END IF
      IRET = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('OUTMAP IMAGE',I2,' ERROR',I4,' ON ',A)
 1100 FORMAT (A6,'RELEASE =''',A7,' ''  /********* Start ',A12,2X,A8)
 1101 FORMAT (A6,'INFILE=''',A,'''')
 1102 FORMAT (A6,'RADIUS=',F9.2,'  / Max radius in arc minutes')
 1103 FORMAT (A6,'CUTOFF=',F9.4,'  / Min data value included')
 1104 FORMAT (A6,'FACTOR=',F9.5,'  / Data scaled to 1.0 by 1/factor')
      END
      SUBROUTINE PLTMAP (IPLT, NM, XM, YM, X0, Y0, IMAG, IRET)
C-----------------------------------------------------------------------
C   Makes a TV or plot file of an image
C   Inputs:
C      IPLT    I      Which image: 1-3 -> data, model, residual
C      NM      I      Number samples: values below to make + signs
C      XM      R(*)   X values
C      YM      R(*)   Y values
C      X0      R      X offset
C      Y0      R      Y offset
C      IMAG    R(*)   image
C   Outputs:
C      IRET    I      error code
C-----------------------------------------------------------------------
      INCLUDE 'IMAGE.QBEAM'
      INTEGER   IPLT, NM, IRET
      DOUBLE PRECISION XM(*), YM(*), X0, Y0, IMAG(IMSIZE,IMSIZE)
C
      INCLUDE 'QBEAM.INC'
      INTEGER   PLBUFF(256), VER, I, IPSIZE, ITYPE, LUNPL, FINDPL, INP,
     *   LABEL, LTYPE, DEPTH(5), INCHAR, ID(3), IT(3), IERR, NLINE, J,
     *   JPLT, NLEVS, NLTEXT, JTRIM, ITEMP
      REAL      BLC(2), TRC(2), XYRATO, CHOUT(4), DX, DY, Y, X, XLEV,
     *   ALEVS(30), DMAX, DMIN
      CHARACTER PFILE*48, TEXT*128, IMGTYP(3)*8, ATIME*8, ADATE*12,
     *   LTEXT(2)*128, CHTEMP*18
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA DEPTH /5*1/
      DATA IMGTYP /'Data', 'Model', 'Residual'/
C-----------------------------------------------------------------------
      JPLT = MIN (3, IPLT)
      BLC(1) = 0.5
      BLC(2) = 0.5
      TRC(1) = IMSIZE + 0.5
      TRC(2) = IMSIZE + 0.5
      XYRATO = 1.0
C                                       fool with location common
      LOCNUM = 1
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      CPREF(1,LOCNUM) = ' '
      CPREF(2,LOCNUM) = ' '
      CTYP(1,LOCNUM) = 'H-offset'
      CTYP(2,LOCNUM) = 'V-offset'
      CPREF(1,LOCNUM) = ' Arc '
      CPREF(2,LOCNUM) = ' Arc '
      CTYP(1,LOCNUM) = 'Minutes'
      CTYP(2,LOCNUM) = 'Minutes'
      DO 10 I = 1,2
         RPLOC(I,LOCNUM) = CATR(KRCRP+I-1)
         RPVAL(I,LOCNUM) = 0.0D0
         AXINC(I,LOCNUM) = CATR(KRCIC+I-1) * 60.0
10       CONTINUE
C                                       contour levels
      DMIN = MIN (0.0, CATR(KRDMN))
      DMIN = CATR(KRDMN)
      DMAX = CATR(KRDMX)
C                                       data, model
      NLEVS = 0
      CALL RFILL (20, -100.0, ALEVS)
      IF (DMAX.GT.0.8) THEN
         XLEV = -1.05
         DO 15 J = 1,20
            XLEV = XLEV + 0.1
            IF ((XLEV.GE.DMIN) .AND. (XLEV.LE.DMAX)) THEN
               NLEVS = NLEVS + 1
               ALEVS(NLEVS) = XLEV
               END IF
 15         CONTINUE
         CALL LEVTXT (2, NLEVS, ALEVS, NLTEXT, LTEXT)
C                                       residual
      ELSE
         XLEV = -0.155
         DO 16 J = 1,30
            XLEV = XLEV + 0.01
            IF ((XLEV.GE.DMIN) .AND. (XLEV.LE.DMAX)) THEN
               NLEVS = NLEVS + 1
               ALEVS(NLEVS) = XLEV
               END IF
 16         CONTINUE
         CALL LEVTXT (3, NLEVS, ALEVS, NLTEXT, LTEXT)
         END IF
C                                       create plot object
      VER = 0
      IF (.NOT.DOTV) THEN
         CALL MADDEX ('PL', DISKOU, CNOUT, CATBLK, PLBUFF, .TRUE.,
     *      'WRIT', VER, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL ZPHFIL ('PL', DISKOU, CNOUT, VER, PFILE, IRET)
         IF (IRET.NE.0) GO TO 960
         END IF
      IPSIZE = 0
      ITYPE = 80
C
      DOPLOT = IPLT
      CALL GINIT (DISKOU, CNOUT, PFILE, IPSIZE, ITYPE, NPARM,
     *   XNAMEO, DOTV, TVCHN, GRCHN, TVCORN, CATBLK, PLBUFF, LUNPL,
     *   FINDPL, IRET)
      IF (IRET.NE.0) GO TO 960
C                                       off graphics
      IF ((DOTV) .AND. (GRCHN.LE.0)) THEN
         DO 5 I = 1,4
            CALL YSLECT ('OFFF', I+NGRAY, 7, BUFFER, IRET)
 5          CONTINUE
         END IF
C                                       Number of characters on each
C                                       side of the plot
      CALL RFILL (4, 0.5, CHOUT)
C                                       Not fully initialized, may make
C                                       INP too large which is okay.
      CALL CHNTIC (BLC, TRC, INP)
      INP = MAX (INP, 3)
C                                       standard labeling
      LABEL = 3
      LTYPE = 3
      CHOUT(1) = INP + 4.0
      CHOUT(2) = 3.333 + 1.333 * NLTEXT
      NLINE = 3
      IF (NANT.GT.1) THEN
         NLINE = NLINE + 1
         IF (NREF.GT.15) NLINE = NLINE + 1
      ELSE
         IF (NREF.GT.11) NLINE = NLINE + 1
         END IF
      CHOUT(4) = 1.0 + 1.333*NLINE
C                                       Init for line drawing.
      CALL GINITL (BLC, TRC, XYRATO, CHOUT, DEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1000) VER
         CALL MSGWRT (3)
         END IF
C                                       Draw border
      CALL GLTYPE (1, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Top labels: type & name
      DX = 0.0
C                                       Date/time/version
      DY = CHOUT(4) - 1.833
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL ZDATE (ID)
      CALL ZTIME (IT)
      CALL TIMDAT (IT, ID, ATIME, ADATE)
      WRITE (TEXT,1100) VER, ADATE, ATIME
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       The second line of the header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Power beam ' // IMGTYP(JPLT)
      CALL REFRMT (TEXT, ' ', INCHAR)
      IF (NAMEOU.NE.' ') THEN
         TEXT(INCHAR+1:) = '____'
         INCHAR = INCHAR+5
         CALL H2CHR (12, KHIMNO, CATH(KHIMN), CHTEMP(1:12))
         CALL H2CHR (6, KHIMCO, CATH(KHIMC), CHTEMP(13:18))
         CALL NAMEST (CHTEMP, CATBLK(KIIMS), TEXT(INCHAR:), ITEMP)
         CALL REFRMT (TEXT, '_', INCHAR)
         END IF
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       the third line of header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       model
      IF ((NANT.LE.1) .AND. (NREF.LE.11)) THEN
         WRITE (TEXT,1050) IANT, FREQU, STOKE, (REFANT(I), I = 1,NREF)
      ELSE IF (NANT.LE.1) THEN
         WRITE (TEXT,1051) IANT, FREQU, STOKE
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
      ELSE IF (NREF.LE.15) THEN
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1054) FREQU, STOKE, (REFANT(I), I = 1,MIN(24,NREF))
      ELSE
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1055) FREQU, STOKE
         END IF
      INP = 7
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       contour levels
      DY = -2.833
      DX = 0.0
      DO 17 I = 1,NLTEXT
         DY = DY - 1.333
         CALL GPOS (BLC(1), BLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         INCHAR = JTRIM (LTEXT(I))
         CALL GCHAR (INCHAR, 0, DX, DY, LTEXT(I), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
 17      CONTINUE
C                                       Put on labels and ticks
      CALL CLAB1 (BLC, TRC, CHOUT, LABEL, XYRATO, .FALSE., PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       little pluses
      CALL GLTYPE (1, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DX = 2.0
      DY = 2.0
      DO 20 I = 1,NM
         X = XM(I) / CATR(KRCIC) / 60.0 + CATR(KRCRP)
         Y = YM(I) / CATR(KRCIC+1) / 60.0  + CATR(KRCRP+1)
         CALL GPOS (X-DX, Y, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X+DX, Y, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GPOS (X, Y-DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X, Y+DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
 20      CONTINUE
C                                       contours
      CALL GLTYPE (2, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL IMGDRW (NLEVS, ALEVS, IMAG, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Done: finish plot
      GPHPAG = IPLT.NE.4
      CALL GFINIS (PLBUFF, IRET)
      IF (IRET.GT.0) GO TO 975
      IF (.NOT.DOTV) THEN
         CALL HIPLOT (DISKOU, CNOUT, VER, BUFFER, IRET)
         IRET = 0
         END IF
      GO TO 999
C                                       ZPHFIL or GINIT failure.
 960  WRITE (MSGTXT,2000)
      CALL MSGWRT (8)
C
      IF (.NOT.DOTV) THEN
         CALL DELEXT ('PL', DISKOU, CNOUT, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         END IF
      GO TO 999
C                                       Try to finish partial graph
 970  MSGTXT = 'PLOT ERROR OCCURRED: TRY TO FINISH PARTIAL PLOT'
      CALL MSGWRT (7)
      GPHPAG = IPLT.NE.4
      CALL GFINIS (PLBUFF, IERR)
      IF (IERR.NE.0) GO TO 975
         IF (.NOT.DOTV) THEN
            CALL HIPLOT (DISKOU, CNOUT, VER, BUFFER, IERR)
            IERR = 0
            END IF
         GO TO 999
C                                       Destroy the plot file
 975  IF (.NOT.DOTV) THEN
         CALL ZCLOSE (LUNPL, FINDPL, IERR)
         CALL ZDESTR (DISKOU, PFILE, IERR)
         CALL DELEXT ('PL', DISKOU, CNOUT, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Plot file version',I4,'  created.')
 1050 FORMAT ('Antenna',I3,' Freq =',F7.3,' GHz Pol = ',A2,
     *   ' RefAnts=',11I3)
 1051 FORMAT ('Antenna',I3,' Freq =',F7.3,' GHz Pol = ',A2)
 1052 FORMAT ('RefAnt =',24I3)
 1053 FORMAT ('Antennas =',23I3)
 1054 FORMAT ('Freq =',F7.3,' GHz Pol = ',A2,' RefAnts=',15I3)
 1055 FORMAT ('Frequency =',F7.3,' GHz Pol = ',A2)
 1100 FORMAT ('Plot file version',I4,'__created ',A, A)
 2000 FORMAT ('PLTEL: ERROR DURING GRAPH FILE CREATION')
      END
      SUBROUTINE LEVTXT (IFMT, NLEVS, ALEVS, NLTEXT, LTEXT)
C-----------------------------------------------------------------------
C   Prepares the string(s) describing the contour levels
C   Inputs
C      IFMT     I      number of digits after the decimal (2, 3)
C      NLEVS    I      Number of levels
C      ALEVS    R(*)   Levels
C   Output:
C      NLTEXT   I      Number of text lines
C      LTEXT    C*(*)  Text to put on plot
C-----------------------------------------------------------------------
      INTEGER   IFMT, NLEVS, NLTEXT
      REAL      ALEVS(*)
      CHARACTER LTEXT(2)*(*)
C
      INTEGER   I, J, K, N, NNEG, NCH
      CHARACTER STRING*10
C-----------------------------------------------------------------------
      NNEG = 0
      DO 10 I = 1,NLEVS
         IF (ALEVS(I).LT.0.0) NNEG = NNEG + 1
 10      CONTINUE
      NCH = (2 + IFMT) * NLEVS + NNEG + 2 * (NLEVS-1) + 1
      NLTEXT = 1
      IF (NCH.GT.72) NLTEXT = 2
      NCH = NCH + 8 * NLTEXT
      J = 1
      LTEXT(J) = 'LEVS = ('
      LTEXT(2) = ' '
      K = 9
      DO 30 I = 1,NLEVS
         IF (IFMT.EQ.2) THEN
            WRITE (STRING,1010) ALEVS(I)
         ELSE
            WRITE (STRING,1011) ALEVS(I)
            END IF
         CALL CHTRIM (STRING, 10, STRING, N)
         LTEXT(J)(K:) = STRING(:N)
         K = K + N
         IF (I.LT.NLEVS) THEN
            LTEXT(J)(K:) = ', '
            K = K + 2
         ELSE
            LTEXT(J)(K:) = ')'
            K = K + 1
            END IF
         IF ((NLTEXT.EQ.2) .AND. (J.EQ.1) .AND. (K.GT.NCH/2)) THEN
            J = 2
            K = 9
            END IF
 30      CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT (F10.2)
 1011 FORMAT (F10.3)
      END
      SUBROUTINE IMGDRW (INLEVS, ALEVS, IMAG, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   Draw contours of IMAG in plot buffer
C   Inputs:
C      INLEVS   I            Number contour values
C      alevs    r(*)         Contour levels
C      IMAG     R(IMSIZE,IMSIZE)   Image
C   In/Out:
C      PLBUFF   I(256)       Plot buffer
C   Outputs:
C      IRET     I            Error code
C-----------------------------------------------------------------------
      INCLUDE 'IMAGE.QBEAM'
      INTEGER   INLEVS, PLBUFF(*), IRET
      REAL      ALEVS(*)
      DOUBLE PRECISION IMAG(IMSIZE,IMSIZE)
C
      REAL      VAL(3), XPOS(3), YPOS(3), TEMP, VC, VL, VM, VS, XA, XB,
     *   XL, XLAST, XM, XS, YA, YB, YL, YLAST, YM, YS, DELTAX, DELTAY,
     *   TLEV, XLEV, XP, YP, XSCALE, YSCALE, XMIN, YMIN, XMAX, YMAX
      INTEGER   IPERM(3,6), IBLCX, IBLCY, ICOL, II, INDEX, INPIXS,
     *   IPLUS, IROW, ITRCX, ITRCXM, ITRCY, ITRI, I, MININT, LOCINT,
     *   IROUND, ISLEV, JJ, IX
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DCNT.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA IPERM /1,3,2, 3,2,1, 3,1,2, 2,1,3, 1,2,3, 2,3,1/
C-----------------------------------------------------------------------
      XLAST = -1000.
      YLAST = -1000.
      TEMP = IMSIZE - 1
      TEMP = 10 - 3 * LOG10 (TEMP)
      LOCINT = IROUND (TEMP)
      IF (LOCINT.LT.2) LOCINT = 2
      IBLCY = 1
      ITRCY = IMSIZE
      ITRCX = IMSIZE
      IBLCX = 1
      INPIXS = ITRCX - IBLCX + 1
      XMIN = (1.0 - CATR(KRCRP)) * CATR(KRCIC) * 60.0
      YMIN = (1.0 - CATR(KRCRP+1)) * CATR(KRCIC+1) * 60.0
      XMAX = (IMSIZE - CATR(KRCRP)) * CATR(KRCIC) * 60.0
      YMAX = (IMSIZE - CATR(KRCRP+1)) * CATR(KRCIC+1) * 60.0
      XSCALE = (XMAX - XMIN) / (IMSIZE -1.0)
      YSCALE = (YMAX - YMIN) / (IMSIZE -1.0)
C                                       magic parms for dashed lines
      XLEV = 256.0 / INPIXS
      TLEV = 256.0 / (ITRCY - IBLCY + 1.0)
      ISLEV = SQRT (1.0 / (XLEV * TLEV)) + 0.1
      IF (ISLEV.LT.1) ISLEV = 1
      IF (XLEV.LT.1.0) XLEV = (SQRT (XLEV) + 3.0*XLEV) / 4.0
C                                       Save first row.
      DO 30 IX = 1,IMSIZE
         RLROW(IX) = IMAG(IX,1)
 30      CONTINUE
C                                       loop over all rows
      DO 300 IROW = 2,IMSIZE
C                                       Loop over all pixels in row.
         IPLUS = 0
         ITRCXM = IMSIZE - 1
         DO 110 IX = 1,IMSIZE
            BUFF(IX) = IMAG(IX,IROW)
 110        CONTINUE
         DO 250 ICOL = 1,ITRCXM
            IPLUS = IPLUS + 1
C                                       Init values
            VAL(1) = BUFF(IPLUS)
            VAL(2) = BUFF(1+IPLUS)
            VAL(3) = RLROW(IPLUS)
            IF ((ICOL.EQ.256) .AND. (IROW.EQ.256)) THEN
               MSGTXT = 'WE ARE HERE'
               END IF
C                                       Init positions.
            XPOS(1) = ICOL
            XPOS(2) = ICOL + 1
            XPOS(3) = ICOL
            YPOS(1) = IROW
            YPOS(2) = IROW
            YPOS(3) = IROW - 1
C                                       Loop for both triangles.
            DO 200 ITRI = 1,2
C                                       Changes for 2nd triangle.
               IF (ITRI.EQ.2) THEN
                  VAL(1) = RLROW(IPLUS+1)
                  XPOS(1) = ICOL + 1
                  YPOS(1) = IROW - 1
                  END IF
C                                       Order points in triangle.
               DO 130 II = 1,3
                  IF (VAL(II).EQ.FBLANK) GO TO 200
 130              CONTINUE
               INDEX = 0
               IF (VAL(1).GT.VAL(2)) INDEX = 1
               IF (VAL(3).GE.VAL(1)) INDEX = INDEX + 2
               IF (VAL(2).GE.VAL(3)) INDEX = INDEX + 4
C                                       find large, med, small
C                                       values and X,Y positions.
               II = IPERM(1,INDEX)
               VL = VAL(II)
               XL = XPOS(II)
               YL = YPOS(II)
C
               II = IPERM(2,INDEX)
               VM = VAL(II)
               XM = XPOS(II)
               YM = YPOS(II)
C
               II = IPERM(3,INDEX)
               VS = VAL(II)
               XS = XPOS(II)
               YS = YPOS(II)
C                                       Loop for all levels.
               DO 190 II = 1,INLEVS
                  VC = ALEVS(II)
C                                       Cut down negatives
                  IF (VC.GE.0.0) GO TO 140
                     IF ((XLEV.LT.2.85) .AND. (ITRI.EQ.2)) GO TO 190
                     IF (XLEV.GE.1.0) GO TO 140
                        JJ = IROW + ICOL + II
                        IF (MOD(JJ, ISLEV).NE.0) GO TO 190
 140              IF ((VC.GT.VL) .OR. ((VL-VS).LE.0.0)) GO TO 200
C                                       If level not right, next lev.
                  IF (VC.LE.VS) GO TO 190
C                                       Interpolate btwn max two corns.
                  TEMP = (VC-VS) / (VL-VS)
                  XA = TEMP * (XL-XS) + XS
                  YA = TEMP * (YL-YS) + YS
C                                       See which corners 2nd pt. btwn.
                  IF (VC.GT.VM) GO TO 150
                  IF (VM.EQ.VS) GO TO 150
C                                       Level btwn med & small corners.
                     TEMP = (VC-VS) / (VM-VS)
                     XB = TEMP * (XM-XS) + XS
                     YB = TEMP * (YM-YS) + YS
                     GO TO 160
C                                       Level btwn large & med corners.
 150                 TEMP = (VC-VM) / (VL-VM)
                     XB = TEMP * (XL-XM) + XM
                     YB = TEMP * (YL-YM) + YM
C                                       Issue position & write commands
C                                       We can avoid position command
C                                       if we switch A and B.
 160              IF ((XLAST.EQ.XB) .AND. (YLAST.EQ.YB)) THEN
                     TEMP = XA
                     XA = XB
                     XB = TEMP
                     TEMP = YA
                     YA = YB
                     YB = TEMP
C                                       See if we need to position.
                  ELSE IF ((XLAST.NE.XA) .OR. (YLAST.NE.YA)) THEN
                     XP = (XMIN + (XA - 1.) * XSCALE) / CATR(KRCIC)/60.
     *                  + CATR(KRCRP)
                     YP = (YMIN + (YA - 1.) * YSCALE) / CATR(KRCIC+1)
     *                  / 60. + CATR(KRCRP+1)
                     CALL GPOS (XP, YP, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 999
                     END IF
C                                       Draw vector.
                  IF (VC.GE.0.0) THEN
                     XP = (XMIN + (XB - 1.) * XSCALE) / CATR(KRCIC)/60.
     *                  + CATR(KRCRP)
                     YP = (YMIN + (YB - 1.) * YSCALE) / CATR(KRCIC+1)
     *                  / 60.0 + CATR(KRCRP+1)
                     CALL GVEC (XP, YP, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 999
                     XLAST = XB
                     YLAST = YB
                     GO TO 190
C                                       Negative contours broken
                  ELSE
                     TEMP = LOCINT * SQRT (((XB-XA)**2 + (YB-YA)**2)
     *                  / 2.0)
                     MININT = IROUND (TEMP)
                     IF (MININT.LT.2) MININT = 2
                     DELTAX = (XB - XA) / MININT
                     DELTAY = (YB - YA) / MININT
                     DO 185 I = 1,MININT,2
                        XB = XA + DELTAX
                        YB = YA + DELTAY
                        XP = (XMIN + (XB - 1.) * XSCALE) / CATR(KRCIC)
     *                     /60. + CATR(KRCRP)
                        YP = (YMIN + (YB - 1.) * YSCALE) / CATR(KRCIC+1)
     *                     /60. + CATR(KRCRP+1)
                        CALL GVEC (XP, YP, PLBUFF, IRET)
                        IF (IRET.NE.0) GO TO 999
                        IF (I.LT.MININT-1) THEN
                           XA = XB + DELTAX
                           YA = YB + DELTAY
                           XP = (XMIN + (XA - 1.) * XSCALE) /
     *                        CATR(KRCIC)/60. + CATR(KRCRP)
                           YP = (YMIN + (YA - 1.) * YSCALE) /
     *                        CATR(KRCIC+1)/60. + CATR(KRCRP+1)
                           CALL GPOS (XP, YP, PLBUFF, IRET)
                           IF (IRET.NE.0) GO TO 999
                           END IF
 185                    CONTINUE
                     XLAST = XB
                     YLAST = YB
                     END IF
 190              CONTINUE
 200           CONTINUE
 250        CONTINUE
         CALL RCOPY (INPIXS, BUFF, RLROW)
 300     CONTINUE
C
 999  RETURN
      END
      SUBROUTINE DORING (IMAG, RING, RSUM)
C-----------------------------------------------------------------------
C   DORING sums up IMAG in rings
C   Inputs
C      IMAG   R(*,*)   Image
C   Outputs:
C      RING   R(*)     Average in rings
C      RSUM   R(*)     Sum inside ring
C-----------------------------------------------------------------------
      INCLUDE 'IMAGE.QBEAM'
      DOUBLE PRECISION IMAG(IMSIZE,IMSIZE), RING(*), RSUM(*)
C
      INCLUDE 'QBEAM.INC'
      INTEGER   NP(IMSIZE), I, J, K, NRING
      DOUBLE PRECISION RX, RY, RR
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      NRING = IMSIZE / 2
      CALL FILL (IMSIZE, 0, NP)
      CALL DFILL (IMSIZE, 0.0D0, RING)
C                                       geometry from PLTFIT, not IRING
      DO 30 J = 1,IMSIZE
         DO 20 I = 1,IMSIZE
            IF (IMAG(I,J).NE.FBLANK) THEN
               RX = I - CATR(KRCRP)
               RY = J - CATR(KRCRP+1)
               RR = SQRT ((RX)**2 + (RY)**2)
               K = RR + 1.0
               IF ((K.GE.1) .AND. (K.LE.NRING)) THEN
                  NP(K) = NP(K) + 1
                  RING(K) = RING(K) + IMAG(I,J)
                  END IF
               END IF
 20         CONTINUE
 30      CONTINUE
      DO 40 I = 1,NRING
         IF (I.EQ.1) THEN
            RSUM(I) = RING(I)
         ELSE
            RSUM(I) = RSUM(I-1) + RING(I)
            END IF
         IF (NP(I).GT.1) RING(I) = RING(I) / NP(I)
 40      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE PLRING (LFRING, DRING, DRSUM, IRET)
C-----------------------------------------------------------------------
C   PLRING makes plots of the IRING-like data
C   Inputs
C      LFRING  L      more plots after this
C      DRING   R(*)   IRING averages of input data image
C      MRING   R(*)   IRING averages of model image
C   Outputs:
C      IRET    I      Error code
C-----------------------------------------------------------------------
      LOGICAL   LFRING
      INTEGER   IRET
      DOUBLE PRECISION DRING(*), DRSUM(*)
C
      INCLUDE 'IMAGE.QBEAM'
      INCLUDE 'QBEAM.INC'
      INTEGER   PLBUFF(256), MP, VER, I, IPSIZE, ITYPE, LUNPL, FINDPL,
     *   INP, LABEL, LTYPE, DEPTH(5), INCHAR, ID(3), IT(3), IERR, NLINE,
     *   ITEMP
      REAL      YMAX, BLC(2), TRC(2), XYRATO, CHOUT(4), DX, DY, Y, X,
     *   XSCALE, YSCALE, YMIN, AR, X1, Y1
      CHARACTER PFILE*48, TEXT*128, ATIME*8, ADATE*12, CHTEMP*18
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      MP = 0
      YMAX = -1000
      BLC(1) = 0
      BLC(2) = 0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      XYRATO = 1.414
      DO 10 I = 1,IMSIZE
         IF (DRING(I).GT.YMAX) YMAX = DRING(I)
         IF (DRING(I).GT.0.0) MP = I
 10      CONTINUE
C                                       fool with location common
      LOCNUM = 1
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      CPREF(1,LOCNUM) = ' '
      CPREF(2,LOCNUM) = ' '
      DO 20 I = 1,2
         RPLOC(I,LOCNUM) = 0.0
         RPVAL(I,LOCNUM) = 0.0D0
20       CONTINUE
      YMIN = -0.03 * YMAX
      YMAX = 1.03 * YMAX
      RPVAL(2,LOCNUM) = YMIN
      CTYP(1,LOCNUM) = 'Radius'
      CTYP(2,LOCNUM) = 'Beam power'
      AXINC(1,LOCNUM) = (MP + 1) / 1000.0 * ABS(CATR(KRCIC)) * 60.0
      AXINC(2,LOCNUM) = (YMAX-YMIN) / 1000.0
      XSCALE = 1000. / (MP + 1)
      YSCALE = 1000.0 / (YMAX-YMIN)
C                                       create plot object
      VER = 0
      IF (.NOT.DOTV) THEN
         CALL CATIO ('READ', DISKOU, CNOUT, CATBLK, 'REST', PLBUFF,
     *      IRET)
         IF ((IRET.GE.1) .AND. (IRET.LE.4)) THEN
            WRITE (MSGTXT,1000) IRET, 'RE-READ CATALOG HEADER'
            GO TO 990
            END IF
         CALL MADDEX ('PL', DISKOU, CNOUT, CATBLK, PLBUFF, .TRUE.,
     *      'WRIT', VER, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL ZPHFIL ('PL', DISKOU, CNOUT, VER, PFILE, IRET)
         IF (IRET.NE.0) GO TO 960
         END IF
      IPSIZE = 0
      ITYPE = 80
      DOPLOT = 4
C
      CALL GINIT (DISKOU, CNOUT, PFILE, IPSIZE, ITYPE, NPARM,
     *   XNAMEO, DOTV, TVCHN, GRCHN, TVCORN, CATBLK, PLBUFF, LUNPL,
     *   FINDPL, IRET)
      IF (IRET.NE.0) GO TO 960
C                                       off graphics
      IF ((DOTV) .AND. (GRCHN.LE.0)) THEN
         DO 5 I = 1,4
            CALL YSLECT ('OFFF', I+NGRAY, 7, BUFFER, IRET)
 5          CONTINUE
         END IF
C                                       Number of characters on each
C                                       side of the plot
      CALL RFILL (4, 0.5, CHOUT)
C                                       Not fully initialized, may make
C                                       INP too large which is okay.
      CALL CHNTIC (BLC, TRC, INP)
      INP = MAX (INP, 3)
C                                       standard labeling
      LABEL = 3
      LTYPE = 3
      CHOUT(1) = INP + 4.0
      CHOUT(2) = 3.333
      NLINE = 3
      IF (NANT.GT.1) THEN
         NLINE = NLINE + 1
         IF (NREF.GT.15) NLINE = NLINE + 1
      ELSE
         IF (NREF.GT.11) NLINE = NLINE + 1
         END IF
      CHOUT(4) = 1.0 + 1.333*NLINE
C                                       Init for line drawing.
      CALL GINITL (BLC, TRC, XYRATO, CHOUT, DEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1001) VER
         CALL MSGWRT (3)
         END IF
C                                       Draw border
      CALL GLTYPE (1, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Top labels: type & name
      DX = 0.0
C                                       Date/time/version
      DY = CHOUT(4) - 1.833
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL ZDATE (ID)
      CALL ZTIME (IT)
      CALL TIMDAT (IT, ID, ATIME, ADATE)
      WRITE (TEXT,1100) VER, ADATE, ATIME
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       The second line of the header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Power beam azimuthal average'
      CALL REFRMT (TEXT, ' ', INCHAR)
      IF (NAMEOU.NE.' ') THEN
         TEXT(INCHAR+1:) = '____'
         INCHAR = INCHAR+5
         CALL H2CHR (12, KHIMNO, CATH(KHIMN), CHTEMP(1:12))
         CALL H2CHR (6, KHIMCO, CATH(KHIMC), CHTEMP(13:18))
         CALL NAMEST (CHTEMP, CATBLK(KIIMS), TEXT(INCHAR:), ITEMP)
         CALL REFRMT (TEXT, '_', INCHAR)
         END IF
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       the third line of header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       model
      IF ((NANT.LE.1) .AND. (NREF.LE.11)) THEN
         WRITE (TEXT,1050) IANT, FREQU, STOKE, (REFANT(I), I = 1,NREF)
      ELSE IF (NANT.LE.1) THEN
         WRITE (TEXT,1051) IANT, FREQU, STOKE
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
      ELSE IF (NREF.LE.15) THEN
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1054) FREQU, STOKE, (REFANT(I), I = 1,MIN(24,NREF))
      ELSE
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1055) FREQU, STOKE
         END IF
      INP = 7
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Put on labels and ticks
      CALL CLAB1 (BLC, TRC, CHOUT, LABEL, XYRATO, .FALSE., PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DX = 5.0
      DY = 5.0
C                                       little X's for data
      CALL GCOMNT (-1, 'Plot data rings as Xs', PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GLTYPE (4, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GPOS (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Data ring'
      DX = -16.
      DY = -6.0
      INCHAR = 9
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DO 60 I = 1,MP
         X = I * XSCALE
         Y = (DRING(I)-YMIN) * YSCALE
         CALL GPOS (X+DX, Y+DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X-DX, Y-DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GPOS (X-DX, Y+DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X+DX, Y-DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
 60      CONTINUE
C                                       little X's for data
      CALL GCOMNT (-1, 'Connect data rings', PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GLTYPE (2, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DO 70 I = 1,MP
         X = I * XSCALE
         Y = (DRING(I)-YMIN) * YSCALE
         IF (I.EQ.1) THEN
            CALL GPOS (X, Y, PLBUFF, IRET)
         ELSE
            CALL GVEC (X, Y, PLBUFF, IRET)
            END IF
         IF (IRET.NE.0) GO TO 970
 70      CONTINUE
C                                       plot data
      CALL GPOS (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Data samples'
      DX = -16.
      DY = -8.0
      INCHAR = 12
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DX = 10
      DY = 10
C                                       plot data
      CALL GPOS (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Data samples'
      DX = -16.
      DY = -8.0
      INCHAR = 12
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DX = 10
      DY = 10
      DO 90 I = 1,NMEAS
         X1 = XMEAS(I)
         Y1 = YMEAS(I)
         Y = (AMPLS(I) - YMIN) * YSCALE
         AR = SQRT (X1**2 + Y1**2)
         X = AR / AXINC(1,LOCNUM)
         CALL GPOS (X-DX, Y, PLBUFF, IERR)
         IF (IERR.NE.0) GO TO 970
         CALL GVEC (X+DX, Y, PLBUFF, IERR)
         IF (IERR.NE.0) GO TO 970
         CALL GPOS (X, Y+DY, PLBUFF, IERR)
         IF (IERR.NE.0) GO TO 970
         CALL GVEC (X, Y-DY, PLBUFF, IERR)
         IF (IERR.NE.0) GO TO 970
 90      CONTINUE
C                                       Done: finish plot
      GPHPAG = .TRUE.
      CALL GFINIS (PLBUFF, IRET)
      IF (IRET.GT.0) GO TO 975
      IF (IRET.LT.0) GO TO 999
      IF (.NOT.DOTV) THEN
         CALL HIPLOT (DISKOU, CNOUT, VER, BUFFER, IRET)
         IRET = 0
         END IF
C                                       sum plot
      YMAX = -10000.
      DO 110 I = 2,MP
         IF (DRSUM(I).GT.YMAX) YMAX = DRSUM(I)
 110     CONTINUE
      DO 120 I = 1,MP
         DRSUM(I) = DRSUM(I) / YMAX
 120     CONTINUE
      YMAX = 1.03
      YMIN = -0.03
      CTYP(2,LOCNUM) = 'Beam sum'
      AXINC(1,LOCNUM) = (MP + 1) / 1000.0 * ABS(CATR(KRCIC)) * 60.0
      AXINC(2,LOCNUM) = (YMAX-YMIN) / 1000.0
      XSCALE = 1000.0 / (MP + 1.0)
      YSCALE = 1000.0 / (YMAX-YMIN)
C                                       create plot object
      VER = 0
      IF (.NOT.DOTV) THEN
         CALL MADDEX ('PL', DISKOU, CNOUT, CATBLK, PLBUFF, .TRUE.,
     *      'WRIT', VER, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL ZPHFIL ('PL', DISKOU, CNOUT, VER, PFILE, IRET)
         IF (IRET.NE.0) GO TO 960
         END IF
      IPSIZE = 0
      ITYPE = 80
      DOPLOT = 5
C
      CALL GINIT (DISKOU, CNOUT, PFILE, IPSIZE, ITYPE, NPARM,
     *   XNAMEO, DOTV, TVCHN, GRCHN, TVCORN, CATBLK, PLBUFF, LUNPL,
     *   FINDPL, IRET)
      IF (IRET.NE.0) GO TO 960
C                                       Number of characters on each
C                                       side of the plot
      CALL RFILL (4, 0.5, CHOUT)
C                                       Not fully initialized, may make
C                                       INP too large which is okay.
      CALL CHNTIC (BLC, TRC, INP)
      INP = MAX (INP, 3)
C                                       standard labeling
      LABEL = 3
      LTYPE = 3
      CHOUT(1) = INP + 4.0
      CHOUT(2) = 3.333
      NLINE = 3
      IF (NANT.GT.1) THEN
         NLINE = NLINE + 1
         IF (NREF.GT.15) NLINE = NLINE + 1
      ELSE
         IF (NREF.GT.11) NLINE = NLINE + 1
         END IF
      CHOUT(4) = 1.0 + 1.333*NLINE
C                                       Init for line drawing.
      CALL GINITL (BLC, TRC, XYRATO, CHOUT, DEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1001) VER
         CALL MSGWRT (3)
         END IF
C                                       Draw border
      CALL GLTYPE (1, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GVEC (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Top labels: type & name
      DX = 0.0
C                                       Date/time/version
      DY = CHOUT(4) - 1.833
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL ZDATE (ID)
      CALL ZTIME (IT)
      CALL TIMDAT (IT, ID, ATIME, ADATE)
      WRITE (TEXT,1100) VER, ADATE, ATIME
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       The second line of the header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Power beam azimuthal average'
      CALL REFRMT (TEXT, ' ', INCHAR)
      IF (NAMEOU.NE.' ') THEN
         TEXT(INCHAR+1:) = '____'
         INCHAR = INCHAR+5
         CALL H2CHR (12, KHIMNO, CATH(KHIMN), CHTEMP(1:12))
         CALL H2CHR (6, KHIMCO, CATH(KHIMC), CHTEMP(13:18))
         CALL NAMEST (CHTEMP, CATBLK(KIIMS), TEXT(INCHAR:), ITEMP)
         CALL REFRMT (TEXT, '_', INCHAR)
         END IF
C                                       the third line of header
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       the fourth line of header
      DY = DY - 1.333
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       model
      IF ((NANT.LE.1) .AND. (NREF.LE.11)) THEN
         WRITE (TEXT,1050) IANT, FREQU, STOKE, (REFANT(I), I = 1,NREF)
      ELSE IF (NANT.LE.1) THEN
         WRITE (TEXT,1051) IANT, FREQU, STOKE
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
      ELSE IF (NREF.LE.15) THEN
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1054) FREQU, STOKE, (REFANT(I), I = 1,MIN(24,NREF))
      ELSE
         WRITE (TEXT,1053) (NANTS(I), I = 1,MIN(23,NANT))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1052) (REFANT(I), I = 1,MIN(24,NREF))
         INP = 7
         CALL REFRMT (TEXT, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         DY = DY - 1.333
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         WRITE (TEXT,1055) FREQU, STOKE
         END IF
      INP = 7
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
C                                       Put on labels and ticks
      CALL CLAB1 (BLC, TRC, CHOUT, LABEL, XYRATO, .FALSE., PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DX = 5.0
      DY = 5.0
C                                       little Xs for data
      CALL GCOMNT (-1, 'Plot data rings as Xs', PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GLTYPE (4, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GPOS (BLC(1), trC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      TEXT = 'Data ring'
      DX = 4.
      DY = -6.0
      INCHAR = 10
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DO 160 I = 1,MP
         X = I * XSCALE
         Y = (DRSUM(I)-YMIN) * YSCALE
         CALL GPOS (X+DX, Y+DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X-DX, Y-DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GPOS (X-DX, Y+DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
         CALL GVEC (X+DX, Y-DY, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 970
 160     CONTINUE
C                                       little X's for data
      CALL GCOMNT (-1, 'Connect data rings', PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      CALL GLTYPE (2, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 970
      DO 170 I = 1,MP
         X = I * XSCALE
         Y = (DRSUM(I)-YMIN) * YSCALE
         IF (I.EQ.1) THEN
            CALL GPOS (X, Y, PLBUFF, IRET)
         ELSE
            CALL GVEC (X, Y, PLBUFF, IRET)
            END IF
         IF (IRET.NE.0) GO TO 970
 170     CONTINUE
C                                       Done: finish plot
      GPHPAG = LFRING
      CALL GFINIS (PLBUFF, IRET)
      IF (IRET.GT.0) GO TO 975
      IF (.NOT.DOTV) THEN
         CALL HIPLOT (DISKOU, CNOUT, VER, BUFFER, IRET)
         IRET = 0
         END IF
      GO TO 999
C                                       ZPHFIL or GINIT failure.
 960  WRITE (MSGTXT,2000)
      CALL MSGWRT (8)
C
      IF (.NOT.DOTV) THEN
         CALL DELEXT ('PL', DISKOU, CNOUT, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         END IF
      GO TO 999
C                                       Try to finish partial graph
 970  MSGTXT = 'PLOT ERROR OCCURRED: TRY TO FINISH PARTIAL PLOT'
      CALL MSGWRT (7)
      GPHPAG = .FALSE.
      CALL GFINIS (PLBUFF, IERR)
      IF (IERR.NE.0) GO TO 975
         IF (.NOT.DOTV) THEN
            CALL HIPLOT (DISKOU, CNOUT, VER, BUFFER, IERR)
            IERR = 0
            END IF
         GO TO 999
C                                       Destroy the plot file
 975  IF (.NOT.DOTV) THEN
         CALL ZCLOSE (LUNPL, FINDPL, IERR)
         CALL ZDESTR (DISKOU, PFILE, IERR)
         CALL DELEXT ('PL', DISKOU, CNOUT, 'WRIT', CATBLK, BUFFER,
     *      VER, IERR)
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLRING ERROR',I4,' ON ',A)
 1001 FORMAT ('Plot file version',I4,'  created.')
 1050 FORMAT ('Antenna',I3,' Freq =',F7.3,' GHz Pol = ',A2,
     *   ' RefAnts=',11I3)
 1051 FORMAT ('Antenna',I3,' Freq =',F7.3,' GHz Pol = ',A2)
 1052 FORMAT ('RefAnt =',24I3)
 1053 FORMAT ('Antennas =',23I3)
 1054 FORMAT ('Freq =',F7.3,' GHz Pol = ',A2,' RefAnts=',15I3)
 1055 FORMAT ('Frequency =',F7.3,' GHz Pol = ',A2)
 1100 FORMAT ('Plot file version',I4,'__created ',A, A)
 2000 FORMAT ('PLTEL: ERROR DURING GRAPH FILE CREATION')
      END
