LOCAL INCLUDE 'PDPLT.INC'
C                                       Local include for PDPLT
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MAXPDC, MAXFIL
      PARAMETER (MAXPDC = 9)
      PARAMETER (MAXFIL = 4)
C                                       Input parameters
      REAL      XSIN, XDISIN, XNVER, XSIN2, XDISI2, XNVER2, XSIN3,
     *   XDISI3, XNVER3, XSIN4, XDISI4, XNVER4, XANT(50),
     *   BPARM(10,MAXFIL-1), XFQID, XSUBA, XBIF, XEIF, XBCHAN, XECHAN,
     *   PIXR(2),APARM(10), XOVER, XDO3C, XSYM, FACTOR, XLABEL, XDOTV,
     *   XGRCH, XYRATO
      HOLLERITH XNAMEI(3), XCLAIN(2), XNAME2(3), XCLAI2(2), XNAME3(3),
     *   XCLAI3(2), XNAME4(3), XCLAI4(2), XTYPE(1), XXSTOK(1), XOPTY(1)
      CHARACTER NAMEIN(MAXFIL)*12, CLAIN(MAXFIL)*6, TYPE*2, XSTOK*4,
     *   OPTYPE*4
C                                       Program info
      REAL      XYSCL(2), XYOFF(2), YYMX(2,MAXANT), YYMN(2,MAXANT),
     *   CHOUT(4), YYMIN(2,MAXANT), PPMAX(2,MAXANT), YYMAX(2,MAXANT),
     *   PPMIN(2,MAXANT), PRAN(2,2), CH(4), PX(MAXCIF,MAXFIL),
     *   CATSR(256,MAXFIL)
      DOUBLE PRECISION FRMIN, FRMAX, CATSD(128,MAXFIL)
      HOLLERITH CATSH(256,MAXFIL)
      INTEGER   CATI(256,MAXFIL), SEQIN(MAXFIL), DISKIN(MAXFIL),
     *   CNOIN(MAXFIL), IVER(MAXFIL), BIF, EIF, ANTS(50,MAXFIL), NPARMS,
     *   NANTSL(MAXFIL), ISTOK, FRQSEL, LABEL, LTYPE, SUBARR, MUMPOL,
     *   ISYM, NCHAN, NIF, NANT, PDBUFF(512,MAXFIL), PDKOLS(MAXPDC),
     *   PDNUMV(MAXPDC), NPOL, BCHAN, ECHAN, MFIL, DO3COL
      LOGICAL   DOTV, DOLINE, HAVE1(MAXANT,MAXFIL), FRDIFF
      EQUIVALENCE (CATI, CATSH, CATSD, CATSR)
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XTYPE, XNVER,
     *   XNAME2, XCLAI2, XSIN2, XDISI2, XNVER2, XNAME3, XCLAI3, XSIN3,
     *   XDISI3, XNVER3, XNAME4, XCLAI4, XSIN4, XDISI4, XNVER4, XANT,
     *   BPARM, XFQID, XSUBA, XXSTOK, XBIF, XEIF, XBCHAN, XECHAN,
     *   XOPTY, PIXR, APARM, XOVER, XDO3C, XSYM, FACTOR, XLABEL, XDOTV,
     *   XGRCH, XYRATO
      COMMON /VPARM/ CATSD, PDBUFF, FRMIN, FRMAX, PX, SEQIN, DISKIN,
     *   CNOIN, IVER, BIF, EIF, ANTS, NPARMS, DOTV, LTYPE, LABEL, CHOUT,
     *   DO3COL, DOLINE, BCHAN, ECHAN, NCHAN, NIF, NANT, NPOL, PDKOLS,
     *   PDNUMV, MFIL
      COMMON /VGNCOM/ XYSCL, XYOFF, NANTSL, PRAN, ISTOK, FRQSEL,
     *   SUBARR, MUMPOL, YYMIN, YYMAX, PPMIN, PPMAX, YYMX, YYMN, ISYM,
     *   HAVE1, CH, FRDIFF
      COMMON /VGNCHR/ NAMEIN, CLAIN, TYPE, XSTOK, OPTYPE
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
C                                                          End PDPLT
LOCAL END
      PROGRAM PDPLT
C-----------------------------------------------------------------------
C! Plots data from one or two PD tables
C# UV Plot EXT-appl Calibration Polarization
C-----------------------------------------------------------------------
C;  Copyright (C) 2020-2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PDPLT plots PD extension files. A 'PL' extension file is made
C   which can be displayed in the usual ways .
C   Inputs:
C      INNAME.....UV file name (name).       Standard defaults.
C      INCLASS....UV file name (class).      Standard defaults.
C      INSEQ......UV file name (seq. #).     0 => highest.
C      INDISK.....Disk unit #.               0 => any.
C      INEXT......'SN','TY','PC' or 'CL' table to be plotted
C      INVERS.....Version number of table to plot, 0=>highest no.
C      STOKES.....The desired Stokes type of the output data:
C                 'R' = RCP, 'L' = LCP, 'DIFF' = difference
C      BIF........IF to plot
C      ANTENNAS...A list of the antennas to be plotted. All 0 => all.
C                 If any number is negative then all antennas listed
C                 are NOT to be plotted and all others are.
C      PIXRANGE...Limit the plot to values between PIXR(1) and
C                 PIXR(2).  The plots will not exceed the min/max in
C                 the actual gains.  Basically, if PIXR(1) < PIXR(2),
C                 all plots will be on the same scale and be limited
C                 to max (datamin, PIXR(1)) through min (datamax,
C                 PIXR(2)).  If PIXR(1) >= PIXR(2), each plot will be
C                 self-scaled individually.
C      OPTYPE.....Data to be plotted: 'PHAS' = phase, 'AMP '=  ampl.,
C                 'A&P' = both
C      DOTV     R      > 0 => TV, else plot file
C      GRCHAN   R      graphics channel to use
C-----------------------------------------------------------------------
C
      CHARACTER PRGN*6
      REAL      PLD1(2)
      LONGINT   PPD1
      INTEGER   IRET, MVAL, NWORDS, I
      INCLUDE 'PDPLT.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA PRGN /'PDPLT '/
C-----------------------------------------------------------------------
C                                       Get input parameters
      CALL PDPIN (PRGN, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'PDPIN'
         GO TO 890
         END IF
      MVAL = 4 * NANT * NCHAN * NIF * MFIL
      NWORDS = (MVAL - 1) / 1024  + 2
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, PLD1, PPD1, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'UNABLE TO GET DYNAMIC MEMORY'
         GO TO 890
         END IF
      NWORDS = NWORDS * 1024
      MVAL = NCHAN * NIF
      CALL RFILL (NWORDS, FBLANK, PLD1(1+PPD1))
      I = MAXFIL * MAXANT
      CALL LFILL (I, .FALSE., HAVE1)
C                                       Fetch data, determine scaling
      CALL PDPMAX (MVAL, NANT, PLD1(1+PPD1), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'PDPMAX'
         GO TO 890
         END IF
C                                       Do plots
      CALL PDPLOT (MVAL, NANT, PLD1(1+PPD1), IRET)
      IF (IRET.LT.0) IRET = 0
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'PDPLOT'
         GO TO 890
         END IF
      GO TO 900
C                                       Close down
 890  CALL MSGWRT (8)
 900  CALL DIE (IRET, PDBUFF)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I4,' RETURNED FROM SUBROUTINE ',A)
      END
      SUBROUTINE PDPIN (PRGN, IERR)
C-----------------------------------------------------------------------
C   Gets the inputs parameters for PDPLT.
C   Inputs:
C      PRGN    C*6  Program name
C   Output in common:
C      SUMSTK  I    Selected Stokes 0=both, 1=R, 2=L
C   Output:
C      IERR    I    Error code: 0 => ok
C      ISTOK   I    1 = R, 2 = L
C      ICODE   I    1='PHAS', 2='AMP ', 3='DELA', 4='RATE', 5='TSYS',
C                   6='SUM ', 7='DOPL', 8='SNR', 9='MDEL', 10='TANT',
C                   11='ATM', 12='GEO', 13='CCAL', 14='DDLY'
C                   15='REAL', 16='IMAG', 17='IFR', 18='PDIF',
C                   19='PSUM', 20=PGN ', 21='PON ', 22='POFF', 23='PSYS'
C                   24='PDGN', 25='PSGN', 26='POWR', 27='PODB'
C-----------------------------------------------------------------------
      INTEGER   IERR
      CHARACTER PRGN*6
C
      INCLUDE 'PDPLT.INC'
C
      CHARACTER STAT*4, CODE(3)*4, TYPTMP*2
      INTEGER   IRET, BUFF(512), I, J, K, L, JERR, IROUND, NSTOK, ICODE,
     *   LUN1, LUNR(MAXFIL), NA, NP, NI, NC, IPDRNO, VER
      LOGICAL T, F
      CHARACTER POLTYP*8
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DANT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DCHND.INC'
      DATA CODE /'PHAS', 'AMP ', 'A&P '/
      DATA T, F /.TRUE.,.FALSE./
      DATA LUN1, LUNR /28, 29,30,31,32/
C-----------------------------------------------------------------------
      NPARMS = 141
C                                        Get input parameters.
      CALL SETUP (PRGN, NPARMS, XNAMEI, BUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING INPUT PARAMETERS'
         CALL MSGWRT (8)
         IRET = 8
         RQUICK = .FALSE.
         GO TO 990
         END IF
C                                       Decode inputs.
C                                       characters
      CALL H2CHR (12, 1, XNAMEI, NAMEIN(1))
      CALL H2CHR (6, 1, XCLAIN, CLAIN(1))
      CALL H2CHR (12, 1, XNAME2, NAMEIN(2))
      CALL H2CHR (6, 1, XCLAI2, CLAIN(2))
      CALL H2CHR (12, 1, XNAME3, NAMEIN(3))
      CALL H2CHR (6, 1, XCLAI3, CLAIN(3))
      CALL H2CHR (12, 1, XNAME4, NAMEIN(4))
      CALL H2CHR (6, 1, XCLAI4, CLAIN(4))
      CALL H2CHR (2, 1, XTYPE, TYPE)
      CALL H2CHR (4, 1, XXSTOK, XSTOK)
      CALL H2CHR (4, 1, XOPTY, OPTYPE)
      APARM(10) = 0.0
      IF ((APARM(3).GT.0.0) .AND. (APARM(4).GT.0.0)) APARM(10) = 1.0
      TYPE = 'PD'
      XTYPE = HBLANK
      CALL CHR2H (2, TYPE, 1, XTYPE)
      MFIL = 1
      IF (NAMEIN(2).NE.' ') THEN
         MFIL = 2
         IF (NAMEIN(3).NE.' ') THEN
            MFIL = 3
            IF (NAMEIN(4).NE.' ') MFIL=4
            END IF
         END IF
C                                       Integers
      SEQIN(1) = IROUND (XSIN)
      DISKIN(1) = IROUND (XDISIN)
      IVER(1) = IROUND (XNVER)
      SEQIN(2) = IROUND (XSIN2)
      DISKIN(2) = IROUND (XDISI2)
      IVER(2) = IROUND (XNVER2)
      SEQIN(3) = IROUND (XSIN3)
      DISKIN(3) = IROUND (XDISI3)
      IVER(3) = IROUND (XNVER3)
      SEQIN(4) = IROUND (XSIN4)
      DISKIN(4) = IROUND (XDISI4)
      IVER(4) = IROUND (XNVER4)
      ISYM = IROUND (XSYM)
      IF ((ISYM.LT.1) .OR. (ISYM.GT.24)) ISYM = 2
      DOLINE = FACTOR.LT.0.0
      IF ((FACTOR.GE.-0.2) .AND. (FACTOR.LT.0.0)) ISYM = -1
      FACTOR = ABS (FACTOR)
      IF ((.NOT.DOLINE) .AND. (FACTOR.LT.0.1)) FACTOR = 1.0
      IF (FACTOR.GT.10.0) FACTOR = 1.0
      ICODE = 3
      DO 10 I = 1,3
         IF (OPTYPE.EQ.CODE(I)) ICODE = I
 10      CONTINUE
      CALL CHR2H (4, CODE(ICODE), 1, XOPTY)
      DOTV = XDOTV.GT.0.0
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS(LABEL), 100)
      IF ((LTYPE.EQ.0) .OR. (LTYPE.GT.10)) LTYPE = 3
      IF (LTYPE.GT.7) LTYPE = 7
      IF ((LTYPE.GE.4) .AND. (LTYPE.LE.6)) LTYPE = 3
      IF (LABEL.LT.0) THEN
         LABEL = (LABEL/100)*100 - LTYPE
      ELSE
         LABEL = (LABEL/100)*100 + LTYPE
         END IF
C                                       Find input catalog entries
      TYPTMP = 'UV'
      DO 20 I = 1,MFIL
         CNOIN(I) = 1
         CALL CATDIR ('SRCH', DISKIN(I), CNOIN(I), NAMEIN(I), CLAIN(I),
     *      SEQIN(I), TYPTMP, NLUSER, STAT, BUFF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1030) IERR, NAMEIN(I), CLAIN(I), SEQIN(I),
     *         DISKIN(I), 'UV', NLUSER
            GO TO 990
            END IF
 20      CONTINUE
      DO 30 I = MFIL,1,-1
         STAT = 'REST'
         IF ((CNOIN(I).NE.CNOIN(1)) .OR. (DISKIN(I).NE.DISKIN(1)) .OR.
     *      (DOTV)) STAT = 'READ'
         IF (I.EQ.1) THEN
            STAT = 'WRIT'
            IF (DOTV) STAT = 'READ'
            END IF
         CALL CATIO ('READ', DISKIN(I), CNOIN(I), CATI(1,I), STAT,
     *       BUFF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1040) IERR
            GO TO 990
            END IF
         NCFILE = NCFILE + 1
         FCNO(NCFILE) = CNOIN(I)
         FVOL(NCFILE) = DISKIN(I)
         FRW(NCFILE) = 0
         IF (STAT.EQ.'WRIT') FRW(NCFILE) = 1
 30      CON TINUE
C                                       Save name class etc.
      CALL CHR2H (12, NAMEIN(1), 1, XNAMEI)
      CALL CHR2H (6, CLAIN(1), 1, XCLAIN)
      XDISIN = DISKIN(1)
      XSIN = SEQIN(1)
      CALL CHR2H (12, NAMEIN(2), 1, XNAME2)
      CALL CHR2H (6, CLAIN(2), 1, XCLAI2)
      XDISI2 = DISKIN(2)
      XSIN2 = SEQIN(2)
      CALL CHR2H (12, NAMEIN(3), 1, XNAME3)
      CALL CHR2H (6, CLAIN(3), 1, XCLAI3)
      XDISI3 = DISKIN(3)
      XSIN3 = SEQIN(3)
      CALL CHR2H (12, NAMEIN(4), 1, XNAME4)
      CALL CHR2H (6, CLAIN(4), 1, XCLAI4)
      XDISI4 = DISKIN(4)
      XSIN4 = SEQIN(4)
C                                       UV data parameters
      CALL COPY (256, CATI(1,1), CATBLK)
      CALL UVPGET (IERR)
      IF (IERR.NE.0) GO TO 990
C                                       Subarray
      SUBARR = IROUND (XSUBA)
      IF (SUBARR.EQ.0) SUBARR = 1
      FRQSEL = IROUND (XFQID)
C                                       IF'S
      IF (JLOCIF.GE.0) THEN
         NIF = CATBLK(KINAX+JLOCIF)
         BIF = IROUND (XBIF)
         BIF = MAX (1, MIN (BIF, NIF))
         EIF = IROUND (XEIF)
         IF (EIF.LT.BIF) EIF = NIF
         IF (EIF.GT.NIF) EIF = NIF
      ELSE
         BIF = 1
         EIF = 1
         NIF = 1
         END IF
      BCHAN = IROUND (XBCHAN)
      BCHAN = MAX (1, BCHAN)
      ECHAN = IROUND (XECHAN)
      IF (ECHAN.LE.BCHAN) ECHAN = CATBLK(KINAX+JLOCF)
      ECHAN = MIN (ECHAN, CATBLK(KINAX+JLOCF))
      XBCHAN = BCHAN
      XECHAN = ECHAN
C                                       Check antennas desired.
      CALL FILL (MAXFIL, 0, NANTSL)
      CALL FILL (50*MAXFIL, 0, ANTS)
      DO 40 J = 1,50
         L = IROUND (XANT(J))
C                                       Make positive
         L = ABS (L)
         DO 35 K = 1,NANTSL(1)
            IF (L.EQ.ANTS(K,1)) L = 0
 35         CONTINUE
C                                       Check for multiple entries
         IF (L.GT.0) THEN
            NANTSL(1) = NANTSL(1) + 1
            ANTS(NANTSL(1),1) = L
            END IF
 40      CONTINUE
      IF (NANTSL(1).LE.0) THEN
         DO 45 J = 1,50
            ANTS(J,1) = J
 45         CONTINUE
         NANTSL(1) = 50
      ELSE
         CALL RFILL (50, 0.0, XANT)
         DO 46 J = 1,NANTSL(1)
            XANT(J) = ANTS(J,1)
 46         CONTINUE
         END IF
      DO 60 I = 2,MFIL
         L = IROUND (BPARM(1,I-1))
         IF (L.LE.0) THEN
            NANTSL(I) = NANTSL(1)
            CALL COPY (50, ANTS(1,1), ANTS(1,I))
         ELSE
            DO 55 J = 1,10
               L = IROUND (BPARM(J,I-1))
               IF (L.GT.0) THEN
                  BPARM(J,I-1) = 0.0
                  DO 50 K = 1,NANTSL(I)
                     IF (L.EQ.ANTS(K,I)) L = 0
 50                  CONTINUE
                  IF (L.GT.0) THEN
                     NANTSL(I) = NANTSL(I) + 1
                     ANTS(NANTSL(I),I) = L
                     BPARM(NANTSL(I),I-1) = L
                     END IF
                  END IF
 55            CONTINUE
            END IF
 60      CONTINUE
C                                       Get antenna names
      CALL GETANT (DISKIN, CNOIN, MAX (1, SUBARR), CATBLK, BUFF, JERR)
C                                       Freq info
      CALL FNDEXT ('FQ', CATBLK, VER)
      CALL CHNDAT ('READ', BUFF, DISKIN, CNOIN, VER, CATBLK, LUN1, NIF,
     *   FOFF, ISBAND, FINC, BNDCOD, FRQSEL, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING 1ST FREQUENCY TABLE'
         GO TO 990
         END IF
C                                       Set stokes request
      NSTOK = CATBLK(KINAX+JLOCS)
      MUMPOL = 1
      IF ((ICOR0.EQ.1) .OR. (ICOR0.EQ.-2) .OR. (ICOR0.EQ.-6) .OR.
     *   (((ICOR0.EQ.-1) .OR. (ICOR0.EQ.-5)) .AND. (NSTOK.EQ.1))) THEN
         ISTOK = ABS (ICOR0)
         XSTOK = 'I'
         IF (ICOR0.EQ.-2) XSTOK='L'
         IF (ICOR0.EQ.-1) XSTOK='R'
         IF (ICOR0.EQ.-6) XSTOK='H'
         IF (ICOR0.EQ.-5) XSTOK='V'
      ELSE IF (ICOR0.EQ.-1) THEN
         IF ((XSTOK.EQ.'R') .OR. (XSTOK.EQ.'RR')) THEN
            ISTOK = 1
            XSTOK = 'R'
         ELSE IF ((XSTOK.EQ.'L') .OR. (XSTOK.EQ.'LL')) THEN
            ISTOK = 2
            XSTOK = 'L'
         ELSE
            ISTOK = 1
            XSTOK = 'R&L'
            MUMPOL = 2
            END IF
      ELSE IF (ICOR0.EQ.-5) THEN
         IF ((XSTOK.EQ.'V') .OR. (XSTOK.EQ.'VV')) THEN
            ISTOK = 1
            XSTOK = 'V'
         ELSE IF ((XSTOK.EQ.'H') .OR. (XSTOK.EQ.'HH')) THEN
            ISTOK = 2
            XSTOK = 'H'
         ELSE
            ISTOK = 1
            XSTOK = 'V&H'
            MUMPOL = 2
            END IF
         END IF
      CALL CHR2H (4, XSTOK, 1, XXSTOK)
      XNVER = IVER(1)
      XNVER2 = IVER(2)
      XNVER3 = IVER(3)
      XNVER4 = IVER(4)
      XBIF = BIF
      XEIF = EIF
      I = 2 * MAXANT
      CALL RFILL (I, 1.E8, PPMIN)
      CALL RFILL (I, -1.E8, PPMAX)
      CALL RFILL (I, 1.E8, YYMIN)
      CALL RFILL (I, -1.E8, YYMAX)
      CALL RFILL (I, 1.E8, YYMN)
      CALL RFILL (I, -1.E8, YYMX)
C                                       open PD tables
      DO 80 I = 1,MFIL
         CALL PDINI ('READ', PDBUFF(1,I), DISKIN(I), CNOIN(I), IVER(I),
     *      CATI(1,I), LUNR(I), IPDRNO, PDKOLS, PDNUMV, NA, NP, NI, NC,
     *      POLTYP, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'OPENING PD TABLE'
            GO TO 990
            END IF
         IF (I.EQ.1) THEN
            NANT = NA
            NPOL = NP
            NIF = NI
            NCHAN = NC
            NANTSL(1) = MIN (NA, NANTSL(1))
         ELSE
            IF ((NP.NE.NPOL) .OR. (NI.NE.NIF) .OR. (NC.NE.NCHAN)) THEN
               WRITE (MSGTXT,1100) NP, NI, NC, NPOL, NIF, NCHAN
               IERR = 10
               GO TO 990
               END IF
            NANT = MAX (NANT, NA)
            NANTSL(I) = MIN (NA, NANTSL(I))
            END IF
 80      CONTINUE
C                                       Compute X axes
      CALL GETPX (IERR)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PDPIN: ERROR:',I4,' ON', A)
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',I3,
     *   ' TYPE=',A2,' USER=',I4)
 1040 FORMAT ('ERROR',I3,' COPYING CATALOG HEADER')
 1100 FORMAT ('NPOL, NIF, NCHAN',2(I2,I4,I6),' DO NOT MATCH')
      END
      SUBROUTINE GETPX (IERR)
C-----------------------------------------------------------------------
C   GETPX finds the X positions of all channels
C   Output:
C      IERR   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'PDPLT.INC'
      DOUBLE PRECISION F1(MAXIF,2,MAXFIL), FR1, FF, S
      REAL      FINC1(MAXIF,MAXFIL), FP1
      INTEGER   I, NI, NC, II, IC, BUFF(512), LUN1, VER, XMAX, XMIN, J
      INCLUDE 'INCS:DCHND.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA LUN1, VER /28, 1/
C-----------------------------------------------------------------------
C                                       Get frequencies of main file
C                                       Frequencies the same?
      NI = CATBLK(KINAX+JLOCIF)
      NC = CATBLK(KINAX+JLOCF)
      IF (JLOCIF.LT.0) NI = 1
      FR1 = CATD(KDCRV+JLOCF)
      FP1 = CATR(KRCRP+JLOCF)
      FRMAX = -1.E16
      FRMIN = 1.E16
      DO 10 I = 1,NI
         F1(I,1,1) = FR1 + FOFF(I) + (1-FP1) * FINC(I)
         F1(I,2,1) = FR1 + FOFF(I) + (NC-FP1) * FINC(I)
         IF ((I.GE.BIF) .AND. (I.LE.EIF)) THEN
            FRMIN = MIN (FRMIN, F1(I,1,1))
            FRMIN = MIN (FRMIN, F1(I,2,1))
            FRMAX = MAX (FRMAX, F1(I,1,1))
            FRMAX = MAX (FRMAX, F1(I,2,1))
            END IF
 10      CONTINUE
      CALL RCOPY (NI, FINC, FINC1(1,1))
      FRDIFF = .FALSE.
C                                       2nd file?
      DO 30 I = 2,MFIL
         IF ((CNOIN(1).EQ.CNOIN(I)) .AND. (DISKIN(1).EQ.DISKIN(I))) THEN
            J = 2 * MAXIF
            CALL DPCOPY (J, F1(1,1,1), F1(1,1,I))
            CALL RCOPY (NI, FINC1(1,1), FINC1(1,I))
         ELSE
            CALL FNDEXT ('FQ', CATI(1,I), VER)
            CALL CHNDAT ('READ', BUFF, DISKIN(I), CNOIN(I), VER,
     *         CATI(1,I), LUN1, NIF, FOFF, ISBAND, FINC, BNDCOD, FRQSEL,
     *         IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READING FREQUENCY TABLE'
               GO TO 990
               END IF
            CALL RCOPY (NI, FINC, FINC1(1,I))
            FR1 = CATSD(KDCRV+JLOCF,I)
            FP1 = CATSR(KRCRP+JLOCF,I)
            DO 20 J = 1,NI
               F1(J,1,I) = FR1 + FOFF(J) + (1-FP1) * FINC(J)
               F1(J,2,I) = FR1 + FOFF(J) + (NC-FP1) * FINC(J)
               IF ((J.GE.BIF) .AND. (J.LE.EIF)) THEN
                  FRMIN = MIN (FRMIN, F1(J,1,I))
                  FRMIN = MIN (FRMIN, F1(J,2,I))
                  FRMAX = MAX (FRMAX, F1(J,1,I))
                  FRMAX = MAX (FRMAX, F1(J,2,I))
                  IF (ABS(F1(J,1,I)-F1(J,1,1)).GT.1.D3) FRDIFF = .TRUE.
                  IF (ABS(F1(J,2,I)-F1(J,2,1)).GT.1.D3) FRDIFF = .TRUE.
                  END IF
 20            CONTINUE
            END IF
 30      CONTINUE
      IF (FRDIFF) THEN
         MSGTXT = 'TWO OR MORE DATA FILES HAVE DIFFERENT FREQUENCIES'
         CALL MSGWRT (7)
         APARM(3) = 1.0
         APARM(4) = 1.0
         APARM(10) = 1.0
         END IF
C                                       get coords
      XMIN = (BIF - 1) * NCHAN
      XMAX = (EIF - BIF + 1) * NCHAN + XMIN + 1
      FRMIN = FRMIN - ABS (FINC(1))
      FRMAX = FRMAX + ABS (FINC(1))
      S = (XMAX - XMIN) / (FRMAX - FRMIN)
      I = (BIF - 1) * NCHAN
      IF (APARM(3).GT.0.0) THEN
         DO 50 II = BIF,EIF
            DO 45 IC = 1,NC
               I = I + 1
               DO 40 J = 1,MFIL
                  FF = F1(II,1,J) + (IC - 1) * FINC1(II,J)
                  PX(I,J) = (FF - FRMIN) * S + XMIN
 40               CONTINUE
 45            CONTINUE
 50         CONTINUE
      ELSE
         DO 70 II = BIF,EIF
            DO 65 IC = 1,NC
               I = I + 1
               DO 60 J = 1,MFIL
                  PX(I,J) = I
 60               CONTINUE
 65            CONTINUE
 70         CONTINUE
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('GETPX ERROR',I4,' ON ',A)
      END
      SUBROUTINE PDPMAX (NV, NA, PD1, IERR)
C-----------------------------------------------------------------------
C   PDPMAX reads the PD table(s) to find the max and min values for the
C   plots
C   Input:
C      NV       I      Number values per antenna (Nchan * Nif)
C   Output:
C      PD1      R(*)   PD table 1 data (4, NV, ant)
C                      the 4 = rr amp phase ll amp phase
C      IERR     I      Error code, 0=OK else failed
C   Outputs in common:
C-----------------------------------------------------------------------
      INTEGER   NV, NA, IERR
      REAL      PD1(4,NV,NA,*)
C
      INCLUDE 'PDPLT.INC'
      INTEGER   NROWS, REFANT, IANT, ISUB, IFQ, IROW, II, IC, JJ, K, I,
     *   IPDRNO, JA, J
      REAL      PDIFF(MAXCIF), DTERMS(2,2*MAXCIF), P, A
      LOGICAL   DOMAX
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
C                                       Read PD tables
      DO 100 J = 1,MFIL
         NROWS = PDBUFF(5,J)
         JA = 1
         DO 90 IROW = 1,NROWS
            IPDRNO = IROW
            CALL TABPD ('READ', PDBUFF(1,J), IPDRNO, PDKOLS, PDNUMV,
     *         NIF, NCHAN, NPOL, IANT, ISUB, IFQ, REFANT, PDIFF, DTERMS,
     *         IERR)
            IF (IERR.GT.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READING PD TABLE'
               GO TO 980
               END IF
            IF (IERR.LT.0) GO TO 90
            IF ((ISUB.GT.0) .AND. (SUBARR.GT.0) .AND. (ISUB.NE.SUBARR))
     *         GO TO 90
            IF ((IFQ.GT.0) .AND. (FRQSEL.GT.0) .AND. (IFQ.NE.FRQSEL))
     *         GO TO 90
            IF (NANTSL(J).GT.0) THEN
               DO 10 I = 1,NANTSL(J)
                  IF (IANT.EQ.ANTS(I,J)) GO TO 30
 10               CONTINUE
               GO TO 90
               END IF
 30         JJ = 0
            K = 0
            IF (XOVER.LE.0.0) JA = I
            DO 50 II = 1,NIF
               DOMAX = (II.GE.BIF) .AND. (II.LE.EIF)
               DO 40 IC = 1,NCHAN
                  JJ = JJ + 1
                  K = K + 1
                  IF ((DTERMS(1,JJ).NE.FBLANK) .AND.
     *               (DTERMS(2,JJ).NE.FBLANK) .AND.
     *               ((DTERMS(1,JJ).NE.0.0) .OR. (DTERMS(2,JJ).NE.0.0))
     *               .AND. (IC.GE.BCHAN) .AND. (IC.LE.ECHAN)) THEN
                     HAVE1(IANT,J) = .TRUE.
                     A = SQRT (DTERMS(1,JJ)*DTERMS(1,JJ) +
     *                  DTERMS(2,JJ)*DTERMS(2,JJ))
                     IF (A.GT.0.0) THEN
                        PD1(1,K,IANT,J) = A
                        P = RAD2DG * ATAN2 (DTERMS(2,JJ), DTERMS(1,JJ))
                        PD1(2,K,IANT,J) = P
                        IF (DOMAX) THEN
                           YYMN(1,JA) = MIN (YYMN(1,JA), A)
                           YYMX(1,JA) = MAX (YYMX(1,JA), A)
                           YYMIN(1,JA) = MIN (YYMIN(1,JA), P)
                           YYMAX(1,JA) = MAX (YYMAX(1,JA), P)
                           IF (P.LT.0.0) P = P + 360.
                           PPMIN(1,JA) = MIN (PPMIN(1,JA), P)
                           PPMAX(1,JA) = MAX (PPMAX(1,JA), P)
                           END IF
                        END IF
                     END IF
 40               CONTINUE
 50            CONTINUE
            IF (NPOL.GT.1) THEN
               K = 0
               DO 70 II = 1,NIF
                  DO 60 IC = 1,NCHAN
                     DOMAX = (II.GE.BIF) .AND. (II.LE.EIF) .AND.
     *                  (IC.GE.BCHAN) .AND. (IC.LE.ECHAN)
                     JJ = JJ + 1
                     K = K + 1
                     IF ((DTERMS(1,JJ).NE.FBLANK) .AND.
     *                  (DTERMS(2,JJ).NE.FBLANK) .AND.
     *                  ((DTERMS(1,JJ).NE.0.0) .OR.
     *                  (DTERMS(2,JJ).NE.0.0)) .AND. (IC.GE.BCHAN) .AND.
     *                  (IC.LE.ECHAN)) THEN
                        HAVE1(IANT,J) = .TRUE.
                        A = SQRT (DTERMS(1,JJ)*DTERMS(1,JJ) +
     *                     DTERMS(2,JJ)*DTERMS(2,JJ))
                        IF (A.GT.0.0) THEN
                           PD1(3,K,IANT,J) = A
                           P = RAD2DG *  ATAN2 (DTERMS(2,JJ),
     *                        DTERMS(1,JJ))
                           PD1(4,K,IANT,J) = P
                           IF (DOMAX) THEN
                              YYMN(2,JA) = MIN (YYMN(2,JA), A)
                              YYMX(2,JA) = MAX (YYMX(2,JA), A)
                              YYMIN(2,JA) = MIN (YYMIN(2,JA), P)
                              YYMAX(2,JA) = MAX (YYMAX(2,JA), P)
                              IF (P.LT.0.0) P = P + 360.
                              PPMIN(2,JA) = MIN (PPMIN(2,JA), P)
                              PPMAX(2,JA) = MAX (PPMAX(2,JA), P)
                              END IF
                           END IF
                        END IF
 60                  CONTINUE
 70               CONTINUE
               END IF
 90         CONTINUE
 100     CONTINUE
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PDPMAX: ERROR',I4,' ON ',A)
      END
      SUBROUTINE PDPLOT (NV, NA, PD1, IERR)
C-----------------------------------------------------------------------
C   PDPLOT manages calls to the actual plot subroutine
C   Inputs
C      NV     I      Product Nif * Nchan
C      NA     I      Number of antennas
C      PD1    R(*)   PD table 1 data (4, NV, ant)
C                      the 4 = rr amp phase ll amp phase
C   Output
C      IERR   I      Error code
C-----------------------------------------------------------------------
      INTEGER   NV, NA, IERR
      REAL      PD1(4,NV,NA,*)
C
      INCLUDE 'PDPLT.INC'
      INTEGER   IANT, JANT, MANT, I, J, K, KANT
      LOGICAL   HAVE
C-----------------------------------------------------------------------
C                                               count plots
      MANT = 0
      KANT = 0
      DO 10 K = 1,50
         HAVE = .FALSE.
         DO 5 J = 1,MFIL
            IANT = ANTS(K,J)
            IF (IANT.GT.0) THEN
               HAVE = HAVE .OR. HAVE1(IANT,J)
               IF (HAVE1(IANT,J)) KANT = KANT + 1
            END IF
 5          CONTINUE
         IF (HAVE) MANT = MANT + 1
 10      CONTINUE
C                                               all on one
      IF (XOVER.GT.0.0) THEN
         CALL PLOTPD (NV, NA, PD1, 0, MANT, KANT, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR
            GO TO 900
            END IF
C                                               1 ant at a time
      ELSE
         CALL RFILL (50, 0.0, XANT)
         K = 10 * MAXFIL - 10
         CALL RFILL (K, 0.0, BPARM)
         JANT = 0
         DO 20 K = 1,50
            HAVE = .FALSE.
            KANT = 0
            DO 15 J = 1,MFIL
               IANT = ANTS(K,J)
               IF (IANT.GT.0) THEN
                  HAVE = HAVE .OR. HAVE1(IANT,J)
                  IF (HAVE1(IANT,J)) KANT = KANT + 1
                  END IF
 15            CONTINUE
            IF (HAVE) THEN
               JANT = JANT + 1
               I = 1
               IF (JANT.EQ.MANT) I = -1
               XANT(1) = ANTS(K,1)
               BPARM(1,1) = ANTS(K,2)
               BPARM(1,2) = ANTS(K,3)
               BPARM(1,3) = ANTS(K,4)
               CALL PLOTPD (NV, NA, PD1, K, I, KANT, IERR)
               IF (IERR.NE.0) THEN
                  WRITE (MSGTXT,1005) IERR, IANT
                  GO TO 900
                  END IF
               END IF
 20         CONTINUE
         END IF
      GO TO 999
C
 900  IF (IERR.GT.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I4,' FROM PLOTPD DOING ALL PLOTS')
 1005 FORMAT ('ERROR',I4,' FROM PLOTPD ON ANTENNA',I4)
      END
      SUBROUTINE PLOTPD (NV, NA, PD1, IANT, MANT, KANT, IRET)
C-----------------------------------------------------------------------
C   PDPLT makes the actual plot
C   Inputs
C      NV     I      Product Nif * Nchan
C      PD1    R(*)   PD table 1 data (4, NV, ant)
C                      the 4 = rr amp phase ll amp phase
C      IANT   I      Subscript in ANTS(i,*) (0 -> all)
C      MANT   I      Max ANTS(i,*) to use (1.-1 when IANT > 0)
C      KANT   I      Actual number antennas in this plot
C   Output
c      IRET   I      Error code
C-----------------------------------------------------------------------
      INTEGER   NV, NA, IANT, MANT, KANT, IRET
      REAL      PD1(4,NV,NA,*)
C
      INCLUDE 'PDPLT.INC'
      INTEGER   NYP, ICODE, PLBUFF(256), PVER, TVCORN(4), TVCHN, GRCHAN,
     *   PLUN, PIND, DEPTH(5), I, J, LANT, IYP, ID(3), IT(3), INCHAR, L,
     *   IA1, IA2, IA, IP, IROUND, IC1, IC2, IP2, K, ICL, JANT, KKANT,
     *   KK, LLANT
      REAL      DX, DY, PLTXIN, PLTYIN, PLTXOF, PLTYOF, BLC(2), TRC(2),
     *   XBLC(2), XTRC(2), LINT, PRANGE(2), XMIN, XMAX, YMIN, YMAX, X,
     *   Y, XLINT, SRANGE(2), PMIN, PMAX, COLV, DCOLV, COL(3),
     *   PBLC(2,2), PTRC(2,2)
      LOGICAL   DOFLIP, GOOD, FLIP2, FIRST, HAVE
      CHARACTER PFILE*48, ATIME*8, ADATE*12, TEXT*80, PROBLM*48,
     *   TEXT2*80
      DATA TVCHN, TVCORN, DEPTH /1, 4*0, 5*1/
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DTVC.INC'
C-----------------------------------------------------------------------
C                                               antennas to plot
      IF (IANT.EQ.0) THEN
         IA1 = 1
         IA2 = 50
      ELSE
         IA1 = IANT
         IA2 = IANT
         END IF
      IC1 = (BIF - 1) * NCHAN + 1
      IC2 = EIF * NCHAN
      DO3COL =  IROUND (XDO3C)
      IF (XDO3C.GT.0.0) DO3COL = MAX (1, DO3COL)
      IF (XOVER.LE.0.0) DO3COL = MIN (1, DO3COL)
      I = ABS (MANT)
      IF (DO3COL.EQ.1) I = I * MFIL
      DCOLV = 0.97 / MAX (I-1,1)
      JANT = ABS(MANT) * MFIL
      KKANT = MIN (JANT, 18)
C                                               positioning parameters
      NYP = MUMPOL
      IF (NPOL.EQ.1) NYP = 1
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      PLTXIN = 1000.0 / 0.75
      PLTYIN = 1000.0 / (NYP - 0.1)
      PLTXOF = PLTXIN - 1000.
      PLTYOF = NYP * PLTYIN - 1000.0
      ICODE = 3
      IF (OPTYPE.EQ.'AMP') ICODE = 1
      IF (OPTYPE.EQ.'PHAS') ICODE = 2
      LINT = 1000.0
      IF (ICODE.EQ.3) LINT = 700.0
      LLANT = MAX (1, IANT)
C                                               create plot file
      IF (.NOT.DOTV) THEN
         PVER = 0
         CALL MADDEX ('PL', DISKIN(1), CNOIN(1), CATI(1,1), PLBUFF,
     *      .TRUE., 'WRIT', PVER, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'ADDING PL FILE TO HEADER'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         END IF
C                                       Open the PLot file.
      CALL ZPHFIL ('PL', DISKIN(1), CNOIN(1), PVER, PFILE, IRET)
      GRCHAN = XGRCH + 0.1
      CALL GINIT (DISKIN(1), CNOIN(1), PFILE, 0, 69, NPARMS, XNAMEI,
     *   DOTV, TVCHN, GRCHAN, TVCORN, CATBLK, PLBUFF, PLUN, PIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT THE PLOT FILE: QUITTING'
         CALL MSGWRT (8)
         IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN(1), CNOIN(1), 'WRIT',
     *      CATI(1,1), PLBUFF, PVER, I)
         GO TO 999
         END IF
C                                        Set text borders at L, B,
C                                        R & T in characters
      CALL RFILL (4, 0.5, CH)
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS (LABEL), 100)
      I = 0
      IF (MOD(ICODE,2).EQ.1) THEN
         PRANGE(1) = YYMN(1,LLANT)
         PRANGE(2) = YYMX(1,LLANT)
         CALL GTICNT (LABEL, PRANGE, J)
         I = MAX (I, J)
         IF (NPOL.GT.1) THEN
            PRANGE(1) = YYMN(2,LLANT)
            PRANGE(2) = YYMX(2,LLANT)
            CALL GTICNT (LABEL, PRANGE, J)
            I = MAX (I, J)
            END IF
         END IF
      IF (ICODE.GT.1) THEN
         PRANGE(1) = YYMIN(1,LLANT)
         PRANGE(2) = YYMAX(1,LLANT)
         CALL GTICNT (LABEL, PRANGE, J)
         I = MAX (I, J)
         IF (NPOL.GT.1) THEN
            PRANGE(1) = YYMIN(2,LLANT)
            PRANGE(2) = YYMAX(2,LLANT)
            CALL GTICNT (LABEL, PRANGE, J)
            I = MAX (I, J)
            END IF
         END IF
      CALL RFILL (4, 0.5, CH)
      IF (LTYPE.EQ.2) CH(1) = 3.5
      IF (LTYPE.GT.2) CH(1) = I + 4.0
      IF (LTYPE.GT.1) THEN
         CH(2) = 2.0 + 1.666
         IF (LTYPE.GT.2) THEN
            CH(2) = CH(2) + 1.333
            IF (APARM(10).LE.0.0) CH(2) = CH(2) + 1.333
            END IF
         END IF
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CH(4) = 2.0
         IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
         IF (MFIL.GT.2) CH(4) = CH(4) + 1.333
         IF (JANT.GT.24) CH(2) = CH(2) + 1.333
         IF (JANT.GT.48) CH(2) = CH(2) + 1.333
         END IF
      IF (XYRATO.LE.0.0) THEN
         IF (DOTV) THEN
            DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) + CH(3))
            DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) + CH(4))
            XYRATO = 1.0
            IF (DY.GT.0.0) XYRATO = DX / DY
         ELSE
            XYRATO = 1.0
            END IF
         END IF

C                                        Init. for line drawing
      CALL GINITL (BLC, TRC, XYRATO, CH, DEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) THEN
         PROBLM = 'INIT FOR LINE DRAWING'
         GO TO 950
         END IF
      DO 100 IYP = NYP,1,-1
C                                       Set window for current plot.
         XBLC(1) = BLC(1)
         XBLC(2) = BLC(2) + (IYP-1) * PLTYIN
         XTRC(1) = XBLC(1) + PLTXIN - 1.0 - PLTXOF
         XTRC(2) = XBLC(2) + PLTYIN - 1.0 - PLTYOF
         XLINT = XBLC(2) + (LINT/1000.0) * PLTYIN
         XLINT = MIN (XLINT, XTRC(2))
         PBLC(1,1) = XBLC(1)
         PBLC(1,2) = XBLC(1)
         PTRC(1,1) = XTRC(1)
         PTRC(1,2) = XTRC(1)
         PBLC(2,1) = XBLC(2)
         PBLC(2,2) = XLINT
         PTRC(2,1) = XLINT
         PTRC(2,2) = XTRC(2)
C                                       Draw borders.
         PROBLM = 'DRAWING BORDERS'
         CALL GLTYPE (1, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GPOS (XBLC(1), XBLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (XTRC(1), XBLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (XTRC(1), XTRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (XBLC(1), XTRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (XBLC(1), XBLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         IF (LINT.LT.1000.0) THEN
            CALL GPOS (XBLC(1), XLINT, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            CALL GVEC (XTRC(1), XLINT, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            END IF
         IF (IYP.EQ.NYP) THEN
            DX = 0.0
            DY = CH(4) - 1.5
C                                       Date/time/version
            IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               PROBLM = 'LABEL DATE/TIME'
               CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               CALL ZDATE (ID)
               CALL ZTIME (IT)
               CALL TIMDAT (IT, ID, ATIME, ADATE)
               WRITE (TEXT,1050) PVER, ADATE, ATIME
               CALL REFRMT (TEXT, '_', INCHAR)
               CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               DY = DY - 1.333
               END IF
C                                       File name label & source name
            IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
               PROBLM = 'FILENAME LABEL'
               CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               WRITE (TEXT,1055) NAMEIN(1), CLAIN(1), SEQIN(1), IVER(1)
               CALL CHPACK (TEXT, '_', INCHAR)
               IF (MFIL.GE.2) THEN
                  WRITE (TEXT2,1055) NAMEIN(2), CLAIN(2), SEQIN(2),
     *               IVER(2)
                  CALL CHPACK (TEXT2, '_', L)
                  TEXT(INCHAR+4:) = TEXT2(:L)
                  INCHAR = INCHAR + L + 3
                  END IF
               CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               DY = DY - 1.333
               IF (MFIL.GT.2) THEN
                  CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  WRITE (TEXT,1055) NAMEIN(3), CLAIN(3), SEQIN(3),
     *               IVER(3)
                  CALL CHPACK (TEXT, '_', INCHAR)
                  IF (MFIL.GT.3) THEN
                     WRITE (TEXT2,1055) NAMEIN(4), CLAIN(4), SEQIN(4),
     *                  IVER(4)
                     CALL CHPACK (TEXT2, '_', L)
                     TEXT(INCHAR+4:) = TEXT2(:L)
                     INCHAR = INCHAR + L + 3
                     END IF
                  CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  DY = DY - 1.333
                  END IF
C                                       antennas
               COLV = -DCOLV
               FIRST = .TRUE.
               ICL = 0
               IF (DO3COL.GT.0) ICL = 1
               PROBLM = 'ANTENNAS LISTING'
               DY = -2.844
               IF (LTYPE.GT.2) DY = -5.833
               IF (APARM(10).GT.0.0) DY = DY + 1.333
               KK = 0
               DO 10 IA = IA1,IA2
                  HAVE = (ANTS(IA,1).GT.0) .AND. (HAVE1(ANTS(IA,1),1))
                  HAVE = ((ANTS(IA,2).GT.0) .AND. (HAVE1(ANTS(IA,2),2)))
     *               .OR. HAVE
                  HAVE = ((ANTS(IA,3).GT.0) .AND. (HAVE1(ANTS(IA,3),3)))
     *               .OR. HAVE
                  HAVE = ((ANTS(IA,4).GT.0) .AND. (HAVE1(ANTS(IA,4),4)))
     *               .OR. HAVE
                  IF (HAVE) THEN
                     DO 5 L = 1,MFIL
                        LANT = ANTS(IA,L)
                        IF (LANT.LE.0) GO TO 5
                        KK = KK + 1
                        IF (LANT.LT.10) THEN
                           K = 2
                        ELSE IF (LANT.LT.100) THEN
                           K = 2
                        ELSE
                           K = 1
                           END IF
                        IF (FIRST) THEN
                           TEXT = 'ANT:'
                           CALL GPOS (BLC(1), BLC(2), PLBUFF, IRET)
                           IF (IRET.NE.0) GO TO 950
                           DX = 0.5 - CH(1)
                           CALL GCHAR (4, 0, DX, DY, TEXT(:4), PLBUFF,
     *                        IRET)
                           IF (IRET.NE.0) GO TO 950
                           FIRST = .FALSE.
                           DX = DX + 5.0
                           END IF
                        WRITE (TEXT,1010) LANT
                        CALL GPOS (BLC(1), BLC(2), PLBUFF, IRET)
                        IF (IRET.NE.0) GO TO 950
                        IF ((DO3COL.EQ.1) .OR. (L.EQ.1)) THEN
                           COLV = COLV + DCOLV
                           CALL COLOR3 (COLV, .FALSE., COL)
                           CALL G3VCOL (COL(1), COL(2), COL(3), PLBUFF,
     *                        IRET)
                           IF (IRET.NE.0) GO TO 950
                           END IF
                        IF (DO3COL.GT.0) THEN
                           CALL G3CHAR (5-K, 0, DX, DY, TEXT(K:4),
     *                        PLBUFF, IRET)
                        ELSE
                           CALL GCHAR (5-K, 0, DX, DY, TEXT(K:4),
     *                        PLBUFF, IRET)
                           END IF
                        IF (IRET.NE.0) GO TO 15
                        DX = DX + 6 - K
                        IF (KK.EQ.KKANT) THEN
                           DY = DY - 1.333
                           DX = 5.5 - CH(1)
                           KK = 0
                           END IF
 5                      CONTINUE
                     END IF
 10               CONTINUE
               END IF
C                                       pointer and range
 15         IP = 2 * ISTOK - 1
            DOFLIP = .FALSE.
            FLIP2 = .FALSE.
            PRANGE(1) = YYMN(ISTOK,LLANT)
            PRANGE(2) = YYMX(ISTOK,LLANT)
            IF (PIXR(2).GT.PIXR(1)) THEN
               PRANGE(1) = PIXR(1)
               PRANGE(2) = PIXR(2)
               END IF
            IF (ICODE.EQ.2) THEN
               IP = IP + 1
               DOFLIP = (PPMAX(ISTOK,LLANT)-PPMIN(ISTOK,LLANT)) .LT.
     *            (YYMAX(ISTOK,LLANT)-YYMIN(ISTOK,LLANT))
               IF (DOFLIP) THEN
                  PRANGE(1) = PPMIN(ISTOK,LLANT)
                  PRANGE(2) = PPMAX(ISTOK,LLANT)
               ELSE
                  PRANGE(1) = YYMIN(ISTOK,LLANT)
                  PRANGE(2) = YYMAX(ISTOK,LLANT)
                  END IF
            ELSE IF (ICODE.EQ.3) THEN
               IP2 = IP + 1
               IF (APARM(1).LT.APARM(2)) THEN
                  FLIP2 = APARM(1).GE.0.0
                  SRANGE(1) = APARM(1)
                  SRANGE(2) = APARM(2)
               ELSE
                  FLIP2 = (PPMAX(ISTOK,LLANT)-PPMIN(ISTOK,LLANT)) .LT.
     *               (YYMAX(ISTOK,LLANT)-YYMIN(ISTOK,LLANT))
                  IF (FLIP2) THEN
                     SRANGE(1) = PPMIN(ISTOK,LLANT)
                     SRANGE(2) = PPMAX(ISTOK,LLANT)
                  ELSE
                     SRANGE(1) = YYMIN(ISTOK,LLANT)
                     SRANGE(2) = YYMAX(ISTOK,LLANT)
                     END IF
                  END IF
               END IF
         ELSE
            IP = 3
            DOFLIP = .FALSE.
            PRANGE(1) = YYMN(2,LLANT)
            PRANGE(2) = YYMX(2,LLANT)
            IF (PIXR(2).GT.PIXR(1)) THEN
               PRANGE(1) = PIXR(1)
               PRANGE(2) = PIXR(2)
               END IF
            IF (ICODE.EQ.2) THEN
               IP = IP + 1
               DOFLIP = (PPMAX(2,LANT)-PPMIN(2,LANT)) .LT.
     *            (YYMAX(2,LLANT)-YYMIN(2,LLANT))
               IF (DOFLIP) THEN
                  PRANGE(1) = PPMIN(2,LLANT)
                  PRANGE(2) = PPMAX(2,LLANT)
               ELSE
                  PRANGE(1) = YYMIN(2,LLANT)
                  PRANGE(2) = YYMAX(2,LLANT)
                  END IF
            ELSE IF (ICODE.EQ.3) THEN
               IP2 = IP + 1
               IF (APARM(1).LT.APARM(2)) THEN
                  FLIP2 = APARM(1).GE.0.0
                  SRANGE(1) = APARM(1)
                  SRANGE(2) = APARM(2)
               ELSE
                  FLIP2 = (PPMAX(2,LLANT)-PPMIN(2,LLANT)) .LT.
     *               (YYMAX(2,LLANT)-YYMIN(2,LLANT))
                  IF (FLIP2) THEN
                     SRANGE(1) = PPMIN(2,LLANT)
                     SRANGE(2) = PPMAX(2,LLANT)
                  ELSE
                     SRANGE(1) = YYMIN(2,LLANT)
                     SRANGE(2) = YYMAX(2,LLANT)
                     END IF
                  END IF
               END IF
            END IF
         XMIN = (BIF - 1.) * NCHAN
         XMAX = (EIF-BIF+1) * NCHAN + XMIN + 1
         YMIN = PRANGE(1) - 0.03*(PRANGE(2)-PRANGE(1))
         YMAX = PRANGE(2) + 0.03*(PRANGE(2)-PRANGE(1))
         PMIN = SRANGE(1) - 0.03*(SRANGE(2)-SRANGE(1))
         PMAX = SRANGE(2) + 0.03*(SRANGE(2)-SRANGE(1))
         DX = 5 * FACTOR / XYRATO
         DY = 5 * FACTOR
C                                       pointer and range
         CALL PDPLAB (ICODE, IYP, PBLC, PTRC, YMIN, YMAX, PMIN, PMAX,
     *      PLBUFF, IRET)
         PROBLM = 'FROM PDPLAB'
         IF (IRET.NE.0) GO TO 950
C                                       plot the data
         COLV = -DCOLV
         DO 95 IA = IA1,IA2
            HAVE = (ANTS(IA,1).GT.0) .AND. (HAVE1(ANTS(IA,1),1))
            HAVE = ((ANTS(IA,2).GT.0) .AND. (HAVE1(ANTS(IA,2),2)))
     *         .OR. HAVE
            HAVE = ((ANTS(IA,3).GT.0) .AND. (HAVE1(ANTS(IA,3),3)))
     *         .OR. HAVE
            HAVE = ((ANTS(IA,4).GT.0) .AND. (HAVE1(ANTS(IA,4),4)))
     *         .OR. HAVE
            IF (.NOT.HAVE) GO TO 95
            DO 90 L = 1,MFIL
               IF ((DO3COL.EQ.1) .OR. (L.EQ.1)) THEN
                  COLV = COLV + DCOLV
                  CALL COLOR3 (COLV, .FALSE., COL)
                  CALL G3VCOL (COL(1), COL(2), COL(3), PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  END IF
               LANT = ANTS(IA,L)
               IF (LANT.LE.0) GO TO 90
               WRITE (PROBLM,1020) LANT, 'PLOT SYMBOLS'
               IF (ISYM.GT.0) THEN
                  IF (DO3COL.LE.0) THEN
                     CALL GLTYPE (4, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 950
                     END IF
                  DO 20 I = IC1,IC2
                     Y = PD1(IP,I,LANT,L)
                     IF (Y.NE.FBLANK) THEN
                        IF ((DOFLIP) .AND. (Y.LT.0.0)) Y = Y + 360.0
                        X = (PX(I,L) - XMIN) / (XMAX - XMIN) *
     *                     (XTRC(1) - XBLC(1)) + XBLC(1)
                        Y = (Y - YMIN) / (YMAX-YMIN) * (XLINT-XBLC(2)) +
     *                     XBLC(2)
                        IF ((X.GE.XBLC(1)) .AND. (X.LE.XTRC(1)) .AND.
     *                     (Y.LE.XLINT) .AND. (Y.GE.XBLC(2))) THEN
                           CALL GMARK (X, Y, DX, DY, PBLC(1,1),
     *                        PTRC(1,1), PLBUFF, IRET)
                           IF (IRET.NE.0) GO TO 950
                           END IF
                        END IF
 20                  CONTINUE
                  END IF
               IF ((ICODE.EQ.3) .AND. (ISYM.GT.0)) THEN
                  WRITE (PROBLM,1020) LANT, 'PLOT 2ND SYMBOLS'
                  DO 30 I = IC1,IC2
                     Y = PD1(IP2,I,LANT,L)
                     IF (Y.NE.FBLANK) THEN
                        IF ((FLIP2) .AND. (Y.LT.0.0)) Y = Y + 360.0
                        X = (PX(I,L) - XMIN) / (XMAX - XMIN) *
     *                     (XTRC(1)-XBLC(1)) + XBLC(1)
                        Y = (Y - PMIN) / (PMAX-PMIN) * (XTRC(2) - XLINT)
     *                     + XLINT
                        IF ((X.GE.XBLC(1)) .AND. (X.LE.XTRC(1)) .AND.
     *                     (Y.GE.XLINT) .AND. (Y.LE.XTRC(2))) THEN
                           CALL GMARK (X, Y, DX, DY, PBLC(1,2),
     *                        PTRC(1,2), PLBUFF, IRET)
                           IF (IRET.NE.0) GO TO 950
                           END IF
                        END IF
 30                  CONTINUE
                  END IF
               IF (DOLINE) THEN
                  WRITE (PROBLM,1020) LANT, 'PLOT LINES'
                  IF (DO3COL.LE.0) THEN
                     CALL GLTYPE (2, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 950
                     END IF
                  GOOD = .FALSE.
                  DO 40 I = IC1,IC2
                     Y = PD1(IP,I,LANT,L)
                     IF (Y.NE.FBLANK) THEN
                        IF ((DOFLIP) .AND. (Y.LT.0.0)) Y = Y + 360.0
                        X = (PX(I,L) - XMIN) / (XMAX - XMIN) *
     *                     (XTRC(1)-XBLC(1)) + XBLC(1)
                        Y = (Y - YMIN) / (YMAX-YMIN) * (XLINT-XBLC(2)) +
     *                     XBLC(2)
                        IF ((X.GE.XBLC(1)) .AND. (X.LE.XTRC(1)) .AND.
     *                     (Y.LE.XLINT) .AND. (Y.GE.XBLC(2))) THEN
                           IF (GOOD) THEN
                              IF (DO3COL.GT.0) THEN
                                 CALL G3VEC (X, Y, PLBUFF, IRET)
                              ELSE
                                 CALL GVEC (X, Y, PLBUFF, IRET)
                                 END IF
                           ELSE
                              CALL GPOS (X, Y, PLBUFF, IRET)
                              END IF
                           IF (IRET.NE.0) GO TO 950
                           GOOD = .TRUE.
                        ELSE
                           GOOD = .FALSE.
                        END IF
                     ELSE
                        GOOD = .FALSE.
                        END IF
 40                  CONTINUE
                  IF (ICODE.EQ.3) THEN
                     WRITE (PROBLM,1020) LANT, 'PLOT 2ND LINES'
                     GOOD = .FALSE.
                     DO 50 I = IC1,IC2
                        Y = PD1(IP2,I,LANT,L)
                        IF (Y.NE.FBLANK) THEN
                           IF ((FLIP2) .AND. (Y.LT.0.0)) Y = Y + 360.0
                           X = (PX(I,1)-XMIN)/(XMAX-XMIN) *
     *                        (XTRC(1)-XBLC(1)) + XBLC(1)
                           Y = (Y - PMIN) / (PMAX-PMIN) *
     *                        (XTRC(2) - XLINT) + XLINT
                           IF ((X.GE.XBLC(1)) .AND. (X.LE.XTRC(1)) .AND.
     *                        (Y.GE.XLINT) .AND. (Y.LE.XTRC(2))) THEN
                              IF (GOOD) THEN
                                 IF (DO3COL.GT.0) THEN
                                    CALL G3VEC (X, Y, PLBUFF, IRET)
                                 ELSE
                                    CALL GVEC (X, Y, PLBUFF, IRET)
                                    END IF
                              ELSE
                                 CALL GPOS (X, Y, PLBUFF, IRET)
                                 END IF
                              IF (IRET.NE.0) GO TO 950
                              GOOD = .TRUE.
                           ELSE
                              GOOD = .FALSE.
                              END IF
                        ELSE
                           GOOD = .FALSE.
                           END IF
 50                     CONTINUE
                     END IF
                  END IF
 90            CONTINUE
 95         CONTINUE
 100     CONTINUE
      GPHPAG = (IANT.GT.0) .AND. (MANT.GT.0)
      CALL GFINIS (PLBUFF, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINISH PLOT'
         PROBLM = ' '
         GO TO 940
      ELSE IF (IRET.LT.0) THEN
         MSGTXT = 'Stopping at your request'
         CALL MSGWRT (3)
         END IF
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1100) PVER
         CALL MSGWRT (3)
         END IF
      GO TO 999
C                                       Error return from plotting
 940  CALL MSGWRT (8)
 950  IF (PROBLM.NE.' ') THEN
         MSGTXT = 'PLOT ERROR ' // PROBLM
         CALL MSGWRT (8)
         END IF
C                                       Destroy the PLot file on error.
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) PVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN(1), PFILE, I)
         CALL DELEXT ('PL', DISKIN(1), CNOIN(1), 'WRIT', CATI(1,1),
     *      PLBUFF, PVER, I)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLOTPD ERROR',I4,' ON ',A)
 1010 FORMAT (I4)
 1020 FORMAT ('ANTENNA',I3,' ON ',A)
 1050 FORMAT ('Plot file version',I4,'__created ',A12,A8)
 1055 FORMAT (A12,'.',A6,'.',I5,'__PD_vers_',I4)
 1100 FORMAT ('Plot file version',I4,' created')
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
      SUBROUTINE GMARK (X, Y, DX, DY, PBLC, PTRC, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   GMARK makes a symbol of type ISYM at X, Y
C   Inputs:
C      X        R      Center point X
C      Y        R      Center point Y
C      DX       R      Extent X
C      DY       R      Extent Y
C      PBLC     R(2)   BLC of plot
C      PTRC     R(2)   TRC of plot
C   In/Out:
C      PLBUFF   I(*)   Plot buffer
C   Out:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   PLBUFF(*), IRET
      REAL      X, Y, DX, DY, PBLC(2), PTRC(2)
C
      INCLUDE 'PDPLT.INC'
      REAL      AX(5), AY(5)
      LOGICAL   DO3C
C-----------------------------------------------------------------------
      DO3C = DO3COL.GT.0
      IF (ISYM.GT.0) THEN
         AX(1) = X
         AY(1) = Y
         AX(2) = X - DX/2.0
         AX(3) = X + DX/2.0
         AX(4) = X
         AX(5) = X
         AY(2) = Y
         AY(3) = Y
         AY(4) = Y + DY/2.0
         AY(5) = Y - DY/2.0
         CALL PNTPLT (ISYM, AX, AY, PBLC, PTRC, .FALSE., DO3C, PLBUFF,
     *      IRET)
         END IF
C
 999  RETURN
      END
      SUBROUTINE PDPLAB (ICODE, IYP, PBLC, PTRC, YMIN, YMAX, PMIN, PMAX,
     *   PLBUFF, IRET)
C-----------------------------------------------------------------------
C   PDPLAB labels the axes
C   Inputs:
C      ICODE    I        1 amp, 2 phase, 3 both
C      IYP      I        Pane number - label X axis only on 1
C      PBLC     R(2,2)   BLC of 1 or portions of panel
C      PTRC     R(2,2)   TRC of 1 or portions of panel
C      YMIN     R        min value lower portion
C      YMAX     R        max value lower portion
C      PMIN     R        min value upper portion
C      PMIN     R        max value upper portion
C   In/out:
C      PLBUFF   I(256)   plot buffer
C   Output:
C      IRET     I        error code
C-----------------------------------------------------------------------
      INTEGER   ICODE, IYP, PLBUFF(*), IRET
      REAL      PBLC(2,2), PTRC(2,2), YMIN, YMAX, PMIN, PMAX
C
      INCLUDE 'PDPLT.INC'
      INTEGER   IP, NP, INOINT, INCHAR, I, J, IXO, NINT
      REAL      XMIN, XMAX, AMIN, AMAX, XINTER(24), DIST, XINT, XVAL,
     *   DCXM, XPOS, YPOS, X, Y, DCX, DCY, TICLEN, TICSCL, X0, DEG, DU,
     *   DL
      CHARACtER MSGBUF*80, PROBLM*48, STKLAB*6, PREFIX*5
      DATA TICSCL /80.0/
      DATA XINTER /.001, .002, .005, .01, .02, .05, .1, .2, .5,
     *   1., 2., 5., 10., 20., 50., 100., 200., 500.,
     *   1000., 2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
      NP = 1
      IF (ICODE.EQ.3) NP = 2
      XMIN = (BIF - 1) * NCHAN
      XMAX = EIF * NCHAN + 1
C                                       first portion plot range
      AMIN = YMIN
      AMAX = YMAX
      IF (ICODE.NE.2) THEN
         AMIN = AMIN * 1000.0
         AMAX = AMAX * 1000.0
         END IF
C                                       vertical axes
      TICLEN = (PTRC(1,1) - PBLC(1,1)) / TICSCL
      DO 100 IP = 1,NP
         IF (IP.EQ.2) THEN
            AMAX = PMAX
            AMIN = PMIN
            END IF
         DIST = AMAX - AMIN
         XINT = MAX (2.0, MIN (8.0, 12.0-(NP/2)))
         DO 10 I = 1,24
            DEG = XINTER(I)
            DU = AINT (AMAX/DEG) * DEG
            IF (DU.GT.AMAX) DU = DU - DEG
            DL = AINT (AMIN/DEG) * DEG
            IF (DL.LT.AMIN) DL = DL + DEG
            INOINT = (DU-DL) / DEG + 1.01
            IF (INOINT.LE.XINT) GO TO 15
 10         CONTINUE
         MSGTXT = 'CANNOT FIND VERTICAL AXIS INCREMENT'
         CALL MSGWRT (8)
         GO TO 100
C                                       Interval and no of inter found.
 15      XINT = DEG
         INOINT = INOINT + 2
         XVAL = AINT (AMIN/XINT) * XINT
         IF (XVAL.GE.AMIN) XVAL = XVAL - XINT
         IXO = I
         DCXM = -0.5
C                                       Loop for all tics.
         PROBLM = 'VERTICAL AXIS LABELS'
         DO 50 I = 1,INOINT
            XVAL = XVAL + XINT
            YPOS = (XVAL - AMIN) / (AMAX - AMIN) *
     *         (PTRC(2,IP) - PBLC(2,IP)) + PBLC(2,IP)
            IF (YPOS.GT.PTRC(2,IP)) GO TO 55
C                                       right hand tic.
            CALL GPOS (PTRC(1,IP), YPOS, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            X = PTRC(1,IP) - TICLEN
            CALL GVEC (X, YPOS, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
C                                       Left hand tic.
            X = PBLC(1,IP) + TICLEN
            CALL GPOS (X, YPOS, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            CALL GVEC (PBLC(1,IP), YPOS, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
C                                       Write value.
            IF (LTYPE.GT.2) THEN
               WRITE (MSGBUF,1030) XVAL
               CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
               IF (IXO.GT.3) INCHAR = INCHAR - 1
               IF (IXO.GT.6) INCHAR = INCHAR - 1
               IF (IXO.GT.9) INCHAR = INCHAR - 2
               DCX = - INCHAR - 1.0
               DCY = -0.5
               DCXM = MIN (DCXM, DCX)
               CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               END IF
C                                       IF dividers
            IF ((EIF.GT.BIF) .AND. (APARM(4).LE.0.0)) THEN
               DO 30 J = BIF,EIF-1
                  X0 = J * NCHAN + 0.5
                  X0 = (X0 - XMIN) / (XMAX - XMIN) *
     *               (PTRC(1,IP) - PBLC(1,IP)) + PBLC(1,IP)
                  IF (I.EQ.1) THEN
                     CALL GPOS (X0, PBLC(2,IP), PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 950
                     CALL GVEC (X0, PTRC(2,IP), PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 950
                     END IF
                  X = X0 - TICLEN/2.0
                  CALL GPOS (X, YPOS, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  X = X0 +TICLEN/2.0
                  CALL GVEC (X, YPOS, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
 30               CONTINUE
               END IF
 50         CONTINUE
 55      MSGBUF = 'Milli-Amplitude'
         IF ((ICODE.EQ.2) .OR. (IP.EQ.2)) MSGBUF = 'Phase'
         DCX = DCXM - 2.0
         YPOS = (PTRC(2,IP) + PBLC(2,IP)) / 2.0
         CALL GPOS (PBLC(1,1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
         DCY = INCHAR / 2.0 - 1.0
         CALL GCHAR (INCHAR, 1, DCX, DCY, MSGBUF, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
 100     CONTINUE
C                                       Horizontal axis
      IF (APARM(3).GT.0.0) THEN
         PROBLM = 'FREQUENCY LABELING X AXIS'
         CALL FRQLAB (ICODE, IYP, PBLC, PTRC, PREFIX, PLBUFF, IRET)
         IF (IRET.GT.0) GO TO 950
         IF (IRET.EQ.0) GO TO 200
         END IF
      XINT = 32 / (EIF-BIF+1)
      XINT = MAX(3.0, MIN (10.0, XINT))
      DIST = NCHAN
      DO 110 I = 1,24
         DEG = XINTER(I)
         DU = AINT (NCHAN/DEG) * DEG
         IF (DU.GT.NCHAN) DU = DU - DEG
         DL = AINT (1.0/DEG) * DEG
         IF (DL.LT.1.0) DL = DL + DEG
         INOINT = (DU-DL) / DEG + 1.01
         IF (INOINT.LE.XINT) GO TO 115
 110     CONTINUE
      MSGTXT = 'CANNOT FIND X AXIS INCREMENT'
      CALL MSGWRT (8)
      GO TO 200
C                                       Interval and no of inter found.
 115  XINT = DEG
      INOINT = INOINT + 2
      XVAL = AINT (1.0/XINT) * XINT
      IF (XVAL.GE.1.0) XVAL = XVAL - XINT
      IXO = I
      TICLEN = (PTRC(2,1) - PBLC(2,1)) / 25.0
      NINT = ((INOINT-2)*(EIF-BIF+1)) / 16
      NINT = MAX (1,NINT)
      DCY = -1.5
      PROBLM = 'PLOT X AXIS TICKS/LABELS'
C                                       Loop for all tics.
      DO 150 J = BIF,EIF
         XVAL = AINT (1.0/XINT) * XINT
         IF (XVAL.GE.1.0) XVAL = XVAL - XINT
         DO 140 I = 1,INOINT
            XVAL = XVAL + XINT
            IF (XVAL.GT.NCHAN) GO TO 150
            XPOS = XVAL + (J-1) * NCHAN
            XPOS = (XPOS - XMIN) / (XMAX-XMIN) * (PTRC(1,1) - PBLC(1,1))
     *         + PBLC(1,1)
            CALL GPOS (XPOS, PBLC(2,1), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = PBLC(2,1) + TICLEN
            CALL GVEC (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = PTRC(2,1) - TICLEN
            CALL GPOS (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            CALL GVEC (XPOS, PTRC(2,1), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            IF (ICODE.EQ.3) THEN
               CALL GPOS (XPOS, PBLC(2,2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               Y = PBLC(2,2) + TICLEN
               CALL GVEC (XPOS, Y, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               Y = PTRC(2,2) - TICLEN
               CALL GPOS (XPOS, Y, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               CALL GVEC (XPOS, PTRC(2,2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               END IF
            IF ((IYP.EQ.1) .AND. (LTYPE.GT.2)) THEN
               CALL GPOS (XPOS, PBLC(2,1), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               WRITE (MSGBUF,1030) XVAL
               CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
               IF (IXO.GT.3) INCHAR = INCHAR - 1
               IF (IXO.GT.6) INCHAR = INCHAR - 1
               IF (IXO.GT.9) INCHAR = INCHAR - 2
               DCX = 0.5 - INCHAR
               CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               END IF
 140        CONTINUE
 150     CONTINUE
C                                       IF numbers
 200  IF (IYP.EQ.1) THEN
         PROBLM = 'PLOT IF NUMBERS'
         IF (LTYPE.GT.2) THEN
            X = (PTRC(1,1) + PBLC(1,1)) / 2.0
            CALL GPOS (X, PBLC(2,1), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            DCY = -2.833
            MSGBUF = 'Spectral channels'
            IF (APARM(3).GT.0.0) THEN
               MSGBUF = 'Frequency'
               IF (PREFIX.NE.' ') MSGBUF = PREFIX // ' Frequency'
               END IF
            CALL CHTRIM (MSGBUF, 17, MSGBUF, INCHAR)
            DCX = 0.5 - INCHAR / 2.0
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            IF (APARM(10).LE.0.0) THEN
               MSGBUF = 'IFs'
               DCY = -1.5
               DCX = 0.5 - CH(1)
               IF (LTYPE.GT.2) DCY = -4.166
               CALL GPOS (PBLC(1,1), PBLC(2,1), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               INCHAR = 3
               CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               XINT = (PTRC(1,1) - PBLC(1,1)) / (EIF - BIF + 1.0)
               DO 210 J = BIF,EIF
                  IF (J.LT.10) THEN
                     WRITE (MSGBUF,1150) J
                     INCHAR = 1
                  ELSE
                     WRITE (MSGBUF,1151) J
                     INCHAR = 2
                     END IF
                  X = (J - BIF + 0.5) * XINT
                  CALL GPOS (X, PBLC(2,1), PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  DCX = -INCHAR / 2.0
                  CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
 210              CONTINUE
               END IF
            END IF
         END IF
C                                       Stokes label
      IF (XSTOK(2:2).EQ.' ') THEN
         IF (XSTOK(:1).EQ.'R') STKLAB = 'L -> R'
         IF (XSTOK(:1).EQ.'L') STKLAB = 'R -> L'
         IF (XSTOK(:1).EQ.'V') STKLAB = 'H -> V'
         IF (XSTOK(:1).EQ.'H') STKLAB = 'V -> H'
      ELSE IF (IYP.EQ.2) THEN
         IF (XSTOK(:1).EQ.'R') STKLAB = 'L -> R'
         IF (XSTOK(:1).EQ.'L') STKLAB = 'R -> L'
         IF (XSTOK(:1).EQ.'V') STKLAB = 'H -> V'
         IF (XSTOK(:1).EQ.'H') STKLAB = 'V -> H'
      ELSE
         IF (XSTOK(:1).EQ.'R') STKLAB = 'R -> L'
         IF (XSTOK(:1).EQ.'V') STKLAB = 'V -> H'
         END IF
      PROBLM = 'PLOT STOKES LABEL'
      CALL GPOS (PTRC(1,1), PTRC(2,1), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      DCX = -9.0
      DCY = -2.5
      IF (PTRC(2,1)-PBLC(2,1).GT.500.0) DCY = -3.5
      CALL GICHAR (1, 6, 0, DCX, DCY, STKLAB, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      GO TO 999
C
 950  WRITE (MSGTXT,1950) IRET, PROBLM
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F14.3)
 1150 FORMAT (I1)
 1151 FORMAT (I2)
 1950 FORMAT ('PDPLAB ERROR',I4,' ON ',A)
      END
      SUBROUTINE FRQLAB (ICODE, IYP, PBLC, PTRC, PREFIX, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   PDPLAB labels the axes
C   Inputs:
C      IYP      I        Pane number - label X axis only on 1
C      PBLC     R(2,2)   BLC of 1 or portions of panel
C      PTRC     R(2,2)   TRC of 1 or portions of panel
C   In/out:
C      PLBUFF   I(256)   plot buffer
C   Output:
C      IRET     I        error code: -1 do channel plot
C-----------------------------------------------------------------------
      INTEGER   ICODE, IYP, PLBUFF(*), IRET
      REAL      PBLC(2,2), PTRC(2,2)
      CHARACTER PREFIX*5
C
      INCLUDE 'PDPLT.INC'
      INTEGER   INOINT, INCHAR, I, IXO
      REAL      XMIN, XMAX, XINTER(24), DIST, XINT, XVAL, XPOS, Y, DCX,
     *   DCY, TICLEN, TICSCL, X0, FSCALE, DEG, DU, DL
      CHARACTER MSGBUF*80
      LOGICAL   NOTOK
      DOUBLE PRECISION FMIN, FMAX
      INCLUDE 'INCS:DCHND.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA TICSCL /80.0/
      DATA XINTER /.001, .002, .005, .01, .02, .05, .1, .2, .5,
     *   1., 2., 5., 10., 20., 50., 100., 200., 500.,
     *   1000., 2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
      XMIN = (BIF - 1) * NCHAN
      XMAX = (EIF - BIF + 1) * NCHAN + XMIN + 1
      IRET = -1
      XINT = 16
      XINT = MAX(3.0, MIN (16.0, XINT))
      DIST = (FRMAX + FRMIN) / 2.0D0
      X0 = DIST
      CALL METSCA (DIST, PREFIX, NOTOK)
      IF (NOTOK) THEN
         MSGTXT = 'CANNOT FIND METRIC PREFIX'
         GO TO 990
         END IF
      FSCALE = DIST / X0
      FMIN = FRMIN * FSCALE
      FMAX = FRMAX * FSCALE
      DO 40 I = 1,24
         DEG = XINTER(I)
         DU = AINT (FMAX/DEG) * DEG
         IF (DU.GT.FMAX) DU = DU - DEG
         DL = AINT (FMIN/DEG) * DEG
         IF (DL.LT.FMIN) DL = DL + DEG
         INOINT = (DU-DL) / DEG + 1.01
         IF (INOINT.LE.XINT) GO TO 50
 40      CONTINUE
      MSGTXT = 'CANNOT FIND X AXIS INCREMENT'
      GO TO 990
 50   XINT = DEG
      INOINT = INOINT + 2
      XVAL = AINT (FMIN/XINT) * XINT
      IF (XVAL.GE.FMIN) XVAL = XVAL - XINT
      IXO = I
      DCY = -1.5
      TICLEN = (PTRC(2,1) - PBLC(2,1)) / 25.0
      DO 70 I = 1,INOINT
         XVAL = XVAL + XINT
         IF (XVAL.GT.FMAX) GO TO 100
         XPOS = (XVAL - FMIN)/ (FMAX-FMIN) * (PTRC(1,1) - PBLC(1,1))
     *      + PBLC(1,1)
         CALL GPOS (XPOS, PBLC(2,1), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         Y = PBLC(2,1) + TICLEN
         CALL GVEC (XPOS, Y, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         Y = PTRC(2,1) - TICLEN
         CALL GPOS (XPOS, Y, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (XPOS, PTRC(2,1), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         IF (ICODE.EQ.3) THEN
            CALL GPOS (XPOS, PBLC(2,2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = PBLC(2,2) + TICLEN
            CALL GVEC (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = PTRC(2,2) - TICLEN
            CALL GPOS (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            CALL GVEC (XPOS, PTRC(2,2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            END IF
         IF ((IYP.EQ.1) .AND. (LTYPE.GT.2)) THEN
            CALL GPOS (XPOS, PBLC(2,1), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            WRITE (MSGBUF,1030) XVAL
            CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
            IF (IXO.GT.3) INCHAR = INCHAR - 1
            IF (IXO.GT.6) INCHAR = INCHAR - 1
            IF (IXO.GT.9) INCHAR = INCHAR - 2
            DCX = 0.5 - INCHAR
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            END IF
 70      CONTINUE
 100  GO TO 999
C
 950  WRITE (MSGTXT,1950) IRET
 990  CALL  MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F14.3)
 1950 FORMAT ('FRQLAB ERROR',I4)
      END
