LOCAL INCLUDE 'PCLOSE.INC'
C                                       Parameter include for CLOSE
      INTEGER   MAXTRP
C                                       MAXTRP = max. no. triples
      PARAMETER (MAXTRP=100000)
LOCAL END
LOCAL INCLUDE 'CLOSE.INC'
C                                       Local include for CLOSE
      INCLUDE 'PCLOSE.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:ZPBUFSZ.INC'
      INCLUDE 'INCS:DMSG.INC'
      HOLLERITH XNAMEI(3), XCLAIN(2), XXSTOK(1), XXSOUR(4), XXCALC(1),
     *   XOPTYP(1), XOPCOD(1), XOUTXT(12)
      CHARACTER NAMEIN*12, CLAIN*6, XSTOK*4, OPTYPE*4, OPCODE*4,
     *   XSOUR*16, XCALCO*4, OUTEXT*48, TITL1*132, TITL2*132
      REAL      XSIN, XDISIN, XQUAL, XBAND, XFREQ, XFQID, XBCHAN,
     *   XECHAN, XBIF, XEIF, UVRANG(2), XTIME(8), XANT(50), XDOCAL,
     *   XGUSE, XDOPOL, XPDVER, XBLVER, XFLAG, XDOBND, XBPVER,
     *   XSMOTH(3), XSUBA, XSOLIN, XPIXR(2), XSYM, FACTOR, XLABEL,
     *   XDOTV, XGRCH, XYRATO, DOCRT, BADD(10)
      REAL      BUFF1(UVBFSS), CHOUT(4)
      INTEGER   JBUFSZ, NANT, NSRC, OLDCNO, LUNP, FINDP, IPCNT, PAGE,
     *   NACROS, CATKEP(256), OBUFF(1024)
      LOGICAL   DOTV, MULTI, DOLINE
      REAL      TBEG, TFIN, XYSCL(2), XYOFF(2), SPECTR(2,16384), REFPIX,
     *   SPECAV(2,16384)
      DOUBLE PRECISION REFVAL
      INTEGER   IAW1, IAW2, SEQIN, DISKIN, LUNI, INDI, LABEL, NPARMS,
     *   LTYPE, ANTS(50), ISUB, GRCHN, TVCHN, TVCORN(4), CPTQ(4*MAXTRP),
     *   NUMTQ, ISYM, NSTOK
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XXSOUR, XQUAL,
     *   XXCALC, XBAND, XFREQ, XFQID, XBCHAN, XECHAN, XBIF, XEIF,
     *   UVRANG, XTIME, XANT, XXSTOK, XDOCAL, XGUSE, XDOPOL, XPDVER,
     *   XBLVER, XFLAG, XDOBND, XBPVER, XSMOTH, XSUBA, XSOLIN, XOPTYP,
     *   XOPCOD, XPIXR, XSYM, FACTOR, XLABEL, XDOTV, XGRCH, XYRATO,
     *   DOCRT, XOUTXT, BADD
      COMMON /BUFRS/ BUFF1, OBUFF, JBUFSZ
      COMMON /VBPCOM/ CATKEP, REFVAL, REFPIX, TBEG, TFIN, XYSCL, XYOFF,
     *   NANT, IAW1, IAW2, SEQIN, DISKIN, LUNI, INDI, ANTS, ISUB, LABEL,
     *   CHOUT, LTYPE, GRCHN, TVCHN, TVCORN, NSRC, OLDCNO, DOTV, MULTI,
     *   LUNP, FINDP, IPCNT, PAGE, NACROS, NUMTQ, CPTQ, SPECTR, SPECAV,
     *   NPARMS, DOLINE, ISYM, NSTOK
C
      COMMON /CHRCOM/ NAMEIN, CLAIN, XSTOK, XSOUR, XCALCO, OPCODE,
     *   OPTYPE, OUTEXT, TITL1, TITL2
LOCAL END
LOCAL INCLUDE 'CLAVER.INC'
      LOGICAL   GOTDAT
      INTEGER   CNTTIM, IVSCNT, VISINC, VISMSG
      REAL      SUMTIM, TLAST, DTUTC
      COMMON /CLAVG/ TLAST, DTUTC, IVSCNT, GOTDAT, CNTTIM, SUMTIM,
     *   VISINC, VISMSG
LOCAL END
      PROGRAM CLOSE
C-----------------------------------------------------------------------
C! Plots selected uv data closure phase/amplitude spectra
C# UV Plot-appl VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2022-2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   CLOSE plots uv data . A 'PL' extension file is made which can
C   be displayed in the usual ways .
C   Inputs:
C     USERID                       UV data file owner # ignored
C     INNAME         NAMEIN        Name of input UV data.
C     INCLASS        CLAIN         Class of input UV data.
C     INSEQ          SEQIN         Seq. of input UV data.
C     INDISK         DISKIN        Disk number of input UV data.

C     BCHAN          BCHAN         Start channel for averaging
C     ECHAN          ECHAN         End channel for averaging
C     BIF            BIF           Start IF number for averaging
C     EIF            EIF           End IF number for averaging
C     XINC.......Skip this number of vis. records between plotting.
C     UVRANGE....Range of UV projected spacings to include (Klambda)
C     TIMERANG...Selection parameters:
C        1 = Start IAT day (day 0 = first day in data base)
C        2 = Start IAT hour
C        3 = Start IAT minute
C        4 = Start IAT second
C        5 = Stop IAT day (day 0 = first day in data base)
C        6 = Stop IAT hour
C        7 = Stop IAT minute
C        8 = Stop IAT second
C     STOKES....Stokes' type
C     ANTENNAS..Antenna numbers
C      DOTV     R      > 0 => TV, else plot file
C      GRCHAN   R      graphics channel to use
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'CLOSE.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA PRGM /'CLOSE '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL CLOSEI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 995
C                                       Get the data
      CALL CLOSEG (IRET)
      IF (IRET.GT.0) GO TO 995
C
      CALL PLOTCL (IRET)
      IRET = MAX (0, IRET)
C                                       Close down
 995  CALL DIE (IRET, OBUFF)
C
 999  STOP
      END
      SUBROUTINE CLOSEI (PRGM, IRET)
C-----------------------------------------------------------------------
C   CLOSEI gets input parameters for CLOSE .
C   Inputs:
C      PRGM   C*6       Program name
C   Output:
C      JERR   I         Error code: 0 => ok, else quit
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
C
      INCLUDE 'CLOSE.INC'
      CHARACTER UTYPE*2, STAT*4, ALSTOK(12)*4
      INTEGER   IERR, IUSER, I, K, L, J, MXANT, MXTRI, IROUND,
     *   LUN, NUMOUT, OUTANS(MAXANT), INCANT(MAXANT)
      REAL      CATR(256), EPS
      LOGICAL   MATCH
      DOUBLE PRECISION CATD(128)
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSOU.INC'
      EQUIVALENCE (CATD, CATR, CATBLK)
      DATA MXANT /MAXANT/
      DATA MXTRI /MAXTRP/
      DATA ALSTOK /'I','Q','U','V','RR','LL','RL','LR','VV','HH','VH',
     *   'HV'/
C-----------------------------------------------------------------------
C                                       Init IO et al.
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      JBUFSZ = UVBFSS * 2
      CALL SELINI
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      IRET = 0
      LUNP = 0
      FINDP = 0
C                                       Get input parameters.
      NPARMS = 127
      CALL GTPARM (PRGM, NPARMS, RQUICK, XNAMEI, OBUFF, IERR)
      XSUBA = MAX (XSUBA, 1.0)
      IF (DOCRT.GT.0.0) RQUICK = .FALSE.
      IF (IERR.NE.0) THEN
         IRET = 8
         RQUICK = .TRUE.
         IF (IERR.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
         CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, OBUFF, IERR)
      IF (IRET.NE.0) GO TO 999
      IRET = 5
C                                       Crunch input parameters.
      EPS = 0.1
      IUSER = NLUSER
      SEQIN = XSIN + EPS
      DISKIN = XDISIN + EPS
      ISUB = IROUND (XSUBA)
      IF (ISUB.NE.-1) ISUB = MAX (1, ISUB)
      ISUB = MAX (0, ISUB)
      SUBARR = ISUB
      DO 5 I = 1,10
         IBAD(I) = IROUND(BADD(I))
 5       CONTINUE
C                                       Check SOLINT
      IF (XSOLIN.EQ.0.0) THEN
         XSOLIN = 5.0
         WRITE (MSGTXT,1020)
         CALL MSGWRT (3)
         END IF
C                                       Characters
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (4, 1, XXSTOK, XSTOK)
      CALL H2CHR (4, 1, XXCALC, XCALCO)
      CALL H2CHR (4, 1, XOPTYP, OPTYPE)
      CALL H2CHR (4, 1, XOPCOD, OPCODE)
      CALL H2CHR (48, 1, XOUTXT, OUTEXT)
      NSTOK = 1
      IF ((XSTOK.EQ.'HALF') .OR. (XSTOK.EQ.'RRLL') .OR.
     *   (XSTOK.EQ.'HHVV')) THEN
         NSTOK = 2
         GO TO 15
         END IF
      DO 10 I = 1,12
         IF (XSTOK.EQ.ALSTOK(I)) GO TO 15
 10      CONTINUE
      NSTOK = 2
      XSTOK = 'HALF'
      MSGTXT = 'STOKES SET TO HALF'
      CALL MSGWRT (6)
 15   STOKES = XSTOK
      CALL CHR2H (4, XSTOK, 1, XXSTOK)
      IF (OPCODE.NE.'INDE') OPCODE = 'CLOS'
      IF (OPTYPE.NE.'AMP ') OPTYPE = 'PHAS'
      CALL CHR2H (4, OPCODE, 1, XOPCOD)
      CALL CHR2H (4, OPTYPE, 1, XOPTYP)
      IF (UVRANG(2).LE.UVRANG(1)) UVRANG(2) = 1.0E10
      UVRANG(1) = UVRANG(1) * 1.0E3
      UVRANG(2) = UVRANG(2) * 1.0E3
      ISYM = IROUND (XSYM)
      IF ((ISYM.LT.1) .OR. (ISYM.GT.24)) ISYM = 2
      XSYM = ISYM
      DOLINE = FACTOR.LT.0.0
      IF ((FACTOR.GE.-0.2) .AND. (FACTOR.LT.0.0)) ISYM = -1
      FACTOR = ABS (FACTOR)
      IF (FACTOR.EQ.0.0) FACTOR = 1.0
C                                       Tv and label parms
      DOTV = XDOTV.GT.0.0
      GRCHN = XGRCH + 0.01
      TVCHN = 1
      CALL FILL (4, 0, TVCORN)
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS(LABEL), 100)
      IF ((LTYPE.EQ.0) .OR. (LTYPE.GT.10)) LTYPE = 3
      IF (LTYPE.GT.7) LTYPE = 7
      IF ((LTYPE.GE.4) .AND. (LTYPE.LE.6)) LTYPE = 3
      IF (LABEL.LT.0) THEN
         LABEL = (LABEL/100)*100 - LTYPE
      ELSE
         LABEL = (LABEL/100)*100 + LTYPE
         END IF
      XLABEL = LABEL
C                                       Get CATBLK from file.
      LUNI = 16
      UTYPE = 'UV'
      OLDCNO = 1
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN, UTYPE,
     *   IUSER, STAT, OBUFF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1030) IRET, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      IUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'REST', OBUFF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'COPYING CATBLK'
         GO TO 990
         END IF
      XSIN = SEQIN
      XDISIN = DISKIN
      CALL CHR2H (12, NAMEIN, 1, XNAMEI)
      CALL CHR2H (6, CLAIN, 1, XCLAIN)
C                                       Get uv header info.
      CALL UVPGET (IRET)
      IF (IRET.NE.0) GO TO 999
      CALL COPY (256, CATBLK, CATKEP)
      REFVAL = CATD(KDCRV+JLOCF)
      REFPIX = CATR(KRCRP+JLOCF)
C                                       Put selection criteria into
C                                       correct common.
      UNAME = NAMEIN
      UCLAS = CLAIN
      UDISK = DISKIN
      USEQ = SEQIN
      IUDISK = UDISK
      IUCNO = OLDCNO
      NSRC = 0
      CALL H2CHR (16, 1, XXSOUR, SOURCS(1))
      IF (SOURCS(1)(1:4).NE.'    ') NSRC = NSRC + 1
      SELQUA = IROUND (XQUAL)
      SELCOD = XCALCO
      CALL RCOPY (8, XTIME, TIMRNG)
      CALL RCOPY (2, UVRANG, UVRNG)
      DOCAL = XDOCAL.GT.0.0
      DOWTCL = DOCAL .AND. (XDOCAL.LE.99.0)
      DOPOL = IROUND (XDOPOL)
      IF (XDOPOL.GT.0.0) DOPOL = MAX (1, DOPOL)
      PDVER = IROUND (XPDVER)
      BLVER = IROUND (XBLVER)
      FGVER = IROUND (XFLAG)
      CLVER = IROUND (XGUSE)
      CLUSE = IROUND (XGUSE)
      BPVER = IROUND (XBPVER)
      DOBAND = IROUND (XDOBND)
C                                       Spectral smoothing
      CALL RCOPY (3, XSMOTH, SMOOTH)
C                                       Multi-source
      CALL MULSDB (CATBLK, MULTI)
C                                       Freq id
      IF (XBAND.GT.0.0) SELBAN = XBAND
      IF (XFREQ.GT.0.0) SELFRQ = XFREQ
      FRQSEL = IROUND (XFQID)
      IF (FRQSEL.EQ.0) FRQSEL = -1
      LUN = 28
      CALL FQMATC (DISKIN, OLDCNO, CATBLK, LUN, SELBAN, SELFRQ,
     *   MATCH, FRQSEL, IRET)
      IF (.NOT.MATCH) THEN
         WRITE (MSGTXT,1070)
         IRET = 1
         CALL MSGWRT (6)
         END IF
      IF (IRET.GT.0) GO TO 999
C                                       Test channel #
      BCHAN = IROUND (XBCHAN)
      BCHAN = MAX (1, MIN (BCHAN, CATBLK(KINAX+JLOCF)))
      ECHAN = IROUND (XECHAN)
      IF (ECHAN.LT.BCHAN) ECHAN = CATBLK(KINAX+JLOCF)
      ECHAN = MAX (1, MIN (ECHAN, CATBLK(KINAX+JLOCF)))
      XBCHAN = BCHAN
      XECHAN = ECHAN
C                                       IF number
      IF (JLOCIF.GE.0) THEN
         BIF = IROUND (XBIF)
         BIF = MAX (1, MIN (BIF, CATBLK(KINAX+JLOCIF)))
         EIF = IROUND (XEIF)
         IF (EIF.LT.BIF) EIF = CATBLK(KINAX+JLOCIF)
         EIF = MAX (1, MIN (EIF, CATBLK(KINAX+JLOCIF)))
      ELSE
         BIF = 1
         EIF = 1
         END IF
      XBIF = BIF
      XEIF = EIF
      I = (EIF - BIF + 1) * (ECHAN - BCHAN + 1)
      IF (I.GT.16384) THEN
         IRET = 8
         MSGTXT = 'I CANNOT PLOT MORE THAN 16384 CHANNELS'
         GO TO 990
         END IF
C                                       Get antenna info.
      CALL CLOSAN (DISKIN, OLDCNO, SUBARR, CATBLK, NANT, NUMOUT, OUTANS,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING MAX ANTENNA NUMBER'
         GO TO 990
         END IF
C                                       omit or include
      L = 0
      K = 0
      DO 30 I = 1,50
         J = IROUND (XANT(I))
         IF (J.GT.0) K = K + 1
         IF (J.LT.0) L = L + 1
 30      CONTINUE
      IF ((K.EQ.0) .AND. (L.EQ.0)) THEN
         CALL FILL (MAXANT, 1, INCANT)
      ELSE IF (L.EQ.0) THEN
         CALL FILL (MAXANT, 0, INCANT)
         DO 35 I = 1,50
            J = IROUND (XANT(I))
            IF (J.GT.0) INCANT(J) = 1
 35         CONTINUE
      ELSE
         CALL FILL (MAXANT, 1, INCANT)
         DO 40 I = 1,50
            J = IROUND (XANT(I))
            J = ABS (J)
            IF (J.GT.0) INCANT(J) = 0
 40         CONTINUE
         END IF
      DO 45 I = 1,NUMOUT
         INCANT(OUTANS(I)) = 0
 45      CONTINUE
C                                       set the triangles/quadrangles
      IF (OPTYPE.EQ.'PHAS') THEN
         CALL SETTRP (OPCODE, NANT, INCANT, NUMTQ, CPTQ, IRET)
         WRITE (MSGTXT,1045) NUMTQ, 'triangles'
      ELSE
         CALL SETQAD (OPCODE, NANT, INCANT, NUMTQ, CPTQ, IRET)
         WRITE (MSGTXT,1045) NUMTQ, 'quadrangles'
         END IF
      IF (IRET.NE.0) THEN
         MSGTXT = 'ERROR SETTING TRIANGLES/QUADRANGLES'
      ELSE
         CALL MSGWRT (3)
         WRITE (MSGTXT,1046) NANT, NUMOUT
         CALL MSGWRT (3)
         GO TO 999
         END IF
C
 990  CALL MSGWRT (6)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CLOSEI: ERROR',I3,' ON ',A)
 1020 FORMAT ('CLOSEI: SOLINT was 0, resetting to 5 minutes')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1070 FORMAT ('NO MATCH TO SELBAND/SELFREQ ADVERBS - CHECK INPUTS')
 1045 FORMAT ('Using',I6,1X,A)
 1046 FORMAT ('Using max antenna #',I4,' with',I2,' known to be out')
      END
      SUBROUTINE CLOSAN (IUDISK, IUCNO, IUVER, CATBLK, MAXA, NUMOUT,
     *   OUTANS, IERR)
C-----------------------------------------------------------------------
C   finds the max antenna number in an antenna file - this may easily
C   not be the same as the number of records.  Also finds any antennas
C   listed as OUT
C   Inputs:
C      IUDISK   I        Disk number
C      IUCNO    I        Catalog number
C      IUVER    I        AN version number = subarray number
C      CATBLK   I(256)   Catalog block
C   Output:
C      MAXA     I        Max antenna number
C      NUMOUT   I        Number of OUT antennas
C      OUTANS   I(*)     Antenna numbers of OUT antennas
C      IERR     I        Error code
C   Output in Common: DANT.INC after ANTINI and several TABAN calls
C-----------------------------------------------------------------------
      INTEGER   IUDISK, IUCNO, IUVER, CATBLK(256), MAXA, NUMOUT,
     *   OUTANS(*),  IERR
C
      INTEGER   NUMSUB, IA, ANBUFF(512), ILUN, NANT
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DANT.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA ILUN /110/
C-----------------------------------------------------------------------
C                                       is there a question
      MAXA = 0
      NUMOUT = 0
      IERR = 0
      CALL FNDEXT ('AN', CATBLK, NUMSUB)
      IF ((NUMSUB.GE.IUVER) .AND. (IUVER.GE.1)) THEN
         IA = 0
         CALL ANTINI ('READ', ANBUFF, IUDISK, IUCNO, IUVER, CATBLK,
     *      ILUN, IANRNO, ANKOLS, ANNUMV, ARRAYC, GSTIA0, DEGPDY,
     *      SAFREQ, RDATE, POLRXY, UT1UTC, DATUTC, TIMSYS, ANAME,
     *      XYZHAN, TFRAME, NUMORB, NOPCAL, ANTNIF, ANFQID, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'INIT', IUVER
            GO TO 980
            END IF
         NANT = ANBUFF(5)
         DO 90 IA = 1,NANT
            CALL TABAN ('READ', ANBUFF, IANRNO, ANKOLS, ANNUMV, ANNAME,
     *         STAXYZ, ORBPRM, NOSTA, MNTSTA, STAXOF, DIAMAN, FWHMAN,
     *         POLTYA, POLAA,POLCA, POLTYB, POLAB, POLCB, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READ', IUVER
               GO TO 970
               END IF
            IF (ANNAME.EQ.'OUT') THEN
               NUMOUT = NUMOUT + 1
               OUTANS(NUMOUT) = NOSTA
            ELSE IF ((STAXYZ(1).EQ.0.0D0) .AND. (STAXYZ(2).EQ.0.0D0)
     *         .AND. (STAXYZ(3).EQ.0.0D0)) THEN
               NUMOUT = NUMOUT + 1
               OUTANS(NUMOUT) = NOSTA
            ELSE
               MAXA = MAX (MAXA, NOSTA)
               END IF
 90         CONTINUE
         CALL TABIO ('CLOS', 0, IANRNO, ANBUFF, ANBUFF, IERR)
         END IF
      GO TO 999
C
 970  CALL MSGWRT (6)
      CALL TABIO ('CLOS', 0, IANRNO, ANBUFF, ANBUFF, IA)
      GO TO 999
C
 980  CALL MSGWRT (6)
      GO TO 999
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CLOSEA: ERROR',I5,1X,A,'ING AN TABLE',I4)
      END
      SUBROUTINE SETTRP (OPCODE, NANT, INCANT, NUMTRP, CPTRIP, IRET)
C-----------------------------------------------------------------------
C   Sets the list of triples
C   Input:
C      OPCODE   C*4      'INDE' or 'CLOS'
C      NANT     I        Max antenna number
C      INCANT   I(*)     1 -> include antenna, 0 -> omit
C   Output:
C      NUMTRP   I        Number of triangles set
C      CPTRIP   I(3,*)   The triangles
C      IRET     I        Error occurred if > 0
C-----------------------------------------------------------------------
      CHARACTER OPCODE*4
      INTEGER   NANT, INCANT(*), NUMTRP, CPTRIP(3,*), IRET
C
      INTEGER   I, J, K, A1
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       unique
      NUMTRP = 0
      IRET = 0
      IF (OPCODE.EQ.'INDE') THEN
         DO 20 J = 3,NANT
            A1 = 1
            DO 10 I = 1,NANT
               IF ((A1.LT.J-1) .AND. (INCANT(A1).EQ.1) .AND.
     *            (INCANT(A1+1).EQ.1) .AND. (INCANT(J).EQ.1)) THEN
                  NUMTRP = NUMTRP + 1
                  CPTRIP(1,NUMTRP) = A1
                  CPTRIP(2,NUMTRP) = A1 + 1
                  CPTRIP(3,NUMTRP) = J
                  END IF
               A1 = A1 + 1
 10            CONTINUE
 20         CONTINUE
C                                       all
      ELSE
         DO 50 I = 1,NANT-2
            IF (INCANT(I).EQ.0) GO TO 50
            DO 40 J = 2,NANT-1
               IF ((I.EQ.J) .OR. (INCANT(J).EQ.0)) GO TO 40
               DO 30 K = 1,NANT
                  IF (INCANT(K).EQ.0) GO TO 30
                  IF ((K.EQ.I) .OR. (K.EQ.J)) GO TO 30
                  IF ((I.GT.J) .OR. (I.GT.K) .OR. (J.GT.K)) GO TO 30
                  NUMTRP = NUMTRP + 1
                  CPTRIP(1,NUMTRP) = I
                  CPTRIP(2,NUMTRP) = J
                  CPTRIP(3,NUMTRP) = K
 30               CONTINUE
 40            CONTINUE
 50         CONTINUE
         END IF
C                                       did we get anything
      IF (NUMTRP.LE.0) THEN
         MSGTXT = 'SETTRP DID NOT FIND ANY ALLOWED TRIPLES'
         CALL MSGWRT (8)
         IRET = 1
         END IF
C
 999  RETURN
      END
      SUBROUTINE SETQAD (OPCODE, NANT, INCANT, NUMQAD, CPQUAD, IRET)
C-----------------------------------------------------------------------
C   Determines the quadrangles to be used
C   Input:
C      OPCODE   C*4      'INDE' or 'CLOS'
C      NANT     I        Max antenna number
C      INCANT   I(*)     1 -> include antenna, 0 -> omit
C   Output:
C      NUMQAD   I        Number of triangles set
C      CPQUAD   I(3,*)   The triangles
C      IRET     I        Error occurred if > 0
C-----------------------------------------------------------------------
      CHARACTER OPCODE*4
      INTEGER   NANT, INCANT(*), NUMQAD, CPQUAD(4,*), IRET
C
      INTEGER   I, J, K, L
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      NUMQAD = 0
      IRET = 0
C                                       independent
      IF (OPCODE.EQ.'INDE') THEN
         DO 20 J = 3,NANT
            K = 1
            DO 10 I = 1,NANT
               IF ((K.LT.J-2) .AND. (INCANT(K).EQ.1) .AND.
     *            (INCANT(K+1).EQ.1) .AND. (INCANT(K+2).EQ.1) .AND.
     *            (INCANT(J).EQ.1))  THEN
                  NUMQAD = NUMQAD + 1
                  CPQUAD(1,NUMQAD) = K
                  CPQUAD(2,NUMQAD) = K + 1
                  CPQUAD(3,NUMQAD) = K + 2
                  CPQUAD(4,NUMQAD) = J
                  END IF
               K = K + 1
 10            CONTINUE
 20         CONTINUE
      ELSE
         DO 80 I = 1,NANT
            IF (INCANT(I).EQ.0) GO TO 80
            DO 70 J = 1,NANT
               IF (INCANT(J).EQ.0) GO TO 70
               DO 60 K = 1,NANT
                  IF (INCANT(K).EQ.0) GO TO 60
                  DO 50 L = 1,NANT
                     IF ((I.LT.J) .AND. (J.LT.K) .AND. (K.LT.L) .AND.
     *                  (INCANT(L).EQ.1)) THEN
                        NUMQAD = NUMQAD + 1
                        CPQUAD(1,NUMQAD) = I
                        CPQUAD(2,NUMQAD) = J
                        CPQUAD(3,NUMQAD) = K
                        CPQUAD(4,NUMQAD) = L
                        END IF
 50                  CONTINUE
 60               CONTINUE
 70            CONTINUE
 80         CONTINUE
         END IF
C                                       get any?
      IF (NUMQAD.LE.0) THEN
         MSGTXT = 'SETQAD DID NOT FIND ANY QUADRANGLES'
         CALL MSGWRT (8)
         IRET = 1
         END IF
C
 999  RETURN
      END
      SUBROUTINE CLOSEG (IRET)
C-----------------------------------------------------------------------
C   CLOSEG allocates dynamic memory and calls either a phase or an
C   amplitude routine to get the closure spectrum.
C   Output:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'CLOSE.INC'
      INTEGER   COUNT(2), COUNT1(2), COUNTA(2)
      REAL      ROUNT(2), ROUNT1(2), WORK(2), WORKC(2), GAMP(2),
     *   GERR(2), SCANV(2), CLERR(2), ROUNTA(2)
      LONGINT   POUNT, POUNT1, PWORK, PWORKC, PGAMP, PGERR, PSCANV,
     *   PCLERR, PCOUNA
      INTEGER   NCH, NWORDS, IT
      EQUIVALENCE (COUNT, ROUNT), (COUNT1, ROUNT1), (COUNTA, ROUNTA)
      INCLUDE 'INCS:DSEL.INC'
C-----------------------------------------------------------------------
      NCH = (ECHAN-BCHAN+1) * (EIF-BIF+1)
      IT = 3
      IF (OPTYPE.EQ.'AMP ') IT = 4
      NWORDS = IT * NCH * NSTOK * NUMTQ
      NWORDS = (NWORDS-1) / 1024 + 1
      CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, ROUNT, POUNT, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, ROUNT1,
     *   POUNT1, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, GAMP,
     *   PGAMP, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, GERR,
     *   PGERR, IRET)
      NWORDS = 2 * IT * NCH * NSTOK * NUMTQ
      NWORDS = (NWORDS-1) / 1024 + 1
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, WORK,
     *   PWORK, IRET)
      NWORDS = 2 * NCH * NSTOK * NUMTQ
      NWORDS = (NWORDS-1) / 1024 + 1
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, WORKC,
     *   PWORKC, IRET)
      NWORDS = NCH * NSTOK * NUMTQ
      NWORDS = (NWORDS-1) / 1024 + 1
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, SCANV,
     *   PSCANV, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, CLERR,
     *   PCLERR, IRET)
      IF (IRET.EQ.0) CALL ZMEMRY ('GET ', 'CLOSE', NWORDS, ROUNTA,
     *   PCOUNA, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING DYNAMIC MEMORY'
         GO TO 990
         END IF
C                                       triangles
      IF (OPTYPE.EQ.'PHAS') THEN
         CALL CLOSEP (CPTQ, NSTOK, NCH, COUNT(1+POUNT),
     *      COUNT1(1+POUNT1), WORK(1+PWORK), WORKC(1+PWORKC),
     *      GAMP(1+PGAMP),GERR(1+PGERR), SCANV(1+PSCANV),
     *      CLERR(1+PCLERR), IRET)
      ELSE
         CALL CLOSEA (CPTQ, NSTOK, NCH, COUNT(1+POUNT),
     *      COUNT1(1+POUNT1), WORK(1+PWORK), WORKC(1+PWORKC),
     *      GAMP(1+PGAMP), GERR(1+PGERR), SCANV(1+PSCANV),
     *      CLERR(1+PCLERR), COUNTA(1+PCOUNA), IRET)
         END IF
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'GETTING CLOSURE SPECTRUM'
         GO TO 990
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CLOSEG: ERROR',I4,' ON ',A)
      END
      SUBROUTINE CLOSEP (CPTRIP, NST, NCH, COUNT, COUNT1, WORK, WORKC,
     *   GAMP, GERR, SCANV, CLERR, IRET)
C-----------------------------------------------------------------------
C   CLOSEP gets the phase closure spectrum
C   Inputs:
C      NST      I        Number stokes
C      NCH      I        Number spectral channels
C      CPTRIP   I(3,*)   Triangles
C   Work buffers:
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C      SCANV    R(*)
C      CLERR    R(*)
C   Output:
C      IRET              Error code
C-----------------------------------------------------------------------
      INTEGER   CPTRIP(3,*), NST, NCH, COUNT(3,NST,NCH,*),
     *   COUNT1(3,NST,NCH,*), IRET
      REAL      WORK(2,3,NST,NCH,*), WORKC(2,NST,NCH,*),
     *   GAMP(3,NST, NCH,*), GERR(3,NST,NCH,*), SCANV(NST,NCH,*),
     *   CLERR(NST,NCH,*)
C
      INCLUDE 'CLOSE.INC'
      INCLUDE 'CLAVER.INC'
      INTEGER   I, J, K, NUMVIS, IC, SCANUM
      LOGICAL   NUSCAN, FIRST
      REAL      WTSUM(2,16384), DT, RPARM(20), POFF, WT
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
C-----------------------------------------------------------------------
C                                       zero spectrum
      CALL RFILL (2*NCH, 0.0, SPECTR)
      CALL RFILL (2*NCH, 0.0, SPECAV)
      CALL RFILL (2*NCH, 0.0, WTSUM)
C                                       Init the IO
      CALL UVGET ('INIT', RPARM, BUFF1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT READING DATA SET'
         GO TO 990
         END IF
      DT = XSOLIN / 1440.0
      NUMVIS = 0
      FIRST = .TRUE.
      WT = 300.0 / NUMTQ
      VISINC = CATBLK(KIGCN) / 10
      VISMSG = CATBLK(KIGCN) / 5
      VISINC = MAX (40000, MIN (200000,VISINC))
      VISINC = VISINC * WT
      VISINC = ((VISINC+500)/1000) * 1000
      VISINC = MAX (10000, MIN (100000,VISINC))
      VISMSG = WT * VISMSG
      VISMSG = (VISMSG / VISINC) * VISINC
      IF (VISMSG.LT.VISINC) VISMSG = 100 * VISINC
 20   CONTINUE
         CALL CLOSPV (NUMVIS, NST, NCH, NUMTQ, CPTRIP, DT, SCANV, CLERR,
     *      NUSCAN, SCANUM, RPARM, BUFF1, COUNT, COUNT1, WORK, WORKC,
     *      GAMP,GERR, IRET)
         IF (IRET.EQ.-2) GO TO 20
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING THE DATA'
            GO TO 990
            END IF
         IF (FIRST) THEN
            FIRST = .FALSE.
            POFF = 0.0
            IC = 0
            DO 30 J = 1,NUMTQ
               DO 25 I = 1,NCH
                  DO 24 K = 1,NST
                     IF (SCANV(K,I,J).NE.FBLANK) THEN
                        POFF = POFF + CLERR(K,I,J)**2
                        IC = IC + 1
                        END IF
 24                  CONTINUE
 25               CONTINUE
 30            CONTINUE
            IF (IC.GT.0) THEN
               POFF = POFF / IC
            ELSE
               POFF = 10.
               END IF
            FIRST = .FALSE.
            END IF
         DO 50 J = 1,NUMTQ
            DO 40 I = 1,NCH
               DO 35 K = 1,NST
                  IF (SCANV(K,I,J).NE.FBLANK) THEN
                     WT = 1.0 / (CLERR(K,I,J)**2 + POFF)
                     SPECAV(K,I) = SPECAV(K,I) + WT * SCANV(K,I,J)
                     SPECTR(K,I) = SPECTR(K,I) + WT * (SCANV(K,I,J)**2)
                     WTSUM(K,I) = WTSUM(K,I) + WT
                     END IF
 35               CONTINUE
 40            CONTINUE
 50         CONTINUE
         IF (IRET.EQ.0) GO TO 20
C                                       close, average
      CALL UVGET ('CLOS', RPARM, BUFF1, IRET)
      J = 0
      DO 60 I = 1,NCH
         DO 55 K = 1,NST
            IF (WTSUM(K,I).GT.0.0) THEN
               SPECAV(K,I) = SPECAV(K,I) / WTSUM(K,I)
               SPECTR(K,I) = SPECTR(K,I)/WTSUM(K,I) - SPECAV(K,I)**2
               IF (SPECTR(K,I).GT.0) THEN
                  SPECTR(K,I) = SQRT (SPECTR(K,I))
               ELSE
                  SPECTR(K,I) = FBLANK
                  END IF
               J = J + 1
            ELSE
               SPECAV(K,I) = FBLANK
               SPECTR(K,I) = FBLANK
               END IF
 55         CONTINUE
 60      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CLOSEP ERROR',I4,' ON ',A)
      END
      SUBROUTINE CLOSPV (NUMVIS, NST, NCH, NUMTRP, CPTRIP, DT, SCANV,
     *   CLERR, NUSCAN, SCANUM, RPARM, VIS, COUNT, COUNT1, WORK, WORKC,
     *   GAMP, GERR, IRET)
C-----------------------------------------------------------------------
C   Returns an integration time's worth of phase closure values
C   Inputs:
C      NST      I        Number STOKES
C      NCH      I        Number spectral channels
C      NUMTRP   I        Number triangles
C      CPTRIP   I(3,*)   Triangles
C      DT       R        Integration time (days)
C   In/out:
C      NUMVIS   I        NUMVIS = 0 - init things, counts records read
C      RPARM    R(*)     Random parameter values
C      VIS      R(3,*)   Visibility data / weights
C   Output:
C      SCANV    R(*)     Closure phase (degrees)
C      CLERR    R(*)     Closure phase uncertainty
C   Work buffers
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C-----------------------------------------------------------------------
      INTEGER   NUMVIS, NST, NCH, NUMTRP, CPTRIP(3,*), SCANUM,
     *   COUNT(3,NST,NCH,*), COUNT1(3,NST,NCH,*), IRET
      LOGICAL   NUSCAN
      REAL      DT, RPARM(*), VIS(3,*), SCANV(NST,NCH,*),
     *   CLERR(NST,NCH,*), WORK(2,3,NST,NCH,*), WORKC(2,NST,NCH,*),
     *   GAMP(3,NST,NCH,*), GERR(3,NST,NCH,*)
C
      INTEGER   I, J, K, ICP, IDAY
      REAL      T1, CT, CP
      DOUBLE PRECISION X8
      INCLUDE 'CLAVER.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
      IF (NUMVIS.EQ.0) CALL CLAVPR ('ZERO', NUMTRP, CPTRIP, T1, DT,
     *   RPARM, VIS, NST, NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR)
C                                       Save scan number (0= no index)
      NUSCAN = SCANUM.NE.INXRNO
      SCANUM = INXRNO
C                                       Initialize time
      T1 = 1.0E10
C                                       Loop reading data
 100  CONTINUE
         CALL UVGET ('READ', RPARM, VIS, IRET)
         IF (IRET.GT.0) GO TO 999
         IF (IRET.EQ.-1) GO TO 200
         NUMVIS = NUMVIS + 1
         IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
            WRITE (MSGTXT,1100) NUMVIS
            CALL MSGWRT (2)
         ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
            WRITE (MSGTXT,1100) NUMVIS
            CALL MSGWRT (1)
            END IF
         CT = RPARM(ILOCT+1) - DTUTC
C                                       Set up first time boundary
         IF (IVSCNT.EQ.0) THEN
            IDAY = CT
            X8 = (CT - IDAY) / ABS (DT)
            TLAST = IDAY + DINT (X8) * ABS (DT) + ABS (DT)
            END IF
C                                       Check if avg. or scan done
         IF ((INXRNO.LE.SCANUM) .AND. (CT.LE.TLAST)) THEN
            CALL CLAVPR ('AVER', NUMTRP, CPTRIP, T1, DT, RPARM, VIS,
     *         NST, NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR)
            GO TO 100
            END IF
C                                       Vector averaging
 200  CP = TWOPI
      DO 210 J = 1,NUMTRP
         DO 205 I = 1,NCH
            DO 204 K = 1,NST
               IF ((COUNT(1,K,I,J).GT.0) .AND. (COUNT(2,K,I,J).GT.0)
     *            .AND. (COUNT(3,K,I,J).GT.0)) THEN
                  IF (DT.GT.0.0) THEN
                     SCANV(K,I,J) = ATAN2 (WORK(2,1,K,I,J),
     *                  WORK(1,1,K,I,J)+1.0E-20) -
     *                  ATAN2 (WORK(2,2,K,I,J), WORK(1,2,K,I,J)+1.0E-20)
     *                  + ATAN2 (WORK(2,3,K,I,J),
     *                  WORK(1,3,K,I,J)+1.0E-20)
                  ELSE
                     SCANV(K,I,J) = ATAN2 (WORKC(2,K,I,J),
     *                  WORKC(1,K,I,J)+1.E-20)
                     END IF
                  GERR(1,K,I,J) = GERR(1,K,I,J) / GAMP(1,K,I,J)
                  GERR(2,K,I,J) = GERR(2,K,I,J) / GAMP(2,K,I,J)
                  GERR(3,K,I,J) = GERR(3,K,I,J) / GAMP(3,K,I,J)
                  CLERR(K,I,J) = SQRT (
     *               GERR(1,K,I,J)* GERR(1,K,I,J) /
     *               MAX(COUNT(1,K,I,J)-1,1) +
     *               GERR(2,K,I,J)* GERR(2,K,I,J) /
     *               MAX(COUNT(2,K,I,J)-1,1) +
     *               GERR(3,K,I,J)* GERR(3,K,I,J) /
     *               MAX(COUNT(3,K,I,J)-1,1))
               ELSE
                  SCANV(K,I,J) = FBLANK
                  CLERR(K,I,J) = FBLANK
                  END IF
 204           CONTINUE
 205        CONTINUE
 210     CONTINUE
C                                       Force range of values= +/- pi
C                                       rad.
      DO 220 J = 1,NUMTRP
         DO 215 I = 1,NCH
            DO 214 K = 1,NST
               IF (SCANV(K,I,J).NE.FBLANK) THEN
                  CP = SCANV(K,I,J) / TWOPI
                  ICP = CP
                  CP = (CP - ICP) * TWOPI
                  IF (CP.GT.PI) CP = CP - TWOPI
                  IF (CP.LT.-PI) CP = CP + TWOPI
                  SCANV(K,I,J) = CP * RAD2DG
                  IF (CLERR(K,I,J).NE.FBLANK) CLERR(K,I,J) =
     *               CLERR(K,I,J) * RAD2DG
                  END IF
 214           CONTINUE
 215        CONTINUE
 220     CONTINUE
C                                       have some results
C                                       save current sample
      IF (IRET.EQ.0) THEN
         CALL CLAVPR ('ZERO', NUMTRP, CPTRIP, T1, DT, RPARM, VIS, NST,
     *      NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR)
         CALL CLAVPR ('AVER', NUMTRP, CPTRIP, T1, DT, RPARM, VIS, NST,
     *      NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1100 FORMAT ('CLOSPV at visibility number',I10)
      END
      SUBROUTINE CLAVPR (OP, NUMTRP, CPTRIP, T1, DT, RPARM, VIS, NST,
     *   NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR)
C-----------------------------------------------------------------------
C   Add a sample to, or clear, the summing arrays
C   Inputs:
C      OP       C*4      'ZERO' or average
C      NUMTRP   I        Number triangles
C      CPTRP    I(*)     The triangles
C      DT       R        Integration time
C      RPARM    R(*)     Random parameters
C      VIS      R(3,*)   Data visibilities/weights
C      NST      I        Number stokes
C      NCH      I        Number spectral channels
C   Outputs
C      T1       R        Start time this average: set if input > 10^9
C   Buffers
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C-----------------------------------------------------------------------
      CHARACTER OP*4
      INTEGER   NUMTRP, CPTRIP(3,*), NST, NCH, COUNT(3,NST,NCH,*),
     *   COUNT1(3,NST,NCH,*)
      REAL      T1, DT, RPARM(*), VIS(3,*)
      REAL      WORK(2,3,NST,NCH,*), WORKC(2,NST,NCH,*),
     *   GAMP(3,NST,NCH,*), GERR(3,NST,NCH,*)
C
      INTEGER   I, J, K, IVIS, JA1, JA2, IDAY, STTRIP, ITRIP, IBASE
      REAL      CT, TEMP
      DOUBLE PRECISION X8
      INCLUDE 'CLAVER.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DANT.INC'
C-----------------------------------------------------------------------
      IF (OP.EQ.'ZERO') THEN
         TLAST = -1.0
         IVSCNT = 0
         DTUTC = DATUTC / 86400.0
         I = 3 * NST * NCH * NUMTRP
         CALL FILL (I, 0, COUNT)
         CALL FILL (I, 0, COUNT1)
         CALL RFILL (I, 0.0, GAMP)
         CALL RFILL (I, 0.0, GERR)
         I = 2 * 3 * NST * NCH * NUMTRP
         CALL RFILL (I, 0.0, WORK)
         I = 2 * NST * NCH * NUMTRP
         CALL RFILL (I, 0.0, WORKC)
C                                       add one vis into arrays:
      ELSE
C                                       Set up first time boundary
         CT = RPARM(ILOCT+1) - DTUTC
         IVSCNT = IVSCNT + 1
         IF (IVSCNT.EQ.1) THEN
            IDAY = CT
            X8 = (CT - IDAY) / ABS (DT)
            TLAST = IDAY + DINT (X8) * ABS (DT) + ABS (DT)
            END IF
C                                       Antenna numbers
         IF (ILOCB.GE.0) THEN
            JA1 = RPARM(ILOCB+1) / 256. + 0.1
            JA2 = RPARM(ILOCB+1) - JA1 * 256 + 0.1
         ELSE
            JA1 = RPARM(ILOCA1+1) + 0.1
            JA2 = RPARM(ILOCA2+1) + 0.1
            END IF
         STTRIP = 1
C                                       Return to here to look for
C                                       further triplets involving this
C                                       baseline.
C                                       Find triplet and member
 100     DO 110 I = STTRIP,NUMTRP
            ITRIP = I
            IBASE = 1
            IF ((JA1.EQ.CPTRIP(1,I).AND.(JA2.EQ.CPTRIP(2,I)))) GO TO 120
            IBASE = 2
            IF ((JA1.EQ.CPTRIP(1,I).AND.(JA2.EQ.CPTRIP(3,I)))) GO TO 120
            IBASE = 3
            IF ((JA1.EQ.CPTRIP(2,I).AND.(JA2.EQ.CPTRIP(3,I)))) GO TO 120
 110        CONTINUE
C                                       Not wanted
         GO TO 999
C                                       wanted
 120     STTRIP = ITRIP + 1
         IF (T1.GT.1.0E9) T1 = RPARM(ILOCT+1)
C                                       Vector average:
      INCLUDE 'INCS:ZVD.INC'
         K = NST
         J = 0
         DO 130 IVIS = 1,NCH*NST
            K = K + 1
            IF (K.GT.NST) THEN
               J = J + 1
               K = 1
               END IF
            IF (VIS(3,IVIS).GT.0.0) THEN
               COUNT(IBASE,K,J,ITRIP) = COUNT(IBASE,K,J,ITRIP) + 1
               COUNT1(IBASE,K,J,ITRIP) = COUNT1(IBASE,K,J,ITRIP) + 1
               WORK(1,IBASE,K,J,ITRIP) = WORK(1,IBASE,K,J,ITRIP) +
     *            VIS(1,IVIS)
               WORK(2,IBASE,K,J,ITRIP) = WORK(2,IBASE,K,J,ITRIP) +
     *            VIS(2,IVIS)
               GAMP(IBASE,K,J,ITRIP) = GAMP(IBASE,K,J,ITRIP) +
     *            SQRT (VIS(1,IVIS)*VIS(1,IVIS) + VIS(2,IVIS)*
     *            VIS(2,IVIS))
               GERR(IBASE,K,J,ITRIP) = GERR(IBASE,K,J,ITRIP) +
     *            SQRT (1.0/VIS(3,IVIS))
               END IF
 130        CONTINUE
C                                       averaging closure phases
         IF (DT.LT.0.0) THEN
            K = NST
            J = 0
            DO 140 IVIS = 1,NCH
               K = K + 1
               IF (K.GT.NST) THEN
                  J = J + 1
                  K = 1
                  END IF
C                                       completed a triangle
               IF ((COUNT1(1,K,J,ITRIP).GT.0) .AND.
     *            (COUNT1(2,K,J,ITRIP).GT.0) .AND.
     *            (COUNT1(3,K,J,ITRIP).GT.0)) THEN
                  TEMP = ATAN2 (WORK(2,1,K,J,ITRIP),
     *               WORK(1,1,K,J,ITRIP)+1.0E-20) -
     *               ATAN2 (WORK(2,2,K,J,ITRIP),
     *               WORK(1,2,K,J,ITRIP)+1.0E-20) +
     *               ATAN2 (WORK(2,3,K,J,ITRIP),
     *               WORK(1,3,K,J,ITRIP)+1.0E-20)
                  WORKC(1,K,J,ITRIP) = WORKC(1,K,J,ITRIP) + COS (TEMP)
                  WORKC(2,K,J,ITRIP) = WORKC(2,K,J,ITRIP) + SIN (TEMP)
                  CALL RFILL (6, 0.0, WORK(1,1,K,J,ITRIP))
                  CALL FILL (3, 0, COUNT1(1,K,J,ITRIP))
                  END IF
 140           CONTINUE
            END IF
C                                       This baseline may be involved in
C                                       more triplets.
         GO TO 100
C
         END IF
C
 999  RETURN
      END
      SUBROUTINE CLOSEA (CPQUAD, NST, NCH, COUNT, COUNT1, WORK, WORKC,
     *   GAMP, GERR, SCANV, CLERR, COUNTA, IRET)
C-----------------------------------------------------------------------
C   CLOSEA gets the amplitude closure spectrum
C   INPUTS:
C      NST      I        Number stokes
C      NCH      I        Number spectral channels
C      CPTRIP   I(3,*)   Triangles
C   Work buffers:
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C      SCANV    R(*)
C      CLERR    R(*)
C   Output:
C      IRET              Error code
C-----------------------------------------------------------------------
      INTEGER   CPQUAD(4,*), NST, NCH, COUNT(4,NST,NCH,*),
     *   COUNT1(4,NST,NCH,*), COUNTA(NST,NCH,*), IRET
      REAL      WORK(2,4,NST,NCH,*), WORKC(2,NST,NCH,*),
     *   GAMP(4,NST,NCH,*), GERR(4,NST,NCH,*), SCANV(NST,NCH,*),
     *   CLERR(NST,NCH,*)
C
      INCLUDE 'CLOSE.INC'
      INCLUDE 'CLAVER.INC'
      INTEGER   I, J, K, NUMVIS, IC, SCANUM
      LOGICAL   NUSCAN, FIRST
      REAL      WTSUM(2,16384), DT, RPARM(20), AOFF, WT
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
C-----------------------------------------------------------------------
C                                       zero spectrum
      CALL RFILL (2*NCH, 0.0, SPECTR)
      CALL RFILL (2*NCH, 0.0, SPECAV)
      CALL RFILL (2*NCH, 0.0, WTSUM)
C                                       Init the IO
      CALL UVGET ('INIT', RPARM, BUFF1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT READING DATA SET'
         GO TO 990
         END IF
      DT = XSOLIN / 1440.0
      FIRST = .TRUE.
      NUMVIS = 0
      WT = 300.0 / NUMTQ
      VISINC = CATBLK(KIGCN) / 10
      VISMSG = CATBLK(KIGCN) / 5
      VISINC = MAX (40000, MIN (200000,VISINC))
      VISINC = VISINC * WT
      VISINC = ((VISINC+500)/1000) * 1000
      VISINC = MAX (5000, MIN (50000,VISINC))
      VISMSG = WT * VISMSG
      VISMSG = (VISMSG / VISINC) * VISINC
      IF (VISMSG.LT.VISINC) VISMSG = 100 * VISINC
 20   CONTINUE
         CALL CLOSAV (NUMVIS, NST, NCH, NUMTQ, CPQUAD, DT, SCANV, CLERR,
     *      NUSCAN, SCANUM, RPARM, BUFF1, COUNT, COUNT1, WORK, WORKC,
     *      GAMP, GERR, COUNTA, IRET)
         IF (IRET.EQ.-2) GO TO 20
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING THE DATA'
            GO TO 990
            END IF
         IF (FIRST) THEN
            FIRST = .FALSE.
            AOFF = 0.0
            IC = 0
            DO 30 J = 1,NUMTQ
               DO 25 I = 1,NCH
                  DO 24 K = 1,NST
                     IF (SCANV(K,I,J).NE.FBLANK) THEN
                        AOFF = AOFF + CLERR(K,I,J)**2
                        IC = IC + 1
                        END IF
 24                  CONTINUE
 25               CONTINUE
 30            CONTINUE
            IF (IC.GT.0) THEN
               AOFF = AOFF / IC
            ELSE
               AOFF = 0.04
               END IF
            END IF
         DO 50 J = 1,NUMTQ
            DO 40 I = 1,NCH
               DO 35 K = 1,NST
                  IF (SCANV(K,I,J).NE.FBLANK) THEN
                     WT = 1.0 / (CLERR(K,I,J)**2 + AOFF)
                     SPECAV(K,I) = SPECAV(K,I) + WT * SCANV(K,I,J)
                     SPECTR(K,I) = SPECTR(K,I) + WT * (SCANV(K,I,J)**2)
                     WTSUM(K,I) = WTSUM(K,I) + WT
                     END IF
 35               CONTINUE
 40            CONTINUE
 50         CONTINUE
         IF (IRET.EQ.0) GO TO 20
C                                       close, average
      CALL UVGET ('CLOS', RPARM, BUFF1, IRET)
      J = 0
      DO 60 I = 1,NCH
         DO 59 K = 1,NST
            IF (WTSUM(K,I).GT.0.0) THEN
               SPECAV(K,I) = SPECAV(K,I) / WTSUM(K,I)
               SPECTR(K,I) = SPECTR(K,I) / WTSUM(K,I) - SPECAV(K,I)**2
               IF (SPECTR(K,I).GT.0.0) THEN
                  SPECTR(K,I) = SQRT (SPECTR(K,I))
               ELSE
                  SPECTR(K,I) = FBLANK
                  END IF
               J = J + 1
            ELSE
               SPECAV(K,I) = FBLANK
               SPECTR(K,I) = FBLANK
               END IF
 59         CONTINUE
 60      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CLOSEA ERROR',I4,' ON ',A)
      END
      SUBROUTINE CLOSAV (NUMVIS, NST, NCH, NUMQAD, CPQUAD, DT, SCANV,
     *   CLERR, NUSCAN, SCANUM, RPARM, VIS, COUNT, COUNT1, WORK, WORKC,
     *   GAMP, GERR, COUNTA, IRET)
C-----------------------------------------------------------------------
C   Returns an integration time's worth of phase closure values
C   Inputs:
C      NUMVIS   I        NUMVIS = 0 - init things
C      NST      I        Number stokes
C      NCH      I        Number spectral channels
C      NUMTRP   I        Number rectangles
C      CPTRIP   I(4,*)   Rectangles
C      DT       R        Integration time (days)
C   In/out:
C      RPARM    R(*)     Random parameter values
C      VIS      R(3,*)   Visibility data / weights
C   Output:
C      SCANV    R(*)     Closure phase (degrees)
C      CLERR    R(*)     Closure phase uncertainty
C   Work buffers
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C-----------------------------------------------------------------------
      INTEGER   NUMVIS, NST, NCH, NUMQAD, CPQUAD(4,*), SCANUM, IRET,
     *   COUNT(4,NST,NCH,*), COUNT1(4,NST,NCH,*), COUNTA(NST,NCH,*)
      LOGICAL   NUSCAN
      REAL      DT, RPARM(*), VIS(3,*), SCANV(NST,NCH,*),
     *   CLERR(NST,NCH,*), WORK(2,4,NST,NCH,*), WORKC(NST,NCH,*),
     *   GAMP(4,NST,NCH,*), GERR(4,NST,NCH,*)
C
      INTEGER   I, J, K, IDAY
      REAL      T1, CT, CP, TEMP
      DOUBLE PRECISION X8
      INCLUDE 'CLAVER.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
      IF (NUMVIS.EQ.0) CALL CLAVAR ('ZERO', NUMQAD, CPQUAD, T1, DT,
     *   RPARM, VIS, NST, NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR,
     *   COUNTA)
C                                       Save scan number (0= no index)
      NUSCAN = SCANUM.NE.INXRNO
      SCANUM = INXRNO
C                                       Initialize time
      T1 = 1.0E10
C                                       Loop reading data
 100  CONTINUE
         CALL UVGET ('READ', RPARM, VIS, IRET)
         IF (IRET.GT.0) GO TO 999
         IF (IRET.EQ.-1) GO TO 200
         NUMVIS = NUMVIS + 1
         IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
            WRITE (MSGTXT,1100) NUMVIS
            CALL MSGWRT (2)
         ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
            WRITE (MSGTXT,1100) NUMVIS
            CALL MSGWRT (1)
            END IF
          CT = RPARM(ILOCT+1) - DTUTC
C                                       Set up first time boundary
         IF (IVSCNT.EQ.0) THEN
            IDAY = CT
            X8 = (CT - IDAY) / ABS (DT)
            TLAST = IDAY + DINT (X8) * ABS (DT) + ABS (DT)
            END IF
C                                       Check if avg. or scan done
         IF ((INXRNO.LE.SCANUM) .AND. (CT.LE.TLAST)) THEN
            CALL CLAVAR ('AVER', NUMQAD, CPQUAD, T1, DT, RPARM, VIS,
     *         NST, NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR, COUNTA)
            GO TO 100
            END IF
C                                       Vector averaging
 200  CP = TWOPI
      DO 210 J = 1,NUMQAD
         DO 205 I = 1,NCH
            DO 204 K = 1,NST
               IF ((COUNT(1,K,I,J).GT.0) .AND. (COUNT(2,K,I,J).GT.0)
     *            .AND. (COUNT(3,K,I,J).GT.0) .AND.
     *            (COUNT(4,K,I,J).GT.0)) THEN
                  IF (DT.GT.0.0) THEN
                    SCANV(K,I,J) = SQRT (WORK(1,1,K,I,J)**2 +
     *                  WORK(2,1,K,I,J)**2) *
     *                  SQRT (WORK(1,2,K,I,J)**2 + WORK(2,2,K,I,J)**2) /
     *                  (COUNT(1,K,I,J) * COUNT(2,K,I,J))
                     TEMP = SQRT (WORK(1,3,K,I,J)**2 +
     *                  WORK(2,3,K,I,J)**2) *
     *                  SQRT (WORK(1,4,K,I,J)**2 + WORK(2,4,K,I,J)**2) /
     *                  (COUNT(3,K,I,J) * COUNT(4,K,I,J))
                  ELSE
                     SCANV(K,I,J) = WORKC(K,I,J)
                     TEMP = COUNTA(K,I,J)
                     END IF
                  IF ((TEMP.GT.0.0) .AND. (SCANV(K,I,J).GT.0.0)) THEN
                     SCANV(K,I,J) = SCANV(K,I,J) / TEMP
                     GERR(1,K,I,J) = GERR(1,K,I,J) / COUNT(1,K,I,J)
                     GERR(2,K,I,J) = GERR(2,K,I,J) / COUNT(2,K,I,J)
                     GERR(3,K,I,J) = GERR(3,K,I,J) / COUNT(3,K,I,J)
                     GERR(4,K,I,J) = GERR(4,K,I,J) / COUNT(4,K,I,J)
                     CLERR(K,I,J) = SQRT (
     *                  GERR(1,K,I,J)*GERR(1,K,I,J) /
     *                  MAX(1,COUNT(1,K,I,J)-1) +
     *                  GERR(2,K,I,J)*GERR(2,K,I,J) /
     *                  MAX(1,COUNT(2,K,I,J)-1) +
     *                  GERR(3,K,I,J)*GERR(3,K,I,J) /
     *                  MAX(1,COUNT(3,K,I,J)-1) +
     *                  GERR(4,K,I,J)*GERR(4,K,I,J) /
     *                  MAX(1,COUNT(4,K,I,J)-1))
                     IF (SCANV(K,I,J).NE.0.0) THEN
                        CLERR(K,I,J) = CLERR(K,I,J) / SCANV(K,I,J)
                        SCANV(K,I,J) = LOG (SCANV(K,I,J))
                        END IF
                  ELSE
                     SCANV(K,I,J) = FBLANK
                     CLERR(K,I,J) = FBLANK
                     END IF
               ELSE
                  SCANV(K,I,J) = FBLANK
                  CLERR(K,I,J) = FBLANK
                  END IF
 204           CONTINUE
 205        CONTINUE
 210     CONTINUE
C                                       have some results
C                                       save current sample
      IF (IRET.EQ.0) THEN
         CALL CLAVAR ('ZERO', NUMQAD, CPQUAD, T1, DT, RPARM, VIS, NST,
     *      NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR, COUNTA)
         CALL CLAVAR ('AVER', NUMQAD, CPQUAD, T1, DT, RPARM, VIS, NST,
     *      NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR, COUNTA)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1100 FORMAT ('CLOSAV at visibility number',I10)
      END
      SUBROUTINE CLAVAR (OP, NUMQAD, CPQUAD, T1, DT, RPARM, VIS, NST,
     *   NCH, COUNT, COUNT1, WORK, WORKC, GAMP, GERR, COUNTA)
C-----------------------------------------------------------------------
C   Add a sample to, or clear, the summing arrays
C   Inputs:
C      OP       C*4      'ZERO' or average
C      NUMQAD   I        Number quadrangles
C      CPQUAD   I(*)     The quadrangles
C      DT       R        Integration time
C      RPARM    R(*)     Random parameters
C      VIS      R(3,*)   Data visibilities/weights
C   Outputs
C      T1       R        Start time this average: set if input > 10^9
C   Buffers
C      COUNT    I(*)
C      COUNT1   I(*)
C      WORK     R(*)
C      WORKC    R(*)
C      GAMP     R(*)
C      GERR     R(*)
C      COUNTA   I(*)
C-----------------------------------------------------------------------
      CHARACTER OP*4
      INTEGER   NUMQAD, CPQUAD(4,*), NST, NCH, COUNT(4,NST,NCH,*),
     *   COUNT1(4,NST,NCH,*), COUNTA(NST,NCH,*)
      REAL      T1, DT, RPARM(*), VIS(3,*)
      REAL      WORK(2,4,NST,NCH,*), WORKC(NST,NCH,*),
     *   GAMP(4,NST,NCH,*), GERR(4,NST,NCH,*)
C
      INTEGER   I, K, IVIS, JA1, JA2, IDAY, STQUAD, IQUAD, IBASE
      REAL      CT, TEMP
      DOUBLE PRECISION X8
      INCLUDE 'CLAVER.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DANT.INC'
C-----------------------------------------------------------------------
      IF (OP.EQ.'ZERO') THEN
         TLAST = -1.0
         IVSCNT = 0
         DTUTC = DATUTC / 86400.0
         I = 4 * NST * NCH * NUMQAD
         CALL FILL (I, 0, COUNT)
         CALL FILL (I, 0, COUNT1)
         CALL RFILL (I, 0.0, GAMP)
         CALL RFILL (I, 0.0, GERR)
         I = 2 * 4 * NST * NCH * NUMQAD
         CALL RFILL (I, 0.0, WORK)
         I = NST * NCH * NUMQAD
         CALL RFILL (I, 0.0, WORKC)
C                                       add one vis into arrays:
      ELSE
C                                       Set up first time boundary
         CT = RPARM(ILOCT+1) - DTUTC
         IVSCNT = IVSCNT + 1
         IF (IVSCNT.EQ.1) THEN
            IDAY = CT
            X8 = (CT - IDAY) / ABS (DT)
            TLAST = IDAY + DINT (X8) * ABS (DT) + ABS (DT)
            END IF
C                                       Antenna numbers
         IF (ILOCB.GE.0) THEN
            JA1 = RPARM(ILOCB+1) / 256. + 0.1
            JA2 = RPARM(ILOCB+1) - JA1 * 256 + 0.1
         ELSE
            JA1 = RPARM(ILOCA1+1) + 0.1
            JA2 = RPARM(ILOCA2+1) + 0.1
            END IF
         STQUAD = 1
C                                       Return to here to look for
C                                       further triplets involving this
C                                       baseline.
C                                       Find triplet and member
 100     DO 110 I = STQUAD,NUMQAD
            IQUAD = I
            IBASE = 1
            IF ((JA1.EQ.CPQUAD(1,I).AND.(JA2.EQ.CPQUAD(2,I)))) GO TO 120
            IBASE = 2
            IF ((JA1.EQ.CPQUAD(3,I).AND.(JA2.EQ.CPQUAD(4,I)))) GO TO 120
            IBASE = 3
            IF ((JA1.EQ.CPQUAD(1,I).AND.(JA2.EQ.CPQUAD(3,I)))) GO TO 120
            IBASE = 4
            IF ((JA1.EQ.CPQUAD(2,I).AND.(JA2.EQ.CPQUAD(4,I)))) GO TO 120
 110        CONTINUE
C                                       Not wanted
         GO TO 999
C                                       wanted
 120     STQUAD = IQUAD + 1
         IF (T1.GT.1.0E9) T1 = RPARM(ILOCT+1)
C                                       Vector average:
      INCLUDE 'INCS:ZVD.INC'
         IVIS = 0
         DO 130 I = 1,NCH
            DO 125 K = 1,NST
               IVIS = IVIS + 1
               IF (VIS(3,IVIS).GT.0.0) THEN
                  COUNT(IBASE,K,I,IQUAD) = COUNT(IBASE,K,I,IQUAD) + 1
                  COUNT1(IBASE,K,I,IQUAD) = COUNT1(IBASE,K,I,IQUAD) + 1
                  WORK(1,IBASE,K,I,IQUAD) = WORK(1,IBASE,K,I,IQUAD) +
     *               VIS(1,IVIS)
                  WORK(2,IBASE,K,I,IQUAD) = WORK(2,IBASE,K,I,IQUAD) +
     *               VIS(2,IVIS)
                  GAMP(IBASE,K,I,IQUAD) = GAMP(IBASE,K,I,IQUAD) +
     *               SQRT (VIS(1,IVIS)*VIS(1,IVIS) + VIS(2,IVIS)*
     *               VIS(2,IVIS))
                  GERR(IBASE,K,I,IQUAD) = GERR(IBASE,K,I,IQUAD) +
     *               SQRT (1.0/VIS(3,IVIS))
                  END IF
 125           CONTINUE
 130        CONTINUE
C                                       averaging closure phases
         IF (DT.LT.0.0) THEN
C                                       completed a quadrangle
            DO 145 K = 1,NST
               DO 140 I = 1,NCH
                  IF ((COUNT1(1,K,I,IQUAD).GT.0) .AND.
     *               (COUNT1(2,K,I,IQUAD).GT.0) .AND.
     *               (COUNT1(3,K,I,IQUAD).GT.0).AND.
     *               (COUNT1(4,K,I,IQUAD).GT.0)) THEN
                     TEMP = SQRT (WORK(1,3,K,I,IQUAD)**2 +
     *                  WORK(2,3,K,I,IQUAD)**2) *
     *                  SQRT (WORK(1,4,K,I,IQUAD)**2 +
     *                  WORK(2,4,K,I,IQUAD)**2) /
     *                  (COUNT1(3,K,I,IQUAD) * COUNT1(4,K,I,IQUAD))
                     IF (TEMP.NE.0.0) THEN
                        WORKC(K,I,IQUAD) = WORKC(K,I,IQUAD) +
     *                     SQRT (WORK(1,1,K,I,IQUAD)**2 +
     *                     WORK(2,1,K,I,IQUAD)**2) *
     *                     SQRT (WORK(1,2,K,I,IQUAD)**2 +
     *                     WORK(2,2,K,I,IQUAD)**2) /
     *                     (COUNT1(1,K,I,IQUAD) * COUNT1(2,K,I,IQUAD)) /
     *                     TEMP
                        COUNTA(K,I,IQUAD) = COUNTA(K,I,IQUAD) + 1
                        END IF
                     CALL RFILL (8, 0.0, WORK(1,1,K,I,IQUAD))
                     CALL FILL (4, 0, COUNT1(1,K,I,IQUAD))
                     END IF
 140              CONTINUE
 145           CONTINUE
            END IF
C                                       This baseline may be involved in
C                                       more quadrangles
         GO TO 100
C
         END IF
C
 999  RETURN
      END
      SUBROUTINE PLOTCL (IRET)
C-----------------------------------------------------------------------
C   PLOTCL plots and optionally prints the computed spectrum
C   Outputs:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'CLOSE.INC'
      INTEGER   I, J, K, NCH, ICH, IIF, SCRBUF(256), PLBUFF(256),
     *   GRCHAN, PLUN, PIND, ID(3), IT(3), NCHAN, INCHAR, DEPTH(5),
     *   PVER, L, IROUND, JTRIM, LSYM
      REAL      RANGE(2), BLC(2), TRC(2), CH(4), DX, DY, XMIN, XMAX,
     *   YMIN, YMAX, X, Y
      CHARACTER SCRTCH*132, LINE*132, PFILE*48, ATIME*8, ADATE*12,
     *   PROBLM*24
      LOGICAL   GOOD
      DOUBLE PRECISION FF
      INCLUDE 'INCS:DCHND.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA TVCHN, TVCORN, DEPTH /1, 4*0, 5*1/
C-----------------------------------------------------------------------
C                                       find max/min if needed
      NCHAN = ECHAN - BCHAN + 1
      NCH = NCHAN * (EIF - BIF + 1)
      RANGE(2) = -1.E6
      RANGE(1) = 1.E6
      DO 10 I = 1,NCH
         DO 5 K = 1,NSTOK
            IF (SPECTR(K,I).NE.FBLANK) THEN
               RANGE(2) = MAX (RANGE(2), SPECTR(K,I))
               RANGE(1) = MIN (RANGE(1), SPECTR(K,I))
               END IF
 5          CONTINUE
 10      CONTINUE
      IF (RANGE(2).LE.RANGE(1)) THEN
         IRET = 10
         MSGTXT = 'NO VALID POINTS TO PLOT/PRINT'
         CALL MSGWRT (8)
         GO TO 999
         END IF
C                                       print the answers
      IF (OUTEXT.EQ.' ') DOCRT = MAX (0.0, DOCRT)
      IF (DOCRT.NE.0.0) THEN
         PAGE = 0
         IPCNT = 999
         CALL LPOPEN (OUTEXT, DOCRT, LUNP, FINDP, NACROS, SCRBUF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPENING LINE PRINTER'
            CALL MSGWRT (7)
            GO TO 40
            END IF
         TITL1 = ' '
         TITL2 = ' '
         IF (DOCRT.GT.-2.5) THEN
            IPCNT = 998
            WRITE (LINE,1001) NAMEIN, CLAIN, SEQIN, DISKIN, NLUSER
            CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2, LINE,
     *         IPCNT, PAGE, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 35
            LINE = ' '
            CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, IPCNT, PAGE, SCRTCH, IRET)
            IF (IRET.NE.0) GO TO 35
            END IF
         WRITE (TITL1,1005)
         IF (NSTOK.EQ.1) TITL1(44:) = ' '
         LINE = TITL1
         CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *      LINE, IPCNT, PAGE, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 35
         WRITE (TITL2,1006)
         IF (NSTOK.EQ.1) TITL2(44:) = ' '
         LINE = TITL2
         CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *      LINE, IPCNT, PAGE, SCRTCH, IRET)
         IF (IRET.NE.0) GO TO 35
         I = 0
         DO 30 IIF = BIF,EIF
            DO 25 ICH = BCHAN,ECHAN
               I = I + 1
               FF = REFVAL + FOFF(IIF) + (ICH-REFPIX) * FINC(IIF)
               FF = FF/1.D6
               WRITE (LINE,1010) IIF, ICH, FF
               INCHAR = JTRIM (LINE)
               DO 24 K = 1,NSTOK
                  IF (SPECTR(K,I).EQ.FBLANK) THEN
                     LINE(INCHAR+1:) = '     INDE      INDE'
                  ELSE IF (OPTYPE.EQ.'AMP ') THEN
                     WRITE (LINE(INCHAR+1:),1011) SPECTR(K,I),
     *                  SPECAV(K,I)
                  ELSE
                     WRITE (LINE(INCHAR+1:),1012) SPECTR(K,I),
     *                  SPECAV(K,I)
                     END IF
                  INCHAR = JTRIM (LINE)
 24               CONTINUE
               CALL PRTLIN (LUNP, FINDP, DOCRT, NACROS, TITL1, TITL2,
     *            LINE, IPCNT, PAGE, SCRTCH, IRET)
               IF (IRET.NE.0) GO TO 35
 25            CONTINUE
 30         CONTINUE
 35      WRITE (MSGTXT,1000) IRET, 'PRINTING A LINE'
         IF (IRET.GT.0) CALL MSGWRT (7)
         CALL LPCLOS (LUNP, FINDP, IPCNT, I)
         END IF
C                                       Now do plot
 40   BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      NCH = NCH + (EIF-BIF)
      XMIN = (BIF - 1) * NCHAN
      XMAX = EIF * NCHAN + (EIF-BIF) + 1
      IF (XPIXR(2).GT.XPIXR(1)) THEN
         CALL RCOPY (2, XPIXR, RANGE)
      ELSE
         CALL RCOPY (2, RANGE, XPIXR)
         END IF
      DY = (RANGE(2) - RANGE(1)) * 0.02
      YMIN = RANGE(1) - DY
      YMAX = RANGE(2) + DY
      RANGE(1) = YMIN
      RANGE(2) = YMAX
C                                               create plot file
      IF (.NOT.DOTV) THEN
         PVER = 0
         CALL MADDEX ('PL', DISKIN, OLDCNO, CATKEP, PLBUFF, .TRUE.,
     *      'WRIT', PVER, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'ADDING PL FILE TO HEADER'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         END IF
C                                       Open the PLot file.
      CALL ZPHFIL ('PL', DISKIN, OLDCNO, PVER, PFILE, IRET)
      GRCHAN = XGRCH + 0.1
      CALL GINIT (DISKIN, OLDCNO, PFILE, 0, 75, NPARMS, XNAMEI, DOTV,
     *   TVCHN, GRCHAN, TVCORN, CATKEP, PLBUFF, PLUN, PIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT THE PLOT FILE: QUITTING'
         CALL MSGWRT (8)
         IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT',
     *      CATKEP, PLBUFF, PVER, I)
         GO TO 999
         END IF
C                                       text borders
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS (LABEL), 100)
      CALL GTICNT (LABEL, RANGE, I)
      CALL RFILL (4, 0.5, CH)
      IF (LTYPE.EQ.2) CH(1) = 3.5
      IF (LTYPE.GT.2) CH(1) = I + 4.0
      IF (LTYPE.GT.1) THEN
         CH(2) = 2.0 + 1.666
         IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
         END IF
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CH(4) = 2.0
         IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
         END IF
      IF (XYRATO.LE.0.0) THEN
         IF (DOTV) THEN
            DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) + CH(3))
            DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) + CH(4))
            XYRATO = 1.0
            IF (DY.GT.0.0) XYRATO = DX / DY
         ELSE
            XYRATO = 1.0
            END IF
         END IF

C                                        Init. for line drawing
      CALL GINITL (BLC, TRC, XYRATO, CH, DEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) THEN
         PROBLM = 'INIT FOR LINE DRAWING'
         GO TO 950
         END IF
C                                       Draw borders.
      PROBLM = 'DRAWING BORDERS'
      CALL GLTYPE (1, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL GPOS (BLC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL GVEC (TRC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL GVEC (TRC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL GVEC (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL GVEC (BLC(1), BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
C                                       external labeling
      DX = 0.0
      DY = CH(4) - 1.5
C                                       Date/time/version
      IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         PROBLM = 'LABEL DATE/TIME'
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL ZDATE (ID)
         CALL ZTIME (IT)
         CALL TIMDAT (IT, ID, ATIME, ADATE)
         WRITE (LINE,1050) PVER, ADATE, ATIME
         CALL REFRMT (LINE, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, LINE, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         DY = DY - 1.333
         END IF
C                                       File name label & source name
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         PROBLM = 'FILENAME LABEL'
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         IF (OPTYPE.EQ.'AMP ') THEN
            WRITE (LINE,1055) NAMEIN, CLAIN, SEQIN, 'amplitude', XSTOK
         ELSE
            WRITE (LINE,1055) NAMEIN, CLAIN, SEQIN, 'phase', XSTOK
            END IF
         CALL CHPACK (LINE, '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, LINE, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         END IF
C                                       axis labeling
      CALL CLOLAB (OPTYPE, LTYPE, BLC, TRC, RANGE, PLBUFF, IRET)
      PROBLM = 'FROM CLOLAB'
      IF (IRET.NE.0) GO TO 950
C                                       plot the data: marks
      DX = 5 * FACTOR / XYRATO
      DY = 5 * FACTOR
      IF (ISYM.GT.0) THEN
         LSYM = ISYM - 1
         PROBLM = 'PLOTTING SYMBOLS'
         DO 65 K = 1,NSTOK
            CALL GLTYPE (2*K, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            L = 0
            LSYM = LSYM + 1
            DO 60 J = BIF,EIF
               DO 50 I = 1,NCHAN
                  L = L + 1
                  X = (J - 1) * NCHAN + (J-BIF) + I
                  X = (X - XMIN) / (XMAX - XMIN) * (TRC(1) - BLC(1)) +
     *               BLC(1)
                  Y = SPECTR(K,L)
                  IF (Y.NE.FBLANK) THEN
                     Y = (Y - YMIN) / (YMAX - YMIN) * (TRC(2) - BLC(2))
     *                  + BLC(2)
                     IF ((X.GE.BLC(1)) .AND. (X.LE.TRC(1)) .AND.
     *                  (Y.GE.BLC(2)) .AND. (Y.LE.TRC(2))) THEN
                        CALL GMARK (LSYM, X, Y, DX, DY, BLC, TRC, PLBUFF
     *                     ,IRET)
                        IF (IRET.NE.0) GO TO 950
                        END IF
                     END IF
 50               CONTINUE
 60            CONTINUE
 65         CONTINUE
         END IF
C                                       plot line
      IF ((ISYM.LT.0) .OR. (DOLINE)) THEN
         DO 85 K = 1,NSTOK
            CALL GLTYPE (2*K, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            L = 0
            PROBLM = 'PLOTTING LINES'
            DO 80 J = BIF,EIF
               GOOD = .FALSE.
               DO 70 I = 1,NCHAN
                  L = L + 1
                  X = (J - 1) * NCHAN + (J-BIF) + I
                  X = (X - XMIN) / (XMAX - XMIN) * (TRC(1) - BLC(1)) +
     *               BLC(1)
                  Y = SPECTR(K,L)
                  IF (Y.EQ.FBLANK) THEN
                     GOOD = .FALSE.
                  ELSE
                     Y = (Y - YMIN) / (YMAX - YMIN) * (TRC(2) - BLC(2))
     *                  +BLC(2)
                     IF ((X.GE.BLC(1)) .AND. (X.LE.TRC(1)) .AND.
     *                  (Y.GE.BLC(2)) .AND. (Y.LE.TRC(2))) THEN
                        IF (GOOD) THEN
                           CALL GVEC (X, Y, PLBUFF, IRET)
                        ELSE
                           CALL GPOS (X, Y, PLBUFF, IRET)
                           END IF
                        IF (IRET.NE.0) GO TO 950
                        GOOD = .TRUE.
                     ELSE
                        GOOD = .FALSE.
                        END IF
                     END IF
 70               CONTINUE
 80            CONTINUE
 85         CONTINUE
         END IF
C                                       finish up
      CALL GFINIS (PLBUFF, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINISH PLOT'
         PROBLM = ' '
         GO TO 940
      ELSE IF (IRET.LT.0) THEN
         MSGTXT = 'Stopping at your request'
         CALL MSGWRT (3)
         END IF
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1100) PVER
         CALL MSGWRT (3)
         END IF
      GO TO 999
C                                       Error return from plotting
 940  CALL MSGWRT (8)
 950  IF (PROBLM.NE.' ') THEN
         MSGTXT = 'PLOT ERROR ' // PROBLM
         CALL MSGWRT (8)
         END IF
C                                       Destroy the PLot file on error.
      IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) PVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN, PFILE, I)
         CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT', CATKEP, PLBUFF,
     *      PVER, I)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLOTCL ERROR',I4,' ON ',A)
 1001 FORMAT (A12,'.',A6,'.',I4,'  Vol=',I2,'  User=',I5)
 1005 FORMAT ('  IF Channel   Frequency  Closure   Closure',
     *   '  Closure   Closure')
 1006 FORMAT ('                  GHz       RMS     average',
     *   '    RMS     average')
 1010 FORMAT (I4,I8,F12.3)
 1011 FORMAT (F9.4,F10.5)
 1012 FORMAT (F9.2,F10.3)
 1050 FORMAT ('Plot file version',I4,'__created ',A12,A8)
 1055 FORMAT (A12,'.',A6,'.',I5,'____Plot_',A,'_closure_rms',
     *   '___STOKES_',A)
 1100 FORMAT ('Plot file version',I4,' created')
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
      SUBROUTINE GMARK (ISYM, X, Y, DX, DY, PBLC, PTRC, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   GMARK makes a symbol of type ISYM at X, Y
C   Inputs:
C      X        R      Center point X
C      Y        R      Center point Y
C      DX       R      Extent X
C      DY       R      Extent Y
C      PBLC     R(2)   BLC of plot
C      PTRC     R(2)   TRC of plot
C   In/Out:
C      PLBUFF   I(*)   Plot buffer
C   Out:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   ISYM, PLBUFF(*), IRET
      REAL      X, Y, DX, DY, PBLC(2), PTRC(2)
C
      REAL      AX(5), AY(5)
      LOGICAL   DO3C
C-----------------------------------------------------------------------
      DO3C = .FALSE.
      IF (ISYM.GT.0) THEN
         AX(1) = X
         AY(1) = Y
         AX(2) = X - DX/2.0
         AX(3) = X + DX/2.0
         AX(4) = X
         AX(5) = X
         AY(2) = Y
         AY(3) = Y
         AY(4) = Y + DY/2.0
         AY(5) = Y - DY/2.0
         CALL PNTPLT (ISYM, AX, AY, PBLC, PTRC, .FALSE., DO3C, PLBUFF,
     *      IRET)
         END IF
C
 999  RETURN
      END
      SUBROUTINE CLOLAB (OPTYPE, LTYPE, BLC, TRC, RANGE, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   CLOLAB does the axis labeling
C   Inputs:
C      OPTYPE   C*4    'AMP ', 'PHAS'
C      LTYPE    I      Labeling level
C      BLC      R(2)   Plot bottom left corner
C      TRC      R(2)   Plot top right corner
C      RANGE    R(2)   Intensity range on Y axis
C   In/out:
C      PLBUFF   I(*)   Plot buffer
C   Output
C      IRET     I      Error code
C-----------------------------------------------------------------------
      CHARACTER OPTYPE*4
      INTEGER   LTYPE, PLBUFF(256), IRET
      REAL      BLC(2), TRC(2), RANGE(2)
C
      INTEGER   INOINT, INCHAR, I, J, IXO, NINT, NCHAN
      REAL      XMIN, XMAX, AMIN, AMAX, XINTER(24), DIST, XINT, XVAL,
     *   DCXM, XPOS, YPOS, X, Y, DCX, DCY, TICLEN, TICSCL, X0, DEG, DU,
     *   DL
      LOGICAL   NOTOK
      CHARACTER MSGBUF*80, PROBLM*48, PREFIX*5
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA TICSCL /80.0/
      DATA XINTER /.001, .002, .005, .01, .02, .05, .1, .2, .5,
     *   1., 2., 5., 10., 20., 50., 100., 200., 500.,
     *   1000., 2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
      NCHAN = (ECHAN - BCHAN + 1)
      XMIN = (BIF - 1) * NCHAN
      XMAX = EIF * NCHAN + (EIF-BIF) + 1
      TICLEN = (TRC(1) - BLC(1)) / TICSCL
      AMAX = RANGE(2)
      AMIN = RANGE(1)
      DIST = (AMIN + AMAX) / 2.0
      X = DIST
      CALL METSCA (DIST, PREFIX, NOTOK)
      DIST = DIST / X
      AMIN = AMIN * DIST
      AMAX = AMAX * DIST
      XINT = 10.0
      DO 10 I = 1,24
         DEG = XINTER(I)
         DU = AINT (AMAX/DEG) * DEG
         IF (DU.GT.AMAX) DU = DU - DEG
         DL = AINT (AMIN/DEG) * DEG
         IF (DL.LT.AMIN) DL = DL + DEG
         INOINT = (DU-DL) / DEG + 1.01
         IF (INOINT.LE.XINT) GO TO 15
 10      CONTINUE
      MSGTXT = 'CANNOT FIND VERTICAL AXIS INCREMENT'
      CALL MSGWRT (8)
      GO TO 100
C                                       Interval and no of inter found.
 15   XINT = DEG
      INOINT = INOINT + 2
      XVAL = AINT (AMIN/XINT) * XINT
      IF (XVAL.GE.AMIN) XVAL = XVAL - XINT
      IXO = I
      DCXM = -0.5
C                                       Loop for all tics.
      PROBLM = 'VERTICAL AXIS LABELS'
      DO 50 I = 1,INOINT
         XVAL = XVAL + XINT
         YPOS = (XVAL - AMIN) / (AMAX - AMIN) * (TRC(2) - BLC(2))
     *      + BLC(2)
         IF (YPOS.GT.TRC(2)) GO TO 55
C                                       right hand tic.
         CALL GPOS (TRC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         X = TRC(1) - TICLEN
         CALL GVEC (X, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
C                                       Left hand tic.
         X = BLC(1) + TICLEN
         CALL GPOS (X, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         CALL GVEC (BLC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
C                                       Write value.
         IF (LTYPE.GT.2) THEN
            WRITE (MSGBUF,1030) XVAL
            CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
            IF (IXO.GT.3) INCHAR = INCHAR - 1
            IF (IXO.GT.6) INCHAR = INCHAR - 1
            IF (IXO.GT.9) INCHAR = INCHAR - 2
            DCX = - INCHAR - 1.0
            DCY = -0.5
            DCXM = MIN (DCXM, DCX)
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            END IF
C                                       IF dividers
         IF (EIF.GT.BIF) THEN
            DO 30 J = BIF,EIF-1
               X0 = J * NCHAN + (J - BIF) + 1.0
               X0 = (X0 - XMIN) / (XMAX - XMIN) * (TRC(1) - BLC(1))
     *            + BLC(1)
               IF (I.EQ.1) THEN
                  CALL GPOS (X0, BLC(2), PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  CALL GVEC (X0, TRC(2), PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 950
                  END IF
               X = X0 - TICLEN/2.0
               CALL GPOS (X, YPOS, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               X = X0 + TICLEN/2.0
               CALL GVEC (X, YPOS, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
 30            CONTINUE
            END IF
 50      CONTINUE
C                                       vertical label
 55   IF (OPTYPE.EQ.'AMP ') THEN
         IF (PREFIX.NE.' ') THEN
            MSGBUF = PREFIX // ' LOG (ratio)'
         ELSE
            MSGBUF = 'LOG (ratio)'
            END IF
      ELSE
         IF (PREFIX.NE.' ') THEN
            MSGBUF = PREFIX // ' degrees'
         ELSE
            MSGBUF = 'degrees'
            END IF
         END IF
      DCX = DCXM - 2.0
      YPOS = (TRC(2) + BLC(2)) / 2.0
      CALL GPOS (BLC(1), YPOS, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
      CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
      DCY = INCHAR / 2.0 - 1.0
      CALL GCHAR (INCHAR, 1, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 950
C                                       Horizontal axis
 100  XINT = 32 / (EIF-BIF+1)
      XINT = MAX(3.0, MIN (10.0, XINT))
      DIST = NCHAN
      DO 110 I = 1,24
         DEG = XINTER(I)
         DU = AINT (NCHAN/DEG) * DEG
         IF (DU.GT.NCHAN) DU = DU - DEG
         DL = AINT (1.0/DEG) * DEG
         IF (DL.LT.1.0) DL = DL + DEG
         INOINT = (DU-DL) / DEG + 1.01
         IF (INOINT.LE.XINT) GO TO 115
 110     CONTINUE
      MSGTXT = 'CANNOT FIND X AXIS INCREMENT'
      CALL MSGWRT (8)
      GO TO 200
C                                       Interval and no of inter found.
 115  XINT = DEG
      INOINT = INOINT + 2
      IXO = I
      TICLEN = (TRC(2) - BLC(2)) / TICSCL
      NINT = ((INOINT-2)*(EIF-BIF+1)) / 16
      NINT = MAX (1,NINT)
      DCY = -1.5
      PROBLM = 'PLOT X AXIS TICKS/LABELS'
C                                       Loop for all tics.
      DO 150 J = BIF,EIF
         XVAL = AINT (BCHAN/XINT) * XINT
         IF (XVAL.GE.BCHAN) XVAL = XVAL - XINT
         DO 140 I = 1,INOINT
            XVAL = XVAL + XINT
            IF (XVAL.GT.ECHAN) GO TO 150
            XPOS = XVAL - BCHAN + 1 + (J-1) * NCHAN + (J-BIF)
            XPOS = (XPOS - XMIN) / (XMAX-XMIN) * (TRC(1) - BLC(1))
     *         + BLC(1)
            CALL GPOS (XPOS, BLC(2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = BLC(2) + TICLEN
            CALL GVEC (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            Y = TRC(2) - TICLEN
            CALL GPOS (XPOS, Y, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            CALL GVEC (XPOS, TRC(2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            IF (LTYPE.GT.2) THEN
               CALL GPOS (XPOS, BLC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               WRITE (MSGBUF,1030) XVAL
               CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
               IF (IXO.GT.3) INCHAR = INCHAR - 1
               IF (IXO.GT.6) INCHAR = INCHAR - 1
               IF (IXO.GT.9) INCHAR = INCHAR - 2
               DCX = 0.5 - INCHAR
               CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 950
               END IF
 140        CONTINUE
 150     CONTINUE
C                                       IF numbers
 200  PROBLM = 'PLOT IF NUMBERS'
      IF (LTYPE.GT.2) THEN
         X = (TRC(1) + BLC(1)) / 2.0
         CALL GPOS (X, BLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         DCY = -2.833
         MSGBUF = 'Spectral channels'
         CALL CHTRIM (MSGBUF, 17, MSGBUF, INCHAR)
         DCX = 0.5 - INCHAR / 2.0
         CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         MSGBUF = 'IFs'
         DCY = -1.5
         DCX = DCXM - 2.0
         IF (LTYPE.GT.2) DCY = -4.166
         CALL GPOS (BLC(1), BLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         INCHAR = 3
         CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         XINT = (TRC(1) - BLC(1)) / (EIF - BIF + 1.0)
         DO 210 J = BIF,EIF
            IF (J.LT.10) THEN
               WRITE (MSGBUF,1150) J
               INCHAR = 1
            ELSE
               WRITE (MSGBUF,1151) J
               INCHAR = 2
               END IF
            X = (J - BIF + 0.5) * XINT
            CALL GPOS (X, BLC(2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
            DCX = -INCHAR / 2.0
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 950
 210        CONTINUE
         END IF
      GO TO 999
C
 950  WRITE (MSGTXT,1950) IRET, PROBLM
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F14.3)
 1150 FORMAT (I1)
 1151 FORMAT (I2)
 1950 FORMAT ('CLOLAB ERROR',I4,' ON ',A)
      END

