LOCAL INCLUDE 'BLPLT.INC'
      INCLUDE 'INCS:PUVD.INC'
      REAL      XSEQ, XDISK, XVER, XBIF, XEIF, XFQ, XSUB, XTIME(8),
     *   XANT(50), XRANGE(2), FACTOR, XDO3C, XLTYPE, XDOTV, XCHAN,
     *   XYRATO
      HOLLERITH XINNAM(3), XINCLS(2), XSTOKE(1), XTYPE(1)
      CHARACTER INNAM*12, INCLS*6, PTYPE*4, TTYPE*2, DOSTOK*4
      COMMON /INPARM/ XINNAM, XINCLS, XSEQ, XDISK, XVER, XFQ, XSUB,
     *   XBIF, XEIF, XSTOKE, XTIME, XANT, XTYPE, XRANGE, FACTOR, XDO3C,
     *   XLTYPE, XDOTV, XCHAN, XYRATO
      COMMON /CHPARM/ INNAM, INCLS, PTYPE, TTYPE, DOSTOK
      INTEGER   INSEQ, INDISK, INVERS, CNO, IUSER, BIF, EIF, BPOL, EPOL,
     *   PBUFF(256), FQID, SUBARR, NPARMS, PLUN, PFIND, LABEL,
     *   IANTS(MAXANT), DO3COL, NIANTS, LTYPE
      DOUBLE PRECISION TIME, TIMBEG, TIMEND, TPLBEG, TPLEND
      REAL      ARANGE(2), CURTIM
      COMMON /BLPLTC/ TIME, TIMBEG, TIMEND, TPLBEG, TPLEND, PBUFF,
     *   INSEQ, INDISK, INVERS, CNO, IUSER, BIF, EIF, BPOL, EPOL, FQID,
     *   SUBARR, NPARMS, PLUN, PFIND, LABEL, IANTS, ARANGE, DO3COL,
     *   NIANTS, LTYPE, CURTIM
LOCAL END
LOCAL INCLUDE 'DBLP.INC'
      INTEGER   IBLRNO, BLKOLS(14), BLNUMV(14), BLNANT, BLNPOL, BLNIF,
     *   BLBUFF(512), NBLINR
      COMMON /DBLCOM/ BLBUFF, IBLRNO, BLKOLS, BLNUMV, BLNANT, BLNPOL,
     *   BLNIF, NBLINR
LOCAL END
      PROGRAM BLPLT
C-----------------------------------------------------------------------
C! Plots BLCAL (BL) table profiles as function of time or baseline
C# EXT-appl Calibration Plot
C-----------------------------------------------------------------------
C;  Copyright (C) 2019-2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Plots BL tables versus baseline or time
C   Inputs from user
C      INNAME.....Input UV file name (name).      Standard defaults.
C      INCLASS....Input UV file name (class).     Standard defaults.
C      INSEQ......Input UV file name (seq. #).    0 => highest.
C      INDISK.....Disk drive # of input UV file.  0 => any.
C      INVERS.....Specifies the version of the BL table to be read as
C                 input.   0 -> highest.
C                 The output version is always highest + 1.
C      BIF........Lowest IF to be plotted.  0 => 1
C      EIF........Highest IF to be plotted.  0 => highest.
C      STOKES.....If the first character is R or L then only that
C                 polarization is plotted.  Otherwise both are plotted
C                 if present.
C      CODETYPE...'AMP', 'PHAS' to plot amplitude or phase of the
C                    bandpass.
C                 'DIFA', 'DIFP' to plot the amplitude or phase of the
C                    difference between the scalar average of the table
C                    entries in the plot and the present entry.
C      PIXRANGE...Clip plotted values with PIXRANGE.  0 => self-scale
C                 with the max min for all solutions in the plot.
C      FACTOR.....Controls the plot scale for each profile.
C      LTYPE......Labelling type: 1 = border, 2 = no ticks, 3 or 7 =
C                 standard, 4 or 8 = relative to ref. pixel, 5 or 9 =
C                 relative to subimage (BLC, TRC) center, 6 or 10 =
C                 pixels. 7-10 all labels other than tick numbers and
C                 axis type are omitted.  Less than 0 is the same except
C                 that the plot file version number and create time are
C                 omitted.
C      DOTV.......> 0 => plot directly on the TV device, otherwise make
C                 plot files for later display on one or more devices
C                 (including the TV if desired).
C      GRCHAN.....Graphics channel (1 - 7) to use for line drawing.
C                 0 => 1.
C-----------------------------------------------------------------------
      INTEGER   IRET
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'BLPLT.INC'
C-----------------------------------------------------------------------
C                                       Get parms, open things
      CALL BLPLTI (IRET)
C                                       do plotting
      IF (IRET.EQ.0) CALL BLPLTT (IRET)
C                                       close down
      CALL DIE (IRET, PBUFF)
C
 999  STOP
      END
      SUBROUTINE BLPLTI (IERR)
C-----------------------------------------------------------------------
C   BLPLTI performs initialization for AIPS task BLPLT.  It gets the
C   adverbs, opens the catalog file for 'READ' (eventually), sorts and
C   opens the BL input file, and determines which FQs, times, and
C   antenna counts apply to the table.
C   Output:
C      IERR    I      Error code: 0 => keep going, else quit.
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'BLPLT.INC'
      INCLUDE 'DBLP.INC'
      CHARACTER INTYP*2, STAT*4, PRGN*6, KEYSBL(3)*24
      INTEGER   IROUND, BLLUN, JERR, J, KEY(2,2), NKEY, KOLS(2), J1, J2,
     *   KEYSUB(2,2)
      REAL      FKEY(2,2)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA BLLUN, INTYP /27, 'UV'/
      DATA PRGN /'BLPLT '/
      DATA NKEY /3/
      DATA FKEY /1.0,0.0, 1.0,0.0/
      DATA KEYSUB /4*1/
      DATA KEYSBL /'ANTENNA1', 'ANTENNA2', 'TIME'/
C-----------------------------------------------------------------------
C                                       AIPS init
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      NCFILE = 0
      NSCR = 0
C                                       get adverbs
      NPARMS = 80
      IERR = 0
      CALL GTPARM (PRGN, NPARMS, RQUICK, XINNAM, BLBUFF, JERR)
      IF (JERR.NE.0) THEN
         RQUICK = .TRUE.
         IERR = 8
         IF (JERR.EQ.1) THEN
            GO TO 999
         ELSE
            WRITE (MSGTXT,1000) JERR, 'GET INPUT ADVERBS'
            CALL MSGWRT (8)
            END IF
         END IF
C                                       restart AIPS
      IF (RQUICK) CALL RELPOP (IERR, BLBUFF, JERR)
      IF (IERR.NE.0) GO TO 999
C                                       Hollerith -> Char
      CALL H2CHR (12, 1, XINNAM, INNAM)
      CALL H2CHR (6, 1, XINCLS, INCLS)
      TTYPE = 'BL'
      INSEQ = IROUND (XSEQ)
      INDISK = IROUND (XDISK)
      INVERS = IROUND (XVER)
      IUSER = NLUSER
      CNO = 1
      CALL CATDIR ('SRCH', INDISK, CNO, INNAM, INCLS, INSEQ, INTYP,
     *   IUSER, STAT, BLBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1010) IERR, INNAM, INCLS, INSEQ, INTYP,
     *      INDISK, IUSER
         GO TO 990
         END IF
C                                       Get catblk, mark file write
      CALL CATIO ('READ', INDISK, CNO, CATBLK, 'WRIT', BLBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READ CATALOG HEADER'
         GO TO 990
         END IF
      NCFILE = 1
      FVOL(1) = INDISK
      FCNO(1) = CNO
      FRW(1) = 1
      DO3COL = XDO3C + 0.5
      IF (XDO3C.GT.0.0) DO3COL = MAX (1, DO3COL)
C                                       Open BL table
      CALL BLREFM (INDISK, CNO, INVERS, CATBLK, BLLUN, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL BLINI ('READ', BLBUFF, INDISK, CNO, INVERS, CATBLK, BLLUN,
     *   IBLRNO, BLKOLS, BLNUMV, BLNANT, BLNPOL, BLNIF, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN INPUT BL TABLE'
         GO TO 990
         END IF
C                                       Set column pointers for sort
      CALL FNDCOL (NKEY, KEYSBL, 24, .TRUE., BLBUFF, KOLS, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1000) IERR, 'FIND BL COLUMNS'
         GO TO 990
         END IF
C                                       sort to baseline order
      J1 = 1
      J2 = 2
      IF ((BLBUFF(43).NE.KOLS(J1)) .OR. (BLBUFF(44).NE.KOLS(J2)))
     *   THEN
C                                       Close
         CALL TABIO ('CLOS', 0, IBLRNO, BLBUFF, BLBUFF, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'CLOSE Bl TABLE'
            GO TO 990
            END IF
C                                       sort
         KEY(1,1) = KOLS(J1)
         KEY(2,1) = KOLS(J1)
         KEY(1,2) = KOLS(J2)
         KEY(2,2) = KOLS(J2)
         CALL TABSRT (INDISK, CNO, 'BL', INVERS, INVERS, KEY, KEYSUB,
     *      FKEY, BLBUFF, CATBLK, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'SORT BL TABLE'
            GO TO 990
            END IF
C                                       Re-open BD table for read
         CALL BLINI ('READ', BLBUFF, INDISK, CNO, INVERS, CATBLK,
     *      BLLUN, IBLRNO, BLKOLS, BLNUMV, BLNANT, BLNPOL, BLNIF, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'OPEN SORTED BL TABLE'
            GO TO 990
            END IF
         END IF
C                                       number of records
      NBLINR = BLBUFF(5)
      BIF = IROUND (XBIF)
      BIF = MAX (1, MIN (BIF, BLNIF))
      EIF = IROUND (XEIF)
      IF ((EIF.LT.BIF) .OR. (EIF.GT.BLNIF)) EIF = BLNIF
      XBIF = BIF
      XEIF = EIF
      CALL H2CHR (4, 1, XTYPE, PTYPE)
      IF ((PTYPE.NE.'PHAS') .AND. (PTYPE.NE.'DIFA') .AND.
     *   (PTYPE.NE.'DIFP') .AND. (PTYPE.NE.'ADIF') .AND.
     *   (PTYPE.NE.'PDIF') .AND. (PTYPE.NE.'REAL') .AND.
     *   (PTYPE.NE.'IMAG') .AND. (PTYPE.NE.'DIFR') .AND.
     *   (PTYPE.NE.'DIFI')) PTYPE = 'AMP '
      CALL CHR2H (4, PTYPE, 1, XTYPE)
      IF (PTYPE.EQ.'ADIF') PTYPE = 'DIFC'
      IF (PTYPE.EQ.'PDIF') PTYPE = 'DIFB'
      CALL H2CHR (4, 1, XSTOKE, STAT)
      DOSTOK = ' '
      IF ((BLNPOL.EQ.1) .OR. (STAT(:1).EQ.'R')) THEN
         BPOL = 1
         EPOL = 1
         STAT = 'R'
      ELSE IF (STAT(:1).EQ.'L') THEN
         BPOL = 2
         EPOL = 2
         STAT = 'L'
      ELSE
         BPOL = 1
         EPOL = 2
         STAT = 'RL'
         END IF
      CALL CHR2H (4, STAT, 1, XSTOKE)
      IF (FACTOR.LE.0.0) FACTOR = 1.0
      ARANGE(1) = XRANGE(1)
      ARANGE(2) = XRANGE(2)
      TIMBEG = ((XTIME(4)/60.0 + XTIME(3)) / 60.0 + XTIME(2)) / 24.0 +
     *   XTIME(1)
      TIMEND = ((XTIME(8)/60.0 + XTIME(7)) / 60.0 + XTIME(6)) / 24.0 +
     *   XTIME(5)
      TPLBEG = TIMBEG
      TPLEND = TIMEND
      IF ((TIMEND.LE.TIMBEG) .OR. (TIMEND.LE.0.0)) THEN
         TIMEND = 9999.
         IF (TIMBEG.LE.0.0D0) TIMBEG = -100.
         END IF
      IF (PTYPE(:3).NE.'DIF') THEN
         TPLBEG = TIMBEG
         TPLEND = TIMEND
         END IF
      FQID = IROUND (XFQ)
      IF (FQID.LE.0) FQID = 1
      SUBARR = IROUND (XSUB)
      IF (SUBARR.LE.0) SUBARR = 1
      LABEL = IROUND (XLTYPE)
      CALL FILL (MAXANT, 0, IANTS)
      CALL FILL (BLNANT, 1, IANTS)
      J1 = 0
      DO 10 J = 1,50
         J2 = IROUND (XANT(J))
         IF (J2.LT.0) THEN
            J1 = J2
         ELSE IF (J1.GE.0) THEN
            J1 = MAX (J1, J2)
            END IF
 10      CONTINUE
C                                       none negative, some > 0
      NIANTS = BLNANT
      IF (J1.GT.0) THEN
         NIANTS = 0
         CALL FILL (BLNANT, 0, IANTS)
         DO 20 J = 1,50
            J2 = IROUND (XANT(J))
            IF ((J2.GT.0) .AND. (J2.LE.BLNANT)) THEN
               IF (IANTS(J2).LE.0) NIANTS = NIANTS + 1
               IANTS(J2) = 1
               END IF
 20         CONTINUE
C                                       some negative
      ELSE IF (J1.LT.0) THEN
         DO 30 J = 1,50
            J2 = IROUND (ABS (XANT(J)))
            IF ((J2.GT.0) .AND. (J2.LE.BLNANT)) THEN
               IF (IANTS(J2).GT.0) NIANTS = NIANTS - 1
               IANTS(J2) = 0
               END IF
 30         CONTINUE
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLPLTI: ERROR',I5,' ON ',A)
 1010 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I3,1X,A2,
     *   'DISK=',I2,' USER=',I5)
      END
      SUBROUTINE BLLABL (IVER, PMIN, PMAX, NREC, TTIME, IERR)
C-----------------------------------------------------------------------
C   Do the init for line drawing, ...
C   Inputs:
C      IVER    I      File version number
C      PMIN    R      Min value to plot
C      PMAX    R      Max value to plot
C      NREC    I      Number of rows
C      TIME    R      The time of the plot
C   Output:
C      IERR   I   Error code
C-----------------------------------------------------------------------
      REAL      PMIN, PMAX, TTIME
      INTEGER   IVER, NREC, IERR
C
      REAL      BLC(7), CH(4), TRC(7), X, DX, DY, DCX, DCY, XMIN, YMIN
      INTEGER   IDEPTH(5), I, IIP, IIF, XINTER(10), NP, XINT, XLO, XHI,
     *   TIME1(4), TIME2(4), INCHAR, JTRIM
      CHARACTER STRING*80, NAMSTR*20, CTIME*8, CDATE*12
      INCLUDE 'BLPLT.INC'
      INCLUDE 'DBLP.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA XINTER /2,5,10,20,50,100,200,500,1000,2000/
C-----------------------------------------------------------------------
C                                       number characters around
      LTYPE = MOD (ABS(LABEL), 100)
      IF (LTYPE.EQ.0) LTYPE = 3
      IF (LABEL.GE.0) THEN
         LABEL = (LABEL/100)*100 + LTYPE
      ELSE
         LABEL = (LABEL/100)*100 - LTYPE
         END IF
      CALL RFILL (4, 0.5, CH)
      IF (LTYPE.EQ.2) CH(1) = 2.5
      IF (LTYPE.GT.2) CH(1) = 6.5
      IF (LTYPE.GT.1) CH(2) = 2.0
      IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) CH(2) = CH(2) + 1.333
      IF (LTYPE.EQ.2) CH(3) = 2.5
      IF (LTYPE.GT.1) CH(4) = CH(4) + 1.5
      IF ((LABEL.GT.1) .AND. (LTYPE.LT.7)) CH(4) = CH(4) + 1.333
C                                       Set BLC, TRC, XYRATO.
      CALL RFILL (5, 1.0, BLC(3))
      CALL RFILL (5, 1.0, TRC(3))
      CALL FILL (5, 1, IDEPTH)
      BLC(2) = 0.0
      BLC(1) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
C                                       default XYRATIO
      IF (XYRATO.LT.0.01) THEN
         IF (XDOTV.GT.0.0) THEN
            XMIN = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1)+CH(3))
            YMIN = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2)+CH(4))
            XYRATO = 1.0
            IF (YMIN.GT.0.0) XYRATO = XMIN / YMIN
         ELSE
            XYRATO = 1.0
            END IF
         END IF
C                                       Initialize plot file line drw.
      CALL GINITL (BLC, TRC, XYRATO, CH, IDEPTH, PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL GLTYPE (1, PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Draw borders.
      CALL GPOS (BLC(1), BLC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL GVEC (TRC(1), BLC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL GVEC (TRC(1), TRC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL GVEC (BLC(1), TRC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL GVEC (BLC(1), BLC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       separate polarizations
      NP = (EPOL-BPOL+1)
      I = NP * (EIF - BIF + 3)
      DX = 1000.0 / I
      IF (NP.GT.1) THEN
         X = 0.0
         DO 20 IIP = 2,NP
            X = X + DX * (EIF - BIF + 3.5)
            CALL GPOS (X, 0.0, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GVEC (X, 1000.0, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
 20         CONTINUE
         END IF
      IF (LTYPE.LE.1) GO TO 999
C                                       Horizontal ticks
      DCY = -0.17
      IF (LTYPE.EQ.2) GO TO 100
      IIP = 8
      IF (NP.GT.1) IIP = 7 - NP
      DO 30 I = 1,10
         XINT = XINTER(I)
         XHI = (EIF / XINT) * XINT
         IF (XHI.GT.EIF) XHI = XHI - XINT
         XLO = (BIF / XINT) * XINT
         IF (XLO.LT.BIF) XLO = XLO + XINT
         IIF = (XHI - XLO) / XINT + 1
         IF (IIF.LE.IIP) GO TO 35
 30      CONTINUE
      GO TO 100
C                                       tick drawing
 35   DY = 25.
      DCY = -1.5
      DO 60 IIP = 1,NP
         DO 50 I = XLO,XHI,XINT
            X = DX * (2.0 + I - BIF) + (IIP-1) * (EIF-BIF+3) * DX
            WRITE (STRING,1035) I
            CALL CHTRIM (STRING, 4, STRING, IIF)
            DCX = -IIF + 0.5
            CALL GPOS (X, 1000.0, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GVEC (X, 1000.0-DY, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GPOS (X, DY, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GVEC (X, 0.0, PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GCHAR (IIF, 0, DCX, DCY, STRING(:IIF), PBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
 50         CONTINUE
 60      CONTINUE
C                                       POL labels
      X = DX
      DCY = -1.5
      DO 70 IIP = BPOL,EPOL
         CALL GPOS (X, TRC(2)-DY, PBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         WRITE (STRING,1060) IIP
         DCX = 1.5
         CALL GICHAR (1, 4, 0, DCX, DCY, STRING(:4), PBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         X = X + (EIF-BIF+3) * DX
 70      CONTINUE
C                                       horizontal axis label
      DCY = DCY - 1.33
      CALL GPOS (500., 0., PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      DCX = -8.5
      CALL GCHAR (16, 0, DCX, DCY, 'SPECTRAL WINDOWS', PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       vertical axis label
      CALL GPOS (0.0, 500., PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      DCX = -CH(1) + 1.0
      CALL GCHAR (14, 1, DCX, 4.5, 'SECOND ANTENNA', PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       more labels
 100  IF (LTYPE.GE.7) GO TO 999
      CDATE = ' '
      CALL H2CHR (4, 1, XSTOKE, CDATE)
      IF (CDATE.EQ.'R+L') THEN
         CDATE = '(R+L)/2'
      ELSE IF (CDATE.EQ.'R-L') THEN
         CDATE = '(R-L)/2'
      ELSE IF (CDATE.EQ.'RL') THEN
         CDATE = 'R and L'
         END IF
C                                       flux range
      IF ((PTYPE.EQ.'AMP ') .OR. (PTYPE.EQ.'DIFA') .OR.
     *   (PTYPE.EQ.'DIFC') .OR. (PTYPE.EQ.'REAL') .OR.
     *   (PTYPE.EQ.'IMAG') .OR. (PTYPE.EQ.'DIFR') .OR.
     *   (PTYPE.EQ.'DIFI')) THEN
         IF (PTYPE.EQ.'DIFC') PTYPE = 'ADIF'
         WRITE (STRING,1100) PTYPE, PMIN, PMAX, BIF, EIF, CDATE
         IF (PTYPE.EQ.'ADIF') PTYPE = 'DIFC'
      ELSE
         IF (PTYPE.EQ.'DIFB') PTYPE = 'PDIF'
         WRITE (STRING,1101) PTYPE, PMIN, PMAX, BIF, EIF, CDATE
         IF (PTYPE.EQ.'PDIF') PTYPE = 'DIFB'
         END IF
      IF (ARANGE(2).LT.ARANGE(1)) STRING(12:29) = 'self-scaled'
      DCY = DCY - 1.33
      DCX = 0.0
      CALL GPOS (0.0, 0.0, PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      INCHAR = JTRIM (STRING)
C                                       add the time
      CALL TODHMS (TTIME, TIME1)
      WRITE (CDATE,1110) TIME1
      IF (TIME1(1).GT.0) THEN
         STRING(INCHAR+2:) = '__TIME ' // CDATE
      ELSE
         STRING(INCHAR+2:) = '__TIME ' // CDATE(5:)
         END IF
      CALL REFRMT (STRING, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DCX, DCY, STRING, PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       image name etc
      CALL GPOS (BLC(1), TRC(2), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
      DCY = 0.5
      DCX = 0.0
      CALL H2CHR (12, KHIMNO, CATH(KHIMN), NAMSTR(1:12))
      CALL H2CHR (6, KHIMCO, CATH(KHIMC), NAMSTR(13:18))
      CALL NAMEST (NAMSTR, CATBLK(KIIMS), STRING, IIF)
      STRING(IIF+1:) = ' '
      IIF = IIF + 4
      IIP = XANT(1) + 0.1
      WRITE (STRING(IIF:),1122) TTYPE, INVERS, IIP
      CALL REFRMT (STRING, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DCX, DCY, STRING(:INCHAR), PBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       time/date, version
      IF (LABEL.GT.0) THEN
         CALL GPOS (BLC(1), TRC(2), PBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         CALL ZDATE (TIME1)
         CALL ZTIME (TIME2)
         CALL TIMDAT (TIME2, TIME1, CTIME, CDATE)
         WRITE (STRING,1130) IVER, CDATE, CTIME
         CALL REFRMT (STRING, '_', INCHAR)
         IIF = 51
         DCY = DCY + 1.333
         CALL GCHAR (INCHAR, 0, DCX, DCY, STRING(:INCHAR), PBUFF, IERR)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1035 FORMAT (I4)
 1060 FORMAT ('POL',I1)
 1100 FORMAT (A4,' RANGE =',F8.4,'_',F8.4,' __IFs',2I3,' __Stokes ',A)
 1101 FORMAT (A4,' RANGE =',F8.2,'_',F8.2,' __IFs',2I3,' __Stokes ',A)
 1110 FORMAT (I3,'/',I2.2,':',I2.2,':',I2.2)
 1122 FORMAT (A2,'VER',I4,' _BASELINES_TO_ANTENNA',I3)
 1130 FORMAT ('Plot file version',I4,'__created ',A,A)
      END
      SUBROUTINE BLPLTT (IERR)
C-----------------------------------------------------------------------
C   BLPLTT uses the open BL table to generate the plots.
C   Output:
C      IERR   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'BLPLT.INC'
      INCLUDE 'DBLP.INC'
      CHARACTER PFILE*48, CLABEL*4, FUNC*12
      INTEGER   I, J, J2, NREC, SOURID, SUBA, ANT1, FREQID, IP, IA,
     *   JERR, ANTS(MAXANT), THEANT, IIF, IIP, MREC, LINE, TVCHN, GRCHN,
     *   TVCORN(2), IVER, IROUND, NP, LP, ITYPE, NPLOT, NRECI, NRECC,
     *   ANT2, OTHANT, KREC, NTIMES, ITIMES
      REAL      D, DMAX, DMIN, BLSUM(3,2*MAXIF), WT, DX, DY, X0, Y0,
     *   SCALE, NSUM(2*MAXIF), X, Y, SOFF, RTIME, PSGN, PMAX, PMIN, XT,
     *   PLPTS(2*MAXIF+100), XPLPTS(2*MAXIF+100), COL(3), COLV, DCOLV,
     *   YH, PPMAX, PPMIN, LMAX, LMIN, YP, FACMUL(2,2,MAXIF),
     *   FACADD(2,2,MAXIF), TEPS, TIMES(512)
      LOGICAL   DOTV, LBLANK, SPHASE
      DOUBLE PRECISION TTIME, DTIME
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:PSTD.INC'
C-----------------------------------------------------------------------
      DTIME = 5. / 60.0 / 24.0
      THEANT = 0
      NPLOT = 0
      CURTIM = 0.0
      TEPS = 1.0 / (3600.0 * 24.0)
      NTIMES = 0
C                                       loop for next plot
 10   THEANT = THEANT + 1
      NREC = 0
      MREC = 0
      KREC = 0
C                                       find list of times
      IF (NTIMES.LE.0) THEN
         DO 20 J = 1,NBLINR
            IBLRNO = J
            CALL TABBL ('READ', BLBUFF, IBLRNO, BLKOLS, BLNUMV, BLNPOL,
     *         RTIME, SOURID, SUBA, ANT1, ANT2, FREQID, FACMUL, FACADD,
     *         IERR)
            IF (IERR.GT.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READ BL TABLE'
               GO TO 990
               END IF
            IF (((FREQID.EQ.FQID) .OR. (FREQID.LE.0)) .AND.
     *         ((SUBA.EQ.SUBARR) .OR. (SUBA.LE.0)) .AND.
     *         (RTIME.GE.TIMBEG) .AND. (RTIME.LE.TIMEND) .AND.
     *         (IANTS(ANT1).GT.0) .AND. (IANTS(ANT2).GT.0)) THEN
               DO 15 ITIMES = 1,NTIMES
                  IF (ABS(RTIME-TIMES(ITIMES)).LE.TEPS) GO TO 20
 15               CONTINUE
               NTIMES = NTIMES + 1
               TIMES(NTIMES) = RTIME
               END IF
 20         CONTINUE
         ITIMES = 1
         IF (NTIMES.LE.0) THEN
            MSGTXT = 'NO RECORDS MATCHING ADVERBS WERE FOUND'
            IERR = 1
            GO TO 990
            END IF
         END IF
      CURTIM = TIMES(ITIMES)
      IF (IANTS(THEANT).GT.0) THEN
         NIANTS = NIANTS - 1
C                                       find range of desired data
         DO 90 J = 1,NBLINR
            IBLRNO = J
            CALL TABBL ('READ', BLBUFF, IBLRNO, BLKOLS, BLNUMV, BLNPOL,
     *         RTIME, SOURID, SUBA, ANT1, ANT2, FREQID, FACMUL, FACADD,
     *         IERR)
            IF (IERR.GT.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READ BL TABLE'
               GO TO 990
               END IF
            IF (((FREQID.EQ.FQID) .OR. (FREQID.LE.0)) .AND.
     *         ((SUBA.EQ.SUBARR) .OR. (SUBA.LE.0)) .AND.
     *         (RTIME.GE.TIMBEG) .AND. (RTIME.LE.TIMEND) .AND.
     *         (IANTS(ANT1).GT.0) .AND. (IANTS(ANT2).GT.0) .AND.
     *         ((ANT1.EQ.THEANT) .OR. (ANT2.EQ.THEANT)) .AND.
     *         (ABS(RTIME-CURTIM).LE.TEPS)) THEN
               IF (NREC.EQ.0) THEN
                  KREC = 0
                  CALL FILL (MAXANT, 0, ANTS)
                  TTIME = RTIME
                  DMAX = -1.E10
                  DMIN = -DMAX
                  PPMAX = DMAX
                  PPMIN = DMIN
                  IF (PTYPE(:3).EQ.'DIF') THEN
                     I = BLNPOL * BLNIF
                     CALL RFILL (I, 0.0, NSUM)
                     I = 6 * I
                     CALL RFILL (I, 0.0, BLSUM)
                     END IF
                  END IF
C                                       check for valid data
               DO 55 IIP = BPOL,EPOL
                  DO 50 IIF = BIF,EIF
                     IF ((FACMUL(1,IIP,IIF).NE.FBLANK) .AND.
     *                  (FACMUL(2,IIP,IIF).NE.FBLANK)) GO TO 60
 50                  CONTINUE
 55               CONTINUE
               J2 = J
               IF ((PTYPE(:3).NE.'DIF') .OR. ((TIME.GE.TPLBEG) .AND.
     *            (TIME.LE.TPLEND))) THEN
                  KREC = KREC + 1
                  END IF
               GO TO 90
 60            MREC = MREC + 1
               IF (ANT1.EQ.THEANT) THEN
                  PSGN = +1.0
                  ANTS(ANT2) = J
               ELSE
                  PSGN = -1.0
                  ANTS(ANT1) = J
                  END IF
               J2 = J
               IF ((PTYPE(:3).NE.'DIF') .OR. ((TIME.GE.TPLBEG) .AND.
     *            (TIME.LE.TPLEND))) THEN
                  NREC = NREC + 1
                  KREC = KREC + 1
                  END IF
C                                       average spectrum
               IF (PTYPE(:3).EQ.'DIF') THEN
                  DO 70 IIP = BPOL,EPOL
                     DO 65 IIF = BIF,EIF
                        I = IIF + BLNIF * (IIP-1)
                        IF ((FACMUL(1,IIP,IIF).NE.FBLANK) .AND.
     *                     (FACMUL(2,IIP,IIF).NE.FBLANK)) THEN
                           BLSUM(1,I) = BLSUM(1,I) + FACMUL(1,IIP,IIF)
                           BLSUM(2,I) = BLSUM(2,I) +
     *                        PSGN*FACMUL(2,IIP,IIF)
                           BLSUM(3,I) = BLSUM(3,I) + SQRT
     *                        (FACMUL(1,IIP,IIF)**2 +
     *                        FACMUL(2,IIP,IIF)**2)
                           NSUM(I) = NSUM(I) + 1.0
                           END IF
 65                     CONTINUE
 70                  CONTINUE
C                                       or find max/min
               ELSE IF (ARANGE(2).LE.ARANGE(1)) THEN
                  DO 80 IIP = BPOL,EPOL
                     DO 75 IIF = BIF,EIF
                        I = IIF + (IIP - 1) * BLNIF
                        IF ((FACMUL(1,IIP,IIF).NE.FBLANK) .AND.
     *                     (FACMUL(2,IIP,IIF).NE.FBLANK)) THEN
                           D = 0.0
                           IF (PTYPE.EQ.'AMP ') THEN
                              D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                              FACMUL(2,IIP,IIF)**2)
                           ELSE IF (PTYPE.EQ.'REAL') THEN
                              D =  FACMUL(1,IIP,IIF)
                           ELSE IF (PTYPE.EQ.'IMAG') THEN
                              D =  FACMUL(2,IIP,IIF)
                           ELSE IF ((FACMUL(1,IIP,IIF).NE.0.0) .OR.
     *                        (FACMUL(2,IIP,IIF).NE.0.0)) THEN
                              D = ATAN2 (PSGN*FACMUL(2,IIP,IIF),
     *                           FACMUL(1,IIP,IIF)) * RAD2DG
                              END IF
                           DMAX = MAX (D, DMAX)
                           DMIN = MIN (D, DMIN)
                           IF (D.LT.0.0) D = D + 360.0
                           PPMAX = MAX (D, PPMAX)
                           PPMIN = MIN (D, PPMIN)
                           END IF
 75                     CONTINUE
 80                  CONTINUE
                  END IF
               END IF
 90         CONTINUE
         END IF
C                                       Found data
      IF ((MREC.GT.0) .AND. (NREC.GT.0)) THEN
         NREC = KREC
C                                       average spectrum
         IF (PTYPE(:3).EQ.'DIF') THEN
            DO 120 IIP = BPOL,EPOL
               DO 115 IIF = BIF,EIF
                  I = (IIP - 1) * BLNIF + IIF
                  WT = NSUM(I)
                  IF (WT.GT.0.0) THEN
                     BLSUM(3,I) = BLSUM(3,I) / WT
                     WT = SQRT (BLSUM(1,I)**2 + BLSUM(2,I)**2)
                     IF (WT.GT.0.0) WT = BLSUM(3,I) / WT
                     BLSUM(1,I) = BLSUM(1,I) * WT
                     BLSUM(2,I) = BLSUM(2,I) * WT
                     END IF
 115              CONTINUE
 120           CONTINUE
            END IF
C                                       now get scale
         IF ((PTYPE(:3).EQ.'DIF') .AND. (ARANGE(2).LE.ARANGE(1))) THEN
            DO 150 J = 1,BLNANT
               IBLRNO = ANTS(J)
               IF (IBLRNO.GT.0) THEN
                  CALL TABBL ('READ', BLBUFF, IBLRNO, BLKOLS, BLNUMV,
     *               BLNPOL, RTIME, SOURID, SUBA, ANT1, ANT2, FREQID,
     *               FACMUL, FACADD, IERR)
                  IF (IERR.GT.0) THEN
                     WRITE (MSGTXT,1000) IERR, 'READ BD TABLE'
                     GO TO 990
                     END IF
                  DO 140 IIP = BPOL,EPOL
                     DO 135 IIF = BIF,EIF
                        I = IIF + (IIP - 1) * BLNIF
                        IF (ANT1.EQ.THEANT) THEN
                           PSGN = +1.0
                        ELSE
                           PSGN = -1.0
                           END IF
                        IF ((FACMUL(1,IIP,IIF).NE.FBLANK) .AND.
     *                     (FACMUL(2,IIP,IIF).NE.FBLANK) .AND.
     *                     (NSUM(I).GT.0.0)) THEN
                           D = 0.0
                           IF (PTYPE.EQ.'DIFC') THEN
                              D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                           FACMUL(2,IIP,IIF)**2) - SQRT
     *                           (BLSUM(1,I)**2 + BLSUM(2,I)**2)
                           ELSE IF (PTYPE.EQ.'DIFB') THEN
                              IF (((FACMUL(1,IIP,IIF).NE.0.0) .OR.
     *                           (FACMUL(2,IIP,IIF).NE.0.0)) .AND.
     *                           ((BLSUM(1,I).NE.0.0) .OR.
     *                           (BLSUM(2,I).NE.0.0))) THEN
                                 D =(ATAN2 (PSGN*FACMUL(2,IIP,IIF),
     *                              FACMUL(1,IIP,IIF)) - ATAN2
     *                              (BLSUM(2,I), BLSUM(1,I))) * RAD2DG
                                 IF (D.LT.-180.0) D = D + 360.0
                                 IF (D.GT.180.0) D = D - 360.0
                                 END IF
                           ELSE
                              FACMUL(1,IIP,IIF) = FACMUL(1,IIP,IIF) -
     *                           BLSUM(1,I)
                              FACMUL(2,IIP,IIF) = PSGN*FACMUL(2,IIP,IIF)
     *                           - BLSUM(2,I)
                              IF (PTYPE.EQ.'DIFA') THEN
                                 D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                              FACMUL(2,IIP,IIF)**2)
                              ELSE IF (PTYPE.EQ.'DIFR') THEN
                                 D =  FACMUL(1,IIP,IIF)
                              ELSE IF (PTYPE.EQ.'DIFI') THEN
                                 D =  FACMUL(2,IIP,IIF)
                              ELSE IF ((FACMUL(1,IIP,IIF).NE.0.0) .OR.
     *                           (FACMUL(2,IIP,IIF).NE.0.0)) THEN
                                 D = ATAN2 (PSGN*FACMUL(2,IIP,IIF),
     *                              FACMUL(1,IIP,IIF)) * RAD2DG
                                 END IF
                              END IF
                           DMAX = MAX (D, DMAX)
                           DMIN = MIN (D, DMIN)
                           IF (D.LT.0.0) D = D + 360.0
                           PPMAX = MAX (D, PPMAX)
                           PPMIN = MIN (D, PPMIN)
                           END IF
 135                    CONTINUE
 140                 CONTINUE
                  END IF
 150           CONTINUE
            END IF
C                                       set scale, blank array
         I = MAXCIF + 100
         CALL RFILL (I, 0.0, XPLPTS)
         IF (ARANGE(2).GT.ARANGE(1)) THEN
            PMIN = XRANGE(1)
            PMAX = XRANGE(2)
            SPHASE = PMIN.GE.0.0
         ELSE
            IF (DMAX-DMIN.LE.PPMAX-PPMIN) THEN
               PMIN = DMIN
               PMAX = DMAX
               SPHASE = .FALSE.
            ELSE
               PMIN = PPMIN
               PMAX = PPMAX
               SPHASE = .TRUE.
               END IF
            XRANGE(1) = PMIN
            XRANGE(2) = PMAX
            END IF
         IF (PMIN.EQ.PMAX) THEN
            IF (PMIN.EQ.0.0) THEN
               PMAX = 1.
               PMIN = -1.
            ELSE
               PMAX = 1.03 * PMIN
               PMIN = 0.97 * PMIN
               END IF
            END IF
C                                       now init the plot
         DOTV = XDOTV.GT.0.0
         TVCHN = 0
         TVCORN(1) = 0
         TVCORN(2) = 0
         GRCHN = IROUND (XCHAN)
         PLUN = 26
         IVER = 0
         IF (.NOT.DOTV) THEN
            CALL MADDEX ('PL', INDISK, CNO, CATBLK, PBUFF, .TRUE.,
     *         'WRIT', IVER, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'CREATE PLOT FILE'
               CALL MSGWRT (7)
               GO TO 999
               END IF
            END IF
C                                       time/antenna adverbs to match
C                                       one antenna
         CALL RFILL (50, 0.0, XANT)
         XANT(1) = THEANT
         CALL ZPHFIL ('PL', INDISK, CNO, IVER, PFILE, IERR)
         ITYPE = 59
         CALL GINIT (INDISK, CNO, PFILE, 0, ITYPE, NPARMS, XINNAM, DOTV,
     *      TVCHN, GRCHN, TVCORN, CATBLK, PBUFF, PLUN, PFIND, IERR)
         FUNC = 'GINIT'
         IF (IERR.NE.0) GO TO 900
         CALL BLLABL (IVER, PMIN, PMAX, NREC, CURTIM, IERR)
         FUNC = 'BLLABL'
         IF (IERR.NE.0) GO TO 900
         DY = 1000.0 / (NREC + FACTOR)
         NP = (EPOL-BPOL+1)
         DX = NP * (EIF-BIF+3)
         DX = 1000.0 / DX
         X0 = DX / 2.0
         Y0 = -DY / 2.0
         XT = MAX (X0, 17.5)
         DCOLV = 0.97 / MAX (1, NREC-1)
         IF (DO3COL.EQ.2) DCOLV = 0.97 / (PMAX - PMIN)
         COLV = 0.97
C                                       get the data part
C        MREC = J2 - J1 + 1
         MREC = NREC
         IA = 0
         LINE = 0
         NRECC = 0
         NRECI = MAX (1, NREC / 20)
         DO 290 J = 1,BLNANT
            IBLRNO = ANTS(J)
            IF (IBLRNO.GT.0) THEN
               CALL TABBL ('READ', BLBUFF, IBLRNO, BLKOLS, BLNUMV,
     *            BLNPOL, RTIME, SOURID, SUBA, ANT1, ANT2, FREQID,
     *            FACMUL, FACADD, IERR)
               IF (IERR.GT.0) THEN
                  WRITE (MSGTXT,1000) IERR, 'READ BD TABLE'
                  GO TO 990
                  END IF
               NRECC = NRECC + 1
               IF (DO3COL.EQ.1) THEN
                  CALL COLOR3 (COLV, .FALSE., COL)
                  COLV = COLV - DCOLV
                  CALL G3VCOL (COL(1), COL(2), COL(3), PBUFF, IERR)
                  FUNC = 'G3VCOL'
                  IF (IERR.NE.0) GO TO 900
                  END IF
               IF (ANT1.EQ.THEANT) THEN
                  OTHANT = ANT2
                  PSGN = +1.0
               ELSE
                  OTHANT = ANT1
                  PSGN = -1.0
                  END IF
               Y0 = Y0 + DY
               IP = 0
               LINE = LINE + 1
               LMAX = -1.E10
               LMIN = 1.E10
               DO 240 IIP = BPOL,EPOL
                  IP = IP + 1
                  PLPTS(IP) = FBLANK
                  DO 235 IIF = BIF,EIF
                     I = IIF + (IIP - 1) * BLNIF
                     IP = IP + 1
                     D = FBLANK
                     IF ((FACMUL(1,IIP,IIF).NE.FBLANK) .AND.
     *                  (FACMUL(1,IIP,IIF).NE.0.0)) THEN
                        IF (PTYPE(:3).EQ.'DIF') THEN
                           IF (NSUM(I).GT.0.0) THEN
                              D = 0.0
                              IF (PTYPE.EQ.'DIFC') THEN
                                 D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                              FACMUL(2,IIP,IIF)**2) - SQRT
     *                              (BLSUM(1,I)**2 + BLSUM(2,I)**2)
                              ELSE IF (PTYPE.EQ.'DIFB') THEN
                                 IF (((FACMUL(1,IIP,IIF).NE.0.0) .OR.
     *                              (FACMUL(2,IIP,IIF).NE.0.0)) .AND.
     *                              ((BLSUM(1,I).NE.0.0) .OR.
     *                              (BLSUM(2,I).NE.0.0))) THEN
                                    D = (ATAN2 (PSGN*FACMUL(2,IIP,IIF),
     *                                 FACMUL(1,IIP,IIF)) - ATAN2
     *                                 (BLSUM(2,I), BLSUM(1,I))) *RAD2DG
                                    IF (D.LT.-180.0) D = D + 360.0
                                    IF (D.GT.180.0) D = D - 360.0
                                    IF ((SPHASE) .AND. (D.LT.0.0))
     *                                 D = D + 360.0
                                    END IF
                              ELSE
                                 FACMUL(1,IIP,IIF) = FACMUL(1,IIP,IIF) -
     *                              BLSUM(1,I)
                                 FACMUL(2,IIP,IIF) = FACMUL(2,IIP,IIF) *
     *                              PSGN - BLSUM(2,I)
                                 IF (PTYPE.EQ.'DIFA') THEN
                                    D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                                 FACMUL(2,IIP,IIF)**2)
                                 ELSE IF (PTYPE.EQ.'DIFR') THEN
                                    D =  FACMUL(1,IIP,IIF)
                                 ELSE IF (PTYPE.EQ.'DIFI') THEN
                                    D =  FACMUL(2,IIP,IIF)
                                 ELSE IF ((FACMUL(1,IIP,IIF).NE.0.0).OR.
     *                              (FACMUL(2,IIP,IIF).NE.0.0)) THEN
                                    D = ATAN2 (PSGN * FACMUL(2,IIP,IIF),
     *                                 FACMUL(1,IIP,IIF)) * RAD2DG
                                    IF ((SPHASE) .AND. (D.LT.0.0))
     *                                 D = D + 360.0
                                    END IF
                                 END IF
                              END IF
                        ELSE
                           D = 0.0
                           IF (PTYPE.EQ.'AMP') THEN
                              D =  SQRT (FACMUL(1,IIP,IIF)**2 +
     *                           FACMUL(2,IIP,IIF)**2)
                           ELSE IF (PTYPE.EQ.'REAL') THEN
                              D =  FACMUL(1,IIP,IIF)
                           ELSE IF (PTYPE.EQ.'IMAG') THEN
                              D =  FACMUL(2,IIP,IIF)
                           ELSE IF ((FACMUL(1,IIP,IIF).NE.0.0) .OR.
     *                        (FACMUL(2,IIP,IIF).NE.0.0)) THEN
                              D = ATAN2 (PSGN*FACMUL(2,IIP,IIF),
     *                           FACMUL(1,IIP,IIF)) * RAD2DG
                              IF ((SPHASE) .AND. (D.LT.0.0))
     *                           D = D + 360.0
                              END IF
                           END IF
                        END IF
                     IF ((D.NE.FBLANK) .AND. ((D.LT.PMIN) .OR.
     *                  (D.GT.PMAX))) D = FBLANK
                     IF (D.NE.FBLANK) THEN
                        LMAX = MAX (LMAX, D)
                        LMIN = MIN (LMIN, D)
                        END IF
                     PLPTS(IP) = D
 235                 CONTINUE
                  IP = IP + 1
                  PLPTS(IP) = FBLANK
 240              CONTINUE
               IF (ARANGE(2).GE.ARANGE(1)) THEN
                  LMAX = PMAX
                  LMIN = PMIN
                  END IF
               IF (DO3COL.EQ.2) DCOLV = 0.97 / (LMAX - LMIN)
C                                       Do the plot now
               SCALE = DY * FACTOR / (LMAX - LMIN)
C                                       Don't label if too crowded
               IF (MOD(NRECC-1,NRECI).EQ.0) THEN
                  IF ((LMAX.GE.0.0) .AND. (LMIN.LE.0.0)) THEN
                     SOFF = Y0 - LMIN * SCALE
                     IF (DO3COL.GE.2) COLV = LMAX * DCOLV
                  ELSE
                     SOFF = Y0 + 0.5 * DY * FACTOR
                     IF (DO3COL.GE.2) COLV = 0.5
                     END IF
                  CALL GLTYPE (1, PBUFF, IERR)
                  FUNC = 'GLTYPE'
                  IF (IERR.NE.0) GO TO 900
                  IF (DO3COL.GE.2) THEN
                     CALL COLOR3 (COLV, .FALSE., COL)
                     CALL G3VCOL (COL(1), COL(2), COL(3), PBUFF, IERR)
                     FUNC = 'G3VCOL'
                     IF (IERR.NE.0) GO TO 900
                     END IF
                  FUNC = 'GPOS/VECs'
                  X = 0.0
                  DO 245 LP = 2,NP
                     X = X + DX
                     CALL GPOS (X+XT, SOFF, PBUFF, IERR)
                     IF (IERR.NE.0) GO TO 900
                     IF (DO3COL.GT.0.0) THEN
                        CALL G3VEC (X-XT, SOFF, PBUFF, IERR)
                     ELSE
                        CALL GVEC (X-XT, SOFF, PBUFF, IERR)
                        END IF
                     IF (IERR.NE.0) GO TO 900
 245                 CONTINUE
                  CALL GPOS (1000.0, SOFF, PBUFF, IERR)
                  IF (IERR.NE.0) GO TO 900
                  CALL GVEC (1000.0-XT, SOFF, PBUFF, IERR)
                  IF (IERR.NE.0) GO TO 900
                  CALL GPOS (XT, SOFF, PBUFF, IERR)
                  IF (IERR.NE.0) GO TO 900
                  CALL GVEC (0.0, SOFF, PBUFF, IERR)
                  IF (IERR.NE.0) GO TO 900
                  IF (LTYPE.GT.2) THEN
                     FUNC = 'GCHAR'
                     WRITE (CLABEL,1240) OTHANT
                     I = 1
                     IF (OTHANT.LE.9) I = 2
                     Y = -(3-I) - 0.5
                     CALL GCHAR (3-I, 0, Y, -0.5, CLABEL(I:4), PBUFF,
     *                  IERR)
                     IF (IERR.NE.0) GO TO 900
                     END IF
                  END IF
               CALL GLTYPE (2, PBUFF, IERR)
               FUNC = 'GLTYPE'
               IF (IERR.NE.0) GO TO 900
               LBLANK = .TRUE.
               X = X0
               DO 250 I = 1,IP
                  IF (PLPTS(I).EQ.FBLANK) THEN
                     LBLANK = .TRUE.
                     X = X + DX
                  ELSE
                     Y = Y0 + (PLPTS(I)-LMIN) * SCALE
                     IF ((LBLANK) .OR. (Y.LT.XPLPTS(I))) THEN
                        CALL GPOS (X, Y, PBUFF, IERR)
                        IF (DO3COL.GE.2) THEN
                           YP = Y
                           COLV = (LMAX-PLPTS(I)) * DCOLV
                           CALL COLOR3 (COLV, .FALSE., COL)
                           CALL G3VCOL (COL(1), COL(2), COL(3), PBUFF,
     *                        IERR)
                           FUNC = 'G3VCOL'
                           IF (IERR.NE.0) GO TO 900
                           END IF
                     ELSE IF (DO3COL.GE.2) THEN
                        YH = (YP + Y) / 2.0
                        CALL G3VEC (X, YH, PBUFF, IERR)
                        YP = Y
                        COLV = (LMAX-PLPTS(I)) * DCOLV
                        CALL COLOR3 (COLV, .FALSE., COL)
                        CALL G3VCOL (COL(1), COL(2), COL(3), PBUFF,
     *                     IERR)
                        FUNC = 'G3VCOL'
                        IF (IERR.NE.0) GO TO 900
                        CALL G3VEC (X, Y, PBUFF, IERR)
                     ELSE IF (DO3COL.EQ.1) THEN
                        CALL G3VEC (X, Y, PBUFF, IERR)
                     ELSE
                        CALL GVEC (X, Y, PBUFF, IERR)
                        END IF
                     FUNC = 'GVEC'
                     IF (IERR.NE.0) GO TO 900
                     LBLANK = .FALSE.
                     X = X + DX
                     IF (Y.LT.XPLPTS(I)) THEN
                        CALL GPOS (X, Y, PBUFF, IERR)
                     ELSE IF (DO3COL.GT.0.0) THEN
                        CALL G3VEC (X, Y, PBUFF, IERR)
                        XPLPTS(I) = Y
                     ELSE
                        CALL GVEC (X, Y, PBUFF, IERR)
                        XPLPTS(I) = Y
                        END IF
                     IF (IERR.NE.0) GO TO 900
                     END IF
 250              CONTINUE
               END IF
 290        CONTINUE
C                                       finish plot and continue?
         GPHPAG = (DOTV) .AND. (J2.LT.NBLINR) .AND. (NIANTS.GT.0)
         CALL GFINIS (PBUFF, IERR)
C                                       Successful plot file finished.
         IF (IERR.LE.0) THEN
            NPLOT = NPLOT + 1
            IF (.NOT.DOTV) THEN
               CALL HIPLOT (INDISK, CNO, IVER, PBUFF, I)
               WRITE (MSGTXT,1290) IVER
               CALL MSGWRT (5)
               END IF
            END IF
         END IF
C                                       loop
      IF ((THEANT.LT.BLNANT) .AND. (IERR.EQ.0)) GO TO 10
      IF (IERR.EQ.0) THEN
         ITIMES = ITIMES + 1
         IF (ITIMES.LE.NTIMES) THEN
            THEANT = 0
            GO TO 10
            END IF
         END IF
      IF (NPLOT.GT.0) THEN
         IERR = 0
      ELSE
         IERR = 1
         MSGTXT = 'But no plots were done'
         CALL MSGWRT (7)
         END IF
      IERR = MAX (0, IERR)
C                                       close
      CALL TABBL ('CLOS', BLBUFF, IBLRNO, BLKOLS, BLNUMV, BLNPOL, RTIME,
     *   SOURID, SUBA, ANT1, ANT2, FREQID, FACMUL, FACADD, JERR)
      GO TO 999
C                                       plotter error
 900  WRITE (MSGTXT,1900) IERR, FUNC
      CALL MSGWRT (8)
      MSGTXT = 'WILL TRY TO SAVE PARTIAL GRAPH'
      CALL MSGWRT (8)
      GPHPAG = .FALSE.
      CALL GFINIS (PBUFF, I)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BDLOTT: ERROR',I5,' ON ',A)
 1240 FORMAT (I2)
 1290 FORMAT ('Successful plot file version',I5,' written')
 1900 FORMAT ('BDLOTT PLOTTING ERROR',I5,' AT ',A)
      END
