LOCAL INCLUDE 'PFTARS.INC'
      INTEGER   MAXCMP, MAXPRM, MXPAIR, MAXLIS, NPLIM, NMXIMG, NCOLRM
      PARAMETER (MAXCMP=4)
      PARAMETER (MAXPRM=4*MAXCMP)
      PARAMETER (MXPAIR=(((MAXCMP-1)*MAXCMP)/2))
      PARAMETER (MAXLIS = 1000)
      PARAMETER (NPLIM=8193)
      PARAMETER (NMXIMG=12)
      PARAMETER (NCOLRM=14)
LOCAL END
LOCAL INCLUDE 'FTARS.INC'
      INCLUDE 'INCS:PMAD.INC'
      INCLUDE 'PFTARS.INC'
C                                       Local include for XFTARS
      REAL      XNIT, XCOMPS, DOSPIX(4), RMSLIM
      HOLLERITH XINFIL(12), XOUFIL(12)
      CHARACTER INFILE*48, OUFILE*48
      DOUBLE PRECISION XVOFF
      REAL      PLTMIN, PLTMAX, QURANG(2,4), L2RANG(2), RMRANG(2,3)
      LOGICAL   RMNEW, ICUBE, ISIIMG
      INTEGER   DOCOMP(MAXPRM), GCODE, SCRTCH(4096),
     *   PSTART, NCOMPS, TVSUP,
     *   PIXLIS(2,MAXLIS), NLIST, IPL(2), SUBWIN(4)
      COMMON /INPARM/ XINFIL, XOUFIL, XNIT, XCOMPS, DOSPIX, RMSLIM
      COMMON /RMACHR/ INFILE, OUFILE
      COMMON /TPARMS/ XVOFF, DOCOMP, GCODE, RMNEW, PSTART,
     *   TVSUP, PIXLIS, NLIST, IPL,
     *   NCOMPS, ICUBE, ISIIMG, SUBWIN, PLTMIN, PLTMAX,
     *   QURANG, L2RANG, RMRANG, SCRTCH
C                                                          End FTARS
LOCAL END
LOCAL INCLUDE 'FTARSD.INC'
      INCLUDE 'PFTARS.INC'
C
      DOUBLE PRECISION QDATA(NPLIM), UDATA(NPLIM), LAMSQ(NPLIM),
     *   AMDATA(NPLIM), PHDATA(NPLIM), RMDATA(NPLIM), LAMSQ1,
     *   PDATA(NPLIM), ADATA(NPLIM)
      REAL      ORANGE(2,5), XBAR, XRANGE(2,2), THERMS(2,2), PRANGE(2,2)
      INTEGER   NITTER, ITTER, LLCOMP(MAXPRM), IGR1, IGR2, IGR3,
     *   IGR4, IGR5, TTYLUN, TTYIND, IGLUN, IGFIND, PLTBLK(256),
     *   PLPOS(7), NVAR, IVAR(MAXPRM), JVAR(MAXPRM), SPIXDO, QUPTS,
     *   RMPTS
      LOGICAL   WASREI, NOWREI, PLOTPA
      COMMON /GDATA/ QDATA, UDATA, AMDATA, PHDATA, RMDATA, LAMSQ,
     *   PDATA, ADATA, LAMSQ1, XBAR, NITTER, ITTER, LLCOMP, IGR1, IGR2,
     *   IGR3, IGR4, IGR5, TTYLUN, TTYIND, ORANGE, XRANGE,
     *   IGLUN, IGFIND, PLTBLK, PLPOS, WASREI, NOWREI, NVAR, IVAR, JVAR,
     *   THERMS, SPIXDO, PRANGE, PLOTPA, QUPTS, RMPTS
      INCLUDE 'INCS:PSTD.INC'
LOCAL END
      PROGRAM FTARS
C-----------------------------------------------------------------------
C! Fits 1-D polarization curves to rows of an image.
C# Map Spectral
C-----------------------------------------------------------------------
C;  Copyright (C) 2020-2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   FTARS fits 1-dimensional polarization functions to Q/U spectra.
C   It fits up to 4 components   It will display the data, initial
C   guess, model, and residual for each row on the TV.  After each fit
C   so displayed, it asks for permission to keep the results.  If NCOMPS
C   > 1, it asks for permission to keep the initial guess and will accept
C   TV cursor input of a new initial guess on that.
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INFILE         INFILE        Q/U spectrum
C      OUTFILE        OUFILE        RM spectrum
C      NITER          XNIT          Limit on iterations in fit
C      NCOMPS         NCOMPS        Number of Components
C      DOSPIX(4)                    spix or thickness
C   Programmer Eric W. Greisen
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, IERR
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA PRGM /'FTARS '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL FTARIN (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       inits, open TV
      CALL YINIT (SCRTCH, IRET)
      IF (IRET.GT.0) GO TO 990
C                                       routine that does the fit
      CALL FTARDO (IRET)
C                                       close devices
      CALL TVCLOS (SCRTCH, IERR)
C                                       Close down files, etc.
 990  CALL DIE (IRET, SCRTCH)
C
 999  STOP
      END
      SUBROUTINE FTARIN (PRGN, IRET)
C-----------------------------------------------------------------------
C   FTARIN gets input parameters for FTARS and creates an output table
C   if needed for the fitting results, filling it with flux values.
C   Inputs:
C      PRGN   C*6   Program name
C   Output:
C      IRET   I     Error code: 0 => ok
C                     4 => user routine detected error.
C                     5 => catalog troubles
C                     8 => can't start
C      /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      CHARACTER PRGN*6
      INTEGER   IRET
C
      CHARACTER PHNAME*48
      INTEGER   IERR, NPARM, IROUND, I, TVCORN(2), J, K, NUMSP, NUMTH,
     *   DISKIN, OLDCNO, CATBLK(256)
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA TVCORN /2*0/
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      IRET = 0
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      TTYLUN = 5
      TTYIND = 0
C                                       Get input parameters.
      NPARM = 31
      CALL GTPARM (PRGN, NPARM, RQUICK, XINFIL, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         IRET = 8
         IF (IERR.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
         CALL MSGWRT (8)
         END IF
      RQUICK = .FALSE.
      IF ((NPOPS.GT.NINTRN) .AND. (NTVDEV.LE.0)) THEN
         MSGTXT = 'I CANNOT RUN IN BATCH'
         IRET = 8
         CALL MSGWRT (8)
         GO TO 999
         END IF
      RQUICK = .FALSE.
      IRET = 5
C                                       Crunch input parameters.
C                                       Characters
      CALL H2CHR (48, 1, XINFIL, INFILE)
      CALL H2CHR (48, 1, XOUFIL, OUFILE)
      IF (RMSLIM.LE.0.0) RMSLIM = 1000.
C                                       get the data
      CALL READIT (IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Component parms
      NCOMPS = XCOMPS + 0.01
      NCOMPS = MIN (4, MAX (1, NCOMPS))
      XCOMPS = NCOMPS
      CALL FILL (MAXPRM, -1, DOCOMP)
      J = 0
      NUMSP = 0
      NUMTH = 0
      SPIXDO = 0
      DO 45 I = 1,NCOMPS
         K = IROUND (DOSPIX(I))
         IF (K.EQ.1) THEN
            NUMSP = NUMSP + 1
         ELSE IF ((K.GE.2) .AND. (K.LE.4)) THEN
            NUMTH = NUMTH + 1
            IF (NUMTH.EQ.1) THEN
               SPIXDO = K
            ELSE IF (SPIXDO.NE.K) THEN
               MSGTXT = 'CANNOT MIX DIFFERENT THICKNESS MODEL TYPES'
               GO TO 990
               END IF
         ELSE
            K = 0
            END IF
         DOSPIX(I) = K
 45      CONTINUE
      IF ((NUMSP.GT.0) .AND. (NUMTH.GT.0)) THEN
         MSGTXT = 'CANNOT MIX SPECTRAL INDEX AND THICKNESS FITS'
         GO TO 990
         END IF
      IF (NUMSP.GT.0) SPIXDO = 1
      K = 1
      DO 50 I = 1,NCOMPS
         DOCOMP(J+1) = 1
         DOCOMP(J+2) = 1
         DOCOMP(J+3) = 1
         K = K + 3
         IF (DOSPIX(I).GE.0.5) DOCOMP(J+4) = 1
         IF (DOSPIX(I).GE.0.5) K = K + 1
         J = J + 4
 50      CONTINUE
      CALL COPY (MAXPRM, DOCOMP, LLCOMP)
C                                       Check input size
      IRET = 0
      IF (XNIT.LT.10.) XNIT = 100 * XCOMPS
      IF (QUPTS.LE.K) THEN
         IRET = 10
         WRITE (MSGTXT,1050) K
         GO TO 990
         END IF
C                                       set up plotting
      DISKIN = 1
      OLDCNO = 1
      CALL FILL (256, 0, CATBLK)
      CALL GINIT (DISKIN, OLDCNO, PHNAME, 0, 0, NPARM, XINFIL, .TRUE.,
     *   0, 0, TVCORN, CATBLK, PLTBLK, IGLUN, IGFIND, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TV PLOT'
         GO TO 990
         END IF
      PLOTPA = .FALSE.
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('FTARIN: ERROR',I3,' ON ',A)
 1050 FORMAT ('REQUIRES AT LEAST',I4,' PIXELS TO DO FIT')
      END
      SUBROUTINE READIT (IRET)
C-----------------------------------------------------------------------
C   Fills all data arrays
C   Outputs:
C      IRET    I      Error code
C   Common out:
C      LAMSQ   D(*)   wavelength squared (meters ^2)
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      INTEGER   LUN, FIND, JTRIM, KBP, KBPLIM, I, J
      CHARACTER LINE*132
      LOGICAL   ISAMP
      DOUBLE PRECISION X, XR, XI, SCALE(2)
      INCLUDE 'DDCH.INC'
      INCLUDE 'DMSG.INC'
      INCLUDE 'PSTD.INC'
C-----------------------------------------------------------------------
      QURANG(1,1) = 1.0E10
      QURANG(2,1) = -1.E10
      CALL RCOPY (6, QURANG, QURANG(1,2))
      CALL RCOPY (2, QURANG, L2RANG)
      CALL RCOPY (6, QURANG, RMRANG)
C                                       Read Q and U
      LUN = 10
      CALL ZTXOPN ('READ', LUN, FIND, INFILE, .FALSE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN Q/U DATA FILE'
         GO TO 990
         END IF
      QUPTS = 0
 10   CALL ZTXIO ('READ', LUN, FIND, LINE, IRET)
      IF (IRET.EQ.2) THEN
         GO TO 20
      ELSE IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING Q/U DATA FILE'
         GO TO 990
      ELSE
         KBPLIM = JTRIM (LINE)
         IF ((KBPLIM.LE.0) .OR. (LINE(:1).EQ.';') .OR.
     *      (LINE(:1).EQ.'#')) GO TO 10
         KBP = 1
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF ((X.LE.0.0D0) .OR. (X.EQ.DBLANK)) GO TO 10
         LAMSQ(QUPTS+1) = (VELITE / X) ** 2
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         QDATA(QUPTS+1) = X
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         UDATA(QUPTS+1) = X
         QUPTS = QUPTS + 1
         ADATA(QUPTS) = SQRT (QDATA(QUPTS)**2 + UDATA(QUPTS)**2)
         PDATA(QUPTS) = 0.0D0
         IF (ADATA(QUPTS).GT.0.0D0) PDATA(QUPTS) = RAD2DG *
     *      ATAN2 (UDATA(QUPTS), QDATA(QUPTS)) / 2.0D0
         IF (L2RANG(1).GT.LAMSQ(QUPTS)) L2RANG(1) = LAMSQ(QUPTS)
         IF (L2RANG(2).LT.LAMSQ(QUPTS)) L2RANG(2) = LAMSQ(QUPTS)
         IF (QURANG(1,1).GT.QDATA(QUPTS)) QURANG(1,1) = QDATA(QUPTS)
         IF (QURANG(2,1).LT.QDATA(QUPTS)) QURANG(2,1) = QDATA(QUPTS)
         IF (QURANG(1,2).GT.UDATA(QUPTS)) QURANG(1,2) = UDATA(QUPTS)
         IF (QURANG(2,2).LT.UDATA(QUPTS)) QURANG(2,2) = UDATA(QUPTS)
         IF (QURANG(1,3).GT.ADATA(QUPTS)) QURANG(1,3) = ADATA(QUPTS)
         IF (QURANG(2,3).LT.ADATA(QUPTS)) QURANG(2,3) = ADATA(QUPTS)
         IF (QURANG(1,4).GT.PDATA(QUPTS)) QURANG(1,4) = PDATA(QUPTS)
         IF (QURANG(2,4).LT.PDATA(QUPTS)) QURANG(2,4) = PDATA(QUPTS)
         IF (QUPTS.LT.NPLIM) GO TO 10
         END IF
      MSGTXT = 'Q/U FILE TRUNCATED AT 8193 SAMPLES'
      CALL MSGWRT (7)
C                                       close it up
 20   CALL ZTXCLS (LUN, FIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE Q/U DATA FILE'
         GO TO 990
         END IF
      WRITE (MSGTXT,1020) QUPTS
      CALL MSGWRT (4)
C                                       Read RM file
      CALL ZTXOPN ('READ', LUN, FIND, OUFILE, .FALSE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN RM DATA FILE'
         GO TO 990
         END IF
      RMPTS = 0
 30   CALL ZTXIO ('READ', LUN, FIND, LINE, IRET)
      IF (IRET.EQ.2) THEN
         GO TO 50
      ELSE IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING RM DATA FILE'
         GO TO 990
      ELSE
         KBPLIM = JTRIM (LINE)
         IF (KBPLIM.LE.0) GO TO 30
         IF (LINE(:5).EQ.';   K') THEN
            IF (RMPTS.GT.0) THEN
               MSGTXT = 'NOT READING RM SPECTRA AFTER THE FIRST'
               CALL MSGWRT (7)
               GO TO 50
            END IF
            I = INDEX (LINE, '10^')
            I = I + 3
            READ (LINE(I:I),1030) J
            SCALE(1) = 10.0D0 ** (-J)
            I = INDEX (LINE, 'PHASE')
            IF (I.GT.0) THEN
               ISAMP = .TRUE.
               SCALE(2) = 1.0
            ELSE
               ISAMP = .FALSE.
               SCALE(2) = SCALE(1)
            END IF
            END IF
         IF ((LINE(:1).EQ.';') .OR. (LINE(:1).EQ.'#')) GO TO 30
         KBP = 1
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         RMDATA(RMPTS+1) = X
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         XR = X
         CALL GETNUM (LINE, KBPLIM, KBP, X)
         IF (X.EQ.DBLANK) GO TO 10
         XI = X
         IF (ISAMP) THEN
            AMDATA(RMPTS+1) = XR * SCALE(1)
            PHDATA(RMPTS+1) = XI
         ELSE
            AMDATA(RMPTS+1) = SQRT (XR*XR + XI*XI) * SCALE(1)
            PHDATA(RMPTS+1) = 0.0D0
            IF (AMDATA(RMPTS+1).GT.0.0D0) PHDATA(RMPTS+1) =
     *         RAD2DG * ATAN2 (XI, XR)
            END IF
         RMPTS = RMPTS + 1
         IF (RMRANG(1,1).GT.RMDATA(RMPTS)) RMRANG(1,1) = RMDATA(RMPTS)
         IF (RMRANG(2,1).LT.RMDATA(RMPTS)) RMRANG(2,1) = RMDATA(RMPTS)
         IF (RMRANG(1,2).GT.AMDATA(RMPTS)) RMRANG(1,2) = AMDATA(RMPTS)
         IF (RMRANG(2,2).LT.AMDATA(RMPTS)) RMRANG(2,2) = AMDATA(RMPTS)
         IF (RMRANG(1,3).GT.PHDATA(RMPTS)) RMRANG(1,3) = PHDATA(RMPTS)
         IF (RMRANG(2,3).LT.PHDATA(RMPTS)) RMRANG(2,3) = PHDATA(RMPTS)
         IF (RMPTS.LT.NPLIM) GO TO 30
         END IF
      MSGTXT = 'RM FILE TRUNCATED AT 8193 SAMPLES'
      CALL MSGWRT (7)
C                                       Close up
 50   CALL ZTXCLS (LUN, FIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE RM DATA FILE'
         GO TO 990
         END IF
      WRITE (MSGTXT,1050) RMPTS
      CALL MSGWRT (4)
      XRANGE(1,1) = L2RANG(1)
      XRANGE(2,1) = L2RANG(2)
      XRANGE(1,2) = RMRANG(1,1)
      XRANGE(2,2) = RMRANG(2,1)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('READIT ERROR',I4,' ON ',A)
 1020 FORMAT ('Read',I5,' spectral samples of Q and U')
 1030 FORMAT (I1)
 1050 FORMAT ('Read',I5,' samples of the RM spectrum')
      END
      SUBROUTINE FTARDO (IRET)
C-----------------------------------------------------------------------
C   FTARDO sends data to fitting routine using the input initial guess.
C   Output:
C      IRET   I    Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      INTEGER   I1, IPOS(7), IG, NCMP, I, J
      REAL      RESULT(MAXPRM,2)
      DOUBLE PRECISION PARMS(MAXPRM), UPARMS(MAXPRM), XPARMS(MAXPRM)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
C                                       Initial guess
      CALL DFILL (MAXPRM, 0.0D0, PARMS)
      CALL DFILL (MAXPRM, 0.0D0, UPARMS)
      CALL DFILL (MAXPRM, 0.0D0, XPARMS)
      IF (SPIXDO.GE.2) THEN
         DO 16 I = 1,MAXCMP
            UPARMS(4*I) = 10.0D0
 16         CONTINUE
         END IF
      CALL COPY (MAXPRM, DOCOMP, LLCOMP)
      MSGTXT = 'FTARDO: solving spectra to/from TARS'
      CALL MSGWRT (2)
C                                       Setup for looping
C                                       Loop
      CALL FILL (7, 1, IPOS)
C                                       Call DO1FIT
      CALL DO1FIT (IPOS, UPARMS, PARMS, XPARMS, NCMP, RESULT, IRET)
      IF (IRET.EQ.99) THEN
         MSGTXT = 'Quitting at user request'
         CALL MSGWRT (5)
         GO TO 60
      ELSE IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1180) IRET
         GO TO 990
         END IF
      DO 50 I1 = 1,MAXPRM
         IF (RESULT(I1,1).NE.FBLANK) UPARMS(I1) = RESULT(I1,1)
 50      CONTINUE
         IG = 0
 60   MSGTXT = 'Final answers'
      CALL MSGWRT (5)
      DO 70 I = 1,NCOMPS
         WRITE (MSGTXT,1060) I, (RESULT(IG+J,1), J = 1,4)
         CALL MSGWRT (5)
         WRITE (MSGTXT,1061) (RESULT(IG+J,2), J = 1,4)
         CALL MSGWRT (5)
         IG = IG + 4
 70      CONTINUE
      WRITE (MSGTXT,1062) THERMS(1,1), THERMS(2,1)
      CALL MSGWRT (5)
      IRET = 0
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1060 FORMAT ('Component',I2,F12.6,F10.2,F10.3,F9.3)
 1061 FORMAT ('+/-        ',F12.6,F10.2,F10.3,F9.3)
 1062 FORMAT ('RMS residual  Q',F11.6,'   U',F11.6)
 1180 FORMAT ('FTARDO: DO1FIT ERROR',I3)
      END
      SUBROUTINE DO1FIT (IPOS, UPARMS, PARMS, XPARMS, NCMP, RESULT,
     *   IRET)
C-----------------------------------------------------------------------
C   DO1FIT fits Components to the data row and returns the answers in
C   RESULT.
C   Inputs:
C      IPOS     I(7)    BLC (input image) of first value in DATA
C      UPARMS   D(16)   Initial guess (input by user)
C      XPARMS   D(16)   Last fit in row below (0 -> do not use)
C   Values from commons:
C      DATA     D(*)    Input row, magic value blanked.
C      FBLANK   R       Value of blanked pixel.
C   In/out:
C      PARMS    D(16)   In: last answer, Out: Answer in fitting units
C   Output:
C      NCMP     I       Actual number components fit
C      RESULT   R(32)   Output row (parameter answers, errors).
C      IRET     I       Return code   0 => OK
C                               >0 => error, terminate.
C-----------------------------------------------------------------------
      INTEGER   IPOS(7), NCMP, IRET
      REAL      RESULT(*)
      DOUBLE PRECISION UPARMS(*), PARMS(*), XPARMS(*)
C
      EXTERNAL  RMFUNC
C
      INCLUDE 'FTARSD.INC'
      INTEGER   INFO, IPVT(MAXPRM), ING, INPARM, INPTS, LERR, TERR,
     *   IERR, NTRY, ITRY, LCOMPS, I, J, K, LNPTS, JNPTS, JNPARM
      DOUBLE PRECISION  FJAC(MAXPRM,MAXPRM), TOL, FVEC(2*NPLIM),
     *   VALVAR(MAXPRM)
      LOGICAL   REDO, SKIP1
      REAL      RANGQU(2,4)
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      IRET = 0
      NTRY = 0
      CALL RFILL (8, 0.0, RANGQU)
      REDO = .TRUE.
      SKIP1 = .FALSE.
      LCOMPS = NCOMPS
C                                       Get the initial guess
 10   NTRY = NTRY + 1
      ING = LCOMPS
      NCMP = LCOMPS
      INPARM = 4 * LCOMPS
      INPTS = QUPTS
      LNPTS = RMPTS
      ITTER = 0
      NITTER = XNIT + 1.01
      CALL FTARGE (LCOMPS, INPTS, UPARMS, XPARMS, DOCOMP, GCODE, PARMS,
     *   FVEC, IERR)
      IF (IERR.NE.0) GO TO 900
C                                       Plot it
      ITRY = 0
 20   ITRY = ITRY + 1
      CALL RTVINI (REDO, SKIP1, INPTS, ING, RANGQU, PARMS, TERR)
      REDO = .FALSE.
      SKIP1 = .FALSE.
      IF ((TERR.GT.0) .AND. (TERR.LT.100)) THEN
         IRET = TERR
         WRITE (MSGTXT,1000) IRET, 'TV ERROR IN RTVINI'
         GO TO 990
      ELSE IF (TERR.EQ.102) THEN
         IRET = 99
         GO TO 990
      ELSE IF (TERR.EQ.101) THEN
         GO TO 900
C                                       Redo guess
      ELSE IF (TERR.GE.100) THEN
         TERR = 0
         LNPTS = RMPTS
         CALL GTVGUS (ING, PARMS, TERR)
         IF (TERR.GT.0) THEN
            IRET = TERR
            WRITE (MSGTXT,1000) IRET, 'TV ERROR IN GTVGUS'
            GO TO 990
            END IF
         IF (ITRY.LT.5) THEN
            SKIP1 = .TRUE.
            GO TO 20
            END IF
         END IF
C                                       index
      NVAR = 0
      K = 0
      DO 50 I = 1,ING
         DO 40 J = 1,4
            K = K + 1
            IF (LLCOMP(K).GT.0) THEN
               NVAR = NVAR + 1
               IVAR(NVAR) = I
               JVAR(NVAR) = J
               IF ((J.EQ.4) .AND. (SPIXDO.GE.2)) THEN
                  IF (PARMS(K).EQ.0.0D0) PARMS(K) = 5.0D0
                  END IF
               VALVAR(NVAR) = PARMS(K)
               END IF
 40         CONTINUE
 50      CONTINUE
C                                       Fit Components
      TOL = 1.D-5
      JNPTS = 2 * INPTS
      JNPARM = NVAR
      CALL RMALMS (RMFUNC, JNPTS, JNPARM, VALVAR, FVEC, FJAC, MAXPRM,
     *   TOL, INFO, IPVT)
      IF (INFO.EQ.-1) THEN
         MSGTXT = 'NUMBER OF ITERATIONS EXCEEDED WHEN TRYING TO FIT'
      ELSE
         WRITE (MSGTXT,1020) INFO
         END IF
      IF ((INFO.LE.0) .OR. (INFO.GT.3)) CALL MSGWRT (6)
      IF ((INFO.EQ.0) .OR. (INFO.EQ.4)) GO TO 900
C                                       Get errors and nice units
      ITTER  = ITTER - 1
      JNPTS = 2 * INPTS
      INPARM = 4 * ING
      JNPARM = NVAR
      CALL REDOAN (JNPTS, JNPARM, VALVAR, PARMS, FVEC, FJAC, MAXPRM,
     *   RESULT)
      CALL FTARCH (ING, INPTS, FVEC, PARMS, LERR)
      CALL RTVMOD (INPTS, ING, IPOS, NCOMPS, FVEC, RANGQU, PARMS,
     *   LERR, TERR)
      IF (TERR.EQ.101) THEN
         GO TO 900
      ELSE IF (TERR.EQ.102) THEN
         IRET = 99
         GO TO 999
      ELSE IF (TERR.EQ.103) THEN
         REDO = .TRUE.
         LCOMPS = ING
         GO TO 10
      ELSE IF (TERR.EQ.105) THEN
         REDO = .TRUE.
         LCOMPS = ING
         GO TO 10
      ELSE IF (TERR.EQ.104) THEN
         TVSUP = 1
         MSGTXT = 'TV turned off until next step'
         CALL MSGWRT (2)
         END IF
C                                       PARMS may have changed
      ITTER  = ITTER - 1
      JNPTS = 2 * INPTS
      INPARM = 4 * ING
C                                       index
      NVAR = 0
      K = 0
      DO 150 I = 1,ING
         DO 140 J = 1,4
            K = K + 1
            IF (LLCOMP(K).GT.0) THEN
               NVAR = NVAR + 1
               IVAR(NVAR) = I
               JVAR(NVAR) = J
               VALVAR(NVAR) = PARMS(K)
               END IF
 140        CONTINUE
 150     CONTINUE
      JNPARM = NVAR
      CALL REDOAN (JNPTS, JNPARM, VALVAR, PARMS, FVEC, FJAC,
     *   MAXPRM, RESULT)
      GO TO 999
C                                       Blank outputs
 900  CALL RFILL (2*MAXPRM, FBLANK, RESULT)
      NCMP = -1
C
 990  IF (IRET.GT.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('DO1FIT: ERROR',I4,' ON ',A)
 1020 FORMAT ('FIT ROUTINE RETURNS ERROR CODE',I3)
      END
      SUBROUTINE REDOAN (M, N, X, PARMS, FVEC, FJAC, LDFJAC, RESULT)
C-----------------------------------------------------------------------
C   REDOAN computes a new residual vector, a new covariance, and redoes
C   the answers to be stored in the table
C   Inputs:
C      M        I        Number data points (adj. array dim.)
C      N        I        Number of unknowns (adj. array dim.)
C      X        D(N)     Vector of solutions
C      LDFJAC   I        First index of FJAC
C   Output:
C      PARMS    D(*)     all answers
C      FVEC     D(M)     Q, U residuals
C      FJAC     D(*,*)   work matrix
C      RESULT   R(*)     baseline, slope, amp, center, width...
C-----------------------------------------------------------------------
      INTEGER   M, N, LDFJAC
      DOUBLE PRECISION X(N), FVEC(M), FJAC(LDFJAC,N), PARMS(*)
      REAL      RESULT(*)
C
      INCLUDE 'FTARSD.INC'
      INTEGER   I, J, IPVT(MAXPRM)
      DOUBLE PRECISION TEMP, WA1(MAXPRM), WA2(MAXPRM), WA3(MAXPRM),
     *   QTF(MAXPRM)
C-----------------------------------------------------------------------
C                                       get residual
      I = 1
      CALL RMFUNC (M, N, X, FVEC, FJAC, I)
C                                       determine IPVT, FJAC
      DO 20 J = 1,N
         IPVT(J) = J
         DO 10 I = 1,N
            FJAC(I,J) = 0.0D0
 10         CONTINUE
 20      CONTINUE
      J = 2
      DO 30 I = 1,M
         CALL RMFUNC (M, N, X, FVEC, WA3, J)
         TEMP = FVEC(I)
         CALL RWUPDT (N, FJAC, LDFJAC, WA3, QTF, TEMP, WA1, WA2)
         J = J + 1
 30      CONTINUE
C                                       fit array into actual PARMS
      CALL DFILL (MAXPRM, 0.0D0, PARMS)
      DO 40 I = 1,N
         J = 4 * (IVAR(I) - 1) + JVAR(I)
         PARMS(J) = X(I)
 40      CONTINUE
C                                       Get errors and squirrel away
      CALL FTARFI (M, N, PARMS, IPVT, FJAC, FVEC, RESULT)
C
 999  RETURN
      END
      SUBROUTINE RMALMS (FCN, M, N, X, FVEC, FJAC, LDFJAC, TOL, INFO,
     *   IPVT)
C-----------------------------------------------------------------------
C   RMALMS provides an extra interface to the math routine LMSTR1
C   and holds the WORK array (for overlay purposes)
C   Inputs:
C      FCN      EXT      Function to evaluate the model
C      M        I        Number data points (adj. array dim.)
C      N        I        Number of unknowns (adj. array dim.)
C      LDFJAC   I        Number points on first axis of FJAC (adj.
C                           array dim.)
C      TOL      D        Tolerance desired
C   In/out:
C      X        D(N)     Initial guess/ answer
C      FVEC     D(M)     Function (Data - model) evaluation
C      FJAC     D(N,N)   Work matrix
C      INFO     I        Error code: 1 - 3 good, 0 bad input,
C                           4 orthogonal, 5 - 7 poor fit
C      IPVT     D(N)     Permutation matrix
C   See precursor remarks to LMSTR1 or LMSTR for details.
C-----------------------------------------------------------------------
      EXTERNAL  FCN
      INTEGER   M, N, LDFJAC, INFO, IPVT(N)
      DOUBLE PRECISION X(N), FVEC(M), FJAC(LDFJAC,N), TOL
C
      INTEGER   LWA
      DOUBLE PRECISION WA(10000)
      DATA LWA /10000/
C-----------------------------------------------------------------------
C                                       It's just a dummy routine
      CALL LMSTR1 (FCN, M, N, X, FVEC, FJAC, LDFJAC, TOL, INFO, IPVT,
     *   WA, LWA)
C
 999  RETURN
      END
      SUBROUTINE FTARGE (NG, ND, UPARMS, XPARMS, DOCOMP, GCODE, RPARMS,
     *   FVEC, IERR)
C-----------------------------------------------------------------------
C   FTARGE obtains an initial guess for the parameters on the
C   Components.  For a single component, it uses moments.  For multiple
C   components, it gets a baseline guess, checks the data, and chooses
C   between the last solution and the user's initial guess.
C   Inputs:
C      NG       I        Number of Components
C      ND       I        Number of data samples in Q/U spectra
C      UPARMS   D(16)    User's initial guess
C      DOCOMP   I(16)    > 0 -> do the parameter
C      GCODE    I        > 0 -> there is a user initial guess
C   In.out:
C      XPARMS   D(16)    another initial guess 0.0D0 -> none
C                           RETURNS 0.0 when XPARMS was considered
C      RPARMS   D(3NG)   In: previous solution
C                        Out:Guess to use
C   Output:
C      FVEC     D(*)     Buffer for computation
C      IERR     I        0 => ok, 1 => all data too low
C                        2 => input error
C   Common output:
C      LLCOMP   I(16)    copy DOCOMP unless previous guess is
C                                 used.  Then leave it alone.
C-----------------------------------------------------------------------
      INTEGER   NG, ND, DOCOMP(*), GCODE, IERR
      DOUBLE PRECISION UPARMS(*), XPARMS(*), RPARMS(*), FVEC(*)
C
      INCLUDE 'FTARSD.INC'
      DOUBLE PRECISION LPARMS(MAXPRM), FJC(MAXPRM), VALVAR(MAXPRM)
      INTEGER   JD, IJ, IM, I, J, K, INPTS
      REAL      X, XM, TS, BL, BLP, BLM, RMS(3)
      LOGICAL   DOUP
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
C-----------------------------------------------------------------------
C                                       Test inputs
      IERR = 2
      IF ((ND.LT.3*NG+6) .OR. (ND.GT.NPLIM)) GO TO 999
      DOUP = .TRUE.
C                                       last -> init guess w fillin
      IF (XPARMS(1).LE.0.0D0) CALL DPCOPY (MAXPRM, RPARMS, XPARMS)
      IF (GCODE.GT.0) THEN
         DO 5 I = 1,MAXPRM
            LPARMS(I) = UPARMS(I)
 5          CONTINUE
      ELSE IF (XPARMS(1).GT.0.0D0) THEN
         DO 6 I = 1,MAXPRM,4
            LPARMS(I) = 0.0D0
            LPARMS(I+1) = 0.0D0
            LPARMS(I+2) = XPARMS(I+2)
            LPARMS(I+3) = XPARMS(I+3)
 6          CONTINUE
      ELSE
         DOUP = .FALSE.
         CALL DFILL (MAXPRM, 0.0D0, LPARMS)
         END IF
      INPTS = RMPTS
C                                       Clear max finding variables
      IM = 0
      XM = 0.
C                                       find max
      DO 40 I = 1,INPTS
         IF (AMDATA(I).NE.FBLANK) THEN
            BL = AMDATA(I)
            IF ((I.NE.1) .AND. (I.NE.INPTS) .AND.
     *         (AMDATA(I-1).NE.FBLANK) .AND.
     *         (AMDATA(I+1).NE.FBLANK)) THEN
               BLM = AMDATA(I-1)
               BLP = AMDATA(I+1)
               X = BLP + BL + BLM
               IF (X.GE.XM) THEN
                  XM = X
                  IM = I
                  END IF
               END IF
            END IF
 40      CONTINUE
      IF (IM.LT.1) THEN
         DO 50 I = 1,INPTS
            IF (AMDATA(I).NE.FBLANK) THEN
               BL = AMDATA(I)
               IF (BL.GT.XM) THEN
                  XM = BL
                  IM = I
                  END IF
               END IF
 50         CONTINUE
         END IF
C                                       Find anything?
      IERR = 1
      IF (IM.LT.1) GO TO 999
C                                       Yes: make a guess
      IF (NG.LE.1) THEN
         RPARMS(1) = AMDATA(IM)
         RPARMS(2) = 0.5D0 * PHDATA(IM)
         RPARMS(3) = RMDATA(IM)
         RPARMS(4) = 0.0D0
         LLCOMP(1) = DOCOMP(1)
         LLCOMP(2) = DOCOMP(2)
         LLCOMP(3) = DOCOMP(3)
         LLCOMP(4) = DOCOMP(4)
         TS = 0.
C                                       Fill in amplitudes
      ELSE IF (DOUP) THEN
         DO 55 I = 1,NG
            K = 4 * I - 3
            IF (LPARMS(K).LE.0.0D0) THEN
               CALL FNDPIX (LPARMS(K+2), J)
               IF ((J.GT.0) .AND. (J.LE.INPTS)) THEN
                  LPARMS(K) = AMDATA(J)
                  LPARMS(K+1) = 0.5D0 * PHDATA(J)
                  IF ((LPARMS(K).LT.0.0D0) .OR. (LPARMS(K).EQ.FBLANK))
     *               THEN
                     LPARMS(K) = 0.0D0
                     LPARMS(K+1) = 0.0D0
                     END IF
                  END IF
               END IF
 55         CONTINUE
         END IF
C                                       Compute the RMSs
      IF (NG.NE.1) THEN
         TS = 0.0
         J = 4 * NG
C                                       user guess
         IF (LPARMS(1).LE.0.0) THEN
            RMS(1) = 1.E10
         ELSE
            ITTER = ITTER - 1
            JD = 2 * ND
            NVAR = 0
            K = 0
            DO 74 I = 1,NG
               DO 73 J = 1,4
                  K = K + 1
                  IF (LLCOMP(K).GT.0) THEN
                     NVAR = NVAR + 1
                     IVAR(NVAR) = I
                     JVAR(NVAR) = J
                     VALVAR(NVAR) = LPARMS(K)
                     END IF
 73               CONTINUE
 74            CONTINUE
            IJ = NVAR
            I = 1
            CALL RMFUNC (JD, IJ, VALVAR, FVEC, FJC, I)
            FJC(1) = 0.0D0
            DO 75 I = 1,JD
               FJC(1) = FJC(1) + FVEC(I) * FVEC(I)
 75            CONTINUE
            RMS(1) = SQRT (FJC(1) / JD)
            END IF
C                                       last solution
         ITTER = ITTER - 1
         JD = 2 * ND
         NVAR = 0
         K = 0
         DO 79 I = 1,NG
            DO 78 J = 1,4
               K = K + 1
               IF (LLCOMP(K).GT.0) THEN
                  NVAR = NVAR + 1
                  IVAR(NVAR) = I
                  JVAR(NVAR) = J
                  VALVAR(NVAR) = RPARMS(K)
                  END IF
 78            CONTINUE
 79         CONTINUE
         IJ = NVAR
         I = 1
         CALL RMFUNC (JD, IJ, VALVAR, FVEC, FJC, I)
         FJC(1) = 0.0D0
         DO 80 I = 1,JD
            FJC(1) = FJC(1) + FVEC(I) * FVEC(I)
 80         CONTINUE
         RMS(2) = SQRT (FJC(1) / JD)
C                                       extra guess
         IF (XPARMS(1).EQ.0.0D0) THEN
            RMS(3) = 1.E10
         ELSE
            ITTER = ITTER - 1
            JD = 2 * ND
            NVAR = 0
            K = 0
            DO 84 I = 1,NG
               DO 83 J = 1,4
                  K = K + 1
                  IF (LLCOMP(K).GT.0) THEN
                     NVAR = NVAR + 1
                     IVAR(NVAR) = I
                     JVAR(NVAR) = J
                     VALVAR(NVAR) = XPARMS(K)
                     END IF
 83               CONTINUE
 84            CONTINUE
            IJ = NVAR
            I = 1
            CALL RMFUNC (JD, IJ, VALVAR, FVEC, FJC, I)
            FJC(1) = 0.0D0
            DO 85 I = 1,JD
               FJC(1) = FJC(1) + FVEC(I) * FVEC(I)
 85            CONTINUE
            RMS(3) = SQRT (FJC(1) / JD)
            END IF
         IF ((RMS(3).LT.RMS(1)) .AND. (RMS(3).LT.RMS(2))) THEN
            DO 90 I = 1,MAXPRM
               RPARMS(I) = XPARMS(I)
C               LLCOMP(I) = DOCOMP(I)
 90            CONTINUE
         ELSE IF (RMS(1).LT.RMS(2)) THEN
            DO 95 I = 1,MAXPRM
               RPARMS(I) = LPARMS(I)
C               LLCOMP(I) = DOCOMP(I)
 95            CONTINUE
            END IF
         END IF
C                                       Return answers/guesses
C                                       test desire to plot
      IERR = 0
      IF (RMS(3).LT.1.E9) CALL DFILL (MAXPRM, 0.0D0, XPARMS)
C
 999  RETURN
      END
      SUBROUTINE FNDPIX (RMVALU, PIX)
C-----------------------------------------------------------------------
C   Finds the closest pixel to a specific RM value
C   Inputs:
C      RMVALU   D   RM value
C   Output:
C      PIX      I   pixel
C-----------------------------------------------------------------------
      INTEGER   PIX
      DOUBLE PRECISION RMVALU
C
      INTEGER   I
      DOUBLE PRECISION X, DMIN
      INCLUDE 'FTARSD.INC'
C-----------------------------------------------------------------------
      DMIN = 1.D10
      PIX = 0
      DO 10 I = 1,RMPTS
         X = ABS (RMDATA(I)-RMVALU)
         IF (X.LT.DMIN) THEN
            PIX = I
            DMIN = X
            END IF
 10      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE FTARFI (INPTS, NP, PARMS, IPVT, FJAC, FVEC, RESULT)
C-----------------------------------------------------------------------
C   FTARFI determines the errors in the fit and converts the results
C   to normal units for output.
C   Inputs:
C      INPTS    I          Number of data samples
C      NP       I          Number of parameters
C      PARMS    D(16)      Answers from LMSTR1
C      IPVT     I(16)      from LMSTR1
C      FJAC     D(16,16)   from LMSTR1
C      FVEC     D(*)       from LMSTR1
C   Output:
C      RESULT   R(36)      Answers then errors in PIXELS
C                             4 each of 4 Components
C                             Errors: 4 ea of 4 Components
C-----------------------------------------------------------------------
      INCLUDE 'FTARSD.INC'
C
      INTEGER   INPTS, NP, IPVT(*)
      DOUBLE PRECISION PARMS(*), FJAC(MAXPRM,MAXPRM), FVEC(*)
      REAL      RESULT(*)
C
      DOUBLE PRECISION EPARMS(MAXPRM), ENORM, FNORM, TOL, WORK(MAXPRM),
     *   SFJAC(MAXPRM,MAXPRM)
      INTEGER   I, NG, JC, JNPTS, JP, JJ
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
C                                       Get errors with LMSTR1 outputs
      TOL = 1.D-5
      JNPTS = 2 * INPTS
      FNORM = ENORM (JNPTS, FVEC)
      JP = MAXPRM * MAXPRM
      CALL DPCOPY (JP, FJAC, SFJAC)
      JP = NP
      CALL GETERR (IPVT, SFJAC, EPARMS, JP, JNPTS, MAXPRM, FNORM, WORK,
     *   TOL, IVAR, JVAR)
C                                       Convert to output
      NG = NP / 4
      JJ = 0
      JC = 0
      CALL RFILL (2*MAXPRM, FBLANK, RESULT)
      DO 20 I = 1,MAXCMP
         IF ((LLCOMP(1+JC).GT.0) .OR. (LLCOMP(2+JC).GT.0) .OR.
     *      (LLCOMP(3+JC).GT.0) .OR. (PARMS(1+JC).NE.0.0D0)) THEN
            IF (PARMS(1+JC).LT.0.0) THEN
               PARMS(1+JC) = -PARMS(1+JC)
               PARMS(2+JC) = PARMS(2+JC) + 90.0
               END IF
            RESULT(1+JJ) = PARMS(1+JC)
C                                       forces angle to be reasonable
            PARMS(2+JC) = MOD (PARMS(2+JC), 180.0D0)
            IF (PARMS(2+JC).GT.90.0) THEN
               PARMS(2+JC) = PARMS(2+JC) - 180.0
            ELSE IF (PARMS(2+JC).LT.-90.0) THEN
               PARMS(2+JC) = PARMS(2+JC) + 180.0
               END IF
            RESULT(2+JJ) = PARMS(2+JC)
            RESULT(3+JJ) = PARMS(3+JC)
            IF (LLCOMP(4+JJ).GT.0) THEN
               RESULT(4+JJ) = PARMS(4+JC)
            ELSE
               RESULT(4+JJ) = 0.0
               END IF
            IF ((EPARMS(1+JC).LE.0.0D0) .AND. (I.GT.1)) THEN
               RESULT(MAXPRM+1+JJ) = RESULT(MAXPRM+1+JJ-4)
            ELSE
               RESULT(MAXPRM+1+JJ) = EPARMS(1+JC)
               END IF
            IF ((EPARMS(2+JC).LE.0.0D0) .AND. (I.GT.1)) THEN
               RESULT(MAXPRM+2+JJ) = RESULT(MAXPRM+2+JJ-4)
            ELSE
               RESULT(MAXPRM+2+JJ) = EPARMS(2+JC)
               END IF
            IF ((EPARMS(3+JC).LE.0.0D0) .AND. (I.GT.1)) THEN
               RESULT(MAXPRM+3+JJ) = RESULT(MAXPRM+3+JJ-4)
            ELSE
               RESULT(MAXPRM+3+JJ) = EPARMS(3+JC)
               END IF
            IF (LLCOMP(4+JJ).GT.0) THEN
               IF ((EPARMS(4+JC).LE.0.0D0) .AND. (I.GT.1)) THEN
                  RESULT(MAXPRM+4+JJ) = RESULT(MAXPRM+4+JJ-4)
               ELSE
                  RESULT(MAXPRM+4+JJ) = EPARMS(4+JC)
                  END IF
            ELSE
               RESULT(MAXPRM+4+JJ) = 0.0
               END IF
            END IF
         JJ = JJ + 4
         JC = JC + 4
 20      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE GETERR (IPVT, FJAC, PARERR, MP, NDATA, MD, FNORM, WA,
     *   TOL, IVAR, JVAR)
C-----------------------------------------------------------------------
C   This subroutine calculates the errors on the fitted parameters.
C   Inputs:
C      IPVT    I(MP)   Defines a permutation matrix P such that
C                      JAC*P = Q*R, where JAC is the final calculated
C                      Jacobian, Q is orthogonal (not stored), and R is
C                      upper triangular with diagonal elements of
C                      nonincreasing magnitude column J of P is column
C                      IPVT(J) of the identity matrix. (See FJAC below)
C      FJAC    D(MD,MP)   The upper MP by MP submatrix of FJAC contains
C                      an upper triangular matrix R with diagonal
C                      elements of nonincreasing magnitude such that
C                           T     T           T
C                          P *(JAC *JAC)*P = R *R,
C                      where P is a permutation matrix and JAC is the
C                      final calculated Jacobian. Column J of P is
C                      column IPVT(J) (see above) of the identity
C                      matrix.
C      MP      I       Number of parameters in fitted function.
C      NDATA   I       Number of data points fitted.
C      MD      I       Maximum no. of data points allowed for in FJAC
C      FNORM   D       Euclidian norm of solution vector.
C      WA      D(MP)   work array.
C  Output:
C      FJAC    D       modified by COVAR
C      PARERR  D(MP)   error in fitted parameters.
C      TOL     D       tolerance used in call to LMDER1.
C-----------------------------------------------------------------------
      INTEGER   MD, MP, IPVT(MP), NDATA, IVAR(*), JVAR(*)
      DOUBLE PRECISION FJAC(MD,MP), PARERR(MP), FNORM, WA(MP), TOL
C
      DOUBLE PRECISION EPSILN
      INTEGER   J, JC
C-----------------------------------------------------------------------
C                                       Calculate error following
C                                       Argonne write up
C      NPARMS = NCOMPS * 4
C                                       Is this right ??????
C                                       changed NPARMS to MP
      EPSILN = FNORM / SQRT (REAL(NDATA-MP))
      CALL COVAR (MP, FJAC, MD, IPVT, TOL, WA)
      CALL DFILL (MD, 0.0D0, PARERR)
      DO 100 J = 1,MP
         JC = 4 * (IVAR(J) - 1) + JVAR(J)
         PARERR(JC) = EPSILN * SQRT (FJAC(J,J))
 100     CONTINUE
C
 999  RETURN
      END
      SUBROUTINE RMFUNC (M, N, VALVAR, FVEC, FJROW, IFLAG)
C-----------------------------------------------------------------------
C   This routine is called by the Argonne package to calculate the
C   difference between the current fit and the actual data OR the
C   Jacobian for this difference.
C   Inputs:
C      M        I      Number of data points in Q plus U
C      N        I      No. of parameters (adj. array dim.;
C                        NCOMPS * 4)
C      VALVAR   D(N)   parameters of components being fitted
C                        GMAX(1), GPOS(1), GWIDTH(1), GMAX(2), ...
C      IFLAG    I      1=calculate difference for current guess.
C                        2=calculate jacobian for current guess.
C    COMMON GDATA
C      QDATA    D(*)   Original Q slice data points.
C      UDATA    D(*)   Original Q slice data points.
C      ITTER    I      number of calls to evaluate FVEC.
C   Outputs:
C      FVEC1    D(M)   Q Slice data points minus data points
C                        evaluated for current guess.
C      FVEC2    D(M)   U Slice data points minus data points
C                        evaluated for current guess.
C      FJROW1   D(N)   Row (IFLAG - 1) of Jacobian.
C-----------------------------------------------------------------------
      INTEGER   N, M, IFLAG
      DOUBLE PRECISION VALVAR(N), FVEC(M), FJROW(N)
C
      INCLUDE 'FTARSD.INC'
      DOUBLE PRECISION AMP, THETA, RM, QQ, UU, TSIN, TCOS, ALPHA, AFACT,
     *   LPARMS(MAXPRM), DSINCS, XX
      INTEGER   ID, IAMP, ITHE, IRM, IALPH, M2, I, K
      INCLUDE 'INCS:DDCH.INC'
      SAVE LPARMS
C-----------------------------------------------------------------------
C                                       Determine difference between
C                                       data and current fit.
      M2 = M / 2
      IF (IFLAG.LE.1) THEN
         ITTER = ITTER + 1
         IF (ITTER.GT.NITTER) THEN
            IFLAG = -1
            GO TO 999
            END IF
C                                       get full parms array
         CALL DFILL (MAXPRM, 0.0D0, LPARMS)
         DO 10 I = 1,N
            K = 4 * (IVAR(I) - 1) + JVAR(I)
            LPARMS(K) = VALVAR(I)
 10         CONTINUE
C                                       Q residual
         DO 20 ID = 1,M2
            FVEC(ID) = QDATA(ID)
            IF (FVEC(ID).EQ.FBLANK) THEN
               FVEC(ID) = 0.0D0
            ELSE
               QQ = 0.0D0
               DO 15 I = 1,N
                  IF (JVAR(I).EQ.1) THEN
                     IAMP = (IVAR(I) - 1) * 4 + 1
                     AMP = LPARMS(IAMP)
                     IF (AMP.NE.0.0D0) THEN
                        IF (SPIXDO.EQ.1) THEN
                           AMP = AMP * ((LAMSQ1/LAMSQ(ID)) **
     *                        (0.5D0 * LPARMS(IAMP+3)))
                        ELSE IF (SPIXDO.GE.2) THEN
                           XX = LPARMS(IAMP+3) * LAMSQ(ID)
                           AMP = AMP * DSINCS (SPIXDO, 0, XX)
                           END IF
                        QQ = QQ + AMP * COS (2.0D0*DG2RAD*LPARMS(IAMP+1)
     *                     + 2.0D0 * LPARMS(IAMP+2) * LAMSQ(ID))
                        END IF
                     END IF
 15               CONTINUE
               FVEC(ID) = (FVEC(ID) - QQ)
               END IF
 20         CONTINUE
C                                       U residual
         DO 40 ID = M2+1,M
            FVEC(ID) = UDATA(ID-M2)
            IF (FVEC(ID).EQ.FBLANK) THEN
               FVEC(ID) = 0.0D0
            ELSE
               UU = 0.0D0
               DO 35 I = 1,N
                  IF (JVAR(I).EQ.1) THEN
                     IAMP = 4 * (IVAR(I) - 1) + 1
                     AMP = LPARMS(IAMP)
                     IF (AMP.NE.0.0D0) THEN
                        IF (SPIXDO.EQ.1) THEN
                           AMP = AMP * ((LAMSQ1/LAMSQ(ID-M2)) **
     *                        (0.5D0 * LPARMS(IAMP+3)))
                        ELSE IF (SPIXDO.GE.2) THEN
                           XX = LPARMS(IAMP+3) * LAMSQ(ID-M2)
                           AMP = AMP * DSINCS (SPIXDO, 0, XX)
                           END IF
                        UU = UU + AMP * SIN (2.0D0*DG2RAD*LPARMS(IAMP+1)
     *                     + 2.0D0 * LPARMS(IAMP+2) * LAMSQ(ID-M2))
                        END IF
                     END IF
 35                CONTINUE
               FVEC(ID) = (FVEC(ID) - UU)
               END IF
 40         CONTINUE
C                                       Calculate Jacobian.
      ELSE
         ID = IFLAG - 1
         AFACT = 1.0D0
         DO 110 I = 1,N
            IAMP = 4 * IVAR(I) - 3
            ITHE = IAMP + 1
            IRM  = IAMP + 2
            IALPH = IAMP + 3
            FJROW(I) = 0.0D0
            AMP   = LPARMS(IAMP)
            THETA = LPARMS(ITHE)
            RM    = LPARMS(IRM)
            ALPHA = LPARMS(IALPH)
            IF (ID.LE.M2) THEN
               IF (SPIXDO.EQ.1) THEN
                  AFACT = (LAMSQ1 / LAMSQ(ID)) ** (0.5D0 * ALPHA)
               ELSE IF (SPIXDO.GE.2) THEN
                  XX = ALPHA * LAMSQ(ID)
                  AFACT = DSINCS (SPIXDO, 0, XX)
                  END IF
               TCOS = COS (2.0D0 * DG2RAD * THETA +
     *            2.0D0 * LAMSQ(ID) * RM)
               TSIN = SIN (2.0D0 * DG2RAD * THETA +
     *            2.0D0 * LAMSQ(ID) * RM)
               IF (JVAR(I).EQ.1) THEN
                  FJROW(I) = -TCOS * AFACT
               ELSE IF (JVAR(I).EQ.2) THEN
                  FJROW(I) = AMP * 2.0D0 * DG2RAD * TSIN * AFACT
               ELSE IF (JVAR(I).EQ.3) THEN
                  FJROW(I) = AMP * 2.0D0 * LAMSQ(ID) * TSIN * AFACT
               ELSE IF (JVAR(I).EQ.4) THEN
                  IF (SPIXDO.EQ.1) THEN
                     FJROW(I) = -AMP * AFACT * TCOS * 0.5D0 *
     *                  LOG (LAMSQ1/LAMSQ(ID))
                  ELSE IF (SPIXDO.GE.2) THEN
                     XX = ALPHA * LAMSQ(ID)
                     FJROW(I) = -AMP * TCOS * LAMSQ(ID) *
     *                  DSINCS (SPIXDO, 1, XX)
                     END IF
                  END IF
            ELSE
               IF (SPIXDO.EQ.1) THEN
                  AFACT = (LAMSQ1 / LAMSQ(ID-M2)) ** (0.5D0 * ALPHA)
               ELSE IF (SPIXDO.GE.2) THEN
                  XX = ALPHA * LAMSQ(ID-M2)
                  AFACT = DSINCS (SPIXDO, 0, XX)
                  END IF
               TCOS = COS (2.0D0 * DG2RAD * THETA +
     *            2.0D0 * LAMSQ(ID-M2) * RM)
               TSIN = SIN (2.0D0 * DG2RAD * THETA +
     *            2.0D0 * LAMSQ(ID-M2) * RM)
               IF (JVAR(I).EQ.1) THEN
                  FJROW(I) = -TSIN * AFACT
               ELSE IF (JVAR(I).EQ.2) THEN
                  FJROW(I) = -AMP * 2.0D0 * DG2RAD * TCOS * AFACT
               ELSE IF (JVAR(I).EQ.3) THEN
                  FJROW(I) = -AMP * 2.0D0 * LAMSQ(ID-M2) * TCOS * AFACT
               ELSE IF (JVAR(I).EQ.4) THEN
                  IF (SPIXDO.EQ.1) THEN
                     FJROW(I) = -AMP * AFACT * TSIN * 0.5D0 *
     *                  LOG (LAMSQ1/LAMSQ(ID-M2))
                  ELSE IF (SPIXDO.GE.2) THEN
                     XX = ALPHA * LAMSQ(ID-M2)
                     FJROW(I) = -AMP * TSIN * LAMSQ(ID-M2) *
     *                  DSINCS (SPIXDO, 1, XX)
                     END IF
                  END IF
               END IF
 110        CONTINUE
         END IF
C
 999  RETURN
      END
      DOUBLE PRECISION FUNCTION DSINCS (MODEL, TYPE, XX)
C-----------------------------------------------------------------------
C   returns sin(xx)/xx on type 0 and d (sin(xx)/xx) / dx on type 1
C   Inputs:
C      MODEL   I   2 - sin(x)/x, 3 Gauss, 4 exp
C      TYPE    I   0 - return function, 1 return derivative
C      XX      D   argument
C   Output
C     DSINCS   D   function value or derivative
C-----------------------------------------------------------------------
      INTEGER   MODEL, TYPE
      DOUBLE PRECISION XX
C
      DOUBLE PRECISION F
C                                       1.8954 radians is the half-power
C                                       of sin(x) / x
C-----------------------------------------------------------------------
      DSINCS = 0.0D0
C                                       SIN(X)/X function
      IF (MODEL.EQ.2) THEN
         IF (TYPE.EQ.0) THEN
            IF (ABS(XX).LE.1.D-5) THEN
               DSINCS = 1.0D0 - XX*XX / 6.0D0 + XX*XX*XX*XX / 120.0D0
            ELSE
               DSINCS = SIN (XX) / XX
               END IF
C                                       SIN(X)/X derivative
         ELSE IF (TYPE.EQ.1) THEN
            IF (ABS(XX).LE.1.D-5) THEN
               DSINCS = -XX/3.D0 + XX*XX*XX/30.D0 -
     *            XX*XX*XX*XX*XX/840.D0
            ELSE
               DSINCS = (XX * COS(XX) - SIN(XX)) / (XX*XX)
               END IF
            END IF
C                                       Gauss function
      ELSE IF (MODEL.EQ.3) THEN
         F = -LOG (2.0D0) / (1.8954 * 1.8954)
         IF (TYPE.EQ.0) THEN
            DSINCS = EXP (F * XX * XX)
C                                       Gauss derivative
         ELSE IF (TYPE.EQ.1) THEN
            DSINCS = 2.0 * XX * F * EXP (F * XX * XX)
            END IF
C                                       Exp function
      ELSE IF (MODEL.EQ.4) THEN
         F = -LOG (2.0D0) / 1.8954
         IF (TYPE.EQ.0) THEN
            DSINCS = EXP (F * ABS(XX))
C                                       Exp derivative
         ELSE IF (TYPE.EQ.1) THEN
            DSINCS = F * EXP (F * ABS(XX))
            END IF
         END IF
C
 999  RETURN
      END
      SUBROUTINE RTVINI (REDO, SKIP1, INPTS, NG, RANGQU, PARMS, IERR)
C-----------------------------------------------------------------------
C   RTVINI initializes the TV for a FTARS plot, plots axis labels,
C   and, if requested, plots the data.
C   Inputs:
C      REDO     L        If true, will always want to make a new guess
C      SKIP1    L        If true, omit first plot and question
C      INPTS    I        Number of points in row.
C      NG       I        Number of Components
C      PARMS    D(16)    Initial guess
C   Output:
C      IERR     I        > 0 => plot failed
C                        101 => bad initial guess
C                        102 => DIE
C   Output in COMMON:
C      ORANGE   R(6)     Actual plot range in plot units
C-----------------------------------------------------------------------
      LOGICAL   REDO, SKIP1
      INTEGER   INPTS, NG, IERR
      DOUBLE PRECISION PARMS(*)
      REAL      RANGQU(2,4)
C
      CHARACTER TEMP*1, MSGBUF*132, FIRSTC*1
      REAL      XFAC, PHS, X
      INTEGER   I, JERR, LNPTS, INBUF(256)
      LOGICAL   T, F, FIRST
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      SAVE FIRST
      DATA T, F, FIRST /.TRUE.,.FALSE.,.TRUE./
C-----------------------------------------------------------------------
      CALL YHOLD ('ONNN', IERR)
      IF (FIRST) THEN
         IGR1 = 1 + NGRAY
         IGR2 = 2 + NGRAY
         IGR3 = 3 + NGRAY
         IGR4 = 4 + NGRAY
         IGR5 = 5 + NGRAY
         DO 5 I = 1,NGRAY+NGRAPH
            CALL YSLECT ('OFFF', I, 0, INBUF, IERR)
            IF (IERR.NE.0) GO TO 990
 5          CONTINUE
         FIRST = .FALSE.
         END IF
      CALL YSLECT ('ONNN', IGR1, 0, INBUF, IERR)
      IF (IERR.NE.0) GO TO 990
      IF (IGR1.NE.IGR2) THEN
         CALL YSLECT ('ONNN', IGR2, 0, INBUF, IERR)
         IF (IERR.NE.0) GO TO 990
         CALL YSLECT ('ONNN', IGR3, 0, INBUF, IERR)
         IF (IERR.NE.0) GO TO 990
         CALL YSLECT ('ONNN', IGR4, 0, INBUF, IERR)
         IF (IERR.NE.0) GO TO 990
         END IF
C                                       Default: actual range
      ORANGE(1,1) = 1.0E10
      ORANGE(2,1) = -ORANGE(1,1)
      ORANGE(1,2) = 1.0E10
      ORANGE(2,2) = -ORANGE(1,2)
      ORANGE(1,3) = 1.0E10
      ORANGE(2,3) = -ORANGE(1,3)
      ORANGE(1,4) = 1.0E10
      ORANGE(2,4) = -ORANGE(1,4)
      ORANGE(1,5) = 1.0E10
      ORANGE(2,5) = -ORANGE(1,5)
      PRANGE(1,1) = 1.E10
      PRANGE(2,1) = -PRANGE(1,1)
      PRANGE(1,2) = 1.E10
      PRANGE(2,2) = -PRANGE(1,2)
      IF (RANGQU(2,1).LE.RANGQU(1,1)) THEN
         ORANGE(1,1) = QURANG(1,1)
         ORANGE(2,1) = QURANG(2,1)
      ELSE
         ORANGE(1,1) = RANGQU(1,1)
         ORANGE(2,1) = RANGQU(2,1)
         END IF
      IF (RANGQU(2,2).LE.RANGQU(1,2)) THEN
         ORANGE(1,2) = QURANG(1,2)
         ORANGE(2,2) = QURANG(2,2)
      ELSE
         ORANGE(1,2) = RANGQU(1,2)
         ORANGE(2,2) = RANGQU(2,2)
         END IF
      IF (RANGQU(2,3).LE.RANGQU(1,3)) THEN
         PRANGE(1,2) = QURANG(1,4)
         PRANGE(2,2) = QURANG(2,4)
      ELSE
         PRANGE(1,2) = RANGQU(1,3)
         PRANGE(2,2) = RANGQU(2,3)
         END IF
      IF (RANGQU(2,4).LE.RANGQU(1,4)) THEN
         PRANGE(1,1) = QURANG(1,3)
         PRANGE(2,1) = QURANG(2,3)
      ELSE
         PRANGE(1,1) = RANGQU(1,4)
         PRANGE(2,1) = RANGQU(2,4)
         END IF
      LNPTS = RMPTS
      ORANGE(1,3) = RMRANG(1,2)
      ORANGE(2,3) = RMRANG(2,2)
      DO 30 I = 1,LNPTS
         IF ((AMDATA(I).NE.FBLANK) .AND. (PHDATA(I).NE.FBLANK)) THEN
            PHS = PHDATA(I)
            IF (PHS.LT.ORANGE(1,4)) ORANGE(1,4) = PHS
            IF (PHS.GT.ORANGE(2,4)) ORANGE(2,4) = PHS
            IF (PHS.LT.0.0) PHS = PHS + 360.0
            IF (PHS.LT.ORANGE(1,5)) ORANGE(1,5) = PHS
            IF (PHS.GT.ORANGE(2,5)) ORANGE(2,5) = PHS
            END IF
 30      CONTINUE
      DO 40 I = 1,5
         XFAC = ORANGE(2,I) - ORANGE(1,I)
         ORANGE(2,I) = ORANGE(2,I) + 0.075 * XFAC
         ORANGE(1,I) = ORANGE(1,I) - 0.075 * XFAC
 40      CONTINUE
      X = PRANGE(2,1) - PRANGE(1,1)
      PRANGE(2,1) = PRANGE(2,1) + 0.075 * X
      PRANGE(1,1) = PRANGE(1,1) - 0.075 * X
      X = PRANGE(2,2) - PRANGE(1,2)
      PRANGE(2,2) = PRANGE(2,2) + 0.075 * X
      PRANGE(1,2) = PRANGE(1,2) - 0.075 * X
C                                       start with amp/phase of FARS
C                                       clear screen
      IF (SKIP1) THEN
         IERR = 0
      ELSE
         CALL YZERO (IGR1, IERR)
         IF (IERR.NE.0) GO TO 990
         IF (IGR2.NE.IGR1) THEN
            CALL YZERO (IGR2, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR3, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR4, IERR)
            IF (IERR.NE.0) GO TO 990
            END IF
         CALL RTVPLT (.FALSE., LNPTS, NG, PARMS, IERR)
         IF (IERR.NE.0) GO TO 990
C                                       Talk to user
         IF (REDO) THEN
            IERR = 103
         ELSE
            CALL RMMEN1 (MSGBUF, SCRTCH, JERR)
            IF (JERR.NE.0) GO TO 920
            TEMP = FIRSTC (MSGBUF)
            IF (TEMP.EQ.'B') THEN
               IERR = 101
            ELSE IF (TEMP.EQ.'Q') THEN
               IERR = 102
            ELSE IF (TEMP.EQ.'E') THEN
               IERR = 103
               END IF
            END IF
         END IF
C                                       If not making a guess
C                                       plot Q, U
C                                       clear screen
      IF ((IERR.LT.101) .OR. (IERR.GT.103)) THEN
         JERR = IERR
         CALL YHOLD ('ONNN', IERR)
         CALL YZERO (IGR1, IERR)
         IF (IERR.NE.0) GO TO 990
         IF (IGR2.NE.IGR1) THEN
            CALL YZERO (IGR2, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR3, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR4, IERR)
            IF (IERR.NE.0) GO TO 990
            END IF
         CALL RTVPLT (.TRUE., INPTS, NG, PARMS, IERR)
         IF (IERR.NE.0) GO TO 990
C         CALL YHOLD ('OFFF', IERR)
         IERR = JERR
         END IF
      GO TO 990
C                                       TTY error
 920  WRITE (MSGTXT,1920) JERR
      CALL MSGWRT (6)
      CALL YHOLD ('OFFF', I)
C
 990  CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1920 FORMAT ('TV MENU ERROR',I7)
      END
      SUBROUTINE RMMEN1 (MSGBUF, SCRTCH, JERR)
C-----------------------------------------------------------------------
C   Does a TV menu for initial guess stage of user questions
C   Outputs:
C      MSGBUF   C*(*)   answer: E, B, Q, other
C      JERR     I       error
C-----------------------------------------------------------------------
      INTEGER   SCRTCH(*), JERR
      CHARACTER MSGBUF*(*)
C
      INTEGER   MTYPE, NCOL, NROWS, GRCHS(2), TOPSEP, SIDSEP, TIMLIM,
     *   NTITLE, TVBUTT, CHOICE
      LOGICAL   LEAVE(5)
      CHARACTER CHOICS(5)*8, TITLE*8, ISHELP*6
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA CHOICS /'DO FIT', ' ', 'RE-GUESS', ' ', 'QUIT'/
C      DATA LEAVE /.FALSE., .TRUE., .FALSE., .TRUE., .FALSE./
      DATA LEAVE /4*.TRUE., .FALSE./
      DATA ISHELP /'XGAUS'/
C-----------------------------------------------------------------------
      GRCHS(1) = 6
      GRCHS(2) = 5
      MTYPE = 1
      NCOL = 1
      NROWS = 5
      SIDSEP = 6 * CSIZTV(1)
      TOPSEP = 5 * CSIZTV(2)
      NTITLE = 0
      TITLE = ' '
      TIMLIM = 0
      MSGBUF = ' '
C                                       menu
 20   CALL TVMENU (MTYPE, NCOL, NROWS, GRCHS, TOPSEP, SIDSEP, ISHELP,
     *   CHOICS, TIMLIM, LEAVE, NTITLE, TITLE, CHOICE, TVBUTT, SCRTCH,
     *   JERR)
      IF (JERR.NE.0) THEN
         MSGTXT = 'RMMEN1: ERROR FROM TV MENU'
         CALL MSGWRT (7)
      ELSE IF (CHOICS(CHOICE).EQ.' ') THEN
         GO TO 20
      ELSE IF (CHOICS(CHOICE).EQ.'RE-GUESS') THEN
         MSGBUF = 'E'
      ELSE IF (CHOICS(CHOICE).EQ.'QUIT') THEN
         MSGBUF = 'Q'
      ELSE IF (CHOICS(CHOICE).EQ.'DO FIT') THEN
         MSGBUF = 'D'
         END IF
C
 999  RETURN
      END
      SUBROUTINE RTVPLT (DOREIM, INPTS, NG, PARMS, IERR)
C-----------------------------------------------------------------------
C   Does the data plot - either real and imaginary (Q,U) or Amp/phase
C   (FARS)
C   Inputs:
C      DOREIM   L        T => plot Q/U or P/A; F => FARS data
C   Common: FTARSD.INC
C   Common in/out
C      CATBLK   I(*)     modified for TV catalog
C   Outputs:
C      IERR     I        error code
C-----------------------------------------------------------------------
      LOGICAL   DOREIM
      INTEGER   INPTS, NG, IERR
      DOUBLE PRECISION PARMS(*)
C
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      CHARACTER PREF*8, XPREF*8, TEXT*132
      INTEGER   TVWIND(4), TVSIZE(2), INCHAR, I, J, INP, JTRIM, K, L
      REAL      XYRATI, BLC(2), TRC(2), CHOUT(4), ATEMP, YMULT, XMULT,
     *   LINT, DX, DY, XBLC(2), XTRC(2), PADD, XP, YP, DP, QQ, UU, XX,
     *   XL, XH, AMP, PP(1000), AA(1000)
      DOUBLE PRECISION X, DSINCS
      LOGICAL   PFLG
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      CALL YHOLD ('ONNN', IERR)
      CALL YWINDO ('READ', TVWIND, IERR)
      IF (IERR.NE.0) THEN
         TVWIND(1) = 1
         TVWIND(2) = 1
         TVWIND(3) = MAXXTV(1)
         TVWIND(4) = MAXXTV(2)
         END IF
      TVSIZE(1) = TVWIND(3) - TVWIND(1) + 1
      TVSIZE(2) = TVWIND(4) - TVWIND(2) + 1
      XYRATI = (WINDTV(3)-WINDTV(1)+1.0) / (WINDTV(4)-WINDTV(2)+1.0)
C                                       Initialize for plotting
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      CALL RFILL (4, 0.5, CHOUT)
C                                       labeling commons
      LOCNUM = 1
      CALL SETLOC (PLPOS(3), .FALSE.)
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      AXFUNC(1,LOCNUM) = 0
      AXFUNC(2,LOCNUM) = 0
      RPLOC(1,LOCNUM) = 0.5
      RPLOC(2,LOCNUM) = 0.5
C                                       P and A
      IF ((DOREIM) .AND. (PLOTPA)) THEN
         LINT = 500.
         ATEMP = PRANGE(2,1) - PRANGE(1,1)
         YMULT = ATEMP
         CALL METSCA (ATEMP, PREF, PFLG)
         YMULT = ATEMP / YMULT
         CTYP(2,LOCNUM) = 'P Jy/beam'
         CPREF(2,LOCNUM) = PREF
         RPVAL(2,LOCNUM) = PRANGE(1,1) * YMULT
         AXINC(2,LOCNUM) = (PRANGE(2,1) - PRANGE(1,1)) * YMULT /
     *      (LINT-1.0)
         ATEMP = XRANGE(2,1) - XRANGE(1,1)
         XMULT = ATEMP
         CALL METSCA (ATEMP, XPREF, PFLG)
         XMULT = ATEMP / XMULT
         RPVAL(1,LOCNUM) = XRANGE(1,1) * XMULT
         AXINC(1,LOCNUM) = (XRANGE(2,1) - XRANGE(1,1)) * XMULT / 999.0
         TEXT = 'P and Ang spectrum__' // INFILE
         CTYP(1,LOCNUM) = 'Lambda^2'
         CPREF(1,LOCNUM) = XPREF
C                                       Q and U.
      ELSE IF (DOREIM) THEN
         LINT = 500.
         ATEMP = ORANGE(2,1) - ORANGE(1,1)
         YMULT = ATEMP
         CALL METSCA (ATEMP, PREF, PFLG)
         YMULT = ATEMP / YMULT
         CTYP(2,LOCNUM) = 'Q Jy/beam'
         CPREF(2,LOCNUM) = PREF
         RPVAL(2,LOCNUM) = ORANGE(1,1) * YMULT
         AXINC(2,LOCNUM) = (ORANGE(2,1) - ORANGE(1,1)) * YMULT /
     *      (LINT-1.0)
         ATEMP = XRANGE(2,1) - XRANGE(1,1)
         XMULT = ATEMP
         CALL METSCA (ATEMP, XPREF, PFLG)
         XMULT = ATEMP / XMULT
         RPVAL(1,LOCNUM) = XRANGE(1,1) * XMULT
         AXINC(1,LOCNUM) = (XRANGE(2,1) - XRANGE(1,1)) * XMULT / 999.0
         TEXT = 'Q and U spectrum__' // INFILE
         CTYP(1,LOCNUM) = 'Lambda^2'
         CPREF(1,LOCNUM) = XPREF
C                                       FARS amp and phase
      ELSE
         LINT = 700.
         ATEMP = ORANGE(2,3) - ORANGE(1,3)
         YMULT = ATEMP
         CALL METSCA (ATEMP, PREF, PFLG)
         YMULT = ATEMP / YMULT
         CTYP(2,LOCNUM) = 'Amplitude'
         CPREF(2,LOCNUM) = PREF
         RPVAL(2,LOCNUM) = ORANGE(1,3) * YMULT
         AXINC(2,LOCNUM) = (ORANGE(2,3) - ORANGE(1,3)) * YMULT /
     *      (LINT-1.0)
         ATEMP = XRANGE(2,2) - XRANGE(1,2)
         XMULT = ATEMP
         CALL METSCA (ATEMP, XPREF, PFLG)
         XMULT = ATEMP / XMULT
         CTYP(1,LOCNUM) = 'Rotation Measure'
         CPREF(1,LOCNUM) = XPREF
         RPVAL(1,LOCNUM) = XRANGE(1,2) * XMULT
         AXINC(1,LOCNUM) = (XRANGE(2,2) - XRANGE(1,2)) * XMULT / 999.0
         TEXT = 'FARS output__' // OUFILE
         END IF
C                                       lower plot
      XBLC(1) = BLC(1)
      XTRC(1) = TRC(1)
      XBLC(2) = BLC(2)
      XTRC(2) = LINT
C                                        Set text borders at L, B,
C                                        R & T in characters
      CALL CHNTIC (BLC, TRC, INP)
      INP = MAX (INP, 4)
      CHOUT(1) = INP + 4
      CHOUT(2) = 3.333
      CHOUT(4) = 2.0
C                                        Init. for line drawing
      CALL GINITL (BLC, TRC, XYRATI, CHOUT, PLPOS(3), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
C                                        Draw the box
      CALL GLTYPE (1, PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GPOS (BLC(1), BLC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GVEC (TRC(1), BLC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GVEC (TRC(1), TRC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GVEC (BLC(1), TRC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GVEC (BLC(1), BLC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GPOS (BLC(1), LINT, PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GVEC (TRC(1), LINT, PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL GPOS (BLC(1), TRC(2), PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
      DX = 0.0
      DY = 0.333
      INCHAR = JTRIM (TEXT)
      CALL REFRMT (TEXT, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DX, DY, TEXT, PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       label bottom plot
      CALL CLAB1 (XBLC, XTRC, CHOUT, 3, XYRATI, .FALSE., PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       top plot
      XBLC(2) = LINT
      XTRC(2) = TRC(2)
      RPLOC(2,LOCNUM) = LINT
C                                       PA
      IF ((DOREIM) .AND. (PLOTPA)) THEN
         CTYP(2,LOCNUM) = 'Position Angle'
         RPVAL(2,LOCNUM) = PRANGE(1,2)
         AXINC(2,LOCNUM) = (PRANGE(2,2) - PRANGE(1,2)) /
     *      (TRC(2)-LINT-1.0)
         CPREF(2,LOCNUM) = ' '
C                                       U
      ELSE IF (DOREIM) THEN
         CTYP(2,LOCNUM) = 'U Jy/beam'
         RPVAL(2,LOCNUM) = ORANGE(1,2) * YMULT
         AXINC(2,LOCNUM) = (ORANGE(2,2) - ORANGE(1,2)) * YMULT /
     *      (TRC(2)-LINT-1.0)
C                                       phase
      ELSE
         CTYP(2,LOCNUM) = 'Phase'
         CPREF(2,LOCNUM) = ' '
         IF (ORANGE(2,4)-ORANGE(1,4).LE.ORANGE(2,5)-ORANGE(1,5)) THEN
            PADD = 0.0
            RPVAL(2,LOCNUM) = ORANGE(1,4)
            AXINC(2,LOCNUM) = (ORANGE(2,4) - ORANGE(1,4)) /
     *         (TRC(2)-LINT-1.0)
         ELSE
            PADD = 360.0
            RPVAL(2,LOCNUM) = ORANGE(1,5)
            AXINC(2,LOCNUM) = (ORANGE(2,5) - ORANGE(1,5)) /
     *         (TRC(2)-LINT-1.0)
            END IF
         END IF
      CPREF(1,LOCNUM) = ' '
      CTYP(1,LOCNUM) = ' '
      CALL CLAB1 (XBLC, XTRC, CHOUT, 3, XYRATI, .FALSE., PLTBLK, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       now plot data
C                                       P
      IF ((DOREIM) .AND. (PLOTPA)) THEN
         CALL GLTYPE (1, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         DX = 0.5
         DY = 0.5
         XL = 10000.
         XH = -1000.
C                                       A
         DO 10 I = 1,INPTS
            IF ((ADATA(I).NE.FBLANK) .AND. (ADATA(I).GE.PRANGE(1,1))
     *         .AND. (ADATA(I).LE.PRANGE(2,1))) THEN
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = (LINT - 1.0) * (ADATA(I) - PRANGE(1,1)) /
     *            (PRANGE(2,1) - PRANGE(1,1)) + 0.5
               CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               XL = MIN (XL, XP)
               XH = MAX (XH, XP)
               END IF
 10         CONTINUE
C                                       P
         DO 20 I = 1,INPTS
            IF ((PDATA(I).NE.FBLANK) .AND. (PDATA(I).GE.PRANGE(1,2))
     *         .AND. (PDATA(I).LE.PRANGE(2,2))) THEN
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = (999.0 - LINT) * (PDATA(I) - PRANGE(1,2)) /
     *            (PRANGE(2,2) - PRANGE(1,2)) + LINT + 0.5
               CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               XL = MIN (XL, XP)
               XH = MAX (XH, XP)
               END IF
 20         CONTINUE
C                                       now plot current guess
         CALL GLTYPE (2, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         DX = (XRANGE(2,1) - XRANGE(1,1)) / 999.0
         DP = -DX + XRANGE(1,1)
         PFLG = .TRUE.
C                                       fill array
         DO 30 I = 1,1000
            DP = DP + DX
            XP = 999.0 * (DP - XRANGE(1,1)) /
     *         (XRANGE(2,1) - XRANGE(1,1)) + 0.5
            IF ((XP.GE.XL) .AND. (XP.LE.XH)) THEN
               QQ = 0.0
               UU = 0.0
               J = -4
               DO 25 K = 1,NG
                  J = J + 4
                  AMP = PARMS(J+1)
                  IF (SPIXDO.EQ.1) THEN
                     AMP = AMP * ((LAMSQ1/DP) ** (0.5D0 * PARMS(J+4)))
                  ELSE IF (SPIXDO.GE.2) THEN
                     X = PARMS(J+4) * DP
                     AMP = AMP * DSINCS (SPIXDO, 0, X)
                     END IF
                  QQ = QQ + AMP * COS (2.0D0*DG2RAD*PARMS(J+2) +
     *               2.0D0 * DP * PARMS(J+3))
                  UU = UU + AMP * SIN (2.0D0*DG2RAD*PARMS(J+2) +
     *               2.0D0 * DP * PARMS(J+3))
 25               CONTINUE
               PP(I) = SQRT (QQ*QQ + UU*UU)
               AA(I) = ATAN2 (UU, QQ) * RAD2DG / 2.0D0
               END IF
 30         CONTINUE
         DP = -DX + XRANGE(1,1)
         PFLG = .TRUE.
         DO 35 I = 1,1000
            DP = DP + DX
            XP = 999.0 * (DP - XRANGE(1,1)) /
     *         (XRANGE(2,1) - XRANGE(1,1)) + 0.5
            IF ((XP.GE.XL) .AND. (XP.LE.XH)) THEN
               IF ((PP(I).GE.PRANGE(1,1)) .AND. (PP(I).LE.PRANGE(2,1)))
     *            THEN
                  YP = (LINT - 1.0) * (PP(I) - PRANGE(1,1)) /
     *               (PRANGE(2,1) - PRANGE(1,1)) + 0.5
                  IF (PFLG) THEN
                     CALL GPOS (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                  ELSE
                     CALL GVEC (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                     END IF
                  PFLG = .FALSE.
               ELSE
                  PFLG = .TRUE.
                  END IF
            ELSE
               PFLG = .TRUE.
               END IF
 35         CONTINUE
C                                       Ang guess
         DP = -DX + XRANGE(1,1)
         PFLG = .TRUE.
         DO 40 I = 1,1000
            DP = DP + DX
            XP = 999.0 * (DP - XRANGE(1,1)) /
     *         (XRANGE(2,1) - XRANGE(1,1)) + 0.5
            IF ((XP.GE.XL) .AND. (XP.LE.XH)) THEN
               IF ((I.GT.1) .AND. (ABS(AA(I)-AA(I-1)).GT.60.)) PFLG =
     *            .TRUE.
               IF ((AA(I).GE.PRANGE(1,2)) .AND. (AA(I).LE.PRANGE(2,2)))
     *            THEN
                  YP = (999.0 - LINT) * (AA(I) - PRANGE(1,2)) /
     *               (PRANGE(2,2) - PRANGE(1,2)) + LINT + 0.5
                  IF (PFLG) THEN
                     CALL GPOS (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                  ELSE
                     CALL GVEC (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                     END IF
                  PFLG = .FALSE.
               ELSE
                 PFLG = .TRUE.
                 END IF
            ELSE
               PFLG = .TRUE.
               END IF
 40         CONTINUE
C                                       Q
      ELSE IF (DOREIM) THEN
         CALL GLTYPE (1, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         DX = 0.5
         DY = 0.5
         XL = 10000.
         XH = -1000.
         DO 110 I = 1,INPTS
            IF ((QDATA(I).NE.FBLANK) .AND. (QDATA(I).GE.ORANGE(1,1))
     *         .AND. (QDATA(I).LE.ORANGE(2,1))) THEN
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = (LINT - 1.0) * (QDATA(I) - ORANGE(1,1)) /
     *            (ORANGE(2,1) - ORANGE(1,1)) + 0.5
               CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               XL = MIN (XL, XP)
               XH = MAX (XH, XP)
               END IF
 110        CONTINUE
C                                       U
         DO 120 I = 1,INPTS
            IF ((UDATA(I).NE.FBLANK) .AND. (UDATA(I).GE.ORANGE(1,2))
     *         .AND. (UDATA(I).LE.ORANGE(2,2))) THEN
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = (999.0 - LINT) * (UDATA(I) - ORANGE(1,2)) /
     *            (ORANGE(2,2) - ORANGE(1,2)) + LINT + 0.5
               CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               XL = MIN (XL, XP)
               XH = MAX (XH, XP)
               END IF
 120        CONTINUE
C                                       now plot current guess
         CALL GLTYPE (2, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         DX = (XRANGE(2,1) - XRANGE(1,1)) / 999.0
         DP = -DX + XRANGE(1,1)
         PFLG = .TRUE.
         DO 130 I = 1,1000
            DP = DP + DX
            XP = 999.0 * (DP - XRANGE(1,1)) /
     *         (XRANGE(2,1) - XRANGE(1,1)) + 0.5
            IF ((XP.GE.XL) .AND. (XP.LE.XH)) THEN
               QQ = 0.0
               J = -4
               DO 125 K = 1,NG
                  J = J + 4
                  AMP = PARMS(J+1)
                  IF (SPIXDO.EQ.1) THEN
                     AMP = AMP * ((LAMSQ1/DP) ** (0.5D0 * PARMS(J+4)))
                  ELSE IF (SPIXDO.GE.2) THEN
                     X = PARMS(J+4) * DP
                     AMP = AMP * DSINCS (SPIXDO, 0, X)
                     END IF
                  QQ = QQ + AMP * COS (2.0D0*DG2RAD*PARMS(J+2) +
     *               2.0D0 * DP * PARMS(J+3))
 125              CONTINUE
               IF ((QQ.GE.ORANGE(1,1)) .AND. (QQ.LE.ORANGE(2,1))) THEN
                  YP = (LINT - 1.0) * (QQ - ORANGE(1,1)) /
     *               (ORANGE(2,1) - ORANGE(1,1)) + 0.5
                  IF (PFLG) THEN
                     CALL GPOS (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                  ELSE
                     CALL GVEC (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                     END IF
                  PFLG = .FALSE.
               ELSE
                  PFLG = .TRUE.
                  END IF
            ELSE
               PFLG = .TRUE.
               END IF
 130        CONTINUE
C                                       U guess
         DP = -DX + XRANGE(1,1)
         PFLG = .TRUE.
         DO 140 I = 1,1000
            DP = DP + DX
            XP = 999.0 * (DP - XRANGE(1,1)) /
     *         (XRANGE(2,1) - XRANGE(1,1)) + 0.5
            IF ((XP.GE.XL) .AND. (XP.LE.XH)) THEN
               UU = 0.0
               J = -4
               DO 135 K = 1,NG
                  J = J + 4
                  AMP = PARMS(J+1)
                  IF (SPIXDO.EQ.1) THEN
                     AMP = AMP * ((LAMSQ1/DP) ** (0.5D0 * PARMS(J+4)))
                  ELSE IF (SPIXDO.GE.2) THEN
                     X = PARMS(J+4) * DP
                     AMP = AMP * DSINCS (SPIXDO, 0, X)
                     END IF
                  UU = UU + AMP * SIN (2.0D0*DG2RAD*PARMS(J+2) +
     *               2.0D0 * DP * PARMS(J+3))
 135              CONTINUE
               IF ((UU.GE.ORANGE(1,2)) .AND. (UU.LE.ORANGE(2,2))) THEN
                  YP = (999.0 - LINT) * (UU - ORANGE(1,2)) /
     *               (ORANGE(2,2) - ORANGE(1,2)) + LINT + 0.5
                  IF (PFLG) THEN
                     CALL GPOS (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                  ELSE
                     CALL GVEC (XP, YP, PLTBLK, IERR)
                     IF (IERR.NE.0) GO TO 980
                     END IF
                  PFLG = .FALSE.
               ELSE
                 PFLG = .TRUE.
                 END IF
            ELSE
               PFLG = .TRUE.
               END IF
 140        CONTINUE
C                                       FARS amplitude
      ELSE
         CALL GLTYPE (1, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         XX = (RMDATA(2) - RMDATA(1))*999.0/(XRANGE(2,2)-XRANGE(1,2))
         DP = RMDATA(1)
         XP = 999.0 * (DP - XRANGE(1,2)) / (XRANGE(2,2) - XRANGE(1,2)) +
     *      0.5
         XP = XP - XX - XX/2.0
         PFLG = .TRUE.
         DO 210 I = 1,INPTS
            XP = XP + XX
            IF ((AMDATA(I).NE.FBLANK) .AND. (PHDATA(I).NE.FBLANK)) THEN
               DP = AMDATA(I)
               YP = (LINT - 1.0) * (DP - ORANGE(1,3)) /
     *            (ORANGE(2,3) - ORANGE(1,3)) + 0.5
               IF (PFLG) THEN
                  CALL GPOS (XP, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
               ELSE
                  CALL GVEC (XP, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  END IF
               CALL GVEC (XP+XX, YP, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               PFLG = .FALSE.
            ELSE
               PFLG = .TRUE.
               END IF
 210        CONTINUE
C                                       phase
         DX = 1.5
         DY = 1.5
         J = 4
         IF (PADD.EQ.360.0) J = 5
         XX = (RMDATA(2)-RMDATA(1))*999.0/(XRANGE(2,2)-XRANGE(1,2))
         DP = RMDATA(1)
         XP = 999.0 * (DP - XRANGE(1,2)) / (XRANGE(2,2) - XRANGE(1,2)) +
     *      0.5
         XP = XP - XX
         DO 220 I = 1,INPTS
            IF ((AMDATA(I).NE.FBLANK) .AND. (PHDATA(I).NE.FBLANK)) THEN
               XP = XP + XX
               DP = PHDATA(I)
               IF (DP.LT.0.0) DP = DP + PADD
               YP = (999.0-LINT) * (DP - ORANGE(1,J)) /
     *            (ORANGE(2,J) - ORANGE(1,J)) + LINT + 0.5
               CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
               IF (IERR.NE.0) GO TO 980
               END IF
 220        CONTINUE
C                                       plot current guess
         CALL GLTYPE (2, PLTBLK, IERR)
         IF (IERR.NE.0) GO TO 980
         L = -4
         DX = 7.0
         DY = 7.0
         DO 230 K = 1,NG
            L = L + 4
            CALL FNDPIX (PARMS(L+3), I)
            XP = 999.0 * (PARMS(L+3) - XRANGE(1,2)) /
     *         (XRANGE(2,2) - XRANGE(1,2)) + 0.5
            IF (LLCOMP(L+1).LT.0) XP = -9.0
            DP = AMDATA(I)
            IF (LLCOMP(L+1).LT.0) DP = 0.0
            YP = (LINT - 1.0) * (DP - ORANGE(1,3)) /
     *         (ORANGE(2,3) - ORANGE(1,3)) + 0.5
            CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            DP = PHDATA(I)
            IF (DP.LT.0.0) DP = DP + PADD
            IF (LLCOMP(L+1).LT.0) DP = 0.0
            YP = (999.0-LINT) * (DP - ORANGE(1,J)) /
     *         (ORANGE(2,J) - ORANGE(1,J)) + LINT + 0.5
            CALL GPOS (XP+DX, YP+DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GVEC (XP-DX, YP-DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GPOS (XP-DX, YP+DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
            CALL GVEC (XP+DX, YP-DY, PLTBLK, IERR)
            IF (IERR.NE.0) GO TO 980
 230        CONTINUE
         END IF
C
 980  IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1980) IERR
         CALL MSGWRT (8)
         END IF
      CALL YHOLD ('OFFF', K)
C
 999  RETURN
C-----------------------------------------------------------------------
 1980 FORMAT ('RTVPLT: ERROR',I4,' FROM TV PLOT ROUTINES')
      END
      SUBROUTINE GTVGUS (NG, PARMS, IERR)
C-----------------------------------------------------------------------
C   GTVGUS has the user point at the desired initial guess for each
C   Component with the TV cursor.  It will accept that there is no
C   component "n" at this row.  It sets the PARMS and plots the new
C   guess with + signs.
C   Inputs:
C      NG       I       Number of Components
C   Output:
C      PARMS    D(16)   Initial guess
C      FVEC     D(*)    Work buffer - size of data
C      IERR     I       error code: 0 -> ok
C-----------------------------------------------------------------------
      INTEGER   NG, IERR
      DOUBLE PRECISION PARMS(*)
C
      CHARACTER MSGBUF*80
      REAL      RPOS(2)
      INTEGER   I, J, IXT, IYT, IX, IY, JERR, IX0, IY0, QUAD, IBUT
      LOGICAL   T, F
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
      INCLUDE 'INCS:DGPH.INC'
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Set scales
      IXT = GPHCAT(IICOR+2)
      IYT = GPHCAT(IICOR+3)
      IX0 = GPHCAT(IICOR)
      IY0 = GPHCAT(IICOR+1)
      CALL YHOLD ('FFFF', IERR)
C                                       Open terminal
      IF (TTYIND.LE.0) THEN
         CALL ZOPEN (TTYLUN, TTYIND, 1, MSGBUF, F, T, T, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (6)
            GO TO 999
            END IF
         END IF
C                                       Loop over components.
      J = -4
      DO 40 I = 1,NG
         J = J + 4
C                                       read peak and position
         IF ((DOCOMP(J+1).GT.0) .OR. (DOCOMP(J+2).GT.0)) THEN
            WRITE (MSGBUF,1020) I
            CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
            IF (IERR.NE.0) GO TO 900
            CALL TVWHER (QUAD, RPOS, IBUT, IERR)
            IF (IERR.NE.0) GO TO 990
            IX = RPOS(1) + 0.5
            IY = RPOS(2) + 0.5

C                                       Set peak and position
            IF ((IX.GE.IX0) .AND. (IY.GE.IY0) .AND. (IX.LE.IXT) .AND.
     *         (IY.LE.IYT)) THEN
               LLCOMP(J+1) = DOCOMP(J+1)
               LLCOMP(J+2) = DOCOMP(J+2)
               LLCOMP(J+3) = DOCOMP(J+3)
               LLCOMP(J+4) = DOCOMP(J+4)
               IF (LLCOMP(J+1).GT.0) THEN
                  PARMS(J+3) = ((RPOS(1) - IX0) / (IXT - IX0)) *
     *               (XRANGE(2,2) - XRANGE(1,2)) + XRANGE(1,2)
                  IX = (PARMS(J+3) - RMDATA(1)) / (RMDATA(2)-RMDATA(1))
     *               + 1.5
                  PARMS(J+1) = AMDATA(IX)
                  PARMS(J+2) = 0.5D0 * PHDATA(IX)
                  IF (SPIXDO.GE.2) THEN
                     PARMS(J+4) = 5.0D0
                  ELSE
                     PARMS(J+4) = 0.0D0
                     END IF
                  END IF
C                                       Blank this component
            ELSE
               PARMS(J+1) = 0.0D0
               PARMS(J+2) = 0.0D0
               PARMS(J+3) = 0.0D0
               PARMS(J+4) = 0.0D0
               LLCOMP(J+1) = -1
               LLCOMP(J+2) = -1
               LLCOMP(J+3) = -1
               LLCOMP(J+4) = -1
               END IF
            END IF
 40      CONTINUE
      GO TO 990
C                                       terminal error
 900  WRITE (MSGTXT,1900) IERR
      CALL MSGWRT (6)
C                                       Close hold
 990  CALL YHOLD ('OFFF', JERR)
      IF (TTYIND.GT.0) THEN
          CALL ZCLOSE (TTYLUN, TTYIND, JERR)
          TTYIND = 0
          END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I5,' OPENING TERMINAL')
 1020 FORMAT ('Position cursor at center (RM) of component ',I2)
 1900 FORMAT ('ERROR',I5,' WRITING TO TERMINAL')
      END
      SUBROUTINE RTVMOD (INPTS, NG, IPOS, NCOMPS, FVEC, RANGQU, PARMS,
     *   PERR, IERR)
C-----------------------------------------------------------------------
C   RTVMOD plots the model functions on the TV.  It asks the user for
C   permission to proceed.
C   Inputs:
C      INPTS    I      Number of data points
C      NCOMPS   I      Max number Components allowed
C      IPOS     I(*)   Position in cube
C      FVEC     D(*)   data - model
C      PERR     I      > 0 => probable parameter bad
C   In/Out:
C      NG       I      Number of Components: retry can ask for fewer
C      PARMS    D(*)   Model parameters
C   Output:
C      IERR     I      TV error code
C                         101 => blank this solution
C                         102 => User wants to quit
C                         103 => do a retry
C                         104 => TV off
C                         105 => Do fit with this guess
C-----------------------------------------------------------------------
      INTEGER   INPTS, NG, IPOS(*), NCOMPS, PERR, IERR
      DOUBLE PRECISION FVEC(*), PARMS(*)
      REAL      RANGQU(2,4)
C
      CHARACTER CTEMP*1, MSGBUF*80, FIRSTC*1, CHS*32
      INTEGER   I, J, JERR, JTRIM, NCHS, IGR, SCRTCH(4096)
      REAL      XP, YP, DX, DY, LINT, TEMP, QQ, UU, PP, AA
      LOGICAL   T, F, WHAND
      DOUBLE PRECISION QRMS, URMS, QCNT, UCNT, QWRMS, UWRMS
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'FTARSD.INC'
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
 10   IERR = 0
      CALL YHOLD ('ONNN', IERR)
      CHS = ' '
      IF (NCOMPS.EQ.2) THEN
         CHS = '''1'', ''2'''
      ELSE IF (NCOMPS.EQ.3) THEN
         CHS = '''1'', ''2'', ''3'''
      ELSE IF (NCOMPS.EQ.4) THEN
         CHS = '''1'', ''2'', ''3'', ''4'''
         END IF
      NCHS = JTRIM (CHS)
      WHAND = .FALSE.
C                                       Plot model
      IGR = IGR4
      CALL GLTYPE (4, PLTBLK, IERR)
      IF (IGR.NE.IGR1) THEN
         CALL YZERO (IGR, IERR)
         IF (IERR.NE.0) GO TO 980
         END IF
      LINT = 500.0
      DX = 1.5
      DY = 1.5
      QRMS = 0.0D0
      URMS = 0.0D0
      QWRMS = 0.0D0
      UWRMS = 0.0D0
      QCNT = 0.0D0
      UCNT = 0.0D0
C                                       P and ang
      IF (PLOTPA) THEN
         DO 30 I = 1,INPTS
C                                       Q
            IF ((QDATA(I).NE.FBLANK) .AND. (UDATA(I).NE.FBLANK)) THEN
               TEMP = FVEC(I)
               QWRMS = QWRMS + FVEC(I)**2
               QRMS = QRMS + TEMP**2
               QCNT = QCNT + 1.0D0
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               QQ = QDATA(I) - TEMP
               TEMP = FVEC(I+INPTS)
               URMS = URMS + TEMP**2
               UWRMS = UWRMS + FVEC(I+INPTS)**2
               UCNT = UCNT + 1.0D0
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               UU = UDATA(I) - TEMP
               PP = SQRT (QQ*QQ + UU*UU)
               AA = ATAN2 (UU, QQ) * RAD2DG / 2.0D0
               IF ((PP.GE.PRANGE(1,1)) .AND. (PP.LE.PRANGE(2,1))) THEN
                  YP = (LINT - 1.0) * (PP - PRANGE(1,1)) /
     *               (PRANGE(2,1) - PRANGE(1,1)) + 0.5
                  CALL GPOS (XP, YP+DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP, YP-DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GPOS (XP-DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP+DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  END IF
               IF ((AA.GE.PRANGE(1,2)) .AND. (AA.LE.PRANGE(2,2))) THEN
                  YP = (LINT - 1.0) * (AA - PRANGE(1,2)) /
     *               (PRANGE(2,2) - PRANGE(1,2)) + LINT + 0.5
                  CALL GPOS (XP, YP+DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP, YP-DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GPOS (XP-DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP+DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  END IF
               END IF
 30         CONTINUE
      ELSE
         DO 60 I = 1,INPTS
C                                       Q
            IF (QDATA(I).NE.FBLANK) THEN
               TEMP = FVEC(I)
               QWRMS = QWRMS + FVEC(I)**2
               QRMS = QRMS + TEMP**2
               QCNT = QCNT + 1.0D0
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = QDATA(I) - TEMP
               IF ((YP.GE.ORANGE(1,1)) .AND. (YP.LE.ORANGE(2,1))) THEN
                  YP = (LINT - 1.0) * (YP - ORANGE(1,1)) /
     *               (ORANGE(2,1) - ORANGE(1,1)) + 0.5
                  CALL GPOS (XP, YP+DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP, YP-DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GPOS (XP-DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP+DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  END IF
               END IF
C                                       U
            IF (UDATA(I).NE.FBLANK) THEN
               TEMP = FVEC(I+INPTS)
               URMS = URMS + TEMP**2
               UWRMS = UWRMS + FVEC(I+INPTS)**2
               UCNT = UCNT + 1.0D0
               XP = 999.0 * (LAMSQ(I) - XRANGE(1,1)) /
     *            (XRANGE(2,1) - XRANGE(1,1)) + 0.5
               YP = UDATA(I) - TEMP
               IF ((YP.GE.ORANGE(1,2)) .AND. (YP.LE.ORANGE(2,2))) THEN
                  YP = (LINT - 1.0) * (YP - ORANGE(1,2)) /
     *               (ORANGE(2,2) - ORANGE(1,2)) + LINT + 0.5
                  CALL GPOS (XP, YP+DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP, YP-DY, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GPOS (XP-DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  CALL GVEC (XP+DX, YP, PLTBLK, IERR)
                  IF (IERR.NE.0) GO TO 980
                  END IF
               END IF
 60         CONTINUE
         END IF
      IF (QCNT.GT.0.0D0) QRMS = SQRT (QRMS/QCNT)
      IF (UCNT.GT.0.0D0) URMS = SQRT (URMS/UCNT)
      IF (QCNT.GT.0.0D0) QWRMS = SQRT (QWRMS/QCNT)
      IF (UCNT.GT.0.0D0) UWRMS = SQRT (UWRMS/UCNT)
      THERMS(1,1) = QRMS
      THERMS(2,1) = URMS
      THERMS(1,2) = QWRMS
      THERMS(2,2) = UWRMS
C                                       Open TTY
      IF (TTYIND.LE.0) THEN
         CALL ZOPEN (TTYLUN, TTYIND, 1, MSGBUF, F, T, T, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1900) IERR
            CALL MSGWRT (6)
            GO TO 999
            END IF
         END IF
      IF (PERR.GT.0) THEN
         WRITE (MSGBUF,1910)
         CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 980
         END IF
      WRITE (MSGBUF,1912) QWRMS, UWRMS
      CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      J = 1
      DO 905 I = 1,NG
         WRITE (MSGBUF,1913) I, PARMS(J), PARMS(J+1), PARMS(J+2),
     *      PARMS(J+3)
         CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 980
         J = J + 4
 905     CONTINUE
      CALL RMMEN2 (PLOTPA, NCOMPS, WHAND, MSGBUF, SCRTCH, JERR)
      IF (IERR.NE.0) GO TO 980
      WHAND = .FALSE.
      CTEMP = FIRSTC (MSGBUF)
      IF (CTEMP.EQ.'B') THEN
         IERR = 101
      ELSE IF (CTEMP.EQ.'Q') THEN
         IERR = 102
      ELSE IF (CTEMP.EQ.'T') THEN
         IERR = 104
      ELSE IF (CTEMP.EQ.'R') THEN
         IERR = 103
      ELSE IF (CTEMP.EQ.'D') THEN
         IERR = 105
      ELSE IF (CTEMP.EQ.'E') THEN
         IERR = 103
      ELSE IF (CTEMP.EQ.'1') THEN
         IERR = 103
         NG = 1
      ELSE IF ((CTEMP.EQ.'2') .AND. (NCOMPS.GE.2)) THEN
         IERR = 103
         NG = 2
      ELSE IF ((CTEMP.EQ.'3') .AND. (NCOMPS.GE.3)) THEN
         IERR = 103
         NG = 3
      ELSE IF ((CTEMP.EQ.'4') .AND. (NCOMPS.GE.4)) THEN
         IERR = 103
         NG = 4
      ELSE IF (CTEMP.EQ.'H') THEN
         WHAND = .TRUE.
         I = 2 * INPTS
         CALL RMHAND (MSGBUF, NG, NCOMPS, I, PARMS, FVEC, IERR)
         PERR = 0
         IF (IERR.EQ.0) GO TO 10
         IERR = MAX (IERR, 0)
      ELSE IF (CTEMP.EQ.'P') THEN
         CALL RMPIXR (INPTS, NG, IPOS, PARMS, MSGBUF, RANGQU)
         GO TO 10
      ELSE IF (CTEMP.EQ.'S') THEN
         PLOTPA = .NOT.PLOTPA
         CALL YHOLD ('ONNN', IERR)
         CALL YZERO (IGR1, IERR)
         IF (IERR.NE.0) GO TO 990
         IF (IGR2.NE.IGR1) THEN
            CALL YZERO (IGR2, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR3, IERR)
            IF (IERR.NE.0) GO TO 990
            CALL YZERO (IGR4, IERR)
            IF (IERR.NE.0) GO TO 990
            END IF
         CALL RTVPLT (.TRUE., INPTS, NG, PARMS, IERR)
         IF (IERR.EQ.0) GO TO 10
         CALL YHOLD ('OFFF', IERR)
         END IF
      GO TO 990
C                                       TTY error
 980  WRITE (MSGTXT,1980) IERR
      CALL MSGWRT (6)
 990  IF (TTYIND.GT.0) THEN
         CALL ZCLOSE (TTYLUN, TTYIND, JERR)
         TTYIND = 0
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1900 FORMAT ('OPEN TERMINAL ERROR',I7)
 1910 FORMAT ('>>>> PARAMETERS SEEM OUT OF RANGE.  SOLUTION PROBABLY ',
     *   'BAD! <<<<')
 1912 FORMAT ('RMS residual Q',F11.6,' U',F11.6)
 1913 FORMAT ('Component',I2,F12.6,F10.2,F10.3,F9.3)
 1980 FORMAT ('TERMINAL I/O ERROR',I7)
      END
      SUBROUTINE RMMEN2 (PLOTPA, NG, WHAND, MSGBUF, SCRTCH, JERR)
C-----------------------------------------------------------------------
C   Does a TV menu for post-fit stage of user questions
C   Inputs:
C      NG       I       Number Gaussians max
C      WHAND    L       T => last command was HAND (add DO FIT to menu)
C   Outputs:
C      MSGBUF   C*(*)   answer: E, B, Q, other
C      JERR     I       error
C-----------------------------------------------------------------------
      LOGICAL   PLOTPA
      INTEGER   NG, SCRTCH(*), JERR
      LOGICAL   WHAND
      CHARACTER MSGBUF*(*)
C
      INTEGER   NCHS
      PARAMETER (NCHS = 11)
C
      INTEGER   MTYPE, NCOL, NROWS, GRCHS(2), TOPSEP, SIDSEP, TIMLIM,
     *   NTITLE, TVBUTT, CHOICE, I, N
      LOGICAL   LEAVE(NCHS)
      CHARACTER CHOICS(NCHS)*8, TITLE*8, ISHELP*6, CHOICZ(NCHS)*8
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA CHOICZ /'RE-GUESS', 'HAND', 'PIXRANGE', 'SHOW P&A', '1', '2',
     *   '3', '4', ' ', 'QUIT', 'DO FIT'/
C      DATA LEAVE /8*.FALSE., 2*.TRUE., .FALSE./
      DATA LEAVE /11*.TRUE./
      DATA ISHELP /'XGAUS'/
C-----------------------------------------------------------------------
      NROWS = 4 + NG
      CHOICS(1) = CHOICZ(1)
      CHOICS(2) = CHOICZ(2)
      IF (PLOTPA) THEN
         CHOICZ(4) = 'SHOW Q&U'
      ELSE
         CHOICZ(4) = 'SHOW P&A'
         END IF
      N = 2
      IF (WHAND) THEN
         NROWS = NROWS + 1
         CHOICS(2) = 'DO FIT'
         N = 3
         END IF
      DO 10 I = 3,NROWS
         N = N + 1
         CHOICS(N) = CHOICZ(I)
 10      CONTINUE
      CHOICS(NROWS+1) = ' '
      CHOICS(NROWS+2) = 'QUIT'
      LEAVE(NROWS+1) = .TRUE.
      LEAVE(NROWS+2) = .FALSE.
      NROWS = NROWS + 2
      GRCHS(1) = 6
      GRCHS(2) = 5
      MTYPE = 1
      NCOL = 1
      SIDSEP = 6 * CSIZTV(1)
      TOPSEP = 5 * CSIZTV(2)
      NTITLE = 0
      TITLE = ' '
      TIMLIM = 0
      MSGBUF = ' '
C                                       menu
 20   CALL TVMENU (MTYPE, NCOL, NROWS, GRCHS, TOPSEP, SIDSEP, ISHELP,
     *   CHOICS, TIMLIM, LEAVE, NTITLE, TITLE, CHOICE, TVBUTT, SCRTCH,
     *   JERR)
      IF (JERR.NE.0) THEN
         MSGTXT = 'RMMEN2: ERROR FROM TV MENU'
         CALL MSGWRT (7)
      ELSE IF (CHOICS(CHOICE).EQ.' ') THEN
         GO TO 20
      ELSE
         MSGBUF = CHOICS(CHOICE)(:1)
         END IF
C
 999  RETURN
      END
      SUBROUTINE FTARCH (NG, INPTS, FVEC, PARMS, IERR)
C-----------------------------------------------------------------------
C   FTARCH checks the answers for being at least vaguely reasonable.
C   Inputs:
C      NG      I       Number of Components
C      INPTS   I      Number of data samples in Q/U
C      FVEC    D(*)   weighted residuals
C      PARMS   D      Answers
C   Output:
C      IERR    I      0 -> all in range, 1 -> some not
C-----------------------------------------------------------------------
      INTEGER   NG, INPTS, IERR
      DOUBLE PRECISION PARMS(*), FVEC(*)
C
      REAL      X, PMAX, RMAX, RMIN
      INTEGER   IAMP, I
      DOUBLE PRECISION QRMS, URMS, QCNT, UCNT, QWRMS, UWRMS, TEMP
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
C-----------------------------------------------------------------------
C                                       need rmses
      QRMS = 0.0D0
      URMS = 0.0D0
      QWRMS = 0.0D0
      UWRMS = 0.0D0
      QCNT = 0.0D0
      UCNT = 0.0D0
      DO 60 I = 1,INPTS
C                                       Q
         IF (QDATA(I).NE.FBLANK) THEN
            TEMP = FVEC(I)
            QWRMS = QWRMS + FVEC(I)**2
            QRMS = QRMS + TEMP**2
            QCNT = QCNT + 1.0D0
            END IF
C                                       U
         IF (UDATA(I).NE.FBLANK) THEN
            TEMP = FVEC(I+INPTS)
            URMS = URMS + TEMP**2
            UWRMS = UWRMS + FVEC(I+INPTS)**2
            UCNT = UCNT + 1.0D0
            END IF
 60      CONTINUE
      IF (QCNT.GT.0.0D0) QRMS = SQRT (QRMS/QCNT)
      IF (UCNT.GT.0.0D0) URMS = SQRT (URMS/UCNT)
      IF (QCNT.GT.0.0D0) QWRMS = SQRT (QWRMS/QCNT)
      IF (UCNT.GT.0.0D0) UWRMS = SQRT (UWRMS/UCNT)
      THERMS(1,1) = QRMS
      THERMS(2,1) = URMS
      THERMS(1,2) = QWRMS
      THERMS(2,2) = UWRMS
C                                       Check answers
      PMAX = QURANG(2,3)
      RMAX = RMRANG(2,1) - ABS (RMDATA(2)-RMDATA(1))
      RMIN = RMRANG(1,1) + ABS (RMDATA(2)-RMDATA(1))
      IF (RMAX.LT.RMIN) THEN
         X = RMAX
         RMAX = RMIN
         RMIN = X
         END IF
      IERR = 1
      IF ((QRMS.GT.RMSLIM) .OR. (URMS.GT.RMSLIM)) GO TO 999
      DO 130 I = 1,NG
         IAMP = 4 * I - 3
         X = PARMS(IAMP)
         IF (((X.LT.0.0) .OR. (X.GT.PMAX)) .AND. (LLCOMP(IAMP).GT.0))
     *      GO TO 999
         X = ABS (PARMS(IAMP+2))
         IF (((X.LT.RMIN) .OR. (X.GT.RMAX)) .AND. (LLCOMP(IAMP+2).GT.0))
     *      GO TO 999
         IF (LLCOMP(IAMP+3).GT.0) THEN
            IF (SPIXDO.EQ.1) THEN
               IF (ABS(PARMS(IAMP+3)).GT.4.0) GO TO 999
            ELSE IF (SPIXDO.GE.2) THEN
               PARMS(IAMP+3) = ABS (PARMS(IAMP+3))
               IF (PARMS(IAMP+3).GT.(RMAX-RMIN)/4.0) GO TO 999
               END IF
            END IF
 130     CONTINUE
      IERR = 0
C
 999  RETURN
      END
      SUBROUTINE RMHAND (MSGBUF, NG, NCOMPS, INPTS, PARMS, FVEC, IERR)
C-----------------------------------------------------------------------
C   Enter guesses as hand numbers
C   Inputs:
C      NG       I       Number Components: currently
C      NCOMPS   I       Max number of Components
C      INPTS    I       Number points in FVEC
C   In/out:
C      MSGBUF   C*(*)   Message buffer
C      PARMS    D(*)    Parameters
C      FVEC     D(*)    Residuals
C   Output:
C      IERR     I       0 => carry on
C-----------------------------------------------------------------------
      INTEGER   NG, NCOMPS, INPTS, IERR
      CHARACTER MSGBUF*(*)
      DOUBLE PRECISION PARMS(*), FVEC(*)
C
      INCLUDE 'FTARSD.INC'
      INTEGER   I, J, K, JTRIM, KBP, MP
      DOUBLE PRECISION XX, OPARMS(MAXPRM), FJAC(MAXPRM,MAXPRM),
     *   VALVAR(MAXPRM)
      CHARACTER TYPE4*5
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      J = 1
      CALL DPCOPY (MAXPRM, PARMS, OPARMS)
      IF (SPIXDO.EQ.1) THEN
         TYPE4 = 'spix'
      ELSE IF (SPIXDO.GE.2) THEN
         TYPE4 = 'thick'
      ELSE
         TYPE4 = ' '
         END IF
      DO 20 I = 1,NG
         IF (LLCOMP(J+3).LE.0) THEN
            WRITE (MSGBUF,1000) I
         ELSE
            WRITE (MSGBUF,1010) I, TYPE4
            END IF
         CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 999
         CALL ZTTYIO ('READ', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 999
         K = JTRIM (MSGBUF)
         KBP = 1
         CALL GETNUM (MSGBUF, K, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         PARMS(J) = XX
         CALL GETNUM (MSGBUF, K, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         PARMS(J+1) = XX
         CALL GETNUM (MSGBUF, K, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         PARMS(J+2) = XX
         IF (LLCOMP(J+3).GT.0) THEN
            CALL GETNUM (MSGBUF, K, KBP, XX)
            IF (XX.EQ.DBLANK) GO TO 900
            PARMS(J+3) = XX
            END IF
         J = J + 4
 20      CONTINUE
      DO 30 I = NG+1,NCOMPS
         IF (LLCOMP(J+3).LE.0) THEN
            WRITE (MSGBUF,1020) I
         ELSE
            WRITE (MSGBUF,1010) I, TYPE4
            CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
            IF (IERR.NE.0) GO TO 999
            WRITE (MSGBUF,1011)
            END IF
         CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 999
         CALL ZTTYIO ('READ', TTYLUN, TTYIND, 72, MSGBUF, IERR)
         IF (IERR.NE.0) GO TO 999
         K = JTRIM (MSGBUF)
         KBP = 1
         CALL GETNUM (MSGBUF, K, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 900
         IF (XX.LE.0.0D0) THEN
            GO TO 40
         ELSE
            NG = I
            PARMS(J) = XX
            CALL GETNUM (MSGBUF, K, KBP, XX)
            IF (XX.EQ.DBLANK) GO TO 900
            PARMS(J+1) = XX
            CALL GETNUM (MSGBUF, K, KBP, XX)
            IF (XX.EQ.DBLANK) GO TO 900
            PARMS(J+2) = XX
            IF (LLCOMP(J+3).GT.0) THEN
               CALL GETNUM (MSGBUF, K, KBP, XX)
               IF (XX.EQ.DBLANK) GO TO 900
               PARMS(J+3) = XX
               END IF
            J = J + 4
            END IF
 30      CONTINUE
C                                       evaluate residual
 40   ITTER = 0
      NITTER = 100
      MP = 4 * NG
      NVAR = 0
      K = 0
      DO 84 I = 1,NG
         DO 83 J = 1,4
            K = K + 1
            IF (LLCOMP(K).GT.0) THEN
               NVAR = NVAR + 1
               IVAR(NVAR) = I
               JVAR(NVAR) = J
               VALVAR(NVAR) = PARMS(K)
               END IF
 83         CONTINUE
 84      CONTINUE
      I = 1
      MP = NVAR
      CALL RMFUNC (INPTS, MP, VALVAR, FVEC, FJAC, I)
      GO TO 999
C                                       bad value quiet exit
 900  IERR = -1
      CALL DPCOPY (MAXPRM, OPARMS, PARMS)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Enter Component',I2,' P, theta, RM (3 values)')
 1010 FORMAT ('Enter Component',I2,' P, theta, RM, ',A,' (4 values)')
 1011 FORMAT ('                  zero -> skip this one')
 1020 FORMAT ('Enter Component',I2,' P, theta, RM (3 values)',
     *   ', zero -> skip this one')
      END
      SUBROUTINE RMPIXR (INPTS, NG, IPOS, PARMS, MSGBUF, RANGQU)
C-----------------------------------------------------------------------
C   gets a new QU pixel range
C   In/Out:
C      MSGBUF   C*(*)    message buffer
C   Outputs
C      RANGQU   R(2,4)   Q range, U range, P range, Ang range
C-----------------------------------------------------------------------
      INTEGER   INPTS, NG, IPOS(*)
      DOUBLE PRECISION PARMS(*)
      CHARACTER MSGBUF*(*)
      REAL      RANGQU(2,4)
C
      INTEGER   NCLIM, KBP, JTRIM, IERR, I
      REAL      TEMP
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'FTARS.INC'
      INCLUDE 'FTARSD.INC'
C-----------------------------------------------------------------------
      MSGBUF = 'Enter Q pixel range and U pixel range: 4 numbers'
      CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      MSGBUF = 'or 2 numbers for identical ranges or none for default'
      CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL ZTTYIO ('READ', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL RFILL (4, 0.0, RANGQU)
      NCLIM = JTRIM (MSGBUF)
      IF (NCLIM.GT.0) THEN
         KBP = 1
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 100
         RANGQU(1,1) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,1) = 0.0
            GO TO 100
            END IF
         RANGQU(2,1) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,2) = RANGQU(1,1)
            RANGQU(2,2) = RANGQU(2,1)
            GO TO 100
            END IF
         RANGQU(1,2) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,2) = 0.0
            GO TO 100
            END IF
         RANGQU(2,2) = XX
         END IF
C                                       redo the max/min if needed
 100  IF (RANGQU(2,1).LE.RANGQU(1,1)) THEN
         DO 110 I = 1,INPTS
            IF (QDATA(I).NE.FBLANK) THEN
               IF (QDATA(I).LT.ORANGE(1,1)) ORANGE(1,1) = QDATA(I)
               IF (QDATA(I).GT.ORANGE(2,1)) ORANGE(2,1) = QDATA(I)
               END IF
 110        CONTINUE
      ELSE
         ORANGE(1,1) = RANGQU(1,1)
         ORANGE(2,1) = RANGQU(2,1)
         END IF
      IF (RANGQU(2,2).LE.RANGQU(1,2)) THEN
         DO 120 I = 1,INPTS
            IF (UDATA(I).NE.FBLANK) THEN
               IF (UDATA(I).LT.ORANGE(1,2)) ORANGE(1,2) = UDATA(I)
               IF (UDATA(I).GT.ORANGE(2,2)) ORANGE(2,2) = UDATA(I)
               END IF
 120        CONTINUE
      ELSE
         ORANGE(1,2) = RANGQU(1,2)
         ORANGE(2,2) = RANGQU(2,2)
         END IF
C                                       P and A
      MSGBUF = 'Enter P pixel range and Ang pixel range: 4 numbers'
      CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      MSGBUF = 'or 2 numbers for identical ranges or none for default'
      CALL ZTTYIO ('WRIT', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL ZTTYIO ('READ', TTYLUN, TTYIND, 72, MSGBUF, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL RFILL (4, 0.0, RANGQU)
      NCLIM = JTRIM (MSGBUF)
      IF (NCLIM.GT.0) THEN
         KBP = 1
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) GO TO 200
         RANGQU(1,3) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,3) = 0.0
            GO TO 200
            END IF
         RANGQU(2,3) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,4) = 0.0
            RANGQU(2,4) = 0.0
            GO TO 200
            END IF
         RANGQU(1,4) = XX
         CALL GETNUM (MSGBUF, NCLIM, KBP, XX)
         IF (XX.EQ.DBLANK) THEN
            RANGQU(1,4) = 0.0
            GO TO 200
            END IF
         RANGQU(2,4) = XX
         END IF
C                                       redo the max/min if needed
 200  IF (RANGQU(2,3).LE.RANGQU(1,3)) THEN
         DO 210 I = 1,INPTS
            IF (PDATA(I).NE.FBLANK) THEN
               IF (PDATA(I).LT.PRANGE(1,2)) PRANGE(1,2) = PDATA(I)
               IF (PDATA(I).GT.PRANGE(2,2)) PRANGE(2,2) = PDATA(I)
               END IF
 210        CONTINUE
      ELSE
         PRANGE(1,1) = RANGQU(1,3)
         PRANGE(2,1) = RANGQU(2,3)
         END IF
      IF (RANGQU(2,4).LE.RANGQU(1,4)) THEN
         DO 220 I = 1,INPTS
            IF (ADATA(I).NE.FBLANK) THEN
               IF (ADATA(I).LT.PRANGE(1,1)) PRANGE(1,1) = ADATA(I)
               IF (ADATA(I).GT.PRANGE(2,1)) PRANGE(2,1) = ADATA(I)
               END IF
 220        CONTINUE
      ELSE
         PRANGE(1,2) = RANGQU(1,4)
         PRANGE(2,2) = RANGQU(2,4)
         END IF
      TEMP = ORANGE(2,1) - ORANGE(1,1)
      ORANGE(2,1) = ORANGE(2,1) + 0.075 * TEMP
      ORANGE(1,1) = ORANGE(1,1) - 0.075 * TEMP
      TEMP = ORANGE(2,2) - ORANGE(1,2)
      ORANGE(2,2) = ORANGE(2,2) + 0.075 * TEMP
      ORANGE(1,2) = ORANGE(1,2) - 0.075 * TEMP
      TEMP = PRANGE(2,1) - PRANGE(1,1)
      PRANGE(2,1) = PRANGE(2,1) + 0.075 * TEMP
      PRANGE(1,1) = PRANGE(1,1) - 0.075 * TEMP
      TEMP = PRANGE(2,2) - PRANGE(1,2)
      PRANGE(2,2) = PRANGE(2,2) + 0.075 * TEMP
      PRANGE(1,2) = PRANGE(1,2) - 0.075 * TEMP
C                                       clear the screens
      CALL YZERO (IGR1, IERR)
      IF (IERR.NE.0) GO TO 990
      IF (IGR2.NE.IGR1) THEN
         CALL YZERO (IGR2, IERR)
         IF (IERR.NE.0) GO TO 990
         CALL YZERO (IGR3, IERR)
         IF (IERR.NE.0) GO TO 990
         CALL YZERO (IGR4, IERR)
         IF (IERR.NE.0) GO TO 990
         END IF
C                                       plot data
      CALL RTVPLT (.TRUE., INPTS, NG, PARMS, IERR)
      IF (IERR.NE.0) GO TO 990
      CALL YHOLD ('OFFF', I)
      GO TO 990
C
 980  WRITE (MSGTXT,1980) IERR, 'I/O TO TERMINAL'
      CALL MSGWRT (8)
      GO TO 999
C                                       TV
 990  IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1980) IERR, 'WRITING TO THE TV'
         CALL MSGWRT (8)
         END IF
      CALL YHOLD ('OFFF', I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1980 FORMAT ('RMPIXR: ERROR',I4,' ON ',A)
      END
