      SUBROUTINE YTVMC
C-----------------------------------------------------------------------
C! issue a master clear to reinitialize IO to the TV
C# TV-IO
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C   YTVMC issues a "master clear" to the TV.  This resets the TV IO
C   system (if necessary) to expect a command record next.
C   YTVMC gets all needed parameters from the TV device common.
C   The TV must already be open.
C   IIS Model 70 version
C-----------------------------------------------------------------------
      INTEGER   UOFF, IT
      REAL      DTIME
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DZCH.INC'
      INCLUDE 'INCS:DTVD.INC'
      INCLUDE 'INCS:DTVC.INC'
      DATA DTIME /0.7/
C-----------------------------------------------------------------------
      UOFF = TVIND + NMOFF
      CALL ZM70MC (FTAB(UOFF))
C                                       time delay to allow ISU unit
C                                       to go thru its reset op.
      IF (ISUNUM.GT.0) CALL ZDELAY (DTIME, IT)
C
 999  RETURN
      END
