      SUBROUTINE YISJMP (GOADDR, IERR)
C-----------------------------------------------------------------------
C! cause microprocessor jump toaddress in NRAO-ISU device
C# TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C   YISJMP is a special Y routine for the NRAO Image Storage Unit -
C   a device interposed between the host CPU and the IIS Model 70 TV.
C   YISJMP causes the microprocessor to jump to a specified address.
C   Inputs:
C      GOADDR   I   Desired micro processor address
C   Output:
C      IERR     I   Error code of Z...XF: 0 okay, 2 input error
C   IIS Model 70 version - ISU present.
C-----------------------------------------------------------------------
      INTEGER   GOADDR, IERR
C
      INTEGER   ISUOPC, HEADER(8), BUFF
      DATA ISUOPC /7/
C-----------------------------------------------------------------------
C                                       Build header
      HEADER(1) = 3
      HEADER(2) = 0
      HEADER(3) = ISUOPC
      HEADER(4) = 0
      HEADER(5) = 0
      HEADER(6) = 0
      HEADER(7) = 0
      HEADER(8) = GOADDR
C                                       Do I/O
      CALL ZM70XF ('WRIT', 0, HEADER, BUFF, IERR)
C
 999  RETURN
      END
