.\"
.\" MAN PAGE COMMENTS to
.\"
.\"	Chet Ramey
.\"	Information Network Services
.\"	Case Western Reserve University
.\"	chet@ins.CWRU.Edu
.\"
.\"	Last Change: Mon Jun 13 20:06:14 EDT 1994
.\"
.TH READLINE 3 "1994 June 13" GNU
.\"
.\" File Name macro.  This used to be `.PN', for Path Name,
.\" but Sun doesn't seem to like that very much.
.\"
.de FN
\fI\|\\$1\|\fP
..
.SH NAME
readline \- get a line from a user with editing
.SH SYNOPSIS
.LP
.nf
.ft B
#include <readline.h>
#include <history.h>
.ft
.fi
.LP
.nf
.ft B
typedef int Function ();
.LP
.nf
.ft B
char *readline (prompt)
char *prompt;
.ft
.fi
.LP
.nf
.ft B
int rl_add_defun (name, function, key)
char *name;
Function *function;
int key;
.ft
.fi
.LP
.nf
.ft B
int rl_bind_key (key, function)
int key;
Function *function;
.ft
.fi
.LP
.nf
.ft B
int rl_unbind_key (key)
int key;
.ft
.fi
.LP
.nf
.ft B
int rl_bind_key_in_map (key, function, keymap)
int key;
Function *function;
Keymap keymap;
.ft
.fi
.LP
.nf
.ft B
int rl_unbind_key_in_map (key, keymap)
int key;
Keymap keymap;
.ft
.fi
.ft B
int rl_macro_bind (keyseq, macro, keymap)
char *keyseq, *macro;
Keymap keymap;
.ft
.fi
.LP
.nf
.ft B
int rl_variable_bind (variable, value)
char *variable, *value;
.ft
.fi
.LP
.nf
.LP
.nf
.ft B
int rl_parse_and_bind (line)
char *line;
.ft
.fi
.LP
.nf
.ft B
int rl_translate_keyseq (keyseq, array, len)
char *keyseq, *array;
int *len;
.ft
.fi
.LP
.nf
.ft B
Function *rl_named_function (command)
char *command;
.ft
.fi
.LP
.nf
.ft B
Function *rl_function_of_keyseq (keyseq, keymap, type)
char *keyseq;
Keymap keymap;
int *type;
.ft
.fi
.LP
.nf
.ft B
char **rl_invoking_keyseqs (function)
Function *function;
.ft
.fi
.LP
.nf
.ft B
char **rl_invoking_keyseqs_in_map (function, keymap)
Function *function;
Keymap keymap;
.ft
.fi
.LP
.nf
.ft B
void rl_function_dumper (readable)
int readable;
.ft
.fi
.LP
.nf
.ft B
char **rl_funmap_names ()
.ft
.fi
.SH COPYRIGHT
.if n Readline is Copyright (C) 1989, 1991 by the Free Software Foundation, Inc.
.if t Readline is Copyright \(co 1989, 1991 by the Free Software Foundation, Inc.
.SH DESCRIPTION
.LP
.B readline
will read a line from the terminal
and return it, using
.B prompt
as a prompt.  If
.B prompt
is null, no prompt is issued.  The line returned is allocated with
.IR malloc (3),
so the caller must free it when finished.  The line returned
has the final newline removed, so only the text of the line
remains.
.LP
.B readline
offers editing capabilities while the user is entering the
line.
By default, the line editing commands
are similar to those of emacs.
A vi\-style line editing interface is also available.
.LP
In the following descriptions,
.B keymap
can be one of \fIemacs_keymap, emacs_meta_keymap, emacs_ctlx_keymap,
vi_insertion_keymap, or vi_movement_keymap\fP.
.LP
.B rl_add_defun
makes
.B name
appear as a bindable readline command, and makes
.B function
be the function called when that command is invoked.  If
.B key
is not \-1, it is bound to
.B function
in the current keymap.
.LP
.B rl_bind_key
causes
.B key
to invoke
.BR function .
The binding is made in the current keymap.
.LP
.B rl_unbind_key
removes the binding for
.B key
in the current keymap.
.LP
.B rl_bind_key_in_map
makes the
.B key
entry in
.B keymap
invoke
.BR function .
.LP
.B rl_unbind_key_in_map
removes the binding for
.B key
in keymap
.BR keymap .
.LP
.B rl_macro_bind
makes
.B keyseq
insert the string
.BR macro .
The binding is performed in
.BR keymap .
.LP
.B rl_variable_bind
sets the value of the readline variable
.B variable
to
.BR value .
.LP
.B rl_parse_and_bind
takes as an argument a line of the same form as the readline startup
file (see
.SM
.B INITIALIZATION FILE
below) and executes the commands therein.
.LP
.B rl_translate_keyseq
converts
.B keyseq
into a new string, storing the result in
.BR array .
This translates control and meta prefixes and the readline
character escape sequences (see
.SM
.B Key Bindings
below).  The length of the translated sequence is returned in
.BR *len .
.LP
.B rl_named_function
returns the function that is executed when the readline
command
.B command
is invoked.
.LP
.B rl_function_of_keyseq
returns the function that is executed when
.B keyseq
is read and
.B keymap
is the current keymap.
.B type
is set to indicate whether the return value corresponds to a
function, macro, or auxiliary keymap.
.LP
.B rl_invoking_keyseqs
returns all of the key sequences in the current keymap that
invoke
.BR function .
.LP
.B rl_invoking_keyseqs_in_map
returns all of the key sequences in
.B keymap
that invoke
.BR function .
.LP
.B rl_function_dumper
prints all of the readline functions and their bindings to the
readline output stream.  If
.B readable
is non\-zero, the output is formattted so that it can be read
back in to restore the bindings.
.LP
.B rl_funmap_names
returns an array of all known readline bindable function names.
The array is sorted.
.SH RETURN VALUE
.LP
.B readline
returns the text of the line read.  A blank line
returns the empty string.  If
.B EOF
is encountered while reading a line, and the line is empty,
.B NULL
is returned.  If an
.B EOF
is read with a non\-empty line, it is
treated as a newline.
.LP
Unless otherwise stated,
the other functions return 0 on success and non\-zero on failure.
.SH NOTATION
.LP
An emacs\-style notation is used to denote
keystrokes.  Control keys are denoted by C\-\fIkey\fR, e.g., C\-n
means Control\-N.  Similarly,
.I meta
keys are denoted by M\-\fIkey\fR, so M\-x means Meta\-X.  (On keyboards
without a
.I meta
key, M\-\fIx\fP means ESC \fIx\fP, i.e., press the Escape key
then the
.I x
key.  This makes ESC the \fImeta prefix\fP.
The combination M\-C\-\fIx\fP means ESC\-Control\-\fIx\fP,
or press the Escape key
then hold the Control key while pressing the
.I x
key.)
.PP
Readline commands may be given numeric
.IR arguments ,
which normally act as a repeat count.  Sometimes, however, it is the
sign of the argument that is significant.  Passing a negative argument
to a command that acts in the forward direction (e.g., \fBkill\-line\fP)
causes that command to act in a backward direction.  Commands whose
behavior with arguments deviates from this are noted.
.PP
When a command is described as \fIkilling\fP text, the text
deleted is saved for possible future retrieval
(\fIyanking\fP).  The killed text is saved in a
\fIkill\-ring\fP.  Consecutive kills cause the text to be
accumulated into one unit, which can be yanked all at once.
Commands which do not kill text separate the chunks of text
on the kill\-ring.
.SH INITIALIZATION FILE
.LP
Readline is customized by putting commands in an initialization
file.  The name of this file is taken from the value of the
.B INPUTRC
variable.  If that variable is unset, the default is
.IR ~/.inputrc .
When a program which uses the readline library starts up, the
init file is read, and the key bindings and variables are set.
There are only a few basic constructs allowed in the
readline init file.  Blank lines are ignored.
Lines beginning with a \fB#\fP are comments.
Lines beginning with a \fB$\fP indicate conditional
constructs.  Other lines
denote key bindings and variable settings.
Each program using this library may add its own commands
and bindings.
.PP
For example, placing
.RS
.PP
M\-Control\-u: universal\-argument
.RE
or
.RS
C\-Meta\-u: universal\-argument
.RE
into the
.FN ~/.inputrc
would make M\-C\-u execute the readline command
.IR universal\-argument .
.PP
The following symbolic character names are recognized while
processing key bindings:
.IR RUBOUT ,
.IR DEL ,
.IR ESC ,
.IR LFD ,
.IR NEWLINE ,
.IR RET ,
.IR RETURN ,
.IR SPC ,
.IR SPACE ,
and
.IR TAB .
In addition to command names, readline allows keys to be bound
to a string that is inserted when the key is pressed (a \fImacro\fP).
.PP
.SS Key Bindings
.PP
The syntax for controlling key bindings in the
.I ~/.inputrc
file is simple.  All that is required is the name of the
command or the text of a macro and a key sequence to which
it should be bound. The name may be specified in one of two ways:
as a symbolic key name, possibly with \fIMeta\-\fP or \fIControl\-\fP
prefixes, or as a key sequence.
When using the form \fBkeyname\fP:\fIfunction-name\fP or \fImacro\fP,
.I keyname
is the name of a key spelled out in English.  For example:
.sp
.RS
Control\-u: universal\-argument
.br
Meta\-Rubout: backward\-kill\-word
.br
Control\-o: ">&output"
.RE
.LP
In the above example,
.I C\-u
is bound to the function
.BR universal\-argument ,
.I M-DEL
is bound to the function
.BR backward\-kill\-word ,
and
.I C\-o
is bound to run the macro
expressed on the right hand side (that is, to insert the text
.I >&output
into the line).
.PP
In the second form, \fB"keyseq"\fP:\fIfunction\-name\fP or \fImacro\fP,
.B keyseq
differs from
.B keyname
above in that strings denoting
an entire key sequence may be specified by placing the sequence
within double quotes.  Some GNU Emacs style key escapes can be
used, as in the following example.
.sp
.RS
"\eC\-u": universal\-argument
.br
"\eC\-x\eC\-r": re\-read\-init\-file
.br
"\ee[11~": "Function Key 1"
.RE
.PP
In this example,
.I C-u
is again bound to the function
.BR universal\-argument .
.I "C-x C-r"
is bound to the function
.BR re\-read\-init\-file ,
and
.I "ESC [ 1 1 ~"
is bound to insert the text
.BR "Function Key 1" .
The full set of escape sequences is
.RS
.TP
.B \eC-
control prefix
.TP
.B \eM-
meta prefix
.TP
.B \ee
an escape character
.TP
.B \e\e
backslash
.TP
.B \e"
literal "
.TP
.B \e'
literal '
.RE
.PP
When entering the text of a macro, single or double quotes should
be used to indicate a macro definition.  Unquoted text
is assumed to be a function name.  Backslash
will quote any character in the macro text, including " and '.
.PP
.B Bash
allows the current readline key bindings to be displayed or modified
with the
.B bind
builtin command.  The editing mode may be switched during interactive
use by using the
.B \-o
option to the
.B set
builtin command.  Other programs using this library provide
similar mechanisms.  The
.I inputrc
file may be edited and re\-read if a program does not provide
any other means to incorporate new bindings.
.SS Variables
.PP
Readline has variables that can be used to further customize its
behavior.  A variable may be set in the
.I inputrc
file with a statement of the form
.RS
.PP
\fBset\fP \fIvariable\-name\fP \fIvalue\fP
.RE
.PP
Except where noted, readline variables can take the values
.B On
or
.BR Off .
The variables and their default values are:
.PP
.PD 0
.TP
.B horizontal\-scroll\-mode (Off)
When set to \fBOn\fP, makes readline use a single line for display,
scrolling the input horizontally on a single screen line when it
becomes longer than the screen width rather than wrapping to a new line.
.TP
.B editing\-mode (emacs)
Controls whether readline begins with a set of key bindings similar
to \fIemacs\fP or \fIvi\fP.
.B editing\-mode
can be set to either
.B emacs
or
.BR vi .
.TP
.B mark\-modified\-lines (Off)
If set to \fBOn\fP, history lines that have been modified are displayed
with a preceding asterisk (\fB*\fP).
.TP
.B bell\-style (audible)
Controls what happens when readline wants to ring the terminal bell.
If set to \fBnone\fP, readline never rings the bell.  If set to
\fBvisible\fP, readline uses a visible bell if one is available.
If set to \fBaudible\fP, readline attempts to ring the terminal's bell.
.TP
.B comment\-begin (``#'')
The string that is inserted in \fBvi\fP mode when the
.B vi\-comment
command is executed.
.TP
.B meta\-flag (Off)
If set to \fBOn\fP, readline will enable eight-bit input (that is,
it will not strip the high bit from the characters it reads),
regardless of what the terminal claims it can support.
.TP
.B convert\-meta (On)
If set to \fBOn\fP, readline will convert characters with the
eighth bit set to an ASCII key sequence
by stripping the eighth bit and prepending an
escape character (in effect, using escape as the \fImeta prefix\fP).
.TP
.B output\-meta (Off)
If set to \fBOn\fP, readline will display characters with the
eighth bit set directly rather than as a meta-prefixed escape
sequence.
.TP
.B completion\-query\-items (100)
This determines when the user is queried about viewing
the number of possible completions
generated by the \fBpossible\-completions\fP command.
It may be set to any integer value greater than or equal to
zero.  If the number of possible completions is greater than
or equal to the value of this variable, the user is asked whether
or not he wishes to view them; otherwise they are simply listed
on the terminal.
.TP
.B keymap (emacs)
Set the current readline keymap.  The set of legal keymap names is
\fIemacs, emacs-standard, emacs-meta, emacs-ctlx, vi, vi-move,
vi-command\fP, and
.IR vi-insert .
\fIvi\fP is equivalent to \fIvi-command\fP; \fIemacs\fP is
equivalent to \fIemacs-standard\fP.  The default value is
.IR emacs ;
the value of
.B editing\-mode
also affects the default keymap.
.TP
.B show\-all\-if\-ambiguous (Off)
This alters the default behavior of the completion functions.  If
set to
.BR on ,
words which have more than one possible completion cause the
matches to be listed immediately instead of ringing the bell.
.TP
.B expand\-tilde (Off)
If set to \fBon\fP, tilde expansion is performed when readline
attempts word completion.
.PD
.SS Conditional Constructs
.PP
Readline implements a facility similar in spirit to the conditional
compilation features of the C preprocessor which allows key
bindings and variable settings to be performed as the result
of tests.  There are three parser directives used.
.IP \fB$if\fP
The
.B $if
construct allows bindings to be made based on the
editing mode, the terminal being used, or the application using
readline.  The text of the test extends to the end of the line;
no characters are required to isolate it.
.RS
.IP \fBmode\fP
The \fBmode=\fP form of the \fB$if\fP directive is used to test
whether readline is in emacs or vi mode.
This may be used in conjunction
with the \fBset keymap\fP command, for instance, to set bindings in
the \fIemacs-standard\fP and \fIemacs-ctlx\fP keymaps only if
readline is starting out in emacs mode.
.IP \fBterm\fP
The \fBterm=\fP form may be used to include terminal-specific
key bindings, perhaps to bind the key sequences output by the
terminal's function keys.  The word on the right side of the
.B =
is tested against the full name of the terminal and the portion
of the terminal name before the first \fB\-\fP.  This allows
.I sun
to match both
.I sun
and
.IR sun\-cmd ,
for instance.
.IP \fBapplication\fP
The \fBapplication\fP construct is used to include
application\-specific settings.  Each program using the readline
library sets the \fIapplication name\fP, and an initialization
file can test for a particular value.
This could be used to bind key sequences to functions useful for
a specific program.  For instance, the following command adds a
key sequence that quotes the current or previous word in Bash:
.RS
.nf
\fB$if\fP bash
# Quote the current or previous word
"\eC-xq": "\eeb\e"\eef\e""
\fB$endif\fP
.fi
.RE
.RE
.IP \fB$endif\fP
This command, as you saw in the previous example, terminates an
\fB$if\fP command.
.IP \fB$else\fP
Commands in this branch of the \fB$if\fP directive are executed if
the test fails.
.SH EDITING COMMANDS
.PP
The following is a list of the names of the commands and the default
key sequences to which they are bound.
.SS Commands for Moving
.PP
.PD 0
.TP
.B beginning\-of\-line (C\-a)
Move to the start of the current line.
.TP
.B end\-of\-line (C\-e)
Move to the end of the line.
.TP
.B forward\-char (C\-f)
Move forward a character.
.TP
.B backward\-char (C\-b)
Move back a character.
.TP
.B forward\-word (M\-f)
Move forward to the end of the next word.  Words are composed of
alphanumeric characters (letters and digits).
.TP
.B backward\-word (M\-b)
Move back to the start of this, or the previous, word.  Words are
composed of alphanumeric characters (letters and digits).
.TP
.B clear\-screen (C\-l)
Clear the screen leaving the current line at the top of the screen.
With an argument, refresh the current line without clearing the
screen.
.TP
.B redraw\-current\-line
Refresh the current line.  By default, this is unbound.
.PD
.SS Commands for Manipulating the History
.PP
.PD 0
.TP
.B accept\-line (Newline, Return)
Accept the line regardless of where the cursor is.  If this line is
non\-empty, add it to the history list. If the line is a modified
history line, then restore the history line to its original state.
.TP
.B previous\-history (C\-p)
Fetch the previous command from the history list, moving back in
the list.
.TP
.B next\-history (C\-n)
Fetch the next command from the history list, moving forward in the
list.
.TP
.B beginning\-of\-history (M\-<)
Move to the first line in the history.
.TP
.B end\-of\-history (M\->)
Move to the end of the input history, i.e., the line currently being
entered.
.TP
.B reverse\-search\-history (C\-r)
Search backward starting at the current line and moving `up' through
the history as necessary.  This is an incremental search.
.TP
.B forward\-search\-history (C\-s)
Search forward starting at the current line and moving `down' through
the history as necessary.  This is an incremental search.
.TP
.B non\-incremental\-reverse\-search\-history (M\-p)
Search backward through the history starting at the current line
using a non\-incremental search for a string supplied by the user.
.TP
.B non\-incremental\-forward\-search\-history (M\-n)
Search forward through the history using a non\-incremental search
for a string supplied by the user.
.TP
.B history\-search\-forward
Search forward through the history for the string of characters
between the start of the current line and the current point.  This
is a non-incremental search.  By default, this command is unbound.
.TP
.B history\-search\-backward
Search backward through the history for the string of characters
between the start of the current line and the current point.  This
is a non-incremental search.  By default, this command is unbound.
.TP
.B yank\-nth\-arg (M\-C\-y)
Insert the first argument to the previous command (usually
the second word on the previous line) at point (the current
cursor position).  With an argument
.IR n ,
insert the \fIn\fPth word from the previous command (the words
in the previous command begin with word 0).  A negative argument
inserts the \fIn\fPth word from the end of the previous command.
.PD
.SS Commands for Changing Text
.PP
.PD 0
.TP
.B delete\-char (C\-d)
Delete the character under the cursor.  If point is at the
beginning of the line, there are no characters in the line, and
the last character typed was not
.BR C\-d ,
then return
.SM
.BR EOF .
.TP
.B backward\-delete\-char (Rubout)
Delete the character behind the cursor.  When given a numeric argument,
save the deleted text on the kill\-ring.
.TP
.B quoted\-insert (C\-q, C\-v)
Add the next character that you type to the line verbatim.  This is
how to insert characters like \fBC\-q\fP, for example.
.TP
.B tab\-insert (M-TAB)
Insert a tab character.
.TP
.B self\-insert (a,\ b,\ A,\ 1,\ !,\ ...)
Insert the character typed.
.TP
.B transpose\-chars (C\-t)
Drag the character before point forward over the character at point.
Point moves forward as well.  If point is at the end of the line, then
transpose the two characters before point.  Negative arguments don't work.
.TP
.B transpose\-words (M\-t)
Drag the word behind the cursor past the word in front of the cursor
moving the cursor over that word as well.
.TP
.B upcase\-word (M\-u)
Uppercase the current (or following) word.  With a negative argument,
do the previous word, but do not move point.
.TP
.B downcase\-word (M\-l)
Lowercase the current (or following) word.  With a negative argument,
do the previous word, but do not move point.
.TP
.B capitalize\-word (M\-c)
Capitalize the current (or following) word.  With a negative argument,
do the previous word, but do not move point.
.PD
.SS Killing and Yanking
.PP
.PD 0
.TP
.B kill\-line (C\-k)
Kill the text from the current cursor position to the end of the line.
.TP
.B backward\-kill\-line (C\-x Rubout)
Kill backward to the beginning of the line.
.TP
.B unix\-line\-discard (C\-u)
Kill backward from point to the beginning of the line.
.\" There is no real difference between this and backward-kill-line
.TP
.B kill\-whole\-line
Kill all characters on the current line, no matter where the
cursor is.  By default, this is unbound.
.TP
.B kill\-word  (M\-d)
Kill from the cursor to the end of the current word, or if between
words, to the end of the next word.  Word boundaries are the same as
those used by \fBforward\-word\fP.
.TP
.B backward\-kill\-word (M\-Rubout)
Kill the word behind the cursor.  Word boundaries are the same as
those used by \fBbackward\-word\fP.
.TP
.B unix\-word\-rubout (C\-w)
Kill the word behind the cursor, using white space as a word boundary.
The word boundaries are different from
.BR backward\-kill\-word .
.TP
.B delete\-horizontal\-space
Delete all spaces and tabs around point.  By default, this is unbound.
.TP
.B yank (C\-y)
Yank the top of the kill ring into the buffer at the cursor.
.TP
.B yank\-pop (M\-y)
Rotate the kill\-ring, and yank the new top.  Only works following
.B yank
or
.BR yank\-pop .
.PD
.SS Numeric Arguments
.PP
.PD 0
.TP
.B digit\-argument (M\-0, M\-1, ..., M\-\-)
Add this digit to the argument already accumulating, or start a new
argument.  M\-\- starts a negative argument.
.TP
.B universal\-argument
Each time this is executed, the argument count is multiplied by four.
The argument count is initially one, so executing this function the
first time makes the argument count four.  By default, this is not
bound to a key.
.PD
.SS Completing
.PP
.PD 0
.TP
.B complete (TAB)
Attempt to perform completion on the text before point.
The actual completion performed is application-specific.
.BR Bash ,
for instance, attempts completion treating the text as a variable
(if the text begins with \fB$\fP), username (if the text begins with
\fB~\fP), hostname (if the text begins with \fB@\fP), or
command (including aliases and functions) in turn.  If none
of these produces a match, filename completion is attempted.
.BR Gdb ,
on the other hand,
allows completion of program functions and variables, and
only attempts filename completion under certain circumstances.
.TP
.B possible\-completions (M-?)
List the possible completions of the text before point.
.TP
.B insert\-completions
Insert all completions of the text before point
that would have been generated by
\fBpossible\-completions\fP.  By default, this
is not bound to a key.
.PD
.SS Keyboard Macros
.PP
.PD 0
.TP
.B start\-kbd\-macro (C-x (\^)
Begin saving the characters typed into the current keyboard macro.
.TP
.B end\-kbd\-macro (C-x )\^)
Stop saving the characters typed into the current keyboard macro
and save the definition.
.TP
.B call\-last\-kbd\-macro (C-x e)
Re-execute the last keyboard macro defined, by making the characters
in the macro appear as if typed at the keyboard.
.PD
.SS Miscellaneous
.PP
.PD 0
.TP
.B re-read-init-file (C\-x C\-r)
Read in the contents of your init file, and incorporate
any bindings or variable assignments found there.
.TP
.B abort (C\-g)
Abort the current editing command and
ring the terminal's bell (subject to the setting of
.BR bell\-style ).
.TP
.B do\-uppercase\-version (M\-a, M\-b, ...)
Run the command that is bound to the corresponding uppercase
character.
.TP
.B prefix\-meta (ESC)
Metafy the next character typed.
.SM
.B ESC
.B f
is equivalent to
.BR Meta\-f .
.TP
.B undo (C\-_, C\-x C\-u)
Incremental undo, separately remembered for each line.
.TP
.B revert\-line (M\-r)
Undo all changes made to this line.  This is like typing the
.B undo
command enough times to return the line to its initial state.
.TP
.B tilde\-expand (M\-~)
Perform tilde expansion on the current word.
.TP
.B dump\-functions
Print all of the functions and their key bindings to the
readline output stream.  If a numeric argument is supplied,
the output is formatted in such a way that it can be made part
of an \fIinputrc\fP file.
.TP
.B emacs\-editing\-mode (C\-e)
When in
.B vi
editing mode, this causes a switch to
.B emacs
editing mode.
.TP
.B vi\-editing\-mode (M\-C\-j)
When in
.B emacs
editing mode, this causes a switch to
.B vi
editing mode.
.PD
.SH DEFAULT KEY BINDINGS
.LP
The following is a list of the default emacs and vi bindings.
Characters with the 8th bit set are written as M-<character>, and
are referred to as
.I metafied
characters.
The printable ASCII characters not mentioned in the list of emacs
standard bindings are bound to the
.I self\-insert
function, which just inserts the given character into the input line.
In vi insertion mode, all characters not specifically mentioned are
bound to
.IR self\-insert .
Characters assigned to signal generation by
.IR stty (1)
or the terminal driver, such as C-Z or C-C,
retain that function.
Upper and lower case
.I metafied
characters are bound to the same function in the emacs mode
meta keymap.
The remaining characters are unbound, which causes readline
to ring the bell (subject to the setting of the
.B bell\-style
variable).
.SS Emacs Mode
.RS +.6i
.nf
.ta 2.5i
.sp
Emacs Standard bindings
.sp
"C-A"	->  beginning-of-line
"C-B"	->  backward-char
"C-D"	->  delete-char
"C-E"	->  end-of-line
"C-F"	->  forward-char
"C-G"	->  abort
"C-H"	->  backward-delete-char
"C-I"	->  complete
"C-J"	->  accept-line
"C-K"	->  kill-line
"C-L"	->  clear-screen
"C-M"	->  accept-line
"C-N"	->  next-history
"C-P"	->  previous-history
"C-Q"	->  quoted-insert
"C-R"	->  reverse-search-history
"C-S"	->  forward-search-history
"C-T"	->  transpose-chars
"C-U"	->  unix-line-discard
"C-V"	->  quoted-insert
"C-W"	->  unix-word-rubout
"C-Y"	->  yank
"C-_"	->  undo
"\^ " to "/"	->  self-insert
"0"  to "9"	->  self-insert
":"  to "~"	->  self-insert
"C-?"	->  backward-delete-char
.PP
Emacs Meta bindings
.sp
"M-C-H"	->  backward-kill-word
"M-C-I"	->  tab-insert
"M-C-J"	->  vi-editing-mode
"M-C-M"	->  vi-editing-mode
"M-C-R"	->  revert-line
"M-C-Y"	->  yank-nth-arg
"M-C-["	->  complete
"M-&"	->  tilde-expand
"M--"	->  digit-argument
"M-0"	->  digit-argument
"M-1"	->  digit-argument
"M-2"	->  digit-argument
"M-3"	->  digit-argument
"M-4"	->  digit-argument
"M-5"	->  digit-argument
"M-6"	->  digit-argument
"M-7"	->  digit-argument
"M-8"	->  digit-argument
"M-9"	->  digit-argument
"M-<"	->  beginning-of-history
"M->"	->  end-of-history
"M-?"	->  possible-completions
"M-B"	->  backward-word
"M-C"	->  capitalize-word
"M-D"	->  kill-word
"M-F"	->  forward-word
"M-L"	->  downcase-word
"M-N"	->  non-incremental-forward-search-history
"M-O"	->  arrow-key-prefix
"M-P"	->  non-incremental-reverse-search-history
"M-R"	->  revert-line
"M-T"	->  transpose-words
"M-U"	->  upcase-word
"M-Y"	->  yank-pop
"M-C-Y"	->  yank-nth-arg
"M-C-?"	->  backward-delete-word
.PP
Emacs Control-X bindings
.sp
"C-XC-G"	->  abort
"C-XC-R"	->  re-read-init-file
"C-XC-U"	->  undo
"C-X("	->  start-kbd-macro
"C-X)"	->  end-kbd-macro
"C-Xe"	->  call-last-kbd-macro
"C-XC-?"	->  backward-kill-line
.sp
.RE
.SS VI Mode bindings
.RS +.6i
.nf
.ta 2.5i
.sp
.PP
VI Insert Mode functions
.sp
"C-D"	->  vi-eof-maybe
"C-H"	->  backward-delete-char
"C-I"	->  complete
"C-J"	->  accept-line
"C-K"	->  kill-line
"C-L"	->  clear-screen
"C-M"	->  accept-line
"C-N"	->  next-history
"C-P"	->  previous-history
"C-Q"	->  quoted-insert
"C-R"	->  reverse-search-history
"C-S"	->  forward-search-history
"C-T"	->  transpose-chars
"C-U"	->  unix-line-discard
"C-V"	->  quoted-insert
"C-W"	->  unix-word-rubout
"C-Y"	->  yank
"C-["	->  vi-movement-mode
"\^ " to "~"	->  self-insert
"C-?"	->  backward-delete-char
.PP
VI Command Mode functions
.sp
"C-D"	->  vi-eof-maybe
"C-E"	->  emacs-editing-mode
"C-G"	->  abort
"C-H"	->  backward-char
"C-J"	->  accept-line
"C-K"	->  kill-line
"C-L"	->  clear-screen
"C-M"	->  accept-line
"C-N"	->  next-history
"C-P"	->  previous-history
"C-Q"	->  quoted-insert
"C-R"	->  reverse-search-history
"C-S"	->  forward-search-history
"C-T"	->  transpose-chars
"C-U"	->  unix-line-discard
"C-V"	->  quoted-insert
"C-W"	->  unix-word-rubout
"C-Y"	->  yank
"C-["	->  abort
"\^ "	->  forward-char
"#"	->  vi-comment
"$"	->  end-of-line
"%"	->  vi-match
"&"	->  vi-tilde-expand
"*"	->  vi-complete
"+"	->  down-history
","	->  vi-char-search
"-"	->  previous-history
"."	->  vi-redo
"/"	->  vi-search
"0"	->  beginning-of-line
"1" to "9"	->  vi-arg-digit
";"	->  vi-char-search
"="	->  vi-complete
"?"	->  vi-search
"@"	->  is undefined
"A"	->  vi-append-eol
"B"	->  vi-prev-word
"C"	->  vi-change-to
"D"	->  vi-delete-to
"E"	->  vi-end-word
"F"	->  vi-char-search
"I"	->  vi-insert-beg
"N"	->  vi-search-again
"P"	->  vi-put
"R"	->  vi-replace
"S"	->  vi-subst
"T"	->  vi-char-search
"U"	->  revert-line
"W"	->  vi-next-word
"X"	->  backward-delete-char
"Y"	->  vi-yank-to
"\e"	->  vi-complete
"^"	->  vi-first-print
"_"	->  vi-yank-arg
"a"	->  vi-append-mode
"b"	->  vi-prev-word
"c"	->  vi-change-to
"d"	->  vi-delete-to
"e"	->  vi-end-word
"f"	->  vi-char-search
"h"	->  backward-char
"i"	->  vi-insertion-mode
"j"	->  next-history
"k"	->  prev-history
"l"	->  forward-char
"n"	->  vi-search-again
"r"	->  vi-change-char
"s"	->  vi-subst
"t"	->  vi-char-search
"u"	->  undo
"w"	->  vi-next-word
"x"	->  vi-delete
"y"	->  vi-yank-to
"|"	->  vi-column
"~"	->  vi-change-case
.RE
.SH "SEE ALSO"
.PD 0
.TP
\fIThe Gnu Readline Library\fP, Brian Fox
.TP
\fIThe Gnu History Library\fP, Brian Fox
.TP
\fIbash\fP(1)
.PD
.SH FILES
.PD 0
.TP
.FN ~/.inputrc
Individual \fBreadline\fP initialization file
.PD
.SH AUTHORS
.RS
Brian Fox, Free Software Foundation (primary author)
.br
bfox@ai.MIT.Edu
.PP
Chet Ramey, Case Western Reserve University
.br
chet@ins.CWRU.Edu
.SH BUG REPORTS
If you find a bug in
.B readline,
you should report it.  But first, you should
make sure that it really is a bug, and that it appears in the latest
version of the
.B readline
library that you have.
.PP
Once you have determined that a bug actually exists, mail a
bug report to \fIbash\-maintainers\fP@\fIprep.ai.MIT.Edu\fP.
If you have a fix, you are welcome to mail that
as well!  Suggestions and `philosophical' bug reports may be mailed
to \fPbug-bash\fP@\fIprep.ai.MIT.Edu\fP or posted to the Usenet
newsgroup
.BR gnu.bash.bug .
.PP
Comments and bug reports concerning this
manual page should be directed to
.IR chet@ins.CWRU.Edu .
.SH BUGS
.PP
It's too big and too slow.
