/* UPDLSTDAT.C                                                        */
/*--------------------------------------------------------------------*/
/*! Print records in a .UPD file later than a given date              */
/*# Update UNIX                                                       */
/*--------------------------------------------------------------------*/
/*;  Copyright (C) 1995, 1996, 2001, 2022                             */
/*;  Associated Universities, Inc. Washington DC, USA.                */
/*;                                                                   */
/*;  This program is free software; you can redistribute it and/or    */
/*;  modify it under the terms of the GNU General Public License as   */
/*;  published by the Free Software Foundation; either version 2 of   */
/*;  the License, or (at your option) any later version.              */
/*;                                                                   */
/*;  This program is distributed in the hope that it will be useful,  */
/*;  but WITHOUT ANY WARRANTY; without even the implied warranty of   */
/*;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    */
/*;  GNU General Public License for more details.                     */
/*;                                                                   */
/*;  You should have received a copy of the GNU General Public        */
/*;  License along with this program; if not, write to the Free       */
/*;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,     */
/*;  MA 02139, USA.                                                   */
/*;                                                                   */
/*;  Correspondence concerning AIPS should be addressed as follows:   */
/*;         Internet email: aipsmail@nrao.edu.                        */
/*;         Postal address: AIPS Project Office                       */
/*;                         National Radio Astronomy Observatory      */
/*;                         520 Edgemont Road                         */
/*;                         Charlottesville, VA 22903-2475 USA        */
/*--------------------------------------------------------------------*/
/*   Print records from the .UPD file given as argument 1 later       */
/*   than the date given as argument 2 on the standard output         */
/*                                                                    */
/*   Inputs:                                                          */
/*      argv[1]          input file name                              */
/*      argv[2]          date/time: date -u +%Y%m%d.%H%M%S            */
/*--------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#ifdef __STDC__
#include <string.h>
#else
#include <strings.h>
#endif

main(argc, argv)
int argc;
char *argv[];
{
  FILE *updp, *fopen();
  char line[132], lastdate[16], updfile[256], update[16], month[4];
  register int i;

  if (argc != 3) {
    printf("Usage: UPDLSTDAT file.UPD yyyymmdd.hhmmss\n");
    exit(1);
  } else {
#ifdef __osf__
    sprintf(updfile, "%s", argv[1]);
    sprintf(lastdate, "%s", argv[2]);
#else
    snprintf(updfile, sizeof(updfile), "%s", argv[1]);
    snprintf(lastdate, sizeof(lastdate), "%s", argv[2]);
#endif
  }

  if ((updp = fopen(updfile,"r")) == NULL) {
    perror("UPDLSTDAT");
    fprintf(stderr,"UPDLSTDAT: can't open %s\n",updfile);
    exit(1);
  }
  while (fgets(line,132,updp) != NULL) {
                                        /* change dd-mmm-yyyy hh:mm:ss */
                                        /* to yyyymmdd.hhmmss */
                                        /* old way was: */
                                        /* sscanf(line,"%*s%*s%s", */
                                        /* update); */

                                        /* zero it out first */
    memset(update, 0, sizeof(update));
    memset(month, 0, sizeof(month));
                                        /* year */
    strncpy(update, &line[7], (size_t) 4);
                                        /* month */
    strncpy(month, &line[3], (size_t) 3);
                                        /* is there a better way? */
    if (strncmp(month, "JAN", 3) == 0) {
      strncpy(&update[4], "01", (size_t) 2);
    } else if (strncmp(month, "FEB", 3) == 0) {
      strncpy(&update[4], "02", (size_t) 2);
    } else if (strncmp(month, "MAR", 3) == 0) {
      strncpy(&update[4], "03", (size_t) 2);
    } else if (strncmp(month, "APR", 3) == 0) {
      strncpy(&update[4], "04", (size_t) 2);
    } else if (strncmp(month, "MAY", 3) == 0) {
      strncpy(&update[4], "05", (size_t) 2);
    } else if (strncmp(month, "JUN", 3) == 0) {
      strncpy(&update[4], "06", (size_t) 2);
    } else if (strncmp(month, "JUL", 3) == 0) {
      strncpy(&update[4], "07", (size_t) 2);
    } else if (strncmp(month, "AUG", 3) == 0) {
      strncpy(&update[4], "08", (size_t) 2);
    } else if (strncmp(month, "SEP", 3) == 0) {
      strncpy(&update[4], "09", (size_t) 2);
    } else if (strncmp(month, "OCT", 3) == 0) {
      strncpy(&update[4], "10", (size_t) 2);
    } else if (strncmp(month, "NOV", 3) == 0) {
      strncpy(&update[4], "11", (size_t) 2);
    } else if (strncmp(month, "DEC", 3) == 0) {
      strncpy(&update[4], "12", (size_t) 2);
    }
                                        /* day */
    strncpy(&update[6], line, (size_t) 2);
    update[8] = '.';
                                        /* hour */
    strncpy(&update[9], &line[12], (size_t) 2);
                                        /* minute */
    strncpy(&update[11], &line[15], (size_t) 2);
                                        /* second */
    strncpy(&update[13], &line[18], (size_t) 2);
                                        /* null terminate the string */
    update[15] = '\0';

                                        /* check if this date is more */
                                        /* recent than lastdate */
    if (strcmp(update,lastdate) >= 0) {
                                        /* Fix from Martin Shepherd */
                                        /* for long lines           */
      printf("%s",line);
                                        /* Print the remainder of    */
                                        /* the line.                 */
      while(line[strlen(line)-1] != '\n' && fgets(line,132,updp) != NULL)
        printf("%s",line);
      } else {
                                        /* Discard the remainder of  */
                                        /* the line.                 */
        while(line[strlen(line)-1] != '\n' && fgets(line,132,updp) != NULL)
          ;
      }
   }
   exit(0);
}
