      SUBROUTINE PREFFT (GAMMA)
C-----------------------------------------------------------------------
C! Convex Pseudo AP routine: Initialize FFT tables for QXFOUR.
C# AP-FFT
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C    Initializes the tables used by the FFT routine QXFOUR.
C    Inputs:
C       GAMMA  I  The max. power of two for which the tables
C                  are to be initilized.
C    Common tables /REV/:
C       WMAX, BMAX   PARAMETERs
C       WREAL  R(WMAX)   Array of coefficients generated by PREFFT.
C       WIMAG  R(WMAX)   Array of coefficients generated by PREFFT.
C       BITREV I(WMAX)   Array generated by PREFFT containing indices
C                        to bit reverse the output vector.
C    Note: these dimensions are good for up to 4096 FFTs
C-----------------------------------------------------------------------
C                                       Declare arguments & parameters
      INTEGER   GAMMA, GMAX, BMAX, WMAX
C                                       Set maximum FFT size to 4096
C                                       or GAMMA = 12 (i.e., 2**GAMMA)
      PARAMETER (GMAX=12)
C                                       Set BMAX as BTABL2(GMAX+1)
C                                       and WMAX as BTABL(GMAX+1)
C                                       (see DATA statements below)
      PARAMETER (BMAX=8190)
      PARAMETER (WMAX=37768)
C                                       Declare local variables
      INTEGER   ISIGN, IPASS, IGAMMA, BASE, ORDER, INDEX, I, J, K, L,
     *   M, N, LN2, ITMP, JTMP
      REAL      PI2
C                                       /REV/ declarations
      INTEGER   BITREV(BMAX)
      REAL      WREAL(WMAX), WIMAG(WMAX)
      INTEGER   BTABL(14), BTABL2(14), IFIRST, GTABL(14), GLAST
      COMMON /REV/ BITREV, WREAL, WIMAG, BTABL, BTABL2, IFIRST,
     *   GTABL, GLAST
C                                       Data inititialization
C                                       BTABL(15) would be 181128
      DATA BTABL  /0, 0, 0,  4, 20, 68, 196, 516, 1284, 3076, 7172,
     *   17288, 37768, 82824/
C                                       BTABL2(15) would be 32766
      DATA BTABL2 /0, 2, 6, 14, 30, 62, 126, 254,  510, 1022, 2046,
     *    4094,  8190, 16382/
C                                       GTABL(15) would be 32768
      DATA GTABL /2, 4, 8, 16, 32, 64, 128, 256,  512, 1024, 2048,
     *    4096,  8192, 16384/
      DATA IFIRST /0/
C-----------------------------------------------------------------------
C                                       Sanity test
      IF ((GAMMA.LT.1).OR.(GAMMA.GT.GMAX)) THEN
         PRINT *,'PREFFT: GAMMA = ',GAMMA,' OUT OF RANGE'
         STOP
         END IF
C                                       Only initialize on first call
C                                       or increased GAMMA
      IF ((IFIRST.NE.0).AND.(GAMMA.LE.GLAST)) GO TO 999
C                                       Set IFIRST and GLAST for
C                                       future calls
         IFIRST = 1
         GLAST = GAMMA
C                                       Initialize bit-reversal index
C                                       array
         DO IGAMMA = 1,GAMMA
            N = 2**IGAMMA
            J = 0
            BASE = BTABL2(IGAMMA)
            DO I = 1,N
               CALL REVERSE (K, J, IGAMMA)
               BITREV(BASE+I) = K + 1
               J = J + 1
               END DO
            END DO
C                                       Initialize FFT coefficients:
C                                       W(P,N) = COS2*PI*P/N -
C                                                J SIN2*PI*P/N
C
C                                       First two passes are built
C                                       into algorithm so that
C                                       coefficients are necessary
C                                       for only later passes.
         PI2 = 2*3.1415926535
         DO IGAMMA = 3,GAMMA
            K = 0
            N = GTABL(IGAMMA)
            LN2 = N/2
            BASE = BTABL(IGAMMA)
            DO I = 1,IGAMMA-2
               DO J = 1,LN2
                  JTMP = J - 1
                  ITMP = I + 1
                  CALL REVERSE (K, JTMP, ITMP)
                  K = K*(GTABL(((IGAMMA-2)-I)))
                  WREAL(J+((I-1)*LN2+BASE)) = COS((PI2/N)*K)
                  WIMAG(J+((I-1)*LN2+BASE)) = -SIN((PI2/N)*K)
                  END DO
               END DO
            END DO
C
 999  RETURN
      END
