      SUBROUTINE RESCCC (IVOL, SLOT, FACTOR, LUN, BUFFER, IERR)
C-----------------------------------------------------------------------
C! rescale CC files
C# POPS-appl Coordinates
C-----------------------------------------------------------------------
C;  Copyright (C) 2019-2020
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   RESCC rescales CC files in place
C   Inputs:
C      IVOL     I      Disk number
C      SLOT     I      Slot number
C      FACTOR   R      Scale factor
C      LUN      I      LUN to use
C   Outputs
C      BUFFER   I(*)   work buffer
C      IERR     I      error code
C-----------------------------------------------------------------------
      INTEGER   IVOL, SLOT, LUN, BUFFER(*), IERR
      DOUBLE PRECISION FACTOR
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   VER, NVER, ICCRNO, CCKOLS(MAXCCC), CCNUMV(MAXCCC), NCOL,
     *   NCC, TYPE, I
      REAL      X, Y, Z, FLUX, PARMS(3)
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      IF (FACTOR.EQ.1.0) GO TO 999
C                                       Any SL tables?
      CALL FNDEXT ('CC', CATBLK, NVER)
      IF (NVER.LE.0) GO TO 999
C                                       loop over versions
      DO 100 VER = 1,NVER
         CALL CCMINI ('WRIT', BUFFER, IVOL, SLOT, VER, CATBLK, LUN,
     *      ICCRNO, CCKOLS, CCNUMV, NCOL, IERR)
         IF (IERR.EQ.2) THEN
            WRITE (MSGTXT,1010) VER
            CALL MSGWRT (6)
            IERR = 0
            GO TO 100
         ELSE IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, VER, 'OPENING CC FILE'
            GO TO 980
            END IF
C                                       read/write
         NCC = BUFFER(5)
         DO 30 I = 1,NCC
            ICCRNO = I
            CALL TABCCM ('READ', BUFFER, ICCRNO, CCKOLS, CCNUMV, NCOL,
     *         X, Y, Z, FLUX, TYPE, PARMS, IERR)
            IF (IERR.GT.0) THEN
               WRITE (MSGTXT,1000) IERR, VER, 'READING CC FILE'
               GO TO 980
            ELSE IF (IERR.EQ.0) THEN
               IF (FLUX.NE.FBLANK) FLUX = FLUX * FACTOR
               ICCRNO = I
               CALL TABCCM ('WRIT', BUFFER, ICCRNO, CCKOLS, CCNUMV,
     *            NCOL, X, Y, Z, FLUX, TYPE, PARMS, IERR)
               IF (IERR.NE.0) THEN
                  WRITE (MSGTXT,1000) IERR, VER, 'WRITING CC FILE'
                  GO TO 980
                  END IF
               END IF
 30         CONTINUE
C                                       close
         CALL TABIO ('CLOS', 0, ICCRNO, PARMS, BUFFER, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, VER, 'CLOSING THE CC FILE'
            GO TO 980
            END IF
 100     CONTINUE
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('RESCCC ERROR',I4,' VERSION',I4,' ON ',A)
 1010 FORMAT ('RESCCC DID NOT FIND CC FILE VERSION',I4)
      END
