      SUBROUTINE PCSEL (DISKI, CNOI, DISKO, CNOO, VER, CATIN, CATOUT,
     *   LUNI, LUNO, BPOL, EPOL, BIF, EIF, FREQID, TB, TE, NSOU, SOUIND,
     *   AN, NA, ISUB, JSUB, BUFFER, OBUFF, IRET)
C-----------------------------------------------------------------------
C! Copies an PC table
C# EXT-appl Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 1996-1998, 2007, 2011
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Copies a subset of IFs in a PC table, can also modify the FQ ID
C   Inputs:
C      DISKI    I        Input volume number
C      CNOI     I        Input catalog number
C      DISKO    I        Output volume number
C      CNOO     I        Output catalog number
C      VER      I        Version to check/modify
C      CATIN    I(256)   Input catalog header
C      CATOUT   I(256)   Output catalog header
C      LUNI     I        LUN to use
C      LUNO     I        LUN to use
C      BPOL     I        First polarization to copy
C      EPOL     I        Last polarization to copy
C      BIF      I        Start IF number
C      EIF      I        End IF number
C      IFQID    I        FQ ID to select (set to 1 on output)
C                           if <= 0 then output value unchanged.
C      TB       D        Beginning time in days
C      TE       D        Ending time in days
C      NSOU     I        Number of selected sources
C      SOUIND   I(*)     Array of sources indexes selected
C      AN       I(*)     Array of selected antennas
C      NA       I        Number of selected antennas
C      ISUB     I        Selected subarray (= 0 any)
C      JSUB     I        Output subarray number (< 0 => NO CHANGE)
C   Input/Output:
C      BUFFER   I(*)     Work buffer
C      OBUFF    I(*)     Work buffer
C   Output:
C      IRET     I        Error, 0 => OK
C-----------------------------------------------------------------------
      INTEGER DISKI, CNOI, DISKO, CNOO, VER, CATIN(256), CATOUT(256),
     *   LUNI, LUNO, BPOL, EPOL, BIF, EIF, FREQID, NSOU, SOUIND(*),
     *   AN(*), NA, ISUB, JSUB, BUFFER(*), OBUFF(*), IRET
      DOUBLE PRECISION TB, TE
C
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DGLB.INC'
      INTEGER   NUMIF, NPCROW, I, OPCRNO, NEWNIF, K, OVER, TOPCRN,
     *   TIPCRN, JIF, IIF, IST, ITONE, NEWPOL, LBIF, LBPOL
      LOGICAL   GOTIT, REFMT
C
      INCLUDE 'INCS:PPCV.INC'
C
      INTEGER   IPCRNO, NOPOLZ, NTONES, NCOL, NOSTA, IARRAY, IFQID, ISRC
      REAL      TINT, PCREL(2,MAXTON,MAXIF),
     *   PCIMG(2,MAXTON,MAXIF), PCRAT(2,MAXTON,MAXIF),
     *   STATE(2,4,MAXIF)
      DOUBLE PRECISION TIME, CABLCL, PCFRQ(2, MAXTON, MAXIF)
      INTEGER   PCKOLS(MAXPCC), PCNUMV(MAXPCC), PCKOLO(MAXPCC),
     *   PCNUMO(MAXPCC)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
C-----------------------------------------------------------------------
C                                       Open PC file
      CALL PCINI ('READ', BUFFER, DISKI, CNOI, VER, CATIN, LUNI, IPCRNO,
     *   PCKOLS, PCNUMV, NOPOLZ, NOBAND, NTONES, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1010) IRET
         GO TO 990
         END IF
C                                       number of columns
      NCOL = 7 + NOPOLZ*5
      NUMIF = NOBAND
C                                       New no. of IF's
      LBIF = MAX (1, BIF)
      NEWNIF = MIN (NUMIF, EIF) - LBIF + 1
      IF (NEWNIF.LE.0) THEN
         NEWNIF = NUMIF
         LBIF = 1
         END IF
      LBPOL = MAX (1,BPOL)
      NEWPOL = MIN (2, MIN (NOPOLZ, EPOL)) - LBPOL + 1
      IF (NEWPOL.LE.0) THEN
         NEWPOL = NOPOLZ
         LBPOL = 1
         END IF
      REFMT = (NEWNIF.NE.NUMIF) .OR. (NEWPOL.NE.NOPOLZ)
C                                       Numbers of rows in old table
      NPCROW = BUFFER(5)
      NOBAND = NEWNIF
C                                       Open up new PC table
      OVER = VER
      CALL PCINI ('WRIT', OBUFF, DISKO, CNOO, OVER, CATOUT, LUNO,
     *   OPCRNO, PCKOLO, PCNUMO, NEWPOL, NEWNIF, NTONES, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1020) IRET
         GO TO 990
         END IF
C                                       Loop and copy
      DO 100 I = 1,NPCROW
         NOBAND = NUMIF
         IPCRNO = I
         CALL TABPC ('READ', BUFFER, IPCRNO, PCKOLS, PCNUMV, NOPOLZ,
     *      TIME, TINT, ISRC, NOSTA, IARRAY, IFQID, CABLCL, STATE,
     *      PCFRQ, PCREL, PCIMG, PCRAT, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1030) IRET
            GO TO 990
            END IF
C                                       for READ the old table
         TIPCRN = IPCRNO
C                                       Time selection
         IF ((TIME.LT.TB) .OR. (TIME.GT.TE) ) IRET = -1
C                                       freqid
         IF ((IFQID.GT.0) .AND. (FREQID.GT.0) .AND. (IFQID.NE.FREQID))
     *      IRET = -1
C                                       subarray selection
         IF ((IARRAY.GT.0) .AND. (ISUB.GT.0) .AND. (ISUB.NE.IARRAY))
     *      IRET = -1
C                                       Sources selection
         IF ((NSOU.GT.0) .AND. (ISRC.GT.0)) THEN
            GOTIT = .FALSE.
            DO 20 K = 1,NSOU
               GOTIT = GOTIT .OR. (ISRC.EQ.SOUIND(K))
 20            CONTINUE
            IF (.NOT.GOTIT) IRET = -1
            END IF
C                                       Antennas selection
         IF ((NA.GT.0) .AND. (NOSTA.GT.0)) THEN
            GOTIT = .FALSE.
            DO 30 K = 1,NA
               GOTIT = GOTIT .OR. (NOSTA .EQ. AN(K))
 30            CONTINUE
            IF (.NOT.GOTIT) IRET = -1
            END IF
C                                       Is this record selected ?
         IF (IRET.LT.0) THEN
            REFMT = .TRUE.
C                                       Re-number IF's
         ELSE
            DO 80 JIF = 1,NEWNIF
               IIF = JIF + LBIF - 1
               DO 40 IST = 1,4
                  STATE(1,IST,JIF) = STATE(LBPOL,IST,IIF)
 40               CONTINUE
               DO 50 ITONE = 1,NTONES
                  PCFRQ(1,ITONE,JIF) = PCFRQ(LBPOL,ITONE,IIF)
                  PCREL(1,ITONE,JIF) = PCREL(LBPOL,ITONE,IIF)
                  PCIMG(1,ITONE,JIF) = PCIMG(LBPOL,ITONE,IIF)
                  PCRAT(1,ITONE,JIF) = PCRAT(LBPOL,ITONE,IIF)
 50               CONTINUE
               IF (NEWPOL.EQ.2) THEN
                  DO 60 IST = 1,4
                     STATE(2,IST,JIF) = STATE(2,IST,IIF)
 60                  CONTINUE
                  DO 70 ITONE = 1,NTONES
                     PCFRQ(2,ITONE,JIF) = PCFRQ(2,ITONE,IIF)
                     PCREL(2,ITONE,JIF) = PCREL(2,ITONE,IIF)
                     PCIMG(2,ITONE,JIF) = PCIMG(2,ITONE,IIF)
                     PCRAT(2,ITONE,JIF) = PCRAT(2,ITONE,IIF)
 70                  CONTINUE
                  END IF
 80            CONTINUE
C
            IF (FREQID.GT.0) IFQID = 1
            NOBAND = NEWNIF
            IF (JSUB.GE.0) IARRAY = JSUB
            CALL TABPC ('WRIT', OBUFF, OPCRNO, PCKOLO, PCNUMO, NEWPOL,
     *         TIME, TINT, ISRC, NOSTA, IARRAY, IFQID, CABLCL, STATE,
     *         PCFRQ, PCREL, PCIMG, PCRAT, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1040) IRET
               GO TO 990
               END IF
C                                       store next record number
C                                       for WRIT the new table
            TOPCRN = IPCRNO
            END IF
 100     CONTINUE
      IRET = 0
C                                       Close both tables
      CALL TABIO ('CLOS', 0, IPCRNO, BUFFER, BUFFER, IRET)
      CALL TABIO ('CLOS', 0, OPCRNO, OBUFF, OBUFF, IRET)
      IF ((MSGSUP.LT.31990) .OR. (MSGSUP.GE.32000)) THEN
         IF (REFMT) THEN
            WRITE (MSGTXT,1100) 'Reformatted PC', DISKI, CNOI, VER,
     *         DISKO, CNOO, OVER
         ELSE
            WRITE (MSGTXT,1100) 'Copied PC', DISKI, CNOI, VER, DISKO,
     *         CNOO, OVER
            END IF
         CALL MSGWRT (3)
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (6)
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('PCSEL: ERROR ',I3,' INITING OLD TABLE')
 1020 FORMAT ('PCSEL: ERROR ',I3,' INITING NEW TABLE')
 1030 FORMAT ('PCSEL: ERROR ',I3,' READING OLD TABLE')
 1040 FORMAT ('PCSEL: ERROR ',I3,' WRITING NEW TABLE')
 1100 FORMAT (A,' file from vol/cno/vers',I3,I5,I4,' to',I3,I5,I4)
      END
