      SUBROUTINE GDTERM (NIF, NCH, NANT, DTFILE, DTERMS, IERR)
C-----------------------------------------------------------------------
C! Fills polarization correction table from info in DTERM text file
C# UV EXT-appl Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2021-2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
      INTEGER   NIF, NCH, NANT, IERR
      REAL      DTERMS(2,NCH,NIF,2,*)
      CHARACTER DTFILE*(*)
C
      INTEGER   NT
      PARAMETER (NT = 10000)
C
      INTEGER   TXLUN, TXIND, CHLUN, VER, JI, JF, NLINE, JA, I, I1, I2,
     *   K, SCRBUF(512), IP
      REAL      RF, CATUR(256), DF, DTVALS(4,NT), W1, W2, VALS(4)
      DOUBLE PRECISION F, FN, FX, F0, CATUD(128), FRQ(NT)
      CHARACTER PDFILE*48, DLINE*80
      LOGICAL   EOF
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCHND.INC'
      INCLUDE 'INCS:DDCH.INC'
      EQUIVALENCE (CATUV, CATUR, CATUD)
C-----------------------------------------------------------------------
C                                       get freq info
      VER = 1
      CHLUN = 31
      FQCHND = MAX (0, FRQSEL)
      CALL CHNDAT ('READ', SCRBUF, IUDISK, IUCNO, VER, CATUV, CHLUN,
     *   CHNIF, FOFF, ISBAND, FINC, BNDCOD, FQCHND, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'FINDING FREQUENCIES'
         GO TO 990
         END IF
      F0 = CATUD(KDCRV+KLOCFY)
      RF = CATUR(KRCRP+KLOCFY)
      DF = 0.0D0
      FX = 0.0D0
      FN = 1.D10
      NIF = CHNIF
      NCH = CATUV(KINAX+KLOCFY)
      DO 10 JI = 1,CHNIF
         F = (F0 + FOFF(JI) + FINC(JI) * (1.0 - RF)) / 1.D9
         FX = MAX (FX, F)
         FN = MIN (FN, F)
         F = (F0 + FOFF(JI) + FINC(JI) * (NCH - RF)) / 1.D9
         FX = MAX (FX, F)
         FN = MIN (FN, F)
         DF = MAX (ABS(FINC(JI)), DF)
 10      CONTINUE
      DF = DF / 1.D9
      FX = FX + 1.02 * DF
      FN = FN - 1.02 * DF
C                                       file name
C                                       freqs should choose file
      PDFILE = 'MYWORK:PDPRT.text'
      IF (DTFILE.NE.' ') PDFILE = DTFILE
      TXLUN = 3
      CALL ZTXOPN ('READ', TXLUN, TXIND, PDFILE, .FALSE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN PD TEXT FILE'
         GO TO 990
         END IF
      EOF = .FALSE.
      DF = DF / 50.0
C                                       header read
 100  CALL ZTXIO ('READ', TXLUN, TXIND, DLINE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READ PD TEXT FILE'
         GO TO 990
         END IF
      IF (DLINE(:1).EQ.'#') GO TO 100
C                                       have first line
      NLINE = 0
      GO TO 120
C                                       read next line
 110  CALL ZTXIO ('READ', TXLUN, TXIND, DLINE, IERR)
      IF (IERR.NE.0) THEN
         IF (IERR.EQ.2) THEN
            EOF = .TRUE.
            GO TO 200
            END IF
         WRITE (MSGTXT,1000) IERR, 'READ PD TEXT FILE'
         GO TO 990
         END IF
      IF (DLINE(:1).EQ.'#') GO TO 200
C                                       parse line
 120  NLINE = NLINE + 1
      READ (DLINE,1120) JA, FRQ(NLINE)
      IF ((FRQ(NLINE).LT.FN) .OR. (FRQ(NLINE).GT.FX)) THEN
         NLINE = NLINE - 1
      ELSE
         DO 130 I = 1,4
            IP = 5 + I*10
            IF (DLINE(IP:IP+9).EQ.'   INDE') THEN
               DTVALS(I,NLINE) = FBLANK
            ELSE
               READ (DLINE(IP:IP+9),1130) DTVALS(I,NLINE)
               END IF
 130        CONTINUE
         END IF
      GO TO 110
C                                       interpolate to output
 200  IF (NLINE.EQ.0) THEN
         MSGTXT = 'GDTERMS: NO DATA IN FREQUENCY RANGE'
         CALL MSGWRT (7)
         GO TO 100
         END IF
      DO 250 JI = 1,CHNIF
         DO 240 JF = 1,NCH
            F = (F0 + FOFF(JI) + FINC(JI) * (JF - RF)) / 1.D9
            I = NLINE * (F - FN) / (FX - FN) + 0.5
            IF (ABS(F-FRQ(I)).LT.DF) THEN
               CALL RCOPY (4, DTVALS(1,I), VALS)
            ELSE
               I1 = MAX (1, I-8)
               I2 = MIN (NLINE-1, I+8)
 205           DO 220 I = I1,I2
                  IF ((F.LE.FRQ(I+1)+DF) .AND. (F.GE.FRQ(I)-DF)) THEN
                     W2 = (F - FRQ(I)) / (FRQ(I+1) - FRQ(I))
                     W1 = 1.0 - W2
                     DO 210 K = 1,4
                        VALS(K) = W1*DTVALS(K,I) + W2*DTVALS(K,I+1)
 210                    CONTINUE
                     GO TO 230
                     END IF
 220              CONTINUE
               MSGTXT = 'INTERP NOT WORK'
               CALL MSGWRT (6)
               IF ((I1.GT.1) .OR. (I2.LT.NLINE)) THEN
                  I1 = 1
                  I2 = NLINE-1
                  GO TO 205
                  END IF
               END IF
C                                       copy to output
 230        CALL RCOPY (2, VALS(1), DTERMS(1,JF,JI,1,JA))
            CALL RCOPY (2, VALS(3), DTERMS(1,JF,JI,2,JA))
 240        CONTINUE
 250     CONTINUE
      IF (.NOT.EOF) GO TO 100
      CALL ZTXCLS (TXLUN, TXIND, IERR)
      IERR = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('GDTERMS ERROR',I4,' ON ',A)
 1120 FORMAT (I4,F10.6)
 1130 FORMAT (F10.5)
      END
