      SUBROUTINE FNDCOO (TYPE, JD, SOUID, DISK, CNOIN, CATBLK, LUNSS,
     *   TIME, DRA, DDEC, PLANET, IRET)
C-----------------------------------------------------------------------
C! find source coordinates including planets
C# UV Calibration Editing
C-----------------------------------------------------------------------
C;  Copyright (C) 2019
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Finds source coordinate or planet coordinate.  It will precess PO
C   file positions to apparent if requested.
C   Inputs:
C      TYPE     I      1 -> coord of epoch, else apparent
C      JD       D      Julian date (not used if TYPE = 1 or not planet)
C      SOUID    I      Source number
C      DISK     I      Disk number of data set
C      CNOIN    I      Catalog number of data set
C      CATBLK   I(*)   Catalog header
C      LUNSS    I      LUN to use for SU table
C      TIME     R      Data sample time
C   Outputs:
C      DRA      D      Right ascension (apparent) in radians
C      DDEC     D      Declination (apparent) in radians
C      PLANET   L      True is source in PO table
C-----------------------------------------------------------------------
      INTEGER   TYPE, SOUID, DISK, CNOIN, CATBLK(256), LUNSS, IRET
      LOGICAL   PLANET
      REAL      TIME
      DOUBLE PRECISION JD, DRA, DDEC
C
      INTEGER   LUNPO, PORNO, LSTSOU, POSOUR(100), NPOS, I, NREC, ISOU,
     *   POBUFF(512), POVER, POKOLS(5), PONUMV(5), TABVER, NC, J,
     *   IPORNO
      CHARACTER OBSDAT*8
      DOUBLE PRECISION PRA, PDEC, PDIST, DTIME, DDTIME, PTIME, DELTA, D,
     *   OBSPOS(3), EQUINX
      REAL      POLAR(2)
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DSOU.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
      SAVE LUNPO, LSTSOU, POSOUR, NPOS, POBUFF, POKOLS, PONUMV, DDTIME,
     *   NREC
      DATA LUNPO, LSTSOU, NPOS, POSOUR / 0, -1, 0, 100*0/
      DATA OBSPOS, POLAR, EQUINX /3*0.0D0, 2*0.0, 2000.0D0/
C-----------------------------------------------------------------------
C                                       is there a PO file
      IF (LUNPO.EQ.0) THEN
         CALL FNDEXT ('PO', CATBLK, POVER)
         IF (POVER.EQ.0) THEN
            LUNPO = -1
         ELSE
            NC = 0
            LUNPO = 89
            CALL POINI ('READ', POBUFF, DISK, CNOIN, POVER, CATBLK,
     *         LUNPO, PORNO, POKOLS, PONUMV, OBSDAT, TABVER, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'OPENING PO TABLE'
               CALL MSGWRT (8)
               LUNPO = -1
            ELSE
               NREC = POBUFF(5)
               NPOS = 0
               DO 20 I = 1,NREC
                  IPORNO = I
                  CALL TABPO ('READ', POBUFF, IPORNO, POKOLS, PONUMV,
     *               DTIME, ISOU, PRA, PDEC, PDIST, IRET)
                  IF (IRET.GT.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'READING PO TABLE 1ST'
                     CALL MSGWRT (8)
                     LUNPO = -1
                     GO TO 25
                  ELSE IF (IRET.EQ.0) THEN
                     IF ((I.GT.1) .AND. (DTIME-PTIME.LT.6.9E-4)) THEN
                        DDTIME = DDTIME + (DTIME - PTIME)
                        NC = NC + 1
                        END IF
                     PTIME = DTIME
                     DO 15 J = 1,NPOS
                        IF (ISOU.EQ.POSOUR(J)) GO TO 20
 15                     CONTINUE
                     NPOS = NPOS + 1
                     POSOUR(NPOS) = ISOU
                     END IF
 20               CONTINUE
               DDTIME = DDTIME / MAX (NC, 1)
               IF (DDTIME.LE.0.0) DDTIME = 6.9E-4
               PORNO = 1
               GO TO 50
C                                       error close table
 25            CALL TABPO ('CLOS', POBUFF, PORNO, POKOLS, PONUMV,
     *            DTIME, ISOU, PRA, PDEC, PDIST, IRET)
               NPOS = 0
               END IF
            END IF
         END IF
C                                       process this call
 50   PLANET = .FALSE.
      IF (LSTSOU.EQ.SOUID) THEN
         IF (RAAPP.EQ.0.0D0) RAAPP = RAEPO
         IF (DECAPP.EQ.0.0D0) DECAPP = DECEPO
         IF (TYPE.EQ.1) THEN
            DRA = RAEPO
            DDEC = DECEPO
         ELSE
            DRA = RAAPP
            DDEC = DECAPP
            END IF
         GO TO 999
C                                       find source
      ELSE
C                                       is it a planet?
         DO 60 I = 1,NPOS
            IF (SOUID.EQ.POSOUR(I)) GO TO 100
 60         CONTINUE
C                                       no
         CALL GETSOU (SOUID, DISK, CNOIN, CATBLK, LUNSS, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINDING A NEW SOURCE'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         LSTSOU = SOUID
         IF (RAAPP.EQ.0.0D0) RAAPP = RAEPO
         IF (DECAPP.EQ.0.0D0) DECAPP = DECEPO
         IF (TYPE.EQ.1) THEN
            DRA = RAEPO
            DDEC = DECEPO
         ELSE
            DRA = RAAPP
            DDEC = DECAPP
            END IF
         GO TO 999
C                                       read PO table for source/time
 100     PORNO = MAX (1, MIN (PORNO, NREC))
         IPORNO = PORNO
         LSTSOU = -1
         CALL TABPO ('READ', POBUFF, IPORNO, POKOLS, PONUMV, DTIME,
     *      ISOU, PRA, PDEC, PDIST, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING PO TABLE 1ST'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         IF ((DTIME-DDTIME.GT.TIME) .OR. (ISOU.NE.SOUID)) THEN
            PORNO = 1
            END IF
C                                       loop through PO
         PLANET = .TRUE.
         DELTA = 1.D10
         DO 110 I = PORNO,NREC
            IPORNO = I
            CALL TABPO ('READ', POBUFF, IPORNO, POKOLS, PONUMV, DTIME,
     *         ISOU, PRA, PDEC, PDIST, IRET)
            IF (IRET.GT.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READING PO TABLE 1ST'
               CALL MSGWRT (8)
               GO TO 999
               END IF
            IF (ISOU.EQ.SOUID) THEN
               D = ABS (DTIME-TIME)
               IF (D.LT.DELTA) THEN
                  DELTA = D
                  PORNO = I
                  DRA = PRA * DG2RAD
                  DDEC = PDEC * DG2RAD
                  END IF
               IF ((DTIME.GT.TIME+DDTIME) .AND. (D.GT.DELTA)) THEN
                  IRET = 0
                  GO TO 900
                  END IF
               END IF
 110        CONTINUE
         END IF
C                                       precess planet
 900  IF (TYPE.NE.1) THEN
         PRA = DRA
         PDEC = DDEC
         CALL JPRECS (JD, EQUINX, 1.0D-6, 1, .TRUE., OBSPOS, POLAR, PRA,
     *      PDEC, DRA, DDEC)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('FNDCOO ERROR',I4,' ON ',A)
      END
