      SUBROUTINE ELVSOU (ANTNO, TIME, EL, AZ, RA, DEC, HA)
C-----------------------------------------------------------------------
C! Computes source coordinates from time, azimut, and elevation
C# Math Coordinates UV Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Subroutine to compute the apparent source coordinates based on
C   azimuth and elevation plos antenna coordinates in common.  The
C   routines GETANT and GETSOU should be called before this routine to
C   put the correct values in the relevant commons.
C   Inputs:
C      ANTNO      I    Antenna number
C      TIME       D    Current data time (days).
C      EL         R    Source elevation (rad)
C      AZ         R    Source azimuth (rad)
C   Input from common:
C      STNLAT     D(*) Antenna latitude (rad).
C      STNLON     D(*) Antenna east longitudes (rad).
C      GSTIAT     D    GST at IAT=0 of reference day (rad).
C      ROTIAT     D    Rotation of the earth rate in IAT.
C   Output:
C      RA         D    Right ascension (apparent)
C      DEC        D    Declination
C      HA         R    Source hour angle (rad)  returns -100 for bad
C-----------------------------------------------------------------------
      INTEGER   ANTNO
      DOUBLE PRECISION TIME, RA, DEC
      REAL      HA, EL, AZ
C
      DOUBLE PRECISION HRANG, ANTLST, DARG, DARG1, DARG2, DARG3
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DANS.INC'
C-----------------------------------------------------------------------
C                                       Antenna LST
      ANTLST = GSTIAT + STNLON(ANTNO) + TIME * ROTIAT
C                                       declination
      DARG1 = SIN (STNLAT(ANTNO)) * SIN (EL)
      DARG2 =  COS (STNLAT(ANTNO)) * COS (EL) * COS (AZ)
      DARG = DARG1 + DARG2
      DEC = ASIN (DARG)
C                                       Hour angle
      DARG1 = COS (EL) * COS (AZ)
      DARG2 = COS (STNLAT(ANTNO)) * SIN (DEC)
      DARG = (DARG2 - DARG1) / SIN (STNLAT(ANTNO))
      DARG3 = - COS (EL) * SIN (AZ)
      HRANG = ATAN2 (DARG3, DARG)
      RA = ANTLST - HRANG
      RA = DMOD (RA, TWOPI)
C                                       translate to between -pi and pi
      IF (HRANG.GT.PI) HRANG = HRANG - TWOPI
      IF (HRANG.LT.-PI) HRANG = HRANG + TWOPI
      HA = HRANG
C
 999  RETURN
      END
