      SUBROUTINE DVHROT (VISIN, PA1, PA2, VISOUT)
C-----------------------------------------------------------------------
C! Adds parallactic angle less IFR to linear polarization visibilities
C# UV Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Gets requested data from XY Stokes visibility record, reformatting as
C   needed.  REQUIRES setup by DGINIT to set values in common DSEL.INC.
C   Inputs:
C      VISIN    R(3)   Input visibility array (1 channel real, imag, wt)
C                      Data order VV HH VH HV
C      PA1      R      Parallactic angle zntenna 1 - lambda^2 * IFR(1)
C      PA2      R      Parallactic angle zntenna 2 - lambda^2 * IFR(2)
c                      radians
C   Input from DSEL.INC
C   Output:
C      VISOUT   R(3)   Output visibility record - may be VISIN
C                      Data order VV HH VH HV
C-----------------------------------------------------------------------
      REAL      VISIN(3,4), PA1, PA2, VISOUT(3,4)
C
      INTEGER   I, J, K
      REAL      C1, C2, S1, S2, ARR(4,4), VISI(3,4), VISO(3,4)
      LOGICAL   VHFLAG
C-----------------------------------------------------------------------
C                                       rearrange
      CALL RCOPY (3, VISIN(1,1), VISI(1,1))
      CALL RCOPY (3, VISIN(1,2), VISI(1,4))
      CALL RCOPY (3, VISIN(1,3), VISI(1,2))
      CALL RCOPY (3, VISIN(1,4), VISI(1,3))
      VHFLAG = (VISI(3,1).LE.0.0) .OR. (VISI(3,2).LE.0.0) .OR.
     *   (VISI(3,3).LE.0.0) .OR. (VISI(3,4).LE.0.0)
C                                       prepare 4x4 array
      C1 = COS (PA1)
      S1 = SIN (PA1)
      C2 = COS (PA2)
      S2 = SIN (PA2)
      ARR(1,1) = C1 * C2
      ARR(2,1) = -C1 * S2
      ARR(3,1) = -S1 * C2
      ARR(4,1) = S1 * S2
      ARR(1,2) = C1 * S2
      ARR(2,2) = C1 * C2
      ARR(3,2) = -S1 * S2
      ARR(4,2) = -S1 * C2
      ARR(1,3) = S1 * C2
      ARR(2,3) = -S1 * S2
      ARR(3,3) = C1 * C2
      ARR(4,3) = -C1 * S2
      ARR(1,4) = S1 * S2
      ARR(2,4) = S1 * C2
      ARR(3,4) = C1 * S2
      ARR(4,4) = C1 * C2
C                                       array multiply
      DO 50 K = 1,2
         DO 40 I = 1,4
            VISO(K,I) = 0.0
            DO 30 J = 1,4
               VISO(K,I) = VISO(K,I) + ARR(J,I) * VISI(K,J)
 30            CONTINUE
            VISO(3,I) = VISI(3,I)
            IF (VHFLAG) VISO(3,I) = -ABS (VISO(3,I))
 40         CONTINUE
 50      CONTINUE
C                                       rearrange
      CALL RCOPY (3, VISO(1,1), VISOUT(1,1))
      CALL RCOPY (3, VISO(1,4), VISOUT(1,2))
      CALL RCOPY (3, VISO(1,2), VISOUT(1,3))
      CALL RCOPY (3, VISO(1,3), VISOUT(1,4))
C
 999  RETURN
      END
