      SUBROUTINE BDINI (OPCODE, BUFFER, DISK, CNO, VER, CATBLK, LUN,
     *   IBDRNO, BDKOLS, BDNUMV, NUMANT, NUMPOL, NUMIF, NUMFRQ, IERR)
C-----------------------------------------------------------------------
C! Create/open/initialize bandpass (BD) table
C# EXT-util Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2009, 2022-2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Creates and initializes blcal bandpass (BD) extension tables.
C   Inputs:
C      OPCODE   C*4      Operation code:
C                        'WRIT' = create/init for write or read
C                        'READ' = open for read only
C      DISK     I        Disk to use.
C      CNO      I        Catalog slot number
C      LUN      I        Logical unit number to use
C   Input/output
C      VER      I        BD file version
C      CATBLK   I(256)   Catalog header block.
C   Input (create) / output (pre-existing)
C      NUMANT   I        Number of antennas
C      NUMPOL   I        Number of polarizations.
C      NUMIF    I        Number of IFs
C      NUMFRQ   I        Number of frequency channels
C   Output:
C      BUFFER   I(512)   I/O buffer and related storage, also defines
C                        file if open.
C      IBDRNO   I        Next scan number, start of the file if 'READ',
C                        the last+1 if WRITE
C      BDKOLS   I(MAXBDC)   The column pointer array in order:
C                        TIME, SOURID, SUBARRAY, ANTENNA1, ANTENNA2,
C                        FREQID, REAL1, IMAG1,
C                        Following used if 2 polarizations per IF
C                        REAL2, IMAG2.
C     BDNUMV    I(MAXBDC)   Element count in each column.
C     IERR      I        Return error code, 0=>OK, else TABINI or TABIO
C                        error.
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MAXBDC, MAXBDK, WRDBDK
      PARAMETER (MAXBDC = 14)
      PARAMETER (MAXBDK = 4)
      PARAMETER (WRDBDK = 4)
C
      CHARACTER OPCODE*4
      INTEGER   BUFFER(*), DISK, CNO, VER, CATBLK(256), LUN, IBDRNO,
     *   BDKOLS(MAXBDC), BDNUMV(MAXBDC), NUMANT, NUMPOL, NUMIF, NUMFRQ,
     *   IERR
C
      HOLLERITH HOLTMP(6)
      CHARACTER TTITLE*56, TITLE(MAXBDC)*24, UNITS(MAXBDC)*8,
     *   KEYW(MAXBDK)*8
      INTEGER   NKEY, NREC, DATP(128,2), NCOL, NTT, DTYP(MAXBDC), NDATA,
     *   KLOCS(MAXBDK), KEYVAL(WRDBDK), KEYTYP(MAXBDK), IPOINT, MSGSAV,
     *   I, NC, JERR, ITRIM, ITEMP(6)
      REAL      KEYVAR(WRDBDK)
      LOGICAL   DOREAD, NEWFIL
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      EQUIVALENCE (KEYVAL, KEYVAR), (HOLTMP, ITEMP)
      DATA NTT /56/
      DATA TTITLE /'AIPS UV DATA FILE BLCHN BANDPASS TABLE'/
      DATA DTYP /22, 5*14, 8*2/
      DATA TITLE /'TIME RANGE', 'SOURCE ID ', 'SUBARRAY ', 'ANTENNA1 ',
     *   'ANTENNA2 ', 'FREQ ID ', 'REAL 1 ', 'IMAG 1 ',
     *   'REAL 2 ', 'IMAG 2 ', 'REAL 3 ', 'IMAG 3 ',
     *   'REAL 4 ', 'IMAG 4 '/
      DATA KEYW /'NO_ANT', 'NO_POL', 'NO_IF', 'NO_CHAN'/
      DATA UNITS /'DAYS ', 13*' '/
C-----------------------------------------------------------------------
C                                       Check OPCODE
      DOREAD = OPCODE.EQ.'READ'
C                                       Open file
      NREC = 500
      NKEY = 9
      NDATA = MAXBDC
      CALL FILL (NDATA, 0, BDKOLS)
      CALL FILL (NDATA, 0, BDNUMV)
C                                       Fill in types
      IF (.NOT.DOREAD) THEN
         NCOL = 6 + NUMPOL * 2
         CALL COPY (NDATA, DTYP, DATP(1,2))
C                                       Correct for real/imag
         DATP(7,2) = DTYP(7) + 10*NUMFRQ*NUMIF
         DATP(8,2) = DTYP(8) + 10*NUMFRQ*NUMIF
         DATP(9,2) = DTYP(9) + 10*NUMFRQ*NUMIF
         DATP(10,2) = DTYP(10) + 10*NUMFRQ*NUMIF
         DATP(11,2) = DTYP(11) + 10*NUMFRQ*NUMIF
         DATP(12,2) = DTYP(12) + 10*NUMFRQ*NUMIF
         DATP(13,2) = DTYP(13) + 10*NUMFRQ*NUMIF
         DATP(14,2) = DTYP(14) + 10*NUMFRQ*NUMIF
      ELSE
         NCOL = 0
         END IF
C                                       Create/open file
      CALL TABINI (OPCODE, 'BD', DISK, CNO, VER, CATBLK, LUN, NKEY,
     *   NREC, NCOL, DATP, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR (OPCODE, 'TABINI', 'BDINI', IERR)
         GO TO 990
         END IF
      NEWFIL = IERR.LT.0
      MSGSAV = MSGSUP
C                                       Get number of scans
      IBDRNO = BUFFER(5) + 1
      IF (DOREAD) IBDRNO = 1
      NKEY = MAXBDK
C                                       File created, initialize
      IF (NEWFIL) THEN
C                                       Col. labels.
         DO 10 I = 1,NCOL
            CALL CHR2H (24, TITLE(I), 1, ITEMP)
            CALL TABIO ('WRIT', 3, I, ITEMP, BUFFER, IERR)
            IF (IERR.GT.0) THEN
               CALL TABERR ('WRIT', 'TABIO', 'BDINI', IERR)
               GO TO 990
               END IF
C                                       Units
            CALL CHR2H (8, UNITS(I), 1, ITEMP)
            CALL TABIO ('WRIT', 4, I, ITEMP, BUFFER, IERR)
            IF (IERR.GT.0) THEN
               CALL TABERR ('WRIT', 'TABIO', 'BDINI', IERR)
               GO TO 990
               END IF
 10         CONTINUE
C                                       Fill in Table title
         CALL CHR2H (NTT, TTITLE, 1, BUFFER(101))
C                                       Set keyword values
C                                       No. antennas.
         KLOCS(1) = 1
         KEYTYP(1) = 4
         KEYVAL(1) = NUMANT
C                                       No. Polarizations
         KLOCS(2) = 2
         KEYTYP(2) = 4
         KEYVAL(2) = NUMPOL
C                                       No. IFs
         KLOCS(3) = 3
         KEYTYP(3) = 4
         KEYVAL(3) = NUMIF
C                                       No. CHAN
         KLOCS(4) = 4
         KEYTYP(4) = 4
         KEYVAL(4) = NUMFRQ
C                                       Only write if just created.
         CALL TABKEY ('WRIT', KEYW, NKEY, BUFFER, KLOCS, KEYVAL, KEYTYP,
     *      IERR)
         IF ((IERR.GE.1) .AND. (IERR.LE.20)) THEN
            CALL TABERR ('WRIT', 'TABKEY', 'BDINI', IERR)
            GO TO 990
            END IF
C                                       Read keywords
      ELSE
         MSGSUP = 32000
         CALL TABKEY ('READ', KEYW, NKEY, BUFFER, KLOCS, KEYVAL, KEYTYP,
     *      IERR)
         MSGSUP = MSGSAV
         IF ((IERR.GE.1) .AND. (IERR.LE.20)) THEN
            CALL TABERR ('READ', 'TABKEY', 'BDINI', IERR)
            GO TO 990
            END IF
C                                       Retrieve keyword values
C                                       No. antennas.
         IPOINT = KLOCS(1)
         IF (IPOINT.GT.0) NUMANT = KEYVAL(IPOINT)
C                                       No. polarizations
         IPOINT = KLOCS(2)
         IF (IPOINT.GT.0) NUMPOL = KEYVAL(IPOINT)
C                                       No. IFs
         IPOINT = KLOCS(3)
         IF (IPOINT.GT.0) NUMIF = KEYVAL(IPOINT)
C                                       No. CHAN
         IPOINT = KLOCS(4)
         IF (IPOINT.GT.0) NUMFRQ = KEYVAL(IPOINT)
         END IF
      IERR = 0
C                                      Get array indices
C                                      Cover your ass from FNDCOL -
C                                      close to flush the buffers and
C                                      then reopen.
      CALL TABIO ('CLOS', 0, IPOINT, ITEMP, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR ('CLOS', 'TABIO', 'BDINI', IERR)
         GO TO 990
         END IF
      NKEY = 0
      CALL TABINI (OPCODE, 'BD', DISK, CNO, VER, CATBLK, LUN, NKEY,
     *   NREC, NCOL, DATP, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR (OPCODE, 'TABINI', 'BDINI', IERR)
         GO TO 990
         END IF
      CALL FNDCOL (NDATA, TITLE, 24, .TRUE., BUFFER, BDKOLS, JERR)
C                                      Get array indices and no. values
      NCOL = 6 + NUMPOL * 2
      DO 150 I = 1,NCOL
         IPOINT = BDKOLS(I)
         IF (IPOINT.GT.0) THEN
            BDKOLS(I) = DATP(IPOINT,1)
            BDNUMV(I) = DATP(IPOINT,2) / 10
            IF (BDNUMV(I).LE.0) THEN
               NC = ITRIM (TITLE(I))
               WRITE (MSGTXT,1100) TITLE(I)(:NC)
               CALL MSGWRT (6)
               END IF
         ELSE
            BDKOLS(I) = -1
            BDNUMV(I) = 0
            IF ((NUMPOL.GT.1) .OR. (I.LE.NDATA-4)) THEN
               NC = ITRIM (TITLE(I))
               WRITE (MSGTXT,1101) TITLE(I)(:NC)
               CALL MSGWRT (6)
               END IF
            END IF
 150     CONTINUE
      GO TO 999
C                                       Error
 990  WRITE (MSGTXT,1990) OPCODE
      CALL MSGWRT (7)
C
 999  RETURN
C-----------------------------------------------------------------------
 1100 FORMAT ('BDINI: ''',A,''' COLUMN HAS NO VALUES')
 1101 FORMAT ('BDINI: ''',A,''' COLUMN NOT FOUND')
 1990 FORMAT ('BDINI: ERROR INITIALIZING BANDPASS TABLE FOR ',A)
      END
