      SUBROUTINE MSGONE (BUF)
C-----------------------------------------------------------------------
C! creates user 1 message file
C# POPS-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2019
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Checks for existence of user 1 message file in program AIPS only
C   Outputs:
C      BUF   I(256)     Scratch buffer
C-----------------------------------------------------------------------
      INTEGER   BUF(256)
C
      INTEGER   NWPL, NLPR, ISIZE, LSIZE, IER, IRNO, LUN, FIND, IUSER
      CHARACTER PHNAME*48
      INCLUDE 'INCS:DMSG.INC'


      DATA LUN /15/

C-----------------------------------------------------------------------
      IF (TSKNAM.EQ.'AIPS') THEN
         NWPL = 25
         NLPR = 255 / NWPL
         ISIZE = 25/NLPR + 1
         IUSER = 1
         CALL ZPHFIL ('MS', 1, IUSER, 0, PHNAME, IER)
         CALL ZEXIST (1, PHNAME, LSIZE, IER)
         IF (IER.NE.0) THEN
            CALL ZCREAT (1, PHNAME, ISIZE, .FALSE., LSIZE, IER)
            IF (IER.EQ.0) THEN
               CALL ZOPEN (LUN, FIND, 1, PHNAME, .FALSE., .TRUE.,
     *            .TRUE., IER)
               IF (IER.EQ.0) THEN
                  CALL FILL (256, 0, BUF)
                  BUF(1) = 0
                  BUF(2) = LSIZE
                  IRNO = 1
                  CALL ZFIO ('WRIT', LUN, FIND, IRNO, BUF, IER)
                  CALL ZCLOSE (LUN, FIND, IER)
                  END IF
               END IF
            END IF
         END IF
C
 999  RETURN
      END


