      SUBROUTINE HIADDN (LUN, N, HILINE, BUF, CHK, IERR)
C-----------------------------------------------------------------------
C! Writes one history line to several history files
C# History
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C   HIADDN is used by HIMERG for output to avoid large numbers of loops.
C   Inputs:
C      LUN  I(N)     Input LUNs.
C      CHK  I(N)     Only write if CHK(I) = 0.
C      N             Number of files (including "dummies").
C      HILINE        String to add.
C   In/Out:
C      BUF  I(256,N) Working buffers
C      IERR I        Error code = max error code generated by HIADD
C-----------------------------------------------------------------------
      INTEGER   N, IERR
      INTEGER   LUN(*), CHK(*), BUF(256,*)
      CHARACTER HILINE*(*)
      INTEGER   J, JER
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      DO 10 J = 1,N
         IF (CHK(J) .NE. 0) GO TO 10
            CALL HIADD (LUN(J), HILINE, BUF(1,J), JER)
            IF (JER .NE. 0) THEN
               WRITE (MSGTXT,1910) JER, J
               CHK(J) = -1
               IERR = MAX(IERR,JER)
               END IF
 10      CONTINUE
      RETURN
C-----------------------------------------------------------------------
 1910 FORMAT ('HIADDN ADD ERROR',I7,' ON OUTPUT FILE',I3)
      END
