      SUBROUTINE FNDX (XPIX, YVAL, XVAL, IERR)
C-----------------------------------------------------------------------
C! returns X-axis coordinate value given X pixel and Y coordinate value
C# Coordinates
C-----------------------------------------------------------------------
C;  Copyright (C) 1995, 2013
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   FNDX returns the X axis coordinate value of a point given the Y
C   axis coordinate value and the X axis pixel position of the point.
C   Needed for rotations and non-linear axes (L-M).
C   Inputs:
C      XPIX   R     X pixel position
C      YVAL   D     Y coordinate value
C   Output:
C      XVAL   D     X coordinate value
C      IERR   I     0 ok, 1 out of range, 2 bad type, 3 undefined
C   Common:
C      /LOCATI/ pos parms must have been set up by SETLOC
C-----------------------------------------------------------------------
      REAL      XPIX
      INTEGER   IERR
      DOUBLE PRECISION YVAL, XVAL
C
      DOUBLE PRECISION R, D, P, RA0, DEC0, DS, DX, DZ, COSR, SINR
      INTEGER   I
      INCLUDE 'INCS:DLOC.INC'
C-----------------------------------------------------------------------
      IERR = 0
      DX = (XPIX - RPLOC(1,LOCNUM)) * AXINC(1,LOCNUM)
C                                       x not related to y, z
      IF ((AXTYP(LOCNUM).LE.0) .OR. (AXTYP(LOCNUM).GE.3)) THEN
         XVAL = DX + RPVAL(1,LOCNUM)
         IF ((KLOCF(LOCNUM).EQ.0) .AND. (AXFUNC(1,LOCNUM).EQ.1)) XVAL =
     *      RPVAL(1,LOCNUM) + DX / (1.0D0 + AXDENU(LOCNUM) *
     *      (XPIX-RPLOC(1,LOCNUM)))
C                                       related somehow
      ELSE
         I = AXFUNC(KLOCL(LOCNUM)+1,LOCNUM)
         R = ROT(LOCNUM) * COND2R
         COSR = COS (R)
         SINR = SGNROT(LOCNUM) * SIN (R)
C                                       x with y
         IF (AXTYP(LOCNUM).NE.2) THEN
C                                       linear
            IF ((CORTYP(LOCNUM).LE.0) .OR. (I.LE.1)) THEN
               IF (COSR.EQ.0.) DX = 0.0
               IF (COSR.NE.0.) DX = (DX - (YVAL-RPVAL(2,LOCNUM))*SINR) /
     *            COSR
               XVAL = DX + RPVAL(1,LOCNUM)
C                                       non-linear
            ELSE
               D = COND2R * YVAL
               P = COND2R * DX
               RA0 = COND2R * RPVAL(CORTYP(LOCNUM),LOCNUM)
               DEC0 = COND2R * RPVAL(3-CORTYP(LOCNUM),LOCNUM)
               IF (CORTYP(LOCNUM).EQ.1) THEN
                  CALL DIRRA (I, P, D, RA0, DEC0, R, DS, XVAL, IERR)
               ELSE IF (CORTYP(LOCNUM).EQ.2) THEN
                  CALL DIRDEC (I, P, D, RA0, DEC0, R, DS, XVAL, IERR)
                  END IF
               XVAL = XVAL / COND2R
               END IF
C                                       x with z : rotation first
         ELSE
            DZ = (ZDEPTH(ZAXIS(LOCNUM)-2,LOCNUM) - RPLOC(3,LOCNUM)) *
     *         AXINC(3,LOCNUM)
            P = DX*COSR - DZ*SINR
            DZ = DZ*COSR + DX*SINR
            DX = P
C                                       linear
            IF ((CORTYP(LOCNUM).LE.0) .OR. (I.LE.1)) THEN
               XVAL = DX + RPVAL(1,LOCNUM)
C                                       non-linear
            ELSE
               DX = COND2R * DX
               DZ = COND2R * DZ
               RA0 = COND2R * RPVAL(1,LOCNUM)
               DEC0 = COND2R * RPVAL(3,LOCNUM)
               IF (CORTYP(LOCNUM).EQ.3) THEN
                  CALL NEWPOS (I, RA0, DEC0, DX, DZ, XVAL, DS, IERR)
               ELSE IF (CORTYP(LOCNUM).EQ.4) THEN
                  CALL NEWPOS (I, DEC0, RA0, DZ, DX, DS, XVAL, IERR)
                  END IF
               XVAL = XVAL / COND2R
               END IF
            END IF
         END IF
C
 999  RETURN
      END
