LOCAL INCLUDE 'PRRFI.INC'
C                                       Local include for PRRFI
      INCLUDE 'INCS:ZPBUFSZ.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   ANTMAX, MXF
      PARAMETER (ANTMAX = 50)
      PARAMETER (MXF = 100)
C
      HOLLERITH XINFIL(12), XOUFIL(12)
      REAL      XANT(50), XBCNT, XECNT, APARM(10)
      REAL      PMEAN(MAXCIF,ANTMAX), PMAX(MAXCIF,ANTMAX),
     *   PMIN(MAXCIF,ANTMAX), RMEAN(MAXCIF,ANTMAX), RMAX(MAXCIF,ANTMAX),
     *   RMIN(MAXCIF,ANTMAX), MMEAN(MAXCIF,ANTMAX), MMAX(MAXCIF,ANTMAX),
     *   MMIN(MAXCIF,ANTMAX)
      LOGICAL   GOTANT(ANTMAX), WANANT(ANTMAX), NEWFMT
      INTEGER   NSAMP, NPARM, NOFILE, BCOUNT, ECOUNT, SCRBUF(256),
     *   NR(ANTMAX)
      DOUBLE PRECISION FREQS(MAXCIF,ANTMAX)
      CHARACTER INFILE(MXF)*48,
     *   OUFILE*48, ANTDAT(ANTMAX)*8, ANTNAM(ANTMAX)*8, CINFIL*48
      COMMON /INPARM/ XANT, XINFIL, XBCNT, XECNT, XOUFIL, APARM
      COMMON /PRRFIV/ FREQS, NSAMP, NPARM, GOTANT, WANANT,
     *   NOFILE, BCOUNT, ECOUNT, NR, NEWFMT
      COMMON /ANSWER/ PMEAN, PMIN, PMAX, RMEAN, RMIN, RMAX, MMEAN, MMIN,
     *   MMAX
      COMMON /CHARPM/ INFILE, ANTDAT, ANTNAM, CINFIL, OUFILE
      COMMON /BUFRS/ SCRBUF
C                                       End local include for PRRFI
LOCAL END
      PROGRAM PRRFI
C-----------------------------------------------------------------------
C! Plots statistics of selected autocorrelation data from VBRFI output
C# UV UV-util Calibration Plot Hardcopy
C-----------------------------------------------------------------------
C;  Copyright (C) 2022-2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PRRFI plots statistics from a sample of uv data
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input VU data.
C   full set of calibration adverbs
C      OPTYPE         OPTYPE        Type of data to process
C      SOLINT         SOLINT        Averaging time (min)
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, JA
      INCLUDE 'PRRFI.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA PRGM /'PRRFI '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL PRRFII (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       read data
      CALL PRRFIR (IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Print one antenna at a time
      DO 30 JA = 1,ANTMAX
         IF ((GOTANT(JA)) .AND. (IRET.EQ.0)) THEN
            CALL PRRFIP (JA, IRET)
            END IF
 30      CONTINUE
C                                       Close down files, etc.
 990  IRET = MAX (0, IRET)
      CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE PRRFII (PRGN, JERR)
C-----------------------------------------------------------------------
C   PRRFII gets input parameters for PRRFI
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      JERR    I    Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C   Output in common:
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      INTEGER   JERR
      CHARACTER PRGN*6
C
      INTEGER   IROUND, IERR, I, J, ANTENS(50)
      LOGICAL   WASNEG
      INCLUDE 'PRRFI.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
      CALL LFILL (ANTMAX, .FALSE., GOTANT)
C                                       Get input parameters.
      NPARM = 86
      CALL GTPARM (PRGN, NPARM, RQUICK, XANT, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, SCRBUF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (48, 1, XINFIL, CINFIL)
      CALL H2CHR (48, 1, XOUFIL, OUFILE)
      BCOUNT = XBCNT + 0.1
      ECOUNT = XECNT + 0.1
      BCOUNT = MAX (1, BCOUNT)
      ECOUNT = MAX (ECOUNT, BCOUNT)
      XBCNT = BCOUNT
      XECNT = ECOUNT
      NOFILE = ECOUNT - BCOUNT + 1
      WASNEG = .FALSE.
      J = 0
      DO 20 I = 1,50
         ANTENS(I) = IROUND (XANT(I))
         IF (ANTENS(I).LT.0) THEN
            WASNEG = .TRUE.
            ANTENS(I) = -ANTENS(I)
            END IF
         IF (ANTENS(I).NE.0) J = J + 1
 20      CONTINUE
      CALL RFILL (44, 0.0, XANT(7))
      CALL CHR2H (6, TSKNAM, 1, XANT(5))
      CALL LFILL (ANTMAX, .TRUE., WANANT)
      IF (WASNEG) THEN
         DO 25 I = 1,50
            IF (ANTENS(I).GT.0) WANANT(ANTENS(I)) = .FALSE.
 25         CONTINUE
      ELSE IF (J.GT.0) THEN
         CALL LFILL (ANTMAX, .FALSE., WANANT)
         DO 30 I = 1,50
            IF (ANTENS(I).GT.0) WANANT(ANTENS(I)) = .TRUE.
 30         CONTINUE
         END IF
C                                       init answers
      I = ANTMAX * MAXCIF
      CALL RFILL (I, FBLANK, PMEAN)
      CALL RFILL (I, FBLANK, PMIN)
      CALL RFILL (I, FBLANK, PMAX)
      CALL RFILL (I, FBLANK, RMEAN)
      CALL RFILL (I, FBLANK, RMIN)
      CALL RFILL (I, FBLANK, RMAX)
      CALL RFILL (I, FBLANK, MMEAN)
      CALL RFILL (I, FBLANK, MMIN)
      CALL RFILL (I, FBLANK, MMAX)
      JERR = 0
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRRFII: ERROR',I3,' ON ',A)
      END
      SUBROUTINE PRRFIR (IRET)
C-----------------------------------------------------------------------
C   PRRFIR reads the text data and prepares a list of values by antenna
C   Output:
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'PRRFI.INC'
      INTEGER   INDEX, TXLUN, TXIND, J, IP, LANT, LCH, LIF, LP, JTRIM,
     *   IFIL
      CHARACTER INLINE*256, DATE*8, STN*8
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA TXLUN /3/
C-----------------------------------------------------------------------
      CALL DFILL (MAXCIF*ANTMAX, 0.0D0, FREQS)
      CALL FILL (ANTMAX, 0, NR)
C                                       find actual values
      CALL PRRFIF (IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING ACTUAL INPUT FILE NAMES'
         GO TO 990
         END IF
      DO 100 IFIL = 1,NOFILE
         CALL ZTXOPN ('READ', TXLUN, TXIND, INFILE(IFIL), .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPEN INTPUT TEXT FILE'
            GO TO 990
            END IF
         LANT = 0
C                                       read the data
 20      CALL ZTXIO ('READ', TXLUN, TXIND, INLINE, IRET)
         IF (IRET.EQ.2) THEN
            IRET = 0
            GO TO 90
         ELSE IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING TEXT FILE'
            GO TO 990
         ELSE IF ((INLINE(:11).EQ.'*** DATEOBS') .OR.
     *      (INLINE(:12).EQ.'**** DATEOBS')) THEN
            NEWFMT = INLINE(4:4).EQ.'*'
            IP = INDEX (INLINE, '''')
            DATE = INLINE(IP+1:IP+8)
            IP = INDEX (INLINE, 'ANTENNA=')
            LP = IP+8
            CALL GETNUM (INLINE, 256, LP, XX)
            LANT = XX + 0.1
            IF ((LANT.LT.1) .OR.(LANT.GT.ANTMAX)) THEN
               WRITE (MSGTXT,1020) LANT, ANTMAX
               CALL MSGWRT (7)
               LANT = 0
               GO TO 20
               END IF
            IF (.NOT.WANANT(LANT)) THEN
               LANT = 0
               GO TO 20
               END IF
            IP = INDEX (INLINE, 'STATION')
            IP = IP + 7
            LP = INDEX (INLINE(IP:), '''')
            LP = LP + IP
            IP = INDEX (INLINE(LP:), '''')
            STN = INLINE(LP:LP+IP)
            LP = JTRIM(STN)
            IF (STN(LP:LP).EQ.'''') STN(LP:) = ' '
            ANTDAT(LANT) = DATE
            ANTNAM(LANT) = STN
C                                       data row
         ELSE IF ((INLINE(:1).EQ.' ') .AND. (LANT.GT.0)) THEN
            LP = 1
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            LIF = XX + 0.1
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            LCH = XX + 0.1
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            GOTANT(LANT) = .TRUE.
            NR(LANT) = NR(LANT) + 1
            J = NR(LANT)
            FREQS(J,LANT) = XX
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMEAN(J,LANT) = FBLANK
            ELSE
               PMEAN(J,LANT) = XX
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMIN(J,LANT) = FBLANK
            ELSE
               PMIN(J,LANT) = XX
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMAX(J,LANT) = FBLANK
            ELSE
               PMAX(J,LANT) = XX
               END IF
            IF (NEWFMT) THEN
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMEAN(J,LANT) = FBLANK
               ELSE
                  RMEAN(J,LANT) = XX
                  END IF
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMIN(J,LANT) = FBLANK
               ELSE
                  RMIN(J,LANT) = XX
                  END IF
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMAX(J,LANT) = FBLANK
               ELSE
                  RMAX(J,LANT) = XX
                  END IF
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMEAN(J,LANT) = FBLANK
            ELSE
               MMEAN(J,LANT) = XX / 1.D3
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMIN(J,LANT) = FBLANK
            ELSE
               MMIN(J,LANT) = XX / 1.D3
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMAX(J,LANT) = FBLANK
            ELSE
               MMAX(J,LANT) = XX / 1.D3
               END IF
            END IF
         GO TO 20
C                                       close
 90      CALL ZTXCLS (TXLUN, TXIND, J)
 100     CONTINUE
C                                       no straight rms
      IF (.NOT.NEWFMT) THEN
         APARM(3) = 0.0
         APARM(4) = 0.0
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRRFIR: ERROR',I3,' ON ',A)
 1020 FORMAT ('PRRFIR: ANTENNA',I4,' OUTSIDE RANGE 1 -',I4)
      END
      SUBROUTINE PRRFIF (IRET)
C-----------------------------------------------------------------------
C   Finds actual file names
C   Output:
C      IRET    I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'PRRFI.INC'
      INTEGER   JTRIM, IFIL, TXLUN, TXIND, I, NC, MSGSAV
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA TXLUN /3/
C-----------------------------------------------------------------------
C                                       Prepare file names
      NC = JTRIM (CINFIL)
      INFILE(1) = CINFIL
      MSGSAV = MSGSUP
      MSGSUP = 32000
      CALL ZTXOPN ('QRED', TXLUN, TXIND, INFILE(1), .TRUE., IRET)
      MSGSUP = MSGSAV
      IF (IRET.NE.0) THEN
         IFIL = BCOUNT
         IF (IFIL.LT.10) THEN
            WRITE (INFILE(1),1010) CINFIL(:NC), IFIL
         ELSE
            WRITE (INFILE(1),1011) CINFIL(:NC), IFIL
            END IF
         CALL ZTXOPN ('QRED', TXLUN, TXIND, INFILE(1), .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPEN INPUT TEXT FILE', BCOUNT
            GO TO 990
            END IF
         END IF
      CALL ZTXCLS (TXLUN, TXIND, IRET)
      DO 10 I = 2,NOFILE
         IFIL = I + BCOUNT - 1
         IF (IFIL.LT.10) THEN
            WRITE (INFILE(I),1010) CINFIL(:NC), IFIL
         ELSE
            WRITE (INFILE(I),1011) CINFIL(:NC), IFIL
            END IF
 10      CONTINUE
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRRFIF: ERROR',I4,' ON ',A,' FILE',I2)
 1010 FORMAT (A,I1)
 1011 FORMAT (A,I2)
      END
      SUBROUTINE PRRFIP (LANT, IRET)
C-----------------------------------------------------------------------
C   Print over cutoffs
C   Input:
C      LANT   I   Desired antenna
C   Output
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   LANT, IRET
C
      INCLUDE 'PRRFI.INC'
      INTEGER   JTRIM, JT, J, I, TXLUN, TXIND, NP
      CHARACTER PRFILE*48, OUTLIN*256
      LOGICAL   FIRST
      REAL      CUT
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA TXLUN /3/
C-----------------------------------------------------------------------
      JT = JTRIM (OUFILE)
      IF (OUFILE(JT:JT).NE.':') THEN
         JT = JT + 1
         OUFILE(JT:) = ':'
         END IF
      PRFILE = OUFILE(:JT) // ANTNAM(LANT)(:2) // ANTDAT(LANT) // '.txt'
      CALL ZTXOPN ('WRIT', TXLUN, TXIND, PRFILE, .TRUE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CREATE OUTPUT TEXT FILE', LANT
         GO TO 990
         END IF
C                                       Pmean autocorrelation values
      CUT = APARM(1)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 20 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((PMEAN(I,LANT).GT.CUT) .OR. (PMEAN(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Pmean', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 20         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Pmean', CUT, NP
         CALL MSGWRT (3)
         END IF
C                                       Pmax autocorrelation values
      CUT = APARM(2)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 30 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((PMAX(I,LANT).GT.CUT) .OR. (PMAX(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Pmax', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 30         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Pmax ', CUT, NP
         CALL MSGWRT (3)
         END IF
C                                       Rmean autocorrelation values
      CUT = APARM(3)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 40 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((rMEAN(I,LANT).GT.CUT) .OR. (rMEAN(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Rmean', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 40         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Rmean', CUT, NP
         CALL MSGWRT (3)
         END IF
C                                       Rmax autocorrelation values
      CUT = APARM(4)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 50 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((RMAX(I,LANT).GT.CUT) .OR. (RMAX(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Pmean', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 50         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Rmax', CUT, NP
         CALL MSGWRT (3)
         END IF
C                                       Mmean autocorrelation values
      CUT = APARM(5)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 60 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((MMEAN(I,LANT).GT.CUT) .OR. (MMEAN(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Mmean', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 60         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Mmean', CUT, NP
         CALL MSGWRT (3)
         END IF
C                                       Pmean autocorrelation values
      CUT = APARM(6)
      IF (CUT.GT.0.0) THEN
         NP = 0
         FIRST = .TRUE.
         DO 70 I = 1,NR(LANT)
            IF ((PMEAN(I,LANT).NE.FBLANK) .AND.
     *         ((MMAX(I,LANT).GT.CUT) .OR. (MMAX(I,LANT).LT.0.0)))
     *         THEN
               IF (FIRST) THEN
                  WRITE (OUTLIN,1010) ANTNAM(LANT)(:2), ANTDAT(LANT),
     *               'Mmax', CUT
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *                  LANT
                     GO TO 990
                     END IF
                  FIRST = .FALSE.
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1015)
                  ELSE
                     WRITE (OUTLIN,1011)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  IF (NEWFMT) THEN
                     WRITE (OUTLIN,1016)
                  ELSE
                     WRITE (OUTLIN,1012)
                     END IF
                  J = JTRIM(OUTLIN)
                  CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:J), IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET,
     *                  'WRITE OUTPUT TEXT FILE', LANT
                     GO TO 990
                     END IF
                  END IF
               IF (NEWFMT) THEN
                  WRITE (OUTLIN,1021) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), RMEAN(I,LANT),
     *               RMIN(I,LANT), RMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
               ELSE
                  WRITE (OUTLIN,1020) FREQS(I,LANT), PMEAN(I,LANT),
     *               PMIN(I,LANT), PMAX(I,LANT), MMEAN(I,LANT)*1000.,
     *               MMIN(I,LANT)*1000., MMAX(I,LANT)*1000.
                  END IF
               JT = JTRIM (OUTLIN)
               CALL ZTXIO ('WRIT', TXLUN, TXIND, OUTLIN(:JT), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT TEXT FILE',
     *               LANT
                  GO TO 990
                  END IF
               NP = NP + 1
               END IF
 70         CONTINUE
         WRITE (MSGTXT,1025) 'Autocorrelation Mmax', CUT, NP
         CALL MSGWRT (3)
         END IF
C
      CALL ZTXCLS (TXLUN, TXIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSING OUTPUT TEXT FILE', LANT
         GO TO 990
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRRFI ERROR',I4,' ON ',A,'  ANTENNA',I3)
 1010 FORMAT ('STATION = ''',A,'''   DATEOBS=',A,
     *      '  AUTOCORR ',A,'  CUTOFF=',F7.2)
 1011 FORMAT (3X,'FREQ',7X,'Pmean',4X,'Pmin',4X,'Pmax',3X,'Mmean',4X,
     *   'Mmin',5X,'Mmax')
 1012 FORMAT (4X,'GHz',28X,2(3X,'milli'),4X,'milli')
 1015 FORMAT (3X,'FREQ',7X,'Pmean',4X,'Pmin',4X,'Pmax',4X,'Rmean',4X,
     *   'Rmin',4X,'Rmax',3X,'Mmean',4X,'Mmin',5X,'Mmax')
 1016 FORMAT (4X,'GHz',52X,2(3X,'milli'),4X,'milli')
 1020 FORMAT (F11.5,3F8.3,2F8.2,F9.2)
 1021 FORMAT (F11.5,6F8.3,2F8.2,F9.2)
 1025 FORMAT (A,' cutoff',F8.3,' printed',I7,' lines')
      END
