LOCAL INCLUDE 'INPUT.INC'
C                                       Declarations for inputs
      INCLUDE 'INCS:PAOOF.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   NPARMS
      PARAMETER (NPARMS=14)
      INTEGER   AVTYPE(NPARMS), AVDIM(2,NPARMS)
      CHARACTER AVNAME(NPARMS)*8
LOCAL END
LOCAL INCLUDE 'INPUTDATA.INC'
C                                       DATA statments defining input
C                                       parameters.
C                      1         2          3        4         5
      DATA AVNAME /'INNAME', 'INCLASS', 'INSEQ', 'INDISK', 'INVERS',
C            6         7           8           9         10
     *   'FREQID', 'SUBARRAY', 'ANTENNAS', 'DOHIST', 'ANTUSE',
C            11         12          13         14
     *   'FLAGVER', 'CALSOUR', 'TIMERANG', 'BADDISK'/
C                    1       2       3       4       5
      DATA AVTYPE /OOACAR, OOACAR, OOAINT, OOAINT, OOAINT,
C          6       7       8       9       10
     *   OOAINT, OOAINT, OOAINT, OOAINT, OOAINT,
C          11      12     13      14
     *   OOAINT, OOACAR, OOARE, OOAINT/
C                   1     2     3     4     5
      DATA AVDIM /12,1,  6,1,  1,1,  1,1,  1,1,
C         6     7     8     9     10
     *   1,1,  1,1, 50,1,  1,1, 50,1,
C         11    12    13    14
     *   1,1, 16,30, 8,1, 10,1/
LOCAL END
      PROGRAM PDEDT
C-----------------------------------------------------------------------
C! Edit the PD table with a graphical editor
C# Task AP OOP UV EDITING TV-APPL CALIBRATION VLBI
C-----------------------------------------------------------------------
C;  Copyright (C) 2018, 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   TY table data used for uv editing
C-----------------------------------------------------------------------
      CHARACTER PRGM*6, UVDATA*32, TBEDIT*32, TBTYPE*2
      INTEGER  IRET, BUFF1(256)
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA PRGM /'PDEDT'/
C-----------------------------------------------------------------------
      TBTYPE = 'PD'
C                                       Startup
      CALL EDITIN (PRGM, UVDATA, TBEDIT, TBTYPE, IRET)
C                                       CLEAN
      IF (IRET.EQ.0) CALL EDITIT (UVDATA, TBEDIT, TBTYPE, IRET)
C                                       Close down files, etc.
      CALL DIE (IRET, BUFF1)
C
 999  STOP
      END
      SUBROUTINE EDITIN (PRGN, UVDATA, TBEDIT, TBTYPE, IERR)
C-----------------------------------------------------------------------
C   EDITIN gets input parameters for PDEDT, creates the EDIT object.
C   Inputs:
C      PRGN     C*6    Program name
C   Output:
C      UVDATA   C*32   Name of input uv data. - as master
C      TBEDIT   C*32   Name of table object to be used in editing
C      IERR     I      Error code: 0 => ok
C-----------------------------------------------------------------------
      INTEGER   IERR
      CHARACTER PRGN*6, UVDATA*(*), TBEDIT*(*), TBTYPE*2
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   NKEY1, NKEY2
C                                       NKEY1 = # adverbs FOR UVDATA
      PARAMETER (NKEY1=7)
C                                       NKEY2 = # adverbs for TBEDIT
      PARAMETER (NKEY2=10)
      INTEGER   DIM(7), TYPE, IDUM(2), BIF, EIF, NIF, SUBA, PDVERI,
     *   PDV, I, FGVERI, FGVERO, FGV
      CHARACTER INK1(NKEY1)*8, OUTK1(NKEY1)*32, INK2(NKEY2)*8,
     *   OUTK2(NKEY2)*32, CDUMMY*1, PDIN*32, TBINP*32, FGNAME(2)*32,
     *   FGIN*32
      LOGICAL   EXIST
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INPUT.INC'
      INCLUDE 'INPUTDATA.INC'
C                                       Adverbs to copy to UVDATA object
      DATA INK1 /'INNAME', 'INCLASS', 'INSEQ', 'INDISK', 'DOHIST',
     *   'CALSOUR', 'TIMERANG'/
C                                       Rename
      DATA OUTK1 /'NAME', 'CLASS', 'IMSEQ', 'DISK', 'DOHIST',
     *   'CALSOUR', 'TIMERANG'/
C                                       Adverbs for TBINP object
      DATA INK2 /'INNAME', 'INCLASS', 'INSEQ', 'INDISK', 'INVERS',
     *   'FREQID', 'SUBARRAY', 'ANTENNAS', 'ANTUSE', 'TIMERANG'/
C                                       Rename
      DATA OUTK2 /'NAME', 'CLASS', 'IMSEQ', 'DISK', 'VER',
     *   'FRQSEL', 'SUBARR', 'ANTENNAS', 'ANTS2USE', 'TIMERANG'/
      DATA FGNAME /'IN_FGVER', 'OUT_FGVER'/
C-----------------------------------------------------------------------
C                                       Startup interactive
      CALL AV2INT (PRGN, NPARMS, AVNAME, AVTYPE, AVDIM, 'Input', IERR)
      IF (IERR.NE.0) GO TO 999
      RQUICK = .FALSE.
C                                       SUBARRAY
      CALL OGET ('Input', 'SUBARRAY', TYPE, DIM, IDUM, CDUMMY, IERR)
      SUBA = IDUM(1)
      IF (IERR.NE.0) GO TO 999
      SUBA = MAX (1, SUBA)
      IDUM(1) = SUBA
      CALL OPUT ('Input', 'SUBARRAY', TYPE, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Create UV master object
      UVDATA = 'UVDATA master input object'
      CALL CREATE (UVDATA, 'UVDATA', IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Copy adverbs to object
      CALL IN2OBJ ('Input', NKEY1, INK1, OUTK1, UVDATA, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Open UVDATA to be sure it's OK
      CALL OOPEN (UVDATA, 'READ', IERR)
      IF (IERR.NE.0) GO TO 999
      CALL OCLOSE (UVDATA, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Find highest FG table.
      FGIN = 'Temporary FG table for EDITR'
      FGV = 1
      CALL UV2TAB (UVDATA, FGIN, 'FG', FGV, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL TBLHIV (FGIN, FGV, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL TABDES (FGIN, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Set FLAGVER
      CALL OGET ('Input', 'FLAGVER', TYPE, DIM, IDUM, CDUMMY, IERR)
      FGVERI = IDUM(1)
      IF (IERR.NE.0) GO TO 999
      FGVERI = MIN (FGVERI, FGV)
      IF (FGVERI.EQ.0) FGVERI = FGV
      FGVERO = FGV + 1
      IDUM(1) = FGVERI
      CALL OPUT (UVDATA, FGNAME(1), TYPE, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
      IDUM(1) = FGVERO
      CALL OPUT (UVDATA, FGNAME(2), TYPE, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Find highest PD table.
      PDIN = 'Temporary PD table for PDEDT'
      PDV = 1
      CALL UV2TAB (UVDATA, PDIN, 'PD', PDV, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL TBLHIV (PDIN, PDV, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL TABDES (PDIN, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL OGET ('Input', 'INVERS', TYPE, DIM, IDUM, CDUMMY, IERR)
      PDVERI = IDUM(1)
      IF (IERR.NE.0) GO TO 999
      IF ((PDVERI.LE.0) .OR. (PDVERI.GT.PDV)) PDVERI = PDV
      IDUM(1) = PDVERI
      CALL OPUT ('Input', 'INVERS', TYPE, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Create TBINP object
      TBINP = TBTYPE // ' temporary table to be used in copying'
      CALL CREATE (TBINP, 'TABLE', IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Copy adverbs to object
      CALL IN2OBJ ('Input', NKEY2, INK2, OUTK2, TBINP, IERR)
      IF (IERR.NE.0) GO TO 999
      DIM(1) = 2
      DIM(2) = 1
      CALL OPUT (TBINP, 'TBLTYPE', OOACAR, DIM, IDUM, TBTYPE, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Use input for editing
C                                       Open TBINP to be sure it's OK.
      CALL OOPEN (TBINP, 'READ', IERR)
      IF (IERR.NE.0) GO TO 999
      CALL OGET (TBINP, 'KEY.NO_IF', TYPE, DIM, IDUM, CDUMMY, IERR)
      NIF = IDUM(1)
      IF ((IERR.NE.0) .OR. (NIF.LE.0)) NIF = 1
      CALL OCLOSE (TBINP, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       BADDISK
      CALL OGET ('Input', 'BADDISK', TYPE, DIM, IBAD, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       IF numbers
C                                       Default BIF, EIF
      BIF = 1
      EIF = NIF
C                                       Save in Inputs for history
      DIM(1) = 1
      IDUM(1) = BIF
      CALL OPUT ('Input', 'BIF', OOAINT, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL OPUT (TBINP, 'BIF', OOAINT, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
      IDUM(1) = EIF
      CALL OPUT ('Input', 'EIF', OOAINT, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL OPUT (TBINP, 'EIF', OOAINT, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       copy to new PD table
      TBEDIT = 'PD table to be used in editing'
      CALL CREATE (TBEDIT, 'TABLE', IERR)
      IF (IERR.NE.0) GO TO 999
C                                       copy the object parts
      CALL TBCOPY (TBINP, TBEDIT, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       did not get adverbs
      CALL IN2OBJ ('Input', NKEY2, INK2, OUTK2, TBedit, IERR)
      IF (IERR.NE.0) GO TO 999
      DIM(1) = 2
      DIM(2) = 1
      CALL OPUT (TBINP, 'TBLTYPE', OOACAR, DIM, IDUM, TBTYPE, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       new version
      DIM(1) = 1
      DIM(2) = 1
      I = PDV + 1
      IDUM(1) = I
      CALL OPUT (TBEDIT, 'VER', OOAINT, DIM, IDUM, CDUMMY, IERR)
      IF (IERR.NE.0) GO TO 999
      WRITE (MSGTXT,1010) PDVERI, I
      CALL MSGWRT (3)
C                                       Make sure output doesn't exist
      CALL OBFEXS (TBEDIT, EXIST, IERR)
      IERR = 0
      IF (EXIST) THEN
         CALL TABRMV (TBEDIT, IERR)
         IF (IERR.NE.0) GO TO 999
         END IF
C                                       copy contents
      CALL TBLCOP (TBINP, TBEDIT, IERR)
      IF (IERR.NE.0) GO TO 999
C
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('Copying PD table version',I4,' to new version',I4)
      END
      SUBROUTINE EDITIT (UVDATA, TBEDIT, TBTYPE, IERR)
C-----------------------------------------------------------------------
C   Does the editing
C   Inputs:
C      UVDATA   C*32   Name of input uv data. - as master
C      TBEDIT   C*32   Name of PD table data
C      TBTYPE   C*2    Type of table
C   Output:
C      IERR    I    Error code: 0 => ok
C-----------------------------------------------------------------------
      INTEGER   IERR
      CHARACTER UVDATA*(*), TBEDIT*(*), TBTYPE*2
C
      CHARACTER UVEDIT*32, STATUS*4, TVDEVC*32
      INTEGER   JERR, DUMMY, DIM(7)
      INCLUDE 'INCS:PAOOF.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       open TV object
      TVDEVC = 'PDEDT task TV object'
      CALL TVDCRE (TVDEVC, IERR)
      IF (IERR.NE.0) GO TO 990
      CALL TVDOPN (TVDEVC, STATUS, IERR)
      IF (IERR.NE.0) GO TO 985
C                                       open edit object
      UVEDIT = 'PDEDT task EDIT object'
      CALL EDICRE (UVEDIT, IERR)
      IF (IERR.NE.0) GO TO 980
      CALL EDIOPN (UVEDIT, STATUS, IERR)
      IF (IERR.NE.0) GO TO 975
C                                       Insert object info
      DIM(1) = LEN(UVDATA)
      DIM(2) = 1
      CALL EDIPUT (UVEDIT, 'UVMASTER', OOACAR, DIM, DUMMY, UVDATA, IERR)
      IF (IERR.NE.0) GO TO 980
      DIM(1) = LEN(TBEDIT)
      CALL EDIPUT (UVEDIT, 'TBEDIT', OOACAR, DIM, DUMMY, TBEDIT, IERR)
      IF (IERR.NE.0) GO TO 980
      DIM(1) = LEN(TVDEVC)
      CALL EDIPUT (UVEDIT, 'TVDEVICE', OOACAR, DIM, DUMMY, TVDEVC, IERR)
      IF (IERR.NE.0) GO TO 980
      DIM(1) = 1
C                                       do it
      CALL EDITPD ('INIT', UVEDIT, TBTYPE, IERR)
C                                       Clean up - no apply
C                                       These zap TBEDIT
      IF (IERR.NE.0) THEN
         IF (IERR.LT.0) THEN
            CALL EDITPD ('ABOR', UVEDIT, TBTYPE, JERR)
            IERR = 0
         ELSE
            CALL EDITPD ('KILL', UVEDIT, TBTYPE, JERR)
            END IF
C                                       apply FG and clean up
      ELSE
         CALL EDITPD ('APPL', UVEDIT, TBTYPE, IERR)
         CALL TABCLO (TBEDIT, JERR)
         CALL TABDES (TBEDIT, JERR)
         END IF
C                                       Delete object
      CALL EDICLO (UVEDIT, JERR)
 975  CALL EDIDES (UVEDIT, JERR)
C                                       close and delete TV device
 980  CALL TVDCLO (TVDEVC, JERR)
 985  CALL TVDDES (TVDEVC, JERR)
C                                       error message
 990  IF (IERR.NE.0) THEN
         MSGTXT = 'ERROR EDITING ' // TBEDIT
         CALL MSGWRT (6)
         END IF
C
 999  RETURN
      END
