LOCAL INCLUDE 'VHCAL.INC'
C                                       Local include for VHCAL
      INCLUDE 'INCS:ZPBUFSZ.INC'
      HOLLERITH XNAME1(3), XCLAS1(2), XNAME2(3), XCLAS2(2), XNAME3(3),
     *   XCLAS3(2), XNAME4(3), XCLAS4(2), XSOUR(4,30), XNAMOU(3),
     *   XCLAOU(2)
      REAL      XSEQ1, XDISK1, XSEQ2, XDISK2, XSEQ3, XDISK3, XSEQ4,
     *   XDISK4, XDOCAL, XGUSE, XFLAG, XDOBND, XBPVER,
     *   XSOUT, XDISO, BADD(10), SCRBUF(256), BUFF1(UVBFSS),
     *   BUFF2(UVBFSS), BUFF3(UVBFSS), BUFF4(UVBFSS), BUFFRS(UVBFSS,4)
      INTEGER   SEQIN(4), SEQOUT, DISKIN(4), DISKO, CATOLD(256,4),
     *   INCSI, INCFI, INCIFI, INCSO, INCFO, INCIFO, LRECO, NRPRMI,
     *   NRPRMO, OLDCNO(4), NEWCNO, NRPRMM, LRECM, JBUFSZ, ILOCWT,
     *   MLOCT, MLOCB, MLOCA1, MLOCA2
      LOGICAL   ISCOMP
      CHARACTER NAMEIN(4)*12, CLASIN(4)*6, NAMOUT*12, CLAOUT*6
      EQUIVALENCE (BUFFRS(1,1), BUFF1),  (BUFFRS(1,2), BUFF2),
     (   (BUFFRS(1,3), BUFF3), (BUFFRS(1,4), BUFF4)
      COMMON /INPARM/ XNAME1, XCLAS1, XSEQ1, XDISK1, XNAME2, XCLAS2,
     *   XSEQ2, XDISK2, XNAME3, XCLAS3, XSEQ3, XDISK3, XNAME4, XCLAS4,
     *   XSEQ4, XDISK4, XSOUR, XDOCAL, XGUSE, XFLAG, XDOBND, XBPVER,
     *   XNAMOU, XCLAOU, XSOUT, XDISO, BADD
      COMMON /VHCALP/ CATOLD, SEQIN, SEQOUT, DISKIN, DISKO, ILOCWT,
     *   INCSI, INCFI, INCIFI, INCSO, INCFO, INCIFO, LRECO, NRPRMI,
     *   NRPRMO, ISCOMP, OLDCNO, NEWCNO, NRPRMM, LRECM, MLOCT, MLOCB,
     *   MLOCA1, MLOCA2
      COMMON /CHARPM/ NAMEIN, CLASIN, NAMOUT, CLAOUT
      COMMON /BUFRS/ SCRBUF, BUFFRS, JBUFSZ
C                                       End local include for VHCAL
LOCAL END
      PROGRAM VHCAL
C-----------------------------------------------------------------------
C! Divide by I/Q/U model for linear polarization
C# Utility UV UV-util VLA VLB Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   VHCAL allows a user to provide a subroutine which performs an
C   operation on a UV data base, writing an output UV data base.
C   IMPORTANT NOTE: to avoid confusion this task should be renamed.
C   To rename (max. 5 char) and install the new task :
C     1) copy the source code to a new file with the name newname.
C        then add desired code to subroutine DIDDLE.
C     2) using the source editor change all references to VHCAL to
C        newname.  It is especially important to change the string
C        entered into PRGM at or near line 61 to the new name.
C     3) copy inputs file for VHCAL to inputs file for newname.
C     4) compile and link edit with the APL and NOTST subroutine
C        libraries from AIPS.
C     5) copy and modify as appropriate the VHCAL HELP file.
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input VU data.
C   full set of calibration adverbs
C      OUTNAME        NAMOUT        Name of the output uv file.
C                                   Default output is input file.
C      OUTCLASS       CLAOUT        Class of the output uv file.
C      OUTSEQ         SEQOUT        Seq. number of output uv data.
C      OUTDISK        DISKO         Disk number of the output file.
C      APARM(10)      APARM         User specified array.
C      BPARM(10)      BPARM         User specified array.
C      BOX(4,10)      BOX           User specified array.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'VHCAL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      DATA PRGM /'VHCAL '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL VHCALI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Call routine that sends data
C                                       to the user routine.
      CALL VHCALD (IRET)
      IF (IRET.NE.0) GO TO 990
      CALL VHCALH
C                                       Close down files, etc.
 990  CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE VHCALI (PRGN, JERR)
C-----------------------------------------------------------------------
C   VHCALI gets input parameters for VHCAL and creates an output file
C   if necessary.
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      JERR    I    Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C   Output in common:
C      NRPRMI  I  Input number of random parameters.
C      INCSI   I  Input Stokes' increment in vis.
C      INCFI   I  Input frequency increment in vis.
C      INCIFI  I  Input IF increment in vis.
C      LRECO   I  Output file record length
C      NRPRMO  I  Output number of random parameters.
C      INCSO   I  Output Stokes' increment in vis.
C      INCFO   I  Output frequency increment in vis.
C      INCIFO  I  Output IF increment in vis.
C      ISCOMP  L  If true data is compressed
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C   See prologue comments in VHCAL for more details.
C
C   To change the adverb list sent to this task change:
C   1)  the inputs file.
C   2)  the contents of COMMON /INPARM/.  Remember all adverbs are sent
C       as R, INNAME etc. are 12 char. 3 words;
C       INCLASS etc. are 6 char., 2 words.
C       Values will be filled into COMMON /INPARM/ in the order
C       specified in the inputs file.
C   3)  If the first adverb is not INNAME (NAMEIN) then replace
C       NAMEIN in the call to GTPARM with the name of the first
C       adverb.
C   4)  Change the value of NPARM sent to GTPARM to the number of
C       R words desired.
C-----------------------------------------------------------------------
      INTEGER   JERR
      CHARACTER PRGN*6
C
      CHARACTER STAT*4, BLANK*6, PTYPE*2
      INTEGER   IROUND, NPARM, IERR, INCX, I, NFREQ, J, K, NOMAT
      REAL      CATR(256), RPARM(20)
      HOLLERITH CATH(256)
      DOUBLE PRECISION CATD(128)
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'VHCAL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      EQUIVALENCE (CATBLK, CATR, CATH, CATD)
      DATA BLANK  /' '/
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 170
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAME1, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, SCRBUF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAME1, NAMEIN(1))
      CALL H2CHR (6, 1, XCLAS1, CLASIN(1))
      SEQIN(1) = IROUND (XSEQ1)
      DISKIN(1) = IROUND (XDISK1)
      CALL H2CHR (12, 1, XNAME2, NAMEIN(2))
      CALL H2CHR (6, 1, XCLAS2, CLASIN(2))
      SEQIN(2) = IROUND (XSEQ2)
      DISKIN(2) = IROUND (XDISK2)
      CALL H2CHR (12, 1, XNAME3, NAMEIN(3))
      CALL H2CHR (6, 1, XCLAS3, CLASIN(3))
      SEQIN(2) = IROUND (XSEQ3)
      DISKIN(3) = IROUND (XDISK3)
      CALL H2CHR (12, 1, XNAME4, NAMEIN(4))
      CALL H2CHR (6, 1, XCLAS4, CLASIN(4))
      SEQIN(4) = IROUND (XSEQ4)
      DISKIN(4) = IROUND (XDISK4)
      DO 5 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 5       CONTINUE
      CALL H2CHR (16, 1, XSOUR(1,1), SOURCS(1))
      DO 6 I = 2,30
         SOURCS(I) = ' '
 6       CONTINUE
      CALL H2CHR (12, 1, XNAMOU, NAMOUT)
      CALL H2CHR (6, 1, XCLAOU, CLAOUT)
      SEQOUT = IROUND (XSOUT)
      DISKO = IROUND (XDISO)
C                                       Info for UVGET:
C                                       Put selection criteria into
C                                       correct common.
      UNAME = NAMEIN(1)
      UCLAS = CLASIN(1)
      UDISK = DISKIN(1)
      USEQ = SEQIN(1)
      DOCAL = XDOCAL.GT.0.0
      DOWTCL = DOCAL .AND. (XDOCAL.LE.99.0)
      FGVER = IROUND (XFLAG)
      DOBAND = IROUND (XDOBND)
      BPVER = IROUND (XBPVER)
      CLVER = IROUND (XGUSE)
      CLUSE = IROUND (XGUSE)
C                                       Get CATBLK from old file.
      DO 20 I = 1,4
         OLDCNO(I) = 1
         PTYPE = 'UV'
         CALL CATDIR ('SRCH', DISKIN(I), OLDCNO(I), NAMEIN(I),
     *      CLASIN(I), SEQIN(I), PTYPE, NLUSER, STAT, SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1030) IERR, NAMEIN(I), CLASIN(I), SEQIN(I),
     *         DISKIN(I), NLUSER
            GO TO 990
            END IF
         CALL CATIO ('READ', DISKIN(I), OLDCNO(I), CATBLK, 'REST',
     *      SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1040) IERR
            GO TO 990
            END IF
C                                       Save input CATBLK
         CALL COPY (256, CATBLK, CATOLD(1,I))
C                                       Compressed data?
         IF (I.EQ.1) ISCOMP = CATBLK(KINAX).EQ.1
         IF ((I.GT.1) .AND. (CATBLK(KINAX).EQ.1)) THEN
            IERR = 10
            MSGTXT = 'I DO NOT WORK ON COMPRESSED MODEL DATA'
            GO TO 990
            END IF
C                                       Get uv header info.
         CALL UVPGET (JERR)
         IF (JERR.NE.0) GO TO 999
         NRPRMM = NRPARM
         LRECM = LREC
         MLOCB = ILOCB
         MLOCT = ILOCT
         MLOCA1 = ILOCA1
         MLOCA2 = ILOCA2
         CALL CATDIR ('CSTA', DISKIN(I), OLDCNO(I), NAMEIN(I),
     *      CLASIN(I), SEQIN(I), PTYPE, NLUSER, 'READ', SCRBUF, IERR)
         NCFILE = NCFILE + 1
         FVOL(NCFILE) = DISKIN(I)
         FCNO(NCFILE) = OLDCNO(I)
         FRW(NCFILE) = 0
 20      CONTINUE
      NOMAT = 0
      J = CATOLD(KIDIM,1)
      DO 30 I = 2,4
         DO 25 K = 0,J-1
            IF ((CATOLD(KINAX+K,I).NE.CATOLD(KINAX+K,1)) .AND. (K.NE.1))
     *         NOMAT = NOMAT+1
 25         CONTINUE
 30      CONTINUE
      IF (NOMAT.GT.0) THEN
         MSGTXT = 'HEADERS DO NOT MATCH'
         JERR = 10
         GO TO 990
         END IF
C                                       Channel selection?
      BIF = 1
      EIF = CATOLD(KINAX+JLOCIF,1)
      NFREQ = CATOLD(KINAX+JLOCF,1)
      BCHAN = 1
      ECHAN = NFREQ
C                                       now using cal system -
C                                       UVGET makes header
      CALL UVGET ('INIT', RPARM, SCRBUF, JERR)
      IF (JERR.NE.0) THEN
         WRITE (MSGTXT,1035) JERR
         GO TO 990
         END IF
      CALL UVGET ('CLOS', RPARM, SCRBUF, IERR)
C                                       Save input file info
      INCX = CATBLK(KINAX)
      NRPRMI = NRPARM
      INCSI = INCS / INCX
      INCFI = INCF / INCX
      INCIFI = INCIF / INCX
C                                       Put new values in CATBLK.
      CALL MAKOUT (NAMEIN(1), CLASIN(1), SEQIN(1), BLANK, NAMOUT,
     *   CLAOUT, SEQOUT)
      CALL CHR2H (12, NAMOUT, KHIMNO, CATH(KHIMN))
      CALL CHR2H (6, CLAOUT, KHIMCO, CATH(KHIMC))
      CATBLK(KIIMS) = SEQOUT
C                                       read compressed => write compr.
      IF (ISCOMP) THEN
         CATBLK(KINAX) = 1
         I = CATBLK(KIPCN)
         CALL CHR2H (8, 'WEIGHT  ', 1, CATH(KHPTP+2*I))
         CALL CHR2H (8, 'SCALE   ', 1, CATH(KHPTP+2*I+2))
         CATBLK(KIPCN) = I + 2
         ILOCWT = I
         END IF
C                                       Create output file.
      CCNO = 1
      FRW(NCFILE+1) = 3
      JERR = 4
      CALL UVCREA (DISKO, CCNO, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         IF (IERR.NE.2) THEN
            WRITE (MSGTXT,1050) IERR
            GO TO 990
            END IF
C                                       Only overwrite Input file
C                                       no destroy existing otherwise
         IF ((CCNO.NE.OLDCNO(1)) .OR. (DISKO.NE.DISKIN(1))) THEN
            WRITE (MSGTXT,1060)
            GO TO 990
            END IF
C                                       Recover existing CATBLK
         FRW(NCFILE+1) = 2
         CALL CATIO ('READ', DISKO, CCNO, CATBLK, 'WRIT', SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1065) IERR
            CALL MSGWRT (6)
            END IF
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKO
      FCNO(NCFILE) = CCNO
      FRW(NCFILE) = FRW(NCFILE) - 1
      NEWCNO = CCNO
C                                       Save output file info
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
      INCX = CATBLK(KINAX)
      LRECO = LREC
      NRPRMO = NRPARM
      INCSO = INCS / INCX
      INCFO = INCF / INCX
      INCIFO = INCIF / INCX
      JERR = 0
      SEQOUT = CATBLK(KIIMS)
C                                       Copy any header keywords
      CALL KEYCOP (DISKIN(1), OLDCNO(1), DISKO, NEWCNO, IERR)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('VHCALI: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1035 FORMAT ('UVGET INIT ERROR',I3,' CHECK ADVERBS')
 1040 FORMAT ('ERROR',I3,' COPYING CATBLK ')
 1050 FORMAT ('ERROR',I3,' CREATING OUTPUT FILE')
 1060 FORMAT ('MAY OVERWRITE INPUT FILE ONLY.  QUITTING')
 1065 FORMAT ('VHCALI: ERROR',I3,' UPDATING NEW CATBLK')
      END
      SUBROUTINE VHCALD (IRET)
C-----------------------------------------------------------------------
C   VHCALD sends uv data one point at a time to the user supplied
C   routine and then writes the modified data if requested.
C   Input in common:
C      NRPRMI  I  Input number of random parameters.
C      INCSI   I  Input Stokes' increment in vis.
C      INCFI   I  Input frequency increment in vis.
C      INCIFI  I  Input IF increment in vis.
C      LRECO   I  Output file record length
C      NRPRMO  I  Output number of random parameters.
C      INCSO   I  Output Stokes' increment in vis.
C      INCFO   I  Output frequency increment in vis.
C      INCIFO  I  Output IF increment in vis.
C      ISCOMP  L  If true data is compressed
C   Output:
C      IRET    I  Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      CHARACTER OFILE*48
      INTEGER   IPTRO, LUNO, INDO, ILENBU, KBIND, NIOUT, NIOLIM, IA1,
     *   IA2, BO, VO, NUMVIS, XCOUNT, NCORO, NCOPY, CATMP(256), RNXRET,
     *   VISINC, VISMSG, LUNI(4), INDI(4), IBIND(4), JNIO, INIO(4),
     *   JA1(4), JA2(4), IPTRM, NERR, I, K
      LOGICAL   T, F
      INCLUDE 'VHCAL.INC'
      REAL      BASEN, VIS(UVBFSS), RESULT(UVBFSS), RPARM(20), TT(4),
     *   TEPS, DBG(392,3)
      EQUIVALENCE (DBG, BUFF2)
      DOUBLE PRECISION UVSCAL
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      DATA LUNO /17/, LUNI /0, 41, 42, 43/
      DATA VO, BO /0, 1/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
      TEPS = 0.5 / (24.0 * 3600.0)
      NERR = 0
C                                       Number of visibilities in input
C                                       and output files.
      NCORO = (LRECO - NRPRMO) / CATBLK(KINAX)
      NCOPY = LRECO - NRPRMO
      VISINC = CATBLK(KIGCN) / 10
      VISINC = MAX (20000, MIN (200000,VISINC))
      VISMSG = 3 * VISINC
C                                       defend cat header from UVGET
      CALL COPY (256, CATBLK, CATMP)
C                                       Open and init for read
      CALL UVGET ('INIT', RPARM, VIS, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET
         GO TO 990
         END IF
      CALL COPY (256, CATMP, CATBLK)
      CALL UVPGET (IRET)
C                                       Open 3 vis files for read
      DO 20 I = 2,4
         CALL ZPHFIL ('UV', DISKIN(I), OLDCNO(I), 1, OFILE, IRET)
         CALL ZOPEN (LUNI(I), INDI(I), DISKIN(I), OFILE, T, F, F, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1010) IRET
            GO TO 990
            END IF
C                                       Init vis file for write
         ILENBU = 0
         CALL UVINIT ('READ', LUNI(I), INDI(I), NVIS, VO, LRECM, ILENBU,
     *      JBUFSZ, BUFFRS(1,I), BO, IBIND(I), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1020) IRET
            GO TO 990
            END IF
         INIO(I) = 0
 20      CONTINUE
C                                       Open vis file for write
      CALL ZPHFIL ('UV', DISKO, CCNO, 1, OFILE, IRET)
      CALL ZOPEN (LUNO, INDO, DISKO, OFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1010) IRET
         GO TO 990
         END IF
C                                       Init vis file for write
      ILENBU = 0
      CALL UVINIT ('WRIT', LUNO, INDO, NVIS, VO, LRECO, ILENBU, JBUFSZ,
     *   BUFF1, BO, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1020) IRET
         GO TO 990
         END IF
      IPTRO = KBIND
      NIOUT = 0
      NIOLIM = ILENBU
      NUMVIS = 0
      XCOUNT = 0
      JNIO = 1000000
C                                       make an index table
      CALL RNXGET (DISKIN, OLDCNO, CATOLD)
      CALL RNXINI (DISKO, NEWCNO, CATBLK, RNXRET)
      IF ((FREQ.GT.0.0D0) .AND. (UVFREQ.GT.0.0D0)) THEN
         UVSCAL = FREQ / UVFREQ
      ELSE
         UVSCAL = 1.0D0
         END IF
C                                       Loop
C                                       Read vis. record.
 100  CALL UVGET ('READ', RPARM, VIS, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1100) IRET
         GO TO 990
C                                       Loop over buffer
      ELSE IF (IRET.EQ.0) THEN
C                                       Read the 3
         IF (JNIO.GT.INIO(2)) THEN
            DO 110 I = 2,4
               CALL UVDISK ('READ', LUNI(I), INDI(I), BUFFRS(1,I),
     *            INIO(I), IBIND(I), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1100) IRET
                  GO TO 990
                  END IF
               IPTRM = IBIND(I)
 110           CONTINUE
            JNIO = 1
            END IF
         DO 115 I = 2,4
            IF (MLOCB.GE.0) THEN
               BASEN = BUFFRS(IPTRM+MLOCB,I)
               JA1(I) = BASEN / 256. + 0.1
               JA2(I) = BASEN - IA1*256. + 0.1
            ELSE
               JA1(I) = BUFFRS(IPTRM+MLOCA1,I) + 0.1
               JA2(I) = BUFFRS(IPTRM+MLOCA2,I) + 0.1
               END IF
            TT(I) = BUFFRS(IPTRM+MLOCT,I)
 115        CONTINUE
         IF (ILOCB.GE.0) THEN
            BASEN = RPARM(1+ILOCB)
            IA1 = BASEN / 256. + 0.1
            IA2 = BASEN - IA1*256. + 0.1
         ELSE
            IA1 = RPARM(1+ILOCA1) + 0.1
            IA2 = RPARM(1+ILOCA2) + 0.1
            END IF
         TT(1) = RPARM(1+ILOCT)
C                                       are we aligned
         IF ((JA1(4).NE.JA1(2)) .OR. (JA1(3).NE.JA1(2)) .OR.
     *      (JA2(4).NE.JA2(2)) .OR. (JA2(3).NE.JA2(2)) .OR.
     *      (ABS(TT(4)-TT(2)).GT.TEPS) .OR. (ABS(TT(3)-TT(2)).GT.TEPS))
     *      THEN
            MSGTXT = 'MODELS ARE OUT OF SYNC'
            IRET = 10
            GO TO 990
            END IF
         IF ((IA1.NE.JA1(2)) .OR. (IA2.NE.JA2(2)) .OR.
     *      (ABS(TT(1)-TT(2)).GT.TEPS)) THEN
            NERR = NERR + 1
            MSGTXT = 'DATA OUT OF SYNC WITH MODELS'
            CALL MSGWRT (6)
            IF (NERR.LT.50) GO TO 100
            IRET = 10
            MSGTXT = 'TOO MANY SUCH ERRORS'
            GO TO 990
            END IF

         NUMVIS = NUMVIS + 1
         IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
            WRITE (MSGTXT,1105) NUMVIS
            CALL MSGWRT (2)
         ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
            WRITE (MSGTXT,1105) NUMVIS
            CALL MSGWRT (1)
            END IF
         RPARM(1+ILOCU) = RPARM(1+ILOCU) * UVSCAL
         RPARM(1+ILOCV) = RPARM(1+ILOCV) * UVSCAL
         RPARM(1+ILOCW) = RPARM(1+ILOCW) * UVSCAL
C                                       call user routine
         K = IPTRM + NRPRMM
         CALL VHCALC (NUMVIS, TT(1), IA1, IA2, VIS, BUFFRS(K,2),
     *      BUFFRS(K,3), BUFFRS(K,4), RESULT, IRET)
         JNIO = JNIO + 1
         IPTRM = IPTRM + LRECM
C                                       Error (fatal)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1120) IRET
            GO TO 990
C                                       Copy to output.
         ELSE IF (IRET.EQ.0) THEN
            XCOUNT = XCOUNT + 1.0D0
            CALL RCOPY (NRPRMI, RPARM, BUFF1(IPTRO))
C                                       update NX table
            CALL RNXUPD (RPARM, RNXRET)
C                                       Compressed
            IF (ISCOMP) THEN
               CALL ZUVPAK (NCORO, RESULT, BUFF1(IPTRO+ILOCWT),
     *            BUFF1(IPTRO+NRPRMO))
            ELSE
               CALL RCOPY (NCOPY, RESULT, BUFF1(IPTRO+NRPRMO))
               END IF
            IPTRO = IPTRO + LRECO
            NIOUT = NIOUT + 1
            END IF
C                                       Write vis record.
         IF (NIOUT.GE.NIOLIM) THEN
            CALL UVDISK ('WRIT', LUNO, INDO, BUFF1, NIOLIM, KBIND, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1150) IRET
               GO TO 990
               END IF
            IPTRO = KBIND
            NIOUT = 0
            END IF
C                                       Read next buffer.
         GO TO 100
         END IF
C                                       Finish write
      NIOUT = - NIOUT
      CALL UVDISK ('FLSH', LUNO, INDO, BUFF1, NIOUT, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1150) IRET
         GO TO 990
         END IF
C                                       Compress output file.
      NVIS = XCOUNT
      CALL UCMPRS (NVIS, DISKO, CCNO, LUNO, CATBLK, IRET)
C                                       Close files
      CALL UVGET ('CLOS', RPARM, VIS, IRET)
      CALL ZCLOSE (LUNO, INDO, IRET)
      CALL ZCLOSE (LUNI(2), INDI(2), IRET)
      CALL ZCLOSE (LUNI(3), INDI(3), IRET)
      CALL ZCLOSE (LUNI(4), INDI(4), IRET)
C                                       close NX table
      IRET = 0
      CALL RNXCLS (RNXRET)
      IF (RNXRET.NE.0) THEN
         MSGTXT = 'OUTPUT NX TABLE, IF ANY, IS INCOMPLETE'
         GO TO 990
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('VHCALD: ERROR',I3,' OPEN/INIT INPUT VIS FILE')
 1105 FORMAT ('VHCALD: at visibility record',I10)
 1010 FORMAT ('VHCALD: ERROR',I3,' OPEN-FOR-WRITE VIS FILE')
 1020 FORMAT ('VHCALD: ERROR',I3,' INIT-FOR-WRITE VIS FILE')
 1100 FORMAT ('VHCALD: ERROR',I3,' READING VIS FILE')
 1120 FORMAT ('VHCALD: DIDDLE ERROR',I3)
 1150 FORMAT ('VHCALD: ERROR',I3,' WRITING VIS FILE')
      END
      SUBROUTINE VHCALH
C-----------------------------------------------------------------------
C   VHCALH copies and updates history file.  It also copies any tables.
C-----------------------------------------------------------------------
      INTEGER   LUN1, LUN2, IERR
      INCLUDE 'VHCAL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUN1, LUN2 /27,28/
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       Copy/open history file.
      CALL HISCOP (LUN1, LUN2, DISKIN, DISKO, OLDCNO, NEWCNO, CATBLK,
     *   SCRBUF, BUFF2, IERR)
      IF (IERR.GT.2) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 100
         END IF
C                                       New history
      CALL HENCO1 (TSKNAM, NAMEIN(1), CLASIN(1), SEQIN(1), DISKIN(1),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO2 (TSKNAM, NAMEIN(2), CLASIN(2), SEQIN(2), DISKIN(2),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO3 (TSKNAM, NAMEIN(3), CLASIN(3), SEQIN(3), DISKIN(3),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO4 (TSKNAM, NAMEIN(4), CLASIN(4), SEQIN(4), DISKIN(4),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCOO (TSKNAM, NAMOUT, CLAOUT, SEQOUT, DISKO, LUN2, BUFF2,
     *   IERR)
      IF (IERR.NE.0) GO TO 100
C                                       calibration history
      CALL CALHIS (LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
C                                       Close HI file
 100  CALL HICLOS (LUN2, .TRUE., BUFF2, IERR)
C                                       Copy tables
      CALL COPTAB (DISKIN, OLDCNO, DISKO, NEWCNO, IERR)
      IF (IERR.GT.2) THEN
         MSGTXT = 'VHCALH: ERROR COPYING TABLES TO OUTPUT UV'
         CALL MSGWRT (6)
         END IF
C                                       Update CATBLK.
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, 'REST', SCRBUF, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('VHCALH: ERROR',I3,' COPY/OPEN HISTORY FILE')
      END
      SUBROUTINE VHCALC (NUMVIS, T, IA1, IA2, VIS, MODI, MODQ, MODU,
     *   RESULT, IRET)
C-----------------------------------------------------------------------
C   Computes moel value for V and H and divides that into the V and H
C   data
C   Inputs:
C      NUMVIS  I    Visibility number, -1 => final call, no data
C                   passed but allows any operations to be completed.
C      T       R    Time in days
C      IA1     I    First antenna number
C      IA2     I    Second antenna number
C      RPARM   R(*) Random parameter array which includes U,V,W etc
C                   but also any other random parameters.
C      VIS     R(3,*)  Visibilities in order real, imaginary, weight
C                   (Jy, Jy, unitless).  Weight <= 0 => flagged.
C      MODI    R(3,*)
C      MODI    R(3,*)
C      MODI    R(3,*)
C   Inputs from COMMON:
C      NRPARM     I       # random parameters.
C      NCOR       I       # correlators
C      CATBLK     I(256)  Catalog header record. See Going Aips for
C                         details.
C      NRPRMI     I    Input number of random parameters.
C      INCSI      I    Input Stokes' increment in vis.
C      INCFI      I    Input frequency increment in vis.
C      INCIFI     I    Input IF increment in vis.
C      LRECO      I    Output file record length
C      NRPRMO     I    Output number of random parameters.
C      INCSO      I    Output Stokes' increment in vis.
C      INCFO      I    Output frequency increment in vis.
C      INCIFO     I    Output IF increment in vis.
C   Output:
C      RESULT     R(3,*) Output visibilities selected in frequency.
C      IRET       I    Return code  -1 => don't write
C                                    0 => OK
C                                   >0 => error, terminate.
C-----------------------------------------------------------------------
      INTEGER   NUMVIS, IA1, IA2, IRET
      REAL      T, VIS(3,*), MODI(3,*), MODQ(3,*), MODU(3,*),
     *   RESULT(3,*)
C
      INTEGER   JIF, JF, JS, NIF, NF, NS, INDEXO, INDEXI, IP
      REAL      PSIN, PCOS, LTIME, TEPS, VR, VI, HR, HI, DR, DI, WT, WTM
      INCLUDE 'VHCAL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DPDC.INC'
      SAVE LTIME
      DATA LTIME /-100./
C-----------------------------------------------------------------------
      IRET = 0
      IF (NUMVIS.GT.0) THEN
         TEPS = 0.95 / (24.0 * 3600.0)
C                                       Parallactic angle
         IF (ABS(T-LTIME).GT.TEPS) THEN
            CALL PARANG (T, PANGLE)
            LTIME = T
            END IF
C                                       pointers to traverse the data
         NS = 1
         NIF = 1
         NF = 1
         IF (JLOCS.GE.0) NS = CATBLK(KINAX+JLOCS)
         IF (JLOCIF.GE.0) NIF = CATBLK(KINAX+JLOCIF)
         IF (JLOCF.GE.0) NF = CATBLK(KINAX+JLOCF)
         IP = 0
         PCOS = COS (PANGLE(IA1) + PANGLE(IA2))
         PSIN = SIN (PANGLE(IA1) + PANGLE(IA2))
         DO 40 JIF = 1,NIF
            DO 30 JF = 1,NF
               IP = IP + 1
               VR = MODI(1,IP) + MODQ(1,IP)*PCOS + MODU(1,IP)*PSIN
               VI = MODI(2,IP) + MODQ(2,IP)*PCOS + MODU(2,IP)*PSIN
               HR = MODI(1,IP) - MODQ(1,IP)*PCOS - MODU(1,IP)*PSIN
               HI = MODI(2,IP) - MODQ(2,IP)*PCOS - MODU(2,IP)*PSIN
               WTM = MIN (MODI(3,IP), MODQ(3,IP))
               WTM = MIN (WTM, MODU(3,IP))
               DO 20 JS = 1,NS
                  INDEXI = (JIF-1) * INCIFI + (JF-1) * INCFI +
     *               (JS-1) * INCSI + 1
                  INDEXO = (JIF-1) * INCIFO + (JF-1) * INCFO +
     *               (JS-1) * INCSO + 1
                  RESULT(1,INDEXO) = VIS(1,INDEXI)
                  RESULT(2,INDEXO) = VIS(2,INDEXI)
                  RESULT(3,INDEXO) = VIS(3,INDEXI)
                  WT = MIN (WTM, RESULT(3,INDEXO))
                  IF (WT.GT.0) THEN
                     DR = RESULT(1,INDEXO)
                     DI = RESULT(2,INDEXO)
                     IF (JS.EQ.1) THEN
                        RESULT(1,INDEXO) = (DR*VR+DI*VI) / (VR*VR+VI*VI)
                        RESULT(2,INDEXO) = (DI*VR-DR*VI) / (VR*VR+VI*VI)
                     ELSE IF (JS.EQ.2) THEN
                        RESULT(1,INDEXO) = (DR*HR+DI*HI) / (HR*HR+HI*HI)
                        RESULT(2,INDEXO) = (DI*HR-DR*HI) / (HR*HR+HI*HI)
                        END IF
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
         END IF
C
 999  RETURN
      END
