LOCAL INCLUDE 'HOLIS.INC'
      INCLUDE 'INCS:ZPBUFSZ.INC'
      CHARACTER NAMEIN*12, CLAIN*6
      HOLLERITH XNAMEI(3), XCLAIN(2), XSOUR(4)
      REAL      XSIN, XDISIN, XFLAG, XANT(50), XBASE(50), OTFMOD,
     *   XBADD(10)
      REAL      BUFF(UVBFSS)
      INTEGER   SEQIN, DISKIN, LUNI, INDI, JBUFSZ, CNOIN, SCRBUF(512),
     *   NSAMP, NPARM
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XSOUR, XFLAG, XANT,
     *   XBASE, OTFMOD, XBADD
      COMMON /CHPARM/ NAMEIN, CLAIN
      COMMON /BUFRS/ BUFF, SCRBUF, JBUFSZ
      COMMON /UVPCOM/ SEQIN, DISKIN, LUNI, INDI, CNOIN, NPARM, NSAMP
LOCAL END
LOCAL INCLUDE 'SAMBUF.INC'
      INTEGER   MSAMP
      PARAMETER (MSAMP=1000000)
      REAL      RPTIME(MSAMP), RPUV(3,MSAMP)
      COMMON /SAMBUF/ RPTIME, RPUV
LOCAL END
      PROGRAM HOLIS
C-----------------------------------------------------------------------
C! HOLIS prints holography sample distribution data
C# Printer appl UV-util VLA VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   HOLIS prints uv data with calibration.
C   Inputs:
C      INNAME         NAMEIN        File name to be imaged
C      INCLASS        CLAIN         File class to be imaged
C      INSEQ          SEQIN         File sequence number
C      INDISK         DISKIN        Disk volume on which file resides
C      SRCNAME        XSOUR(4)      Source selected
C      ANTENNAS       XANT(50)      Antenna numbers
C      BASELINE       XBASE(50)     Antenna numbers to pair up
C      BADDISK        XBADD(10)     Disks to avoid for scratch
C-----------------------------------------------------------------------
      CHARACTER  PRGM*6
      INTEGER  IRET
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'HOLIS.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      DATA PRGM /'HOLIS '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL HOLISI (PRGM, IRET)
      IF (IRET.EQ.0) THEN
         IF (OTFMOD.GT.0.0) THEN
            CALL HOLISO
         ELSE IF (OTFMOD.EQ.0.0) THEN
            CALL HOLISP
         ELSE
            CALL HOLISS
            END IF
         END IF
C                                       Close down
      CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE HOLISI (PRGM, IRET)
C-----------------------------------------------------------------------
C   HOLISI gets input parameters for HOLIS.
C   Inputs:
C      PRGM   C*6   Program name
C    Output:
C      IRET   I      Error code: 0 => ok, else quit
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
C
      CHARACTER UTYPE*2, STAT*4
      INTEGER   IUSER, I, IERR, IROUND, LUNTB, J
      LOGICAL   T, F
      REAL      CATR(256)
      DOUBLE PRECISION CATD(128)
      HOLLERITH CATH(256)
      INCLUDE 'HOLIS.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DANT.INC'
      INCLUDE 'INCS:DSOU.INC'
      EQUIVALENCE (CATBLK, CATR, CATD, CATH)
      DATA T, F /.TRUE., .FALSE./
      DATA LUNTB /39/
C-----------------------------------------------------------------------
C                                       Init IO et al.
      TSKNAM = PRGM
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
C                                       Get input parameters.
      NPARM = 123
      CALL GTPARM (PRGM, NPARM, RQUICK, XNAMEI, SCRBUF, IRET)
      IF (IRET.NE.0) THEN
         RQUICK = .TRUE.
         IF (IRET.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IRET
         CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
C      IF ((IRET.NE.0) .OR. (NPOPS.GT.NINTRN) .OR. (ISBTCH.EQ.32000))
C     *   DOCRT = MIN (-1.0, DOCRT)
      IF (RQUICK) CALL RELPOP (IRET, SCRBUF, IERR)
      IF (IRET.NE.0) GO TO 999
      IRET = 5
C                                       Hollerith -> Char
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (16, 1, XSOUR, SOURCS(1))
      IF (SOURCS(1).EQ.' ') SOURCS(1) = 'HOLORASTER'
C                                       Crunch input parameters.
      IUSER = NLUSER
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
C                                       Get CATBLK from file.
      LUNI = 48
      UTYPE = 'UV'
      STAT = 'INIT'
      CALL MAPOPN (STAT, DISKIN, NAMEIN, CLAIN, SEQIN, UTYPE, IUSER,
     *   LUNI, INDI, CNOIN, CATBLK, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1010) IERR
         GO TO 990
         END IF
      CALL CHR2H (12, NAMEIN, 1, XNAMEI)
      CALL CHR2H (6, CLAIN, 1, XCLAIN)
      XDISIN = DISKIN
      XSIN = SEQIN
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = CNOIN
      FRW(NCFILE) = 0
C                                       Get uv header info.
      CALL UVPGET (IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Info for UVGET:
C                                       Put selection criteria into
C                                       correct common.
      UNAME = NAMEIN
      UCLAS = CLAIN
      UDISK = DISKIN
      USEQ = SEQIN
      DO 40 I = 1,10
         IBAD(I) = IROUND (XBADD(I))
 40      CONTINUE
      FGVER = IROUND (XFLAG)
C                                       Clear antenna selection
C                                       criteria for UVGET
      CALL FILL (50, 0, ANTENS)
      I = XANT(1) + 0.1
      J = XBASE(1) + 0.1
      IF (I.LT.J) THEN
         ANTENS(1) = I
         ANTENS(2) = J
      ELSE
         ANTENS(1) = J
         ANTENS(2) = I
         END IF
      IF ((I.LE.0) .OR. (J.LE.0)) THEN
         IRET = 1
         MSGTXT = 'HOLOGRAPHY REQUIRES ANTEN(1) AND BASELI(1), NO DESEL'
         GO TO 990
         END IF
C                                       read in the data
      CALL HOLISR (IRET)
      GO TO 999
C                                       Error
 990  CALL MSGWRT (6)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UVPIN: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1010 FORMAT ('ERROR',I3,' FINDING THE UV DATA SET')
      END
      SUBROUTINE HOLISR (IRET)
C-----------------------------------------------------------------------
C   reads in the data
C   Output
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'HOLIS.INC'
      INCLUDE 'SAMBUF.INC'
      INTEGER   IA1, IA2
      REAL      RPARM(20)
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
C-----------------------------------------------------------------------
      NSAMP = 0
      CALL UVGET ('INIT', RPARM, BUFF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING INPUT UV DATA SET'
         GO TO 990
         END IF
C                                       read loop
 20   CALL UVGET ('READ', RPARM, BUFF, IRET)
      IF (IRET.LT.0) THEN
         IRET = 0
         GO TO 900
      ELSE IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING INPUT UV DATA SET'
         GO TO 990
      ELSE
         IF (ILOCB.GE.0) THEN
            IA1 = INT (RPARM(ILOCB+1)) / 256
            IA2 = MOD (INT (RPARM(ILOCB+1)), 256)
         ELSE
            IA1 = RPARM(1+ILOCA1) + 0.1
            IA2 = RPARM(1+ILOCA2) + 0.1
            END IF
         IF ((IA1.EQ.ANTENS(1)) .AND. (IA2.EQ.ANTENS(2))) THEN
            NSAMP = NSAMP + 1
            RPTIME(NSAMP) = RPARM(1+ILOCT)
            RPUV(1,NSAMP) = RPARM(1+ILOCU) * 1000.0
            RPUV(2,NSAMP) = RPARM(1+ILOCV) * 1000.0
            RPUV(3,NSAMP) = RPARM(1+ILOCW)
            IF (NSAMP.GE.MSAMP) THEN
               MSGTXT = 'INPUT BUFFER FULL!!!'
               CALL MSGWRT (8)
               GO TO 900
               END IF
            IF (MOD(NSAMP-1,2000).EQ.0) THEN
               WRITE (MSGTXT,1020) NSAMP
               CALL MSGWRT (2)
               END IF
            END IF
         GO TO 20
         END IF
C                                       EOF
 900  WRITE (MSGTXT,1900) NSAMP, ANTENS(1), ANTENS(2)
      CALL MSGWRT (3)
C                                       close
      CALL UVGET ('CLOS', RPARM, BUFF, IRET)
      IRET = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('HOLISR: ERRIR',I4,' ON ',A)
 1020 FORMAT ('HOLISR: at sample',I8)
 1900 FORMAT ('HOLISR read',I10,' visibilities on baseline',I3,' -',I3)
      END
      SUBROUTINE T2DHMS (TIMEIN, NDIG, TIME, RTIME)
C-----------------------------------------------------------------------
C   Convert from Time to Days Hours Minutes Seconds format
C   Input:
C      TIMEIN   R       Input:  Time
C      NDIG     I       Number digits in seconds display
C   Output:
C      TIME     I*(3)   Output Time in Days Hours Minutes
C      RTIME    R       SECONDS
C-----------------------------------------------------------------------
      REAL     TIMEIN, RTIME
      INTEGER  NDIG, TIME(3)
C
      REAL     T
      INTEGER  I, J
C-----------------------------------------------------------------------
      T = TIMEIN
      IF (TIMEIN.LT.0.0) T = -T
C
      TIME(1) = T
      T = (T - TIME(1)) * 24.0
      TIME(2) = T
      T = (T - TIME(2)) * 60.0
      TIME(3) = T
      T = (T - TIME(3)) * 60.0
      RTIME   = T
      J = 10 ** NDIG
      J = MAX (1, J)
      I = J*T + 0.5
C                                       Now Remove 60 seconds
      IF (I.GE.J*60) THEN
         RTIME = RTIME - 60.0
         TIME(3) = TIME(3) + 1
         END IF
C                                       Now Remove 60 minutes
      IF (TIME(3).GE.60) THEN
         TIME(3) = TIME(3) - 60
         TIME(2) = TIME(2) + 1
         END IF
C                                       Now Remove 24 hours
      IF (TIME(2).GE.24) THEN
         TIME(2) = TIME(2) - 24
         TIME(1) = TIME(1) + 1
         END IF
C                                       Sign
      IF (TIMEIN.LT.0.0) TIME(1) = -TIME(1)
C
 999  RETURN
      END
      SUBROUTINE HOLISO
C-----------------------------------------------------------------------
C   HOLISO prints the arrangement of OTF data
C-----------------------------------------------------------------------
C
      INTEGER   I, I1, I2, ITIM(3), IG, NP, NN, J
      REAL      DU, DV, TIMS
      INCLUDE 'HOLIS.INC'
      INCLUDE 'SAMBUF.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      I2 = 0
      IG = 0
      MSGTXT = '*****   On-the-fly holography data   *****'
      CALL MSGWRT (3)
      WRITE (MSGTXT,1000)
      CALL MSGWRT (3)
C                                       loop point
 20   I1 = I2 + 1
      IF (I1.LE.NSAMP) THEN
         NP = 0
         NN = 0
         DU = ABS (RPUV(1,I1)-RPUV(1,I1+1))
         DV = ABS (RPUV(2,I1)-RPUV(2,I1+1))
         IF (DU.LT.0.1*DV) THEN
            DO 30 I = I1+1,NSAMP
               IF (ABS(RPUV(1,I)-RPUV(1,I1)).GT.0.001) GO TO 40
               IF (RPUV(2,I)-RPUV(2,I-1).LT.0.0) THEN
                  NN = NN + 1
               ELSE
                  NP = NP + 1
                  END IF
 30            CONTINUE
 40         I2 = I - 1
            IG = IG + 1
            J = MIN (NN, NP)
            IF (J.EQ.NN) J = -J
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) IG, I1, ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1), I2-I1+1, J
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPTIME(I2), 2, ITIM, TIMS)
            WRITE (MSGTXT,1041) I2, ITIM, TIMS, RPUV(2,I2)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
         ELSE IF (DV.LT.0.1*DU) THEN
            DO 50 I = I1+1,NSAMP
               IF (ABS(RPUV(2,I)-RPUV(2,I1)).GT.0.001) GO TO 60
               IF (RPUV(1,I)-RPUV(1,I-1).LT.0.0) THEN
                  NN = NN + 1
               ELSE
                  NP = NP + 1
                  END IF
 50            CONTINUE
 60         I2 = I - 1
            IG = IG + 1
            J = MIN (NN, NP)
            IF (J.EQ.NN) J = -J
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) IG, I1, ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1), I2-I1+1, J
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPTIME(I2), 2, ITIM, TIMS)
            WRITE (MSGTXT,1042) I2, ITIM, TIMS, RPUV(1,I2)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
         ELSE
            I2 = I1
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1, ITIM, TIMS, RPUV(1,I1), RPUV(2,I1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (6)
            CALL T2DHMS (RPTIME(I1+1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1042) I1+1, ITIM, TIMS, RPUV(1,I1+1),
     *         RPUV(2,I1+1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (6)
            END IF
         GO TO 20
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Group   vis #       time           L        M   Nsamp',
     *   ' Backwards')
 1040 FORMAT (I5,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2,I6,I10)
 1041 FORMAT (5X,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,9X,F9.2)
 1042 FORMAT (5X,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2,I6)
 1100 FORMAT ('EQUAL',I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2)
      END
      SUBROUTINE HOLISP
C-----------------------------------------------------------------------
C   HOLISP prints the arrangement of pointed holography data
C-----------------------------------------------------------------------
C
      INTEGER   I, I1, I2, ITIM(3), IG, NP
      REAL      DU, DV, TIMS
      INCLUDE 'HOLIS.INC'
      INCLUDE 'SAMBUF.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      I2 = 0
      IG = 0
      MSGTXT = '*****   Pointed holography data   *****'
      CALL MSGWRT (3)
      WRITE (MSGTXT,1000)
      CALL MSGWRT(3)
C                                       loop point
 20   I1 = I2 + 1
      IF (I1.LE.NSAMP) THEN
         DU = ABS (RPUV(1,I1)-RPUV(1,I1+1))
         DV = ABS (RPUV(2,I1)-RPUV(2,I1+1))
         IF ((DU.LT.0.001) .AND. (DV.LT.0.001)) THEN
            NP = 1
            DO 30 I = I1+1,NSAMP
               DU = ABS (RPUV(1,I)-RPUV(1,I1+1))
               DV = ABS (RPUV(2,I)-RPUV(2,I1+1))
               IF ((DU.GE.0.001) .OR. (DV.GE.0.001)) GO TO 40
               NP = NP + 1
 30            CONTINUE
 40         I2 = I - 1
            IG = IG + 1
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) IG, I1, ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1), I2-I1+1
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPTIME(I2), 2, ITIM, TIMS)
            WRITE (MSGTXT,1041) I2, ITIM, TIMS
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
         ELSE
            I2 = I1
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1, ITIM, TIMS, RPUV(1,I1), RPUV(2,I1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPTIME(I1+1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1+1, ITIM, TIMS, RPUV(1,I1+1),
     *         RPUV(2,I1+1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            END IF
         GO TO 20
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Group   vis #       time           L        M   Nsamp')
 1040 FORMAT (I5,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2,I6)
 1041 FORMAT (5X,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2)
 1100 FORMAT ('ORDER',I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,2F9.2)
      END
      SUBROUTINE HOLISS
C-----------------------------------------------------------------------
C   HOLISS prints a summary of the arrangement of pointed holography data
C-----------------------------------------------------------------------
C
      INTEGER   I, I1, I2, ITIM(3), IG, NP, IV(2,10000), J, NN
      REAL      DU, DV, TIMS, RPSTOP(10000)
      INCLUDE 'HOLIS.INC'
      INCLUDE 'SAMBUF.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      I2 = 0
      IG = 0
      MSGTXT = '*****   Pointed holography data summary  *****'
      CALL MSGWRT (3)
      WRITE (MSGTXT,1000)
      CALL MSGWRT(3)
C                                       loop point
 20   I1 = I2 + 1
      IF (I1.LE.NSAMP) THEN
         DU = ABS (RPUV(1,I1)-RPUV(1,I1+1))
         DV = ABS (RPUV(2,I1)-RPUV(2,I1+1))
         IF ((DU.LT.0.001) .AND. (DV.LT.0.001)) THEN
            NP = 1
            DO 30 I = I1+1,NSAMP
               DU = ABS (RPUV(1,I)-RPUV(1,I1+1))
               DV = ABS (RPUV(2,I)-RPUV(2,I1+1))
               IF ((DU.GE.0.001) .OR. (DV.GE.0.001)) GO TO 40
               NP = NP + 1
 30            CONTINUE
 40         I2 = I - 1
            IG = IG + 1
            RPTIME(IG) = RPTIME(I1)
            RPSTOP(IG) = RPTIME(I2)
            RPUV(1,IG) = RPUV(1,I1)
            RPUV(2,IG) = RPUV(2,I1)
            IV(1,IG) = I1
            IV(2,IG) = I2
         ELSE
            I2 = I1
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1, ITIM, TIMS, RPUV(1,I1), RPUV(2,I1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPTIME(I1+1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1+1, ITIM, TIMS, RPUV(1,I1+1),
     *         RPUV(2,I1+1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            END IF
         GO TO 20
         END IF
C                                       loop point
      NSAMP = IG
      I2 = 0
 120  I1 = I2 + 1
      IF (I1.LE.NSAMP) THEN
         NP = 0
         NN = 0
         DU = ABS (RPUV(1,I1)-RPUV(1,I1+1))
         DV = ABS (RPUV(2,I1)-RPUV(2,I1+1))
         IF (DU.LT.0.1*DV) THEN
            DO 130 I = I1+1,NSAMP
               IF (ABS(RPUV(1,I)-RPUV(1,I1)).GT.0.001) GO TO 140
               IF (RPUV(2,I)-RPUV(2,I-1).LT.0.0) THEN
                  NN = NN + 1
               ELSE
                  NP = NP + 1
                  END IF
 130           CONTINUE
 140        I2 = I - 1
            J = MIN (NN, NP)
            IF (J.EQ.NN) J = -J
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) I1, IV(1,I1), ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1), IV(2,I2)-IV(1,I1)+1, J
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPSTOP(I2), 2, ITIM, TIMS)
            WRITE (MSGTXT,1041) I2, IV(2,I2), ITIM, TIMS, RPUV(2,I2)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
         ELSE IF (DV.LT.0.1*DU) THEN
            DO 150 I = I1+1,NSAMP
               IF (ABS(RPUV(2,I)-RPUV(2,I1)).GT.0.001) GO TO 160
               IF (RPUV(1,I)-RPUV(1,I-1).LT.0.0) THEN
                  NN = NN + 1
               ELSE
                  NP = NP + 1
                  END IF
 150           CONTINUE
 160        I2 = I - 1
            J = MIN (NN, NP)
            IF (J.EQ.NN) J = -J
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) I1, IV(1,I1), ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1), IV(2,I2)-IV(1,I1)+1, J
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
            CALL T2DHMS (RPSTOP(I2), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) I2, IV(2,I2), ITIM, TIMS, RPUV(1,I2)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (3)
         ELSE
            I2 = I1
            CALL T2DHMS (RPTIME(I1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1100) I1, IV(1,I1), ITIM, TIMS, RPUV(1,I1),
     *         RPUV(2,I1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (6)
            CALL T2DHMS (RPTIME(I1+1), 2, ITIM, TIMS)
            WRITE (MSGTXT,1040) I1+1, IV(1,I1+1), ITIM, TIMS,
     *         RPUV(1,I1+1),  RPUV(2,I1+1)
            IF (MSGTXT(25:25).EQ.' ') MSGTXT(25:25) = '0'
            CALL MSGWRT (6)
            END IF
         GO TO 120
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Group   vis #       time           L        M   Nsamp',
     *   ' Backwards')
 1040 FORMAT (I5,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2,I6,I10)
 1041 FORMAT (I5,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,9X,F9.2)
 1100 FORMAT ('EQUAL',I5,I8,I4.1,'/',I2.2,':',I2.2,':',F5.2,F9.2,F9.2)
      END
