LOCAL INCLUDE 'BPFLG.INC'
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:DBPC.INC'
      REAL      XSEQ, XDISK, XVER, FGVIN, FGVOUT,  XTIME(8), XBIF, XEIF,
     *   XBCHAN, XECHAN, XANT(50), APARM(10), BADD(10)
      HOLLERITH XINNAM(3), XINCLS(2)
      CHARACTER INNAM*12, INCLS*6
      COMMON /INPARM/ XINNAM, XINCLS, XSEQ, XDISK, XVER, FGVIN, FGVOUT,
     *   XTIME, XBIF, XEIF, XBCHAN, XECHAN, XANT, APARM, BADD
      COMMON /CHPARM/ INNAM, INCLS
      INTEGER   INSEQ, INDISK, BPVER, CNO, INFG, OUTFG, BIF, EIF,
     *   ANTS(50), NANT, NFLAGS, BCHAN, ECHAN
      DOUBLE PRECISION TIME, TIMBEG, TIMEND
      REAL      BNDPAS(2,MAXCIF)
      LOGICAL   DOCOPY
      COMMON /BPFLGC/ TIME, TIMBEG, TIMEND, INSEQ, INDISK, BPVER, CNO,
     *   BNDPAS, BIF, EIF, ANTS, NANT, NFLAGS, INFG, OUTFG, BCHAN,
     *   ECHAN, DOCOPY
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
LOCAL END
      PROGRAM BPFLG
C-----------------------------------------------------------------------
C! Flags uv data based on bad BP values
C# EXT-appl Calibration Editing
C-----------------------------------------------------------------------
C;  Copyright (C) 2019
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Flags uv data based on BP values
C   Inputs from user
C      INNAME.....Input UV file name (name).      Standard defaults.
C      INCLASS....Input UV file name (class).     Standard defaults.
C      INSEQ......Input UV file name (seq. #).    0 => highest.
C      INDISK.....Disk drive # of input UV file.  0 => any.
C      BPVER......Specifies the version of the BP table to be read as
C                 input.   0 -> highest.
C                 The output version is always highest + 1.
C      APARM(1) = lowest good BP amp
C      APARM(2) = highest good BP amp
C      APARM(3) = lowest good BP phase
C      APARM(4) = highest good BP phase
C-----------------------------------------------------------------------
      INTEGER   IRET
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'BPFLG.INC'
C-----------------------------------------------------------------------
C                                       Get parms, open things
      CALL BPFLGI (IRET)
C                                       do smoothing
      IF (IRET.EQ.0) CALL BPFLGT (IRET)
C                                       do history
      IF (IRET.EQ.0) CALL BPFLHI (IRET)
C                                       close down
      CALL DIE (IRET, BPBUFF)
C
 999  STOP
      END
      SUBROUTINE BPFLGI (IERR)
C-----------------------------------------------------------------------
C   BPSMIN performs initialization for AIPS task BPFLG.  It gets the
C   adverbs, opens the catalog file for 'WRIT', sorts and opens the BP
C   input file, creates the BP output file, and determines which FQs,
C   times, and antenna counts apply to the table.
C   Output:
C      IERR    I      Error code: 0 => keep going, else quit.
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'BPFLG.INC'
      CHARACTER INTYP*2, STAT*4, PRGN*6, KEYS(2)*24, LTYPBP*8
      INTEGER   NPARM, IROUND, BPLUN, JERR, I, J, KEY(2,2), NKEY,
     *   KOLS(2),
     *   KEYSUB(2,2)
      REAL      FKEY(2,2)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA BPLUN, INTYP /27, 'UV'/
      DATA PRGN /'BPFLG '/
      DATA NKEY /2/
      DATA FKEY /1.0,0.0, 1.0,0.0/
      DATA KEYSUB /4*1/
      DATA KEYS /'ANTENNA ', 'TIME '/
C-----------------------------------------------------------------------
C                                       AIPS init
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      NCFILE = 0
      NSCR = 0
C                                       get adverbs
      NPARM = 92
      IERR = 0
      CALL GTPARM (PRGN, NPARM, RQUICK, XINNAM, BPBUFF, JERR)
      IF (JERR.NE.0) THEN
         RQUICK = .TRUE.
         IERR = 8
         IF (JERR.EQ.1) THEN
            GO TO 999
         ELSE
            WRITE (MSGTXT,1000) JERR, 'GET INPUT ADVERBS'
            CALL MSGWRT (8)
            END IF
         END IF
C                                       restart AIPS
      IF (RQUICK) CALL RELPOP (IERR, BPBUFF, JERR)
      IF (IERR.NE.0) GO TO 999
C                                       Hollerith -> Char
      CALL H2CHR (12, 1, XINNAM, INNAM)
      CALL H2CHR (6, 1, XINCLS, INCLS)
      INSEQ = IROUND (XSEQ)
      INDISK = IROUND (XDISK)
      BPVER = IROUND (XVER)
      CNO = 1
      CALL CATDIR ('SRCH', INDISK, CNO, INNAM, INCLS, INSEQ, INTYP,
     *   NLUSER, STAT, BPBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1010) IERR, INNAM, INCLS, INSEQ, INTYP,
     *      INDISK, NLUSER
         GO TO 990
         END IF
C                                       Get catblk, mark file write
      CALL CATIO ('READ', INDISK, CNO, CATBLK, 'WRIT', BPBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READ CATALOG HEADER'
         GO TO 990
         END IF
      NCFILE = 1
      FVOL(1) = INDISK
      FCNO(1) = CNO
      FRW(1) = 1
      CALL UVPGET (IERR)
C                                       flag versions
      CALL FNDEXT ('FG', CATBLK, I)
      INFG = FGVIN + 0.1
      IF ((INFG.EQ.0) .OR. (INFG.GT.I)) INFG = I
      OUTFG = FGVOUT + 0.1
      DOCOPY = (INFG.GT.0) .AND. (OUTFG.LE.0)
      IF (OUTFG.LE.0) OUTFG = I + 1
C                                       IFs, channels
      IF (JLOCIF.LT.0) THEN
         BIF = 1
         EIF = 1
      ELSE
         BIF = XBIF + 0.1
         EIF = XEIF + 0.1
         IF ((BIF.LT.1) .OR. (BIF.GT.CATBLK(KINAX+JLOCIF))) BIF = 1
         IF ((EIF.LT.BIF) .OR. (EIF.GT.CATBLK(KINAX+JLOCIF))) EIF =
     *      CATBLK(KINAX+JLOCIF)
         END IF
      BCHAN = XBCHAN + 0.1
      ECHAN = XECHAN + 0.1
      IF ((BCHAN.LT.1) .OR. (BCHAN.GT.CATBLK(KINAX+JLOCF))) BCHAN = 1
      IF ((ECHAN.LT.BCHAN) .OR. (ECHAN.GT.CATBLK(KINAX+JLOCF))) ECHAN =
     *      CATBLK(KINAX+JLOCF)
C                                       Open BP file
      CALL BPREFM (INDISK, CNO, BPVER, CATBLK, BPLUN, IERR)
      IF (IERR.NE.0) GO TO 999
      CALL BPINI ('READ', BPBUFF, INDISK, CNO, BPVER, CATBLK, BPLUN,
     *   IBPRNO, BPKOLS, BPNUMV, NANTBP, NPOLBP, NIFBP, NCHNBP, BCHNBP,
     *   NUMSHF, LOWSHF, DELSHF, LTYPBP, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN INPUT BP TABLE'
         GO TO 990
         END IF
      WPOLY = LTYPBP.NE.' '
C                                       Set column pointers for sort
      CALL FNDCOL (NKEY, KEYS, 24, .TRUE., BPBUFF, KOLS, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1000) IERR, 'FIND BP COLUMNS'
         GO TO 990
         END IF
C                                       Sort to ant-time order
      IF ((BPBUFF(43).NE.KOLS(1)) .OR. (BPBUFF(44).NE.KOLS(2))) THEN
C                                       Close
         CALL TABIO ('CLOS', 0, IBPRNO, BPBUFF, BPBUFF, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'CLOSE BP TABLE'
            GO TO 990
            END IF
C                                       sort
         KEY(1,1) = KOLS(1)
         KEY(2,1) = KOLS(1)
         KEY(1,2) = KOLS(2)
         KEY(2,2) = KOLS(2)
         CALL TABSRT (INDISK, CNO, 'BP', BPVER, BPVER, KEY, KEYSUB,
     *      FKEY, BPBUFF, CATBLK, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'SORT BP TABLE'
            GO TO 990
            END IF
C                                       Re-open BP table for read
         CALL BPINI ('READ', BPBUFF, INDISK, CNO, BPVER, CATBLK, BPLUN,
     *      IBPRNO, BPKOLS, BPNUMV, NANTBP, NPOLBP, NIFBP, NCHNBP,
     *      BCHNBP, NUMSHF, LOWSHF, DELSHF, LTYPBP, IERR)
         IF (IERR.GT.0) THEN
            WRITE (MSGTXT,1000) IERR, 'OPEN INPUT BP TABLE'
            GO TO 990
            END IF
         END IF
C                                       set up APARM, other parameters
      IF (APARM(2).LE.APARM(1)) THEN
         APARM(1) = 0.0
         APARM(2) = 1000000.
         END IF
      IF (APARM(4).LE.APARM(3)) THEN
         APARM(1) = -180.0
         APARM(2) = 180.0
         END IF
      TIMBEG = XTIME(1) + XTIME(2) / 24.0D0 + XTIME(3) / (24.0D0*60.0D0)
     *   + (XTIME(4) / (24.0D0*60.0D0*60.0D0))
      TIMEND = XTIME(5) + XTIME(6) / 24.0D0 + XTIME(7) / (24.0D0*60.0D0)
     *   + (XTIME(8) / (24.0D0*60.0D0*60.0D0))
      IF (TIMEND.LE.TIMBEG) THEN
         TIMEND = 1000000.
         TIMBEG = -1000.
      END IF
      NANT = 0
      DO 20 I = 1,50
         J = XANT(I) + 0.1
         IF (J.GT.0) THEN
            NANT = NANT + 1
            ANTS(NANT) = J
            END IF
 20      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BPFLGI: ERROR',I5,' ON ',A)
 1010 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I3,1X,A2,
     *   'DISK=',I2,' USER=',I5)
      END
      SUBROUTINE BPFLGT (IRET)
C-----------------------------------------------------------------------
C   BPFLGT reads the open BP tables, generates flags as needed
C   Output:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'BPFLG.INC'
      INTEGER   I, J, SOURID, SUBA, ANTNO, FREQID, BPREF(2), JERR,
     *   NBPREC, LUN1, LUN2, IFGRNO, IOFF, LP, FGNUMV(MAXFGC),
     *   FGKOLS(MAXFGC), NW, IT(3), ID(3), LIF, LCH, BUFF1(512),
     *   FGBUFF(512), WOFF, BCH, ECH
      REAL      INTERV, AMP, PHASE, BT, ET, TEPS, WEIGHT(2*MAXIF)
      CHARACTER REASON*24, CSTOKE(2)*4
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUN1, LUN2 /28, 29/
      DATA CSTOKE /'1011', '0111'/
C-----------------------------------------------------------------------
      NBPREC = BPBUFF(5)
      NFLAGS = 0
      TEPS = 0.1/(24.0*3600.0)
      CALL ZDATE (ID)
      CALL ZTIME (IT)
      WRITE (REASON,1010) TSKNAM, ID, IT
C                                       read BP table
      DO 100 J = 1,NBPREC
         IBPRNO = J
         CALL TABBP ('READ', BPBUFF, IBPRNO, BPKOLS, BPNUMV, NIFBP,
     *      NCHNBP, NPOLBP, TIME, INTERV, SOURID, SUBA, ANTNO, CHNBND,
     *      BPFREQ, FREQID, BPREF, WEIGHT, BNDPAS, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ BP TABLE'
            GO TO 990
            END IF
         IF ((TIME.LT.TIMBEG) .OR. (TIME.GT.TIMEND)) GO TO 100
         IF (NANT.GT.0) THEN
            DO 10 I = 1,NANT
               IF (ANTNO.EQ.ANTS(I)) GO TO 15
 10            CONTINUE
            GO TO 100
            END IF
C                                       loop through BP
 15      DO 50 LP = 1,NPOLBP
            WOFF = (LP - 1) * NIFBP
            DO 40 LIF = BIF,EIF
               IOFF = (LIF - 1) * NCHNBP + (LP - 1) * NCHNBP * NIFBP
               BCH = 0
               DO 30 LCH = BCHAN,ECHAN
                  IF ((BNDPAS(1,LCH+IOFF).NE.FBLANK) .AND.
     *               (BNDPAS(2,LCH+IOFF).NE.FBLANK) .AND.
     *               (WEIGHT(WOFF+LIF).GT.0.0)) THEN
                     AMP = SQRT (BNDPAS(1,LCH+IOFF)**2 +
     *                  BNDPAS(2,LCH+IOFF)**2)
                     PHASE = ATAN2 (BNDPAS(2,LCH+IOFF),
     *                  BNDPAS(1,LCH+IOFF)) * RAD2DG
C                                       flag it
                     IF ((AMP.LT.APARM(1)) .OR. (AMP.GT.APARM(2)) .OR.
     *                  (PHASE.LT.APARM(3)) .OR. (PHASE.GT.APARM(4)))
     *                  THEN
C                                       copy old FG table
                        IF (DOCOPY) THEN
                           CALL TABCOP ('FG', INFG, OUTFG, LUN1, LUN2,
     *                        INDISK, INDISK, CNO, CNO, CATBLK, BUFF1,
     *                        FGBUFF, IRET)
                           IF (IRET.NE.0) THEN
                              WRITE (MSGTXT,1000) IRET,
     *                           'COPYING OLD FG TABLE'
                              GO TO 990
                              END IF
                           CALL FILL (512, 0, FGBUFF)
                           DOCOPY = .FALSE.
                           END IF
                        BT = TIME - TEPS
                        ET = TIME + TEPS
                        IF (BCH.LE.0) BCH = LCH
                        ECH = LCH
                     ELSE IF (BCH.GT.0) THEN
                        CALL FLAGUP ('FLAG', LUN1, INDISK, CNO, OUTFG,
     *                     FGBUFF, IFGRNO, FGKOLS, FGNUMV, SOURID, 1,
     *                     SUBA, FREQID, 1, ANTNO, 0, BT, ET, LIF, LIF,
     *                     BCH, ECH, CSTOKE(LP), REASON, NW, IRET)
                        IF (IRET.NE.0) THEN
                           WRITE (MSGTXT,1000) IRET,
     *                        'ADDING FLAGS TO TABLE'
                           GO TO 990
                           END IF
                        NFLAGS = NFLAGS + NW
                        BCH = 0
                        END IF
                     END IF
 30               CONTINUE
               IF (BCH.GT.0) THEN
                  CALL FLAGUP ('FLAG', LUN1, INDISK, CNO, OUTFG,
     *               FGBUFF, IFGRNO, FGKOLS, FGNUMV, SOURID, 1,
     *               SUBA, FREQID, 1, ANTNO, 0, BT, ET, LIF, LIF,
     *               BCH, ECH, CSTOKE(LP), REASON, NW, IRET)
                  IF (IRET.NE.0) THEN
                     WRITE (MSGTXT,1000) IRET, 'ADDING FLAGS TO TABLE'
                     GO TO 990
                     END IF
                  NFLAGS = NFLAGS + NW
                  END IF
 40            CONTINUE
 50         CONTINUE
 100     CONTINUE
      WRITE (MSGTXT,1100) NFLAGS, OUTFG
      CALL MSGWRT (4)
C                                       close
      CALL TABBP ('CLOS', BPBUFF, IBPRNO, BPKOLS, BPNUMV, NIFBP, NCHNBP,
     *   NPOLBP, TIME, INTERV, SOURID, SUBA, ANTNO, CHNBND, BPFREQ,
     *   FREQID, BPREF, WEIGHT, BNDPAS, JERR)
      CALL FLAGUP ('CLOS', LUN1, INDISK, CNO, OUTFG, FGBUFF, IFGRNO,
     *   FGKOLS, FGNUMV, SOURID, 1, SUBA, FREQID, 1, ANTNO, 0, BT, ET,
     *   LIF, LIF, LCH, LCH, CSTOKE(LP), REASON, NW, IRET)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BPFLGT: ERROR',I5,' ON ',A)
 1010 FORMAT (A6,I5,2('/',I2.2),I3.2,2I2.2)
 1100 FORMAT ('Wrote',I12,' new flags to FG table version',I4)
      END
      SUBROUTINE BPFLHI (IRET)
C-----------------------------------------------------------------------
C   BPFGHI writes some history records to record what we did
C   Output:
C      IRET   I   Error code - always 0
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'BPFLG.INC'
      INTEGER   IERR, HIBUFF(256), IT(4), ID(3), IHLUN, I, I1, I2
      CHARACTER HILINE*72, ATIME*8, ADATE*12
      REAL      TEMP
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA IHLUN /29/
C-----------------------------------------------------------------------
      IRET = 0
      IF (NFLAGS.LE.0) GO TO 999
C                                       Initialize HI common
      CALL HIINIT (3)
C                                       Open HI file
      CALL HIOPEN (IHLUN, INDISK, CNO, HIBUFF, IERR)
      IF (IERR.NE.0) THEN
         IF (IERR.EQ.5) THEN
            WRITE (MSGTXT,1000)
         ELSE
            WRITE (MSGTXT,1010) IERR
            END IF
         GO TO 990
         END IF
C                                       Header text
      CALL ZDATE (ID)
      CALL ZTIME (IT)
      CALL TIMDAT (IT, ID, ATIME, ADATE)
      WRITE (HILINE,1020) TSKNAM, RLSNAM, ADATE, ATIME
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
C                                       versions
      WRITE (HILINE,1025) TSKNAM, BPVER
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
      WRITE (HILINE,1030) TSKNAM, INFG
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
      WRITE (HILINE,1035) TSKNAM, OUTFG
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
C                                       IFs
      WRITE (HILINE,1040) TSKNAM, 'BIF', BIF
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
      WRITE (HILINE,1040) TSKNAM, 'EIF', EIF
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
C                                       times
      IF (TIMBEG.GT.0.0) THEN
         IT(1) = TIMBEG
         TEMP  = (TIMBEG - IT(1)) * 24.0
         IT(2) = TEMP
         TEMP = (TEMP - IT(2)) * 60.0
         IT(3) = TEMP
         TEMP = (TEMP - IT(3)) * 60.0
         IT(4) = TEMP
         WRITE (HILINE,1050) TSKNAM, 'BEG', IT
         CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
         IF (IERR.NE.0) GO TO 90
         END IF
      IF (TIMEND.LT.1000.0) THEN
         IT(1) = TIMEND
         TEMP  = (TIMBEG - IT(1)) * 24.0
         IT(2) = TEMP
         TEMP = (TEMP - IT(2)) * 60.0
         IT(3) = TEMP
         TEMP = (TEMP - IT(3)) * 60.0
         IT(4) = TEMP
         WRITE (HILINE,1050) TSKNAM, 'END', IT
         CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
         IF (IERR.NE.0) GO TO 90
         END IF
C                                       antennas
      IF (NANT.LE.0) THEN
         WRITE (HILINE,1055) TSKNAM
         CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
         IF (IERR.NE.0) GO TO 90
      ELSE
         I1 = 1
 10      I2 = MIN (I1+13, NANT)
         WRITE (HILINE,1060) TSKNAM, (ANTS(I), I = I1,I2)
         IF (I1.GT.1) HILINE(:16) = ' '
         CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
         IF (IERR.NE.0) GO TO 90
         IF (I2.LT.NANT) GO TO 10
         END IF
C                                       number flagged
      WRITE (HILINE,1070) TSKNAM, NFLAGS
      CALL HIADD (IHLUN, HILINE, HIBUFF, IERR)
      IF (IERR.NE.0) GO TO 90
      GO TO 100
C                                       ERROR
 90   WRITE (MSGTXT,1090) IERR
      CALL MSGWRT (6)
C                                       Close file updating it
 100  CALL HICLOS (IHLUN, .TRUE., HIBUFF, IERR)
      GO TO 999
C
 990  CALL MSGWRT (6)

C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BPSMHI: HISTORY FILE DOES NOT EXIST')
 1010 FORMAT ('BPSMHI: ERROR',I5,' OPENING THE HISTORY FILE')
 1020 FORMAT (A6,'RELEASE =''',A7,' ''  /********* Start ',A12,2X,A8)
 1025 FORMAT (A6,'INVERS   =',I5,'  / BP table version number')
 1030 FORMAT (A6,'FLAGVER  =',I5,'  / FG table input version')
 1035 FORMAT (A6,'OUTFGVER =',I5,'  / FG table output version')
 1040 FORMAT (A6,A3,'      =',I5,'  / IF range')
 1050 FORMAT (A6,A3,'TIM   =',I3,2(':',I2.2),I2.2,'  / time range')
 1055 FORMAT (A6,'ANTENNAS =   0','  / all antennas included')
 1060 FORMAT (A6,'ANTENNAS =',14(I3,','))
 1070 FORMAT (A6,'/  NFLAGS=',I10,'  / number flag recirds written')
 1090 FORMAT ('BPSMHI: ERROR',I5,' ADDING TO THE HISTORY FILE')
      END
