LOCAL INCLUDE 'BLPCL.INC'
C                                       Local include for BLPCL
      INCLUDE 'INCS:ZPBUFSZ.INC'
      HOLLERITH XNAME1(3), XCLAS1(2), XNAME2(3), XCLAS2(2), XNAME3(3),
     *   XCLAS3(2), XNAME4(3), XCLAS4(2), XNAME5(3), XCLAS5(2),
     *   XSOUR(4), XNAMOU(3), XCLAOU(2)
      REAL      XSEQ1, XDISK1, XSEQ2, XDISK2, XSEQ3, XDISK3, XSEQ4,
     *   XDISK4, XSEQ5, XDISK5, XSUBA, XDOCAL, XGUSE, XFLAG, XDOBND,
     *   XBPVER, XDOPOL, XPDVER, XSMOTH(3), XBDVER, XSOUT, XDISO,
     *   BADD(10),
     *   SCRBUF(256), BUFF1(UVBFSS), BUFF2(UVBFSS), BUFF3(UVBFSS),
     *   BUFF4(UVBFSS), BUFF5(UVBFSS), BUFFRS(UVBFSS,5), TIMIN, TIMAX
      INTEGER   SEQIN(5), SEQOUT, DISKIN(5), DISKO, CATOLD(256,5),
     *   INCSI, INCFI, INCIFI, INCSO, INCFO, INCIFO, LRECO, NRPRMI,
     *   NRPRMO, OLDCNO(5), NEWCNO, NRPRMM, LRECM, JBUFSZ, ILOCWT,
     *   MLOCT, MLOCB, MLOCA1, MLOCA2, MFILES, CATNEW(256), BDVER
      LOGICAL   ISCOMP, ISVPOL
      CHARACTER NAMEIN(5)*12, CLASIN(5)*6, NAMOUT*12, CLAOUT*6
      EQUIVALENCE (BUFFRS(1,1), BUFF1),  (BUFFRS(1,2), BUFF2),
     *   (BUFFRS(1,3), BUFF3), (BUFFRS(1,4), BUFF4),
     *   (BUFFRS(1,5), BUFF5)
      COMMON /INPARM/ XNAME1, XCLAS1, XSEQ1, XDISK1, XNAME2, XCLAS2,
     *   XSEQ2, XDISK2, XNAME3, XCLAS3, XSEQ3, XDISK3, XNAME4, XCLAS4,
     *   XSEQ4, XDISK4, XNAME5, XCLAS5, XSEQ5, XDISK5, XSOUR, XSUBA,
     *   XDOCAL, XGUSE, XFLAG, XDOBND, XBPVER, XDOPOL, XPDVER, XSMOTH,
     *   XBDVER, XNAMOU, XCLAOU, XSOUT, XDISO, BADD
      COMMON /BLPCLP/ CATOLD, CATNEW, SEQIN, SEQOUT, DISKIN, DISKO,
     *   ILOCWT, INCSI, INCFI, INCIFI, INCSO, INCFO, INCIFO, LRECO,
     *   NRPRMI, NRPRMO, ISCOMP, OLDCNO, NEWCNO, NRPRMM, LRECM, MLOCT,
     *   MLOCB, MLOCA1, MLOCA2, ISVPOL, MFILES, BDVER, TIMIN, TIMAX
      COMMON /CHARPM/ NAMEIN, CLASIN, NAMOUT, CLAOUT
      COMMON /BUFRS/ SCRBUF, BUFFRS, JBUFSZ
C                                       End local include for BLPCL
LOCAL END
      PROGRAM BLPCL
C-----------------------------------------------------------------------
C! Divide by I/Q/U model for linear polarization
C# Utility UV UV-util VLA VLB Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   BLPCL reads 3 or 4 polarization model data sets and a matching
C   actual data set.  It computes the average ration of RR, LL, RL,and
C   LR data to model and makes a BD table of correction complex factors
C   to apply to the data and then does that application to the input
C   data set.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, MAXANS, MAXIFS, MAXCHS, NEED
      REAL      WORK(2), WTS(2)
      LONGINT   PWORK, PWTS
      INCLUDE 'BLPCL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DSEL.INC'
      DATA PRGM /'BLPCL '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL BLPCLI (PRGM, MAXANS, MAXIFS, MAXCHS, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       get dynamic memory
      MAXCHS = MAXCHS * MAXIFS
      NEED = MAXANS * MAXANS * MAXCHS
      NEED = (4 * NEED - 1) / 1024 + 1
      CALL ZMEMRY ('GET ', TSKNAM, NEED, WORK, PWORK, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'FAILED TO ALLOCATED NEEDED MEMORY'
         CALL MSGWRT (8)
         GO TO 990
         END IF
      CALL ZMEMRY ('GET ', TSKNAM, NEED, WTS, PWTS, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'FAILED TO ALLOCATED NEEDED MEMORY'
         CALL MSGWRT (8)
         GO TO 990
         END IF
C                                       Average divided data
      MSGTXT = 'Now average the gain values'
      CALL MSGWRT (2)
      CALL BLPCLD (MAXANS, MAXIFS, MAXCHS, WORK(1+PWORK), WTS(1+PWTS),
     *   IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Average divided data
      MSGTXT = 'Now apply the gains to the input'
      CALL MSGWRT (2)
      CALL BLPCLO (MAXANS, MAXCHS, WORK(1+PWORK), IRET)
      IF (IRET.NE.0) GO TO 990
C                                       history
      CALL BLPCLH
C                                       Close down files, etc.
 990  CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE BLPCLI (PRGN, MAXANS, MAXIFS, MAXCHS, JERR)
C-----------------------------------------------------------------------
C   BLPCLI gets input parameters for BLPCL and creates an output file
C   if necessary.
C   Inputs:
C      PRGN     C*6   Program name
C   Output:
C      MAXANS   I     Maximum antenna number in data.
C      MAXIFS   I     Maximum number of IFs.
C      MAXCHS   I     Maximum spectral channels
C      JERR     I     Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C   Output in common:
C      NRPRMI  I  Input number of random parameters.
C      INCSI   I  Input Stokes' increment in vis.
C      INCFI   I  Input frequency increment in vis.
C      INCIFI  I  Input IF increment in vis.
C      LRECO   I  Output file record length
C      NRPRMO  I  Output number of random parameters.
C      INCSO   I  Output Stokes' increment in vis.
C      INCFO   I  Output frequency increment in vis.
C      INCIFO  I  Output IF increment in vis.
C      ISCOMP  L  If true data is compressed
C-----------------------------------------------------------------------
      INTEGER   JERR, MAXANS, MAXIFS, MAXCHS
      CHARACTER PRGN*6
C
      CHARACTER STAT*4, BLANK*6, PTYPE*2
      INTEGER   IROUND, NPARM, IERR, INCX, I, NFREQ, J, K, NOMAT,
     *   NUMAN(2), LUN1
      REAL      CATR(256), RPARM(20)
      HOLLERITH CATH(256)
      DOUBLE PRECISION CATD(128)
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'BLPCL.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      EQUIVALENCE (NUMAN, BUFF1)
      EQUIVALENCE (CATBLK, CATR, CATH, CATD)
      DATA BLANK  /' '/,  LUN1 /22/
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 68
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAME1, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, SCRBUF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAME1, NAMEIN(1))
      CALL H2CHR (6, 1, XCLAS1, CLASIN(1))
      SEQIN(1) = IROUND (XSEQ1)
      DISKIN(1) = IROUND (XDISK1)
      CALL H2CHR (12, 1, XNAME2, NAMEIN(2))
      CALL H2CHR (6, 1, XCLAS2, CLASIN(2))
      SEQIN(2) = IROUND (XSEQ2)
      DISKIN(2) = IROUND (XDISK2)
      CALL H2CHR (12, 1, XNAME3, NAMEIN(3))
      CALL H2CHR (6, 1, XCLAS3, CLASIN(3))
      SEQIN(2) = IROUND (XSEQ3)
      DISKIN(3) = IROUND (XDISK3)
      CALL H2CHR (12, 1, XNAME4, NAMEIN(4))
      CALL H2CHR (6, 1, XCLAS4, CLASIN(4))
      SEQIN(4) = IROUND (XSEQ4)
      DISKIN(4) = IROUND (XDISK4)
      CALL H2CHR (12, 1, XNAME5, NAMEIN(5))
      CALL H2CHR (6, 1, XCLAS5, CLASIN(5))
      SEQIN(5) = IROUND (XSEQ5)
      DISKIN(5) = IROUND (XDISK5)
      ISVPOL = (NAMEIN(5).NE.' ') .OR. (CLASIN(5).NE.' ')
      DO 5 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 5       CONTINUE
      CALL H2CHR (16, 1, XSOUR, SOURCS(1))
      CALL H2CHR (12, 1, XNAMOU, NAMOUT)
      CALL H2CHR (6, 1, XCLAOU, CLAOUT)
      SEQOUT = IROUND (XSOUT)
      DISKO = IROUND (XDISO)
C                                       Info for UVGET:
C                                       Put selection criteria into
C                                       correct common.
      UNAME = NAMEIN(1)
      UCLAS = CLASIN(1)
      UDISK = DISKIN(1)
      USEQ = SEQIN(1)
      DOCAL = XDOCAL.GT.0.0
      DOWTCL = DOCAL .AND. (XDOCAL.LE.99.0)
      FGVER = IROUND (XFLAG)
      DOBAND = IROUND (XDOBND)
      BPVER = IROUND (XBPVER)
      CLVER = IROUND (XGUSE)
      CLUSE = IROUND (XGUSE)
      MFILES = 4
      IF (ISVPOL) MFILES = 5
      SUBARR = XSUBA + 0.1
      SUBARR = MAX (1, SUBARR)
      BDVER = IROUND (XBDVER)
      CALL RCOPY (3, XSMOTH, SMOOTH)
C                                       Get CATBLK from old file.
      DO 20 I = 1,MFILES
         OLDCNO(I) = 1
         PTYPE = 'UV'
         CALL CATDIR ('SRCH', DISKIN(I), OLDCNO(I), NAMEIN(I),
     *      CLASIN(I), SEQIN(I), PTYPE, NLUSER, STAT, SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1030) IERR, NAMEIN(I), CLASIN(I), SEQIN(I),
     *         DISKIN(I), NLUSER
            GO TO 990
            END IF
         CALL CATIO ('READ', DISKIN(I), OLDCNO(I), CATBLK, 'REST',
     *      SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1040) IERR
            GO TO 990
            END IF
C                                       Save input CATBLK
         CALL COPY (256, CATBLK, CATOLD(1,I))
C                                       Compressed data?
         IF (I.EQ.1) ISCOMP = CATBLK(KINAX).EQ.1
         IF ((I.GT.1) .AND. (CATBLK(KINAX).EQ.1)) THEN
            IERR = 10
            MSGTXT = 'I DO NOT WORK ON COMPRESSED MODEL DATA'
            GO TO 990
            END IF
C                                       Get uv header info.
         CALL UVPGET (JERR)
         IF (JERR.NE.0) GO TO 999
         NRPRMM = NRPARM
         LRECM = LREC
         MLOCB = ILOCB
         MLOCT = ILOCT
         MLOCA1 = ILOCA1
         MLOCA2 = ILOCA2
         CALL CATDIR ('CSTA', DISKIN(I), OLDCNO(I), NAMEIN(I),
     *      CLASIN(I), SEQIN(I), PTYPE, NLUSER, 'READ', SCRBUF, IERR)
         NCFILE = NCFILE + 1
         FVOL(NCFILE) = DISKIN(I)
         FCNO(NCFILE) = OLDCNO(I)
         FRW(NCFILE) = 0
 20      CONTINUE
      NOMAT = 0
      J = CATOLD(KIDIM,1)
      DO 30 I = 2,MFILES
         DO 25 K = 0,J-1
            IF ((CATOLD(KINAX+K,I).NE.CATOLD(KINAX+K,1)) .AND. (K.NE.1))
     *         NOMAT = NOMAT+1
 25         CONTINUE
 30      CONTINUE
      IF (NOMAT.GT.0) THEN
         MSGTXT = 'HEADERS DO NOT MATCH'
         JERR = 10
         GO TO 990
         END IF
C                                       Channel selection?
      BIF = 1
      EIF = CATOLD(KINAX+JLOCIF,1)
      NFREQ = CATOLD(KINAX+JLOCF,1)
      BCHAN = 1
      ECHAN = NFREQ
      MAXIFS = CATOLD(KINAX+JLOCIF,1)
      MAXCHS = CATOLD(KINAX+JLOCF,1)
C                                       Find number of antennas.
      CALL GETNAN (DISKIN(1), OLDCNO(1), CATOLD(1,1), LUN1, SCRBUF,
     *   NUMAN, IERR)
      IF (IERR.NE.0) GO TO 999
      MAXANS = NUMAN(2)
C                                       now using cal system -
C                                       UVGET makes header
      CALL UVGET ('INIT', RPARM, SCRBUF, JERR)
      IF (JERR.NE.0) THEN
         WRITE (MSGTXT,1035) JERR
         GO TO 990
         END IF
      CALL UVGET ('CLOS', RPARM, SCRBUF, IERR)
C                                       Save input file info
      INCX = CATBLK(KINAX)
      NRPRMI = NRPARM
      INCSI = INCS / INCX
      INCFI = INCF / INCX
      INCIFI = INCIF / INCX
C                                       Put new values in CATBLK.
      CALL MAKOUT (NAMEIN(1), CLASIN(1), SEQIN(1), BLANK, NAMOUT,
     *   CLAOUT, SEQOUT)
      CALL CHR2H (12, NAMOUT, KHIMNO, CATH(KHIMN))
      CALL CHR2H (6, CLAOUT, KHIMCO, CATH(KHIMC))
      CATBLK(KIIMS) = SEQOUT
C                                       read compressed => write compr.
      IF (ISCOMP) THEN
         CATBLK(KINAX) = 1
         I = CATBLK(KIPCN)
         CALL CHR2H (8, 'WEIGHT  ', 1, CATH(KHPTP+2*I))
         CALL CHR2H (8, 'SCALE   ', 1, CATH(KHPTP+2*I+2))
         CATBLK(KIPCN) = I + 2
         ILOCWT = I
         END IF
C                                       Create output file.
      CCNO = 1
      FRW(NCFILE+1) = 3
      JERR = 4
      CALL UVCREA (DISKO, CCNO, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         IF (IERR.NE.2) THEN
            WRITE (MSGTXT,1050) IERR
            GO TO 990
            END IF
C                                       Only overwrite Input file
C                                       no destroy existing otherwise
         IF ((CCNO.NE.OLDCNO(1)) .OR. (DISKO.NE.DISKIN(1))) THEN
            WRITE (MSGTXT,1060)
            GO TO 990
            END IF
C                                       Recover existing CATBLK
         FRW(NCFILE+1) = 2
         CALL CATIO ('READ', DISKO, CCNO, CATBLK, 'WRIT', SCRBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1065) IERR
            CALL MSGWRT (6)
            END IF
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKO
      FCNO(NCFILE) = CCNO
      FRW(NCFILE) = FRW(NCFILE) - 1
      NEWCNO = CCNO
C                                       Save output file info
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
      INCX = CATBLK(KINAX)
      LRECO = LREC
      NRPRMO = NRPARM
      INCSO = INCS / INCX
      INCFO = INCF / INCX
      INCIFO = INCIF / INCX
      JERR = 0
      SEQOUT = CATBLK(KIIMS)
C                                       Copy any header keywords
      CALL KEYCOP (DISKIN(1), OLDCNO(1), DISKO, NEWCNO, IERR)
      CALL COPY (256, CATBLK, CATNEW)
      TIMIN = 1.E10
      TIMAX = -1.E10
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLPCLI: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1035 FORMAT ('UVGET INIT ERROR',I3,' CHECK ADVERBS')
 1040 FORMAT ('ERROR',I3,' COPYING CATBLK ')
 1050 FORMAT ('ERROR',I3,' CREATING OUTPUT FILE')
 1060 FORMAT ('MAY OVERWRITE INPUT FILE ONLY.  QUITTING')
 1065 FORMAT ('BLPCLI: ERROR',I3,' UPDATING NEW CATBLK')
      END
      SUBROUTINE BLPCLD (MAXANS, MAXIFS, MAXF, SUMP, SUMW, IRET)
C-----------------------------------------------------------------------
C   BLPCLD reads the data and the 3 model files, computes the data
C   divided by model, and sums the result.  It then writes the BD table.
C   Output:
C      SUMP    R(*)   (POL&wt, freq, ant, ant)
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   MAXANS, MAXIFS, MAXF, IRET
      REAL      SUMP(4,MAXF,MAXANS,MAXANS), SUMW(4,MAXF,MAXANS,MAXANS)
C
      CHARACTER OFILE*48
      INTEGER   ILENBU, IA1, IA2, BO, VO, NUMVIS, XCOUNT, CATMP(256),
     *   VISINC, VISMSG, LUNI(5), INDI(5), IBIND(5), JNIO, INIO(5),
     *   JA1(5), JA2(5), IPTRM, NERR, I, K, BDBUFF(512), J, FREQID,
     *   BDKOLS(14), BDNUMV(14), IBDRNO, II, LUNBD, NUGOOD, NUMFRQ,
     *   SOURID, SUBA
      LOGICAL   T, F
      INCLUDE 'BLPCL.INC'
      REAL      BASEN, VIS(UVBFSS), RESULT(UVBFSS), RPARM(20), TT(5),
     *   TEPS, A, TIME(2), WT, DBG(12,64)
      DOUBLE PRECISION UVSCAL
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      EQUIVALENCE (DBG, RESULT)
      DATA LUNI /40, 41, 42, 43, 44/, LUNBD/45/
      DATA VO, BO /0, 1/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
      NUGOOD = 0
      I = 4 * MAXF * MAXANS * MAXANS
      CALL RFILL (I, 0.0, SUMP)
      CALL RFILL (I, 0.0, SUMW)
C
      TEPS = 0.5 / (24.0 * 3600.0)
      NERR = 0
C                                       Number of visibilities in input
C                                       and output files.
      VISINC = CATBLK(KIGCN) / 10
      VISINC = MAX (20000, MIN (200000,VISINC))
      VISMSG = 3 * VISINC
C                                       defend cat header from UVGET
      CALL COPY (256, CATBLK, CATMP)
C                                       Open and init for read
      CALL UVGET ('INIT', RPARM, VIS, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN/INIT INPUT VIS FILE'
         GO TO 990
         END IF
      CALL COPY (256, CATMP, CATBLK)
      CALL UVPGET (IRET)
C                                       Open 3 vis files for read
      DO 20 I = 2,MFILES
         CALL ZPHFIL ('UV', DISKIN(I), OLDCNO(I), 1, OFILE, IRET)
         CALL ZOPEN (LUNI(I), INDI(I), DISKIN(I), OFILE, T, F, F, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPEN INPUT MODEL FILE'
            GO TO 990
            END IF
C                                       Init vis file for write
         ILENBU = 0
         CALL UVINIT ('READ', LUNI(I), INDI(I), NVIS, VO, LRECM, ILENBU,
     *      JBUFSZ, BUFFRS(1,I), BO, IBIND(I), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT MODEL FILE FOR READ'
            GO TO 990
            END IF
         INIO(I) = 0
 20      CONTINUE
      NUMVIS = 0
      XCOUNT = 0
      JNIO = 1000000
      IF ((FREQ.GT.0.0D0) .AND. (UVFREQ.GT.0.0D0)) THEN
         UVSCAL = FREQ / UVFREQ
      ELSE
         UVSCAL = 1.0D0
         END IF
C                                       Loop
C                                       Read vis. record.
 100  CALL UVGET ('READ', RPARM, VIS, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ INPUT DATA FILE'
         GO TO 990
C                                       Loop over buffer
      ELSE IF (IRET.EQ.0) THEN
C                                       Read the 3
         IF (JNIO.GT.INIO(2)) THEN
            DO 110 I = 2,MFILES
               CALL UVDISK ('READ', LUNI(I), INDI(I), BUFFRS(1,I),
     *            INIO(I), IBIND(I), IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET,  'READ MODEL FILE'
                  GO TO 990
                  END IF
               IPTRM = IBIND(I)
 110           CONTINUE
            JNIO = 1
            END IF
         DO 115 I = 2,4
            IF (MLOCB.GE.0) THEN
               BASEN = BUFFRS(IPTRM+MLOCB,I)
               JA1(I) = BASEN / 256. + 0.1
               JA2(I) = BASEN - JA1(I)*256. + 0.1
            ELSE
               JA1(I) = BUFFRS(IPTRM+MLOCA1,I) + 0.1
               JA2(I) = BUFFRS(IPTRM+MLOCA2,I) + 0.1
               END IF
            TT(I) = BUFFRS(IPTRM+MLOCT,I)
 115        CONTINUE
         IF (ILOCB.GE.0) THEN
            BASEN = RPARM(1+ILOCB)
            IA1 = BASEN / 256. + 0.1
            IA2 = BASEN - IA1*256. + 0.1
         ELSE
            IA1 = RPARM(1+ILOCA1) + 0.1
            IA2 = RPARM(1+ILOCA2) + 0.1
            END IF
         TT(1) = RPARM(1+ILOCT)
C                                       are we aligned
         IF ((JA1(4).NE.JA1(2)) .OR. (JA1(3).NE.JA1(2)) .OR.
     *      (JA2(4).NE.JA2(2)) .OR. (JA2(3).NE.JA2(2)) .OR.
     *      (ABS(TT(4)-TT(2)).GT.TEPS) .OR. (ABS(TT(3)-TT(2)).GT.TEPS))
     *      THEN
            MSGTXT = 'MODELS ARE OUT OF SYNC'
            IRET = 10
            GO TO 990
            END IF
         IF ((IA1.NE.JA1(2)) .OR. (IA2.NE.JA2(2)) .OR.
     *      (ABS(TT(1)-TT(2)).GT.TEPS)) THEN
            NERR = NERR + 1
            MSGTXT = 'DATA OUT OF SYNC WITH MODELS'
            CALL MSGWRT (6)
            IF (NERR.LT.50) GO TO 100
            IRET = 10
            MSGTXT = 'TOO MANY SUCH ERRORS'
            GO TO 990
            END IF
C                                       progress
         NUMVIS = NUMVIS + 1
         IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
            WRITE (MSGTXT,1105) NUMVIS
            CALL MSGWRT (2)
         ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
            WRITE (MSGTXT,1105) NUMVIS
            CALL MSGWRT (1)
            END IF
         RPARM(1+ILOCU) = RPARM(1+ILOCU) * UVSCAL
         RPARM(1+ILOCV) = RPARM(1+ILOCV) * UVSCAL
         RPARM(1+ILOCW) = RPARM(1+ILOCW) * UVSCAL
C                                       call user routine
         K = IPTRM + NRPRMM
         CALL BLPCLC (NUMVIS, TT(1), IA1, IA2, VIS, BUFFRS(K,2),
     *      BUFFRS(K,3), BUFFRS(K,4), BUFFRS(K,5), RESULT)
         JNIO = JNIO + 1
         IPTRM = IPTRM + LRECM
C                                       sum into arrays
         II = -2
         DO 130 I = 1,MAXF
            DO 120 J = 1,4
               II = II + 3
               WT = RESULT(II+2)
               IF (WT.GT.0.0) THEN
                  SUMP(J,I,IA1,IA2) = SUMP(J,I,IA1,IA2) +
     *               RESULT(II) * WT
                  SUMP(J,I,IA2,IA1) = SUMP(J,I,IA2,IA1) +
     *               RESULT(II+1) * WT
                  SUMW(J,I,IA1,IA2) = SUMW(J,I,IA1,IA2) + WT
                  NUGOOD = 1
                  END IF
 120           CONTINUE
 130        CONTINUE
         XCOUNT = XCOUNT + 1.0D0
C                                       Read next buffer.
         GO TO 100
         END IF
C                                       Close files
      CALL UVGET ('CLOS', RPARM, VIS, IRET)
      DO 131 I = 2,MFILES
         CALL ZCLOSE (LUNI(I), INDI(I), IRET)
 131     CONTINUE
C                                       average
      DO 170 IA1 = 1,MAXANS-1
         DO 160 IA2 = IA1+1,MAXANS
            DO 150 I = 1,MAXF
               DO 140 J= 1,4
                  WT = SUMW(J,I,IA1,IA2)
                  IF (WT.GT.0) THEN
                     SUMP(J,I,IA1,IA2) = SUMP(J,I,IA1,IA2) / WT
                     SUMP(J,I,IA2,IA1) = SUMP(J,I,IA2,IA1) / WT
                     A = SUMP(J,I,IA1,IA2)**2 + SUMP(J,I,IA2,IA1)**2
                     IF (A.GT.0) THEN
                        SUMP(J,I,IA1,IA2) = SUMP(J,I,IA1,IA2) / A
                        SUMP(J,I,IA2,IA1) = -SUMP(J,I,IA2,IA1) / A
                        END IF
                  ELSE
                     SUMP(J,I,IA1,IA2) = FBLANK
                     SUMP(J,I,IA2,IA1) = FBLANK
                     END IF
 140              CONTINUE
 150           CONTINUE
 160        CONTINUE
 170     CONTINUE
C                                       BD table
      IF (XBDVER.LT.0.0) GO TO 999
      NUMPOL = 4
      NUMFRQ = MAXF / MAXIFS
      FREQID = 0
      SOURID = 0
      TIME(1) = TIMIN
      TIME(2) = TIMAX
      SUBA = SUBARR
      CALL CATFIX (DISKIN, OLDCNO, 'NOTR')
      CALL BDINI ('WRIT', BDBUFF, DISKIN, OLDCNO, BDVER, CATOLD, LUNBD,
     *   IBDRNO, BDKOLS, BDNUMV, MAXANS, NUMPOL, MAXIFS, NUMFRQ, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CREATING OUTPUT BD TABLE'
         GO TO 990
         END IF
      WRITE (MSGTXT,1170) BDVER
      CALL MSGWRT (2)
      DO 200 IA1 = 1,MAXANS-1
         DO 195 IA2 = IA1+1,MAXANS
            I = -1
            DO 190 J = 1,4
               DO 180 K = 1,MAXF
                  I = I + 2
                  VIS(I) = SUMP(J,K,IA1,IA2)
                  VIS(I+1) = SUMP(J,K,IA2,IA1)
 180              CONTINUE
 190           CONTINUE
            CALL TABBD ('WRIT', BDBUFF, IBDRNO, BDKOLS, BDNUMV, MAXIFS,
     *         NUMFRQ, NUMPOL, TIME, SOURID, SUBA, IA1, IA2, FREQID,
     *         VIS, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'WRITING BD TABLE'
               GO TO 990
               END IF
 195        CONTINUE
 200     CONTINUE
      CALL TABBD ('CLOS', BDBUFF, IBDRNO, BDKOLS, BDNUMV, MAXIFS,
     *   NUMFRQ, NUMPOL, TIME, SOURID, SUBA, IA1, IA2, FREQID, VIS,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSING BD TABLE'
         GO TO 990
         END IF
      IRET = 0
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLPCLD: ERROR',I3,' ON ',A)
 1105 FORMAT ('BLPCLD: at visibility record',I10)
 1170 FORMAT ('Writing BD table version',I5)
      END
      SUBROUTINE BLPCLO (MAXANS, MAXF, SUMP, IRET)
C-----------------------------------------------------------------------
C   BLCOUT copies the input uv data set applying the solution
C   Inputs:
C      MAXANS   I      Array dimension # antennas
C      MAXF     I      Array dimension Nchans * Nifs
C      SUMP     R(*)   Solution polarization 1-4
C   Outputs:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   MAXANS, MAXF, IRET
      REAL      SUMP(4,MAXF,MAXANS,MAXANS)
C
      INTEGER   NCOPY, NCORO, ILENBU, VO, BO, LUNO, LUNI, INDI,
     *   INDO, KBIND, IPTRI, IPTRO, IBIND, NIOUT, NIOLIM, NUMVIS,
     *   VISINC, VISMSG, RNXRET, INIO, I
      LOGICAL   T, F
      CHARACTER BLANK*6, IFILE*48, OFILE*48
      INCLUDE 'BLPCL.INC'
      REAL      UBUFF(UVBFSS)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA BLANK /' '/
      DATA T, F /.TRUE., .FALSE./
      DATA LUNI, LUNO /28,29/
C-----------------------------------------------------------------------
      CALL COPY (256, CATNEW, CATBLK)
      CALL UVPGET (IRET)
      VISINC = CATBLK(KIGCN) / 10
      VISINC = MAX (20000, MIN (200000,VISINC))
      VISMSG = 3 * VISINC
C                                       Find weight and scale.
      ISCOMP = CATBLK(KINAX).EQ.1
      IF (ISCOMP) THEN
         CALL AXEFND (8, 'WEIGHT  ', CATBLK(KIPCN), CATH(KHPTP), ILOCWT,
     *      IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'ERROR FINDING WEIGHT FOR COMPRESSED DATA'
            IRET = 9
            GO TO 990
            END IF
         END IF
C                                       Open and init for read
C                                       visibility file
      CALL ZPHFIL ('UV', DISKIN(1), OLDCNO(1), 1, IFILE, IRET)
      CALL ZOPEN (LUNI, INDI, DISKIN(1), IFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN INPUT UV'
         GO TO 990
         END IF
C                                       Open vis file for write
      CALL ZPHFIL ('UV', DISKO, NEWCNO, 1, OFILE, IRET)
      CALL ZOPEN (LUNO, INDO, DISKO, OFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN OUTPUT UV'
         GO TO 990
         END IF
C                                       Init vis file for write
      NCOPY = LREC - NRPARM
      NCORO = (LREC - NRPARM) / CATBLK(KINAX)
      ILENBU = 0
      VO = 0
      BO = 1
      CALL UVINIT ('WRIT', LUNO, INDO, NVIS, VO, LREC, ILENBU,
     *   JBUFSZ, BUFF2, BO, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT OUTPUT UV'
         GO TO 990
         END IF
      IPTRO = KBIND
      NIOUT = 0
      NIOLIM = ILENBU
C                                       Init vis file for read.
      ILENBU = 0
      CALL UVINIT ('READ', LUNI, INDI, NVIS, VO, LREC, ILENBU,
     *   JBUFSZ, BUFF1, BO, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT INPUT UV'
         GO TO 990
         END IF
      NUMVIS = 0
C                                       make an index table
      CALL RNXGET (DISKIN, OLDCNO, CATOLD)
      CALL RNXINI (DISKO, NEWCNO, CATBLK, RNXRET)
C                                       Loop
C                                       Read vis. record.
 100     CALL UVDISK ('READ', LUNI, INDI, BUFF1, INIO, IBIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ', 'INPUT'
            GO TO 990
            END IF
         IPTRI = IBIND
         DO 190 I = 1,INIO
C                                       move random parameters
            CALL RCOPY (NRPARM, BUFF1(IPTRI), BUFF2(IPTRO))
C                                       compressed
            IF (ISCOMP) THEN
               CALL ZUVXPN (NCORO, BUFF1(IPTRI+NRPARM),
     *            BUFF1(IPTRI+ILOCWT), UBUFF)
               CALL SCALIT (MAXANS, MAXF, SUMP, BUFF2(IPTRO), UBUFF,
     *            IRET)
               IF (IRET.EQ.0) CALL ZUVPAK (NCORO, UBUFF,
     *            BUFF2(IPTRO+ILOCWT), BUFF2(IPTRO+NRPARM))
C                                       Decide if kept, select
            ELSE
               CALL SCALIT (MAXANS, MAXF, SUMP, BUFF2(IPTRO),
     *            BUFF1(IPTRI+NRPARM), IRET)
               IF (IRET.EQ.0) CALL RCOPY (NCOPY, BUFF1(IPTRI+NRPARM),
     *            BUFF2(IPTRO+NRPARM))
               END IF
            NUMVIS = NUMVIS + 1
            NIOUT = NIOUT + 1
C                                       progress
            IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
               WRITE (MSGTXT,1105) NUMVIS
               CALL MSGWRT (2)
            ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
               WRITE (MSGTXT,1105) NUMVIS
               CALL MSGWRT (1)
               END IF
C                                       update NX table
            CALL RNXUPD (BUFF2(IPTRO), RNXRET)
            IPTRI = IPTRI + LREC
            IPTRO = IPTRO + LREC
C                                       Write vis record.
            IF (NIOUT.GE.NIOLIM) THEN
               CALL UVDISK ('WRIT', LUNO, INDO, BUFF2, NIOLIM, KBIND,
     *            IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'WRIT OUTPUT UV'
                  GO TO 990
                  END IF
               IPTRO = KBIND
               NIOUT = 0
               END IF
 190        CONTINUE
         IF (INIO.GT.0) GO TO 100
C                                       Finish write
      NIOUT = - NIOUT
      CALL UVDISK ('FLSH', LUNO, INDO, BUFF2, NIOUT, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINISH OUTPUT UV'
         GO TO 990
         END IF
C                                       Compress output file.
      NVIS = NUMVIS
      CALL UCMPRS (NVIS, DISKO, NEWCNO, LUNO, CATBLK, IRET)
C                                       Close files
      CALL ZCLOSE (LUNI, INDI, IRET)
      CALL ZCLOSE (LUNO, INDO, IRET)
      IRET = 0
      CALL RNXCLS (RNXRET)
      IF (RNXRET.NE.0) THEN
         MSGTXT = 'OUTPUT NX TABLE, IF ANY, IS INCOMPLETE'
         GO TO 990
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLPCLO: ERROR',I4,' ON ',A)
 1105 FORMAT ('BLPCLO: at visibility record',I10)
      END
      SUBROUTINE SCALIT (MAXANS, MAXF, SUMP, RPARM, VIS, IRET)
C-----------------------------------------------------------------------
C   SCALIT scales the vis by the correction factors
C   Inputs:
C      MAXANS   I      Array dimension # antennas
C      MAXF     I      Array dimension Nchans * Nifs
C      SUMP1    R(*)   Solution polarization 1 - 4
C      SUMP2    R(*)   Solution polarization 2
C      RPARM    R(*)   Random parameters
C   In/out:
C      VIS      R(*)   Visibilities
C   Output:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   MAXANS, MAXF, IRET
      REAL      SUMP(4,MAXF,MAXANS,MAXANS), RPARM(*), VIS(3,*)
C
      INTEGER   IA1, IA2, LIF, LCH, NFREQ, LNCIF, LNCF, LNCS, INCX,
     *   NUMPOL, NUMIF, II, IND, LND, LP
      REAL      CR, CI, TR, TI
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
C-----------------------------------------------------------------------
      IRET = 0
      IF (ILOCB.GE.0) THEN
         IA2 = RPARM(1+ILOCB) + 0.01
         IA1 = IA2 / 256
         IA2 = IA2 - IA1*256
      ELSE
         IA1 = RPARM(1+ILOCA1) + 0.01
         IA2 = RPARM(1+ILOCA2) + 0.01
         END IF
      IF (JLOCIF.GT.0) THEN
         NUMIF = CATBLK(KINAX+JLOCIF)
      ELSE
         NUMIF  = 1
         END IF
      NFREQ = CATBLK(KINAX+JLOCF)
      INCX = CATBLK(KINAX)
      LNCIF = INCIF / INCX
      LNCF = INCF / INCX
      LNCS = INCS / INCX
      NUMPOL = CATBLK(KINAX+JLOCS)
C                                       cross-correlations only
C                                       first polarization
      IF (IA1.NE.IA2) THEN
         II = 0
         DO 30 LIF = 1,NUMIF
            IND = 1 + (LIF - 1) * LNCIF
            DO 20 LCH = 1,NFREQ
               II = II + 1
               LND = IND
               DO 10 LP = 1,NUMPOL
                  IF (VIS(3,LND).GT.0.0) THEN
                     CR = SUMP (LP, II, IA1, IA2)
                     CI = -SUMP (LP, II, IA2, IA1)
                     TR = CR * VIS(1,LND) + CI * VIS(2,LND)
                     TI = CR * VIS(2,LND) - CI * VIS(1,LND)
                     VIS(1,LND) = TR
                     VIS(2,LND) = TI
                     CR = CR * CR + CI * CI
                     IF (CR.GT.0.0) THEN
                        VIS(3,LND) = VIS(3,LND) / CR
                     ELSE
                        VIS(3,LND) = 0.0
                        END IF
                     END IF
                  LND = LND + LNCS
 10               CONTINUE
               IND = IND + LNCF
 20            CONTINUE
 30         CONTINUE
         END IF
C
 999  RETURN
      END
      SUBROUTINE BLPCLH
C-----------------------------------------------------------------------
C   BLPCLH copies and updates history file.  It also copies any tables.
C-----------------------------------------------------------------------
      INTEGER   LUN1, LUN2, IERR, NONOT
      CHARACTER NOTTYP*2 /'BD'/
      INCLUDE 'BLPCL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUN1, LUN2 /27,28/
      DATA NONOT, NOTTYP /1, 'BD'/
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       Copy/open history file.
      CALL HISCOP (LUN1, LUN2, DISKIN, DISKO, OLDCNO, NEWCNO, CATBLK,
     *   SCRBUF, BUFF2, IERR)
      IF (IERR.GT.2) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 100
         END IF
C                                       New history
      CALL HENCO1 (TSKNAM, NAMEIN(1), CLASIN(1), SEQIN(1), DISKIN(1),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO2 (TSKNAM, NAMEIN(2), CLASIN(2), SEQIN(2), DISKIN(2),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO3 (TSKNAM, NAMEIN(3), CLASIN(3), SEQIN(3), DISKIN(3),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      CALL HENCO4 (TSKNAM, NAMEIN(4), CLASIN(4), SEQIN(4), DISKIN(4),
     *   LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
      IF (ISVPOL) THEN
         CALL HENCO5 (TSKNAM, NAMEIN(5), CLASIN(5), SEQIN(5), DISKIN(5),
     *      LUN2, BUFF2, IERR)
         IF (IERR.NE.0) GO TO 100
         END IF
      CALL HENCOO (TSKNAM, NAMOUT, CLAOUT, SEQOUT, DISKO, LUN2, BUFF2,
     *   IERR)
      IF (IERR.NE.0) GO TO 100
C                                       calibration history
      CALL CALHIS (LUN2, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 100
C                                       Close HI file
 100  CALL HICLOS (LUN2, .TRUE., BUFF2, IERR)
C                                       Copy tables
      CALL ALLTAB (NONOT, NOTTYP, LUN1, LUN2, DISKIN, DISKO, OLDCNO,
     *   NEWCNO, CATBLK, BUFF1, BUFF2, IERR)
      IF (IERR.GT.2) THEN
         MSGTXT = 'BLPCLH: ERROR COPYING TABLES TO OUTPUT UV'
         CALL MSGWRT (6)
         END IF
C                                       Update CATBLK.
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, 'REST', SCRBUF, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLPCLH: ERROR',I3,' COPY/OPEN HISTORY FILE')
      END
      SUBROUTINE BLPCLC (NUMVIS, T, IA1, IA2, VIS, MODI, MODQ, MODU,
     *   MODV, RESULT)
C-----------------------------------------------------------------------
C   Computes moel value for V and H and divides that into the V and H
C   data
C   Inputs:
C      NUMVIS  I    Visibility number, -1 => final call, no data
C                   passed but allows any operations to be completed.
C      T       R    Time in days
C      IA1     I    First antenna number
C      IA2     I    Second antenna number
C      RPARM   R(*) Random parameter array which includes U,V,W etc
C                   but also any other random parameters.
C      VIS     R(3,*)  Visibilities in order real, imaginary, weight
C                   (Jy, Jy, unitless).  Weight <= 0 => flagged.
C      MODI    R(3,*)
C      MODI    R(3,*)
C      MODI    R(3,*)
C   Inputs from COMMON:
C      NRPARM     I       # random parameters.
C      NCOR       I       # correlators
C      CATBLK     I(256)  Catalog header record. See Going Aips for
C                         details.
C      NRPRMI     I    Input number of random parameters.
C      INCSI      I    Input Stokes' increment in vis.
C      INCFI      I    Input frequency increment in vis.
C      INCIFI     I    Input IF increment in vis.
C      LRECO      I    Output file record length
C      NRPRMO     I    Output number of random parameters.
C      INCSO      I    Output Stokes' increment in vis.
C      INCFO      I    Output frequency increment in vis.
C      INCIFO     I    Output IF increment in vis.
C   Output:
C      RESULT     R(3,*) Output visibilities selected in frequency.
C-----------------------------------------------------------------------
      INTEGER   NUMVIS, IA1, IA2
      REAL      T, VIS(3,*), MODI(3,*), MODQ(3,*), MODU(3,*),
     *   MODV(3,*), RESULT(3,*)
C
      INTEGER   JIF, JF, JS, NIF, NF, NS, INDEXO, INDEXI, IP
      REAL      PSIN, PCOS, LTIME, TEPS, MR(4), MI(4), DR, DI, WT, WTM
      INCLUDE 'BLPCL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DPDC.INC'
      SAVE LTIME
      DATA LTIME /-100./
C-----------------------------------------------------------------------
      IF (NUMVIS.GT.0) THEN
         TEPS = 0.95 / (24.0 * 3600.0)
         TIMIN = MIN (TIMIN, T)
         TIMAX = MAX (TIMAX, T)
C                                       Parallactic angle
         IF (ABS(T-LTIME).GT.TEPS) THEN
            CALL PARANG (T, PANGLE)
            LTIME = T
            END IF
C                                       pointers to traverse the data
         NS = 1
         NIF = 1
         NF = 1
         IF (JLOCS.GE.0) NS = CATBLK(KINAX+JLOCS)
         IF (JLOCIF.GE.0) NIF = CATBLK(KINAX+JLOCIF)
         IF (JLOCF.GE.0) NF = CATBLK(KINAX+JLOCF)
         IP = 0
         PCOS = COS (PANGLE(IA1) + PANGLE(IA2))
         PSIN = SIN (PANGLE(IA1) + PANGLE(IA2))
         DO 40 JIF = 1,NIF
            DO 30 JF = 1,NF
               IP = IP + 1
               IF (ISVPOL) THEN
                  MR(1) = MODI(1,IP) + MODV(1,IP)
                  MI(1) = MODI(2,IP) + MODV(2,IP)
                  MR(2) = MODI(1,IP) - MODV(1,IP)
                  MI(2) = MODI(2,IP) - MODV(1,IP)
               ELSE
                  MR(1) = MODI(1,IP)
                  MI(1) = MODI(2,IP)
                  MR(2) = MODI(1,IP)
                  MI(2) = MODI(2,IP)
                  END IF
               MR(3) = MODQ(1,IP) - MODU(2,IP)
               MI(3) = MODQ(2,IP) + MODU(1,IP)
               MR(4) = MODQ(1,IP) + MODU(2,IP)
               MI(4) = MODQ(2,IP) - MODU(1,IP)
               WTM = MIN (MODI(3,IP), MODQ(3,IP))
               WTM = MIN (WTM, MODU(3,IP))
               DO 20 JS = 1,NS
                  INDEXI = (JIF-1) * INCIFI + (JF-1) * INCFI +
     *               (JS-1) * INCSI + 1
                  INDEXO = (JIF-1) * INCIFO + (JF-1) * INCFO +
     *               (JS-1) * INCSO + 1
                  RESULT(1,INDEXO) = VIS(1,INDEXI)
                  RESULT(2,INDEXO) = VIS(2,INDEXI)
                  WT = MIN (WTM, VIS(3,INDEXI))
                  RESULT(3,INDEXO) = WT
                  IF (WT.GT.0) THEN
                     DR = RESULT(1,INDEXO)
                     DI = RESULT(2,INDEXO)
                     RESULT(1,INDEXO) = (DR*MR(JS) + DI * MI(JS)) /
     *                  (MR(JS)*MR(JS) + MI(JS)*MI(JS))
                     RESULT(2,INDEXO) = (DI*MR(JS) - DR*MI(JS)) /
     *                  (MR(JS)*MR(JS) + MI(JS)*MI(JS))
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
         END IF
C
 999  RETURN
      END
