LOCAL INCLUDE 'BASRM.INC'
C                                       Local include for BASRM
      INCLUDE 'INCS:ZPBUFSZ.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MMXSOU
C                                       MMXSOU = max number of sources
      PARAMETER (MMXSOU = 500)
      CHARACTER NAMEIN*12, CLAIN*6, NAMOUT*12, CLAOUT*6, HISCRD(6)*64
      HOLLERITH XNAMEI(3), XCLAIN(2), XNAMOU(3), XCLAOU(2)
      INTEGER   SEQIN, SEQOUT, DISKIN, DISKO, NUMHIS, JBUFSZ,
     *   CATOLD(256), FRQSEL, ILOCWT, CHNSEL(2,20,MAXIF), OLDCNO, NEWCNO
      LOGICAL   DOSCL, ISCOMP
      DOUBLE PRECISION XCOUNT(2)
      REAL      XSIN, XDISIN, XSOUT, XDISO, XBAND, XFREQ, XFQID,
     *   XCHNS(4,20), BUFF1(UVBFSL), BUFF2(UVBFSS), APARM(10)
      COMMON /BUFRS/ BUFF1, BUFF2, JBUFSZ
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XNAMOU, XCLAOU,
     *   XSOUT, XDISO, XBAND, XFREQ, XFQID, APARM, XCHNS
      COMMON /XTRPRM/ CATOLD, XCOUNT, SEQIN, SEQOUT, DISKIN, DISKO,
     *   FRQSEL, NUMHIS, DOSCL, ISCOMP, ILOCWT, CHNSEL, OLDCNO, NEWCNO
      COMMON /CHPARM/ NAMEIN, NAMOUT, CLAIN, CLAOUT, HISCRD
LOCAL END
      PROGRAM BASRM
C-----------------------------------------------------------------------
C! BASRM copies selected data from UV data base
C# Task UV Spectral
C-----------------------------------------------------------------------
C;  Copyright (C) 1995-1998, 2000, 2015-2016, 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   BASRM copies a database removing polynomial spectral baselines
C   from total power data.
C   Inputs:
C     AIPS adverb    Prg. name.          Description.
C       INNAME         NAMEIN        Name of input uv data.
C       INCLASS        CLAIN         Class of input uv data.
C       INSEQ          SEQIN         Seq. of input uv data.
C       INDISK         DISKIN        Disk number of input uv data.
C       OUTNAME        NAMOUT        Name of the output uv file.
C                                    Default output is input file.
C       OUTCLASS       CLAOUT        Class of the output uv file.
C       OUTSEQ         SEQOUT        Seq. number of output uv data.
C       OUTDISK        DISKO         Disk number of the output file.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER IRET
      INCLUDE 'BASRM.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA PRGM /'BASRM '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL COPYIN (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Call routine that sends data
C                                       to the user routine.
      CALL COPYUV (IRET)
      IF (IRET.NE.0) GO TO 990
      CALL COPYHI
C                                       Close down files, etc.
 990  CALL DIE (IRET, BUFF1)
C
 999  STOP
      END
      SUBROUTINE COPYIN (PRGN, JERR)
C-----------------------------------------------------------------------
C   COPYIN gets input parameters for COPY and creates an output file
C   if necessary.  Also set the parameters which are used to select
C   data.
C   Inputs:  PRGN    C*6       Program name
C   Output:  JERR    I         Error code: 0 => ok
C                                5 => catalog troubles
C                                6 => too much data to select ch.
C                                8 => can't start
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C      FRQSEL     I    Freq ID sel, .le. 0 => all
C      DOSCL      L    If true rescale u,v,w
C      ISCMP      L    If .TRUE. then data is compressed
C----------------------------------------------------------------------
      CHARACTER STAT*4, PRGN*6, BLANK*6, UTYPE*2
      INTEGER   JERR, ITEMP, I, J, IROUND, NPARM, IERR, NUMAN(513),
     *   ISUB, LUNAN, LUNI
      REAL      SELBAN
      DOUBLE PRECISION SELFRQ
      LOGICAL   T, F, MATCH
      INCLUDE 'BASRM.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   IBUFF(UVBFSS), NW(MAXIF), NCHAN, K, K1, K2
C
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      EQUIVALENCE (BUFF1, IBUFF)
      DATA BLANK /'      '/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (T)
      CALL VHDRIN
      JBUFSZ = UVBFSS * 2
      NUMHIS = 0
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 107
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, BUFF1, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Hollerith -> char
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (12, 1, XNAMOU, NAMOUT)
      CALL H2CHR (6, 1, XCLAOU, CLAOUT)
C                                       Crunch input parameters
      SEQIN = IROUND (XSIN)
      SEQOUT = IROUND (XSOUT)
      DISKIN = IROUND (XDISIN)
      DISKO = IROUND (XDISO)
C                                       Create new file.
C                                       Get CATBLK from old file.
      OLDCNO = 1
      UTYPE = 'UV'
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN, UTYPE,
     *   NLUSER, STAT, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      NLUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'REST', BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR
         GO TO 990
         END IF
C                                       Compressed data?
      ISCOMP = CATBLK(KINAX).EQ.1
      IF (ISCOMP) THEN
C                                       Find weight and scale.
         CALL AXEFND (8, 'WEIGHT  ', CATBLK(KIPCN), CATH(KHPTP), ILOCWT,
     *      JERR)
         IF (JERR.NE.0) THEN
            MSGTXT = 'ERROR FINDING WEIGHT FOR COMPRESSED DATA'
            JERR = 9
            GO TO 990
            END IF
         END IF
C                                       Get uv header info.
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
C                                       Channel selection
      NCHAN = CATBLK(KINAX+JLOCF)
      I = 40 * MAXIF
      CALL FILL (I, 0, CHNSEL)
      CALL FILL (MAXIF, 0, NW)
      DO 40 J = 1,20
         K = IROUND (XCHNS(2,J))
         IF (K.GT.0) THEN
            K = IROUND (XCHNS(4,J))
            IF ((K.LE.0) .OR. (K.GT.MAXIF)) THEN
               K1 = 1
               K2 = MAXIF
            ELSE
               K1 = K
               K2 = K
               END IF
            DO 35 K = K1,K2
               NW(K) = NW(K) + 1
               DO 30 I = 1,2
                  CHNSEL(I,NW(K),K) = IROUND (XCHNS(I,J))
                  IF (CHNSEL(I,NW(K),K).LT.0) CHNSEL(I,NW(K),K) = 0
 30               CONTINUE
 35            CONTINUE
            END IF
 40      CONTINUE
      DO 50 K = 1,MAXIF
         IF (NW(K).LE.0) THEN
            NW(K) = 1
            CHNSEL(1,1,K) = (NCHAN+1)/8 + 1
            CHNSEL(2,1,K) = NCHAN - ((NCHAN+1)/8)
            END IF
         DO 45 I = 1,NW(K)
            CHNSEL(1,I,K) = MAX (1, MIN (CHNSEL(1,I,K), NCHAN))
            IF (CHNSEL(2,I,K).LT.CHNSEL(1,I,K))
     *         CHNSEL(2,I,K) = NCHAN
            CHNSEL(2,I,K) = MAX (1, MIN (CHNSEL(2,I,K), NCHAN))
 45         CONTINUE
 50      CONTINUE
C                                       Save old CATBLK
      CALL COPY (256, CATBLK, CATOLD)
C                                       Freq id
      IF (ILOCFQ.GE.0) THEN
         SELBAN = XBAND
         SELFRQ = XFREQ
         FRQSEL = IROUND (XFQID)
       ELSE
          SELBAN = 0.
          SELFRQ = 0.
          FRQSEL = 0
          END IF
      IF (FRQSEL.LE.0) FRQSEL = -1
      IF ((SELBAN.GT.0.0) .OR. (SELFRQ.GT.0.0)) THEN
         LUNI = 28
         CALL FQMATC (DISKIN, OLDCNO, CATOLD, LUNI, SELBAN, SELFRQ,
     *      MATCH, FRQSEL, JERR)
         IF (.NOT.MATCH) THEN
            WRITE (MSGTXT,1070)
            JERR = 1
            GO TO 990
            END IF
         IF (JERR.GT.0) GO TO 999
         END IF
      XCOUNT(2) = 0.0D0
C                                       Put new values in CATBLK.
      CALL MAKOUT (NAMEIN, CLAIN, SEQIN, BLANK, NAMOUT,CLAOUT, SEQOUT)
      CALL CHR2H (12, NAMOUT, KHIMNO, CATH(KHIMN))
      CALL CHR2H (6, CLAOUT, KHIMCO, CATH(KHIMC))
      CATBLK(KIIMS) = SEQOUT
C                                       Create output file.
      NEWCNO = 1
      FRW(NCFILE+1) = 3
      JERR = 4
      CALL UVCREA (DISKO, NEWCNO, BUFF1, IERR)
C
      CATBLK(KIGCN) = ITEMP
      IF (IERR.NE.0) THEN
         IF (IERR.EQ.2) GO TO 60
            WRITE (MSGTXT,1050) IERR
            GO TO 990
C                                       Only overwrite Input file
C                                       no destroy existing otherwise
 60      IF ((NEWCNO.NE.OLDCNO) .OR. (DISKO.NE.DISKIN)) THEN
            WRITE (MSGTXT,1060)
            IF ((NEWCNO.NE.OLDCNO) .OR. (DISKO.NE.DISKIN))
     *         WRITE (MSGTXT,1061)
            GO TO 990
            END IF
C                                       Recover existing CATBLK
         FRW(NCFILE+1) = 2
         CALL CATIO ('READ', DISKO, NEWCNO, CATBLK, 'WRIT', BUFF1, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1065) IERR
            CALL MSGWRT (6)
            END IF
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKO
      FCNO(NCFILE) = NEWCNO
      FRW(NCFILE) = FRW(NCFILE) - 1
C                                        Put input file in READ
      UTYPE = 'UV'
      CALL CATDIR ('CSTA', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN, UTYPE,
     *   NLUSER, 'READ', BUFF1, IERR)
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = OLDCNO
      FRW(NCFILE) = 0
      JERR = 0
C                                       Copy any header keywords
      CALL KEYCOP (DISKIN, OLDCNO, DISKO, NEWCNO, IERR)
      IF (IERR.NE.0) GO TO 999
      SEQOUT = CATBLK(KIIMS)
      XCOUNT(1) = 0.0D0
C                                       get subarray info
      ISUB = 0
      LUNAN = 20
      CALL GETNAN (DISKIN, OLDCNO, CATOLD, LUNAN, BUFF1, NUMAN, IERR)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('COPYIN: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,
     *   ' DISK=',I3,' USID=',I5)
 1040 FORMAT ('ERROR',I3,' COPYING CATBLK ')
 1050 FORMAT ('ERROR',I3,' CREATING OUTPUT FILE')
 1060 FORMAT ('MAY NOT OVERWRITE INPUT FILE IF DELETING SUBARRAYS')
 1061 FORMAT ('MAY OVERWRITE INPUT FILE ONLY.  QUITTING')
 1065 FORMAT ('COPYIN: ERROR',I3,' UPDATING NEW CATBLK')
 1070 FORMAT ('NO MATCH TO SELBAND/SELFREQ ADVERBS - CHECK INPUTS')
      END
      SUBROUTINE COPYUV (IRET)
C-----------------------------------------------------------------------
C   COPYUV sends uv data one point at a time to the time check routine
C   and then writes the modified data if requested.
C   Output: IRET   I    Return code, 0 => OK, otherwise abort.
C                       9 => output record size exceeds input.
C-----------------------------------------------------------------------
      CHARACTER OFILE*48, IFILE*48
      INTEGER   IRET, INIO, IPTRI, IPTRO, LUNI, LUNO, LENBU, INDI, INDO,
     *   LRECO, I, ILENBU, KBIND, NIOUT, NIOLIM, IBIND, INCX, VO, BO,
     *   NUMVIS, RNXRET
      LOGICAL   T, F, DOARR
      INCLUDE 'BASRM.INC'
      REAL      CBUFF(UVBFSS)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA LUNI, LUNO /16, 17/
      DATA VO, BO, LENBU /0, 1, 32/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Set length of complex axis
      INCX = CATBLK(KINAX)
C                                       Open and init for read
C                                       visibility file
      CALL ZPHFIL ('UV', DISKIN, FCNO(NCFILE), 1, IFILE, IRET)
      CALL ZOPEN (LUNI, INDI, DISKIN, IFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET
         GO TO 990
         END IF
C                                       Open vis file for write
      CALL ZPHFIL ('UV', DISKO, NEWCNO, 1, OFILE, IRET)
      CALL ZOPEN (LUNO, INDO, DISKO, OFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1010) IRET
         GO TO 990
         END IF
C                                       Init vis file for write
C                                       LRECO = length of output rec.
      LRECO = CATBLK(KINAX)
      DO 30 I = 2,KICTPN
         LRECO = LRECO * MAX (1, CATBLK(KINAX+I-1))
 30      CONTINUE
      LRECO = LRECO + NRPARM
C                                       Make sure LREC >= LRECO
      IF (LREC.LT.LRECO) THEN
         WRITE (MSGTXT,1030) LRECO, LREC
         IRET = 9
         GO TO 990
         END IF
      ILENBU = 0
      CALL UVINIT ('WRIT', LUNO, INDO, NVIS, VO, LRECO, ILENBU, JBUFSZ,
     *   BUFF2, BO, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1040) IRET
         GO TO 990
         END IF
      IPTRO = KBIND
      NIOUT = 0
      NIOLIM = ILENBU
C                                       Init vis file for read.
      ILENBU = 0
      CALL UVINIT ('READ', LUNI, INDI, NVIS, VO, LREC, ILENBU, JBUFSZ,
     *   BUFF1, BO, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1060) IRET
         GO TO 990
         END IF
      NUMVIS = 0
      DOARR = .FALSE.
C                                       make an index table
      CALL RNXGET (DISKIN, OLDCNO, CATOLD)
      CALL RNXINI (DISKO, NEWCNO, CATBLK, RNXRET)
C                                       Loop
C                                       Read vis. record.
 100     CALL UVDISK ('READ', LUNI, INDI, BUFF1, INIO, IBIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1100) IRET
            GO TO 990
            END IF
         IPTRI = IBIND
         IF (INIO.LE.0) GO TO 200
         DO 190 I = 1,INIO
            NUMVIS = NUMVIS + 1
C                                       Decide if it's kept, select
            IF (ISCOMP) THEN
               CALL ZUVXPN (NCOR, BUFF1(IPTRI+NRPARM),
     *            BUFF1(IPTRI+ILOCWT), CBUFF)
               CALL COPYIT (NUMVIS, CBUFF, BUFF1(IPTRI), DOARR, IRET)
            ELSE
               CALL COPYIT (NUMVIS, BUFF1(IPTRI+NRPARM), BUFF1(IPTRI),
     *            DOARR, IRET)
               END IF
C                                       Error (fatal)
            IF (IRET.GT.0) THEN
               WRITE (MSGTXT,1120) IRET
               GO TO 990
C                                       Copy to output.
            ELSE IF (IRET.EQ.0) THEN
C                                       update NX table
               CALL RNXUPD (BUFF1(IPTRI), RNXRET)
               IF (ISCOMP) THEN
                  CALL RCOPY (NRPARM, BUFF1(IPTRI), BUFF2(IPTRO))
                  CALL ZUVPAK (NCOR, CBUFF, BUFF2(IPTRO+ILOCWT),
     *               BUFF2(IPTRO+NRPARM))
               ELSE
                  CALL RCOPY (LRECO, BUFF1(IPTRI), BUFF2(IPTRO))
                  END IF
               IPTRO = IPTRO + LRECO
               NIOUT = NIOUT + 1
               END IF
C                                       OK, but no output please
            IPTRI = IPTRI + LREC
C                                       Write vis record.
            IF (NIOUT.GE.NIOLIM) THEN
               CALL UVDISK ('WRIT', LUNO, INDO, BUFF2, NIOLIM, KBIND,
     *            IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1140) IRET
                  GO TO 990
                  END IF
               IPTRO = KBIND
               NIOUT = 0
               END IF
 190        CONTINUE
         GO TO 100
C                                       Final call to COPYIT
 200     NUMVIS = -1
         CALL COPYIT (NUMVIS, BUFF1, BUFF1, DOARR, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1120) IRET
            GO TO 990
            END IF
C                                       Finish write
      NIOUT = - NIOUT
      CALL UVDISK ('FLSH', LUNO, INDO, BUFF2, NIOUT, KBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1140) IRET
         GO TO 990
         END IF
C                                       Compress output file.
      NVIS = XCOUNT(1) + 0.01
      CALL UCMPRS (NVIS, DISKO, NEWCNO, LUNO, CATBLK, IRET)
C                                       Close files
      CALL ZCLOSE (LUNI, INDI, IRET)
      CALL ZCLOSE (LUNO, INDO, IRET)
      IRET = 0
      CALL RNXCLS (RNXRET)
      IF (RNXRET.NE.0) THEN
         MSGTXT = 'OUTPUT NX TABLE, IF ANY, IS INCOMPLETE'
         GO TO 990
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('COPYUV: ERROR',I3,' OPEN-FOR-WRITE VIS FILE')
 1010 FORMAT ('COPYUV: ERROR',I3,' OPEN-FOR-READ VIS FILE')
 1030 FORMAT ('COPYUV: LRECO=',I4,'.GT. LREC=',I4)
 1040 FORMAT ('COPYUV: ERROR',I3,' INIT-FOR-WRITE VIS FILE')
 1060 FORMAT ('COPYUV: ERROR',I3,' INIT-FOR-READ VIS FILE')
 1100 FORMAT ('COPYUV: ERROR',I3,' READING VIS FILE')
 1120 FORMAT ('COPYUV: COPYIT ERROR',I3)
 1140 FORMAT ('COPYUV: ERROR',I3,' WRITING VIS FILE')
      END
      SUBROUTINE COPYHI
C-----------------------------------------------------------------------
C   COPYHI copies and updates history file for COPY
C-----------------------------------------------------------------------
      CHARACTER NOTTYP(1)*2, HILINE*72,  LABEL*8
      INTEGER   LUN1, LUN2, I, J, IERR, NONOT, ICH(4), IROUND
      LOGICAL   T, F, DOIT
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'BASRM.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DANT.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA LUN1, LUN2 /27,28/
      DATA T, F /.TRUE.,.FALSE./
      DATA NONOT, NOTTYP /0,'  '/
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       Copy/open history file.
      CALL HISCOP (LUN1, LUN2, DISKIN, DISKO, FCNO(NCFILE),
     *   FCNO(NCFILE-1), CATBLK, BUFF1, BUFF2, IERR)
      IF (IERR.GT.2) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 200
         END IF
C                                       New history
      CALL HENCO1 (TSKNAM, NAMEIN, CLAIN, SEQIN, DISKIN, LUN2, BUFF2,
     *   IERR)
      IF (IERR.NE.0) GO TO 200
      CALL HENCOO (TSKNAM, NAMOUT, CLAOUT, SEQOUT, DISKO, LUN2,
     *   BUFF2, IERR)
      IF (IERR.NE.0) GO TO 200
C                                       APARM
      I = IROUND (APARM(1))
      WRITE (HILINE,1010) TSKNAM, I
      CALL HIADD (LUN2, HILINE, BUFF2, IERR)
      IF (IERR.NE.0) GO TO 200
      IF (APARM(2).GT.0.0) THEN
         WRITE (HILINE,1011) TSKNAM
         CALL HIADD (LUN2, HILINE, BUFF2, IERR)
         IF (IERR.NE.0) GO TO 200
         END IF
C                                       ICHANSEL
      DO 20 J = 1,20
         DOIT = .FALSE.
         DO 15 I = 1,4
            ICH(I) = IROUND (XCHNS(I,J))
            DOIT = DOIT .OR. (ICH(I).GT.0)
 15         CONTINUE
         IF (DOIT) THEN
            WRITE (HILINE,1012) TSKNAM, J, ICH
            CALL HIADD (LUN2, HILINE, BUFF2, IERR)
            IF (IERR.NE.0) GO TO 200
            END IF
 20      CONTINUE
C                                       Add history from COPYIT
      IF (NUMHIS.GE.1) THEN
         LABEL = TSKNAM // '/ '
         HILINE(1:8) = LABEL(1:8)
         DO 190 I = 1,NUMHIS
            HILINE(9:64) = HISCRD(I)(1:64)
            CALL HIADD (LUN2, HILINE, BUFF2, IERR)
            IF (IERR.NE.0) GO TO 200
 190        CONTINUE
         END IF
C                                       Close HI file
 200  CALL HICLOS (LUN2, T, BUFF2, IERR)
C                                       Copy tables
      CALL ALLTAB (NONOT, NOTTYP, LUN1, LUN2, DISKIN, DISKO, FCNO(2),
     *   FCNO(1), CATBLK, BUFF1, BUFF2, IERR)
      IF (IERR.GT.2) THEN
         WRITE (MSGTXT,1020)
         CALL MSGWRT (6)
         END IF
C                                        Update CATBLK.
      CALL CATIO ('UPDT', DISKO, FCNO(NCFILE-1), CATBLK, 'REST', BUFF1,
     *   IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('COPYHI: ERROR',I3,' COPY/OPEN HISTORY FILE')
 1010 FORMAT (A6,'APARM(1) =',I3,'   / polynomial order')
 1011 FORMAT (A6,'/  output is the fit polynomials not the data')
 1012 FORMAT (A6,'ICHANSEL(*,',I2.2,')=',2I6,2I3,'  / channels for fit')
 1020 FORMAT ('COPYHI: ERROR COPYING TABLES')
      END
      SUBROUTINE COPYIT (NUMVIS, VIS, RPARM, DONARR, IRET)
C-----------------------------------------------------------------------
C   COPYIT returns cross correlation data unchanged and removes a fit
C   baseline from autocorrelation data.  Variables  XCOUNT(1) as a
C   counter of vis.
C   Inputs:
C      NUMVIS     I    Visibility number, -1 => final call, no data
C                      passed but allows any operations to be completed
C   In/Out:
C      VIS(3,*)   R    VIS record; RE, IM, WT for NTCOR samples
C      RPARM(*)   R    Random parameter array. When a single FQ ID
C                      is copied the FQ r.p in this array is changed.
C      DONARR     L    T -> an array > 1 has been dropped
C   Inputs from COMMON
C      CATBLK(256)I    Catalog header record. See [DOC]HEADER.
C      DOBOTH     L    Both xc & ac data copyied
C      CHNSEL     I(*) selects channels by IFs
C   Output:
C      VIS        R    Visibilities possibly with some flagged
C      IRET       I    Return code  -1 => do not write
C                                0 => OK
C                               >0 => error, terminate.
C   Output in COMMON
C      NUMHIS     I    # history entries (max. 10)
C      HISCRD(16,NUMHIS) R   History records
C      CATBLK     I    Catalog header block
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      LOGICAL   DONARR
      INTEGER   NUMVIS, IRET
      REAL      VIS(3,*), RPARM(*)
C
      REAL      BFIT(11), XI, TPLATE(MAXCHA), SIGMA
      INTEGER   IA1, IA2, IROUND, K, J, JIF, JF, JS, NIF, NF, NS, NP,
     *   INDEXI, I
      INCLUDE 'BASRM.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      IRET = 0
C                                       Select data
      IF (NUMVIS.GT.0) THEN
C                                       Data type
         XCOUNT(1) = XCOUNT(1) + 1.D0
         IF (ILOCB.GE.0) THEN
            IA1 = RPARM(1+ILOCB) / 256.0 + 0.1
            IA2 = RPARM(1+ILOCB) - IA1 * 256.0 + 0.1
         ELSE
            IA1 = RPARM(1+ILOCA1) + 0.1
            IA2 = RPARM(1+ILOCA2) + 0.1
            END IF
         IRET = 0
         IF (IA1.NE.IA2) GO TO 999
         NS = 1
         NIF = 1
         NF = 1
         IF (JLOCS.GE.0) NS = CATBLK(KINAX+JLOCS)
         IF (JLOCIF.GE.0) NIF = CATBLK(KINAX+JLOCIF)
         IF (JLOCF.GE.0) NF = CATBLK(KINAX+JLOCF)
         DO 60 JIF = 1,NIF
            DO 50 JS = 1,NS
               DO 20 JF = 1,NF
                  INDEXI = (JIF-1) * INCIF + (JF-1) * INCF +
     *               (JS-1) * INCS
                  INDEXI = (INDEXI / 3) + 1
                  TPLATE(JF) = FBLANK
                  IF (VIS(3,INDEXI).GT.0.0) TPLATE(JF) = VIS(1,INDEXI)
 20               CONTINUE
               NP = IROUND(APARM(1))
               CALL BLINE (TPLATE, NF, NP, CHNSEL(1,1,JIF), BFIT, SIGMA,
     *            IRET)
               IF (IRET.EQ.0) THEN
                  IF (APARM(3).GT.0.0) THEN
                     WRITE (MSGTXT,1499) IA1, JIF, JS, SIGMA
                     CALL MSGWRT (4)
                     J = MIN (5, NP+1)
                     WRITE (MSGTXT,1500) (BFIT(I), I = 1,J)
                     CALL MSGWRT (4)
                     IF (J.LT.NP+1) THEN
                        WRITE (MSGTXT,1501) (BFIT(I), I = J+1,NP+1)
                        CALL MSGWRT (4)
                        END IF
                     END IF
                  IF (APARM(2).GT.0.0) THEN
                     J = NP + 1
                     DO 30 I = 1,NF
                        XI = I
                        TPLATE(I) = BFIT(1)
                        DO 25 K = 2,J
                           TPLATE(I) = TPLATE(I) + BFIT(K) * (XI**(K-1))
 25                        CONTINUE
 30                     CONTINUE
                     END IF
                  DO 40 JF = 1,NF
                     INDEXI = (JIF-1) * INCIF + (JF-1) * INCF +
     *                  (JS-1) * INCS
                     INDEXI = (INDEXI / 3) + 1
                     VIS(1,INDEXI) = TPLATE(JF)
 40                  CONTINUE
               ELSE
                  XCOUNT(2) = XCOUNT(2) + 1.0
                  DO 45 JF = 1,NF
                     INDEXI = (JIF-1) * INCIF + (JF-1) * INCF +
     *                  (JS-1) * INCS
                     INDEXI = (INDEXI / 3) + 1
                     VIS(3,INDEXI) = -1.0
 45                  CONTINUE
                  END IF
 50            CONTINUE
 60         CONTINUE
C                                        History cards
      ELSE
         WRITE (MSGTXT,1201)
         CALL MSGWRT (4)
         HISCRD(1)(1:64) = MSGTXT(1:64)
         WRITE (MSGTXT,1203)
         CALL MSGWRT (4)
         HISCRD(2)(1:64) = MSGTXT(1:64)
         WRITE (MSGTXT,1204) XCOUNT(1)
         CALL MSGWRT (4)
         HISCRD(3)(1:64) = MSGTXT(1:64)
         NUMHIS = 3
         IF (DONARR) THEN
            WRITE (MSGTXT,1207)
            CALL MSGWRT (4)
            NUMHIS = NUMHIS + 1
            HISCRD(NUMHIS)(1:64) = MSGTXT(1:64)
            END IF
         IF (XCOUNT(2).GT.0.0) THEN
            NUMHIS = NUMHIS + 1
            WRITE (MSGTXT,1208) XCOUNT(2)
            CALL MSGWRT (4)
            HISCRD(NUMHIS) = MSGTXT(:64)
            END IF
C                                       error check
         IF (XCOUNT(1).LE.0.0) IRET = 8
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1201 FORMAT ('Copied from the beginning')
 1203 FORMAT ('        to  the end')
 1204 FORMAT ('Copied',F10.0,' vis records')
 1207 FORMAT ('Dropped subarray designations > 1')
 1208 FORMAT ('Flagged out',F10.0,' whole spectra')
 1499 FORMAT ('BFIT: ANTENNA',I4,'  IF',I3,'  POL',I2'  rms',F7.4)
 1500 FORMAT ('BFIT',5(1PE12.2))
 1501 FORMAT ('    ',5(1PE12.2))
      END
      SUBROUTINE BLINE (ACSPEC, NUMFRQ, NP, BASE, BFIT, SIGMA, IRET)
C-----------------------------------------------------------------------
C  Routine BLINE fits a polynomial baseline to spectra. The
C  fitted parameters are returned and the data is returned
C  with the baseline removed.
C  The routine assumes that only one IF/POLZN is passed down.
C  The calling routine must call BLINE over a loop of # IF's
C  and # polzns.
C
C  Inputs:
C     ACSPEC(*)      R        Input spectrum
C     NUMFRQ         I        # freq. channels in the spectrum
C     NP             I        The degree of polynomial to fit
C     BASE(2,20)     I        Array of start and stop channel
C                             numbers specifying the channels
C                             to be used for fitting
C  Outputs:
C     ACSPEC(*)      R        Output spectrum
C     BFIT(11)       R        The fitted parameters
C     IRET           I        Error code: 0 => OK
C                                         1 => error
C-----------------------------------------------------------------------
      REAL    ACSPEC(*), BFIT(11), SIGMA
      INTEGER NUMFRQ, NP, BASE(2,20), IRET
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER IB, IBB, IBB1, I, NCHNLS, J, N
      DOUBLE PRECISION XB(MAXCHA), YB(MAXCHA), WT(MAXCHA), YBAVG, TEMP,
     *   VARRES, X, DFIT(11)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      IRET = 0
      NCHNLS = 0
C                                       Check channel ranges
      DO 100 IB = 1,20
         IF (BASE(1,IB).LT.0 .OR. BASE(2,IB).LT.0) THEN
            IRET = 1
            WRITE (MSGTXT,1000) BASE(1,IB), BASE(2,IB)
            GO TO 990
            END IF
         IF (BASE(1,IB).GT.NUMFRQ .OR. BASE(2,IB).GT.NUMFRQ) THEN
            IRET = 1
            WRITE (MSGTXT,1010) BASE(1,IB), BASE(2,IB), NUMFRQ
            GO TO 990
            END IF
         IF (BASE(2,IB).LT.BASE(1,IB)) THEN
            IRET = 1
            WRITE (MSGTXT,1020) BASE(1,IB), BASE(2,IB)
            GO TO 990
            END IF
C                                       Select data
         IBB = BASE(1,IB)
         IBB1 = BASE(2,IB)
         IF ((IBB.GT.0) .AND. (IBB1.GT.0)) THEN
            DO 50 I = IBB,IBB1
               IF (ACSPEC(I).NE.FBLANK) THEN
                  NCHNLS = NCHNLS + 1
                  XB(NCHNLS) = I
                  YB(NCHNLS) = ACSPEC(I)
                  WT(NCHNLS) = 1.0D0
                  END IF
 50            CONTINUE
            END IF
 100     CONTINUE
C                                       Jump out if nothing to fit
      IF (NCHNLS.LE.0) GO TO 999
C                                       Special case, NP = 0
      IF (NP.EQ.0) THEN
         YBAVG = 0.0
         DO 110 I = 1,NCHNLS
            YBAVG = YBAVG + YB(I)
 110        CONTINUE
         YBAVG = YBAVG / NCHNLS
         DO 150 I = 1,NUMFRQ
            IF (ACSPEC(I).NE.FBLANK) ACSPEC(I) = ACSPEC(I) - YBAVG
 150        CONTINUE
         BFIT(1) = YBAVG
         GO TO 999
         END IF
C                                       Set up for polynomial fit
      N = NP + 1
      CALL DFITPN (XB, YB, WT, N, NCHNLS, DFIT, VARRES, IRET)
C      CALL POLINO (XB, YB, N, NCHNLS, BFIT, VARRES, IRET)
      IF (IRET.EQ.0) THEN
C                                       Subtract baseline from data
         DO 700 I = 1,NUMFRQ
            TEMP = 0.0
            X = I
            DO 650 J = 1,N
               TEMP = TEMP + DFIT(J) * X**(J-1)
  650          CONTINUE
            IF (ACSPEC(I).NE.FBLANK) ACSPEC(I) = ACSPEC(I) - TEMP
  700       CONTINUE
         DO 710 J = 1,N
            BFIT(J) = DFIT(J)
 710        CONTINUE
         SIGMA = VARRES
      ELSE
         WRITE (MSGTXT,1700) IRET, 'RETURNED FROM POLYNOMIAL FITTER'
         GO TO 990
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (6)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BLINE: BASELINE CHN SELECTION = ',2I5,' CHECK BPARMS')
 1010 FORMAT ('BLINE: BASELINE CHN SELECTION = ',2I5,' NUMFRQ = ',I5)
 1020 FORMAT ('BLINE: BASELINE CHN SELECTION = ',2I5,' INVERTED??')
 1700 FORMAT ('BLINE: ERROR',I5,' ON ',A)
      END
