      SUBROUTINE EXTLAB (XANT, XBASL)
C-----------------------------------------------------------------------
C! does ANTENNAS with BASELINE for EXTLIST
C# POPS-appl Plot-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
      REAL      XANT(50), XBASL(50)
C
      INTEGER   NANT1, NANT2, IANT1(50), IANT2(50), IROUND, JTRIM, J, I,
     *   NA, IX, IY
      LOGICAL   DESEL
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      NANT1 = 0
      NANT2 = 0
      DESEL = .FALSE.
      CALL FILL (50, 0, IANT1)
      CALL FILL (50, 0, IANT2)
      DO 20 I = 1,50
         J = IROUND (XANT(I))
         IF ((NANT1.GT.0) .AND. (J.EQ.IANT1(NANT1))) J = 0
         IF (J.NE.0) THEN
            NANT1 = NANT1 + 1
            IANT1(NANT1) = ABS (J)
            IF (J.LT.0) DESEL = .TRUE.
         END IF
         J = IROUND (XBASL(I))
         IF ((NANT2.GT.0) .AND. (J.EQ.IANT2(NANT2))) J = 0
         IF (J.NE.0) THEN
            NANT2 = NANT2 + 1
            IANT2(NANT2) = ABS (J)
            IF (J.LT.0) DESEL = .TRUE.
         END IF
 20      CONTINUE
C                                       print them - all
      MSGTXT = ' '
      IF ((NANT1.LE.0) .AND. (NANT2.LE.0)) THEN
         MSGTXT(13:) = 'All antenna pairs included'
         CALL MSGWRT (5)
C                                       by ones
      ELSE IF ((NANT1.LE.1) .AND. (NANT2.LE.1)) THEN
         WRITE (MSGTXT,1020) IANT1(1), IANT2(1)
         IF (IANT1(1).EQ.0) MSGTXT(31:32) = '**'
         IF (IANT2(1).EQ.0) MSGTXT(39:40) = '**'
         IF (DESEL) MSGTXT(41:) = ' deselected'
         CALL MSGWRT (5)
C                                       individually
      ELSE
         IF (NANT1.LE.0) THEN
            MSGTXT(13:) = 'All antennas'
            IF (DESEL) MSGTXT(13:) = 'Deselect all antennas'
            CALL MSGWRT (5)
         ELSE
            IY = 0
            IF (DESEL) THEN
               NA = 12
               MSGTXT(13:) = 'Deselect ants'
            ELSE
               MSGTXT(13:) = 'ants'
               NA = 15
               END IF
            J = JTRIM (MSGTXT) + 1
 30         IX = IY + 1
            IF (IX.LE.NANT1) THEN
               IY = MIN (IX+NA, NANT1)
               WRITE (MSGTXT(J:),1030) (IANT1(I), I = IX,IY)
               CALL MSGWRT (5)
               GO TO 30
               END IF
            END IF
         IF (NANT2.LE.0) THEN
            MSGTXT = ' '
            MSGTXT(13:) = 'With all antennas'
            CALL MSGWRT (5)
         ELSE
            IY = 0
 40         IX = IY + 1
            IF (IX.LE.NANT2) THEN
               IY = MIN (IX+15, NANT2)
               WRITE (MSGTXT,1040) (IANT2(I), I = IX,IY)
               CALL MSGWRT (5)
               GO TO 40
               END IF
            END IF
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT (12X,'antenna',I3,' with',I3)
 1030 FORMAT (16I3.2)
 1040 FORMAT (12X,'with',16I3.2)
      END
