      PROGRAM CDFIX
C-----------------------------------------------------------------------
C! Looks at catalog header second records and can zero them
C# Utility Catalog
C-----------------------------------------------------------------------
C;  Copyright (C) 2020
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   A service routine to debug catalog file disk contents
C-----------------------------------------------------------------------
      CHARACTER PHNAME*48, MSGBUF*80, PRGNAM*6, ASTR*4, HSTR*8
      INTEGER   IVOL, IBUF(256), TTYLUN, TTYIND, IERR, HLUN, HIND, IREC,
     *   TTY(2), IDAT(3), NC, JTRIM, I, J, ICNO
      DOUBLE PRECISION DBUF(128)
      REAL      RBUF(256)
      HOLLERITH HBUF(256)
      LOGICAL   T, F
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      EQUIVALENCE (IREC, IDAT(1))
      EQUIVALENCE (TTY(1), TTYLUN),  (TTY(2), TTYIND)
      EQUIVALENCE (IBUF, RBUF, HBUF, DBUF)
      DATA PRGNAM /'CDFIX '/
      DATA T, F /.TRUE.,.FALSE./
      DATA TTYLUN, HLUN /5, 16/
C-----------------------------------------------------------------------
      CALL AIPINI (TTY, PRGNAM, IERR)
      IF (IERR.NE.0) GO TO 990
      MSGTXT = 'I look at disk file contents'
      CALL MSGWRT (2)
C                                       Loop to ask for vol, cat #s
 10   MSGBUF = 'Enter user, disk, catalog number (0 0 0 to quit)'
      CALL INQINT (TTY, MSGBUF, 3, IDAT, IERR)
      IF (IERR.GT.0) GO TO 990
      IF (IERR.LT.0) GO TO 995
      IF (IDAT(1).LE.0) GO TO 995
      NLUSER = IDAT(1)
      IVOL = IDAT(2)
      ICNO = IDAT(3)
      CALL ZPHFIL ('CB', IVOL, ICNO, 1, PHNAME, IERR)
C                                       open the file
      CALL ZOPEN (HLUN, HIND, IVOL, PHNAME, F, T, T, IERR)
      IF (IERR.NE.0) THEN
         NC = JTRIM (PHNAME)
         WRITE (MSGTXT,1010) IERR, PHNAME(:NC)
         CALL MSGWRT (8)
         IF (IERR.NE.2) GO TO 995
         GO TO 10
         END IF
      IREC = 2
      CALL ZFIO ('READ', HLUN, HIND, IREC, IBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1020) IERR, IREC
         CALL MSGWRT (8)
         GO TO 90
         END IF
      J = 0
      DO 30 I = 1,256
         CALL ZHEX (IBUF(I), 8, HSTR)
         CALL H2CHR (4, 1, HBUF(I), ASTR)
         IF (JTRIM(ASTR).EQ.0) ASTR = ' '
         IF (MOD(I-1,2).EQ.0) THEN
            J = J + 1
            WRITE (MSGTXT,1025) I, IBUF(I), RBUF(I), HSTR, ASTR, DBUF(J)
         ELSE
            WRITE (MSGTXT,1025) I, IBUF(I), RBUF(I), HSTR, ASTR
            END IF
         CALL MSGWRT (5)
 30      CONTINUE
      MSGBUF = 'Re-write this record? (y or n)'
      CALL INQSTR (TTY, MSGBUF, 4, ASTR, IERR)
      IF ((ASTR(:1).EQ.'Y') .OR. (ASTR(:1).EQ.'y')) THEN
         CALL FILL (256, 0, IBUF)
         IBUF(1) = 2
         CALL ZFIO ('WRIT', HLUN, HIND, IREC, IBUF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1030) IERR, IREC
            CALL MSGWRT (8)
            END IF
         END IF
C                                       close data file and loop
 90   CALL ZCLOSE (HLUN, HIND, IERR)
      GO TO 10
C                                       Terminal error
 990  WRITE (MSGTXT,1990) IERR
      CALL MSGWRT (8)
C
 995  CALL ZCLOSE (TTYLUN, TTYIND, IERR)
      NLUSER = 1
      CALL ACOUNT (2)
C
 999  STOP
C-----------------------------------------------------------------------
 1010 FORMAT ('ERROR',I3,' OPENING ''',A,'''')
 1020 FORMAT ('ERROR',I3,' READING RECORD',I6)
 1025 FORMAT (I3,I13,1PE15.6,2X,A8,'  ''',A,'''',1PE15.6)
 1030 FORMAT ('ERROR',I3,' WRITING RECORD',I6)
 1990 FORMAT ('ERROR',I7,' IN TERMINAL IO')
      END
