      PROGRAM ADVCNT
C-----------------------------------------------------------------------
C! Finds max line length in help files
C# Utility
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Program to extract the maximum line length in help files.  Displays
C   all > 80, < 60
C      A logical or enviroment variable named MYDIR must be defined
C   before running ADVCNT.
C      The output will be written to a file named ADVCNT.OUT.
C-----------------------------------------------------------------------
      CHARACTER INLINE*100, OUTLIN*64, INFIL*48, OUTFIL*48, LFIL*48,
     *   SUBNAM*12
      INTEGER   IOERR, BUFFER(512), LUNI, LUNO, FINDI, FINDO, LUNL,
     *   FINDL, JTRIM, JT, J, JMAX, JL, INPMAX
      LOGICAL   ININP
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA LUNI, LUNO, LUNL /16, 17, 18/
C-----------------------------------------------------------------------
C                                       AIPS system start up stuff
      TSKNAM ='ADVCNT'
      NPOPS = 1
      MSGKIL = 32000
      MSGSUP = 32000
      CALL ZDCHIN (.FALSE., BUFFER)
      MSGKIL = 32000
      DEVTAB(LUNI) = 3
      DEVTAB(LUNO) = 3
      DEVTAB(LUNL) = 3
C                                       Get list of routines
      LFIL = 'MYDIR:HLPA.LIST'
      CALL ZTXOPN ('READ', LUNL, FINDL, LFIL, .FALSE., IOERR)
      IF (IOERR.NE.0) GO TO 999
C                                       Open output file
      OUTFIL = 'MYDIR:ADVCNT.OUT'
      CALL ZTXOPN ('WRIT', LUNO, FINDO, OUTFIL, .TRUE., IOERR)
      IF (IOERR.NE.0) GO TO 900
      WRITE (OUTLIN,1599)
      J = JTRIM (OUTLIN)
      CALL ZTXIO ('WRIT', LUNO, FINDO, OUTLIN(:J), IOERR)
      IF (IOERR.NE.0) THEN
          WRITE (6,1200) IOERR, 'WRITING OUTPUT', 'header'
          GO TO 900
          END IF
C                                       Begin looping over files
 100     CALL ZTXIO ('READ', LUNL, FINDL, INLINE, IOERR)
         IF (IOERR.NE.0) GO TO 900
         JT = JTRIM (INLINE)
         IF (INLINE.EQ.' ') GO TO 900
         IF (INLINE(JT-3:JT).EQ.'.HLP') JT = JT - 4
         SUBNAM = INLINE(:JT)
         IF ((SUBNAM.EQ.'VCODE') .OR. (SUBNAM.EQ.'STATIONS') .OR.
     *      (SUBNAM.EQ.'DOPROFIL')) THEN
            MSGTXT = 'WE ARE HERE'
            END IF
C                                       Form input names etc
         INFIL = 'HLPFIL:' // SUBNAM(:JT) // '.HLP'
C                                       Open input file
         CALL ZTXOPN ('QRED', LUNI, FINDI, INFIL, .FALSE., IOERR)
         IF (IOERR.NE.0) THEN
            MSGTXT = 'FILE WAS ' // SUBNAM(:JT)
            CALL MSGWRT (8)
            GO TO 100
            END IF
         JMAX = 0
         JL = 0
         INPMAX = 0
         ININP = .FALSE.
C                                       Digest file:
C                                       Read line loop
 200        CALL ZTXIO ('READ', LUNI, FINDI, INLINE, IOERR)
C                                       End of file?
            IF (IOERR.EQ.2) GO TO 600
C                                       Error?
            IF (IOERR.GT.0) GO TO 590
            J = JTRIM (INLINE)
            IF ((INLINE(:1).NE.';') .AND. (INPMAX.EQ.0)) ININP = .TRUE.
            IF (INLINE(:6).EQ.'------') ININP = .FALSE.
            IF (ININP) INPMAX = MAX (INPMAX, J)
            JMAX = MAX (J, JMAX)
            IF (J.GT.72) JL = JL + 1
            GO TO 200
C                                       Error - close file
 590     WRITE (6,1590) SUBNAM
C                                       End - close file
 600     CALL ZTXCLS (LUNI, FINDI, IOERR)
         IF ((IOERR.NE.0) .AND. (IOERR.NE.2)) GO TO 900
         WRITE (OUTLIN,1600) SUBNAM, INPMAX, JMAX, JL
         IF ((JMAX.NE.72) .OR. (INPMAX.NE.64)) THEN
            J = JTRIM (OUTLIN)
            CALL ZTXIO ('WRIT', LUNO, FINDO, OUTLIN(:J), IOERR)
            IF (IOERR.NE.0) THEN
               WRITE (6,1200) IOERR, 'WRITING OUTPUT', SUBNAM
               GO TO 900
               END IF
            END IF
C                                       Next file
         GO TO 100
C                                       Done - close files
 900  CALL ZTXCLS (LUNO, FINDO, IOERR)
      CALL ZTXCLS (LUNL, FINDL, IOERR)
 999  STOP
C-----------------------------------------------------------------------
 1200 FORMAT (' ERROR',I3,' ON ',A,1X,A)
 1590 FORMAT (' ERROR READING FILE ',A)
C1600 FORMAT (A,' MAX LENGTH',I4,5X,' # > 72',I7)
 1599 FORMAT ('HelpFile',8X,'Inp',3X,'Help',9x,'>72')
 1600 FORMAT (A,3X,I4,3X,I4,5X,I7.2)
      END
